/*
Navicat MySQL Data Transfer

Source Server         : mysql 3306
Source Server Version : 50505
Source Host           : localhost:3306
Source Database       : laravel-vuetify

Target Server Type    : MYSQL
Target Server Version : 50505
File Encoding         : 65001

Date: 2023-09-04 03:12:26
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for abonos
-- ----------------------------
DROP TABLE IF EXISTS `abonos`;
CREATE TABLE `abonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_cobrar_id` bigint(20) unsigned NOT NULL,
  `total_abono` float(9,2) DEFAULT NULL,
  `deuda_capturada` float(9,2) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `abonos_cuenta_cobrar_id` (`cuenta_cobrar_id`),
  CONSTRAINT `abonos_cuenta_cobrar_id` FOREIGN KEY (`cuenta_cobrar_id`) REFERENCES `cuentas_cobrars` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of abonos
-- ----------------------------

-- ----------------------------
-- Table structure for almacenes
-- ----------------------------
DROP TABLE IF EXISTS `almacenes`;
CREATE TABLE `almacenes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(500) NOT NULL,
  `sucursal_id` int(11) NOT NULL,
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `almacenes_sucursal_id` (`sucursal_id`),
  CONSTRAINT `almacenes_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of almacenes
-- ----------------------------

-- ----------------------------
-- Table structure for clientes
-- ----------------------------
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `folio` varchar(45) DEFAULT NULL,
  `rfc` varchar(45) DEFAULT NULL,
  `razonSocial` varchar(250) DEFAULT NULL,
  `celular` varchar(45) DEFAULT NULL,
  `email` text DEFAULT NULL,
  `expediente` text DEFAULT NULL,
  `autorizado_session` varchar(4) NOT NULL DEFAULT 'no',
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34263 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of clientes
-- ----------------------------
INSERT INTO `clientes` VALUES ('1', 'C-100001', '', 'MARCELA LOPEZ MAYO', '9932236296', '', '', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('2', 'C-100002', '', 'LINDA CRISTAL ROMERO PEREZ', '9932326687', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('3', 'C-100003', '', 'ROSA GARCIA RAMOS', '9371084990', '', '', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('4', 'C-100004', '', 'GLORIA ESTHER GONZALEZ GARCIA', '9932399304', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('5', 'C-100005', '', 'DANIELA GOCHICOA GRAMER', '9932951991', '', '4/agosto/16 masaje sensorelax y promocion de caviar mirena entor 12:00\r\n4/dic/17 dermapen ofelia entro 4:00\r\n27/ABRIL/18 INICIA TRATAMIENTO DE CARBOXITERAPIA PAGO 2,500\r\n1.- CARBOX   27/ABRIL/18 LUCY ENTRO 1:10\r\n2.- CARBOX   30/ABRIL/18 MARIANA ENTRO 4:50\r\n3.- CARBOX   2/MAYO/18 ANITA\r\n4.- CARBOX  4/MAYO/18 MARY ENTRO  1:05\r\n5.- CARBOX  7/MAYO/18 MARY ENTRO 1:10\r\n6.- CARBOX 9/MAYO/18 MARY ENTRO 1:25\r\n7.- CARBOX 11/MAYO/18 ANITA ENTRO 1:25\r\n8.- CARBOX  14/MAYO/18 REYNA  ENTRO 1:00\r\n9.- CARBOX  16/MAYO/18 MARIANA ENTRO 1:30\r\n10.- CARBOX  18/MAYO/18 MARY ENTRO 1:40\r\n11.- CARBOX  21/MAYO/18 MARY ENTRO  12:50\r\n12.- CARBOX  23/MAYO/18 MARY ENTRO 1:25\r\n13.- CARBOX  25/MAYO/18 MARY ENTRO 1:00\r\n14.- CARBOX  28/MAYO/18 MARY ENTRO 12:55\r\n15.- CARBOX   30/MAYO/18 MARY ENTRO 1:30\r\n16.- CARBOX   01/JUNIO/18 MARY ENTRO 1:00\r\n17.- CARBOX  4/JUNIO/18 MARY ENTRO 1:50\r\n18.- CARBOX  11/JUNIO/18 MARY ENTRO 12:10\r\n11/JUNIO/18 MDM FULL RELAX D CLIENTE FRECUENTE MARY\r\n19.- CARBOX  13/JUNIO/18 MARY ENTRO 1:30\r\n20.- CARBOX 15/JUNIO/18 SUSI ENTRO 1:30 \r\n21/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE OFELIA\r\n16/MARZO/19 PROM TRATAMIENTO FACIAL DETOX ANITA ENTRO 9:20\r\n2/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE MARY ENTRO 5:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('6', 'C-100006', '', 'ELIZABETH MARTINEZ SUAREZ', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('7', 'C-100007', '', 'VERONICA IZQUIERDO CORREA', '9363641690', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('8', 'C-100008', '', 'BERNARDO PEREZ PEREZ', '5513312139', '', '06/julio/17 masaje express rosy entro 2:47 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('9', 'C-100009', '', 'CLAUDIA FLORES NAVARRETE', '5513312139', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('10', 'C-100010', '', 'HEIDI QUEVEDO AREVALO', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('11', 'C-100011', '', 'GLADYS MERCEDES AREVALO', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('12', 'C-100012', '', 'DIANA CARRERA JAVIER', '9931551519', '', '30/agosto/18 limpieza facial 2x600 susy entro 7:00 (mega)\r\n31/MAYO/2022 MASAJE DESCONTRACTURANTE MONICA ENTRO 17:00 MEGA', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('13', 'C-100013', '', 'JUAN RAMON VELAZQUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('14', 'C-100014', '', 'CARLOS MANRIQUE MONTA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('15', 'C-100015', '', 'GUADALUPE BORBOLLA ECHEVERRIA', '9933156899', '', 'depilacion de bigote $180.00 c/s\r\n1ª sesion 1/julio/09 bigote 30 ms 18 j lucy \r\n2ª sesion 20/agosto/09 bigote autom. 20 j lucy \r\n3ª sesion 29/sept/09 autom. 22 j lucy \r\n4a sesion 4/nov/09 autom. 22 j rosy \r\n5a sesion 14/dic/09 bigote autom. 23 j lucy \r\n6a sesion 14/ene/10 bigote autom. 23 j rosy\r\n7a sesion 16/feb/10 bigote autom. 23 j rosy \r\n8ª sesion 22/abril/10 bigote autom. 23 j lucy \r\n\r\n\r\n\r\ndepilacion de axila $360.00\r\n1ª sesion 20/agosto/09 axila autom. 20 j lucy \r\n2ª sesion 30/sept/09 axila autom. 24 j lucy \r\n3ª sesion 4/nov/09 axila autom. 24 j rosy\r\n4ª sesion 14/dic/09 axila autom. 26 j lucy \r\n5ª sesion 14/ene/10 axila autom. 26 j rosy  \r\n6ª sesion 16/feb/10 axila autom. 26 j rosy\r\n7ª sesion 22/abril/10 axila autom. 26 j lucy \r\n8ª sesion 2/julio/10 axila autom. 26 j mary \r\n\r\n2/julio/10 retoque de bigote autom. 23 j mary\r\n4/nov/10 retoque de bigote autom. 18 j lucy\r\n\r\n02/marzo/2001 citoquinas pancha\r\n7/feb/08 promocion dermorelax marcela entro 3:30\r\n16/oct/08 promocion colageno julia entro 3:15 \r\n1/julio/09 limpieza facial araceli entro 3:00 \r\n29/sept/09 limpieza facial 2 x 1 reyna entro 3:35 \r\n14/dic/09 promocion flash beaute sara entro 3:50 \r\n22/abril/10 promocion 3 geles sara entro 3:30\r\n2/julio/10 limpieza de acne indira entro 3:10\r\n4/nov/10 limpieza de acne araceli entro 3:35\r\n3/feb/11 retoque depilacion de bigote autom. 20 j, axila autom. 27 j lucy\r\n3/feb/11 limpieza de acne gladys entro 3:24 se le puso gelula amarilla porque la masc. de colageno \r\nde lendan y jabotiere le ardio\r\n2/junio/11 retoque de bigote autom. 20 j, axila autom. 27 j lucy\r\n2/junio/11 mdm, limpieza de acne susy entro 3:15 se desmaquilla con leche  desmquillante,\r\nno se tonifica ni se le aplica brosh ni peeling nada mas vapor y extraccion,ni mascarilla.\r\ndepilacion de patillas $360.00 c/s\r\n8/julio/14 1ra. patilla aut-10j lucy entro 5:10\r\n8/agosto/14 2da. patilla aut-12j lucy entro 4:00\r\n8/sep/14 3ra. patilla autom. 13 j reyna entro 4:00\r\n19/nov/14 4ta. patillas autom. 15 j reyna\r\n25/marzo/15 patilla autom 15 bigote y mejilla lucy\r\n 12/mayo/15 axila aut-20j y patilla aut-15j lucy\r\n3/agos/15 axila y patilla aut-20j sra bego\r\n3/sept/15 axila y patilla aut-22j lucy', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('16', 'C-100016', '', 'MARIA GUADALUPE SANCHEZ SILVA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('17', 'C-100017', '', 'IRENE ALPUCHE GARCIA', '9371280850', '', '19/agosto/17 masaje sensorelax lizvet entro 2:25\r\n13/MARZO/18 DELINEADO DE CEJAS Y PÁRPADO SUPERIOR OFELIA ENTRO 9:25\r\n19/ABRIL/18 RIZADO DE PESTAÑAS  MARIANA ENTRO 5:00\r\n17/ENERO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE JOHANY ENTRO 3:00\r\n25/MAYO/2022 MASAJE FULL RELAX 2 X 600 SUSY ENTRO 11:00\r\n9/SEPT/2022 MASAJE FULL RELAX 2 X 600 MARIANA ENTRO 9:15', 'no', 'activo', '2021-12-07 00:49:45', '2022-09-08 17:25:51', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('18', 'C-100018', '', 'ANA LUISA JUAREZ FLORES', '5516093035', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('19', 'C-100019', '', 'EYRA DE JESUS PEREYRA HERNANDEZ', '9933185827', '', '4/ENERO/2023 INICIA DEPILACIONLASER  BRASILEÑA 30MS 10J/100MS 10J LUCY ENTRO 3:25\r\n4/FEBRERO/2023 2DA BRASILEÑA AUT 10J/30MS 10J JHOANY ENTRO 9:00\r\n4/MARZO/2023 3RA BRASILEÑO  MARIANA ENTRO 8:05\r\n29/MAYO/2023 4TA BRASILEÑO 30MS 11J JHOANY ENTRO 2:30\r\n30/JUNIO/2023 5TA BRASILEÑO TOTAL 30MS 11J JHOANY', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-30 18:53:46', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('20', 'C-100020', '', 'MONICA RAMOS NAVA', '9932341243', 'monica.ramos@pemex.com', 'ipl $1000.00 c/s\r\n1.-3/feb/11 ovalo facial prog. ii int. 3 mary lazaro entro 4:40 \r\n27/julio/11 limpieza facial 2 x 1 araceli entro 6:10\r\n24/agosto/11 limpieza facial 2x1 aracely 4:55\r\n18/ene/12 mdm drenaje linfatico mariana entro 3:15\r\n23/feb/12 promocion 3 geles karina entro 5:05\r\n3/abril/12 promocion revitalizante aracely entro 2:55\r\n14/06/12 lim. facial 2x1 atendio graciela entro 3:50 mega \r\n3/oct/12 limpieza facial 2 x 1 reyna entro 3:00\r\n30/11/12 prom. del mes atendio joany entro 3:50 mega\r\n23/ene/13 limpieza facial 2 x 1 reyna entro 12:00\r\n03/06/13 micro brenda entro 6.00 mega\r\n17/junio/13 micro rosy entro 2:20\r\n29/junio/13 micro graciela\r\n16/oct/13 promocion the verde ana entro 2:15\r\n13/nov/13 limpiesa facial 2 x1 nelly entro 2:10\r\n7/mayo/14 limpieza capilar nelli entro 2:25\r\n7/mayo/14 mdm full relax mirena entro 3:30\r\n13/nov/14 limpieza facial con amp. desincrustante brenda entro 2:10\r\n03/01/15 serealizo la promocion del mes atendio susy cristal entro alas 6.00\r\n4/sept/15 promocion equilibrante del ph lucy entro 4:10\r\n27/sep/15 ´promocion equilibrante del ph atendio eva entro 3:40 suc cristal\r\n5/oct/15 mdm full relax graciela entro 3:15\r\n12/oct/15 promocion equilibrante del ph mariana entro 2:10\r\n17-10-15 promo del mes cristal martha 3-40 \r\n25/octubre/15 prom. del mes trat. reafirmante eva entro 6:20 (mega)\r\n15/dic/15 promocion reafirmante modeladora reyna entro 3:10\r\n27/diciembre/15 prom. del mes rosy entro 1:05 (mega)\r\n18/ene/16 promocion desintoxicante charito entro 2:10\r\n01/febrero/16 prom. del mes rosy entro 6:00 (mega\r\n20/feb/16 promocion roll & lift mary lazaro entro 10:15\r\n4/marzo/16 promocion hydratante mariana entro 2:30\r\n1/abril/16 promocion  luxury (chocolate) carmen entro 3:00\r\n30/mayo/16 limpieza capilar anita/mariana entro 3:15\r\n18/ene/17 depilacion de cejas ofelia entro 12:30\r\n09/abril/17 prom. del mes trat. térmico lizbeth entro 3:55 (mega)\r\n12/abril/17 limpieza facial 2x600 lizbeth entro 3:00 (mega)\r\n19/mayo/17 mdm full relax mary L entro 3:10\r\n16/MAYO/19 MDM DRENAJE LINFATICO ANITA ENTRO  3.00\r\n13/sep/19 limpieza facial profunda janeth entro 3:15 mega\r\n21/DICIEMBRE/19 LIMPIEZA FACIAL PROFUNDA JANETH ENTRO 7:00 MEGA\r\n17/MARZO/2022 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('21', 'C-100021', '', 'NELLI MARTINEZ GONZALEZ', '9933112022', '', '28/AGOSTO/2021 MASAJE CHAMPI MONICA ENTRO 12:32 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('22', 'C-100022', '', 'LUCIA GARCIA DE MANDOWALL', '9931307175', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('23', 'C-100023', '', 'JUANA DE LA CRUZ TAPIA', '9931600419', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('24', 'C-100024', '', 'XIOMARA BARRERA ROSALES', '9933939765', '', '8/sept/16 mdm full relax reyna entro 11:10\r\ninicia depilacion laser de axila $360, pezon $25 y pantorrilla $750.00 cada sesion\r\n17/nov/16 1era, pantorrilla, pezón y axila aut- 10j 0\r\n26/nov/16 promocion  oxigenante mary lazaro entro 10.10\r\nINICIA NEX LIFT $8000.00 abono $4000.00 resta $4000.00 \r\n1.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI I, MASCARILLA PORCELANA 5/dic/16 mariana entro 4:10\r\n2.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI I, MASCARILLA PORCELANA  6/dic/16 reyna   entro 11.05\r\n3.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI I, MASCARILLA PORCELANA 7/dic/16 mariana entro 11:00\r\n4.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI I, MASCARILLA PORCELANA 8/dic/16 mariana entro 11:00\r\n5.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI I, MASCARILLA PORCELANA  9/dic/16 mariana entro 1:10\r\n6.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI 3, MASCARILLA MODELADORA 12/dic/16 reyna entro 11:00 termino de pagar el tratamiento.\r\n7.-LIMPIAR, TONICO, OXIGENO, LINFÁTICO , NEW LIFT, LIFTING #2, BEATI 3, MASCARILLA MODELADORA 13/dic/16 mariana entro 11:00\r\n8.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI 3, MASCARILLA MODELADORA 14/dic/16 mariana entro 10:55\r\n9.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI 3, MASCARILLA MODELADORA  15/dic/16 mariana entro 1:00\r\n10.-LIMPIAR, TONICO, OXIGENO, LINFATICO , NEW LIFT, LIFTING #2, BEATI 3,MASCARILLA  MODELADORA  16/dic/16 mariana entro 11.00\r\ntermino el tratameinto.\r\n19/dic/16 depilación de pantorrilla, pezón y axila aut-10j lucy\r\n23/ene/17 pantorrilla, pezón y axila aut-11j lucy\r\n1/marzo/17 pantorrilla, pezón y axila aut-12j lucy\r\n28/marzo/17 5ta. pantorrilla autom. 13 j, axila, pezón autom. 12 j mary entro 12:15\r\n12/mayo/17 6ta. pantorrilla autom. 13 j, axila autom. 13 , pezón autom. 13 j lucy\r\nbigote $180.00 c/s\r\n12/mayo/17 1ra, bigote 30 ms 10 j lucy\r\n8/junio/17 mdm full relax cliente frecuente mariana entro 11:10\r\n27/junio/17 2da. bigote 30ms 11j,pantorrilla aut-14 j, axila aut-14 j, pezón aut-14j mary lazaro\r\n15/sept/17 bigote 30ms 11j pantorrilla aut-14 j, pezón aut-14 j, axila aut-14 lucy\r\n30/oct/17 bigote 30 ms 12 j, pantorrilla autom. 16 j, axila autom. 16 j, pezón autom. 16 j ofelia\r\n26/12/17 MDM FILL RELAX CLIENTE FRECUENTE LUCY ENTRO 2:00\r\n23/ENERO/18 5TA. BIGOTE AUTOM. 14 J MARY LAZARO\r\n23/ENERO/18 10° PANTORRILLA, AXILA, PEZÓN AUTOM. 14 J MARY LAZARO\r\n10/MARZO/18 BIGOTE AUT 15 MARY\r\n15/JUNIO/18 LASER DE PANTORRILLA, AXILA, PEZÓN, BIGOTE AUT 15   OFELIA\r\n18/JULIO/18 LASER DE BIGOTE AUT 15 J LUCY\r\n28/AGOSTO/18 MDM FULL RELAX   LUPITA  ENTRO 12:00\r\n28/AGOSTO/18 LASER DE BIGOTE AUT 18J Y AXILA AUT 19 J  OFELIA\r\n5/DIC/18 LASER DE BIGOTE AUT 18 J  Y PANTORRILLAS 15 J LUCY\r\n1/FEB/19 LASER DE BIKINI AUT 10 J Y BIGOTE AUT 15 J OFELIA\r\n9/ABRIL/19 LASER DE BIGOTE AUT 15 J PANTORRILLAS AUT 15 J AXILA AUT 15 PEZON AUT 15 J REYNA\r\n11/MAYO/19 LASER DE BIGOTE AUT 16 J OFELIA\r\n30/AGOSTO/19 LASER DE BIGOTE AUT 16 J BIKINI AUT 10 J PEZON AUT 10 J AXILA AUT 12J  LUCY \r\n5/NOVIEMBRE/19 LASER DE BIGOTE AUT 16 J  MARY LAZARO\r\n7/DICIEMBRE/19 LASER DE BIGOTE AUT 14 J REYNA\r\n19/FEBRERO/20 LASER DE BIKINI, Y BIGOTE  AUT 12 J MARY LAZARO\r\n23/MARZO/2022 RETOQUE BIGOTE 30MS 17 BIKIMI 30MS 10J Y PEZON AUT 15 MARY LAZARO', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('25', 'C-100025', '', 'ELIDE CAMPOS JIMENEZ', '9371332976/9373723144', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('26', 'C-100026', '', 'ESMERALDA GARCIA DE LA CRUZ', '9371269684', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('27', 'C-100027', '', 'JULIAN VILLEGAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('28', 'C-100028', '', 'JUAN ROSADO RAMON', '9931671025', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('29', 'C-100029', '', 'ROSALINDA ALVAREZ SANCHEZ', '9933112875', '', '2/feb/11 promocion trat. de seda graciela entro 7:00 sucursal \r\ncon lifting de parpados consuelo\r\n28/11/03 prom. trat. hydartante con lifting de parpados marcela\r\n12/12/03 promocion vitamina c lucy\r\n28/01/04 prom. trat. relajante e hidratante rosy\r\n04/03/04 promocion anti-arrugas mary\r\n19/04/04 facial completo lucy\r\n28/04/04 promocion botanico 4 f lucy\r\n13/07/04 promocion termico consuelo\r\n02/12/04 promocion vitamina c bego\r\n22/01/05 promocion relajante e hidratante mary\r\n23/04/05 promocion botanico 4 f bego\r\n14/07/05 promocion termico mary\r\n21/oct/05 promocion modeladora marcela\r\n13/dic/05 promocion vitamina c lucy\r\n24/mayo/06 promocion papaya y piña mary lazaro\r\n29/junio/06 revitase rosy\r\n20/sept/06 limpieza facial 2 x 1 mary\r\n29/nov/06 promocion antiarrugas bego entro 5:50\r\n11/dic/06 promocion nutriente e hidratante lucy entro 6:30 \r\n12/dic/06 exfoliacion de cuerpo con mascarilla de chocolate mary lazaro entro 4:50\r\n19/feb/07 promocion ginseng rosy entro 5:00\r\n28/feb/07 promocion ginseng marcela entro 5:20\r\n24/abril/07 promocion botanico mary lazaro entro 4:45\r\n28/mayo/07 promocion antiarrugas y reafirmante bety\r\n29/mayo/07 trat. de café marcela entro 5:20\r\n2/julio/07 promocion de colageno lucy\r\n09/agosto/07 promocion regenerador antioxidante lucy entro 5:50\r\n16/oct/07 promocion modeladora bety entro 5:15\r\n15/nov/07 trat. de café bety entro 4:50\r\n11/feb/08 promocion dermorelax bety entro 5:15 \r\n31/marzo/08 promocion criogenico con amp. soothing extrac mary lazaro entro 5:05 \r\n13/mayo/08 micro mary lazaro entro 5:30 \r\n15/mayo/08 promocion 3 geles bety entro 5:45 \r\n17/mayo/08 promocion 3 geles lucy entro 12:45\r\n30/junio/08 promocion catiodermia mary lazaro entro 5:30 \r\n4/sept/08 promocion modeladora marcela entro 5:00 \r\n3/dic/08 facial completo mary entro 5:00 \r\n*ojo* todo el producto tiene que ser tópico. no usar nada de corrientes.\r\n15/ene/09 promocion jalea real bego entro 5:20 \r\n18/feb/09 promocion per collagen mary entro 5:15 \r\n12/marzo/09 promocion spa therapy perla bego entro 6:05 \r\nllevo serum nutritivo con aceites incas.\r\n1/abril/09 promocion spa therapy oro rosy entro 5:20\r\n13/mayo/09 promocion trat parp y labios bego\r\n2/junio/09 promocion white line rosy entro 5:15 \r\n12/junio/09 promocion white line reyna entro 5:45 \r\n20/agosto/09 promocion revitalizante karina entro 5:45\r\n15/oct/09 promocion hidronutritivo reyna entro 6:30 \r\n22/oct/09 trat. facial especial begoña mary lazaro entro 5:10 \r\n12/julio/16 facial vitamina c natura bisse sra. bego entro 5:00\r\n11/nov/09 promocion reestructurante bego entro 5:55\r\n26/nov/09 exfoliacion corporal sara entro 5:40 \r\n12/ene/10 promocion vinoterapia karina entro 5:00\r\n16/feb/10 promocion estimulante de endorfinas mary lazaro entro 6:00\r\n25/feb/10 promocion estimulante de endorfinas reyna entro 5:00\r\n13/abril/10 promocion 3 geles sara entro 6:00 \r\n11/mayo/10 exfoliacion corporal 2 x 1 sara entro 5:30 \r\n12/mayo/10 skinlight completo bego entro 5:30\r\n21/junio/10 promocion botanico 4 f mary lazaro entro 6:10\r\n22/junio/10 exfoliacion de cuerpo 2 x 1 mary lazaro entro 5:10 \r\n7/julio/10 promocion relajante e hidratante lupita entro 6:10\r\n10/julio/10 exfoliacion de cuerpo mary lazaro \r\n4/agosto/10 promocion antiarrugas mariana entro 6:10\r\n llevo crema facial jalea real, crema chauffant, crema relajante equilibrium\r\n18/agosto/10 promocion antiarrugas lupita entro 5:35\r\n24/agosto/10 exfoliacion corporal 2 x 1 indira entro 5:15\r\n29/oct/10 promocion efecto botox lupita entro 6:05 (sucursal) \r\n13/ene/11 promocion porcelana mary lazaro entro 6:06 \r\nllevo 2 dabalash y crema facial de jalea real\r\n17/marzo/11 promocion elastina  sara  entro alas 5:00\r\n6/junio/11 mdm, promocion estimulante de endorfinas karina entro 4:00\r\n11/julio/11 rizado de pestañas reyna entro 4:35 salio 5:50 llevo crema nutritiva de frutos incas \r\n8/agosto/11 exfoleacion corporal, mdm sara entro 4:30\r\n20/08/11 tratamiento piel de seda atendio graciela entro 7:00 salio (suc mega) \r\n09/09/11 tratamiento azteca atendio indira entro 7.20 pm salio (suc mega)\r\n21/sep/11 so-delicatese llevo 12 gelula amarillas mariana entro 5:15\r\n18/oct/11 radiofrecuencia se llevo el serum reconciliador de so de licate y dabalash reyna entro 5:4\r\n04/nov/11 promocion germen de trigo sara entro 4:50\r\n12/dic/11 masaje drenaje linfatico araceli entro 6:30\r\n13/ene/12 llevo spot diminish, dabalash, 6 gelulas amarillas\r\n16/01/12 trat revitalizante atendio deyanira entro 6:30 (mega) \r\n7/feb/12 promocion 3 geles reyna entro 6:05\r\n24/abril/12 promocion revitalizante aracely entro 4:40\r\n24/abril/12 exfoliacion de cuerpo vitamina c aracely\r\n5/junio/12 exfoliacion de cuerpo 2 x 1, promocion reafirmante reyna entro 5:05\r\n17/06/12 serealizo trat reafirmante atendio deya entro 2:55 (mega)\r\n9/agosto/12 se realizo mdm y promocion gladys entro 9:35\r\n24/agosto/12 promocion hidratante y reafirmante araceli entro 5:50\r\n25/sept/12 promocion de agave reyna entro 5:00\r\n28/sept/12 mdm diana entro 5:45 llevo activador de celulas madres y gelulas amarillas\r\n23/oct/12 promocion reafirmante de cuello lucy entro 4:35 llevo crema piel seca y leche desm. de\r\njalea real royal jelly\r\n17/dic/12 promocion de oro araceli entro 4:45\r\n10/ene/13 promocion lifting de parpados lucy entro 5:00\r\n19/feb/13 promocion catiodermia lucy entro 5:15\r\n28/feb/13 promocion catiodermia lucy entro 5:40\r\n18/marzo/13 promocion royal jelly mariana entro 5:55\r\n25/abril/13 mdm full relax, promocion porcelana mariana entro 5:05\r\n14/mayo/13 promocion relajante e hidratante yusiria entro 6:00\r\n20/mayo/13 masaje de aromas reyna entro 5:40\r\n11/junio/13 promocion coco y mango bego entro 5:30\r\n4/julio/13 promocion colageno y elastina reyna entro 4:10\r\n5/agosto/13 drenaje linfatico, promocion oxigenante mariana entro 5:30\r\n6/agosto/13 drenaje linfatico rosy entro 4:25\r\n7/agosto/13 drenaje linfatico mariana\r\n9/agosto/13 drenaje linfatico yusiria entro 5:30\r\n21/agosto/13 drenaje linfatico en cuerpo y rostro reyna entro 4:30 llevo amp. acido hialuronico\r\n2/sept/13 skinlight completo lucy entro 5:30\r\n9/sept/13 skinlight completo rosy entro 4:45\r\n9/oct/13 promocion the verde bego entro 5:00 llevo peptonas\r\n10/oct/13 mdm cliente frecuente reyna entro 6:00\r\n12/nov/13 promocion intensivo antiestres reyna entro 5:00\r\n18/nov/13 radiofrecuencia mariana entro 5:00\r\n19/dic/13 promocion de oro con amp. beaute 1 yusiria entro 5:10\r\n9/ene/14 promocion desintoxicante yusiria entro 5:40\r\n11/feb/14 promocion eternamente joven yusiria entro 4:50\r\n17/feb/14 limpieza facial crioterapia 15 min. despues del masaje linfatico $800.00 lucy entro 4:35\r\n17/feb/14 mdm cliente frecuente lucy\r\n28/feb/14 promocion eternamente joven lucy entro 5:00\r\n28/feb/14 trat. de manos carmen \r\n7/mayo/14 promocion facial hidratante bego entro 5:45\r\n12/junio/14 facial completo bego entro 4:50\r\ntratamiento de celulitis pago 10 sesiones $4,000.00\r\n1.-cavitacion 60 m, masaje 45 m 16/junio/14 yusiria entro 5:00\r\n2.-lumicell 17/junio/14 yusiria entro 4:55\r\n3.-masaje, g-5 18/junio/14 yusiria entro 5:00\r\n4.-lumicell 19/junio/14 yusiria entro 5:00\r\n5.-masaje, g-5 20/junio/14 yusiria entro 4:45\r\n6.-lumicell 23/junio/14 yusiria entro 4:50\r\n7.- masaje , g-5 24/junio/14 yusiria entro 5:10\r\n8.-lumicell 25/junio/14 yusiria entro 4:20\r\n9.-masaje 65m 26/junio/14 yusiria entro 5:05\r\n10.- lumicell 30/junio/14 yusiria entro 5:15\r\ntermino tratamiento.\r\ninicia tratamiento $2500.00pagado\r\n1.- termoslin 30/junio/14 yusiria entro 5:30\r\n2.- capsula 01/julio/14 yusiria entro 5.00\r\n3.-termoslin 02/julio/14 yusiria entro 4:25\r\n2/julio/14 masaje reductivo yusiria\r\n4.-capsula 03/julio/14 yusiria entro 4:40\r\n03/julio/14 masaje reductivo yusiria entro 4:40\r\n5.-termoslin 4/julio/14 yusiria entro 4:30\r\n4/julio/14 masaje reductivo 45 m yusiria\r\npago $2,400.00 de tres sesiones mas de masaje reductivo y termoslin \r\n1.-masaje 45 m, termoslin 7/julio/14 yusiria entro 5:00\r\n2.-masaje 45 m, termoslin 8/julio/14 yusiria entro 4:15\r\n3.-masaje 45 m, termoslin 9/julio/14 yusiria entro 4:25\r\n15/julio/14 facial diamond life infusion bego entro 5:20\r\n25/julio/14 facial diamond life infusion lucy entro 5:05\r\n9/agosto/14 facial diamond life infusion lucy entro 11:30\r\n2/sep/14 promocion tratamiento facial azteca ofelia entro 5:10\r\n10/oct/14 promocion trat. smoothie yusiria entro 5:30\r\n5/nov/14 facial completo mirena entro 5:15\r\n3/dic/14 skinlight lucy entro 5:00 llevo crema so-delicate piel seca\r\n13/enero/15 radio facial mariana entro 5:15\r\n28/enero/15 promocion trat desintoxicante y oxigenante mariana entro 5:40\r\n13/marzo/15 desafio antiedad mariana entro 5.22\r\n16/marzo/15 promocion tratamiento anti-edad reyna entro 4:20\r\n24/marzo/15 promocion tratamiento anti-edad maribel entro 5:50\r\n7/mayo/15 promocion tratamiento de catiodermia reyna entro 6:00\r\n16/mayo/15 promocion catiodermia susy entro 1:15\r\n23/mayo/15 radio facial  mariana entro 9:00\r\n23/mayo/15 mdm drenaje linfatico maribel entro 10.00\r\ninicia masaje reductivo 5 sesiones $1500.00 pagado\r\n1.-carbo, masaje 45m25/mayo/15 eva entro 6:00\r\n2.-masaje 45m 26/mayo/15 eva entro 5:20\r\n3.-carbo, masaje 45m 27/mayo/15 eva entro 5:30\r\n4.-masaje 45m 28/mayo/15eva entro 5:45\r\n5.-carbo, masaje 45m 01/jun/15 eva entro 5:40\r\n4/junio/15 facial retinol de atache lucy entro 6:00\r\n17/junio/15 promocion trat. antioxidante susy entro 4.40\r\n17/julio/15 radio facial lucy entro 5:05\r\n11/agosto/15 promocion chocoterapia graciela entro 5:15\r\n26/sept/15 promocion equilibrante de ph con amp. de colageno ofelia entro 10:00\r\n26/sept/15 llevo serum y crema so-delicate \r\n30/oct/15 timexpert lift mariana entro 4:45\r\n12/nov/15 llevo serum so-delicate\r\n25/nov/15 radio facial lucy entro 5:20\r\n11/ene/16 promocion desintoxicante sra. bego llevo serum se so delicate\r\n22/ene/16 promocion desintoxicante lucy entro 6:00\r\n27/abril/16 promocion trat luxury maria entr 6:00\r\n25/mayo/16 llevo cuidado reconciliador facial piel seca so delicate, serum reconciliador facial  so delicate \r\n27/junio/16 promocion de elastina lucy entro 5:55\r\n8/julio/16 promocion de colageno lucy entro 5:10\r\n8/julio/16 llevo dabalas y concentrado de algas de bolsas y ojeras natura bisse\r\n12/julio/16 facial vitamina c de natura bisse sra. bego\r\n18/julio/16 facial completo sra. bego entro 4:40\r\n19/julio/16 rizado de pestaña mirena entro 4:30\r\n19/julio/16 llevo concentrado de algas de ojos natura bisse\r\n6/agosto/16 facial completo rosy entro 10:25\r\n10/nov/16 promocion oxigenante reyna entro 5:45\r\n20/ene/17 promocion desintoxicante  anita entro 5:45\r\n29/marzo/17 promocion estimulante de colageno con luz leds carmen entro 5:45\r\n5/junio/17 promocion antioxidante charito entro 6:00\r\n27/julio/17 facial completo mary lazaor entor 1:05 \r\n3/oct/17 promocion reafirmante bego entro 5:40 llevo elixir absoluto de nutrición timexpert rides, aceite rosa mosqueta de ceutical nb\r\n17/nov/17 promocion termico humectante mary lazaro entro 5:00\r\n21/enero/18 prom. del mes trat. oxigenante susy entro 4:05 (mega)\r\n15/FEB/18 FACIAL COMPLETO  CANDY ENTRO 4:55\r\n22/MARZO/18  PTOM TRATAMIENTO DE CATIODERMIA LUCY ENTRO 5:50\r\n15/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD LUCY\r\n5/JULIO/18 FACIAL HYDRACURE REYNA ENTRO 5:15\r\n5/JULIO/18 DABALASH Y SO-DELICATE PIEL SECA\r\n7/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE SRA BEGO\r\n27/SEP/18 EXFOLIACIÓN DE CUERPO  LUPITA ENTRO 4:50\r\n16/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA LUPITA ENTRO 5:15\r\n1/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION SRA BEGO\r\n21/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION ANITA ENTRO 5:40\r\n20/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLA LUCY ENTRO 4:50\r\n17/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K OFELIA ENTRO 4:15\r\nLLEVO CREMA X-CEL TIMEXPERT RIDES ARRUGAS\r\n27/MAYO/2020 LLEVO CREMA ROYAL JELLY EXTREME, CREMA SUPREMA TIMEXPERT LIFT IN\r\n10/MAYO/2022 TRATAMIENTO FACIAL DIAMOND LIFE INFUSION MARIANA ENTRO 10:00\r\n25/JULIO/2022 TRATAMIENTO FACIAL DIAMOND WHITE OFELIA ENTRO 11:00\r\n6/DICIEMBRE/2022 TRATAMIENTO FACIAL DIAMNOND WHITE MARY LAZARO ENTRO 9:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-02 14:51:59', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('30', 'C-100030', '', 'MIRALDELLI CALCANEO PAZ', '9931160923', '', '17/10/13 limp facial nelly mega 5:00\r\n16/07/14 lim facial 2x1 carmen mega 10:10\r\n18/dic/14 promocion del mes trat. global nelly entro 4:08 (mega)\r\n24/abril/15 mdm full relax cliente frecuente martha entro 10:06 (mega)\r\n05/mayo/15 limpieza facial 2x1 candy entro 5:27 (mega)\r\n08/DICIEMBRE/2015 LIMPIEZA FACIAL CHARITO ENTRO 3:05 (MEGA)\r\n13/agosto/16 limpieza facial 2x600 lizbeth entro 2:05 (mega)\r\n03/noviembre/16 limpieza facial 2x500 susy entro 7:05 (mega).\r\n12/enero/17 limpieza facial maria entro 4:15 (mega)\r\n22/junio/17 limpieza facial 2x600 rosy entro 2:00 (mega)\r\n21/julio/17 limpieza facial 2x600 candy entro 2:00 (mega)\r\n11/octubre/17 limpieza facial 2x600 rosy entro 1:05 (mega)\r\n27/diciembre/18 limpieza facial 2x600 charito entro 7:15 (mega)\r\n11/julio/19 limpieza facial 2x600 rosy entro 12:00 mega\r\n3/ENERO/20 LIMPIEZA FACIAL 2X600 MONI ENTRO 2:08 MEGA\r\n03/MAYO/2023 DUO LIMPIEZA FACIAL BASICA MONICA ENTRO 10:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-03 10:24:20', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('31', 'C-100031', '', 'ALFONSO RAMIREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('32', 'C-100032', '', 'MARIA EUGENIA DOMINGUEZ VALENCIA', '9932220419', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('33', 'C-100033', '', 'YOLANDA MADRIGAL DE LA CRUZ', '9141230679', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('34', 'C-100034', '', 'MARITZA DE LOS ANGELES MORALES HERNADEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('35', 'C-100035', '', 'LORENA LOPEZ MARTINEZ', '7821076970', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('36', 'C-100036', '', 'ROSA MARIA SANCHEZ DE ALVAREZ', '', '', ' 2/feb/11 promocion trat. de seda susy entro 7:00 (sucursal) \r\n17/marzo/11 promocion trat de elastina sara entro als 5:00\r\n13/oct/11 limpieza facial rocio entro 2:25\r\n04/nov/11 promocion germen de trigo aracely entro 4:50\r\n12/dic/11 promocion velo de colageno brenda entro 6:25\r\n7/feb/12 promocion 3 geles rosy entro 6:00\r\n24/abril/12 promocion revitalizante gladys entro 12:10\r\n5/junio/12 promocion reafirmante karina entro 5:10\r\n24/agosto/12 promocion hidratante y reafirmante graciela entro 5:50\r\n17/dic/12 promocion de oro sara entro 4:45\r\n10/ene/13 promocion lifting de parpados ofe entro 5:00\r\n19/feb/13 promocion catiodermia yusiria entro 5:15\r\n28/feb/13 promocion catiodermia reyna entro 5:40\r\n25/abril/13 promocion porcelana martha entro 5:05\r\n14/mayo/13 promocion relajante e hidratante reyna entro 6:00\r\n20/mayo/13 promocion relajante e hidratante ana entro 5:45\r\n11/junio/13 promocion coco y mango ana entro 5:30\r\n5/agosto/13 promocion oxigenante reyna entro 5:30\r\n21/agosto/13 promocion oxigenante graciela entro 4:30\r\n2/sept/13 promocion lifting antiarrugas rosy entro 5:30\r\n9/oct/13 promocion the verde ana entro 5:10\r\n10/oct/13 mdm cliente frecuente mirena entro 6:00\r\n18/nov/13 promocion intensivo antiestres carolina entro 5:00\r\n19/dic/13 promocion de oro susy entro 5:10\r\n11/feb/14 promocion eternamente joven nelli entro 4:50\r\n17/feb/14 promocion eternamente joven reyna entro 4:35\r\n17/feb/14 mdm cliente frecuente reyna\r\n7/mayo/14 promocion facial hidratante graciela entro 5:45\r\n16/junio/14 promocion antioxidante nelli entro 5:00\r\n20/junio/14 mdm full relax nelli entro 4:45\r\n8/julio/14 promocion tratamiento de colageno graciela entro 4:20\r\n2/sep/14 promocion tratamiento facial azteca carmen entro 5:00\r\n10/oct/14 promocion trat. smoothie mirena 5:30\r\n5/nov/14 promocion antiedad humectante nutritivo ana entro 5:15\r\n8/nov/14 delineado de cejas, parpado superior, inferior, se le dio $300.00 pesos a ofelia\r\n3/dic/14 promocion trat. global antiedad (humectante , nutritivo y reafirmante) ana entro 5:00\r\n13/enero/15 promocion trat desintoxicante y oxigenante \r\n28/enero/15 promocion trat desintoxicante y oxidante carmen entro 5:45\r\n13/marzo/15 promocion tratamiento anti-edad candy entro 5:25\r\n24/marzo/15 promoción tratamiento anti-edad carmen entro 5.50\r\n7/mayo/15 promocion tratamiento de catiodermia eva entro 6:00\r\n16/mayo/15 promocion catiodermia carmen entro 1:00\r\n4/mayo/15 promocion trat antioxidante reyna entro 6:00\r\n17/junio/15 promocion tratamiento antioxidante eva entro 5:40\r\n17/julio/15 promocion trat de cuello eva entro 5:0\r\n11/agosto/15 promocion chocoterapia candy entro 5:15\r\n26/sept/15 promocion equilibrante de ph reyna entro 10:00\r\n30/oct/15 promocion reafirmante fernanda entro 4:45\r\n25/nov/15 promocion antiedad humectante y nutritivo mariana entro 5:20\r\n22/ene/16 promocion desintoxicante carmen entro 5.55\r\n27/abril/16 promocion trata luxury rosy entro 6:00\r\n8/julio/16 promocion de colageno maria entro 5:10\r\n10/nov/16 promocion oxigenate carmen entro 5:45\r\n20/ene/17 promocion desintoxicante andrea entro 5:40\r\n29/marzo/17 promocion estimulante de colageno con luz leds bego entro 5:40\r\n5/junio/17 promocion antioxidante monica entro 6:00\r\n27/julio/17 promocion trat relajante e hidratante lucy entro 1:05\r\n3/oct/17 promocion reafirmante monica entro 5:40\r\n17/nov/17 promocion termico humectante monica entro 5:00\r\n21/enero/18 prom. del mes trat. oxigenante monica entro 4:05 (mega)\r\n15/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO MARIANA ENTRO 5:00\r\n15/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD ANITA\r\n5/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL  MARY ENTRO 5:10\r\n20/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLA ROSITA ENTRO 4:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('37', 'C-100037', '', 'EUNISES DE LA CRUZ GOMEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('38', 'C-100038', '', 'ANTONIO MATURANA MELO', '9616524886', '', '7/dic/15 masaje full relax mariana entro 5:00\r\n28/ene/16 mdm full relax charito entro 3:25\r\n19/feb/16 mdm full relax charito entro 6:00\r\n12/mayo/16 mdm holistico rosy entro 5:50\r\n29/sept/16 masaje full relax andrea entro 6:00\r\n25/ene/17 masaje full relax carmen entro 2:30\r\n26/abril/17 mdm full relax monica entro 4:15\r\n4/JULIO/18 MDM FULL RELAX LUPITA ENTRO 6:00\r\n19/SEP/18 MDM FULL RELAX REYNA ENTRO 3:50\r\n13/MARZO/19 MDM FULL RELAX  BETTY ENTRO 5:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('39', 'C-100039', '', 'PERLA MEDINA ESPINOZA', '9932586609', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('40', 'C-100040', '', 'MARICELA URBINA GARCIA', '9931534355', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('41', 'C-100041', '', 'TERESA FERNANDEZ RUIZ', '', '', '4/ENE/19 MDM DE AROMAS  MARY ENTRO 1:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('42', 'C-100042', '', 'MARGARITA CASTILLO LAVIADA', '9931674429', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('43', 'C-100043', '', 'MARIA GABRIELA TANDAZO VALENCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('44', 'C-100044', '', 'ADRIANA RAMOS PEREZ', '9932101910', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('45', 'C-100045', '', 'ADRIANA HERNANDEZ SOLIS', '9931565742', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('46', 'C-100046', '', 'FLOR RADILLA FAJARDO', '9931601471', '', '', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('47', 'C-100047', '', 'GUADALUPE BLE GARCIA', '9932996863', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('48', 'C-100048', '', 'MA. DE LOS ANGELES DOMINGUEZ', '', 'angelita_1774@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('49', 'C-100049', '', 'MARIA DEL CARMEN JIMENEZ AVALOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('50', 'C-100050', '', 'OLGA OJEDA PAREDES', '9932221111', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('51', 'C-100051', '', 'RICARDO MURILLO ORTEGA', '9933946934', '', '02/11/11 masaje de espalda atendio jhoany entro 6.00 salio (mega)\r\n18/12/12 mdm drenaje lin. atendio jhoany entro6:08 mega\r\n14/09/13 masaje full relax jhoany mega 6:00\r\n22/09/13 mdm 2x1 atendio nelly entro 6:00\r\n23/02/14 masaje full relax mirena mega 6:05\r\n30/03/14 mdm full relax martha mega 5:00\r\n06/04/14 mdm full relax martha mega 5:05\r\n13/04/14 masaje cliente frecuente martha mega 5:15\r\n29/06/14 mdm full relax carmen mega 4:55\r\n06/07/14 mdm full relax carmen mega 5:00\r\n20/07/14 mdm full relax carmen mega 5:00\r\n03/08/14 mdm full relax martha mega 6:05\r\n10/08/14 mdm full relax martha mega 6:00\r\n31/agosto/14 mdm full relax martha entro 5:00 (mega)\r\n17/nov/14 mdm full relax martha entro 6:02 (mega)\r\n15/02/15  se realizo masaje full relax de cliente frecuente. atendio lucero. entro 5-20.\r\n30/nov/14 mdm full relax candy entro 7:01 (mega)\r\n14/marzo/15 mdm full relax maribel entro 7:05 (mega)\r\n18/abril/15 mdm full relax lucero entro 6:05 (mega)\r\n16/mayo/15 mdm full relax lucerito entro 6:07 (mega)\r\n27/junio/15 mdm full relax nelly entro 5:00 (mega)\r\n27/sept/15 mdm full relax maribel entro 7:10 (mega)\r\n26-12-15 SE REALIZO MDM FULL RELAX MARTHA CRISTAL 6PM\r\n10/julio/16 mdm full relax andrea entro 6:25 (mega)\r\n14/agosto/16 mdm full relax charito entro 5:00 (mega)\r\n28/agosto/16 mdm full relax charito entro 6:10 (mega)\r\n01/octubre/16 mdm full relax charito entro 06:00 (mega)\r\n06/noviembre/16 mdm full relax lizbeth entro 6:05 (mega)\r\n13/diciembre/16 mdm full relax cliente frecuente lizbeth entro 5:00 (mega)\r\n29/octubre/18 mdm full relax lupita entro 12:00 (mega)\r\n21/JULIO/19 MDM FULL RELAX EALEX ENTRO 6:05 MEGA\r\n18/MARZO/2020 MDM FULL RELAX SUSI ENTRO 11:15 MEGA\r\n5/SEPT/2020 MASAJE DESCONTRACTURANTE MARY LAZARO ENTRO 2:00\r\n30/OCTUBRE/2020 MASAJE DESCONTRACTURANTE MARY LAZARO ENTRO  1:00\r\n8/MAYO/21 MASAJE FULL RELAX ROSITA ENTRO 4:00 MEGA\r\n22/JUNIO/2021 MASAJE DESCONTRACTURANTE JHOANY ENTRO 9:50\r\n14/AGOSTO/2021 MASAJE DESCONTRACTURANTE MARIANA ENTRO 1:55 ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('52', 'C-100052', '', 'LUIS CRUZ SANCHEZ', '9931993987', '', '29/diciembre/18 mdm full relax y limpieza de acne 2x600 belen entro 4:00 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('53', 'C-100053', '', 'MARISOL MONTALVO RAMON', '9932077835', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('54', 'C-100054', '', 'GLORIA LOPEZ RODRIGUEZ', '9933939400', '', '01/junio/16 mdm sensorelax susy entro 11:05 (mega)\r\n30/junio/16 depilacion de bikini y muslo  maria entro 9:05\r\n9/AGOSTO/2021 DEPILACION CON CERA DE BIGOTE, PIERNAS COMPLETAS, BIKINI TRADICIONAL Y AXILA MARIANA ENTRO 2:05\r\n6/ABRIL/2022 DEPILACION CON CERA DE BIKINI Y MUSLO JOHANY ENTRO 11:50\r\n18/NOVIEMBRE/2022 DEPILACION CON CERA DE BIGOTE OFELIA ENTRO 2:15\r\n31/MARZO/2023 DEPILACION CON CERA DE BIGOTE, BIKINI Y MUSLO ROSY ENTRO 12:57 (MEGA)\r\n12/JULIO/2023 DEPILACION CON CERA DE BIGOTE Y MENTON JHOANY ENTRO 1:15', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-12 15:03:03', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('55', 'C-100055', '', 'ZOILA LIBERTAD OSORIO', '9933113425', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('56', 'C-100056', '', 'LESBIA ORALIA SANCHEZ MORALES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('57', 'C-100057', '', 'MARCELA DE LA CRUZ ASENCIO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('58', 'C-100058', '', 'AURORA AZCUAGA BERNAT', '934340007', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('59', 'C-100059', '', 'ELIZABETH DIAZ GOMEZ', '9932090932', '', '28-08-15 SE REALIZO DEP DE BIGOTE CANDY CRISTAL\r\n27/01/16 MASAJE CLIENTE FRECUENTE ATENDIO SUSY ENTRO 10.20 (CRISTAL)\r\n10-04-16 se realizo dp de bigote cristal candy 7-30\r\n06/junio/16 depilacion de bigote atendio susy entro 11.30 (mega)\r\n12/julio/16 dep. bigote andrea entro 6:50 (mega)\r\n12/agosto/16 dep. bigote andrea entro 7:45 (mega)\r\n27/septiembre/16 mdm full relax cliente frecuente rosy entro 10:05 (mega)\r\n27/noviembre/16 dep. bigote sra. bego 12:40 (mega)\r\n27/diciembre/16 dep. bigote lizbeth entro 5:15 (mega)\r\n29/enero/17 dep. bigote andrea entro 5:40 (mega)\r\n29/marzo/17 dep. bigote candy entro 11:55 (mega)\r\n31/mayo/17 dep. bigote candy entro 4:05 (mega)\r\n27/junio/17 dep. bigote charito entro 6:55 (mega)\r\n09/noviembre/17 dep. bigote andrea entro 6:42 (mega)\r\n23/MARZO/18 INICIA DEP LASER DE BIGOTE AUT 11J OFELIA ENTRO 5:00\r\n23/ABRIL/18 DEP LASER DE BIGOTE  AUT 18J SRA BEGO\r\n23/ABRIL/18 LLEVO CLEAR, TIMEXPERT WHITE  CONCENTRADO PRECISIÓN\r\n07/mayo/18 mdm full relax cliente frecuente anita entro 3.55 (mega)\r\n23/MAYO/18 DEP DE BIGOTE AUT 18 J OFELIA\r\n23/JUNIO/18 LASER DE BIGOTE AUT 20 J OFELIA ENTRO 5:00\r\n23/AGOSTO/18 LASER DE BIGOTE AUT 17 J LUCIA\r\n24/SEP/18 LASER DE BIGOTE AUT 18 J ENTRO 5:40\r\n24/OCT/18 LASER  DE BIGOTE AUT 22 J OFELIA \r\n24/NOV/18 8° BIGOTE AUTOM. 22 J MARY LAZARO\r\n8/ENE/19 LASER DE BIGOTE AUT 20 J/ SELE BAJO 18 J REYNA\r\n8/FEB/19 11° BIGOTE AUTOM. 18 J LUCY\r\n12/MARZO/19  LASER DE BIGOTE AUT 19 J REYNA\r\n18/MARZO/19 FULL RELAX CLIENTE FRECUENTE CARMEN ENTRO11:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('60', 'C-100060', '', 'CECILIA RUIZ LEON', '9931602534', '', '28/junio/17 delienado de cejas ofelia, se le dio $100.00 pesos a ofelia\r\n12/julio/17 retoque de cejas ofelia, se le dio $100.00 a ofelia\r\n17/OCT/2020 PROMOCION TRAT GOLD REGENERANTE LUCY ENTRO 12:00\r\n20/NOV/2020 PROMOCION TRAT. BOTANICO CON AMP. ROYAL JELLY OFELIA ENTRO 12:00\r\n4/DIC/2020 DELINEADO DE CEJAS, SE LE DIO $300.00 PESOS A OFELIA\r\n7/DICIEMBRE/2020 TRATAMIENTO FACIAL DE PORCELANA Y DEPILACION CON CERA DE PANTORRILAS ANITA ENTRO 3:00\r\n4/FEB/2021 DEPILACION CON CERA DE PANTORRILLAS Y PATILLAS MIRENA ENTRO 1:50\r\n27/MARZO/2021 DEPILACION DE PANTORRILLA CON CERA, PROMOCION ACIDO HIALURONICO LUCY ENTRO 8:50\r\n4/MAYO/2021 DEPILACION CON CERA PANTORRILLA MARIANA ENTRO 12:05\r\n24/JUNIO/2021 DEPILACION CON CERA DE PANTORRILLA MIRENA ENTRO 9:20\r\n23/JUNIO/2022 DEPILACION CON CERA DE PANTORRILLA MARIANA ENTRO 12:10\r\n30/JUNIO/2022 PROMOCION TRAT YOGA FACIAL JHOANY ENTRO 9:00\r\n30/JUNIO/2022 DELINEADO DE CEJAS OFELIA ENTRO 10:40\r\n26/JULIO/2022 RETOQUE DE CEJAS OFELIA ENTRO 11:20\r\n26/JULIO/2022 DEPILACION DE PANTORRILLAS OFELIA\r\n23/AGOSTO/2022 PROMOCION TRAT. FACIAL ANTIOXIDANTE, DEPILACION DE PANTORRILLAS JHOANY ENTRO 12:40\r\n26/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA JHOANY\r\n9/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN CRISTINA ENTRO 3:00\r\n23/DICIEMBRE/2022 PROMOCION TRAT. FACIAL GOLDEN CRISTINA ENTRO 12:35\r\n11/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE MARIANA ENTRO 12:40\r\n24/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE OFELIA ENTRO 9:40\r\n16/FEBRERO/2023 PROMOCION TRAT. FACIAL ELIXIR DE JUVENTUD OFELIA ENTRO 11:00\r\n29/MARZO/2023 PROMOCION DEL MES TRATAMIENTO MICRODERMA ANTIEDAD ROSY ENTRO 3:10 (MEGA) LLEVO HELIOCARE 360 CON COLOR\r\n28/ABRIL/2023 PROMOCION TRAT. FACIAL PLASMA MARINO JHOANY ENTRO 1:05\r\n1/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND LUCY ENTRO 9:20', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-31 18:44:50', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('61', 'C-100061', '', 'ROSARIO DOMINGUEZ Y MENDOZA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('62', 'C-100062', '', 'GUADALUPE HERNANDEZ GARCIA', '9932621891', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('63', 'C-100063', '', 'ALEJANDRA MERINO FERRER', '9932055396', '', '11/marzo/16 promocion hydratante carmen entro 10:00\r\n11/marzo/16 llevo crema confort alta recuperación night timexpert srns \r\n20/mayo/16 promocion de colageno maria entro 9:10\r\n21/junio/16 promocion de elastine mary lazaor neotr 9:45\r\n21/nov/16 masaje sensorelax charito entro 9:15\r\n30/nov/16 masaje full relax 2x500 mary lazaor entro 9:10\r\n16/mayo/17 promocion antiedad con lifting mary L entro 9:10 llevo crema excel therapy O2 y elixir absoluto timexpert rides\r\n16/junio/17 promocion antioxidante mary L entro 9:00 salio 10:15\r\n13/julio/17 promocion relajante e hidratante lizvet entro 9:15\r\n10/agosto/17 radio facial mary lazaro entro 9:30\r\n21/agosto/17 radio facial mary lazaro entro 9:25\r\n21/Oct/17 mdm drenaje linfatico, promocion reafirmante monica entro 10:05 LLEVO CREMA RECUPERADORA INTENSIVA TIMEXPERT SRNS\r\n28/12/17 PROMOCION TRATAMIENTO GOLD ANITA ENTRO 1:00\r\n02/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA ANITA ENTRÓ 10:25 LLEVO CREMA MULTI-CORRECCIÓN INTENSIVA TIMEXPERT VITAMINA C + DE GERMAINE\r\n25/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE  LUCY ENTRO 9:05\r\n26/JUNIO/18   IPL  PROG 2 INT 5  LUCY\r\n20/JULIO/18  IPL   PROG  2 INT 5 LUCY\r\n20/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL LUCY ENTRO 9:10\r\n27/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE MARY  ENTRO 9:20\r\n27/AGOSTO/18 IPL PROG 1 INT 5 MARY\r\n5/OCT/18 PROMOCION REAFIRMANTE LUCY ENTRO 9:50\r\n5/OCT/18 4TA. IPL PROG. 1 INT. 5 LUCY\r\n5/OCT/18 LLEVO CREMA EXCEL THERAPY\r\n7/NOV/18 IPL MANCHAS PROG 2 INT 5 REYNA Y PROM TRATAMIENTO FACIAL DE POLUCIÓN OFELIA\r\n17/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE CARMEN\r\n17/DIC/18 IPL  PROG 1 INT 5 MARY\r\n21/ENERO/19 PROMOCION REVITALIZANTE MONICA ENTRO 10:00\r\n21/ENERO/19 7A. IPL PROG. 2 INT. 5 MARY \r\n18/FEB/19 PROMOCION REAFIRMANTE OFELIA ENTRO 11:10\r\n18/FEB/19 8TA. IPL PROG. 2 INT. 5 OFELIA\r\n5/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE LUPITA ENTRO 11:00\r\n6/MAYO/19 REVERSE ANITA ENTRO 10:20\r\n22/JULIO/19 REVERSE MARY LAZARO ENTRO 10:35\r\n26/AGOSTO/19 MASAJE FULL RELAX 2 X 600 ANITA ENTRO 10:10\r\n26/AGOSTO/19 TRAT REVERSE ANITA ENTRO 11:15\r\n14/OCT/19 TRAT REVERSE MARY LAZARO ENTRO 11:50\r\n13/NOV/19 TRAT REVERSE MARY LAZARO ENTRO 11:00\r\n4/MARZO/20 FACIAL SRNS MARY LAZARO ENTRO 11:50\r\n22/AGOSTO/2020 MASAJE FULL RELAX, PROMOCION TRAT OXIGENANTE LUCY ENTRO 1:00\r\n22/SEPTIEMBRE/2020 TRATAMIENTO FACIAL REVITALIZANTE ANITA ENTRO 11:45\r\n7/OCT/2020 PROMOCION TRAT GOLD REGENERANTE ROSY ENTRO 10:00\r\n19/ABRIL/2021 PROMOCION TRAT. VIT C CON AMP. BEAUTE I LUCY ENTRO 11:05\r\n18/MAYO/2021 PROMOCION TRAT. CELULAS MADRE ANITA ENTRO 10:10\r\n4/JUNIO/2021  PROM. TRATAMIENTO FACIAL RETINOL  MARIANA ENTRO 10:10\r\nLLEVO CREMA CHAUFFANTE\r\n27/JULIO/2021 PROMOCION TRAT CAVIAR Y ORO MARY LAZARO ENTRO 10:50\r\n13/AGOSTO/2021 PROMOCION TRATAMIENTO ORGANICO REVITALIZANTE Y RADIOFRECUENCIA FACIAL MARIANA ENTRO 9:45 \r\n25/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD JOHANY EN TRO 10:10\r\n5/NOVIEMBRE/2021 MASAJE FULL RELAX 2X600, PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO  JOHANY ENTRO 10:10\r\n12/ENERO/2022 PROMOCION TRAT DETOX MARIANA ENTRO 10:15\r\n18/FEB/2022 TRATAMIENTO FACIAL PHITO RETINOL VEGANO CON MASCARA DE ELECTROESTIMULACION $2000.00 MIRENA ENTRO 12:30 \r\n22/MARZO/2022 PROM. TRATAMIENTO FACIAL SCHOK DE COLAGENO CON AMP  BEAUTE I MIRENA \r\n26/ABRIL/2022 PROMOCION TRAT CINETICO JHOANY ENTRO 11:00\r\n17/MAYO/2022 PROMOCION TRAT FITO HIDRATANTE MARIANA ENTRO 10:05\r\n*****LLEVO CREMA GLOBAL SUPREMA TIMEXPERT RIDES*****\r\n2/JUNIO/2022 PROMOCION TRAT YOGA FACIAL, DEPILACION DE CEJAS MARIANA ENTRO 10:00\r\n21/JULIO/2022 PROMOCION TRAT ROLL & LIFT, DEPILACION DE CEJAS MARIANA ENTRO 10:40\r\n16/AGOSTO/2022 PROM TRATAMIENTO FACIAL ANTIOXIDANTE CRISTINA ENTRO 10:05\r\n********************************************************************************\r\n* LIFTING DE L,800.00 A 1,600   2/SEPTIEMBRE/2022 MARIANA  ENTRO 10:10\r\n* RADIFRECUENCIA FACIAL DE 1,800.00 A 1,500.00 19/OCTUBRE/2022 LUCY ENTRO 11:05\r\n* EXCEL THERAPY CON REVERSE 2,400.00 A 2,000.00 24/NOVIEMBRE/2022 ARIANA ENTRO 11:15\r\n* LASER DE CARBONO 1,200.00 29/DICIEMBRE/2022 OFELIA ENTRO 11:00\r\n29/DICIEMBRE/2022 MASAJE FULL RELAX 2 X 600 OFELIA ENTRO 10:10\r\n* V-MAX  3,500.00 A 2,000.00\r\n* MESO BOOST 2,000.00 A  1,500.00\r\n* TIMEXPERT IN CON RADIO 2,400.00 A 2,000.00\r\n* SRNS CON CIOTERAPIA 2,400.00 A 2,000.00\r\n* TRATAMIENTO DE ORO CON LIFTING 2,400.00 A 2,000.00\r\n* TRATAMIENTO REVITALIZANTE CON CRIOTERAPIA 2,400.00 A 2,000.00\r\n17/MAYO/2023 PROMO TRATAMIENTO FACIAL MAGIC FACE CON AMP. AGE COMPLEX OFELIA ENTRO 3:00\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-17 16:02:27', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('64', 'C-100064', '', 'LILIANA DE LA CRUZ BRINDIS', '9931979309', '', '02/05/16 MASAJE FULL RELAX ATENDIO ANDREA ENTRO 10.50 (MEGA)\r\n21/ABRIL/2021 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ROSY ENTRO 11:30 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('65', 'C-100065', '', 'ELSY DE LA CRUZ VELAZQUES', '9931299591', '', '15/junio/17 depilacion brasileña total andrea entro 3:00\r\n19/junio/17 masaje full relax 2x600 yani entro 6:00\r\n28/sept/17 depilacion brasileña total mariana entro 1:30\r\n25/ENERO/2020 PROMOCION TRAT DESINTOXICANTE MARIANA ENTRO 9:00\r\n25/FEBRERO/20 INICIA DEPILACION LASER DE BIGOTE 30 MS 10 J LUCY\r\n25/FEBRERO/20 DEPILACION CON CERA DE BRASILEÑA TOTAL ANITA\r\n20/JUNIO/20 LASER DE BIGOTE 30 MS 12 J Y BRASILEÑA 30 MS 10 J MARY LAZARO\r\n9/MARZO/2021 PROMOCION TRAT. ACIDO HIALURONICO JHOANY ENTRO 12:50\r\n5/FEB/2022 PROMOCION TRAT AGE DEFENSE ARLETH ENTRO 11:55\r\n22/MAYO/2023 PROMOCION TRAT. MAGIC FACE ALONDRA ENTRO 1:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-20 15:39:51', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('66', 'C-100066', '', 'CEYLA ZURITA BOCANEGRA', '9931967331', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('67', 'C-100067', '', 'KARLA CORDOVA WILSON', '9932071687', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('68', 'C-100068', '', 'MARIBEL LEZAMA ROJAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('69', 'C-100069', '', 'SILVIA PEREZ DE SAENZ', '9933110760', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('70', 'C-100070', '', 'VANESA MU', '9932599757', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('71', 'C-100071', '', 'SANDRA GUADALUPE CASTILLO FERNANDEZ', '9933206151', '', '15/ene/16 delineado de cejas ofelia. se le dio $100.00 a ofelia\r\n15/ene/16 mdm aromas chario entro 1:40\r\n10/feb/16 retoque de cejas ofelia, se le dio $100.00  a ofelia se le dio el retoque no se sabe si vino.\r\n18/DIC/18 DELINEADO DE CEJAS OFELIA\r\n28/JUNIO/2021 DELINEADO DE CEJAS SE LE DIO 300 OFELIA ENTRO 1:00\r\n12/JULIO/2021 RETOQUE DE CEJAS OFELIA ENTRO 11:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('72', 'C-100072', '', 'PENELOPE MU', '9932599757', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('73', 'C-100073', '', 'CECILIA VAZQUEZ PEREZ', '9931604071 ', '', '27/JUNIO/2023 VALE DE REGALO PROMOCION DEL MES TRATAMIENTO ULTRASOUND SUSY ENTRO 2:58 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-30 14:44:53', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('74', 'C-100074', '', 'PAULA BARRERA DAVILA', '9932079318', '', '03/03/11 masaje antiestres 2x1 atendio:graciela entro:2:25pm-3:15pm sucursal.\r\n28/04/11 limp. fac. mdm 2x1 atendio:jhoana entro:12:53pm salio:3:53(suc)\r\n30/mayo/11 facial hidronutritivo reyna entro 9:00\r\n17/sep/11 trat. amaranto ofelia entro 11:00\r\n30/nov/11 infinitime ofelia entro 10:15\r\n25/feb/12 hydracure ofe entro 9:00\r\n21/marzo/12 facial excel therapy o2 ofe entro 9:20\r\n17/abril/12 promocion revitalizante reyna entro 2:30\r\n25/junio/12 bioxidea ofelia entro 12:00\r\n16/julio/2012 timexpert rides ofe entro 12:20\r\n6/sept/12 timexpert lift ofelia entro 1:00\r\n24/sept/12 desafio antiedad natura bisse ofelia entro 12:25\r\n26/oct/12 oxigenante nb ofelia entro 11:10\r\n17/dic/12 facial royal jelly ofelia entro 11:15\r\n22/dic/12 facial oxigenante nb ofelia entro 11:35\r\n20/marzo/13 timexpert rides ofelia entro 12:10\r\n28/junio/13 facial velo de colageno ofelia entro 10:00\r\n28/sept/13 facial inhibit 3d nb ofelia entro 12:25\r\n6/dic/13 timexpert rides ofelia entro 12:30\r\n10/mayo/14 lim. facial desafio antiedad ofelia entro 10:20\r\n24/mayo/14 facial vitamina c de natura bisse ofelia entro 9:45\r\n25/junio/14 facial aqua natura bisse ofelia entro 9:20\r\n16/julio/14 timexpert lift ofe entro 12:55\r\n30/sept/15 facial vitamina c natura bisse ofelia entro 9:15\r\n8/dic/15 desafio antiedad ofelia entro 10:10\r\n14/ene/16 timexpert rides ofelia entro 11:00\r\n16/marzo/16 facial timexpert rides mariana entro 2:15\r\n7/junio/16 facial timexpert rides ofelia entro 3:10\r\n28/junio/16 facial vitamina c de germaine ofelia entro 12:15\r\n12/oct/16 facila hydracure ofelia entro 3:00\r\n4/julio/17 facial timexpert rides ofelia entro 1:20\r\n16/agosto/17 delineado de cejas ofelia, se le dio $100.00 a ofelia\r\n30/agosto/17 retoque de cejas ofelia, se le dio $100.000 a ofelia\r\n9/sept/17 promocion resveratrol con amp,. de colageno ofelia entro 9:20\r\n25/01/18 TIMEXPERT WHITE OFE ENTRO 11:00\r\n14/JUNIO/18 FACIAL TIMEXPERT RIDES OFELIA \r\n20/JULIO/18 DELINEADO DE CEJAS  OFELIA\r\n9/AGOSTO/18 RETOQUE DE CEJAS OFELIA\r\n18/DIC/18 FACIAL  Y LIFTING DE VICT C OFELIA\r\n12/JULIO/19 FACIAL TIMEXPERT RIDES OFELIA ENTRO 3:00\r\n12/FEBRERO/2022 FACIAL VITAMINA C DE NATURA BISSE OFELIA ENTRO 12:00', 'no', 'activo', '2021-12-07 00:49:45', '2022-11-14 15:38:32', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('75', 'C-100075', '', 'MARIA ENRIQUETA MADRAZO BOYLAN', '', '', '16/feb/17 promocion trat de elastine ofelia entro 9:40', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('76', 'C-100076', '', 'LUISANGELICA SOLIS PERALTA', '9932386378', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('77', 'C-100077', '', 'BEATRIZ GARCIA GONZALEZ', '9932198450', '', '1/sept/16 promoción de colageno mary lazaro entro 1:00\r\n15/sept/16 promoción de coalgeno mariana entro 12:25\r\n24/noviembre/16 limpieza facial 2x500 con amp. beaute II maria entro 4:00 (mega)  no quiso exfoliacion en cuello y pectorales asi mismo tampoco quiso mascarilla en cuello y pectorales.\r\n07/diciembre/16 limpieza facial 2x600 con amp. acido hialuronico lizbeth entro 12:05 (mega) no quiso exfoliacion en cuello y pectorales asi mismo tampoco quiso mascarilla en cuello y pectorales.\r\n02/marzo/17 limpieza facial con amp. hydratante rosy entro 11:20 (mega)\r\n13/DIC/18 LIMPIEZA FACIAL 2 X 600 LUPITA ENTRO 10:45\r\n19/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K SANDY', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('78', 'C-100078', '', 'GEORGINA ALAMILLA GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('79', 'C-100079', '', 'DIANA PEREZ', '9931566604', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('80', 'C-100080', '', 'JORGE ALBERTO RODRIGUEZ CORDOVA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('81', 'C-100081', '', 'CLAUDIA CECILIA GARCIA', '9932058592', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('82', 'C-100082', '', 'ANABEL MIMBRERA JIMENEZ', '9935901585', '', '1/ DICIEMBRE/2021 MASAJE DRENAJE LINFATICO MARIANA ENTRO 4:15\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('83', 'C-100083', '', 'JHONATAN ROMAN ORTA', '9935901585', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('84', 'C-100084', '', 'ANTONIA CARRERA NADAL', '9933995369', '', '08/11/03 prom. trat. hidratante con lifting de parpados lucy\r\n22/11/03 jalea real rosy\r\n24/02/04 promocion ginseng bego\r\n20/03/04 hydrasoin bego\r\nel proximo tratamiento sera citoquinas\r\n29/07/04 timexpert bego\r\n31/07/04 exf. cuerpo lupita\r\n06/09/04 revitase, limpieza capilar bego\r\n23/10/04 revitase bego\r\n01/11/04 facial tipo revitase bego\r\n01/12/04 facial vitamina c bego\r\n05/03/05 hydrasoin bego\r\n11/03/05 hydrasoin bego\r\n12/03/05 hydrasoin bego\r\n15/04/05 jalea real bego\r\n15/04/05 reflexologia podal lucy\r\n30/04/05 facial bego\r\ntiene un saldo a favor de $400.00 pesos \r\nde un cambio de cremas el serum intensivo por el trat. corrector de timexpert\r\nno se le debe nada se dio una promocion 3 geles su hija fabiola. \r\n10/06/05 hydrasoin y limpieza capilar bego\r\n18/06/05 antiarrugas bego\r\n18/06/05 llevo la crema hydrasoin comfort\r\n21/07/05 facial bego\r\n27/08/05 jalea real bego\r\n08/10/05 timexpert de parpados, dep. cejas bego\r\n08/10/05 llevo la amp. biolage\r\n15/oct/05 trat. de uva bego\r\n20/dic/05 ginseng, lifting de parafina bego\r\n07/ene/06 ginseng bego\r\n03/feb/06 hydrasoin mary lazaro\r\n10/marzo/06 oxigenoterapia bego\r\n10/marzo/06 llevo la emulsion facial nutrisence \r\n18/marzo/06 revitase gladys\r\n25/marzo/06 hidrasoin gladys\r\n08/abril/06 excel therapy gladys\r\n13/mayo/06 revitase bego\r\ninicia tratamiento ptv $1000.00 cada sesion\r\n20/mayo/06 micro-hydrasoin bego\r\n26/mayo/06 micro-excel therapy bego\r\n03/junio/06 micro-revitase bego\r\n10/junio/06 micro-timexpert bego\r\n10/junio/06 trat. de pies yesy..\r\nse llevo la crema strategis de dia y de noche, crema de oro, \r\ny spray para piernas cansadas.\r\n24/junio/06 dermorelax ofelia\r\n01/julio/06 trat. criogeno bego\r\n19/julio/06 facial de hidratacion bego\r\n29/julio/06 tratamiento de impulsos reafirmante rosy y se lleva 2 esponjas\r\n07/agosto/06 vino su hija y la sra va a pagar\r\n los productos que se llevo su hija paola carrera facial $650, \r\nemulsion excel $1,100 y crema revitase ojos $530 \r\ntambiem vino su hija ximena y se le hizo una limpieza facial $300 que va a pagar.\r\n09/agosto/06 trat. facial de hidratacion $800.00 y lfting $250.00\r\n de su nuera carmela alamilla\r\n11/agosto/06 hija paola mdm $350.00  facial $800.00 gel desm. $500.00\r\n12/agosto/06 trat. facial bego $800.00  \r\n12/agosto/06 trat. de oro rosy llevo amp. eclat $100.00\r\n12/agosto/06 su cuenta llego $7680.00 abono $3500.00 con tarjeta\r\n y $3000.00 en efectivo. resta $1180.00\r\n19/agosto/06 facial, capilar, dep. cejas, exf. cuerpo bego\r\n19/agosto/06 pago todo lo que debia. no debe nada.\r\n01/sept/06 so.delicate bego entro 12:20 salio 1:40\r\n14/sept/06 tratamiento de perla facial bego entro 8:00 salio 9:10 debe 600 pesos\r\n29/sept/06 infinitime bego\r\n21/oct/06 go expression bego. \r\ndebe este tratamiento lo va a pagar el lunes o martes \r\nse llevo un facial go-expression, 1 crema infinitime\r\n13/dic/06 revitase bego \r\n14/dic/06 chocolaterapia bety entro 8:30 salio 10:30\r\ndebe $4,550.00 de su hija fabiola carrera\r\ndebe $5,070.00 de su hija paola carrera\r\nen total debe $9,620.00\r\n04/ene/07 velos elasticos de colageno rosy entro 5:20\r\n03/marzo/07 llevo hydrasoin comfort pago todo lo que debia.\r\n16/marzo/07 vitamina c lucy entro 5:15\r\n17/marzo/07 exfoliacion de cuerpo reyna entro 8:40\r\n06/julio/07 infinitime lucy entro 5:15\r\n06/julio/07 llevo 3 gelulas rojas, i beaute ii, crema infinitime piel normal a mixta\r\n21/julio/07 mesoterapia sin aguja bego entro 12:50\r\n16/agosto/07 go-expression bego entro 4:05\r\n15/sept/07 limpieza facial con amp. de placent mary entro 1:15\r\n15/dic/07 trat. caviar bego entro 8:10\r\n19/dic/07 inicia mesoterapia facial bety entro 4:35\r\n26/dic/07 mesoterapia facial rosy entro 9:20\r\n3/ene/08 mesoterapia facial rosy entro 3:30 salio 3:45 \r\n11/ene/08 mesoterapia facial bety entro 3:30 salio 3:50 \r\n15/marzo/08 llevo locion facial infinitime.\r\n19/abril/08 trat. caviar bego entro 10:15 salio 11:40 va a llevar la crema de oro.\r\n17/mayo/08 seda y perla lucy entro 11:10 salio 12:15 \r\n21/junio/08 trat. orange bego \r\n16/agosto/08 limpieza facial bego entro 1:00 \r\n6/sept/08 trat. hidro-nutritivo bego entro 9:50 se llevo el tonico de flor de loto\r\n15/oct/08 limpieza facial 2 x 1 con amp. beaute i rosy entro 4:00 \r\n29/oct/08 excel therapy 02 rosy \r\n1/nov/08 jalea real, lifting de parafina rosy entro 9:50 \r\n15/nov/08 trat. facial con masc. nutritiva de leim bego entro 12:10 \r\n28/nov/08 tratamiento facial de $ 1200.00 bego \r\n18/dic/08 timexpert lucy entro 9:30\r\n3/ene/09 tratamiento facial con gelula roja \r\ny amp. serum nutritivo regenerador $1200.00 bego entro 8:35 \r\n5/feb/09 limpieza facial bego entro 8:00 salio 9:00\r\n se llevo l.vita y la crema de ojos de perla\r\n5/feb/09 empezo a usar el l´vita.\r\n5/marzo/09 limpieza facial bego \r\n5/marzo/09 radiofrecuencia bego\r\n7/marzo/09 radiofrecuencia bego entro 8:50 salio 9:30\r\n13/marzo/09 radiofrecuencia bego\r\n13/marzo/09 se le puso gelula amarilla, gelula roja, beaute i, amp. hidratante de sothys\r\n25/abril/09 timexpert ofelia entro 9:05 \r\n23/mayo/09 limpieza facial con amp. complex marine y amp. retinol bego \r\n4/julio/09 deluxe bego entro 12:00 \r\n4/julio/09 llevo masc. ak para control de grasa en la nariz\r\n8/agosto/09 promocion revitalizante con amp. beaute iii mary lazaro entro 10:55 \r\n28/mayo/10 trat. begoña bego entro 8:55 salio 10:45 \r\n17/junio/10 skinlight completo bego entro 10:00\r\n26/junio/10 orange bego entro 11:55 \r\ncaja de gelula roja precio esteticista $2,300.00\r\n24/julio/10 se llevo la caja de gelula roja\r\n29/ene/11 caviar bego entro 11:00 \r\nllevo locion piel seca de lendan, crema facial celulas madres de manzana de germaine\r\n4/feb/11 hydronutritivo bego entro 11:26 \r\n1.-11/mayo/11 skinlight completo bego entro 4:10 llevo trat. de ojos dia/noche timexpert rides\r\n11/mayo/11 trat. de manos karina \r\n25/junio/11 trat. facial se le aplico amp. acido hialuronico y amp. finish bego entro 12:30\r\n2/julio/11 llevo ampolletas s.o.s\r\n14/08/11 tratamiento timexpert lif reafirmante  atendio indira entro 12.20 pm salio3:00  (suc mega)\r\ndep de cejas y bigote \r\n16/09/11 limpieza facial 2x1 atendio indira entro 1.05 salio 3. (suc mega) se le aplicara su lifting\r\nreflexolodia y se le\r\n20/dic/11 facial velo de colageno, depilacion de cejas y bigote bego\r\n18/ene/12 trat. facial con amp. olea rituals y aqua rituals, dep. de cejas y bigote bego entro 4:20\r\n18/ene/12 llevo serum recuperador intensivo contorno de ojos timexpert srns, leche desmaquillante\r\ny tonico de jalea real.\r\n4/feb/12 caviar mariana entro 2:00\r\n21/feb/12 radiofrecuencia reyna entro 4:00\r\n21/feb/12 cavitacion 30 m en abdomen $800.00 masaje reductivo 20 m $450.00 mariana entro 4:35\r\n23/abril/12 trat. bioxidea, dep. de bigote, lifting de colageno, trat. de manos reyna entro 5:40\r\n28/abril/12 skinlight completo bego \r\n28/abril/12 trat de manos de uva lucy\r\n10/mayo/12 timexpert rides lucy entro 10:00\r\n12/julio/12 depilacion de cejas y bigote bego entro 5:00\r\n18/julio/12 tratamiento glycocure karina entro 2:20\r\n18/julio/12 depilacion de cejas karina \r\n25/08/12 trat. timex pert  rides atendio jhoany entro 1:00 mega\r\n2/oct/12 antiedad natura bisse ofelia entro 10:05 llevo tonico ceutical natura bisse\r\n20/oct/12 vit c natura bisse ofelia entro 9:45\r\n23/nov/12 facial the cure natura bisse lucy entro 5:25 llevo fluido reafirmante de vit c de nb\r\n1/dic/12 facial ceutical nb lucy entro 1:30\r\npago 5 sesiones de masaje reductivo $1500.00 pagado\r\n1.-masaje 45 m 13/feb/14 carmen \r\n23/julio/15 mdm full relax y dep cejas ofelia entro 2:05\r\n21/agosto/15 dep de cejas reyna entro 4:15\r\n8/oct/15 dep de cejas, bigote y limpieza facial con amp. colageno ofelia\r\n4/marzo/16 facial vitamina c nb, depilacion de cejas lucy entro 11:50\r\n8/julio/17 promocion relajante e hidratante ofelia entro 2:20\r\n8/DICIEMBRE/19 TRATAMIENTO 24K MONI ENTRO 12:50 MEGA\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('85', 'C-100085', '', 'NOEMI ALVAREZ RAMIREZ', '9161161299', '', '9/dic/16 promocion trat multivitaminico charito entro 5:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('86', 'C-100086', '', 'MARTHA DEL CARMEN RODRIGUEZ JIMENEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('87', 'C-100087', '', 'MARIA YOLANDA CONTRERAS PALACIO', '9931982068', '', '19/ene/12 promocion revitalizante rosy entro 1:35\r\n13/feb/13 promocion catiodermia gladys entro 11:50\r\n11/10/13 limpieza facial 2x1 susy entro 12.30 (suc las flores)\r\n06/03/14 serealizo linp facial atendio mary las flores\r\n30/04/14 seealizo limp de un 2x1 atendio graciela las flores\r\n24/06/14 se hizo limp  2x1 1.20 mary suc las flores\r\n22/01/15 se hizo limp 2x1 atendio graciela cristal entro alas 2.00\r\n18/agosto/15 limpieza facial 2x600 graciela entro 1:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('88', 'C-100088', '', 'JAVIER ARTURO MARTINEZ LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('89', 'C-100089', '', 'PAMELA GUTIERREZ OJEDA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('90', 'C-100090', '', 'MARIA ESTHER GARCIA PINTO', '9932071029', '', '22/mayo/16 limpieza facial 2x600 andrea entro 2:55 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('91', 'C-100091', '', 'AMBROSIO HERNANDEZ OSORIO', '', '', '22/AGOSTO/19 MDM FULL RELAX DE CLIENTE FRECUENTE ALE ENTRO 9:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('92', 'C-100092', '', 'JUAN GUERRERO TAPIA', '9933115542', '', '', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('93', 'C-100093', '', 'CONCEPCION ZURITA ALMEIDA', '9933995490', '', '9/OCT/18 FACIAL DESAFIO ANTIEDAD LUPITA ENTRO 10:10\r\n11/OCT/18 INICIA TRATAMIENTO DE NEW LIFT COSTO 8,000 ABONO 4,000 DEBE 4,000\r\n1.- NEW LIFT  11/OCT/18 LUCY ENTRO 10:10\r\n2.- NEW LIFT  15/OCT/18 LUCY ENTRO 10:15\r\n3.- NEW LIFT  16/OCT/18 LUCY ENTRO 10:00\r\n4.- NEW LIFT   17/OCT/18 LUCY ENTRO 10:00\r\n5.- NEW LIFT   19/OCT/18 LUCY ENTRO 10:00\r\n6.- NEW LIFT   20/OCT/18 LUCY ENTRO 8:15\r\n7.- NEW LIFT 23/OCT/18 LUCY ENTRO 10:00\r\n8.- NEW LIFT  24/OCT/18 LUCY ENTRO 11:15\r\n9.- NEW LIFT  25/OCT/18 LUCY ENTRO 10:00\r\n10.- NEW LIFT \r\n\r\n27/OCT/2020 DEPILACION DE AXILA CON CERA ANITA ENTRO 12:15\r\n23/DIC/2020 TRAT. TRADICIONAL DE MANCHAS ANITA ENTRO 3:10\r\n26/DIC/2021 TRAT, TRADICIONAL DE MANCHAS MARY LAZARO ENTRO 2:10\r\n26/DIC/2021 LASER DE AXILA 30MS 11J Y BIGOTE 100MS 11J MARY LAZARO\r\n3/FEB/2021 TRAT MANCHAS LUCY ENTRO 11:10 LLEO SPOT DIMINISH TIMEXPERT WHITE\r\n3/FEB/2021 DEPILACION DE CEJAS MIRENA\r\n8/NOVIEMBRE/2021 PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO MARY LAZARO \r\n11/NOVIEMBRE/2021 IPL MANCHAS PROG 1 INT 4 LUCY ENTRO 11:00\r\n25/NOVIEMBRE/2021 4TA AXILA Y BIGOTE 30MS 10J MARY LAZARO\r\n25/NOVIEMBRE/2021 INCIA LASE DE BIKINI 30MS 10J MARY LAZARO\r\n25/NOVIEMBRE/2021 MICRO PUNTA MARY LAZARO    **LLEVO GLYCOCELL\r\n7/DIC/2021 MICRO MANCHAS LUCY ENTRO 12:00\r\n14/DIC/2021 MICRO MANCHAS JHOANY ENTRO 12:00\r\n17/DIC/2021 2DA. BIGOTE, AXILA, BIKINI 30 MS 10 J LUCY\r\n7/ENERO/2022 MICRO MANCHAS JHOANY ENTRO 12:10\r\n14/ENERO/2022 MICRO MANCHAS JHOANY ENTRO 11:55\r\n17/ENERO/2022 3RA. LASER DE BIGOTE, AXILA, BIKINI 30 MS 10 J MARY LAZARO\r\n24/ENERO/2022 MICRO MANCHAS MARY LAZARO ENTRO 11:45\r\n14/FEB/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ARLETH ENTRO 12:00\r\n22/FEBRERO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 10:10\r\n22/FEBRERO/2022 4TA BIGOTE, AXILA Y BIKINI 30MS 10J MARY LAZARO\r\n4/MARZO/2022 MICRODERMABRASION ARLETH ENTRO 12:00\r\n25/MARZO/2022 MICRODERMABRASION DE PUNTA MARIANA ENTRO 11:55\r\n11/MARZO/2022 MICRODERMABRASION PUNTA SUSI ENTRO 12:25\r\n27/ABRIL/2022 MICRO PUNTA DIAMANTE MARY LAZARO ENTRO 11:40\r\n11/MAYO/2022 MICRO PUNTA DIAMANTE JHOANY ENTRO 12:00\r\n26/MAYO/2022 MICRO PUNTA DIAMANTE OFELIA ENTRO 1:00\r\n23/JUNIO/2022 MICRO PUNTA DE DIAMANTE MARIANA ENTRO 1:00\r\n********************************************************************************************\r\n************************OJOO  NOLA PUEDE ATENER CRISTINA******************************\r\n*********************************************************************************************', 'no', 'activo', '2021-12-07 00:49:45', '2022-06-29 16:32:40', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('94', 'C-100094', '', 'ALEJANDRA DELFIN AGUILAR', '9931909333', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('95', 'C-100095', '', 'ROSA GUADALUPE MARIN MAY', '9333347081', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('96', 'C-100096', '', 'ROSARIO RODRIGUEZ ZEPEDA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('97', 'C-100097', '', 'LOURDES CABRERA ESTRADA', '9931655802', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('98', 'C-100098', '', 'MELISSA RIOS SUAREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('99', 'C-100099', '', 'ERIKA FLORES DURAN', '9933115570', '', '17/noviembre/15 dep. bikini total mirena entro 2:05 (mega)\r\n15/julio/16 dep. bikini total lizbeth entro 5:00 (mega)\r\n16/agosto/17 dep. bikini total andrea entro 1:10 (mega)\r\n05/marzo/18 dep. bikini total rosy entro 1:00 (mega)\r\n22/junio/18 dep. bikini total candy entro 1:05 (mega)\r\n19/ENE/19 DEP BIKINI TOTAL SUSI ENTRO 1.05 (MEGA)\r\n16/mayo/19 dep. de bikini completo susy entro 12:00 mega\r\n12/agosto/19 dep. de bikini completo rosy entro 6:10 mega\r\n23/ENERO/2020 DEP. DE BIKINI COMPLETO CON CERA SUSI ENTRO 3:05 MEGA\r\n13/ABRIL/2022 DEP. BIKINI TOTAL ROSI ENTRO 16:00 MEGA\r\n29/julio/2022 depilacion brasileña  susy entro 5:10 (MEGA)\r\n28/ NOVIEMBRE/2022 DEPILACION DE CERA BRASILEÑA BIKINI TOTAL ROSY ENTRO 3:15 (MEGA)\r\n04/ABRIL/2023 DEPILACION DE CERA BRASILEÑA BIKINI TOTAL SUSY ENTRO 2:10 (MEGA)\r\n16/JUNIO/2023 DEPILACION DE CERA BRASILEÑA BIKINI TOTAL SUSY ENTRO 2:01 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-16 11:59:44', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('100', 'C-100100', '', 'ALBERTO GERONIMO GARCIA', '2292675755', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('101', 'C-100101', '', 'WILLY DEIVY TASS SALINAS', '9343440422', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('102', 'C-100102', '', 'ADRIANA MARTINEZ BURGOS', '9933995622', '', '07-09-15 SE REALIZO LIMP FACIAL MARTHA CRISTAL 4PM\r\n07/enero/16 limpieza facial con descuento de pemex  charito entro 4:10 (mega)\r\n16/diciembre/16 limpieza de acne con  amp. desincrustante maria entro 10:05 (mega)\r\n27/abril/17 limpieza de acne lizbeth entro 11:05 (mega)\r\n12/oct/17 limpieza facial lucy entro 1:20\r\n30/nov/17 limpieza facial con amp. desincrustante lucy entro 12:15\r\n8/dic/17 limpieza de acne charito entro 2:10\r\n18/AGOSTO/18 LIMPIEZA FACIAL LUCY ENTRO 2:00\r\n17/NOV/18 LIMPIEZA FACIAL SARAI\r\n06/ABRIL/19 LIMPIEZA FACIAL DE ACNE MONY ENTRO 5_10 MEGA\r\n14/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS   LUCY ENTRO 5:05\r\n15/JULIO/2020 HYDRAFACIAL LUCY ENTRO 12:50\r\n19/NOV/2020 PROMOCION TRAT. BOTANICO ARLETH ENTRO 5:10\r\n12/JULIO/2022 LIMPIEZA FACIAL BASICA ROSY ENTRO 3:15  MEGA        (NO QUISO MASAJE EN LA ESPALDA PORQUE LLEVAVA PRISA)\r\n17/OCTUBRE/2022 LIMPIEZA FACIAL BASICA ROSY ENTRO 6:10 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-17 13:41:43', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('103', 'C-100103', '', 'HORACIO LUQUE CANO', '4.6E+11', '', '21/agosto/17 promocion descance las lineas del tiempo y deo de cejas anita entro 5:45', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('104', 'C-100104', '', 'YIRA GRAU HERNANDEZ', '9931651616', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('105', 'C-100105', '', 'CLAUDIA DOLORES CHAVEZ MALDONADO', '9931651616', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('106', 'C-100106', '', 'CARLOS DAGDUG NAZUR', '9933180650', '', '20/oct/07 mdm full relax marcela entro 10:00\r\n12/abril/08 mdm geotermal odet entro 9:35 \r\n19/abril/08 mdm geotermal odet entro 10:05 \r\n17/junio/08 mdm marcela entro 4:00 salio 5:00\r\n21/junio/08 mdm. lucy entro 10:50\r\n9/agosto/08 mdm completo araceli entro 9:35 \r\n16/agosto/08 mdm completo araceli entro 9:00 salio 10:05 \r\n11/oct/08 mdm geotermal julia entro 10:05 \r\n4/sept/10 mdm completo mariana entro 9:15\r\n09/oct/10mdm sensorelax karina entro 10:05\r\n23/oct/10 mdm sensorelax gladys entro 10:00 \r\n11/ene/11 mdm sensorelax gladys entro 9:53 \r\n18/ene/11 mdm geotermal ofelia entro 9:45 \r\n22/ene/11 mdm geotermal sara entro 9:00 \r\n29/ene/11 mdm geotermal reyna entro 9:17\r\n5/feb/11 mdm geotermal mariana entro 9:34\r\n16/feb/11 mdm sensorelax araceli entro 9:35 \r\n8/abril/11 mdm sensorelax susy entro 10:00\r\n4/julio/11 mdm sensorelax karina entro 11:35\r\n13/agosto/11 mdm aromas(lavanda) sara entro 10:00\r\n23/agosto/11 mdm aromas(vainilla y chocolate) aracely entro 9:35 \r\n12/sept/11 mdm sensorelax sara entro 2:05\r\n19/sep/11 msensorelax karina entro 3:00\r\n05/nov/11 sensorelax karina entro 9:10\r\n1/dic/11 mdm desincrustante reyna entro 9:05\r\n9/marzo/12 mdm drenaje linfatico aracely entro 9:05\r\n20/julio/12 mdm geotermal mariana entro 5:00\r\n21/agosto/12 mdm geotermal araceli entro 9:25\r\n25/agosto/12 mdm geotermal araceli entro 9:35\r\n29/oct/12 mdm geotermal karina entro 8:40\r\n26/marzo/13 mdm drenaje linfatico 80 m rosy entro 8:35\r\n21/mayo/13 mdm sensorelax mariana entro 9:00\r\n26/agosto/13 mdm descontracturante yusiria entro 9:05\r\n4/ene/14 mdm geotermal nelli entro 9:25\r\n17/mayo/14 mdm sensorelax yusiria entro 10:00\r\n10/junio/14 mdm sensorelax nelli entro 9:05\r\n17/sept/14 mdm sensorelax brenda entro 9:10\r\n06/nov/14 mdm descontracturante johany entro 9:00\r\n1/dic/14 mdm descontracturante lucero entro 8:55\r\n22/dic/14 mdm descobtracturante johany entro 9:00\r\n31/marzo/15 mdm descontracturante maribel entro 9:05\r\n14/abril/15 mdm descontracturante carmen entro 9:10\r\n22/junio/15 mdm quirogolf mariana entro 9:10\r\n04/agosto/15 mdm descontracturante graciela entro 9:30\r\n10/agosto/15 mdm geotermal graciela entro 9:30\r\n27/Agosto/15 mdm quirogolf mariana entro 9:30\r\n8/sept/15 mdm quiroglof ofelia entro 9:25\r\n21/sept/15 mdm descontracturante candy entro 8:50\r\n5/oct/15 mdm descontracturante eva entro 9:50\r\n23/nov/15 masaje descontracturante graciela entro 8:45\r\n3/dic/15 masaje descontracturante mariana entro 9:00\r\n28/dic/15 masaje quirogolf (vale regalo) candy entro 8:45\r\n5/feb/16 mdm descontracturante carmen entro 9:00\r\n2/mayo/16 mdm descontracturante mariana entro 8:30\r\n16/mayo/16 mdm descontracturante mariana entro 9:20 \r\n10/junio/16 mdm quirogolf mirena entro 9:05\r\n20/junio/16 masaje quirogolf mariana entro 9:15\r\n25/julio/16 masaje quirogolf lucy entro 9:10\r\n5/oct/16 mdm descontracturante maria entro 10:05\r\n8/nov/16 masaje descontracturante charito entro 9:15\r\n4/SEPT/18 MDM DESCONTRACTURANTE OFELIA ENTRO 3:30\r\n11/SEPT/18 MDM DESCONTRACTURANTE LUPITA ENTRO 4:15\r\n8/ENE/19 MDM DESCONTRACTURANTE REYNA ENTRO 2:00\r\n22/ENERO/19 MASAJE DESCONTRACTURANTE LUPITA ENTRO 4:55\r\n9/MARZO/2022 MASAJE FULL RELAX MARIANA ENTRO 3:00\r\n23/MARZO/2022 MASAJE DESCONTRACTURANTE SUSY ENTRO 1:50\r\n31/MARZO/2022 MASAJE FULL RELAX MIRENA ENTRO 2:05\r\n6/ABRIL/2022 MASAJE DESCONTRACTURANTE SUSY ENTRO 2:00\r\n13/ABRIL/2022  MASAJE DESCONTRACTURANTE LUCY ENTRO 3:00\r\n19/ABRIL/2022 MASAJE DECONTRACTURANTE MIRENA ENTRO 4:00\r\n3/MAYO/2022 MASAJE DESCONTRACTURANTE LUCY ENTRO 2:00\r\n7/MAYO/2022 PROMOCION TRAT FITO HIDRATANTE SUSY ENTRO 10:00\r\n12/MAYO/2022  MASAJE DESCONTRACTURANTE  MARIANA ENTRO 3:00\r\n18/MAYO/2022 MASAJE FULL RELAX  SUSY ENTRO 2:00\r\n23/MAYO/2022 MASAJE DESCONTRACTURANTE SUSY ENTRO 3:00\r\n31/MAYO/2022 MASAJE DESCONTRACTURANTE SUSI\r\n8/JUNIO/2022 MASAJE DESCONTRACTURANTE MARIANA ENTRO 3:00\r\n14/JUNIO/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 2:00 \r\n23/JUNIO/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 3:05\r\n27/JUNIO/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 2:55\r\n4/JULIO/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 2:05 \r\n13/JULIO/2022 MASAJE DESCONTRACTURANTE JOHANY ENTRO 1:55\r\n19/JULIO/2022 MASAJE DESCONTRACTURANTE ARIANA  ENTRO 2:00\r\n26/JULIO/2022 MASAJE DESCONTRACTURANTE JOHANY ENTRO 1:55\r\n22/AGOSTO/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 3:00\r\n31/AGOSTO/2022 MASAJE FULL RELAX CRISTINA ENTRO 1:50\r\n7/SEPT/2022 MASAJE DESCONTRACTURANTE JHOANY ENTRO 2:50\r\n19/SEPTIEMBRE/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 2:50\r\n26/SEPTIEMBRE/2022 MASAJE DESCONTRACTURANTE CRISTINA ENTRO 2:55\r\n3/OCTUBRE/2022 MASAJE DESCONTRACTURANTE MARIANA ENTRO 2:55\r\n24/OCTUBRE/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 2:45\r\n31/OCTUBRE/2022 MASAJE DESCONTRACTURANTE JHOANY ENTRO 3:00\r\n7/NOVIEMBRE/2022 MASAJE DESCONTRACTURANTE MARIANA ENTRO 2:55\r\n14/NOVIEMBRE/2022 MASAJE DESCONTRACTURANTE MARIANA ENTRO 2:55\r\n24/NOVIEMBRE/2022 MASAJE DESCONTRACTURANTE CRISTINA ENTRO 2:05\r\n29/NOVIEMBRE/2022 MASAJE GEOTERMAL LUCY ENTRO 1:55\r\n5/DICIEMBRE/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 1:55\r\n16/DICIEMBRE/2022 MASAJE DESCONTRACTURANTE LUCY ENTRO 1:50\r\n27/DICIEMBRE/2022 MASAJE DESCONTRACTURANTE LUCY ENTRO 2:50 VALE DE REGALO\r\n3/ENERO/2023 MASAJE DESCONTRACTURANTE  MARIANA ENTRO 1:50 VALE DE REGALO \r\n16/ENERO/2023 MASAJE DESCONTRACTURANTE ARIANA ENTRO 3:00 VALE DE REGALO \r\n25/ENERO/2023 MASAJE DESCONTRACTURANTE LUCY ENTRO 2:55\r\n1/FEBRERO/2023  MASAJE DESCONTRACTURANTE  MARIANA ENTROB1:50\r\n9/FEBRERO/2023 MASAJE DESCONTRACTURANTE MARIANA ENTRO 2:10\r\n16/FEBRERO/2023 MASAJE DESCONTRACTURANTE ARIANA ENTRO 1:00\r\n21/FEBRERO/2023 MASAJE DESCONTRACTURANTE MARIANA ENTRO 1:05\r\n2/MARZO/2023 MASAJE DESCONTRACTURANTE SUSI ENTRO 2:00\r\n7/MARZO/2023 MASAJE DESCINTRCTURANTE MARIANA ENTRO 1:50\r\n16/MARZO/2023 MASAJE BOMBON FRUTOS ROJOS JHOANY ENTRO 2:55\r\n23/MARZO/2023 MASAJE DRENAJE LINFATICO SUSY ENTRO 11:00\r\n29/MARZO/2023 MASAJE DESCONTRACTURANTE SUSI ENTRO 2:00\r\n13/ABRIL/2023 MASAJE DESCONTRACTURANTE LUCY ENTRO 2:00\r\n24/ABRIL/2023 MASAJE DESCONTRACTURANTE LUCY ENTRO 1:45\r\n5/JUNIO/2023 MASAJE DESCONTRACTURANTE LUCY ENTRO 2:00\r\n14/JUNIO/2023 MASAJE DESCONTRACTURANTE ALONDRA ENTRO 2:00\r\n20/JUNIO/2023 MASAJE DRENAJE LINFATICO KARLA ENTRO 2:00\r\n28/JUNIO/2023 MASAJE DESCONTRACTURANTE KARLA ENTRO 2:55\r\n30/JUNIO/2023 PROMO TRATAMIENTO FACIAL ULTRASOUND ALONDRA ENTRO 3:00\r\n7/JULIO/2023 MASAJE DESCONTRACTURANTE KARLA ENTRO 1:10\r\n14/JULIO/2023 MASAJE DESCONTRACTURANTE JHOANY ENTRO 1:45', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-14 16:23:56', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('107', 'C-100107', '', 'ANA LETICIA GOMEZ GARCIA', '9931608014', 'psico.ale06@hotmail.com', '17/dic/15 promocion reafirmante modeladora reyna entro 10.00\r\n5/marzo/16 promocion hydratante lucy entro 10:00\r\n23/abril/16 promocion trat luxury lucy entro 9:50\r\n24/junio/16 promocion de elastine lucy entro 5:30\r\n6/agosto/16 promocion de caviar reyna entro 10:10\r\n5/ene/17 promocion desintoxicante andrea entro 11.05\r\n10/junio/17 promocion antioxidante lucy entro 11:00\r\n1/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN LUCY \r\n2/AGOSTO/19 TRATAMIENTO DE PORCELANA LUCY ENTRO 4:00\r\n29/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION ENTRO 4:40\r\n9/MARZO/20 TRATAMIENTO FACIAL RECUPERADOR LUCY ENTRO 4:05\r\n11/JUNIO/2020 PROMOCION REPARADOR ANTIEDAD LUCY ENTRO 11:00\r\n11/JULIO/2020 PROMOCION TRAT ANTIEDAD A BASE DE ALGAS LUCY ENTRO 10:20\r\n1/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD LUCY ENTRO 1:55\r\n12/NOV/2020 HYDRAFACIAL LUCY ENTRO 2:00\r\n28/ENERO/2021 TRATAMIENTO FACIAL ANTIPOLUTION LUCY ENTRO 2:10\r\n15/JUNIO/2021 PROM. TRATAMIENTO FACIAL RETINOL LUCY ENTRO 2:00\r\n17/AGOSTO/2021 PROMOCION TRATAMIENTO ORGANICO REVITALIZANTE LUCY ENTRO 3:18 \r\n26/OCT/2021 HIDRODERMOBRASION LUCY ENTRO 4:00 \r\n30/DIC/2021 PROMOCION TRAT FACE PURE LUCY ENTRO 12:00\r\n15/MARZO/2022 PROM. TRATAMIENTO FACIAL SCHOK DE COLAGENO LUCY ENTRO 5:00\r\n17/MAYO/2022 PROM. TRATAMIENTO FACIAL FITO-HIDRATANTE LUCY ENTRO 5:05\r\n29/JUNIO/2022 PROM. TRATAMIENTO YOGA FACIAL LUCY ENTRO 4:45\r\n6/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA ENTRO  LUCY ENTRO 4:00\r\n31/ENERO/2023 PROMO TRATAMIENTO FACIAL PURIFICANTE LUCY ENTRO 5:15\r\n4/ABRIL/2023 PROMO TRATAMIENTO FACIAL PLASMA MARINO LUCY ENTRO 4:00\r\n6/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND LUCY ENTRO 3:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-27 12:49:16', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('108', 'C-100108', '', 'LILIAN GOMEZ GARCIA', '9931607754', 'lgg64@hotmail.com', '5/julio/08 timexpert lucy \r\n2/agosto/08 caviar lucy entro 10:05\r\n6/sept/08 seda y perla lupita entro 9:20 \r\n11/oct/08 promocion colageno marcela entro 9:35 \r\n17/nov/08 promocion lifting de parpados araceli entro 4:00 \r\n20/dic/08 promocion vitamina c julia entro 9:25 salio 10:50 \r\n24/ene/09 promocion jalea real lupita entro 9:30 \r\n14/feb/09 micro reyna entro 8:35 salio 9:45 \r\n28/feb/09 promocion percollagen gladys entro 9:30 salio 10:40 \r\n7/marzo/09 micro sara entro 10:35 \r\n21/marzo/09 promocion spa therapy perla mary lazaro entro 10:10 \r\n29/mayo/09 promocion intensivo parpados y labios mary lazaro entro 6:05 \r\n27/junio/09 promocion white line mary entro 9:20\r\n11/julio/09 promocion extraperformance araceli entro 9:30\r\n15/agosto/09 promocion revitalizante bety entro 9:15 \r\n12/sept/09 promocion termico de azuleno marina entro 9:30\r\n17/oct/09 promocion hidronutritivo karina entro 9:10\r\n16/nov/09 promocion reestructurante sara entro 9:10\r\n12/dic/09 promocion flash beaute gladys entro 11:00\r\n6/feb/10 promocion estimulante de endorfinas sara entro 11:20 \r\n15/marzo/10 promocion de cristal gladys entro 9:35\r\n23/abril/10 promocion 3 geles lucy entro 3:50 \r\n29/julio/10 promocion relajante e hidratante lucy entro 3:00\r\n30/agosto/10 promocion antiarrugas marina entro 4:10 \r\n17/sept/10 promocion termico araceli entro 8:30 \r\n30/oct/10 promocion efecto botox sara\r\n22/nov/10 promocion modeladora sara entro 3:57 \r\n8/ene/11 promocion porcelana mary lazaro entro 10:30\r\n5/feb/11 masaje de espalda, promocion trat. de seda susy entro 9:55 \r\n6/mayo/11 promocion botanico reyna entro 9:30\r\n6/junio/11 promocion estimulante de endorfinas araceli entro 4:30\r\n8/agosto/11 promocion piel de seda lucy entro 4:50\r\n22/oct/11 promocion relajante reyna entro 9:20\r\n3/marzo/12 promocion hidradermis karina entro 9:00\r\n10/marzo/12 carbo, termoslin rosy entro 11:30\r\n12/marzo/12 carbo, laser lipolitico rosy entro 8:10\r\ncarbo, laser lipolitico pagado 14/marzo/12 rosy entro 8:00\r\ncarbo, laser lipolitico pagado 16/marzo/12 rosy entro 8:00\r\n17/marzo/12 carbo, termoslin rosy entro 11:15\r\n19/marzo/12 carbo, laser lipolitico rosy\r\n21/marzo/12 carbo, laser lipolitico rosy entro 7:55\r\n23/marzo/12 carbo, laser lipolitico rosy entro 8:00\r\n24/marzo/12 carbo, termoslin rosy entro 9:20\r\n26/marzo/12 carbo, laser lipolitico no quizo el masaje gladys entro 8:05\r\n28/marzo/12 carbo, laser lipolitico, masaje 20 m rosy entro 8:00\r\n30/marzo/12 carbo, laser lipolitico, masaje 20 m rosy entro 8:02\r\n26/mayo/12 promocion velo de colageno aracely entro 9:00\r\n14/julio/12 promocion hidratante de arroz gladys entro 1:10\r\n18/agosto/12 promocion hidratante y reafirmante reyna entro 12:00\r\n22/sept/12 promocion de agave gladys entro 9:50\r\n24/nov/12 promocion de colageno araceli entro 11:00\r\ninicia ipl $1000.00 c/s\r\n24/nov/12 1ra. ipl lucy\r\n22/dic/12 promocion de oro sara entro 9:30\r\n22/dic/12 2da. ipl prog. 2 int 5 lucy\r\n26/ene/13 promocion lifting de parpados reyna entro 9:25\r\n26/ene/13 3ra. ipl prog. 2 int. 5 reyna\r\n16/feb/13 promocion catiodermia gladys entro 9:00\r\n16/feb/13 4ta. ipl prog. 2 int. 5 lucy\r\n16/marzo/13 promocion royal jelly nelli entro 9:20\r\n16/marzo/13 5ta. ipl prog. 2 int.5 lucy entro 10:50\r\n20/abril/13 promocion porcelana yusiria entro 9:20\r\n20/abril/13 6ta. ipl \r\n18/mayo/13 promocion relajante e hidratante mariana entro 9:00\r\n18/mayo/13 7ta. ipl prog. 2 int. 5 rosy\r\n19/junio/13 promocion coco y mango gladys entro 9:15\r\n19/junio/13 8ta. ipl prog. 2 int. 5 rosy entro 10:30\r\n20/julio/2013 promocion de colageno y elastine entro 10.20\r\n17/agosto/13 promocion oxigenante reyna entro 9:30\r\n25/sept/13 promocion lifting antiarrugas gladys entro 9:40\r\n19/oct/13  promocion del mes the verde reyna entro 9:20\r\n21/nov/13 promocion intensivo antiestres reyna entro 5:00\r\n20/dic/13 promocion de oro reyna entro 9:20\r\n18/ene/14 promocion desintoxicante susy entro 9:00\r\n18/feb/14 promocion eternamente joven susy entro 11:50\r\n15/marzo/14 promosion humectante lucy entro 10:15\r\n22/abril/14 promocion de lim de porcelana lucy entro 11:00\r\n18/julio/14 promocion de colageno reyna entro 11:20\r\n15/agosto/14 promocion oxigenante reyna entro 10:10\r\n15/agosto/14 radiofrecuencia reyna\r\n25/sept/14 promocion trat facial azteca reyna entro 10:00\r\npaquete de promocion de criolipolisis y carbo $4000.00 abono $2000.00 resta $2000.00\r\n1.-27/sept/14 criolipolisis en abdomen carmen \r\n2.-carbo 29/sept/14 ana\r\n3.-carbo 1/oct/14 reyna\r\n4.-carbo 3/oct/14 yusiria\r\n5.-carbo 05/oct/14 martha mega\r\n6.-carbo 7/oct/14 ana entro 5:35\r\n7.-carbo 09/oct/14 carmen entro 5:00\r\n8.-carbo 13/oct/14 mirena entro 5:20\r\n9.-carbo 15/oct/14 mirena entro 5:40 termino de pagar paq. de promocion de criolipolisis y carbo \r\n10.-carbo 18/oct/14 martha entro 4:35 (mega)\r\n11.-carbo 20/oct/14 nelly entro 10:20 (mega)\r\n12.-carbo 23/oct/14 reyna entro 9:40\r\n23/oct/14 promocion trat smoothie reyna entro 9:40\r\n13.-carbo 26/oct/14 martha entro 12:05 (mega)\r\n14.-criolipolisis 27/oct/14 ana entro \r\n8/octubre/14 criolipolisis en espalda atendio lucero entro 4:30\r\n7/nov/14 criolipolisis en espalda mirena entro 9:30\r\n13/nov/14 promocion trat antiedad humectante y nutritivo ofelia entro 9:35 llevo crema cuello y\r\nescote de timexpert lift\r\n20/dic/14 promocion trat. global antiedad reyna entro 9:55\r\n31/enero/15 promocion trat desintoxicante y oxigenante reyna entro 10:05\r\n20/febrero/15 promocion tratamiento reafirmante reyna entro 10:00\r\n25 marzo 2015  promocion del mes lucy 10-15\r\n18/abril/15 promocion tratamiento de porcelana reyna entro 9.50\r\n20/abril/15 mdm full relax (cliente frecuente) reyna entro 4:40\r\n28/mayo/15 promocion de catiodermia lucy entro 10:05\r\n06/julio/15 promocion trat de cuello reyna entro 4:45\r\n23/julio/15 mdm full relax (cliente frecuente) reyna entro 10:00\r\n06/agosto/15 promocion chocoterapia lucy entro 10:55\r\n3/sept/15 promocion equilibrante ph reyna entro 11:00\r\n1/oct/15 promocion reafirmante lucy entro 10.35\r\n12/nov/15 promocion antiedad reyna entro 10:45\r\ninicia tratamiento de IPL\r\n12/nov/15 1ra. ipl prog. 2 int. 3 reyna llevo heliocare compacto y heliocare gel\r\n10/dic/15 promocion reafirmante modeladora reyna entro 10:10\r\n10/dic/15 ipl  progra 2 int-5 reyna\r\n21/enero/16 promocion trat desintoxicante lucy entro 10:45\r\n21/enero/16 3ra. IPL prog. II int. 5 lucy entro 12:15\r\n11/feb/16 promocion roll & lift lucy entro 10:25 \r\n11/feb/16 ipl 4ta ipl progra 2 int-5 lucy\r\n17/marzo/16 promocion hydratante e ipl progr-2 int-3 lucy entro 11:00\r\n14/abril/16 promocion trat luxury lucy entro 10.20\r\n14/abril/16 ipl progra-1 int-5 lucy\r\n19/abril/16 btx 1/3 dr. oscar garcia\r\n13/mayo/16 promocion colageno lucy \r\n13/mayo/16 ipl prog. 1 int. 5 lucy\r\n16/junio/16 promocion de elastine lucy entro 10:50\r\n16/junio/16 ipl progra-1 int-5 lucy\r\n27/agosto/16 promocion de caviar lucy entro 11:15\r\n22/sept/16 promoción de colageno lucy entro 11:00\r\n22/oct/16 promocion de colageno lucy entro 10:05\r\n10/nov/16 promocion oxigenante lucy entro 11:00\r\n5/ene/17 promocion desintoxicante lucy entro 11:05\r\n9/feb/17 promocion trat de elastine lucy entro 11:20\r\n13/feb/17 masaje fullr elax (cliente frecuente) lucy entro 11:00\r\n2/marzo/17 promocion estimulante de colageno con masc led lucy entro 4:45\r\n6/abril/17 promocion termico lucy entro 12:10\r\n18/mayo/17 promocion antiedad con lifting lucy entro 4:00\r\n15/junio/17 mdm full relax cliente frecuente, promocion antioxidante lucy entro 11:05\r\n13/julio/17 promocion trat relajante e hidratante lucy entro 12.00\r\n10/julio/17 promocion desvanece las lineas del tiempo  lucy entro 11:05\r\n12/dic/17 promocion trat gold lucy entro 11:50\r\n27/01/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO LUCY\r\n28/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO  LUCY ENTRO 10:50\r\n25/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE LUCY ENTRO 2:35\r\n9/MAYO/18 RADIO FRACCIONADA OFELIA ENTRO 12:00\r\n12/MAYO/18 INICIA TRATAMIENTO DE CARBOXITERAPIA ((((PAGADO 2,500)))\r\n1.- CARBOX  12/MAYO/18 MARY\r\n2.- CARBOX  15/MAYO/18 LUCY ENTRO 11:15\r\n16/MAYO/18 RADIO FRACCIONADA  OFELIA ENTRO 10:20\r\n3.- CARBOX  18/MAYO/18 LUCY  ENTRO 6:00\r\n4.- CARBOX  21/MAYO/18 OFELIA ENTRO 4:15\r\n5.- CARBOX  23/MAYO/18 LUCY ENTRO 11:00\r\n6.- CARBOX  25/MAYO/18 LUCY ENTRO 4:10\r\n7.- CARBOX   29/MAYO/18  LUCY ENTRO 9:40\r\n8.- CARBOX   31/MAYO/18 OFELIA\r\n2/JUNIO/18 RADIO FRACCIONADA OFELIA ENTRO 11:30\r\n9.- CARBOX  2/JUNIO/18 ANITA ENTRO 1:10\r\n10.- CARBOX  6/JUNIO/18 ANITA ENTRO 12:20\r\n11.- CARBOX  8/JUNIO/18 MARY\r\n12.- CARBOX  11/JUNIO/18 LUCY\r\n14/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE LUCY\r\n13.- CARBOX  14/JUNIO/18 LUCY ENTRO 4:15\r\n19/JUNIO/18 RADIOFRECUENCIA FRACCIONADA OFELIA ENTRO 1:00\r\n14.- CARBOX   18/JUNIO/18 ANITA\r\n15.- CARBOX   20/JUNIO/18 OFE ENTRO 10:45\r\n16.- CARBOX  22/JUNIO/18 LUCY ENTRO 4:;20\r\n17.- CARBOX  25/JUNIO/18 LUCY \r\n18.- CARBOX  28/JUNIO/18 LUCY ENTRO 11:55\r\n19.- CARBOX   30/JUNIO/18 ANITA ENTRO 11:55\r\n20.- CARBOX  4/JULIO/18 LUCY ENTRO 4:35\r\n26/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL  LUCY\r\n26/JULIO/18  LIPOSONIX    16  DISPAROS    50 J  LUCY\r\n27/JULIO/18 LIMPIEZA CAPILAR HIDRATANTE  ANITA\r\n23/AGOSTO/18 16 DISPAROS DE LIPOSONIX 50 J  LUCY\r\n28/AGOSTO/18 PROM TRATAMIENTO FACIAL LUCY ENTRO 10:25\r\n28/SEP/18 10 DISPAROS DE LIPOSONIX 50 J LUCY\r\n26/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE LUCY\r\n30/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN Y LIMPIEZA CAPILAR LUCY\r\n15/DIC/18 PROM TRATAMIENTO FAICAL DIAMANTE LUCY ENTRO 10:45\r\n24/ENERO/19 PROMOCION REVITALIZANTE LUCY ENTRO 11:50\r\n23/FEBRERO/19 PROM TRATAMIENTO FACIAL REAFIRMANTE LUCY ENTRO 10:35\r\n21/MARZO/19 PROM TRATAMIENTO FACIAL DETOZ LUCY\r\n23/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE LUCY ENTRO 11:00\r\n27/JUNIO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO ANTIEDAD LUCY ENTRO 11:00\r\n30/JULIO/19 TRATMIENTO FACIAL DE COLAGENO HIDROLIZADO LUCY\r\n30/JULIO/19 MDM FULL DE CLIENTE FRECUENTE  ALE\r\n29/AGOSTO/19 PROMOCION PORCELANA LUCY ENTRO 11:35\r\n26/SEPT/19 PROMOCION OXIGENANTE LUCY ENTRO 11:45\r\n24/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION LUCY ENTRO 1:30\r\n21/NOVIEMBRE/19 4HPDO CK C/W4 12,000.00 DR OSCAR\r\n28/DIC/19 PROMOCION TRAT 24 K LUCY ENTRO 11:00\r\n12/MARZO/2020 PROMOCION TRAT RECUPERADOR FACIAL LUCY ENTRO 10:50\r\n11/JUNIO/2020 PROMOCION REPARADOR ANTIEDAD LUCY ENTRO 12:00\r\n23/JULIO/2020 TRATAMIENTO ANTIEDAD A BASE DE ALGAS  LUCY ENTRO 11:55\r\n24/SEPT/2020 PROMOCION TRAT REVITALIZANTE LUCY ENTRO 4:00\r\n11/NOV/2020 HYDRAFACIAL LUCY ENTRO 11:40\r\n30/NOVIEMBRE/2020 TRATAMIENTO FACIAL BOTANICO  LUCY\r\n30/DIC/2020 PROMOCION TRAT PORCELANA LUCY ENTRO 12:00\r\n28/ENERO/2021 TRATAMIENTO FACIAL ANTIPOLUTION LUCY ENTRO 11:55\r\n27/FEB/2021 PROM. TRATAMIENTO FACIAL PEEL OFF LUCY ENTRO 12:00\r\n22/ABRIL/2021 PROM. TRATAMIENTO FACIAL VITAMINA C LUCY ENTRO 11:50\r\n19/JUNIO/2021 PROM. TRATAMIENTO FACIAL RETINOL LUCY ENTRO 11:00\r\n12/AGOSTO/2021 RADIOFRECUENCIA FACIAL LUCY ENTRO 11:00 \r\n13/OCTUBRE/2021 PROMOCION TRATAMIENTO ORGANICO CBD LUCY ENTRO 3:00\r\n10/NOV/2021 RADIOFRECUENCIA FACIAL  LUCY\r\n10/NOVIEMBRE/2021 INICIO TRATAMIWNTO DE CARBOX COSTO 2500.00 PAGADO\r\n 1.- CARBOX 10/NOVIEMBRE/2021 LUCY ENTRO 1:00 \r\n2.-  CARBOX 13/NOVIEMBRE/2021 LUCY ENTRO 2:50 \r\n3.- CARBOX 15/NOVIEMBRE/2021  LUCY\r\n18/NOVIEMBRE/2021 PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO LUCY\r\n4.- CARBOX 18/NOVIEMBRE/2021 LUCY\r\n5.- CRBOX 20/NOVIEMBRE/2021 LUCY ENTRO 11:45\r\n6.- CARBOX 23/NOVIEMBRE/2021 LUCY ENTRO 12:05\r\n7.- CARBOX 29/NOVIEMBRE/2021 LUCY\r\n8.- CARBOX 2/DICIEMBRE/2021 LUCY\r\n9.- CARBOX 6/DIC/2021 LUCY ENTRO 12:00\r\n10.- CARBOX 8/DIC/2021 LUCY \r\n11.- CARBOX 11/DICIEMBRE/2021 LUCY\r\n12.- CARBOX 16/DICIEMBRE/2021 LUCY\r\n13. CARBOX 18/DIC/2021 LUCY\r\n14.- CARBOX 21/DICIEMBRE/2021 LUCY\r\n15.- CARBOX 22/DICIEMBRE/2021 LUCY\r\n16.- CARBOX 28/DIC/2021 LUCY ENTRO 6:00\r\n17.- CARBOX 30/DIC/2021 LUCY ENTRO 6:00\r\n18.- CARBOX 3/ENERO/2022 LUCY ENTRO 4:00\r\n19.- CARBOX 15/ENERO/2022 LUCY ENTRO 2:40\r\n20.- CARBOX 17/ENERO/2022 LUCY ENTRO 6:30\r\n29/NOVIEMBRE/2021 RADIOFRECUENCIA FACIAL LUCY\r\n18/DIC/2021 PROMOCION TRAT FACE PURE LUCY ENTRO 12:00\r\n20/ENERO/2022 PROM. TRATAMIENTO FACIAL DETOX LUCY ENTRO 11:00\r\n24/ENERO/2022 MASAJE REDUCTIVO CLIENTE FRECUENTE LUCY ENTRO 10:45\r\nINICIA MASAJE REDUCTIVO $4,000.00 PAGADO\r\nCON MEDIDA CINTURA 85 CM, CADERA ALTA 101 CM PESO 67 1/2 KG\r\n1.-MASAJE 45 M 26/ENERO/2022 LUCY ENTRO 12:00\r\n2.-MASAJE 45 M 27/ENERO/2022 LUCY ENTRO 12:00\r\n3.-MASAJE 45 M 28/ENERO/2022 LUCY ENTRO 11:50\r\n4.-MASAJE 45 M 31/ENERO/2022 LUCY ENTRO 12:00\r\n5.-MASAJE 45 M 1/FEB/2022 LUCY ENTRO 11:30\r\n6.-MASAJE 45 M  2/FEBRERO/2022 LUCY ENTRO 11:45\r\n7.-MASAJE 45 M 3/FEB/2022 LUCY ENTRO 12:00\r\n8.-MASAJE 45 M 7/FEB/2022 LUCY ENTRO 11:50\r\n9.-MASAJE 45 M 2/MARZO/2022 LUCY ENTRO 12:00\r\n10.-MASAJE 45 M  4/MARZO/2022 LUCY ENTRO 11:05\r\n11.-MASAJE 45 M 7/MARZO/2022 LUCY ENTRO 11:55\r\n7/ABRIL/2022 PROMOCION TRAT CINETICO LUCY ENTRO 11:10\r\n7/ABRIL/2022 8 DISPAROS DE LIPOSONIC LUCY\r\n18/MAYO/2022 8 DISPAROS DE LIPOSONIC LUCY ENTRO 12:50\r\n21/MAYO/2022 PROM. TRATAMIENTO FACIAL FITO-HIDRATANTE LUCY ENTRO 11:55\r\n11/AGOSTO/2022 PROMOCION TRAT FACIAL ANTIOXIDANTE LUCY ENTRO 11:55\r\n3/SEPTIEMBRE/2022 PROM. TRATAMIENTO FACIAL PREVENTIVO MANCHAS LUCY ENTRO 11:45\r\n1/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL PREVENTIVO DE OBSIDIANA  LUCY ENTRO 11:00\r\n17/NOVIEMBRE/2022 PROMOCION TRAT. FACIAL REPARACION CELULAR LUCY ENTRO 11:40\r\n15/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN LUCY ENTRO 11:05\r\n2/FEBRERO/2023 PROMOCION TRAT. FACIAL ELIXIR DE JUVENTUD LUCY ENTRO 12:45\r\n16/MARZO/2023 PROMOCION TRAT. FACIAL MICRODERMA ANTIEDAD LUCY ENTRO 10:00\r\n12/MAYO/2023 PROMO TRATAMIENTO FACIALMAGIC FACE LUCY ENTRO 10:45\r\n29/JUNIO/2023 PROMO TRATAMIENTO FACIAL ULTRASOUND LUCY ENTRO 11:20', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-01 13:04:31', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('109', 'C-100109', '', 'ANA ZURITA FERNANDEZ', '9931604791', '', '18/marzo/16 mdm combo andrea entro 10:10 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('110', 'C-100110', '', 'LETICIA PEREZ', '', '', '29/NOVIEMBRE/19 LIMPIEZA FACIAL PROFUNDA ROSI ENTRO 4:05 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('111', 'C-100111', '', 'RUBI SUAREZ MORALES', '9932426089', '', '1.-v f 45m 12 dic/15 fernanda entro 10:00\r\n2.-V F45M 14/dic/15 fernanda entro 1:15\r\n3.-V F45M 15/dic/15 fernanda entro 1:30\r\n4.-V F45M 16/dic/15 fernanda entro 4:10\r\n5.-V F45M 22/dic/15 andre anetro 2:50\r\n6.-V F45M 23/dic/15 mariana entro 8:30\r\n7.-V F45M 7/ene/16 lizvet entro 8:15\r\n8.-V F45M\r\n9.-V F45M\r\n10.-V F45M\r\n6/JULIO/18 INICIA TRATAMIENTO REDUCTIVO  \r\n 6/JULIO/18  CAPSULA SRA BEGO\r\n 9/JULIO/18 CORPO LUCY ENTRO 3:30\r\n1.- VENDAS FRIAS   10/JULIO/18  SRA BEGO\r\n2.-VENDAS FRIAS    12/JULIO/18  LUCY ENTRO 9:00\r\n3.- VENDAS FRIAS   13/JULIO/18 LUCY ENTRO 9:05\r\n4.- VENDAS FRIAS   16/JULIO/18 MARY ENTRO 9:05\r\n5.- VENDAS FRIAS   17/JULIO/18 MARY\r\n13/JULIO/18 PAGÓ TRATAMIENTO DE VF COSTO 1,500 Y PAGO 2 TRATAMIENTO CÁPSULA Y CORPO\r\n3/OCT/18 INICIA TRATAMIENTO DE VENDAS COSTO 3,000\r\n21/NOV/18 ABONO 1,500 DEBE 1,500\r\n1.-  CARBOX, VF  3/OCT/18 MARY\r\n2.- VF 40M             4/OCT/18 MARY ENTRO 5:50\r\n3.- CARBOX, VF   5/OCT/18 REYNA ENTRO 12:30\r\n4.- VF 40M  12/NOV/18 MONICA-CARMEN\r\n5.- CARBOX, VF 13/NOV/18 MARY ENTRO 1:10\r\n6.- VF 40M   14/NOV/18 OFELIA ENTRO 12:05\r\n7.- CARBOX, VF 20/NOV/18 SARAI ENTRO 1:10\r\n8.- VF 40M\r\n9.- CARBOX, VF\r\n10 VF 40M\r\n17/ENERO/19 PAGO LAS SESIONES QUE DEBIA. YA NO DEBE NADA\r\n17/AGOSTO/2020 PLANCHADO DE CEJAS OFELIA ENTRO 12:00\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('112', 'C-100112', '', 'DIANA PATRICIA HERNANDEZ GORDILLO', '9931323242', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('113', 'C-100113', '', 'GELMA GUADALUPE CASTELLANO AGUILAR', '9931136928', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('114', 'C-100114', '', 'DORA MARIA DE LA CRUZ GARCIA', '9331025809', '', '18/nov/15 limpieza facial 2x600 graciela entro 4:00\r\n23/dic/15 limpieza facial maria entro 2:50\r\n30/nov/16 limpieza facial 2x500 ofelia entro 4:10\r\n6/sept/17 limpieza facial 2x600 anita entro 3:20\r\n28/MARZO/18 LIMPIEZA FACIAL 2 X 600 REYNA ENTRO 12:00\r\n8/AGOSTO/18 LIMPIEZA FACIAL 2 X 600  LUPITA ENTRO 4:00\r\n9/OCT/19 LIMPIEZA FACIAL 2 X 600 MARY LAZARO ENTRO 4:00\r\n19/OCTUBRE/19 MDM FULL RELAX OFELIA ENTRO 11:00\r\n16/JULIO/2021 LIMPIEZA FACIAL 2 X 600 ARLETH ENTRO 10:10\r\n10/DIC/2021 LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 12:20\r\n21/DICIEMBRE/2022 LIMPIEZA FACIAL2 X 600 LUCY ENTRO 10:15', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-20 15:01:47', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('115', 'C-100115', '', 'CARMEN ALEIDA OCAMPO ROCHA', '9932687985 9931941834', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('116', 'C-100116', '', 'JOSE RICARDO MURILLO ORTEGA', '9933946934', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('117', 'C-100117', '', 'SUSANA PALOMERA CANO', '', '', 'INICIA RADIOFRECUENCIA FACIAL $1500.0 CADA SESION\r\n11/ene/16 radio facial mariana entro 2:25\r\n18/ene/16 radio facial reyna entro 4:20\r\n25/ene/16 radio facial reyna entro 4.00\r\n1/feb/16 radio facial reyna entro 4;:00\r\n9/feb/16 radio facial mariana entro 4:00\r\n19/feb/16 radio facial mariana entro 4:05\r\n29/feb/16 radio facial  lucy entro 4:05\r\n7/marzo/16 radio facial mariana entro 4:00\r\n1/nov/17 limpieza facial monica entro 6:00\r\n3/nov/17 radiofrecuencia facial lucy entro 4:00\r\n26/ABRIL/2022 MASAJE COMBO SUSI ENTRO 5:00\r\n1/JUNIO/2022 MASAJE FULL RELAX JHOANY ENTRO 6:00 (VALE DE REGALO)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('118', 'C-100118', '', 'EMMA ZUBIRI FLORES', '9331297853', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('119', 'C-100119', '', 'MARIA GUADALUPE RODRIGUEZ HERNANDEZ', '9932000119', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('120', 'C-100120', '', 'GUADALUPE CHAVEZ LUNA', '9932332827', '', 'depilacion lasser de axila $360.00 cada secion\r\n1.- 3/enero/11 axila\r\n\r\ntratamiento de masaje reductivo $3000.00 pagado\r\n1.-masaje 45 m 11/ene/11 karina \r\n2.-12/ene/11 mariana entro 8:25 \r\n3.-13/ene/11 mariana entro 8:20\r\n4.-14/ene/11 mariana entro 9:00\r\n5.-17/ene/11 sara \r\n6.-18/ene/11 mariana\r\n7.-19/ene/11 araceli\r\n8.-20/ene/11 mariana\r\n9.-24/ene/11 gladys entro 1:30\r\n10.-25/ene/11 susy \r\ntermino tratamiento\r\n\r\n\r\ntratamiento de masaje reductivo $3000.00 pagado.\r\n1.-masaje 45 m 27/ene/11 susy entro 4:23 \r\n2.-28/ene/11 susy entro 9:10\r\n3.-31/ene/11 susy entro 10:30 (sucursal) \r\n4.-1/feb/11 susy entro 10:35 (sucursal) \r\n5.-7/feb/11 susy \r\n6.-9/feb/11 susy entro 3:00\r\n7.-masaje 45 m 9/marzo/11 susy entro 10:00\r\n\r\ntratamiento de celulitis $7000.00 \r\nabono $3500.00 resta $3500.00\r\n1.-dermosonic 3/ene/11 mariana \r\n2.-cavitacion 4/ene/11 mariana \r\n3.-lumicell 6/ene/11 mariana entro 10:54 \r\n4.-aspired 40 m 8/ene/11 mariana entro 10:25\r\n5.-radio 40 m 10/ene/11 \r\n6.-dermosonic 12/ene/11 mariana entro 8:25\r\n7.-lumicell 11/ene/11 gladys\r\n8.-aspired 40 m 13/ene/11 mariana \r\n9.-radio 40 m 14/ene/11 mariana \r\n10.-dermosonic 17/ene/sara\r\n11.-lumicell 18/ene/11 mariana entro 2:45\r\n12.-aspired 40 m 19/ene/11 araceli entro 10:00\r\n13.-radio 40 m 20/ene/11 mariana entro 8:52\r\n14.-dermosonic 24/ene/11 gladys\r\n15.-lumicell 25/ene/11 susy entro 1:45\r\n16.-aspired 40 m 27/ene/11 susy \r\n17.-radio 40 m 28/ene/11 sara\r\n18.-dermo 31/ene/11 karina\r\n19.-lumicell 1/feb/11 araceli\r\n20.-aspired 40 m 7/feb/11 susy \r\ntermino tratamiento.\r\n500 c/3\r\n1.-8/dic/10 marina \r\n2.-10/dic/10 rosy\r\n3.-13/dic/10 lucy \r\n4.-23/dic/10 karina\r\n5.-27/dic/10 reyna \r\n6.-3/ene/11 lucy entro 4:23\r\n7.-5/ene/11 sara\r\n8 7 ene-11 sara\r\n9.-10 ene-11 sara\r\n10.-12/ene/11 karina entro 8:25\r\n11.-14/ene/11 karina\r\n12.-17/ene/11 sara\r\n13.-19/ene/11 sara entro 10:25\r\n14.-24/ene/11 gladys\r\n15.-28/ene/11 reyna entro 9:00\r\n16.-1/feb/11 karina\r\n17.-7/feb/11 karina\r\n18.-9/feb/11 rosy\r\n19.-22/feb/11 reyna\r\n20.-23/feb/11 reyna\r\n\r\n9/feb/11 promocion trat. de seda mariana entro 4:00 \r\n9/marzo/11 promocion elastine susy entro 11:00\r\n9/marzo/11 dejo abono de $3500.00 para el trat. de celulitis.\r\n6/mayo/11 hydracure karina entro 6:00\r\ninicia trat. de carboxiterapia\r\n1.-6/mayo/11 karina entro 5:55\r\n2.-9/mayo/11 carbo sara\r\n3.-11/mayo/11 carbo sara\r\n\r\n6/mayo/11 llevo crema chauffante, serum liporeductor, tonico piel seca de lendan, masc. excel therap\r\n9/mayo/11 trat. # 1 peso 104 1/2 kilos \r\n10/mayo/11 exfoliacion de cuerpo 2 x 1 araceli entro 2:10\r\n10/mayo/11 depilacion de bikini karina\r\n11/mayo/11 llevo hydragel de colageno, shampoo hidronutritivo, crema capilar hidronutritiva y \r\nmascarilla capilar hidronutritiva\r\n23/mayo/11 llevo concentrado reescultor especifico y trat. # 2 no se peso\r\n27/mayo/11 limpieza de acne con amp. desincrustante y amp. acido hialuronico, lifting # 2 mariana\r\n\r\n24/10/11 inicio carbox en matriz\r\n24/10/11  # 1 carboxi atendio sara entro 3.00  \r\n26/10/11  # 2 carbox atendio:graciela entro:1.10pm salio:1:33pm  ( mega)\r\n01/11/11  # 3 carbox atendio deyanira entro 6.25 salio 6:48 (mega)\r\n03/11/11  # 4 carbox atendio:jhoany  entro 6.45 salio 7:03 (mega)\r\n03/11/11  # 5 carbox  regalo una sesion a su amiga karla atendio:jhoany entro 7.08 salio 7:20 (mega)\r\n08/11/11  # 6 carbox atendio jhoany entro 6:53 salio 7:15 (mega)\r\n08/11/11  # 7 carbox atendio jhoany entro 7.15 regalo asu amiga karla (mega)\r\n10/11/11  # 8carbox atendio gracielaentro 2:25 salio 2:40 (mega)\r\n10/11/11  # 9 carbox atendio graciela entro 2:45 salio:2:53pm regalo asu amiga karla (mega)\r\n14/03/12 #10 carbox atendio jhoany entro 4.15 (mega)\r\n14/03/12 limp facial 2x1 atendio jhoany entro 3:00 (mega)\r\n16/03/12  carbox atendio deyanira entro 3.25 (mega)\r\n20/03/12 carbox atendio jhoany entro 7.30 (mega)\r\n23/03/12 carbox entro 7:00graciela 5:15 ( suc comer)\r\n29/03/12 carbox entro 6:00  graciela 7.05 (mega)\r\n31/03/12 carbox entro 10.00 graciela (mega)\r\n02/04/12 carbox entro 6:10 atendio jhoany mega.\r\n4/abril/12 carbo, laser lipolitico gladys entro 3:20\r\n9/abril/12 carbo, laser lipolitico sara entro 3:30\r\n11/marzo/12 carbo lucy entro 5:10 salio 5:35\r\n13/abril/12 carbo lucy\r\n16/abril/12 carbo karina\r\n19/04/12  carbox brenda entro 7:10 mega\r\n8/12/12 carbox atendio diana entro 7:55 mega\r\n10/12/12 lim. facial y carbox atendio jhoany entro 7:20 mega\r\n21/09/13 mdm 2x1 carolina mega 6:00\r\ntratamiento de promocion 2 sesiones de criolipolisis y 12 sesiones de carbo $4000.00 pagado.\r\nmedida en abdomen 125 cm, cadera alta 119 cm peso 119 kg llevo trat. # 0 dieta 13 dias\r\n1.-criolipolisis en abdomen 29/oct/13 mirena entro 8:05\r\n2.-carbo 4/nov/13 rosy entro 8:15\r\n3.-carbo 6/nov/13 mariana entro 1:55\r\n4.-carbo 9/nov/13 rosy entro 8:25\r\n5.-carbo 14/nov/13 nelli\r\n6.-carbo 20/nov/13 mariana\r\n7.-carbo no vino\r\n8.-carbo 25/nov/13 susy \r\n9.-carbo 27/nov/13 nelli entro 8:20\r\n10.-carbo 20/diciembre/15 eva  entro 11:00 (mega)\r\n11.-carbo\r\n12.-carbo\r\n13.-carbo\r\n14.-criolipolisis en abdomen\r\n04/12/13 carbo atendio marha mega entro 1:15\r\ninicia tratamiento de carbo en abdomen, piernas, brazos\r\n15/ene/14 carbo ofelia\r\n17/ene/14 carbo susy entro 6:30\r\n29/nov/14 carbo brenda entro 12:45\r\n1/dic/14 carbo lucy entro 12:15\r\n4/dic/14 carbo johany entro 3:50\r\n8/dic/14 carbo yusiria entro 5:25\r\n8/dic/14 masaje reductivo yusiria entro 5:30\r\n10/dic/14 carbo, masaje reductivo brenda entro 12:00\r\n11/dic/14 masaje reductivo lucero entro 5:50\r\n12/dic/14 carbo, masaje reductivo carmen entro 3:45\r\n13/dic/14 drenaje linfatico mariana entro 12:00 llevo crema chauffante\r\n15/dic/14 carbo, masaje reductivo carmen entro 12:00\r\n25/sept/15 carbo, masaje reductivo candy entro 2.45\r\n17/oct/15 carbo eva y masaje reductivo lzvet entro 1:00\r\n18/octubre/15 carbox y masaje reductivo susy entro 1:05 (mega)\r\n22/octubre/15 inicia tratamiento reductivo de $3000.00 pesos pago $3000.00 pesos con medidas de a.117 b.116 c.117 ca.121 cb.130 b.45 m.76 y peso de 112.500 kg. carbox $350.00 por sesion\r\n1.-masaje 45 min. carbox 22/octubre/15 susy entro 12:20 (mega)\r\n2.-masaje 45 min.  23/octubre/15 susy entro 11:20 (mega)\r\n3.-masaje 45 min.  carbox 24/octubre/15 susy entro 11:20(mega) \r\n4.-masaje 45 min. 25/octubre/15 susy entro 11:20 (mega)\r\n5.-masaje 45 min. 31/octubre/15 susy entro 11:10 (mega)\r\n6.-masaje 45 min. 01/noviembre/15 susy entro 11:05 (mega)\r\n7.-masaje 45 min. 07-11-15 SUSSY CRISTAL 6-40 CRISTAL\r\n8.-masaje 45 min.  14/NOV/15 MASAJE. SUSSY.  12:25 CRISTAL.\r\n9.-masaje 45 min. 15-11-15  masaje sussy cristal  11-40\r\n10.masaje 45 min. 16-11-15 masaje sussy cristal 11am\r\n07/noviembre/15 carbox maribel entro 6:10 (mega)\r\n14/noviembre/15 carbox eva entro 1:40 (mega) cortesia lifting por el buen fin \r\n15/noviembre/15 carbox eva entro 11:05 (mega)\r\n15-11-15 limp facial 2x1 cristal sussy 11-40\r\n16-11-15 se realizo mdm cliente frecuente cristal sussy\r\n21/NOV/15 Inicia tratamiento inicia  cavitación y masaje  1:25 SUSY. CRISTAL. ABDOMEN 115CM BUSTO 119 CM  CINTURA 115 CM CADERA ALTA 125CM  133 CM 46 CM 85 CM\r\n22-11-15 se realizo masaje reductivo cristal sussy 12pm  carbox mega eva\r\n28-11-15 se realizo masaje reductivo cristal sussy 11pm \r\n29-11-15 se realizo lmasaj reductivo cristal sussy csrbox eva mega\r\n29/noviembre/15 exfoliacion corporal maribel entro 2:45 (mega)\r\n05-12-15  se realizo masaje reductivo masaje de cliente frecuente y depilacion de bikini cristal sussy 11-20\r\n06/DICIEMBRE/2015 CARBOX EVA ENTRO 1:50 (MEGA)\r\n12/dic/15 carbox lucy\r\n12-12-15 se realizo masaje y cavitacion suss cristal  11am\r\n13-12-15 se realizo masaje reductivo cristal sussy  11pm\r\n13/diciembre/15 carbox maribel entro 5:15 (mega)\r\n20-12-15 se realizo masaje reductivo cristal sussy 11-05\r\n02-01-15 se realizo MASAJE Y CAVITACION CRISTAL SUSSY 11-20  ABDOMEN 115 BUSTO 117 CM CINTURA 112 CM 118 CM CADERA BAJA 134 CM CADERA ALTA 118CM  BRAZO 44CM MUSLO 83 CM \r\ninicia cavitacion y masaje $4000.00 pagado\r\n1.-carbox, CAVITACION 60M, MASAJE 45M 13/feb/16 carmen entro 1:30\r\n2.-MASAJE 45M, 14-febrero-2016 sussy cristal 10am  CARBOX 14/febrero/16 carbox candy entro 12:15 (mega)\r\n3.-carbo, 20/feb/16 carmen (matriz) MASAJE  45M  SUSSY CRISTAL 12PM \r\nY MASAJE DE CLIENTE FRECUENTE SUSSY CRISTAL.\r\n4.-CAVITACION 60M, MASAJE 45M 21-02-16  sussy cristal 11pm\r\n4/marzo/16 carboxiterapia carmen entro 4:15\r\n5.-MASAJE 45M, 04-03-16 martha cristal 6-20 pm\r\n6.-MASAJE 45M 06-02-16 susy cristal 11-15am\r\n7-CAVITACION 60M, MASAJE 45M 12-03-16 sussy cristal 1pm\r\n8.-MASAJE 45M, 13-03-16 SE SUSSY  CRISTAL 3-15 CARBOX \r\n9.-MASAJE 45M 19/marzo/16 maria entro 12.30 (MATRIZ)\r\n10.-CAVITACION 60M, MASAJE 45M 20-03-16  SUSSY CRISTAL 11AM\r\n06/marzo/16 carbox candy entro 12:20 (mega)\r\n13/marzo/16 carbox andrea entro 4:23 (mega)\r\n19/marzo/16 carbox, termoslim maria entro 1:30 (MATRIZ\r\n1.- 24-03-16  inicia cavitacion y masaje sussy cristal 6pm\r\n 2.- 27-03-16 masaje sussy cristal  y masaje de cliente frecuente carbox mega andrea 2pm\r\n3.-carbo,  masaje 2/abril/16 lizvet entro 10:20\r\n2/abril/16 capsula lizvet entro 12:00\r\n4.-cavitacion y masaje, carbox 03/abril/16 susy entro 11:20 (mega)\r\n5.-,masaje 16/abril/16 maria entro 11:20\r\n16/abril/16 termoslim y carbox maria\r\n6.-masaje 17/abril/16 susy entro 10:15 (mega)\r\n17/abril/16 prom. del mes con amp. acido hialuronico susy entro 10:15 (mega)\r\n7.-cavitacion y masaje 30/abril/16 maria entro 9:35\r\n30/abril/16 carbox maria\r\n8.- masaje 01/mayo/16 susy entro 10:25 (mega)\r\n9.-masaje 14/mayo/16 ofelia entro 11.20\r\n14/mayo/16 carbox, capsula ofelia\r\n10.-cavitacion y masaje 15/mayo/16 susy entro 10:20 (mega) carbox \r\n29/abril/16 capsula y carbox maria entro 4:05\r\n01/mayo/16 masaje cliente frecuente susy entro 10:25 (mega)\r\n29/mayo/16 limpieza facial y carbox susy entro 5:25 (mega)\r\n\r\nINICIA PAQUETE DE CAVITACION Y MASAJE $4000.00 PAGADO\r\n1.-CARBO, MASAJE 45M 3/junio/16 maria entro 5:40\r\n2.CAVITACION 60M, MASAJE 45M 4/junio/16 maria entro 9.35 \r\n4/junio/16 capsula maria entro 9.35\r\n3.-carbo,MASAJE 45M 24/junio/16 lizvet entrO 5:05\r\n4.-CAVITACION 60M, MASAJE 45M 26/junio/16 susy entro 10:30 (mega) Tomo carbox\r\n5.-MASAJE 45M 25/junio/16 maria entro 9:30\r\n25/junio/16 presoterapia maria\r\n6.-carbo, MASAJE 45M 01/julio/16 maria entro 5:00\r\n7.-carbo, CAVITACION 60M, MASAJE 45M 2/julio/16 rosita entro 9:20\r\n8.-MASAJE 45M 10/julio/16 susy carbox entro 4:10 (mega)\r\n9.-MASAJE 45M, carbo 16/julio/16 susy entro 10:100\r\n16/julio/6 promocion de colageno con amp. de ácido hialurónico susy\r\nquedo pendiente la ampolleta de acido hialuronico $200.00\r\n10.-CAVITACION 60M, MASAJE 45M 30/julio/16 susy entro 9:25\r\ntermino el tratamiento.\r\n30/julio/16 carbox, promocion de colageno con amp. beati 1 sus entro 11:15  \r\nya liquidó la ampolleta que estaba pendiente\r\n31/julio/16 mdm cliente frecuente y carbox andrea entro 10:30 (mega)\r\n13/diciembre/16 carbox susy entro 12:05 (mega)\r\ninicia tratamiento de cavitacion $4000.00 pesos pago $4000.00 pesos \r\n1.-masaje 45 min, cavitacion 19/diciembre/16 susy entro 11:25 (mega)\r\n2.-masaje 45 min, carbox 20/diciembre/16 susy entro 11:10 (mega)\r\n3.-masaje 45 min 21/diciembre/16 susy entro 7:15 (mega)\r\n4.-masaje 45 min cavitacion 22/diciembre/16 susy entro 3:15 (mega)\r\n5.-masaje 45 min, carbox 23/diciembre/16 susy entro 3:05 (mega)\r\n6.-masaje 45 min 26/diciembre/16 susy entro 11:30 (mega)\r\n7.-masaje 45 min, cavitacion 27/diciembre/16 susy entro 11:20 (mega) queda pendiente la cavitacion la retomara mañana.\r\n8.-masaje 45 min, carbox 29/diciembre/16 susy entro 11:10 (mega) tomo cavitacion que tenia pendiente \r\n9.-masaje 45 min 02/enero/17 susy entro 11:15 (mega)\r\n10.-masaje 45 min, cavitacion 04/enero/17 susy entro 11:10 (mega)\r\n7/ene/17 masaje drenaje linfático y promocion desintoxicante susy entro 10:05\r\n8/abril/17 carbox mariana entro 10:00\r\n8/abril/17 dejo pagado un paquete de cavitacion\r\nINICIA TRATAMIENTO DE CAVITACION Y MASAJE $4000.00 PAGADO\r\n1.-CAVITACION 60 M, MASAJE 45 M 10/abril/17 anita entro 11:10\r\n2.-CARBO, MASAJE 45 M 12/abril/17 anita entro 11:20\r\n12/abril/17 promocion termico anita entro 1:00\r\n3.-MASAJE 45 M 17/abril/17 yennifer entro 9:15\r\n17/abril/17 carbo yennifer\r\n4.-CAVITACION 60 M, MASAJE 45 M 20/abril/17 anita entro 11:15\r\n5.-CARBO, MASAJE 45 M 19/abril/17 anita entro 5:50\r\n6.-MASAJE 45 M 21/abril/17 anita entro 12:45\r\n21/abril/17 carbo anita entro 12:45\r\n21/abril/17 mdm full relax cliente frecuente monica entro 2:00\r\n7.-CAVITACION 60 M, MASAJE 45 M 22/abril/17 anita entro 11:15\r\n8.-CARBO, MASAJE 45 M 23/abril/17 carmen entro 10:00 (mega)\r\n9.-MASAJE 45 M \r\n10.-CAVITACION 60 M, MASAJE 45 M 24/abril/17 yennifer entro 10:20\r\n23/abril/17 prom. del mes trat. termico carmen entro 6:05 (mega)\r\n24/abril/17 depilacion de bikini, axila mariana\r\n--------------------\"OJO\"  LE QUEDA PENDIENTE UNA SESION DE MASAJE-------------------\r\n12/agosto/17 carbox y promocion del mes desvanece las lineas del tiempo anita entro 6:30 (mega)\r\n17/agosto/17 carbox, cavitación y masaje yeni entro 9:40\r\n18/agosto/17 carbo yeni entro 10:00\r\n\r\n18/agosto/17 mdm full relax de cliente frecuente yeni entro 10:00\r\nINICIA TRATAMIENTO DE CAVITACION $4000.00 PAGADO\r\n1.-CAVITACION 60 M, MASAJE 45 M 20/DIC/17 SUSY \r\n2.-MASAJE 45 M 21/DIC/17 SUSY\r\n22/dic/17 promocion trat gold susy\r\n3.-MASAJE 45 M   CARBO 26/12/17 OFE ENTRO 8:30\r\n4.-CAVITACION 60 M, MASAJE 45 M  27/12/17 SUSY ENTRO 10:15\r\n5.-MASAJE 45 M  28/12/17 SUSY ENTRO 10:25\r\n6.-MASAJE 45 M  02/01/18 SUSY ENTRO 10:00\r\n7.-CAVITACION 60 M, MASAJE 45 M  03/01/18 SUSY ENTRO 10:15\r\n8.-MASAJE 45 M 04/01/18 SUSY ENTRO 2:20\r\n9.-MASAJE 45 M 5/ENE/18 SUSY ENTRO 10:55\r\n10.-CAVITACION 60 M, MASAJE 45 M  06/01/18 SUSY ENTRO 8:30\r\n02/01/18 CARBOXITERAPIA SUSY ENTRP 10:00\r\n06/01/18 LLEVO CREMA SO-DELICATE\r\n21/julio/18 mdm drenaje linfatico y carbox susy entro 7:00 (mega)\r\n23/JULIO/18 MASAJE REDUCTIVO Y CARBOX  MARY ENTRO 5:30\r\n24/JULIO/18 MASAJE REDUCTIVO REYNA ENTRO 9:15\r\n25/JULIO/18 MASAJE REDUCTIVO Y CARBOX  MONICA ENTRO 12:10\r\n26/JULIO/18 MASAJE REDUCTIVO MONICA ENTRO 10:15\r\n02/noviembre/18 carbox y masaje reductivo susy entro 6:55 (mega)\r\n03/noviembre/18 carbox y masaje reductivo susy entro 7:15 (mega)\r\nINICIA TRATAMIENTO DE CAVITACION $4000.00 PAGADO\r\n1.-CAVITACION 60 M, MASAJE 45 M  27/diciembre/18 susy entro 5:55 (mega)\r\n2.-MASAJE 45 M CARBOX 29/diciembre/18 susy entro 12:15 (mega)\r\n3.-MASAJE 45 M   30/diciembre/18 susy entro 11:10 (mega) Carbox\r\n4.-CAVITACION 60 M, MASAJE 45 M  02/enero/19 susy entro 6:15 (mega)\r\n5.-MASAJE 45 M  CARBOX 03/enero/19 susy entro 6:15 (mega)\r\n6.-MASAJE 45 M 05/enero/19 susy entro 11:05 (mega)\r\n7.-CAVITACION 60 M, MASAJE 45 M  06/enero/19 susy entro 11:10 (mega)\r\n8.-MASAJE 45 M \r\n9.-MASAJE 45 M CARBOX\r\n10.-CAVITACION 60 M, MASAJE 45 M \r\n30/diciembre/18 prom. del mes trat. diamante belen entro 6:10 (mega\r\nINICIA TRATAMIENTO DE CAVITACION PAGO 2000 PESOS XQ QUIERE MEDIA SECION NADA MAS.\r\n1.- CAVITACION 60 M MASAJE 45 M 14/MARZO/19 ENTRO 5:00 MEGA\r\n2.- CORP 60 MIN Y CARB 15/MARZO/19  SUSY ENTRO 11:20 MEGA\r\n19/MARZO/19 PROMOCION DEL MES DETOX ROSY ENTRO 11:00 MEGA \r\n3.- MASAJE 45 MIN 16/MARO/19 SUSY ENTRO 4:00 MEGA\r\n4.- MASAJE Y CARBOX 04/ABRIL/19 SUSY ENTRO 4:00 MEGA\r\n5.- CAVITACION 60 MIN MASAJE 45 MIN 05/ABRIL/19 SUSY ENTRO 2:30 MEGA\r\n27/SEPT/19 CARBO, MASAJE 45 M MARIA DEL C ALEGRIA ENTRO 9:30\r\n29/sep/19 cavitacion y masaje  ale entro 6.15 mega\r\n30/SEPT/19 CARBO LUCY\r\n30/SEPT/19 MASAJE 45 M LIZBETH ENTRO 10:15\r\nINICIA TRATAMIENTO DE CAVITACION $4000.00 PAGADO\r\n28/OCTUBRE/19 MASAJE DE ESPALDA ALEGRIA \r\n1.-CAVITACION 60 M, MASAJE 45 M 28/OCT/19 MARIA DEL C ALEGRIA ENTRO 11:40\r\n2.-MASAJE 45 M 29/OCT/19 MARIA DEL C ALEGRIA ENTRO 11:10\r\n29/OCT/19 LIMPIEZA DE ESPALDA MARIA DEL C ALEGRIA ENTRO 11:10\r\n3.-MASAJE 45 M, CARBOX 1/NOV/19 MARIA DEL C ALEGRIA ENTRO 11:30\r\n4.-CAVITACION 60 M, MASAJE 45 M 2/NOV/19 JANETH ENTRO 11:15 MEGA\r\n5.-MASAJE 45 M 4/NOV/19 MARIA DEL C ALEGRIA ENTRO 9:30\r\n6.-MASAJE 45 M 6/NOV/19 SANDY ENTRO 12:00\r\n6/NOV/19 CARBO LUCY ENTRO 12:00\r\n7.-CAVITACION 60 M, MASAJE 45 M 7/NOV/19 SANDY ENTRO 10:35\r\n8.-MASAJE 45 M\r\n9.-MASAJE 45 M\r\n10.-CAVITACION 60 M, MASAJE 45 M \r\n\r\n23/ENERO/2020 LIMPIEZA FACIAL Y FULL RELAX 2X600 JANETH ENTRO 3:15 MEGA\r\n21/FEBRERO/20 CARBOXITERAPIA LUCY ENTRO 5:05\r\n25/02/2021 TRA FACIAL PEE OFF ATENDIO ROSI {MEGA\r\n26/02/2021M FULL RELAX Y LIM ESPALDA ATENDIO ROSI {MEGA}}\r\n27/MARZO/2021 CARBOXITERAPIA ANITA ENTRO 10:38\r\n24/ABRIL/2021 CARBOXITERAPIA LUCY \r\n1/MAYO/2021 CARBOX, CAVITACION, MASAJE JHOANY ENTRO 8:10\r\n27/DIC/2021 PROMO. TRAT. FACE PURE  CON AMP. BEAUTE III MONICA ENTRO 15:05 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('121', 'C-100121', '', 'WILBERT GUTIERREZ JIMENEZ', '9933180473', '', '15/JULIO/2021 MASAJE LASAI, PROMOCION TRAT. CAVIAR Y ORO MIRENA ENTRO 11:00 (VALE DE REGALO)\r\n21/ABRIL/2022 PROM. TRATAMIENTO FACIAL CINETICO Y MASAJE DE PIES JOHANY ENTRO 9:10\r\n6/OCTUBRE/2022 MASAJE FULL RELAX, PROMOCION TRAT. FACIAL DE OBSIDIANA CRISTINA 10:00', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-06 08:40:17', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('122', 'C-100122', '', 'RUTH VIDAL PEREZ', '9932425117', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('123', 'C-100123', '', 'ENRIQUE OLAN FUENTES', '9363840000', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('124', 'C-100124', '', 'VICTOR DE LA CRUZ GARCIA', '9932021754', '', '', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('125', 'C-100125', '', 'ZAYDA GEORGINA ESCALANTE', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('126', 'C-100126', '', 'ANA LAURA VASQUEZ GONZALES', '', '', '06/03/11 limp facial 2x1, atendio: jhoany. entro10:30 salio: 11:40am(suc)\r\n09/12/11 limp.facial 2x1 atendio dulce entro 3:58 salio (mega)\r\n28/09/12 lim. facial 2x1 atendio jenifer entro 6:20 mega\r\n12/01/14 lim facial 2x1 atendio anita mega entro 4:15\r\n11/02/14 lim.acne 2x1 jhoany mega 4:45 \r\n12/SEPTIEMBRE/15 LIMPIEZA FACIAL 2X1 ROSY ENTRO 6:05 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('127', 'C-100127', '', 'DIANA LAURA DOMINGUEZ GENAREZ', '9932160459', '', '14/dic/16 limpieza facial 2x600 con amp. desincrustante carmen entro 5:50\r\n10/junio/17 limpieza de acne monica entro 2:10\r\n16/sept/17 limpieza facial anita entro 6:10 (mega)\r\n10/noviembre/17 limpieza facial andrea entro 11:40 (mega)\r\n17/diciembre/17 limpieza facial 2x600 monica entro 2:50 (mega)\r\n29/abril/18 limpieza de acne Guadalupe entro 6:00 (mega)\r\n24/junio/18 limpieza de acne 2x600 monica entro 6:00 (mega)\r\n30/septiembre/18 limpieza facial lupita entro 1:45 (mega)\r\n13/enero/19 limpieza de acne con amp. desincrustante susy entro 3:00 (mega)\r\n1/MARZO/19  LIMPIEZA DE ACNE LUPITA ENTRO 10:10\r\n05/mayo/19 limpieza de acne 2x600 carmen entro 6:00 mega\r\n24/AGOSTO/19 LIMPIEZA FACIAL CON AMP DEINCRUSTANTE Y MDM DE ESPALDA ANITA ENTRO 11:55\r\n31/AGOSTO/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE ANITA ENTRO 12:05\r\n7/SEPT/19 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE, DEPILACION DE AXILA Y BIGOTE LUPITA ENTRO 11:00\r\n12/OCT/19 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE, DEPILACION DE AXILA Y BIGOTE LUPITA ENTRO 11:40\r\n3/NOVIEMBRE/19 LIMPIEZA FACIAL 2X600 JANETH ENTRO 3:15 MEGA\r\n9/NOVIEMBRE/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE LUPITA ENTRO 12:45\r\n22/DICIEMBRE/19 LIMPIEZA DE ACNE 2X600 ROSI ENTRO 2:36 MEGA\r\n9/FEBRERO/2020 LIMPIEZA DE ACNE 2X600 SUSI ENTRO 1:59 MEGA\r\n8/MARZO/2020 M. CHAMPI Y LIMPIEZA DE ACNE 2X600 SUSI ENTRO 3:54 MEGA\r\n24/OCT/2020 MASAJE FULL RELAX, LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 10:00\r\n3/DIC/2020 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 1:00\r\n10/DIC/2020 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 12:55\r\n29/DIC/2020 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 3:00\r\n31/MARZO/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY LAZARO ENTRO 9:00\r\n29/MAYO/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY LAZARO\r\n19/JUNIO/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 1:05\r\n17/JULIO/2021 MASAJE FULL RELAX 2X600 Y LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE LUCY ENTRO 8:00\r\n31/JULIO/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JOHANY ENTRO 11:00\r\n24/AGOSTO/2021 LIMPIEZA DE ACNE  MIRENA EWNTRO 12:50\r\n14/SEPT/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY LAZARO ENTRO 9:55\r\n9/OCTUBRE/2021 LIMPIEZA DE ACNE CON AMP, DESINCRUSTANTE MARY LAZARO ENTRO 1:10\r\n24/NOVIEMBRE/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 2:45\r\n27/DIC/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 8:55 LLEVO UN JABON ACNIPOP\r\n30/DIC/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 9:00\r\n15/ENERO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JOHANY ENTRO 9:05 \r\nLLEVO CREMA HIDRATANTE NO ESTRES PUREXPERT \r\n7/FEB/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 9:00\r\nINICIA DEPILACION LASER DE BIGOTE $250.00 PATILLAS $500.00 DOBLE MENTON $500.00\r\n7/FEB/2022 1RA. DOBLE MENTON, BIGOTE, PATILLAS 30 MS 11 J MARY LAZARO\r\n15/MARZO/2022 2DA DOBLE MENTON BIGOTE Y PATILLA 30MS 13J MARY LAZARO\r\n30/ABRIL/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JOANA ENTRO 1:00\r\n3/MAYO/2022 INICIA LA DEPILACION EN NO SE HACE FRENTE 1RA. CARA COMPLETA 30 MS 13 J MARY LAZARO\r\n4/JUNIO/2022 4TA CARA COMPLETA 30MS 13J MARY LAZARO \r\n8/JUNIO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 9:10\r\n2/JULIO/2022 5ª LASER CARA COMPLETA 30MS 12J MARY LAZARO \r\n22/JULIO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE CRISTINA ENTRO 9:00\r\n18/AGOSTO/2022 6TA CARA COMPLETA 30MS 18J SRA BEGO\r\n20/AGOSTO/2022 INICIA DEPILACION LASER DE AXILA AUT 13J BEGO\r\n20/AGOSTO/2022 INICIA TRATAMIENTO DE ACNE COSTO 3075.00\r\nLLEVO JABON ACNIPOP, LIMPIADORA FACIAL ACIDA, LOCION BIO-CONTROL, GEL BIO-CONTROL Y MASCARILLA PH 5\r\n1.- TRATAMIENTO DE ACNE 20/AGOSTO/2022 ARIANA ENTRO 11:45\r\n2.-TRAT DE ACNE 22/AGOSTO/2022 JHOANY ENTRO 4:15\r\n3.-TRAT DE ACNE 24/AGOSTO/2022 ARIANA ENTRO 4:05\r\n4.-TRAT DE ACNE 26/AGOSTO/2022 CRISTINA ENTRO 4:20\r\n5.- TRATA DE ACNE 1/SEPTIEMBRE/2022 ARIANA ENTRO 4:30\r\n6.- TRATA DE ACNE 17/SEPTIEMBRE/2022 CRISTINA ENTRO 11:05\r\n7.- TRATA DE ACNE 1/OCTUBRE/2022 MARIANA ENTRO 12:30\r\n1/OCTUBRE/2022 2DA AXILA AUT 13J LUCY\r\n1/OCTUBRE/2022 7ª CARA COMPLETA 30MS 18J LUCY\r\n22/OCTUBRE/2022 TRAT. ACNE JHOANY ENTRO 12:20\r\n5/NOVIEMBRE/2022 INICIA PIERNAS COMPLETAS AUT 10J LUCY\r\n5/NOVIEMBRE/2022 3RA AXILA AUT 13J LUCY\r\n5/NOVIEMBRE/2022 8ª CARA COMPLETA 30MS 18J LUCY\r\n12/NOVIEMBRE/2022 TRAT. ACNE, MASAJE DE ESPALDA LUCY ENTRO 11:05\r\n3/DICIEMBRE/2022 2DA PIERNAS COMPLETAS 30MS 11J MARY LAZARO ENTRO 12:00\r\n3/DICIEMBRE/2022 4TA AXILA AUT 13J MARY LAZARO\r\n3/DICIEMBRE/2022 9ª CARA COMPLETA 30MS 15J MARY LAZARO\r\n10/DICIEMBRE/2022 TRATAMIENTO DE ACNE SUSI ENTRO 2:00\r\nTERMINO TRATAMIENTO DE ACNE, YA SE LE VAN HACER LIMPIEZA DE ACNE. \r\n3/ENERO/2023 5TA AXILA AUT 13J LUCY \r\n3/ENERO/2023 10ª CARA COMPLETA 30MS 15J LUCY\r\n3/ENERO/2023 3RA PIERNAS COMPLETAS 30MS 12J LUCY\r\n4/FEBRERO/2023 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 11:10\r\n20/FEBRERO/2023 10º CARA COMPLETA 30 MS 15 J LUCY\r\n20/FEBRERO/2023 1º BRASILEÑA 30 MS 10 J/100 10 J, LINEA DE ABDOMEN AUTOM. 10 J LUCY\r\n30/MARZO/2023 2DA BRSASILEÑA 30MS 11J/100MS 11J Y LINEA DE  ABDOMEN AUT11J LUCY ENTRO 3:05\r\n30/MARZO/2023 4TA PIERNAS COMPLETAS 30MS 13J LUCY\r\n30/MARZO/2023 6TA AXILA AUT 13J LUCY\r\n30/MARZO/2023 12ª CARA COMPLETA 30MS 15J LUCY\r\n1/ABRIL/2023 LIMPIEZA DE ACNE LUCY ENTRO 11:10\r\n15/ABRIL/2023 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE LUCY ENTRO 10:00\r\n13/MAYO /2023 5TA PIERNAS COMPLETAS 30MS 13J LUCY\r\n13/MAYO/2023 7TA AXILA AUT 13J LUCY\r\n13/MAYO//2023 13ª CARA COMPLETA 30MS 15J LUCY\r\n13/MAYO/2023  3RAA BRSASILEÑA 30MS 11J/100MS 11J Y LINEA DE  ABDOMEN AUT11J LUCY \r\n22/MAYO/2023 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE LUCY ENTRO 4:00\r\n8/JULIO/2023 14º CARA COMPLETA 30 MS 13 J LUCY ENTRO 11:00\r\n8/JULIO/2023 8º AXILA 30 MS 13 J LUCY\r\n8/JULIO/2023 6º PIERNAS COMPLETAS 30 MS 14 J LUCY\r\n8/JULIO/2023 4º BRASILEÑA 30 MS 12 J/100 MS 12 J, LINEA DE ABDOMEN 30 MS 12 J LUCY\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-08 15:53:51', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('128', 'C-100128', '', 'JEAIR CORDOVA CALDERON', '9931128333', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('129', 'C-100129', '', 'MARIA SASHIMA PONCE HERRERA', '9141004157', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('130', 'C-100130', '', 'ALEJANDRO REYES VIDAL', '9931559567', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('131', 'C-100131', '', 'SARAI BELEM FALCON SOSA', '9935909315', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('132', 'C-100132', '', 'ARMENIA GARCIA GOMEZ', '9933111495', '', '15/julio/4169 masaje drenaje linfatico y promocion de coalgeno maria entro 12:45\r\n22/agosto/16 masaje drenaje linfatico reyna entro 2;00\r\n                              \r\n                         OJO                (((((QUIERE QUE LA ATIENDA MARIA ))))\r\n19/NOVIEMBRE/19 TXB 1/3 SUP BOTOX 6,000.00 Y TXB TLATISMA 20 J 4,000 =10,000.00 DR OSCAR', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('133', 'C-100133', '', 'DEYANIRA CAMACHO JAVIER', '9931064006', '', '12/enero/18 masaje express rosy entro 4:10 (mega)\r\n4/ENERO/20 M. ESPALDA Y LIFTIN NO.2 ROSI ENTRO 6:00 MEGA\r\n11/ENERO/2020 DRENAJE LINFATICO MONI ENTRO 6:02 MEGA\r\n22/DIC/2021 MASAJE FULL RELAX 2 X 600 ARLETH ENTRO 11:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('134', 'C-100134', '', 'PATRICIA ALVA COLORADO', '6563285041', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('135', 'C-100135', '', 'MARTHA ALEJANDRA FERIA RUIZ', '9933115957', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('136', 'C-100136', '', 'FRANCISCO JIMENEZ GARCIA', '9361018958', '', '23/FEBREO/19 PROM.TRATAMIENTO REAFIRMANTE  SUSY ENTRO 2:00 MEGA\r\n26/JULIO/19 CONSULTA Y LLEVO TIMEXPERT CUELLO Y ESCOTE Y CONTORNO OJOS DE NATURA BISSE', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('137', 'C-100137', '', 'CONCEPCION CALDERON LARA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('138', 'C-100138', '', 'AMBAR RAMIREZ ESTRADA', '9931967426', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('139', 'C-100139', '', 'MARIA ANTONIA SALAZAR CRUZ', '9161011485', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('140', 'C-100140', '', 'VERONICA CID ORDO', '9931035416', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('141', 'C-100141', '', 'CRISTINA RUEDA VILLAMIZAR', '9935902130', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('142', 'C-100142', '', 'LILIA HERNANDEZ SALAZAR', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('143', 'C-100143', '', 'MARICELA CASEP RODRIGUEZ', '9931777719', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('144', 'C-100144', 'VARL800329483', 'LIDIA DEL CARMEN VAZQUEZ RAMOS', '9931434046', 'lydi_vr@hotmail.com', '23/nov/15 promocion antiedad humectante y nutritivo andrea entro 3:45\r\n14/ene/16 promocion desintoxicante carmen entro 4:15\r\n6/mayo/16 promocion de colágeno carmen entro 4:10\r\n15/nov/16 promocion oxigenante reyna entro 4:35\r\n21/sept/17 promocion resveratrol ofelia entro 4:10\r\n15/FEB/2021 PROM. TRATAMIENTO FACIAL PEEL OFF ANITA ENTRO 2:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('145', 'C-100145', '', 'DIANA CECILIA GARCIA DAYEDT', '9371412952', '', '26/SEP/19 MDM FULL RELAX 2X600 JANETH ENTRO 5.05 MEGA\r\n05/JULIO/22  FULL RELAX  ROSY  ENTRO 4:50 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-05 14:49:48', '1', '26', null, null);
INSERT INTO `clientes` VALUES ('146', 'C-100146', '', 'JUAN CARLOS AREVALO VERONICO', '9371093460', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('147', 'C-100147', '', 'HECTOR IVAN MORALES OVANDO', '9931475540', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('148', 'C-100148', '', 'ROSAURA PEREZ LOPEZ', '9931608618', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('149', 'C-100149', '', 'GISELA PATRICIA CALZADA PEREZ', '9932775883', '', 'depilacion de axila $360.00 c/s\r\n1ª sesion 19/junio/10 autom. 18 j rosy \r\n2ª sesion 20/julio/10 autom. 18 j mary \r\n3ª sesion 20/agosto/10 autom. 19 j lupita\r\n4ª sesion 02/oct/10 rosy aut 19 j rosy\r\n5a sesion 6/nov/10 autom. 20 j lucy\r\n6a sesion 15/dic/10 autom. 21 j mary lazaro \r\n7a sesion 5/feb/11 autom. 24 j lucy\r\n8.-sesion 5/marzo/11 autom.28 j lucy termino seciones.\r\n\r\ndepilacion de brasileña $450.00 c/s\r\n1ª sesion 2/oct/10 aut 18 j rosy\r\n2a sesion 6/nov/10 30 ms 20 j lucy\r\n3ª sesion 15/dic/10 30 ms 21 j mary lazaro\r\n4a sesion 5/feb/11 30 ms 22 j lucy \r\n5.-sesion 5/mazo/11 30ms 24j lucy.\r\n6.-2/abril/11 30 ms 25 j rosy \r\n7.-7/mayo/11 brasileña 30 ms 20 j lucy \r\n8.-27/junio/11 brasileña 30 ms 20 j lucy\r\n27/junio/11 retoque de axila autom. 28 j lucy \r\n2/marzo/12 retoque de axila, brasileña 30 ms 20 j lucy\r\n22/ene/13 retoque de axila autom. 28 j lucy\r\n22/ene/13 brasileña autom. 28 j lucy\r\n27/feb/13 2da. brasileña hasta recto autom. 28 j lucy\r\n1/abril/13 3ra. brasileña autom. 28 j reyna\r\n3/mayo/13 4ta. brasileña autom. 30 j reyna\r\n6/mayo/13 retoque de axila 30 ms 22 j rosy\r\n1/julio/13 5ta. brasileña autom. 32 j lucy\r\n3/agosto/13 6ta. brasileña autom. 32 j lucy\r\n13/sept/13 7ta. brasileña autom. 36 j lucy\r\n12/dic/13 8ta. brasileña /rectal autom. 36 j lucy\r\n12/dic/13 retoque de axila autom. 30 j lucy\r\n20/feb/14 9° brasileña/rectal 30 ms 30 j lucy\r\n12/mayo/14 10° brasileña/rectal 10 j lucy\r\n11/junio/14 11° brasileña/rectal autom. 10 j reyna\r\n28/agosto/15 bikini y axila 20j lucy\r\n28/sept/15 bikini aut-22j lucy\r\n28/dic/15 bikini y bigote aut-23j lucy\r\n28/ene/16 bikini aut-23j lucy\r\n19/feb/16 bigote aut-18j ofelia\r\n19/marzo/16 bigote aut-19j ofelia\r\n18/abril/16 bigote aut-20j, axila aut-22j bikini aut-23j ofelia\r\n24/abril/17 bigote autom. 20 j, axila autom. 24 j, bikini autom. 24 j lucy\r\n29/mayo/17 bigote autom. 20 j, bikini autom. 24 j mary L', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('150', 'C-100150', '', 'MAGDALENA FILIGRANA GARRIDO', '9933300875', '', '16/septiembre/16 mdm full relax 2x500 rosy entro 10:18 (mega)\r\n5/MARZO/18 INICIA TRATAMIENTO DE CELULITIS\r\n1.- CARB, DERMO  5/MARZO/18 MARIANA ENTRÓ  10:20\r\n2.- LUMICELL    6/MARZO/18 MARIANA ENTRO 10:05\r\n3.- CARB, DERMO  9/MARZO/18  MARIANA ENTRO 10:00\r\n4.- LUMICELL    10/MARZO/18 MARIANA ENTRO 10:15\r\n5.- VF 50M 12/MARZO/18 MARIANA ENTRO 10:00\r\n12/MARZO/18 MASAJE DE ESPALDA MARIANA ENTRO 10:00\r\n6.- CARB, DERMO   13/MARZO/18 MARIANA ENTRO 10:00\r\n12/MARZO/18 MASAJE DE ESPALDA MARIANA ENTRO 10:00\r\n7.- LUMICELL  14/MARZO/18  MARIANA ENTRO 10:00\r\n8.- CARBO, DERMO  15/MARZO/18 MARIANA ENTRO 10:05\r\n9.- VF 50   15/MAR    16/MARZO/18 MARIANA 10:00\r\n16/MARZO/18 DEP DE CEJAS MARIAMA\r\n10 CARB, DERMO   19/MARZO/18 MARIANA ENTRO 10:00\r\n11.- LUMICELL   20/MARZO/18 MARIANA ENTRO 10:00\r\n12.- CARB, DERMO    21/MARZO/18  MARIANA ENTRO 10:10\r\n13.- LUMICELL    22/MARZO/18 MARIANA ENTRO 10:05\r\n14.- VF   23/MARZO/18 MARIANA ENTRO 10:10\r\n15.- CARB, DERMO\r\n16.- LUMICELL\r\n17.- CARB, DERMO\r\n18.- LUMICELL\r\n19.- CARB, DERMO\r\n20.- VF 50\r\n28/JUNIO/18 SALDO A FAVOR 2,000 AUTORIZÓ SRA  BEGO\r\n3/JULIO/18 PROM TRATAMIENTO FACIAL CON RETINOL Y AMP BEAUTÉ III Y DEP DE CEJAS MARY ENTRO 11:10\r\n3/JULIO/18 SALVO A FAVOR 595\r\n04/JULIO/20022 LIMPIEZA FACIAL 2X600 DEPILACION DE CEJAS ROSY ENTRO 6:05 MEGA\r\n\r\n\r\n\r\n26/JULIO/18  DEP DE CEJAS Y A SU HIJA LIMPIEZA FACIAL CON AMP SALDO LIQUIDADO', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-04 18:11:32', '1', '26', null, null);
INSERT INTO `clientes` VALUES ('151', 'C-100151', '', 'CLAUDIA LILIANA CASTRO MEJIA', '9931608312', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('152', 'C-100152', '', 'MARIO FIGUEROA', '9931083456', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('153', 'C-100153', '', 'GRACIELA BROCA RAMIREZ', '9371168388', '', '19/03/11 mdm. limp.facial.2x1.atendio: jhoana. entro:11:05am salio:1:09pm(suc)\r\n09/08/11limp. facial 2x1atendio:deyanira entro 6:30p.m  salio : (suc deportiva)\r\n10/11/12 lim.facial y mdm 2x1 atendio jeny entro 2.20 mega\r\n08/08/13 lim. facial 2x1 atendio brenda entro 6:10 mega\r\n13/02/14 mdm 2x1 mirena mega 5:05\r\n10/08/14 lim facial 2x1 susi mega 12.10\r\n07/10/14 serealizo lim y msj de un 2x1 atendio lucero cristal entro alas 2.10\r\n13/dic/14 limpieza facial y mdm ful relax 2x1 martha entro 9:53 (mega)\r\n25/julio/15 mdm full relax y limpieza facial susy entro 2:15 (mega)\r\n28/enero/16 limpieza facial 2x1 andrea entro 7:05 (mega)\r\n17-07-16 SE REALIZO L-F Y MDM CANDY CRISTAL 2PM\r\n23/abril/17 mdm full relax y limpieza facial 2x600 carmen entro 1:55 (mega)\r\n29/noviembre/17 limpieza facial 2x600 monica entro 1:00 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('154', 'C-100154', '', 'KARLA SANCHEZ DE LA ROSA', '9933114892', '', '16/mayo/16 promocion de colageno con amp. desicnrustante lucy entro 11.15\r\n23/mayo/16 limpieza facial maria entro 11.30\r\nINICIA VENDAS FRIAS $3000.00 PAGADO\r\n1.- V F 45M 23/mayo/16 maria entro 11.20\r\n2.-V F 45M 24/mayo/16 maria entro 11.40\r\n3.-V F 45M 25/mayo/16 ofelia entro 11_45\r\n4.-V F 45M 26/mayo/16 maria entro 11.35\r\n5.-V F 45M 27/mayo/16 maria entro 1:15\r\n6.-V F 45M 30/mayo/16 reyna entro 4:20\r\n7.-V F 45M\r\n8.-V F 45M\r\n9.-V F 45M\r\n10.-V F 45M\r\n04/diciembre/16 masaje express lizbeth entro 1:50 (mega)\r\n06/febrero/17 limpieza facial  profunda y masaje express rosy entro 5:10 (mega)\r\n17/abril/17 limpieza facial y masaje express lizbeth entro 1:10 (mega)\r\n11/enero/18 mdm full relax rosy entro 1:10 (mega)\r\n15/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE CON AMP DESINCRUSTANTE BELÉN ENTRO 12:10\r\n15/DIC/18 SE LE RECOMIENDA QUE COMPRE EL MOUSSE DE OXYGEN O LIMPIADORA FACIAL ACIDA ////// PIEL MUY////SENSIBLE\r\n21/marzo/19 limpieza facial profunda rosy entro 4:15 mega\r\n22/MARZO/19 MDM DE ESPALDA LUPITA ENTRO 11:30\r\n29/junio/19 mdm full relax mony entro 11:05 mega\r\n07/septiembre/19 limpieza facial profunda rosy entro 11:00 mega\r\n9/NOVIEMBRE/19 MDM FULL RELAX JANETH ENTRO 11:15 MEGA\r\n7/DICIEMBRE/19 TRATAMIENTO 24K MONI ENTRO 1:08 MEGA\r\n26/FEB/2022 MASAJE FULL RELAX MONICA ENTRO 17:04 MEGA\r\n28/ABRIL/2022 MASAJE FULL RELAX MONICA ENTRO 12:55 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-14 17:27:10', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('155', 'C-100155', '', 'NICOLE LOPEZ JERONIMO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('156', 'C-100156', '', 'ADRIANA MIRIELLE', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('157', 'C-100157', '', 'JENNIFER CASTA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('158', 'C-100158', '', 'GLADYS BAUTISTA HERNANDEZ', '9932020093', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('159', 'C-100159', '', 'GABRIEL RUIZ CRUZ', '9931605559', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('160', 'C-100160', '', 'NATZIRA PEREZ MUNGIA', '', '', '22/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE Y CON AMP DESINCRUSTANTE OFELIA ENTRO  1:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('161', 'C-100161', '', 'ANA MARIA FIERRO DE LOS SANTOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('162', 'C-100162', 'MAUG701212CM7', 'GUADALUPE MARTINEZ VICHEL', '9931114160', 'marvich70@hotmail.com', '23/oct/15 masaje full relax y limpieza facial lizvet entro 8:15\r\n2/junio/16 mdm full relax anita entro 8:40\r\n15/sept/17 promocion resveratrol y lifting colageno mariana entro 10:30\r\n12/noviembre/17 mdm full relax 2x600 monica entro 6:10 (mega)\r\n21/12/17 EXCEL THERAPY SUSY ENTRO 3:00\r\n6/ABRIL/18 FACIAL VITAMINA C GERMAINE ANITA\r\n25/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE Y LIFTING DE COLÁGENO MARY ENTRO 9:50\r\n29/NOV/18 LIMPIEZA FACIAL Y MASAJE DE PIES ISABEL-LUPITA ENTRO 9:00\r\n14/MARZO/19 MDM FULL RELAX Y LIMPIEZA FACIAL 2 X 600 BETTY ENTRO 4:20\r\n23/JULIO/19 TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO Y LIFTING DE COLAGENO MARY ENTRO 11:05\r\n13/DIC/19 PROMOCION TRAT 24 K LUCY ENTRO 11:10\r\n7/ENERO/20 MASAJE FULL RELAX CLIENTE FRECUENTE, PROMOCION TRAT DESINTOXICANTE SANDY ENTRO 1:10\r\n11/DICIEMBRE/2020 TRATAMIENTO FACIAL DE PORCELANA Y LIFTING DE TIMEXPERT RIDES YOANA ENTRO 1:10\r\n14/DIC/2020 MASAJE DESCONTRACTURANTE JHOANY ENTRO 11:00\r\n19/DIC/2020 MASAJE DESCONTRACTURANTE JHOANY ENTRO 8:00\r\n28/DIC/2020 MASAJE DESCONTRACTURANTE JHOANY ENTRO 2:00\r\n4/ENERO/2021 INICA RADIOFRECUENCIA ANITA ENTRO 10:00\r\n15/ENERO/2021 2DA. RADIOFRECUENCIA FACIAL OFELIA ENTRO 11:45\r\n22/ENERO/2021 RADIOFRECUENCIA FACIAL OFELIA ENTRO 10:50\r\n29/ENERO/2021 RADIOFRECUENCIA FACIAL OFELIA ENTRO 12:00\r\n15/FEB/2021 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 2:00\r\n27/MARZO/2021 PROMOCION TRAT. ACIDO HIALURONICO OFELIA ENTRO 7:50\r\n28/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD JOHANY ENTRO 3:05\r\n29/DICIEMBRE/2021 MASAJE FULL RELAX CLIENTE FRECUENTE, PROM. TRATAMIENTO FACIAL FACE PURE Y MASCARILLA DE CUELLO MIRENA ENTRO 2:55\r\n6/ENERO/2022 MASAJE DESCONTRACTURANTE JOHANY ENTRO 11:00\r\n7/JULIO/2022 PROMOCION TRAT ROLL & LIFT CRISTINA ENTRO 11:05\r\n8/AGOSTO/2022 PROMO. TRATAMIENTO ANTIOXIDANTE ARIANA ENTRO 2:40\r\n13/SEPTIEMBRE/2022 PACK DE RIZADO, DEPILACION DE CEJAS Y PLANCHADO JHIANY ENTRO 3:50\r\n15/OCTUBRE/2022 MASAJE DESCONTRACTURANTE ARIANA ENTRO 11:50\r\n25/OCTUBRE/2022 MASAJE CLIENTE FRECUENTE ARIANA ENTRO 10:10', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-25 11:10:19', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('163', 'C-100163', '', 'JONATHAN DAVID JESUS MATIAS', '9931165049', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('164', 'C-100164', '', 'BRIANDA LISBETH JESUS MATIAS', '9931165049', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('165', 'C-100165', '', 'YENIRIA CABRERA CERNUDA', '', '', '', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('166', 'C-100166', '', 'YANIN JUAREZ LEON', '9932026066', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('167', 'C-100167', '', 'LUVIA GRAHAM PRIEGO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('168', 'C-100168', '', 'GUSTAVO DEVEZE RODRIGUEZ', '9933964377', '', '15/JUNIO/19 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ANITA ENTRO 2:00\r\n 1/AGOSTO/19 LIMPIEZA DE ACNE CONA MP DESINCRUSTANTE LIZBETH ENTRO 5:30\r\n17/DICIEMBRE/2022 HIDRODERMABRASION, LIMPIEZA FACIAL  Y HIDROADERMABRASION OFELIA ENTRO 11:20', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-29 20:00:22', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('169', 'C-100169', '', 'VICTOR ALFONSO AVILA QUINTERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('170', 'C-100170', '', 'LUIS ENRIQE AVILA QUINTERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('171', 'C-100171', '', 'LILITA CRUCES FERNANDEZ', '9931160670', '', '26/ene/09 promocion jalea real mary lazaro entro 5:45 \r\n20/feb/09 infinitime mary lazaro \r\n1/abril/09 timexpert mary lazaro entro 5:30\r\n8/junio/09 caviar mary lazaro entro 5:20\r\n10/julio/09 excel therapy 02 lucy entro 4:40 \r\n28/agosto/09 seda y perla mary entro 5:05 \r\n3/dic/09 celulas madres de manzana sara entro 5:25\r\norange 3/nov/10 mary lazaro entro 4:15\r\n10/dic/10 promocion velos de colageno mary lazaro entro 4:39 \r\n11/ene/11 promocion porcelana lucy entro 4:13 \r\n5/feb/11 timexpert lift indira entro 3:00 salio 4:45 (sucursal)\r\n5/abril/11 promocion vinoterapia mary lazaro entro 4:35\r\n26/mayo/11 promocion botanico reyna entro 4:55\r\n22/junio/11 promocion estimulante de endorfinas deyanira entro 4:45 le gusta que le pongan diatermia\r\n22/julio/11 promocion de amaranto lucy entro 4:35\r\n27/julio/11 limpieza facial con amp. desincrustante y amp. hydracure lucy entro 4:50\r\n03/oct/11 promocion  relajante sara entro 4:15\r\n06/oct/// masaje aromas mariana entro 5:00\r\n05/nov/11 promocion germen de trigo reyna entro 11:15\r\n26/nov/11 promocion germen de trigo y vitamina e mariana entro 11:20\r\n26/ene/12 promocion revitalizante lucy entro 4:05\r\n15/003/12 trat hidradermis atendio deya entro 5:00 (mega) \r\n22/marzo/12 trat. facial coenzima q10 lucy entro 4:50\r\n12/abril/12 inicia trat. reductivo de termo y laser lipolitico $5000.00 abono $2500.00 resta $2500.0\r\nde cortesia carbo en gorditos\r\n1.-carbo, termoslin 12/abril/12 rosy entro 5:15\r\n2.-carbo, laser lipolitico 14/abril/12 karina entro 10:35\r\n3.-carbo, termoslin 16/abril/12 sara entro 4:35\r\n4.-carbo, laser lipolitico 18/abril/12 reyna entro 5:20\r\n5.-carbo, termoslin 20/abril/12 lucy entro 11:25\r\n6.-carbo, laser lipolitico 23/abril/12 aracely entro 4:25\r\n7.-carbo, termoslin 26/abril/12 karina entro 4:25\r\n8.-carbo, laser lipolitico 2/mayo/12 sara entro 4:25\r\n9.-carbo, termoslin 7/mayo/12 rosy entro 6:20\r\n10.-carbo, laser lipolitico 25/junio/12 aracely entro 4:25\r\n18/mayo/12 promocion velo de colageno con amp. desincrustante rosy entro 4:45\r\n25/junio/12 10 m de drenaje linfatico de cortesia\r\n27/junio/12 radiofrecuencia facial lucy entro 5:05\r\n3/julio/12 radiofrecuencia karina entro 5:00\r\n6/julio/12 termoslin reyna\r\n7/julio/12 laser lipolitico mariana entro 10:35\r\n9/julio/12 termoslin araceli entro 3:50\r\n9/julio/12 radiofrecuencia araceli\r\n10/julio/12 laser lipolitico araceli entro 3:30\r\n20/agosto/12 radiofrecuencia lucy entro 10:00\r\n10/sept/12 radiofrecuencia lucy entro 5:40\r\n13/sept/12 promocion de agave con amp. desincrustante lucy entro 4:25\r\n19/sept/12 radiofrecuencia lucy entro 4:30\r\n24/sept/12 7ta radiofrecuencia araceli entro 11:40\r\n4/oct/12 8ta radiofrecuencia lucy entro 8:05\r\n25/oct/12 vitamina c nb bego entro 4:50\r\n26/oct/12 prp dr. oscar\r\n8/nov/12 royal jelly lucy entro 4:35\r\n4/ene/13 oxigenante nb lucy entro 5:00\r\n11/ene/13 promocion lifting de parpados lucy entro 4:50\r\n1/marzo/13 facial desafio antiedad nb lucy entro 3:15\r\n21/marzo/13 promocion royal jelly con amp. de acido hialuronico lucy entro 3:45\r\n27/abril/13 prp dr. oscar\r\n23/mayo/13 micro, facial ceutical rosy entro 4:20 llevo tonico ceutical de nb\r\n10/junio/13 facial the cure nb lucy entro 5:00\r\n26/agosto/13 facial the cure nb lucy entro 4:30\r\n23/sept/13 facial vitamina c de nb lucy entro 5:10\r\n11/oct/13 facial retinol lucy entro 5:20\r\n25/oct/13 prp 7m, txb 3m\r\n3/ene/14 desafio antiedad mariana entro 4:10\r\n10/ene/14 facial vitamina c de natura bisse mariana entro 5:00\r\n10/feb/14 facial retinol de jabotiere lucy entro 5:05\r\n8/abril/14 facial aqua nb lucy entro 5:00\r\n16/mayo/14 prp $7000.00 botox $5000.00\r\n20/junio/14 facial the cure natura bisse lucy entro 8:20\r\n17/julio/14 vitamina c de natura bissé lucy 5:05\r\n27/agosto/14 facial aqua de natura bisse mirena entro 5:00\r\n5/sep/14 promocion y lifting nb entro mariana 5:20\r\n5/nov/14 facial ceutical ofelia entro 5:20\r\n19/dic/14 facial aqua mariana entro 5:20\r\n11/febrero/15 promocion tratamiento reafirmante lucy entro 5:10\r\n19/febrero/15 facial hydradermie lucy entro 5:05\r\n17/marzo/15 facial the cure reyna entro 8:25\r\n13/abril/15 desafio antiedad lucy entro 5:05\r\n20/abril/15 prp $7000.00 dr, oscar garcía\r\n11/junio/15 facial modeladora lucy entro 8:10\r\n27/agosto/15 facial the cure lucy entro 3:30\r\n26/oct/ prp cce $ 7000.00 dr. oscar garcia\r\n10/nov/15 facial hydracure  (pidele al tiempo que vuelva) lucy entro 5:10\r\n5/ene/16 facial vitamina c natura bisse lucy entro 5:10\r\n10/marzo/16 timexpert lift in lucy entro 5:00\r\n19/abril/16 prp cce $7000.00 dr, oscar garcía\r\n8/junio/16 facial the cure NATURA BISSÉ LUCY entro 4:45\r\n15/julio/16 facial the cure natura bisse lucy entro 4:40\r\n26/sept/16 facial desafio antiedad de natura bisse lucy entro 5:00\r\n13/oct/16 limpieza facial con amp. desinrudtante lucy entro 3:45\r\n29/oct/16 prp cce $7000.00 dr. oscar garcia\r\n30/nov/16 retoque de laser de piernas y bikini/total  30ms 10j reyna\r\n5/ene/17 retoque de laser axila $360.0  piernas $1500.00  y bikini $450.00 cada sesion}\r\n5/ene/14 retoque de axila aut-10j, piernas 30ms 11j, bikini 30ms 11j lucy\r\n17/ene/17 facial desafio antiedad de natura bisse lucy entro 5:25\r\n4/feb/17 axila aut-14j, bikini, piernas completas 30ms 10j lucy\r\n12/abril/17 axila autom. 14 j, bikini, piernas completas 30 ms 10 j lucy\r\n19/abril/17 promocion termico mariana entro 5:10\r\n20/mayo/17 PRP CCE 7.0 Dr. Oscar\r\n15/junio/17 promocion antioxidante lucy entro 4:50\r\n1/sept/17 facial the cure natura bisse mariana entro 5:05\r\n21/sept/17 promocion resveratrol lucy entro 4:35\r\n28/nov/17 prp dr. oscar\r\n24/ENERO/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO LUCY ENTRO 3:15\r\n12/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO LUCY ENTRO 4:00\r\n18/ABRIL/18  PRP CCE 7,000 DOCTOR OSCAR\r\n26/JUNIO/18 FACIAL  THE CURE LUCY ENTRO 4:10\r\n24/SEP/18 FACIAL DE NATURA BISSÉ SE LE PASO RADIO Y SE LE COBR 2,00 Y LIFTING DE COLÁGENO OFELIA\r\n25/OCT/18 PRP CCE  DR OSCAR\r\n13/ABRIL/19 PRP CCE 7,000 DR OSCAR\r\n30/ene/19 FACIAL DE VITAMINA C DE NATURA BISSÉ LUCY ENTRO 4:45\r\n22/MARZO/19 PROM TRATAMIENTO FACIAL DETOX MARY ENTRO 3:30\r\n27/SEP/19 TRATAMIENTO FACIAL OXIGENANTE ANITA ENTRO 4:50 LLEVO BRUMA SOLAR\r\n21/NOVIEMBRE/19 PRP CCE 7,000.00 DR OSCAR\r\n3/JUNIO/20 FACIAL THE CURE LUCY ENTRO 3:10 LLEVO TONICO CEUTICAL\r\n15/JULIO/2020 TRATAMIENTO DE CUELLO  DE NATURA BISSE  LUCY ENTRO 2:20\r\nLLEVO CREMA TENSOR DE CUELLO Y ESCOTE DE NATURA BISSE Y ESSENTIL SCHOCK REAFIRMANTE CUELLO Y LABIOS DE NATURA BISSE\r\n27/JULIO/2020 TRATAMIENTO FACIAL ANTIEDAD A BASE DE ALGAS CON AMP DESINCRUSTANTE LUCY ENTRO 3:05\r\n2/OCTUBRE/2020 TRATAMIENTO DE CUELLO DE NATURA BISSE CON AMP DE OXIGENO LUCY ENTRO 3:15\r\n27/OCTUBRE/2020 FACIAL THE CURE DE NATURA BISSE LUCY ENTRO 2:15\r\n8/ENERO/2021 FACIAL THE CURE NATURA BISSE LUCY ENTRO 3:15\r\n4/MARZO/2021 TRATAMIENTO COLAGENO 3D ESSENTIAL SHOCK DE NATURA BISSE MARIANA ENTRO 3:15\r\n12/MAYO/2021 TRAT. FACIAL THE CURE NATURA BISSE LUCY ENTRO 3:20\r\n30/JUNIO/2021 FACIAL DESAFIO ANTIEDAD DE NATURA BISSE LUCY ENTRO 4:50\r\n3/AGOSTO/2021 FACIAL DE CUELLO DE NATURA BISSE OFELIA ENTRO OFELIA ENTRO 3:05\r\n1/SEPT/2021 RADIOFRECUENCIA FACIAL OFELIA ENTRO 3:13 \r\n29/SEPT/2021 FACIAL VITAMINA C DE NATURA BISSE  OFELIA ENTRO 3:05 LLEVO AMPOLLETAS SRNS DETOX NIGHT \r\n11/ENERO/2022 FACIAL VITAMINA C DE NATURA BISSE OFELIA ENTRO 3:00\r\n16/FEBRERO/2022 FACIAL RETINOL DE GRMAINE 2000.00 OFELIA ENTRO 3:00\r\n1/MARZO/2022**************SU HIJO SE REALIZO LIMPIEZA FACIAL PROFUNDA**************\r\n***********************PENDIENTE DE  PAGO********************************\r\n25/MAYO/2022 FACIAL TIMEXPERT IN CON REVERS LUCY ENTRO 3:10\r\n13/SEPTIEMBRE/2022 FACIAL MESOBOOT OFELIA ENTRO 3:15\r\n3/ENERO/2023 FACIAL ESSENTIAL SCHOK CON AMP. DIAMOND OFELIA ENTRO 2:50\r\n8/JULIO/2023 TRATAMIENTO MESOBOOST CON AMP. DE CASMARA OFELIA ENTRO 12:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-08 13:50:49', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('172', 'C-100172', '', 'ANA PATRICIA GONZALEZ', '8110391179', '', 'INICIA RADIO FACIAL $1500.00 CADA SESION\r\n23/oct/15 radio facial mariana entro 3:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('173', 'C-100173', '', 'ITANDEHUI ARRIOLA FRANCO', '9932074375', '', '24/agosto/19 mdm full relax y limpieza facial 2x600 mony entro 3:00 mega', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('174', 'C-100174', '', 'LOLY MAR SILVA OCHOA', '9931601423', '', '04-11-15 se realizo limp 2x1 cristal martha  4pm\r\n20-01-16  1 INICIO MASAJE REDUCTIVO MARTHA 10AM ABDOMEN 93 BUSTO 101 CINTURA 96 CADERA ALTA 104 CADERA BAJA 109 BRAZO 35 MUSLO 62 martha 10am\r\n21-01-16  2 MASAJE REDUCTIVO martha 10am CRISTAL\r\n22-01-16  3 MASAJE REDUCTIVO martha 10am CRISTAL\r\n25-01-16  4 MASAJE REDUCTIVO MARTHA 10 AM CRISTA\r\n27-01-16  5 MASAJE REDUCTIVO MARTHA 10AM CRISTAL\r\n28-01-16  6 MASAJE REDUCTIVO MARTHA 10AM CRISTAL\r\n29-01-16   7 MASAJE REDUCTIVO MARTHA CRISTAL 10AM\r\n01-02-16  8 MASAJE REDUCTIVO martha cristal 12pm\r\n02-02-16  9 MASAJE REDUCTIVO MARTHA CRISTAL 10 AM\r\n03-02-15 10 MASAJE REDUCTIVO SUSSY CRISTAL 10AM', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('175', 'C-100175', '', 'PEDRO PANZA VALERO', '9931601409', '', '24/abril/16 mdm full relax charito entro 11:10 (mega)\r\n25/agosto/16 masaje full relax lucy entro 11.30\r\n14/sept/16 masaje full relax mariana entro 12:00\r\n12/nov/16 masaje sensorelax carmen entro 11:50\r\n17/enero/17 mdm sensorelax lizbeth entro 7:00 (mega)\r\n24/enero/17 mdm sensorelax lizbeth entro 6:05 (mega)\r\n31/enero/17 mdm sensorelax lizbeth entro 6:15 (mega)\r\n31/enero/17 pago 2 masajes sensorelax el dice que dia los tomara \r\n21/julio/17 masaje descontracturante anita entor 11:15\r\n20/agosto/17 trata. de colageno carmen entro 10:15 (mega)\r\n9/sept/17 promocion resveratrol mary lazaro entro 12:00\r\n24/sept/17 promocion resveratrol carmen entro 12:15 (mega)\r\n7/oct/17 facial desafio antiedad (incluye colageno) natura bisse mary lazaro entro 12.15\r\n17/noviembre/17 trat. de colageno candy entro 6:10 (mega)\r\n25/noviembre/17 mdm full relax candy entro 5:10 (mega)\r\n16/01/18 FACIAL DESAFIO ANTIEDAD NATURA  BISSÉ MARY LAZARO\r\n23/marzo/18 mdm full relax monica entro 4:05 (mega)\r\n20/ABRIL/18 MDM DE AROMA, FACIAL TIMEXPERT RIDES REYNA ENTRO 3:50\r\n28/MAYO/18 MDM DRENAJE LINFATICO LUCY ENTRO 3:45\r\n27/junio/18 mdm full relax candy entro 5:45 (mega)\r\n20/JULIO/18 MDM  DRENAJE LINFATICO LUPITA ENTRO 4:55\r\n04/agosto/18 mdm full relax susy entro 4:00 (mega)\r\n3/SEP/18 MDM FULL RELAX MARY ENTRO 12:00\r\n14/SEP/18 FACIAL DE COLÁGENO TIMEXPERT RIDES Y MDM FULL RELAX MARY\r\n16/OCT/18 MDM DRENAJE LINFATICO LUPITA ENTRO 11:50\r\n25/octubre/18 mdm full relax charito entro 4:00 (mega)\r\n9/NOV/18 MDM DESCONTRACTURANTE REYNA - BELEN ENTRO 11:10\r\n15/NOV/18 MDM DE AROMAS CARMEN- LUCY ENTRO 4:05\r\n29/NOV/18 MDM FULL RELAX KARLA-MARY \r\n16/FEB/19 FACIAL COLAGENO 3D NATURA BISSE OFELIA ENTRO 11:45\r\n11/abril/19 mdm full relax carmen entro 6:50 mega', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('176', 'C-100176', '', 'WENDY MANZANERO NOTARIO', '9932239265', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('177', 'C-100177', '', 'MIGUEL VILLALOBOS', '9932078805', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('178', 'C-100178', '', 'YULIANA VINAGRE CARRILLO', '9141061452', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('179', 'C-100179', '', 'AGUSTIN ANDRES PEREZ APARICIO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('180', 'C-100180', '', 'ANA ELENA MARISCAL RAMIREZ', '9931603558', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('181', 'C-100181', '', 'LEONILDA HERNANDEZ BOLON', '9381000990', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('182', 'C-100182', '', 'MARIA DEL CARMEN FIGUEROA ELIZARRARAS', '9931170214', '', '19/marzo/16 mdm aromas carmen entro 10.55\r\n4/abril/16 mdm holístico 2x600 maria entro 6:00\r\n20/NOVIEMBRE/19 TXB 1/3 SUP BOTOX 6,000.00 DR OSCAR\r\n15/JUNIO/2020 PROMOCION TRAT REPARADOR ANTIEDAD MARY LAZARO ENTRO 10:00\r\nINICIA TRATAMIENTO DE MASAJE REDUCTIVO $3000.00 PAGADO.\r\n1.-MASAJE 45 M 15/JUNIO/2020 MARY LAZARO ENTRO 9:00\r\n2.-MASAJE 45 M 16/JUNIO/2020 MARY LAZARO ENTRO 12:15\r\n3.-MASAJE 45 M 19/JUNIO/2020 MARY LAZARO ENTRO 10:50\r\n4.-MASAJE 45 M 23/JUNIO/2020 YANETH ENTRO 1:00\r\n5.-MASAJE 45 M 29/JUNIO/2020 MONICA ENTRO 9:00\r\n6.-MASAJE 45 M 30/JUNIO/2020 YANETH ENTRO 9:00\r\n7.-MASAJE 45 M \r\n8.-MASAJE 45 M \r\n9.-MASAJE 45 M \r\n10.-MASAJE 45 M ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('183', 'C-100183', '', 'MARIA ISABEL SEVILLA SANCHEZ', '9932258942', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('184', 'C-100184', '', 'MARIELA ANTONIA LEON JIMENEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('185', 'C-100185', '', 'YENY MONTALVO ALVAREZ', '9931987688', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('186', 'C-100186', '', 'MARIA FERNANDA GOMEZ BERDEJA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('187', 'C-100187', '', 'CONSUELO OCAÑA BELTRAN', '9933995042', '', '25/mayo/17 retoque de axila, bikini autom. 24 j lucy', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('188', 'C-100188', '', 'ROSA MARIA CUSTODIO REYES', '9373782146', '', '27/JUNIO/20 FACIAL DE ORO  CON BEAUTE I MONICA ENTRO 10:45\r\n27/JUNIO/20M LLEVO *TIMEXPERT RIDES MASCARA DE NOCHE 995.00 *ELIXIR TIMEXPERT RIDES 1,325.00  *ROYAL JELLY EXTREME 975.00 *TIMEXPERT RIDES EYES TRATAMIENTO CONTORNO JOS DIA Y NOCHE 1,790.00 \r\n2/JULIO/2020 TRAT FACIAL COMPLETO MONICA ENTRO 12:40\r\n7/ENERO/2021 TRATAMIENTO DE HYDRAFACIAL ANITA ENTRO 11:10\r\n19/ENERO/2021 TRATAMIENTO HYDRAFACIAL ANITA ENTRO 1:00\r\n19/AMYO/2021 TRATAMIENTO FACIAL CELULAS MADRE OFELIA\r\n21/JUNIO/2021 PROMOCION RETINOL MARIANA ENTRO 10:20\r\n5/JULIO/2021 PROMOCION CAVIAR Y ORO, 1RA. RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 10:05 \r\n13/JULIO/2021 2DA. RADIOFRECUENCIA FACIAL LUCY ENTRO 10:45\r\n19/JULIO/2021 3° RADIOFRECUENCIA FACIAL LUCY ENTRO 10:25\r\n27/JULIO/2021 RADIOFRECUENCIA ANITA ENTRO 10:20 (SE LE REPUSO LA SESION ANTERIOR PORQUE SE QUEJO QUE NO LE DIERON EL TIEMPO EXACTO)\r\n3/AGOSTO/2021 4º RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 9:40 \r\n10/AGOSTO/2021 5TA. RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 10:35 \r\n17/AGOSTO/2021 6TA. RADIOFRECUENCIA FACIAL LUCY ENTRO 9:50 \r\n26/AGOSTO/2021 7TA. RADIOFRECUENCIA FACIAL LUCY ENTRO 10:15\r\n31/AGOSTO/2021 FACIAL NEW LIFT LUCY ENTRO 10:10 \r\n10/SEPT/2021 HOLLYWOOD PEEL OFELIA ENTRO 9:50 \r\n14/SEPT/2021  FACIAL NEW LIFT LUCY ENTRO 10:00\r\n28/SEPT/2021 FACIAL NEW LIFT MARY LAZARO ENTRO 10:00\r\n6/OCT/2021 HOLLYWOOD PEEL OFELIA ENTRO 10:00\r\n12/OCT/2021 FACIAL NEW LIFT MARY LAZARO ENTRO 10:00\r\n26/OCTUBRE/2021 FACIAL NEW LIFT MARY LAZARO ENTRO 10:15\r\n3/NOVIEMBRE/2021 HOLLEWOOB PEEL OFELIA ENTRO 9:55\r\n9/NOVIEMBRE/2021 TRATAMIENTO DE NEW LIFT MARY LAZARO ENTRO 10:10\r\n30/NOVIEMBRE/2021 HOLLEWOOB PEEL OFELIA\r\n7/DIC/2021 TRATAMIENTO NEW LIFT MARY LAZARO ENTRO 10:10\r\n6/ENERO/2022 HYDROADERMSBRASION MARY LAZARO ENTRO 11:00\r\n11/MARZO/2022 PROMOCION TRAT. SHOCK DE COLAGENO MARY LAZARO ENTRO 10:00\r\n21/ABRIL/2022 PROM. TRATAMIENTO FACIAL CINETICO MARY LAZARO ENTRO 10:00\r\n24/MAYO/2021 PROM. TRATAMIENTO FACIAL FITO-HIDRATANTE LUCY ENTRO 10:25\r\n27/MAYO/2022 PROM. DERMAPEN LUCY ENTRO 4:05\r\n7/JULIO/2022 PROMOCION TRAT ROLL & LIFT ARIANA ENTRO 10:05\r\n14/JULIO/2022 DERMAPEN LUCY ENTRO 10:10\r\n18/AGOSTO/2022 PROM. TRATAMIENTO FACIAL ANTIOXIDANTE CRISTINA ENTRO 10:10\r\n18/AGOSTO/2022 LIPOSONIC  RF 80 HIFU 6 LUCY\r\n****MEDIDA CINTURA 92****\r\n23/SEPT/2022 MESOBOOST LUCY ENTRO 10:20\r\n8/NOVIEMBRE/2022 PROMOCION TRAT. REPARACION CELULAR CRISTINA ENTRO 9:50\r\n28/ENERO/2023 TRATAMIENTO FACIAL DE $1,000.00 PESOS CON MASCARILLA REAFIRMANTE, AMPOLLETA AGE COMPLEX DE CASMARA Y BURBUJA DE OXIGENO JHOANY ENTRO 10:10\r\n16/MAYO/2023 PROMOCION TRAT. FACIAL MAGIC FACE JHOANY ENTRO 10:00 LLEVO MASCARILLA GLYCOLIC DE CASMARA', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-15 19:01:14', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('189', 'C-100189', '', 'ELIZABETH EGURROLA RODRIGUEZ', '', '', '17/mayo/18 prom. del mes trat. antiedad monica entro 6:10 (mega)\r\n4/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL MARY ENTRO 11:05\r\n13/AGOSTO/18 LIPOSONIX  50 J OFELIA\r\n21/NOVIEMBRE/19 1/3 SUP BOTOX 6,000.00 DR OSCAR\r\n9/ENERO/2020 TRATAMIENTO DESINTOXICANTE ROSY ENTRO 10:53 MEGA\r\n9/JUNIO/2020 PROMOCION REGENERADOR ANTIEDAD MONICA ENTRO 10:00\r\n10/MAYO/21 TRATAMIENTO CELULAS MADRES ROSITA ENTRO 9:50 MEGA\r\n25/OCTUBRE/2021 INICIA TRATAMIENTO REDUCTIVO\r\n1.- CAPSULA  25/OCTUBRE/2021 JOHANY ENTRO 9:10\r\n2.-  CORPO 26/OCTUBRE/2021 ARLETH ENTRO 11:50\r\n3.- MASAJE REDUCTIVO CON G-5 27/OCT/2021 JHOANA ENTRO 9:00 \r\n4.- CAPSULA 28/OCT/2021 MIRENA ENTRO 9:00\r\n5.- CAPSULA 29/OCTUBRE/2021 MARIANA ENTRO 9:00\r\n6.- LASER LIPOLITICO 1/NOV/2021 LUCY ENTRO 9:00\r\n7.- VENDAS CALIENTES 3/NOV/2021 LUCY ENTRO 9:00\r\n8.- MASAJE REDUCTIVO 45M 4/NOV/2021 MIRENA ENTRO 9:06 \r\n9.- TERMOSLIN 9/NOVIEMBRE/2021 JOHANY ENTRO 9:00\r\n10.- CORPO 11/NOVIEMNRE/2021 MARIANA ENTRO 11:55\r\n1.- CAPSULA  12/NOVIEMBRE/2021 JOHANY ENTRO 10:00\r\n2.- MASAJE 45 15/NOVIEMBRE/2021 MIRENA ENTRO 9:00\r\n3.- VENDAS CALIENTES 17/NOVIEMBRE/2021 MIRENA ENTRO 12:00\r\n4.- 23/NOVIEMBRE/2021 CORPO  MIRENA ENTRO 12:05\r\n5.- TERMOSLIN 25/NOVIEMBRE/2021 MARIANA ENTRO 12:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('190', 'C-100190', '', 'MARDONIA GARCIA SIBAJA', '9932241749', '', '17/sept/16 masaje de espalda anita entro 12:00\r\n15/dic/16 masaje de espalda andrea entro 10:20\r\n21/dic/16 masaje de espalda andrea entro 10:05\r\n22/dic/16 facial diamond life infusion mary lazaro entro 9:05\r\n23/feb/17 masaje de espalda andrea entro 10.30\r\n23/FEB/17 LLEVO CREMA TENSO-REAFIRMANTE CUELLO Y ESCOTE TIMEXPERT LIN IN\r\n2/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE LUPITA ENTRO 3:50\r\n11/OCT/18 FACIAL COMPLETO  REYNA\r\n8/JULIO/19 MASAJE DE ESPALDA OFELIA ENTRO 2:55\r\n30/DIC/19 DIAMOND LIFE INFUSION, LIFTING DE COLAGENO, TRAT DE MANOS REYNA ENTRO 9:00\r\n28/DICIEMBRE/2021 TRATAMIENTO DE MANOS MIRENA ENTRO 3:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('191', 'C-100191', '', 'ROMANA GARCIA MONTEJO', '9931114366', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('192', 'C-100192', '', 'JUAN DIEGO GARCIA TILAN', '93640907', '', '31/oct/15 limpieza de acne con amp, desincrustante charito entro 11.30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('193', 'C-100193', '', 'HILDA MORALES GUTIERREZ', '', '', '9/ABRIL/19  DELINEADO DE CEJAS OFELIA ENTRO 10:10\r\n24/ABRIL/19 RETOQUE DE CEJAS OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('194', 'C-100194', '', 'BEATRIZ TORRES DE LA CRUZ', '9931286544', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('195', 'C-100195', '', 'ALONZO LAZARO GALLEGOS', '9931697533', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('196', 'C-100196', '', 'JOANA MADRIGAL BRANBILA', '9931389231', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('197', 'C-100197', '', 'MAYRA SOMER', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('198', 'C-100198', '', 'FERNANDA CRUZ LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('199', 'C-100199', '', 'ALEJANDRA CRUZ LOPEZ', '9171357241', '', '27/OCT/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY ENTRO 1:15\r\n16/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN BEL-LUCY\r\nCADA SESION $1,000.00\r\n24/NOV/18 CAVITACION Y MASAJE KARLA ENTRO 12:20 LLEVÓ CREMA CHAUFFANTE\r\nMASAJE 45 M, TERMO\r\nMASAJE 45 , CAPSULA\r\nLASER LIPOLITICO, MASAJE \r\nMASAJE 45 , CORPO\r\n15/NOV/19 PROMOCION TRAT DE PERLA ANITA ENTRO 11:35', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('200', 'C-100200', '', 'DIANA LAURA GONZALEZ RODRIGUEZ', '9371102063', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('201', 'C-100201', '', 'AURA LUZ GARCIA LOPEZ', '', '', '11-10-15 se realizo limp facial 2x1 y mdm de espalda mire cristal 3pm', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('202', 'C-100202', '', 'ELSA DOMINGUEZ MAGAÑA', '9931776128', '', '1.-demoledor 10 m, masaje 45 m, v f gel 30 m 09/marzo/06 mary\r\n2.-masaje 45 m, g-5 10 m, v f gel 30 m 22/marzo/06 mary\r\n3.-faja sauna 15 m, masaje 45 m, v f gel 30 m 24/marzo/06 mary\r\n4.-aro 15 m, masaje 45 m, v f gel 30 m 28/marzo/06 mary\r\n5.-demoledor 10 m, masaje 45 m, v f gel 30 m 30/marzo/06 mary\r\n6.-masaje 45 m, g-5 10 m, v f gel 30 m 31/marzo/06 mary\r\n7.-faja sauna 15 m, masaje 45 m, v f gel 30 m 03/abril/06 mary\r\n8.-aro 15 m, masaje 45 m, v f gel 30 m 04/abril/06 mary\r\n9.-demoledor 10 m, masaje 45 m, v f gel 30 m 05/abril/06 mary\r\n10.-masaje 45 m, g-5 10 m, v f gel 30 m 06/abril/06 bety\r\ntermino su tratamiento.\r\nno se midio ni se peso.\r\n23/abril/15 radio corporal mirena entro 4:10\r\n\r\ninicia tratamiento de masaje reductivo\r\n1.-masaje 45 m 01/agosto/06 marcela\r\n2.-masaje 45 m 02/agosto/06 marcela\r\n3.-masaje 45 m 03/agosto/06 marcela\r\n4.-masaje 45 m 08/agosto/06 marcela\r\n5.-masaje 45 m 10/agosto/06 marcela\r\n6.-masaje 45 m 11/agosto/06 marcela\r\n7.-masaje 45 m 14/agosto/06 marcela\r\n8.-masaje 45 m 15/agosto/06 marcela\r\n9.-masaje 45 m \r\n10.-masaje 45 m\r\n****se da por cancelado el tratamiento , \r\nno se presento a sus dos ultimas sesiones, \r\nel ultimo dia que vino fue el 15 de agosto del 2006 \r\nera un tratamiento de $1800 pesos ya estaba pagado. \r\n\r\ninicia tratamiento reductivo \r\ncon medidas en ombligo 90 cm peso 62 kilos\r\n\r\n1.-masaje 45 m, g-5 10 m 19/sept/06 marcela\r\n2.-masaje 45 m, g-5 10 m 20/sept/06 marcela entro 5:10\r\n3.-masaje 45 m, g-5 10 m 26/sept/06 marcela\r\n4.-masaje 45 m, g-5 10 m 28/sept/06 carmen\r\n5.-masaje 45 m, g-5 10 m 03/oct/06 marcela\r\n6.-masaje 45 m, g-5 10 m 04/oct/06 marcela\r\n7.-masaje 45 m, g-5 10 m 06/oct/06 carmen\r\n8.-masaje 45 m, g-5 10 m 10/oct/06 yesy\r\n9.-masaje 45 m, g-5 10 m 13/oct/06 marcela\r\n10.-masaje 45 m, g-5 10 m 17/oct/06 marcela\r\ntermino su tratamiento.\r\n\r\ninicia tratamiento corporal \r\n1.-masaje 45 m 20/nov/06 tana entro 10:00\r\n2.-masaje 45 m 23/nov/06 tana entro 8:30 salio 9:35\r\n3.-masaje 45 m 28/nov/06 tana entro 8:40 salio 9:55\r\n4.-masaje 45 m 30/dic/06 tana entro 8:30 salio 9:15\r\n5.-masaje 45 m 8/dic/06 tana entro 8:50 salio 9:42\r\n6.-masaje 45 m \r\n7.-masaje 45 m \r\n8.-masaje 45 m \r\n9.-masaje 45 m \r\n10.-masaje 45 m\r\n\r\ninicia tratamiento reductivo de $1800.00 \r\n1.-masaje 45 m 14/marzo/07 carmen entro 3:40\r\n2.-masaje 45 m 15/marzo/07 carmen entro 2:30 salio 3:30\r\n3.-masaje 45 m 16/marzo/07 carmen entro 2:25 salio 3:35\r\n4.-masaje 45 m 19/marzo/07 carmen entro 2:35\r\n5.-masaje 45 m 26/marzo/07 carmen entro 2:35 salio 3:30\r\n6.-masaje 45 m 27/marzo/07 carmen entro 5:20\r\n7.-masaje 45 m 28/marzo/07 carmen entro 3:15\r\n8.-masaje 45 m 02/mayo/07 carmen entro 2:30 salio 3:20\r\n9.-masaje 45 m 07/mayo/07 carmen entro 5:00 salio 5:50\r\n10.-masaje 45 m  \r\n\r\n\r\ninicia tratamiento corporal\r\n1.-masaje 45 m 14/mayo/07 oded entro 4:35\r\n2.-masaje 45 m 16/mayo/07 oded entro 8:10 salio 9:05\r\n3.-masaje 45 m 17/mayo/07 oded\r\n4.-masaje 45 m 18/mayo/07 oded entro 7:50 salio 8:40 \r\n5.-masaje 45 m 25/mayo/07 oded entro 8.10 salio 8:55\r\n6.-masaje 45 m 29/mayo/07 oded entro 8:10 salio 9:00\r\n7.-masaje 45 m 30/mayo/07 oded entro 8:05 salio 9:00\r\n8.-masaje 45 m 31/mayo/07 oded entro 8:10 salio 9:00\r\n9.-masaje 45 m 05/junio/07 oded entro 8:00 salio 9:00\r\n10.-masaje 45 m 08/junio/07 oded entro 4:15\r\ntermino su tratamiento.\r\ntiene pagado otro tratamiento de masaje reductivo de $1800.00\r\n1.-masaje 45 m 12/junio/07 ligia\r\n2.-masaje 45 m 15/junio/07 oded entro 8:10 salio 9:00\r\n3.-masaje 45 m 21/junio/07 odet entro 8:00 salio 8:55\r\n4.-masaje 45 m 06/julio/07 odet entro 8:15 salio 9:00\r\n5.-masaje 45 m 13/julio/07 ligia entro 8:10 salio 9:10\r\n6.-masaje 45 m \r\n7.-masaje 45 m \r\n8.-masaje 45 m \r\n9.-masaje 45 m \r\n10.-masaje 45 m \r\n\r\ninicia tratamiento de masajes reductivos. \r\nva a venir lunes, miercoles y viernes. no se le midio.\r\n1.-masaje 45 m 08/oct/07 bety entro 8:35 salio 9:30\r\n2.-masaje 45 m 10/oct/07 ligia entro 8:30 salio 9:25\r\n3.-masaje 45 m 16/oct/07 ligia entro 8:20 salio 9:10\r\n4.-masaje 45 m 14/nov/07 marcela entro 2:15\r\n5.-masaje 45 m 30/nov/07 marcela entro 8:20\r\n6.-masaje 45 m 29/ene/08 julia entro 8:10 salio 9:00\r\n7.-masaje 45 m 14/feb/08 lucy entro 8:15\r\n8.-masaje 45 m 25/feb/08 julia entro 5:45\r\n9.-masaje 45 m 3/marzo/08 julia entro 6:05\r\n10.-masaje 45 m 6/marzo/08 julia entro 6:15\r\ntermino tratamiento.\r\n\r\n15/marzo/08 masaje 45 m julia entro 8:30 \r\n24/marzo/08 masaje 45 m odet entro 8:20 salio 9:10\r\n27/marzo/08 masaje 45 m araceli entro 5:50 \r\n\r\ninicia masaje reductivo de 10 sesiones $1800.0\r\n1.-masaje 45 m 29/abril/08 marcela \r\n2.-masaje 45 m 9/mayo/08 bety \r\n3.-masaje 45 m 12/mayo/08 reyna entro 8:15 salio 9:00\r\n4.-masaje 45 m 19/mayo/08 bety entro 8:20 salio 9:10\r\n5.-masaje 45 m 29/mayo/08 araceli entro 8:20 salio 9:05\r\n6.-masaje 45 m 3/mayo/08araceli entro 8:30\r\n7.-masaje 45 m 4/junio/08 sara entro 8:30\r\n8.-masaje 45 m 7/junio/08 araceli entro 8:30 salio 9.30\r\n9.-masaje 45 m 11/julio/08 sara entro 8:20\r\n10.-masaje 45 m\r\n30/09/12  masaje reductivo atendio deya entro 12:25 mega \r\n\r\ninicia tratamiento reductivo completo $5000.00\r\nllevo trat. # 1 de pastillas peso 69.200 k.g.\r\n\r\n1.-masaje 45 m, termo 5/agosto/08 sara entro 8:25 salio 10:30 \r\n2.-masaje 45 m 8/agosto/08 sara entro 8:15 salio 9:15\r\n3.-aro 30 m, masaje 45 m 8/agosto/08 julia entro 5:00\r\n4.-masaje 45 m, g-5 10 m, v f 30 m 12/agosto/08 sara entro 5:15\r\n5.-aspired 20 m, masaje 45 m, v f 30 m 14/agosto/08 sara entro 8:10 \r\n6.-masaje 45 m, termo 15/agosto/08 sara entro 8:05 salio 9:00  \r\n7.-lumicell 20 m, masaje 45 m, v f 20 m 19/agosto/08 sara entro 8:20\r\n8.-capsula, masaje 45 m 21/agosto/08 marcela entro 6:00 \r\n9.-masaje 45 m 26/agosto/08 sara entro 8:10 salio 9:00\r\n10.- masaje 45 m 27/agosto/08 araceli entro 6:00 \r\ntermino el tratamiento. no se le debe nada.\r\n\r\ntratamiento reductivo $1800.00 dejo pagado todo. peso 68 kilos\r\n1.-masaje 45 m 2/sept/08 julia entro 6:00 \r\n2.-masaje 45 m 5/sept/08 julia \r\n3.-masaje 45 m 8/sept/08 julia entro 6:00\r\n4.-masaje 45 m 9/sept/08 julia entro 5:40\r\n5.-masaje 45 m 18/sept/08 julia entro 8:10 salio 9:10\r\n6.-masaje 45 m 22/sept/08 julia entro 6:00\r\n7.-masaje 45 m 24/sept/08 julia entro 6:10\r\n8.-masaje 45 m 29/sept/08 julia entro 8:25 salio 9:30\r\n9.-masaje 45 m 2/oct/08 julia entro 8:20 salio 9:20\r\n10.-masaje 45 m 9/oct/08 julia entro 8:20 salio 9:20\r\ntermino tratamiento.\r\n\r\ninicia tratamiento reductivo.\r\n1.-masaje 45 m 14/oct/08 julia entro 8:20\r\n2.-masaje 45 m 16/oct/08 julia entro 8:15\r\n3.-masaje 45 m 20/oct/08 julia entro 8:10 salio 9:10\r\n4.-masaje 45 m 21/oct/08 julia entro 8:20 salio 9:20\r\n5.-masaje 45 m 22/oct/08 julia entro 8:20 salio 9:10\r\n6.-masaje 45 m 29/oct/08 julia entro 8:20\r\n7.-masaje 45 m 4/nov/08 julia entro 8:10 salio 9:10\r\n8.-masaje 45 m 11/nov/08 julia entro 8:15 salio 9:15\r\n9.-masaje 45 m 17/nov/08 sara entro 12:40\r\n10.-masaje 45 m 18/nov/08 julia entro 8:10 salio 9:25\r\ntermino tratamiento.\r\n\r\ninicia tratamiento reductivo $1800.00 \r\n1.-masaje 45 m 10/dic/08 julia entro 8:00 salio 9:00 \r\n2.-masaje 45 m 22/dic/08 julia entro 8:15 salio 9:35\r\n3.-masaje 45 m 23/dic/08 julia entro 8:30 salio 9:25\r\n4.-masaje 45 m 6/ene/09 sara entro 8:30 salio 9:20\r\n5.-masaje 45 m 9/ene/09 julia\r\n6.-masaje 45 m 16/ene/09 araceli entro 8:30 salio 9:15\r\n7.-masaje 45 m 23/ene/09 julia entro 8:55 salio 9:45\r\n8.-masaje 45 m 24/ene/09 julia entro 8:30\r\n9.-masaje 45 m 26/ene/09 julia entro 8:40 salio 9:40\r\n10.-masaje 45 m 6/feb/09 julia entro 8:00 salio 9:00\r\ntermino tratamiento.\r\n\r\ninicia tratamiento reductivo $1800.00 \r\n1.-masaje 45 m 18/feb/09 gladys entro 8:40 salio 9:30 \r\n2.-masaje 45 m 20/feb/09 gladys entro 8:20 salio 9:20\r\n3.-masaje 45 m 23/feb/09 gladys entro 8:10 salio 9:10\r\n4.-masaje 45 m 4/marzo/09 gladys\r\n5.-masaje 45 m 9/marzo/09 gladys entro 8:20 salio 9:10\r\n6.-masaje 45 m 11/marzo/09 gladys entro 8:15 salio 9:10\r\n7.-masaje 45 m 17/marzo/09 bety entro 8:20 salio 9:20\r\n8.-masaje 45 m 19/marzo/09 reyna entro 8:15 salio 9:15\r\n9.-masaje 45 m 23/marzo/09 reyna entro 8:20\r\n10.-masaje 45 m 26/marzo/09 rosy entro 8:20 salio 9:10\r\n\r\ninicia tratamiento reductivo $2500.00\r\n1.-masaje 45 m 30/marzo/09 rosy entro 8:25\r\n2.-masaje 45 m 31/marzo/09 mary entro 8:25\r\n3.-masaje 45 m 1/abril/09 mary entro 8:15 salio 9:10\r\n4.-masaje 45 m 3/abril/09 mary entro 8:20 salio 9:20\r\n5.-masaje 45 m 13/abril/09 ofelia entro 9:20\r\n6.-masaje 45 m 14/abril/09 araceli entro 8:25 salio 9:25\r\n7.-masaje 45 m 16/abril/09 sara entro 8:25 salio 9:20\r\n8.-masaje 45 m 20/abril/09 gladys entro 8:30\r\n9.-masaje 45 m 21/abril/09 sara entro 8:25\r\n10.-masaje 45 m 23/abril/09 araceli entro 8:35 salio 9:35\r\ntermino tratamiento.\r\n\r\ninicia otro tratamiento $2500.00 abono $500.00 resta $2000.00\r\n1.-masaje 45 m 28/abril/09 araceli entro 8.15 salio 8:10\r\n2.-masaje 45 m 30/abril/09 reyna entro 8:30 salio 9:25\r\n3.-masaje 45 m 19/mayo/09 sara\r\n4.-masaje 45 m 20/mayo/09 mary entro 8:20 salio 9:30\r\n5.-masaje 45 m 26/mayo/09 sara entro 8:25 salio 9:20\r\n6.-masaje 45 m 29/mayo/09 sara entro 8:25 salio 9:15\r\n7.-masaje 45 m 2/junio/09 sara entr 8:10\r\n8.-masaje 45 m 4/junio/09 aracely entro 8:25\r\n9.-masaje 45 m 12/junio/09 reyna entro 8:20 salio 9:15\r\n10.-masaje 45 m 25/junio/09 karina entro 8:20\r\ntermino tratamiento.\r\n\r\ninicia tratamiento reductivo $2500.00 \r\n1.-masaje 45 m 30/junio/09 karina entro 5:55\r\n2.-masaje 45 m 2/julio/09 karina entro 6:00\r\n3.-masaje 45 m 6/julio/09 karina entro 8:25 salio 9:20\r\n4.-masaje 45 m 7/julio/09 marina\r\n5.-masaje 45 m 27/julio/09 marina entro 8.15 salio 9:15\r\n6.-masaje 45 m 29/julio/09 karina entro 8:30\r\n7.-masaje 45 m 3/agosto/09 sara entro 9:20\r\n8.-masaje 45 m 5/agosto/09 marina entro 5:20\r\n9.-masaje 45 m 12/agosto/09 sara entro 9:05\r\n10.-masaje 45 m 13/agosto/09 karina entro 6:00\r\n\r\ncarbo $250.00 c/s\r\n1.-12/agosto/09 carbo sara\r\n2.-14/agosto/09 carbo sara\r\n3.-17/agosto/09 carbo lupita\r\n4.-24/agosto/09 rosy\r\n5.-\r\n6.-\r\n7.-\r\n8.-\r\n9.-\r\n10.-\r\n11.-\r\n12.-\r\n13.-\r\n14.-\r\n15.-\r\n\r\n\r\n1.-masaje 45 m 14/agosto/09 karina entro 6:10\r\n2.-masaje 45 m 17/agosto/09 araceli entro 5:30\r\n3.-masaje 45 m 18/agosto/09 araceli entro 6:00\r\n4.-masaje 45 m 24/agosto/09 araceli entro 8:20\r\n5.-masaje 45 m 26/agosto/09 araceli entro 5:35\r\n6.-masaje 45 m 1/sept/09 karina entro 5:15\r\n7.-masaje 45 m 2/sept/09 araceli entro 5:30\r\n8.-masaje 45 m 7/sept/09 reyna entro 6:15\r\n9.-masaje 45 m 8/sept/09 marina entro 6:00\r\n10.-masaje 45 m 12/sept/09 karina entro 8:25 salio 9:25\r\n\r\n1.-masaje 45 m 14/sept/09 karina entro 8:20 salio 9:15\r\n2.-masaje 45 m 17/sept/09 mary entro 6:15\r\n3.-masaje 45m 29/sep/09 entro karina 6:05\r\n4.-masaje 45 m 7/oct/09 karina entro 8:20 salio 9:25\r\n5.-masaje 45 m 8/oct/09 marina entro 6:25\r\n6.-masaje 45m 10/oct/09 sara entro 6:02\r\n7.-masaje 45m 14/oct/09 entro karina 8:00\r\n8.-masaje 45m 12/nov/09 entro karina 8:00 salio 9:00\r\n\r\n21/dic/09 masaje 45 m eva entro 6:20\r\n22/dic/09 masaje 45 m karina entro 8:15 salio 9:15\r\n28/dic/09 masaje 45 m karina\r\n14/ene/10 masaje 45 m karina entro 6:20\r\n4/feb/10 masaje 45 m karina entro 8:10\r\n18/feb/10 masaje 45 m mariana entro 8:05 salio 9:00\r\n29/marzo/10 masaje 45 m mariana entro 3:10 \r\n30/marzo/10 masaje 45 m mariana entro 8:25 salio 9:30\r\n5/abril/10 masaje 45 m mariana entro 8:35 salio 9:30 \r\n6/abril/10 masaje 45 m lupita entro 6:20\r\n21/junio/10 msaje 45 m mariana entro 8:30 salio 9:30\r\n\r\nmasaje reductivo 10 sesiones $2500.00 pagado\r\n\r\n1.-22/junio/10 masaje 45 m karina entro 9:25\r\n2.-masaje 45 m 29/junio/10 karina entro 8:25\r\n3.-masaje 45 m 3/julio/10 araceli entro 9:10\r\n4.-masaje 45 m 5/julio/10 marina entro 8:35\r\n5.-masaje 45 m 6/julio/10 karina entro 8:25\r\n6.-masaje 45 m 7/julio/10 karina entro 8:15\r\n7.-masaje 45 m 30/julio/10 karina entro 11:25\r\n8.-masaje 45 m, dermosonic reyna entro 9:30 \r\n9.-masaje 45 m 2/agosto/10 karina entro 6:00\r\n10.-masaje 45 m 3/agosto/10 indira entro 8:25 \r\ntermino tratamiento.\r\n\r\ninicia tratamiento reductivo $2500.00\r\n1.-masaje 45 m 5/agosto/10 indira entro 9:10\r\n2.-masaje 45 m 9/agosto/10 sara entro 8:20\r\n3.-masaje 45 m 10/agosto/10 sara\r\n4.-masaje 45 m 13/agosto/10 indira entro 6:10\r\n\r\n5.-masaje 45 m 25/agosto/10 indira entro 8:15\r\n6.-masaje 45 m 6/sept/10 graciela entro 8:10\r\n7.-masaje 45 m 7/sept/10 graciela entro 8:35\r\n8.-masaje 45 m 10/sept/10 graciela entro 8:35\r\n9.-masaje 45 m 14/sept/10 sara entro 8:10\r\n10.-masaje 45 m 17/sept/10 chela entro 5:20 \r\ntermino \r\n\r\ninicia tratamiento $2500.00 pagado\r\n1.-masaje 45 m 20/sept/10 indira entro 8:20 \r\n2.-masaje 45 m 23/sept/10 reyna entro 6:15 \r\n3.-masaje 45 m 24/sept/10\r\n4.-masaje 45 m 05/oct/10 marina entro 8:35\r\n5.-masaje 45 m 11/oct/10 marina entro 8:30\r\n6.-masaje 45 m 25/oct/10 mariana entro 8:45 \r\n7.-masaje 45 m 10/nov/10 karina entro 8:10 \r\n8.-masaje 45 m 15/nov/10 reyna entro 3:15\r\n10.-masaje 45 m 6/dic/10 araceli\r\ntermino\r\n\r\n14/nov/10 masaje 45 m graciela entro 3:00 (sucursal) \r\n21/nov/10 masaje 45 m graciela entro 4:20 (sucursal) \r\n3/dic/10 se llevo trat # 4 \r\n7/dic/10 masaje reductivo lucy entro 8:33\r\n8/dic/10 masaje reductivo reyna entro 8:15\r\n13/dic/10 masaje reductivo marina entro 8:27\r\n14/dic/10 masaje reductivo deyanira entro 8:20\r\n\r\ntratamiento reductivo $3000.00 pagado\r\n1.-masaje 45 m 5/ene/11 susy entro 4:30 \r\n2.-7/ene/11 karina entro 8:25 \r\n3.-11/ene/11 rosy entro 6:10\r\n4.-14/ene/11 deyanira entro 2:58\r\n5.-15/ene/11 susy entro 8:30\r\n6.-19/ene/11 karina entro 8:34\r\n7.-24/ene/11 susy entro 8:15\r\n8.-31/ene/11 sara entro 2:14 \r\n9.-7/feb/11 mariana entro 1:30\r\n10.-8/feb/11 karina entro 8:25 salio 9:15\r\ntermino tratamiento.\r\n\r\n9 ene.11 indira entro 5:30\r\n7/feb/11 masaje de espalda mariana \r\ninicia masaje reductivo $3000.00 abono $1500.00 resta $1500.00\r\n1.-masaje 45 m 9/feb/11 reyna entro 2:31 \r\n2.-masaje 45 m 14/feb/11 deyanira\r\n3.-masaje 45 m 16/feb/11 deyanira entro 8:08\r\nmasaje 45 m 17/feb/11 jhoany entro 7:05 (sucursal)\r\n4.-masaje 45 m 23/feb/11 gladys entro 8:25 \r\n5.-masaje 45 m 28/feb/11 deyanira entro 8:25\r\n6.-masaje 45 m 14/marzo/11 deyanira entro 8:26\r\n7.-masaje 45 m 21/marzo/11 deyanira entro 1:00\r\n8.-masaje 45 m 28/marzo/11 deyanira\r\n9.-masaje 45 m 1/abril/11 deyanira\r\n10.-masaje 45 m 4/abril/11 araceli entro 8:15\r\ntermino tratamiento.\r\n21/marzo/11 masaje de espalda deyanira \r\n19/abril/11 masaje reductivo mariana entro 1:48 \r\ninicia tratamiento reductivo $3000.00 abono $2000.00 resta $1000.00\r\n1.-masaje 45 m 25/abril/11 deyanira entro 8:20\r\n25/abril/11 llevo trat. # 6 \r\n2.-masaje 45m 26/abril/11 deyanira  entro 8:20\r\n3.-masaje 45 m 27/abril/11 deyanira entro 6:00\r\n4.-masaje 45 m 29/abril/11 deyanira entro 6:05\r\n5.-masaje 45 m 2/mayo/11 araceli entro 6:10\r\n6.-masaje 45 m 9/mayo/11 mariana entro 8:30\r\n7.-masaje 45 m 16/mayo/11 araceli entro 6:05\r\n8.-masaje 45 m 21/mayo/11 susy entro 9:35\r\n9.-masaje 45 m 9/junio/11 reyna entro 11:30\r\n10.-masaje 45 m 7/julio/11 susy entro 5:20\r\ntermino tratamiento.\r\n\r\n03/04/11 masaje reductivo atendio:graciela. entro:4:00pm salio:5:00pm(suc)\r\n08/05/11 masaje reductivo atendio graciela entro5:05 pm salio 6:05 pm (suc)\r\n14/mayo/11 radiofrecuencia araceli entro 9:00\r\n16/mayo/11 radiofrecuencia sara entro 8:25\r\n20/mayo/11 radiofrecuencia  karina entro 6:00\r\n21/mayo/11 masaje de espalda susy entro 10:30\r\n9/junio/11 radiofrecuencia reyna\r\n12/06/11 masaje reductivo y trat. de endorfinas atendio susy entro 1:40 pm salio pm (suc) \r\n7/julio/11 llevo trat. # 7 \r\ninicia tratamiento de masajes reductivos $3000.00 abono $1000.00 resta $2000.00\r\n1.-masaje 45 m 11/julio/11 rosy entro 10:00\r\n2.-masaje 45 m 12/julio/11 sara entro 10:05\r\n3.-masaje 45 m 14/julio/11 sara entro 9:30\r\n4.-masaje 45 m 15/julio/11 sara entro 9:45\r\n5.-masaje 45 m 16/julio/11 gladys entro 8:35\r\n6.-masaje 45 m 19/julio/11 gladys entro 9:25\r\n7.- masaje 45 m 23/julio/11 rocio \r\n8..-masaje 45 m  9/agosto/11  mariana entro 9:30 abono $1,400.00\r\n9.-masaje 45 m  13/agosto/11 dulce entro 9:30 pago $600.00\r\n10.-masaje 45 m 22/agosto/11 dulce entro 2:05\r\ntermino tratamiento\r\n11/julio/11 llevo crema hydracure piel normal a mixta\r\n\r\n17/07/11 masaje reductivo atendio deyanira entro 4:00 pm salio 5:00 pm 6:35 pm \r\n17/07/11 tratamiento completo hidracuré atendio deyanira entro 4:10pm salio5:05 (suc mega)\r\nllevo ampolleta hydracure.\r\n21/julio/11 radiofrecuencia corporal gladys entro 9:50\r\n21/julio/11 llevo trat. # 6 \r\n21/08/11 tratamiento # 3 homeopatico y amp. hidracuré (suc mega)\r\n28/08/11 masaje reductivo i sesion atendio deyanira entro 2:15 pm salio 3.05  (mega)\r\n04/09/11 masaje reductivo atendio:deyanira entro:12:05pm salio:1:25 (suc mega)\r\n04/09/11 masaje de espalda.\r\n\r\ninicia tratamiento reductivo $3,000.00 abono $1,000.00 resta $2,000.00\r\n1.- masaje 45 m 05/sept/11 brenda 9:05\r\n2.- masaje 45 m  19/sep/11 brenda entro 10:40\r\n3.- masaje 45 m   26/sep/11 rocio entro 9:30 salio 10:30\r\n4.- masaje 45 m    30/sep/11 rocio entro 10:00 salio 11:00\r\n5.- masaje 45 m    03/oct/11 dulce entro 11:15\r\n6.- masaje 45 m    11/oct/11 reyna entro 11:50\r\n7.- masaje 45 m     12/oct/11 sara entro 9:30\r\n8.- masaje 45 m     17/oct/11 rocio entro 1:15\r\n9.- masaje 45 m     18/oct/11 sara entro 9:20\r\n10.- masaje 45 m    26/oct/11 rocio entro 8:10 salio 9:10\r\n\r\n25/09/11 masaje reductivo atendio:deyanira entro:1:30pm salio:2:25pm (suc mega)\r\n02/10/11 masaje reductivo/ masaje de espalda atendio deyanira entro 3.00 pm salio (mega)\r\n\r\n1.-28/oct/11 masaje 45m. 28/oct/11 rocio\r\n2.- 30/10/11  masaje reductivo atendio deyanira entro 11.30 salio (mega)\r\n3.-31/10/11 tratamiento nutritivo/ m. espalda atendio deyanira entro 11.30 salio 2:05 (mega)		 \r\n4.- 03/nov./11 masaje 45m. brenda entro 8:50\r\n5.-07/nov/11 masaje 45m aracely entro9:25\r\n6.-15/nov/11 masaje 45 m mariana entro 6:15\r\n7.-16/nov/11 rocio entro 1:00\r\n8.-masaje 45 m 24/nov/11 dulce entro 9:30\r\n9.-masaje 45 m 28/nov/11 rocio entro 9:35\r\n04/12/11 masaje 45m atendio deyanira (mega)\r\n\r\nreinicio corporal pago $3000 \r\n1.-masaje 45 y g5 sara entro alas 9:05 5/dic/11\r\n2.-masaje 45 m 10/dic/11 rocio entro 8:20\r\n3.-masaje 45 m 12/dic/11 sara entro 8:30\r\n4.-masaje 45 m 16/dic/11 karina entro 8:30\r\n5.-masaje 45 m 19/dic/11 rocio entro 8:15\r\n6.-masaje 45 m 22/dic/11 rocio entro 8:20\r\n7.-masaje 45 m 26/dic/11 rocio entro 9:00\r\n8.-masaje 45 m 28/dic/11 rocio entro 9:15\r\n9.-masaje 45 m 2/ene/12 karina entro 8:15\r\n10.-masaje 45 m 3/ene/12  karina entro 8:30 \r\n\r\ninicia tratamiento\r\n1.-masaje 45 m 9/ene/12 mariana entro 8:25\r\n2.-masaje 45 m 12/ene/12 karina entro 10:15\r\n3.-masaje 45 m 16/ene/12 sara entro 8:05\r\n4.-masaje 45 m 18/ene/12 sara entro 8:15\r\n5.-masaje 45 m 19/ene/12 sara entro 8:05 salio 9:05\r\n6.-masaje 45 m  22/ene/12 deyanira entro 10:15 (mega)\r\n7.-masaje 45 m 30/ene/12 aracely\r\n8.-masaje 45 m 1/feb/12 reyna entro 8:45\r\n9.-masaje 45 m 6/feb/12 karina entro 12:00\r\n10.-masaje 45 m 8/feb/12 gladys entro 9:40\r\ntermino tratamiento\r\n28/01/12 masaje reductivo atendio deyanira entro 3:00 (mega)\r\ninicia tratamiento de masaje reductivos $3000.00 abono $1500.00 resta $1500.00\r\n1.-masaje 45 m 13/feb/12 karina entro 9:20\r\n2.-masaje 45 m 15/feb/12 mariana entro 9:00\r\n3.-masaje 45 m 20/feb/12 reyna entro 9:40\r\n4.-masaje 45 m 27/feb/12 gladys entro 10:00\r\n5.-masaje 45 m 1/marzo/12 mary entro 9:40\r\n6.-masaje 45 m 8/marzo/12 karina \r\n7.-masaje 45 m 9/marzo/12 sara entro 8:30\r\n8.-masaje 45 m 12/marzo/12 sara entro 8:50\r\n9.-masaje 45 m 19/marzo/12 aracely\r\n10.-masaje 45 m 3/abril/12  gladis entro9:10\r\ntermino tratamiento.\r\n04/03/12 limp facial reductivo atendio deyanira entro 12.30 (mega)\r\n01/04/12 masaje reductivo atendio deyanira entro 3.10 (mega)\r\n4/abril/12 radiofrecuencia sara entro 2:10\r\ninicia trat. de masaje reductivo $3000.00 abono $1500.00 resta $1500.00\r\n1.-masaje 45 m 9/abril/12 karina entro 10:05\r\n2.-masaje 45 m 16/abril/12 ofe entro 10:15\r\n3.-masaje 45 m 23/abril/12 reyna entro 9:30\r\n4.masaje 45 m 30/abril/12 aracely entro 9:50\r\n5.-masaje 45 m 2/mayo/12 aracely entro 10:00\r\n6.-masaje 45 m 7/mayo/12 sara\r\n7.-masaje 45 m 10/mayo/12 karina entro 8:05\r\n8.-masaje 45 m 14/mayo/12 karina entro 8:50\r\n9.-masaje 45 m \r\n10.-masaje 45 m 4/junio/12 karina entro  8:30\r\ntermino tratamiento.\r\n27/05/12 masaje reductivo atendio graciela entro 1:50 mega y llebo homeopatia # 0 (mega)\r\n4/junio/12 abono $1500.00 pesos para otro tratamiento.\r\n1.-masaje 45 m 5/junio/12 aracely entro 8:55\r\n2.-masaje 45 m 7/junio/12 reyna entro 5:30\r\n3.-masaje 45 m 11/junio/12 karina entro 8:50\r\n4.-masaje 45 m 18/junio/12 diana entro 5:45\r\n5.-masaje 45 m 25/junio/12 diana entro 8:15\r\n\r\n6.-masaje 45 m 29/junio/12 aracely entro 8:30\r\n7.-masaje 45 m 2/julio/12 araceli susy entro 9:40\r\n8.-masaje 45 m 3/julio/12 diana entro 5:50\r\n9.-masaje 45 m 9/julio/12 sara entro 8:35\r\n10.-masaje 45 m 17/julio/12 diana entro 6:00\r\ntermino tratamiento.\r\n4 masaje reductivo atendio jhoany entro 4:20(mega)\r\nmasaje de espalda atendio jhoany entro 4:20 ( mega) \r\n16/06/2012 prom del mes atendio jhoany entro 6:35\r\nreinicio trat.corporal\r\n1.-masaje 45m reyna entro 4:40\r\n2.-masaje 45m graciela 6:00\r\n3.-masaje 45 m 15/agosto/12 araceli entro 6:10\r\n4.-masaje 45 m 3/sept/12 graciela entro 5:45\r\n5.-masaje 45 m 11/sept/12 reyna entro 8:45\r\n6.-masaje 45 m 17/sept/12 karina entro 3:30\r\n7.-masaje 45 m 18/sept/12 araceli entro 5:45\r\n8.-masaje 45 m 27/sept/12 araceli \r\n9.-masaje 45 m 2/oct/12 reyna\r\n10.-masaje 45 m 31/oct/12 araceli entro 5:35\r\ntermino tratamiento\r\n5/nov/12 pago 10 sesiones de masaje reductivo\r\n1.-masaje 45 m 5/nov/12 karina entro 9:30\r\n2.-masaje 45 m 19/nov/12 gladys entro 11:30\r\n3.-masaje 45 m 11/dic/12 karina entro 5:55\r\n4.-masaje 45 m 17/dic/12 karina entro 6:00\r\n5.-masaje 45 m 26/dic/12 reyna entro 12:05\r\n6.-masaje 45 m 27/dic/12 karina entro 5:30\r\n7.-masaje 45 m 7/ene/13 gladys entro 9:00\r\n8.-masaje 45 m 16/ene/13 yusiria entro 8:15\r\n9.-masaje 45 m 22/ene/13 graciela entro 9:30\r\n22/ene/13 depilacion de bikini lucy\r\n22/ene/13 llevo trat. # 2 \r\n10.-masaje 45 m 24/ene/13 ana entro 5:15\r\ntermino tratamiento.\r\ninicia otro tratamiento reductivo $3000.00 abono $1500.00 resta $1500.00\r\n1.-masaje 45 m 30/ene/13 ana entro 6:20\r\n2.-masaje 45 m 19/feb/13 nelli entro 6:05\r\n3.-masaje 45 m 7/marzo/13 nelli entro 9:20\r\n4.-masaje 45 m 25/marzo/13 gladys entro 9:50\r\n25/marzo/13 radio corporal gladys\r\n5.-masaje 45 m 26/marzo/13 martha\r\n27/marzo/13 radiofrecuencia reyna entro 10:30\r\n6.-masaje 45m  01/04/13 mariana entro 1:05\r\n7.- masaje 45 m 5/abril/13 gladis entro 9:10\r\n8.-masaje 45m 8/abril/13 gladys entro 10:35\r\nmasaje de espalda\r\n9.-masaje 45 m 11/abril/13 nelli entro 2:10\r\n10.- masaje 45m. 16/abril/13 entro graciela  12:50\r\ninicia masaje reductivo $3000.00 abono $1000.00 resta $2000.00\r\n1.-masaje 45 m 22/abril/13 yusiria entro 9:30\r\n2.-masaje 45 m 23/abril/13 yusiria\r\n3.-masaje 45 m 26/abril/13 martha\r\n4.-masaje 45 m 30/abril/13 yusiria entro 10:05\r\n5.-masaje 45 m 6/mayo/13 ana entro 9:15\r\n6.-masaje 45 m 13/mayo/13 ana entro 9:35\r\n7.-masaje 45 m 22/mayo/13 yusiria entro 10:40\r\n8.-masaje 45 m 3/junio/13 ana entro 9:40\r\n9.-masaje 45 m 17/junio/13 gladys\r\n10.-masaje 45 m 1/julio/13 ana entro 9:30\r\ntermino tratamiento.\r\n1/julio/13 dejo abono de $1500.00 para otro trat reductivo\r\ninicia tratamiento reductivo \r\n1.-masaje 45 m 9/julio/13 graciela entro 6:00\r\n2.-masaje 45 m 10/julio/13 gladys entro 9:15\r\n3.-masaje 45 m 11/julio/13 rosy entro 6:00\r\n4.-masaje 45 m 12/julio/13 carolina entro 6:00 \r\n5.-masaje 45 m  9/agosto/13 yusiria \r\n6.-masaje 45 m 10/agosto/13 carolina entro 8:50\r\n7.-masaje 45 m 12/agosto/13 graciela entro 9:10\r\n8.-masaje 45 m 13/agosto/13 reyna entro 5:35\r\n9.-masaje 45 m 19/agosto/13 yusiria entro 9:45\r\n10.-masaje 45 m 27/agosto/13 ana entro 9:20\r\n\r\ninicia tratamiento reductivo \r\n1.-masaje 45 m 28/agosto/13 carolina entro 9:10\r\n2.-masaje 45 m 3/sept/13 carolina entro 6:00\r\n3.-masaje 45 m 9/sept/13 graciela entro 9:00\r\n9/sept/13 criolipolisis graciela\r\n4.-masaje 45 m 10/sept/13 mirena entro 9:15\r\n5.-masaje 45 m 11/sept/13 ana entro 1:10\r\n23/septiembre/13 criolipolisis mariana entro 1:05 \r\n27/sept/13 criolipolisis espalda ofelia entro 10:05\r\n2/octubre/13 criolipolisis espalda, masaje 45 m yusiria entro 11:30 \r\n6.-masaje 45 m 2/oct/13 yusiria\r\n7.-masaje 45 m 3/oct/13 mirena abono $1000.00 resta $500.00\r\n8.-masaje 45 m 5/oct/13 yusiria entro 8:30\r\n9.-masaje 45 m 7/oct/13 mariana entro 8:40\r\n10.-masaje 45 m 9/oct/13 ana \r\ntermino tratamiento \r\n9/oct/13 criolipolisis en brazos ana\r\n15/oct/13 criolipolisis en abdomen gladys entro 8:45\r\ninicia trat reductivo $3000.00 abono $1000.00 resta $2000.00\r\n1.-masaje 45 m 15/oct/13 gladys entro 8:45\r\n2.-masaje 45 m  21/oct/13  ana entro 8:55\r\n3.-masaje 45 m 24/oct/13 mirena entro 8:20\r\n31/oct/13 criolipolisis en espalda gladys \r\n31/oct/13 masaje express gladys\r\n4.-masaje 45 m  11/nov/13 susi entro 1:05\r\n5.-masaje 45 m 12/nov/13 carolina entro 8:10\r\n6.-masaje 45 m 18/nov/13 nelli entro 925 termino de pagar \r\n18/nov/13 criolipolisis en abdomen nelli\r\n7.-masaje 45 m 21/nov/13 carolina entro 8:45\r\n8.-masaje 45 m 22/nov/13 carolina entro 8:10\r\n9.-masaje 45 m 25/nov/13 carolina entro 8:15\r\n10.-masaje 45 m 10/dic/13 reyna entro 5:15\r\ntermino tratamiento\r\n19/dic/13 criolipolisis en abdomen mariana entro 6:00\r\ninicia masaje reductivo $3000.00 abono $1000.00 resta $2000.00\r\n1.-masaje 45 m 23/dic/13 carmen entro 8:20\r\n30/dic/13 criolipolisis en espalda mariana entro 8:50\r\n2.-masaje 45 m 1/feb/14 carmen entro 9:40\r\n1/feb/14 criolipolisis en abdomen carmen entro 9:40\r\n3.-masaje 45 m 09/02/14 martha mega entro 2:10\r\n4.-masaje 45 m \r\n5.-masaje 45 m \r\n6.-masaje 45 m \r\n7.-masaje 45 m \r\n8.-masaje 45 m \r\n9.-masaje 45 m \r\n10.-masaje 45 m \r\n18/feb/14 criolipolisis en espalda yusiria entro 6:00\r\n6/marzo/14 criolipolisis en abdomen graciela entro 4 :55\r\n11/marzo/14 facial desafio antiedad nb bego entro 5:40\r\n17/marzo/14 llevo crema the cure, y crema the cure con color\r\n25/marzo/14 criolipolisis en espalda carmen entro 9:15\r\n26/marzo/14 tratamiento facial revitalizante de jabotiere bego 5:50\r\n31/marzo/14 micro parte baja de gluteos $850.00 c/s lucy entro 3:50\r\n8/abril/14 criolipolisis en abdomen nelli entro 9:20\r\n10/abril/14 micro parte baja de gluteos lucy entro 4:25\r\n10/abril/14 criolipolisis en espalda yusiria entro 5:25\r\n25/abril/14 radiofrecuencia corporal atendio mariana entro 3:00\r\n28/abril/14 criolipolisis en abdomen carmen entro 9:15\r\n26/mayo/14 radiofrecuencia en abdomen yusiria entro 6:00\r\ntratamiento reductivo $6000.00 pagado\r\n1.-carbo, corpo 29/mayo/14 mariana entro 4:45\r\n31/mayo/14 facial timexpert rides bego entro 9:30\r\n2.-laser lipolitico 20 m, masaje 45 m 5/junio/14 yusiria entro 6:00 no se le dio el masaje\r\n3.-radiofrecuencia 50 m 7/junio/14 yusiria entro 8:45 llevo desmaquillante de ojos y espuma \r\nlimpiadora de natura bisse\r\n4.-carbo, termoslin 16/junio/14 mirena entro 5:00\r\n5.- laser lipolitico 20m masaje 45m  23/junio/14 ana entro 5:45\r\n6.-radio 50m 28/julio/14 nelli entro 4:25\r\n7.-carbox  termo \r\n8.-laser lipo 20m masaje45m\r\n9.-rsdio 50m\r\n10.-carbox. termo.\r\n07/07/14 trat. de retinol sra bego mega 5:25\r\n9/julio/14 criolipolisis abdomen ana entro 6:00\r\n18/julio/14 criolipolisis ana entro 2:15\r\n21/julio/14 criolipolisis mirena entro 5:30\r\n26/julio/14 radiofrecuencia corporal graciela entro 10:55\r\n26/julio/14 micro(gluteos) graciela entro 10:55\r\n31/julio/14 radiofrecuencia corporal nelli entro 9:00\r\n07/agosto/14 radiofrecuencia corporal mariana entro 8:25\r\n25/agosto/14 masaje reductivo lucero entro 2:00\r\n5/sep/14 radio frecuencia corporal mirena entro 3:30\r\n5/sep/14 mdm espalda mirena salio 5:20\r\n23/sept/14 radiofrecuencia carmen entro 5:30\r\n3/oct/14 criolipolisis en abdomen brenda entro 4:15\r\n13/oct/14 radiofrecuencia corporal mariana entro 4:50\r\n16/oct/14 criolipolisis en espalda mirena entro 6:09\r\n18/oct/14 radio frecuencia corporal anita entro 12:40\r\n31/oct/14 criolipolisis lucero entro 5:45\r\n22/nov/14 radio frecuencia corporal yusiria entro 2:15\r\n26/nov/14 radio frecuenciacorporal yusiria entro 6:00\r\n6/dic/14 criolipolisis lucero entro 11:50\r\n13/dic/14 radiofrecuencia mirena entro 10:00\r\n20/dic/14 radiofrecuencia corporal mirena entro 10:15\r\n26/dic/14 criolipolisis ana entro 4:30\r\n26/dic/14 facial aqua de natura bisse bego entro 5:20\r\n27/dic/14 radiofrecuencia en espalda y brazos carmen entro 9:15\r\n2/ene/15 radiofrecuencia johany entro 3:20\r\n17/ene/15 criolipolisis en brazos y espalda brenda entro 11:10\r\n20/enero/15 baño de novia (regalo de la sra. bego) mirena entro 9]:15\r\n28/abril/15 criolipolisis ana entro 4.30\r\n17/junio/15 criolipolisi en abdomen eva entro 3.25\r\n30/abril/15 radio corporal mirena entro 4:00\r\n12/sept/15 radio corporal graciela entro 1:35\r\n17/oct/15 criolipolisis graciela entro 10:30\r\n3/nov/15 radio corporal andrea entro 8:40\r\n7/nov/15 radio corporal mary lazaro entro 9:05\r\n14/nov/15 criolipolisis mary lazaro entro 10:00\r\n16/nov/15 radio corporal mariana entro 1:10\r\n18/nov/15 radio corporal ofelia entro 10:30\r\n19/dic/15 criolipolisis graciela entro 9:15\r\ndejo pagada una sesion de radio corporal \r\n26/dic/15 masaje reductivo lizvet entro 10:045 y la radio que tenia pagada mary lazaro entro 11:00\r\n30/ene/16 radio corporal reyna entro 9:25\r\n19/feb/16 radio corporal charito entro 1:_15\r\n10/ene/16 criolipolisis maria entro 9.20\r\n8/marzo/16 radio corporal charito entro 4:10\r\n12/marzo/16 radio corporal charito entro 10:05\r\n17/marzo/16 criolipolisis carmen entro 2.30\r\n19/marzo/16 radio corporal ofelia entro 10.30\r\n22/marzo/16 radiofrecuencia corporal mary lazaro entro 9:4\r\n\r\n01/agosto/16  criolipolisis mirena entro 4:20\r\n23/ENERO/ 18 CRIOLIPÓLISIS MARIANA ENTRO 10:25\r\n23/MARZO/18  TRATAMIENTO DE LIPOSONIC 8 DISPAROS DE .08 SRA BEGO \r\n23/JULIO/18   CRIOLIPOLISIS  REYNA ENTRO 10:30\r\n\r\n14/MARZO/19 CRIOLIPOLISIS LUPITA ENTRO 10:45\r\n11/ABRIL/19 CRIOLIPOLISIS ANITA ENTRO 12:45\r\n13/ABRIL/19 PRP CCE 7,000 DR OSCAR\r\n11/JUNIO/19 FACIAL HYDRACURE CON 5 MINUTOS DE CRIOTERAPIA OFELIA ENTRO 9:45\r\n15/JUNIO/19 CRIOLIPOLISIS CARMEN ENTRO 9:10\r\n28/JUNIO/19 CRIOLIPOLISIS EN BRAZOS Y MUSLO LUCY ENTRO 9:15\r\n28/JUNIO/19 FACIAL VITAMINA C DE GERMAINE LUCY ENTRO 9:15\r\n4/JULIO/19 CRIOLIPOLISIS LUPITA ENTRO 12:55\r\n10/JULIO/19 MICRO PUNTA DIAMANTE MARY LAZARO ENTRO 10:00\r\n11/JUNIO/19 CRIOLIPOLISIS ALE ENTRO 2:20\r\n17/JULIO/19 CRIOLIPOLISIS LUPITA ENTRO 1:35\r\n19/JULIO/19 4 DISPAROS DE LIPOSONIC LUCY\r\n19/JULIO/19 LIMPIEZA FACIAL CON AMP. ACIDO HIALURONICO LUCY ENTRO 9:30\r\n14/AGOSTO/19 CRIOLIPOLISIS EN ABDOMEN MARY LAZARO ENTRO 3:10\r\n22/AGOSTO/19 CRIOLIPOLISIS  ALE ENTRO 1:15\r\n23/AGOSTO/19 PROMOCION PORCELANA MARY LAZARO ENTRO 9:55\r\n10/SEP/19 CRIOLIPOLISIS MARY LAZARO ENTRO 1:45\r\n18/SEPT/19 CRIOLIPOLISIS BRAZOS, ENTRE PIERNA OFELIA ENTRO 10:00\r\n23/SEPT/19 CRIOLIPOLISI REYNA \r\n23/SEPT/19 HYDRAFACIAL CON AMP. ACIDO HIALURONICO $1,500.00 OFELIA ENTRO 9:35\r\n4/OCT/19 CRIOLIPOLISIS LUPITA ENTRO 10:40\r\n8/OCT/19 CRIOLIPOLISIS EN ESPALDA Y BRAZOS ANITA ENTRO 10:05\r\n11/OCT/19 CRIOLIPOLISIS LUPITA ENTRO 9:40\r\n19/OCTUBRE/19 LIPOSONIX 9 DISPAROS OFELIA ENTRO 8:15\r\n29/OCTUBRE/19 LIPOSONIX 10 DISPAROS LUCY\r\n1/NOV/19 CRIOLIPOLISIS EN ESPALDA A LOS COSTADOS OFELIA ENTRO 9:55\r\n4/DIC/19 LIPOSONIC 7 DISPAROS 20 J LUCY \r\n12/DICIEMBRE/19 CRIOLIPOLISIS ANITA  ENTRO 2:45\r\n21/DICIEMBRE/19 CRIOTERAPIA ANITA ENTRO 10:50\r\n26/DICIEMBRE/19 11 DISPAROS DE LIPOSONIX LUCY\r\n4/SEPTIEMBRE/2020 FACIAL NEW AGE  OFELIA ENTRO 9:35\r\n24/OCT/2020 PROMOCION TRAT GOLD REGENERANTE MONICA ENTRO 9:25\r\n12/DIC/2020 FACIAL EXCEL THERAPY O2 Y LIFTING DE COLAGENO OFELIA ENTRO 8:10\r\n1/JUNIO/2021 CRIOTERAPIA MARIANA\r\n8/JUNIO/2021 HYDRAFACIAL Y 6 DISPAROS DE LIPOSONIX LUCY ENTRO 10:55\r\n11/JUNIO/2021 12 DISPAROS DE LIPOSONIC LUCY\r\n15/JUNIO/2021 CRIOTERAPIA MARIANA ENTRO 1:00\r\n25/JUNIO/2021 PROMOCION TRAT RETINOL MARY LAZARO ENTRO 12:15\r\n29/JUNIO/2021 CRIOTERAPIA JOHANY ENTRO 12:10\r\n1/JULIO/2021 CRIOTERAPIA MARY LAZARO ENTRO 11:15\r\n6/JULIO/2021 CRIOTERAPIA MARIANA ENTRO 11:15\r\n7/JULIO/2021 CRIOTERAPIA JHOANY ENTRO 9:50\r\n12/JULIO/2021 CRIOTERAPIA EN ABDOMEN, BRAZOS Y PIERNAS JHOANY ENTRO 9:50 12/JULIO/2021 LLEVO CREMA CHAUFFANTE\r\n14/JULIO/2021 PROMOCION TRAT CAVIAR Y ORO ANITA ENTRO 10:00\r\n10/AGOSTO/2021 12 DISPAROS DE LIPOSONIX LUCY ENTRO 2:45\r\n16/AGOSTO/2021 CARBOX OFELIA ENTRO 1:00\r\n18/AGOSTO/2021 HYDRAFACIAL CON VITAMINA C $2000.00 MARIANA ENTRO 1:00\r\n27/AGOSTO/2021 CARBOX MIRENA ENTRO 10:30\r\n31/AGOSTO/2021 3° CARBOXITERAPIA JOANA ENTRO 10:17 \r\n1/SEPT/2021 HYDRAFACIAL CON COLAGENO MARY LAZARO ENTRO 12:00\r\n14/DIC/2021 TRATAMIENTO FACIAL GLYCOCURE, CARBOX MARY LAZARO ENTRO 10:25\r\n21/DIC/2021 CRIOTERAPIA JHOANY ENTRO 1:10\r\n7/ENERO/2022 CRIOTERAPIA ARLETH 10:10\r\n7/ENERO/2022 4 DISPAROS DE LIPOSONIC LUCY\r\n18/ENERO/2022 CRIOTERAPIA LUCY ENTRO 11:20\r\n21/ENERO/2022 HIDROADERMABRASION CON AMP. DE COLAGENO OFELIA\r\n27/ENERO/2022 CRIOTERAPIA LUCY ENTRO 10:25\r\n29/ENERO/2022 TRATAMIENTO LASER DE CARBONO LUCY ENTRO 10:25\r\n9/FEBRERO/2022 CRIOTERAPIA LUCY  ENTRO 10:40\r\n9/FEBRERO/2022 HYDRODERMABRASION MARY LAZARO ENTRO 11:20\r\n8/ABRIL/2022 CRIOTERAPIA MARIANA ENTRO 2:20\r\n11/ABRIL/2022 CRIOTERAPIA LUCY ENTRO 1:00\r\n30/JULIO/2022 FACIAL HYDRACURE JHOANY ENTRO 11:15\r\n30/JULIO/2022 LIPOSONIX HIFU BADOMEN JHOANY\r\n1/AGOSTO/2022 CRIOTERAPIA ARIANA ENTRO 10:50\r\n30/AGOSTO/2022 CRIOTERAPIA ARIANA ENTRO 9:05\r\n5/SEPT/2022 CRIOTERAPIA DOS AREAS ARIANA ENTRO 9:35\r\n26/SEPT/2022 TRATAMIENTO FACIAL VITAMINA C RADIANCE MARY LAZARO ENTRO 10:40\r\n26/SEPT/2022 CRIOTERAPIA EN ABDOMEN ARIANA ENTRO  10:40\r\n26/OCTUBRE/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA CON AMP. DE COLAGENO LUCY \r\n26/OCTUBRE/2022 LIPOSONIC EN ABDOMEN CRISTINA ENTRO 11:15\r\n3/NOVIEMBRE/2022 LIPOSONIC EN ABDOMEN LUCY ENTRO 12:10\r\n8/NOVIEMBRE/2022 LIPOSONIC BRAZOS, ENTRE PIERNAS, ABDOMEN JHOANY ENTRO 9:05\r\n8/NOVIEMBRE/2022 HIDRODERMABRASION CON AMPOLLETA MARIANA ENTRO 9:05\r\n17/NOVIEMBRE/2022 LIPOSONIC EN ABDOMEN MARY LAZARO ENTRO 12:50\r\n23/NOVIEMBRE/2022 HYDRADERMOABRASION MARY LAZARO ENTRO 11:30\r\n23/NOVIEMBRE/2022 LIPOSONIC MARIANA\r\n30/NOVIEMBRE/2022 LIPOSONIC DOA AREAS MARY LAZARO ENTRO 2:55\r\n15/DICIEMBRE/2022 LIPOSONIC MARY LAZARO ENTRO 9:10\r\n18/ENERO/2023 LIPÒSONIC LUCY ENTRO 10:15\r\n22/FEBRERO/2023 CRIOTERAPIA LUCY ENTRO 9:25\r\n22/FEBRERO/2023 HIDRODERMOABRASION OFELIA ENTRO 9:30\r\n7/MARZO/2023 CRIOTERAPIA MARIANA ENTRO 4:15\r\n7/MARZO/2023 COLLIFTING JHOANY\r\n16/MARZO/2023 CRIOTERAPIA OFELIA ENTRO 12:00\r\n24/MARZO/2023 LIPOSONIC/RADIO JHOANY ENTRO 1:15\r\n28/MARZO/2023 LIPOSONIC MARYFER ENTRO 10:20\r\n28/MARZO/2023 HIDRODERMOABRASION JHOANY ENTRO 10:20\r\n4/ABRIL/2023 LIPOSONIC/RADIO JHOANY ENTRO 9:20 LLEVO MASCARILLA HYALURONIC\r\n5/MAYO/2023 TERMOSLIN SRA. BEGO ENTRO 11:15\r\n12/JUNIO/2023 LIPOSONIC/RADIO, 8 DISPAROS DE LIPOSONIC LUCY ENTRO 10:20\r\n28/JUNIO/2023 16 DISPAROS DE LIPOSONIC LUCY ENTRO 9:45\r\n4/JULIO/2023 LIPOSONIC RADIO LUCY ENTRO 12:25\r\n8/JULIO/2023 CRIOTERAPIA EN ABDOMEN OFELIA ENTRO 11:10\r\n8/JULIO/2023 ANALISIS DE PIEL SRA. BEGO ', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-11 15:46:13', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('203', 'C-100203', '', 'MARICELA DAMIAN SILVAN', '9932092523', '', '19/ene/16 depilacion de brasileña y pantorrilla lucy entro 5:40\r\n10/mayo/16 facial con lifting#2 y amp de colageno ofelia entro 11.00\r\n10/mayo/16 depilación de pantorrilla y bikini lucy \r\n17/junio/16 depilación brasileño lucy entro 11.50\r\n3/abril/17 depilacion de pantorrilla mary entro 11:35\r\n4/abril/17 promocion termico anita entro 10:40\r\n25/abril/17 depilacion de pantorrilla, brasileña total anita \r\n23/junio/17 facial multisensorial de diamond natura bisse anita entor 11:15\r\n08/FEB/18  DE BIKINI TOTAL C/CERA MARIANA ENTRO 12:00\r\n27/MARZO/18 DEP DE BIKINI TOTAL MARIANA ENTRO 10:40\r\n1/FEB/19 DEPILACION CON CERA DE PANTORRILLAS MARY ENTRO 12:45\r\n4/MARZO/19 DEPILACION DE PANTORRILLAS ANITA ENTRO 1:35\r\n6/ABRIL/19 DEPILACION DE PANTORRILLAS MARY ENTRO 2:15\r\n16/ABRIL/19 DEPILACION TOTAL DE BIKINI LUCY\r\n17/MAYO/19 DEPILACION CON CERA DE PANTORRILLAS Y BIGOTE MARY ENTRO 1:25\r\n12/JUNIO/19 DEPILACION DE PANTORRILLAS Y BIGOTE ANITA ENTRO 6:20\r\n17/AGOSTO/19 DEPILACION CON CERA DE PANTORRILLAS Y BIGOTE ANITA \r\n7/SEPT/19 DEPILACION DE PANTORRILA OFELIA ENTRO 10:45\r\n5/NOV/19 DEPILACION DE PANTORRILLA OFELIA ENTRO 11:30\r\n5/NOV/19 HYDRAFACIAL OFELIA-ANITA ENTRO 11:30\r\nPRESUPUESTO: SU ESPOSO VA A MANDAR ABONO DEL TRATAMIENTO CADA VEZ QUE LE TOQUE CITA. \r\n15 SESIONES DE DEPILACION LASER DE: \r\nAXILA $360.00 CADA SESION\r\nBIKINI TOTAL $650.00 CADA SESION\r\nBIGOTE $180.00 CADA SESION\r\nMENTON $200.00 CADA SESION \r\nPANTORRILA $750.00 CADA SESION \r\n8 SESIONES DE IPL $1,000.00 CADA SESION\r\n8 SESIONES DE DIAMOND WHITE $2,500.00 CADA SESION\r\nSE LE DIO CREMA ACLARADORA LASMA SKIN AL 2 % Y 4 %, SERUM, SPOT Y CREMA TIMEXPERT WHITE, HELIOCARE COMPACTO.\r\nTOTAL:65,810.00 \r\n10/FEB/2020 ABONO $3,000.00 RESTA $62,810.00\r\n12/FEB/2020 ABONO $8,500.00 RESTA $54,310.00\r\n11/FEBRERO/20 INICIA DEPILACION LASER DE PANTORRILLA 30 MS 10 J AXILA, BIGOTE Y MENTON 30 MS 10 J LUCY\r\n13/FEBRERO/20 LASER DE BIKINI 30 MS 10 J MAS ABAJO 100 10 J LUCY\r\n1.-17/FEB/2020 DIAMOND WHITE LUCY ENTRO 11:15\r\n18/FEBRERO/20 INICIA IPL  MANCHAS PROG 1 INT 3 LUCY\r\n2.- 25/FEBRERO/20 FACIAL DIAMOND WHITE LUCY ENTRO 12:50\r\n3.-FACIAL DIAMOND WHITE 3/MARZO/2020 ANITA ENTRO 11:00\r\n10/MARZO/20 LASER DE PANTORRILAS 30 MS 12 J, AXILA, BIGOTE MENTON 30 MS 12 J Y BRASILEÑA 30 MS 11 J LUCY ENTRO 12:15\r\n4.-FACIAL DIAMOND WHITE 14/MARZO/2020 LUCY ENTRO 8:30\r\nDEPILACION LASER DE PANTORRILLA $750.00 AXILA $500.00 BRASILEÑA TOTAL $750.00\r\n2/MARZO/2021 1RA. PANTORRILLA 30 MS 14 J, AXILA 30 MS 13 J, BRASILEÑA TOTAL 30 MS 10 J MARY LAZARO ENTRO 12:15\r\n13/ABRIL/2021 2DA. PANTORRILLA 30 MS 13 J, AXILA 30 MS 13 J, BRASILEÑA 30 MS 10 J MARY LAZARO\r\n18/MAYO/2021 3RA. PANTORRILLA 30 MS 14 J, AXILA 30 MS 14 J, BRASILEÑA TOTAL 30 MS 10 J LUCY\r\n22/JUNIO/2021 4TA. PANTORRILLA 30 MS 15 J, AXILA 30 MS 14 J, BRASILEÑA TOTAL 30 MS 12 J LUCY\r\n9/DIC/2021 DEPILACION CON CERA DE AXILA, PANTORRILLA, BRASILEÑA TOTAL LUCY ENTRO 12:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('204', 'C-100204', '', 'LUZ RANERO LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('205', 'C-100205', '', 'CARLOS BALLINA JUAREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('206', 'C-100206', '', 'YARIMAR GONZALEZ CHACIEN', '9933182880', '', '30/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN SOLO FUE CON ASPIRACIÓN POR QUE TIENE EVENTO CARMEN ENTRO 4:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('207', 'C-100207', '', 'BERCY EDITH ALEJO HERNANDEZ', '9931389169', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('208', 'C-100208', '', 'GRACIELA AQUE AVILE', '9933403348', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('209', 'C-100209', '', 'JANETH GOMEZ RAMIREZ', '9932351473', '', '18/diciembre/18 limpieza facial charito entro 7:05 (mega)\r\n13/ene/19 prom. tratamiento revitalizante susi entro 12:00\r\n20/ENE/19 LIMPIEZA DE ACNE MARY  ENTRO 1:05 (MEGA)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('210', 'C-100210', '', 'MANUEL OCA', '9932107332', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('211', 'C-100211', '', 'FRANCISCA MENDEZ CASTILLO', '9931692011', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('212', 'C-100212', '', 'ANGELICA BELLO CASTA', '9933473315', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('213', 'C-100213', '', 'JORGE LEON ECHEVERRIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('214', 'C-100214', '', 'LINDA ALVAREZ GOMEZ', '9932420508', '', '05/JULIO/2021 MASAJE FULL RELAX 2X600 ROSI ENTRO 13:00 MEGA\r\n22/ABRIL/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE ROSY ENTRO 11:25 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-04-22 14:37:21', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('215', 'C-100215', '', 'ANTONIO CASTELAN GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('216', 'C-100216', '', 'LOREN MIRANDA ROMERO', '9933608075', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('217', 'C-100217', '', 'JUAN CARLOS SUAREZ', '9931260390', '', '11/agosto/19 limpieza facial susy entro 4.05 mega', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('218', 'C-100218', '', 'GABRIELA CORREA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('219', 'C-100219', '', 'JULIO CESAR CRUZ VALERIO', '9931669606', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('220', 'C-100220', '', 'JHOANA JIMENEZ PINEDA', '5529796758', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('221', 'C-100221', '', 'CANDELARIA SANCHEZ SILVAN', '9931897572', '', '28/oct/17 limpieza facial 2x600 mariana entro 10:05\r\n21/SEPT/19 TRAT CAPILAR MARY CARMEN ENTRO 10:10\r\n15/OCT/19 LIMPIEZA FACIAL, LIMPIEZA CAPILAR LUPITA ENTRO 8:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('222', 'C-100222', '', 'HECTOR PEDRERO BUENDIA', '', '', '19/DICIEMBRE/2022 LIMPIEZA FACIAL PROFUNDA OFELIA ENTRO 1:10\r\n19/DICIEMBRE/2022 LIMPIEZA FACIAL CONM AMP. DESINCRUSTANTE OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-19 11:56:13', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('223', 'C-100223', '', 'NELSIN DENNIS PADILA RAMOS', '9932644195', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('224', 'C-100224', '', 'JAVIER PEREZ RAMON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('225', 'C-100225', '', 'MANUEL HERNANDEZ DOMINGUEZ', '9932097224', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('226', 'C-100226', '', 'ZAYI AGUILAR RAMIREZ', '9933186613', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('227', 'C-100227', '', 'CATALINA ARRIAGA SALGADO', '9933473474', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('228', 'C-100228', '', 'MARIA CRISTINA JIMENEZ DE LA CRUZ', '019373725052/9371209899', '', '23/ene/16 criolipolisis en abdomen lizvet entro 1:25\r\n27/ene/16 criolipolisis en chaparrera lucy entro 2:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('229', 'C-100229', '', 'VICTORIA RUBI MORENO MALPICA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('230', 'C-100230', '', 'LIDIA CARAZO LOREDO', '9932076258', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('231', 'C-100231', '', 'MARIA FERNANDA ESCOBAR SANCHEZ', '9612693313', '', '21/marzo/16 mdm full relax 2x600 reyna entro 2:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('232', 'C-100232', '', 'KARLA PATRICIA LOPEZ CRUZ', '', '', '21/marzo/16 mdm full relax 2x600 charito entro 2:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('233', 'C-100233', '', 'ANA LOURDES SANCHEZ GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('234', 'C-100234', '', 'MARIA RODRIGUEZ ALVAREZ', '9871411770', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2022-10-17 09:43:34', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('235', 'C-100235', '', 'ANGELICA REYES R', '5530710329', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('236', 'C-100236', '', 'RAFAEL DE LA PARRA', '5530710329', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('237', 'C-100237', '', 'LORENA RUEDA PEREZ', '9933114559', '', '19/abril/16 limpieza facial andrea entro 10:45 (mega)\r\n25/enero/18 masaje de espalda monica entro 11:00 (mega)\r\n09/DICIEMBRE/2022 MASAJE HOLISTICO ROSY ENTRO 6:47 (MATRIZ) ', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-09 12:44:38', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('238', 'C-100238', '', 'GUADALUPE LEMUS MOCAYO', '9931366748', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('239', 'C-100239', '', 'HORTENCIA MONCAYO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('240', 'C-100240', '', 'ISELA RENDON PINEDA', '9932072286', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('241', 'C-100241', '', 'HANA CUNHA', '9932088036', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('242', 'C-100242', '', 'ROMAN DE LA ROSA LLERGO', '9933590382', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('243', 'C-100243', '', 'AMADOR RODRIGUEZ PE', '9933115424', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('244', 'C-100244', '', 'ALICIA GOMEZ OLMEDO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('245', 'C-100245', '', 'LUISA FERNANDA VIVEROS VIDAL', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('246', 'C-100246', '', 'ELSA MAGAÑA', '9933997035', 'elsama201@hotmail.com', '9/NOV/18 MDM REDUCTIVO BELÉN ENTRO 9:20\r\n9/NOV/18 TRATAMIENTO DE LUMICELL, FACIAL DIAMOND LIFE, MANOS, PIES Y LIFTING DE TIMEXPERT OFELIA\r\n15/ENERO/19 MDM DRENAJE LINFATICO MONICA ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('247', 'C-100247', '', 'ROXANNA ROSENQDIST', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('248', 'C-100248', '', 'YOSELIN GARCIA MELCHOR', '9932586820', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('249', 'C-100249', '', 'MARISELA DEL CAMPO MONTUY', '9931608518', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('250', 'C-100250', '', 'SAUL CORDOVA DE LA CRUZ', '9933139416', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('251', 'C-100251', '', 'ESTEFANY RODRIGUEZ RODRIGUEZ', '', '', '2/junio/16 masaje de espalda y limpieza facial rosy entro 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('252', 'C-100252', '', 'NILDA VENTURA MENDEZ', '9933180261', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('253', 'C-100253', '', 'GLORIA ZABALA HERNANDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('254', 'C-100254', '', 'CAROLINA LEON NOTARIO', '', '', '15/abril/11 limpieza capilar con amp. olio-mineralizante mariana entro 11:35 llevo masc.\r\ncapilar, crema capilar y shampoo hidronutritivo\r\n15/abril/11 promocion vinoterapia araceli \r\n22/julio/11 limpieza facial de acne 2 x 1 lucy entro 1:20\r\n22/nov/12 promocion de colageno con amp. desincrustante mariana entro 5:15\r\n17/11/13 limp. facial 2x1 martha mega 11.20\r\n25/sept/15 promocion equilibrante del ph mariana entro 9:50\r\n8/ene/16 promocion desintoxicante lizvet entro 11:40\r\n12/julio/17 limpieza facial 2x600 lucy entro 12.05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('255', 'C-100255', '', 'ALEJANDRA RODRIGUEZ HERRERA', '9931601202', '', '3/SEPT/2021 MASAJE FULL RELAX  JHOANY ENTRO 4:55\r\n12/MAYO/2023 MASAJE FULL RELAX ROSY ENTRO 5:00 (MEGA)\r\n******TOMO EL MASAJE FULL RELAX UN JOVEN A NOBRE DE LA SEÑORITA \r\n               ALEJANDRA RODRIGUEZ HERRERA******************\r\n13/MAYO/2023 MASAJE FULL RELAX MONICA ENTRO 9:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-12 22:01:29', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('256', 'C-100256', '', 'LIBERTAD BLANCO DE ARAUJO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('257', 'C-100257', '', 'GUILLERMO ARAUJO CUEVAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('258', 'C-100258', '', 'BEATRIZ ELENA OSORIO LASTRA', '9933997054', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('259', 'C-100259', '', 'MARIA DEL CARMEN ROJAS', '', '', '10-08-16 se realizo l-f cristal candy 1:00\r\n03/febrero/17 mdm full relax y limpieza facial 2x600 lizbeth entro 10:55 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('260', 'C-100260', '', 'MARIA GUADALUPE FRIAS MORALES', '9933257422', '', '8/Mayo/17 delineado de cejas, se le dio $100.00 pesos a ofelia', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('261', 'C-100261', '', 'YENY GAMEZ COLOMBON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('262', 'C-100262', '', 'BETY GONZALEZ DE CANTU', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('263', 'C-100263', '', 'GERARDO PRIEGO PRIEGO', '9935901901', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('264', 'C-100264', '', 'AMANDA NU', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('265', 'C-100265', '', 'GERARDO RAMOS AVALOS', '9933602320', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('266', 'C-100266', '', 'GABRIEL GONZALEZ MU', '9931605155', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('267', 'C-100267', '', 'ALEJANDRA CORTES MONTALVO', '9933954445', '', '23/marzo/16 mdm holistico y facial hydracure mariana entro 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('268', 'C-100268', '', 'ALMA ROCIO GARCIA GUEVARA', '9931175236', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('269', 'C-100269', '', 'ALMA OLIVIA GUEVARA VALDEZ.', '9931175236', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('270', 'C-100270', '', 'LAURA DE LA GARZA FAZ', '9932195514', '', '31/mayo/17 dep. bikini total rosy entro 10:05 (mega)\r\n27/sept/17 dep. bikini total candy entro 5:00 (mega) se le comento que le quedarian algunos vellos por que los trate muy chiquitos.\r\n08/noviembre/17 dep. bikini total rosy entro 5:00 (mega)\r\n08/diciembre/17 dep. bikini total rosy entro 11:05 (mega)\r\n09/ENERO/17 DEP. BIKINJI TOTAL SUSY ENTRO 11.20 (MEGA)\r\n27/01/18 DEP BIKINI COMPLETA C/CERA REYNA ENTRO       ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('271', 'C-100271', '', 'CAROL JANNETH SERAFIN RODRIGUEZ', '9361124126', '', '14/12/17 promocion tratamiento gold\r\n15/12/17 PROMOCION TRATAMIENTO GOLD ENTRO 10:00\r\n10/01/18  PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO ANITA ENTRO 9:50\r\n13/DIC/18 PROMOCION TRAT DIAMANTE REYNA ENTRO 9:20', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('272', 'C-100272', '', 'CLARA CUETO SANCHEZ', '9935908970', '', '23/dic/16 limpieza facial 2x 600 mariana entro 5:35\r\n3/ene/17 limpieza facial anita entro 6:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('273', 'C-100273', '', 'YESICA JERONIMO LANDERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('274', 'C-100274', '', 'ICELA ALEJANDRA OCAMPO LOPEZ', '9931669325', 'icelaocampo@hotmail.com', '2/septiembre/15 exf. corporal vitamina c graciela entro 2:50\r\n2/sept/15 facial vitamina c de natura bisse lucy entro 4:00\r\nllevo filtro solar de vitamina c de natura bisse, fluido reafirmante especial piel normal y grasa vitamina c de nb y mascarilla antioxidante y reafirmante vitamina c de natura bisse.\r\n3/oct/15 sauna mary lazaro entro 10:10\r\n18-10-15 SE REALIZO PROM DEL MES MIRE CRISTAL 2PM\r\n29/oct/15 capsula mariana entro 1:20\r\n12/nov/15 promocion antiedad ofelia entro 1:00\r\n21/nov/15 dermosonic graciela entro 1:00\r\n26/nov/15 micro graciela entro 2:00\r\n28/nov/ demosonic, laser lipolítico graciela entro 10:00\r\n29-11-15 se realizo esfoliacion 2x1 y l-f-2x1 sussy cristal 3-10\r\n15/dic/15 laser lipolitico reyna centro 12.45\r\n28/dic/15 capsula fernanda entro 9:20\r\n9/ene/16 laser lipolitico lizvet entro 1:15\r\n17/enero/16 exfoliacion corporal con descuento 2x1 susy entro 11:10 (cristal)\r\n23/ene/16 capsula charito entro 9:20\r\n24-01-16 SE REALIZO LIMP FACIAL 2X600 CRISTAL SUSSY 11AM\r\n19-03-16 se realizo limp facial cristal sussy 2-30pm\r\n05/junio/16 limpieza facial 2x600 andrea entro 6.50 (mega)\r\n14/junio/16 dermosonic mariana entro 4:05\r\n8/oct/16 sauna anita entro 9:30\r\n17/dic/16 capsula carmen entro 10:00\r\n26/dic/16 sauna mariana entro 11:50\r\n6/ene/17 sauna lucy entro 5:40\r\n04/marzo/17 limpieza facial 2x600 anita entro 6:50 (mega)\r\n23/marzo/17 promocion estimulante de colageno con luz leds andrea entro 2:00\r\n25/marzo/17 sauna, dermosonic andrea entro 11:00\r\n04/marzo/17 limpieza facial 2x600 anita entro 7:05 (mega)\r\n04/marzo/17 limpieza facial 2x600 anita entro 7:05 (mega)\r\n1/abril/17 capsula rosy entro 8:50 llevo crema chauffante\r\n08/abril/17 exfoliacion corporal 2x1000 anita entro 4:15 (mega)\r\n08/abril/17 exfoliación corporal 2x1000 anita entro 4:15 (mega)\r\n22/abril/17 sauna, dermosonic ofe entro 12:00\r\n15/julio/17 criolipolisis yeni entro 12:00\r\n15/julio/17 criolipolisis yeni entro 12:00\r\n22/julio/17 sauna susy entro 11.30\r\n29/julio/17 sauna yeni entro 12:20\r\n9/sept/17 sauna yeni entro 12:35\r\n30/sept/17 limpieza facial 2x600 anita entro 6:00 (mega)\r\n26/oct/17 criolipolisis mary lazaro entro 10:30\r\n3/nov/17 dermosonic anita entro 11:45\r\n13/nov/17 dermosonic anita entro 10:50 llevo crema chauffante\r\n25/nov/17 dermosonic y lumicell susy entro 11:40\r\n7/dic/17 promocion trat gold anita entro 12:05\r\n30/DIC/17 PROMOCION TRATAMIENTO GOLD Y SAUNA ANITA ENTRO 1:50\r\n7/ABRIL/18 SAUNA OFELIA ENTRO 12:35\r\n21/ABRIL/18 SAUNA, LUMICELL MARIANA ENTRO 11:50\r\n22/abril/18 limpieza facial 2x600 candy entro 5:00 (mega)\r\n14/ABRIL/18 SAUNA (MARY) Y DERMOSONIC  REYNA ENTRO 11:30\r\n16/JUNIO/18 SAUNA  SUSI ENTRO 10:40\r\n23/JUNIO/18 SAUNA MARY ENTRO 8:50\r\n17/JULIO/18 DERMOSONIC  MARY ENTRO 11:25\r\n14/JULIO/18  SAUNA   OFELIA ENTRO 10:30\r\n13/OCT/18 CRIOLIPOLISIS MARY ENTRO 1:10\r\n24/NOV/18 CRIOLIPÓLISIS EN ABDOMEN MARY LAZARO ENTRO 11:20\r\n24/NOV/18 DERMOSONIC EN PIERNAS MARY LAZARO\r\n26/NOV/18 LUMICELL MONICA ENTRO 4:40\r\n28/NOV/18 SAUNA  REYNA Y DERMOSONIC MARY \r\n22/DIC/18 SAUNA SRA BEGO\r\n29/DIC/18 DERMOSONIC Y SAUNA  MONICA ENTRO 8:40\r\n16/ENERO/19 CAPSULA MARY LAZARO ENTRO 2:00\r\n19/ENERO/19 CAPSULA MONICA ENTRO 1:45\r\n26/ENERO/19 CAPSULA MARY LAZARO ENTRO 9:25\r\n2/FEB/19 CAPSULA ENTRO MONICA ENTRO 8:40\r\n22/FEBRERO/19 DERMOSONIC LUPITA ENTRO 3:05\r\n23/FEB/19 LUMICELL MONICA ENTRO 8:30\r\n26/FEB/19 DERMONIC  LUCY ENTRO 3:25\r\n12/MARZO/19 DERMOSONIC, LASER LIPOLITICO ANITA ENTRO 10:50\r\n14/MARZO/19 LUMICELL ANITA 4:10\r\n15/MARZO/19 EXFOLIACIÓN DE CUERPO MONICA ENTRO 9:10\r\n23/MARZO/19  CAPSULA ENTRO  LUPITA  10:10\r\n28/MARZO/19 CAPSULA SRA  BEGO ENTRO 12:50\r\n04/JUNIO/19 exfoliacion corporal 2x1000 susy entro 6:50 mega\r\n9/JUNIO/19 LIMPIEZA FACIAL 2 X 600 SUSI MEGA\r\n9/JULIO/19 CAPSULA  ANITA ENTRO 11:25\r\n28/JULIO/19 LIMPIEZA FACIAL 2X600 MONY ENTRO 5:05 MEGA\r\n17/AGOSTO/19 SAUNA ALE ENTRO 12:40\r\n24/AGOSTO/19 SAUNA Y DERMOSONIC CARMEN ENTRO 9:55\r\n24/AGOSTO/19 LIPOSONIX 4 DISPAROS  OFELIA\r\n28/AGOSTO/19 LUMICEL  CARMEN ENTRO 3:00\r\n31/AGOSTO/19 DERMOSONIC REYNA ENTRO 11:00\r\n27/DICIEMBRE/19 SAUNA  REYNA ENTRO 4:45\r\n18/ENERO/20 SAUNA LUPITA ENTRO 11:55\r\nLLEVO GEL HYPOTERMICO\r\n8/FEBRERO/2021 SAUNA PROMOCION 10 DE MAYO MONICA ENTRO 2:30\r\n12/FEB/2021 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MIRENA ENTRO 1:35 PROM DEL 10 DE MAYO\r\n12/FEB/2021 CRIOTERAPIA YOANA ENTRO 2:35 PROM 10 DE MAYO\r\n10/ABRIL/2021 PROMOCION VITAMINA C JHOANY ENTRO 9:25 (PROMOCION 10 DE MAYO PAGO LA DIFERENCIA)\r\n24/ABRIL/2021 SAUNA (PROMOCION 10 DE MAYO) MARIANA ENTRO 10:55\r\n19/JUNIO/2021 SAUNA (PROMOCION 10 DE MAYO) ANITA\r\n19/JUNIO/2021 PROMOCION RETINOL (PAGO DIFERENCIA DEL DRENAJE LINFATICO QUE TENIA PAGADO DE LA PROMOCION DEL 10 DE MAYO) ANITA ENTRO 8:45\r\n10/JULIO/2021 SAUNA  OFELIA ENTRO 9:50\r\n13/NOVIEMBRE/2021 SAUNA EN TRO MARIANA ENTRO 8:55', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-01 12:17:36', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('275', 'C-100275', '', 'FATIMA ZURITA HERNANDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('276', 'C-100276', '', 'MARITZA BARRERA LOPEZ', '9933745993', '', '25/nov/17 limpieza facial 2x600 monica entro 1:45\r\n24/JULIO/19 MDM FULL RELAX 2 X 600 LUPITA ENTRO 12:20\r\n7/AGOSTO/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 JOHANY ENTRO 2:05\r\n12/AGOSTO/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 JOHANY ENTRO 2:10\r\n8/ENERO/2022 MASAJE FULL RELAX 2 X 600 LUCY ENTRO 12:00\r\n23/JULIO/2022 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 1:50', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-22 17:47:12', '1', '25', null, null);
INSERT INTO `clientes` VALUES ('277', 'C-100277', '', 'RUBEN GARCIA GALLEGOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('278', 'C-100278', '', 'JOVANI SANDRE CORREA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('279', 'C-100279', '', 'SARA ADRIANA GIL PEREZ', '9933968166', '', '2/ene/13 lim. facial 2x1 atendio brenda entro 7:20 mega\r\n14/02/13 lim. facial atendio brenda entro 7:20 mega\r\n17/03/13 lim. facial atendio graciela entro 3.00 mega \r\n17/05/13 lim. facia y mdm 2x1 atendio brenda entro 6:20 mega \r\n09/08/13 limp. facial brenda mega\r\n23/12/13 lim facial atendio mirena mega entro 5:20\r\n19/07/14 lim de acne rosi mega 11:05\r\n17/ene/15 limpieza facial nelly entro 11:02 (mega)\r\n15/marzo/15 limpieza facial martha entro 5:51 (mega)\r\n19/noviembre/15 prom. del mes tra. antiedad charito entro 3:55 (mega)\r\n19/AGOSTO/2022 LIMPIEZA FACIAL BASICA SUSY ENTRO 5:08 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-08-19 16:50:00', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('280', 'C-100280', '', 'FRANCISCO JUAREZ ALMEIDA', '9931167666', 'juaf670210@hotmail.com', '29/julio/13 limpieza de acne rosy entro 4:15\r\n14/agosto/13 limpieza de acne yusiria entro 4:00\r\n26/agosto/13 limpieza de acne yusiria entro 4:35\r\n11/sept/13 limpieza de acne yusiria entro 3:15\r\n19/sept/13 limpieza de acne reyna entro 4:00\r\n4/oct/13 limpieza de acne reyna entro 4:00\r\n28/oct/13  limpieza de acne yusiria entro 6.10\r\n7/nov/13 limpieza de acne yusiria entro 4:45\r\n09/oct/14 limpieza de acne mariana entro 5:12 \r\n14/nov/14 limpieza de acne brenda entro 10:40\r\n5/dic/14 limpieza de acne mirena entro 10:30\r\n27/enero/15 limpieza de acne con amp, desincrustante lucero entro 10:55\r\n19/feb/15 limpieza de acne con amp. desincrustante carmen entro 10:25\r\n01/oct/15  limpieza de acne con amp. desincrustante charito/candy entro 10:45\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('281', 'C-100281', '', 'SELENE ALVAREZ MAYO', '9932649348', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('282', 'C-100282', '', 'SANTIAGO DE LA CRUZ BALLESTER', '9933046913', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('283', 'C-100283', '', 'MARIA MAGDALENA HERNANDEZ VALENCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('284', 'C-100284', '', 'CLARISA RODRIGUEZ MAGA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('285', 'C-100285', '', 'ROSA JESUS DE LA CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('286', 'C-100286', '', 'AURORA RAMOS GONZALEZ', '9932024609', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('287', 'C-100287', '', 'MELISSA PORTILLO MENDOZA', '9931065587', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('288', 'C-100288', '', 'ELIZABHET ANGLES HERNANDEZ', '9931786597', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('289', 'C-100289', '', 'NURI JIMENEZ DE LOS SANTOS', '9933475044', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('290', 'C-100290', '', 'ZAMY AVALOS RODRIGUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('291', 'C-100291', '', 'MICHELL MARQUEZ DEL POZO', '9932078288', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('292', 'C-100292', '', 'MARIANA HERNANDEZ MORALES', '9141085941/9931605039', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('293', 'C-100293', '', 'ARLET ALEJANDRA RIVERA MARTINEZ', '9932150409', '', '4/JULIO/19 PROMOCION COLAGENO HIDROLIZADO OFELIA ENTRO 9:10\r\n3/DIC/19 MASAJE FULL RELAX CLIENTE FRECUENTE REYNA ENTRO 1:15\r\nINICIA TRATAMIENTO REDUCTIVO COMPLETO $12,000.00 ABONO $6000.00 RESTA $6000.00\r\nMEDIDA EN CINTURA (OMBLIGO) 83 CM PESO 58 KILOS\r\n1.-CAVITACION, MASAJE 12/JUNIO/2023 KARLA ENTRO 10:05\r\n2.-MASAJE, TERMO 13/JUNIO/2023 KARLA ENTRO 1:20\r\n3.-MASAJE, CAPSULA 14/JUNIO/2023 KARLA ENTRO 3:00\r\n4.-MASAJE, CORPO 15/JUNIO/2023 ANI ENTRO 10:50\r\n5.-LASER LIPOLITICO, MASAJE 16/JUNIO/2023 KARLA ENTRO 1:00\r\n6.-MASAJE 45 M, V F 45 M 19/JUNIO/2023 ANI ENTRO 1:45\r\n7.-MASAJE, G-5 15 M, VENDAS FRIAS 30 M 20/JUNIO/2023 ANI ENTRO 10:00\r\n8.-MASAJE, PRESO 40 M 21/JUNIO/2023 ANI ENTRO 10:00\r\n9.-CAVITACION, MASAJE 22/JUNIO/2023 ANI ENTRO 10:00\r\n10.-LASER LIPOLITICO, MASAJE, VENDAS FRIAS 30 M 23/JUNIO/2023 ANI ENTRO 1:00\r\n*****TERMINO TRATAMIENTO CON MEDIDA EN CINTURA 70 CM*****\r\n13/JULIO/2023 MASAJE FULL RELAX, LIMPIEZA FACIAL ANI ENTRO 9:00 ((((CORTESIA NOVIA))))', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-13 12:20:02', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('294', 'C-100294', '', 'VIRGINIA MARTINEZ FLORES', '9931485789', '', '17/JUNIO/19 INICIA TRATAMIENTO DE CELULITIS COSTO 8,000 ABONO 4,000 DEBE 4,000\r\n1.- DERMOSONIC  18/JUNIO/19 ANITA ENTRO 3:05\r\nLLEVO CREMA CHAUFFANTE\r\n2.-LUMICELL 19/JUNIO/19 MARY CARMEN ENTRO 10:10\r\n3.- ROLL ACTION, VF 20/JUNIO/19 CARMEN ENTRO 10:15\r\n4.-DERMO 21/JUNIO/19 CARMEN ENTRO 10:15\r\n5.- LUMICELL 22/JUNIO/19 CARMEN ENTRO 8:00\r\n6.- ROLL ACTION, VF 24/JUNIO/19 ANITA ENTRO 10:15\r\n7.- DERMO  25/JUNIO/19 CARMEN ENTRO 10:15\r\n8.- LUMICELL 26/JUNIO/19 MARY CARMEN ENTRO 10:15\r\n9.- ROLL ACTION, VF 27/JUNIO/19 CARMEN ENTRO 10:10\r\n10.- DERMO 28/JUNIO/19 MARY CARMEN ENTRO 10:25\r\n11.- LUMICELL 1/JULIO/19  MARY ENTRO 10:00\r\n12.- ROLL ACTION, VF  2/JULIO/19 ANITA ENTRO 10:15\r\n13.- DERMO 3/JULIO/19 MARY CARMEN ENTRO 10:00\r\n14.- LUMICELL 4/JULIO/19 MARY CARMEN ENTRO 9:10\r\n15.- ROLL ACTION, VF 5/JULIO/19 MARY CARMEN ENTRO 10:10\r\n16.- DERMO 8/JULIO/19 ANITA ENTRO 10:15\r\n17.- LUMICELL 9/JULIO/19 CARMEN ENTRO 10:15\r\n18.- ROLL ACTION 10/JULIO/19 MARY CARMEN ENTRO 10:15\r\n19.- DERMO 11/JULIO/19 MARY CARMEN ENTRO 9:55\r\n20 LUMICELL 12/JULIO/19 ANITA ENTRO 10:15\r\nTERMINO TRATAMIENTO.\r\n3/DIC/19 MASAJE FULL RELAX CLIENTE SANDY ENTRO 1:15\r\nINICIA TRATAMIENTO REDUCTIVO COMPLETO $12,000.00 ABONO $6,000.00 RESTA $6,000.00\r\nMEDIDA CINTURA (OMBLIGO) 90 CM PESO 65 1/2 KILOS\r\n1.-CAVITACIO, MASAJE 12/JUNIO/2023 JHOANY\r\n2.-MASAJE, CAPSULA 13/JUNIO/2023 JHOANY ENTRO 2:00\r\n3.-MASAJE, TERMO 14/JUNIO/2023 JHOANY\r\n4.-LASER LIPOLITICO, MASAJE 15/JUNIO/2023 JHOANY ENTRO 10:00\r\n5.-MASAJE, CORPO 16/JUNIO/2023 JHOANY ENTRO 10:10\r\n6.-MASAJE, VENDAS FRIAS 45 M 19/JUNIO/2023 JHOANY ENTRO 2:00\r\n7.-MASAJE, PRESO 40 M 20/JUNIO/2023 JHOANY ENTRO 10:00\r\n8.-MASAJE 45, G-5 15 M, VENDAS CALIENTES 30 M 21/JUNIO/2023 JHOANY ENTRO 10:10\r\n9.-CAVITACION, MASAJE  22/JUNIO/2023 JHOANY ENTRO 10:00\r\n10.-LASER LIPOLITICO, MASAJE, V F 30 M 23/JUNIO/2023 JHOANY ENTRO 1:00\r\n*****TERMINO TRATAMIENTO CON MEDIDA EN CINTURA 80 CM*****', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-19 15:23:30', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('295', 'C-100295', '', 'MAXIMILIANO LOPEZ CALDERON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('296', 'C-100296', '', 'ESTEFANIA PAIRO DESALES', '9931020605', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('297', 'C-100297', '', 'MONICA BALDIOLA', '9931088639', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('298', 'C-100298', '', 'ERIKA JARQUIN BALDIOLA', '9931088639', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('299', 'C-100299', '', 'JORGE JESUS REYES VIDAL', '', '', '12/julio/16 limpieza de acne mary lazaro entro 8:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('300', 'C-100300', '', 'JULIETA CAMACHO LOPEZ', '9935908353', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('301', 'C-100301', '', 'LETICIA PALOMEQUE CRUZ', '9932238091', '', 'incia masaje reductivo $3000.00 abono $1500.00 resta $1500.00\r\ncon media en-ombligo 94 cm y peso 76 kg.\r\n1.-MASAJE 45M 10/mayo/16 carmen entro 12:15\r\n2.-MASAJE 45M 11/mayo/16 carmen entro 6:00\r\n3.-MASAJE 45M13/mayo/16 carmen entro 6:00\r\n4.-MASAJE 45M 14/mayo/16 carmen entro 11:00\r\n5.-MASAJE 45M 16/mayo/16 carmen entro 5:50\r\n6.-MASAJE 45M 17/mayo/16 carmen entro 6:05\r\n7.-MASAJE 45M 18/mayo/16 carmen entro 6:00\r\n8.-MASAJE 45M 19/mayo/16 carmen entro 4:30\r\n9.-MASAJE 45M 20/mayo/16 carmen entro 6:00\r\n10.-MASAJE 45M 21/mayo/16 lizvet entro 11:10\r\ntermino el tratameinto.\r\n23/mayo/16 masaje reductivo  de  cliente frecuente (n d tar)lizvet entro 6:15\r\nincia cinco sesiones de  masaje  reductivo $1500.00 ABONO $500.00 RESTA  $1000.00\r\n1.-masaje 45m 24/mayo/16 lizvet entro 6:05\r\n2.-MASAJE 45M 25/mayo/16 lizvet entro 6:10 abono $500.00 resta $500.00\r\n3.-MASAJE 45M 26/mayo/16 lizvet entro 5:30\r\n4.-MASAJE 45M 31/mayo/16 lizvet entro 4:55\r\n5.-MASAJE 45M\r\n24/mayo/17 mdm full relax 2x600 carmen entro 6:25\r\n8/nov/17 mdm full relax 2x600 anita entro 1:25\r\n20/JUNIO/19 INICIA TRATAMIENTO REDUCTIVO DE MASAJES COSTO 3,000 ABONO 1,000 DEBE  2,000  PESO 78 1/2 MEDIDA CINTURA OMBLIGO 94\r\n1.- MASAJE 45  20/JUNIO/19 ALE ENTRO 3:05\r\n2.- MASAJE 45 21/JUNIO/19 MARIA DEL C ALEGRIA ENTRO 3:05\r\n3.- MASAJE 45 24/JUNIO/19 ALE ENTRO 3:20\r\n4.- MASAJE 45 25/JUNIO/19 ALE ENTRO 3:10\r\n5.- MASAJE 45 26/JUNIO/19 ALE ENTRO 3:20\r\n29/JUNIO/19 ABONO  1000.00 DE SU CORPORAL DEBE 1,000\r\n6.- MASAJE 45 29/JUNIO/19 ALE ENTRO 8:00\r\n7.- MASAJE 45 2/JULIO/19 ALE ENTRO 3:30\r\n8.- MASAJE 45 3/JULIO/19 MARIA DEL C ALEGRIA ENTRO 3:00\r\n9.- MASAJE 45 4/JULIO/19 ALE ENTRO 3:10\r\n4/JULIO/19 TERMINO DE PAGAR SU REDUCTIVO 1,000\r\n10.- MASAJE 45 17/JULIO/19 LISBETH ENTRO 3:00\r\nTERMINO TRATAMIENTO\r\n22/JULIO/19 MASAJE REDUCTIVO CLIENTE  FRECUENTE YASMIN\r\n22/OCTUBRE/19 INCIA TRATAMIENTO REDUCTIVO COSTO AUTORIZADO POR LA SRA BEGO 1500.00 5 SESIONES\r\n1.- MASAJE 45 22/OCTUBRE/19 SANDY ENTRO 3:10\r\n2.- MASAJE 45 23/OCT/19 SANDY ENTRO 3:00\r\n3.- MASAJE 45 24/OCTUBRE/19 SANDY ENTRO 2:40\r\n4.- MASAJE 45 25/OCT/19 SANDY\r\n5.- MASAJE 45 26/OCT/19 SANDY ENTRO 8:00\r\nTERMINO TRATAMIENTO.\r\n3/DICIEMBRE/19 INICIA TRATAMIENTO REDUCTIVO COSTO 3,000.00 ABONO 1500.00\r\nNO QUISO QUE LA MIDIERAN\r\n1.- MASAJE 45 3/DICIEMBRE/19 SANDY ENTRO 3:15\r\n2.- MASAJE 45 4/DCIEMBRE/19 SANDY ENTRO 3:50\r\n3.- MASAJE 45 5/DICIEMBRE/19 SANDY ENTRO 4:05\r\n4.- MASAJE 45 6/DICIEMBRE/19 SANDY ENTRO 4:05\r\n9/DICIEMBRE/19 TERMINO DE PAGAR SU TRATAMIENTO 1500.00\r\n5.- MASAJE 45 9/DICIEMBRE/19 SANDY\r\n6.- MASAJE 45 10/DICIEMBRE/19 MILI ENTRO 3:40\r\n7.- MASAJE 45 11/DICIEMBRE/19 MILI ENTRO 1:20\r\n8.- MASAJE 45 13/DICIEMBRE/19 SANDY ENTRO 3:45\r\n9.- MASAJE 45\r\n10.- MASAJE 45', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('302', 'C-100302', '', 'GLORIA SIGA ARRONA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('303', 'C-100303', '', 'GUSTAVO TORRES CHAO', '9933115817', '', '10/ABRIL/2021 PROMOCION TRAT. VIT C JHOANY ENTRO 7:55\r\n5/OCT/2022 TRATAMIENTO FACIAL PURIFICANTE CASMARA ARIANA ENTRO 2:30', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-13 17:53:20', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('304', 'C-100304', '', 'CRISTEL ARGAIZ MATA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('305', 'C-100305', '', 'GABRIELA PATRICIA LOPEZ MONROY', '9932242240', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('306', 'C-100306', '', 'RAUL PALOMERA GONZALEZ', '9931696041', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('307', 'C-100307', '', 'EMAGLI HERNANDEZ MEDINA', '9932391536', '', '02/sept/06 promocion anticouperose reyna entro 12:00\r\n30/sept/06 limpieza facial yesy 12:30\r\n2/dic/06 promocion tratamiento corrector lineas de expresion reyna entro 10:40\r\n31/marzo/07 promocion antiarrugas ofelia entro 11:25\r\n5/mayo/07 limpieza facial marcela entro 1:20\r\n26/junio/07 limpieza facial reyna\r\n26/junio/07 limpieza facial reyna entro 2:00\r\n01/sept/07 limpieza facial odet entro 9:10\r\n5/abril/08 limpieza facial marcela entro 9:00 \r\n26/julio/08 limpieza facial gladys entro 11:20 \r\n9/agosto/08 limpieza facial mary lazaro entro 11:55\r\n25/oct/08 promocion de trat de colageno arceli entro 12:00\r\n22/nov/08 promocion lifting de parpados reyna entro 12:10 \r\n14/marzo/09 limpieza facial gladys entro 12:40 \r\n21/marzo/09 limpieza facial gladys entro 12:45 \r\n9/mayo/09 limpieza facial mary l \r\n26/mayo/09 limpieza de acne con amp. desincrustante sara entro 12:30 \r\n18/julio/09 limpieza facial con amp. hidratante de sothys araceli entro 10:05\r\n** no volver a aplicar la amp. hidratante de sothys porque le dio alergia**\r\n28/agosto/09 promocion revitalizante reyna entro 5:20\r\n2/oct/09 limpieza facial mary lazaro entro 6:15\r\n31/oct/09 limpieza facial rosy entro 10:25\r\n23/ene/10 promocion vinoterapia gladys entro 10:40\r\n27/marzo/10 limpieza facial con amp. desincrustante karina\r\n12/junio/10 limpieza facial mariana entro 11:45\r\n7/feb/11 promocion trat. de seda reyna entro 4:09 \r\n4/junio/11 limpieza facial mariana entro 1:10\r\n15/julio/11 mdm drenaje linfatico lucy entro 6:15\r\n14/09/14 llinpiesa facial nelly 12.15 mega\r\n21/mayo/16 promocion de colageno lizvet entro 9:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('308', 'C-100308', '', 'KAQUIS HERNANDEZ MEDINA', '9932391536', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('309', 'C-100309', '', 'DEYANIRA RAMOS LOPEZ', '9931134478', '', '07/enero/17 limpieza de acne con amp. desincrustante lizbeth entro 6:50 (mega)\r\n18/junio/17 limpieza de acne monica entro 5:00 (mega)\r\n12/mayo/19 promocion del mes efecto botox susy entro 5:00 mega\r\n08/ DICIEMBRE/2022 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTESUSY ENTRO 6:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-08 15:41:54', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('310', 'C-100310', '', 'MARCELA GONZALEZ GARCIA', '9935904550', '', '07/04/04 hydrasoin, depilacion de cejas lucy\r\n08/09/04 depilacion de cejas, bigote, barbilla, patilla lucy\r\n08/09/04 timexpert rosy\r\n03/01/05 promocion relajante e hidratante mary lazaro\r\n03/01/05 depilacion de cejas y bigote mary lazaro\r\n11/oct/05 hydrasoin reyna\r\n09/junio/07 hydrasoin mary entro 12:35\r\n20/agosto/07 promocion regenerador antioxidante, \r\ndep. de cejas reyna entro 1:45 salio 2:55\r\n29/sept/07 facial so-delicate bego entro 12:25\r\n03/dic/07 promocion vitamina c marcela entro 2:50\r\n3/marzo/08 hydrasoin lucy entro 5:30\r\n10/oct/05 llevo la crema hydrasoin fresh\r\n03/dic/07 llevo crema facial azulen de lendan\r\n5/abril/08 llevo crema facial respuesta protectora dermazuleno,\r\n crema contorno de ojos infinitime, go-expresions \r\n5/abril/08 so-delicate lupita entro 12:50\r\n2/mayo/08 timexpert ofelia entro 9:55 salio 11:20\r\n24/mayo/08 timexpert odet entro 11:35 \r\n6/junio/08 trat. orange mary entro 4:40 \r\n1/julio/08 hydrasoin odet entro 5:15 \r\n28/julio/08 revitase julia entro 3:35 \r\n13/agosto/08 trat. orange lucy entro 5:40 \r\n3/sept/08 caviar rosy entro 6:10 \r\n11/oct/08 so-delicate bego entro 11:10 salio 12:00 \r\n8/nov/08 trat. hidratante de sothys bego\r\n11/dic/08 hydrasoin lucy entro 6:15\r\n12/ene/09 limpieza facial con amp. desincrustante\r\n araceli entro 5:25 \r\n21/feb/09 facial con amp. complex marine y retinol liposome\r\n bego entro 11:45 llevo pack crema de perla  \r\n21/marzo/09 seda y perla bety entro 12:20  \r\nllevo pack emulsion de perla\r\n18/abril/09 promocion spa therapy oro araceli entro 11:50\r\n28/mayo/09 timexpert lift mary lazaro entro 5:50 \r\n13/junio/09 so-delicate rosy entro 10:15 \r\n30/junio/09 jalea real mary entro 5:25 \r\n8/julio/09 limpieza facial y depilacion de cejas rosy \r\n30/julio/09 limpieza facial con amp. desincrustante\r\n araceli entro 6:10\r\n\r\nradiofrecuencia $1500.00 c/s\r\n1.-6/junio/09 ofelia\r\n2.-13/junio/09 bego\r\n3.-20/junio/09 ofelia\r\n4.-29/junio/09 lucy\r\n5.-6/julio/09 lupita entro 6:00\r\n6.-14/julio/09 lupita entro 5:15\r\n7.-17/julio/2012  facial mariana entro 10:10\r\n8.-\r\n\r\n29/agosto/09 so-delicate sara entro 11:50\r\n9/sept/09 seda y perla rosy entro 10:55\r\n17/sept/09 promocion termico\r\n de azuleno mary lazaro entro 2:35\r\n7/oct/09 jalea real sara entro 9:30\r\n5/nov/09 infinitime rosy entro 1:30\r\n14/nov/09 revitase sara entro 12:10\r\n10/dic/09 timexpert lift rosy entro 11:15\r\n29/dic/09 excel therapy 02 reyna entro 4:10\r\n11/ene/10 vitamina c reyna entro 3:30\r\n9/feb/10 infinitime lucy entro 4:15\r\n26/feb/10 caviar sara entro 8:30 salio 10:10\r\n13/marzo/10 so-delicate sara entro 9:20	\r\n22/abril/10 so-delicate lupita entro 9:20\r\n22/mayo/10 caviar ofe entro 10:15\r\n4/junio/10 infinitime araceli entro 3:10\r\n12/julio/10 promocion relajante e hidratante \r\ncon wellbox araceli entro 4:15\r\n26/julio/10 facial araceli entro 6:10 \r\n9/agosto/10 trat. facial araceli entro 5:20\r\n10/sept/10 hydrasoin araceli entro 5:00\r\n17/sept/10 timexpert lift araceli entro 5:15\r\n5/oct/10 cosmeceuticals araceli entro 6:10 \r\n12/oct/10 caviar araceli entro 12:00 \r\n20/oct/10 trat. facial combinado araceli entro 4:40 \r\n30/nov/10 celulas madres de manzana araceli entro 3:55 \r\n23/dic/10 orange ofelia \r\n6/ene/11 seda y perla mariana entro 11:58 \r\n26/ene/11 vitamina c  lucy\r\n7/feb/11 strategist karina entro 5:14 \r\n7/marzo/11  orange aracely entro alas 3:25 llevo crema facial infinitime piel mixta\r\ny se realizo depi. de cejas.\r\n31/marzo/11 hydrasoin mary lazaro entro 3:00\r\n26/abril/11 infinitime araceli entro 5:25\r\n2/mayo/11 llevo crema infinitime piel mixta\r\n11/mayo/11 trat. cosmeceuticals araceli entro 5:00\r\n4/junio/11 jalea real reyna entro 12:00\r\n21/junio/11 trat. facial cosmeceuticals araceli entro 5:30\r\ninicia radiofrecuencia $1500.00 c/s\r\n1.-11/julio/11 lucy entro 12:25\r\n20/julio/11 so-delicate araceli entro 6:05\r\n23/julio/11 mdm aroma rosas araceli entro 11:15\r\n8/agosto/11 l facial infinitime aracely entro 5:05 \r\nllevo crema infinitime piel mixta \r\n26/agosto/11 tratamiento facial lifting de dizao y mdm aracely entro 5:10\r\n08/sept/11 infinitime, masaje de descanso aracely entro 5:00\r\n19/sep/11 hidraquir aracely entro 6:00\r\n01/nov/11 sotish mdm aracely entro 9:00 \r\n19/nov/11 so-delicate, depilacion de cejas araceli entro 12:15\r\n1/dic/11 trat. velo de colageno sara entro 5:25\r\n14/dic/11 trat. excel therapy araceli entro 1:07\r\n7/ene/12 trat. seda y perla aracely entro 9:20\r\n4/feb/12 infinitime aracely entro 12:05\r\n11/feb/12 mdm geotermal, limpieza de espalda, strategist aracely entro 12:05\r\n25/feb/12 timexpert lift aracely entro 1:00\r\n6/marzo/12 infinitime karina entro 4:20\r\n24/marzo/12 trat. bioxidea aracely entro 10:45\r\n17/abril/12 mdm aracely entro 8:35\r\n21/abril/12 mdm, facial aracely entro 10:00\r\n4/mayo/12 excel therapy 02 aracely entro 5:50\r\n1/junio/12 excel therapy o2, depilacion de cejas lucy entro 11:00\r\n18/junio/12 hydracure aracely entro 5:30\r\n30/junio/12 facial combinado araceli entro 1:10\r\n7/julio/12 hidracure araceli entro 10:55\r\n25/julio/12 mdm geotermal, trat facial con atache araceli entro 4:20\r\n4/agosto/12 mdm, timexpert lift araceli entro 9:55\r\n18/agosto/12 hidronutritivo araceli entro 10:00\r\n29/agosto/12 infinitime ofelia entro 10:00\r\n29/agosto/12 depilacion de cejas ofelia\r\n8/sept/12 mdm aroma, facial vit c natura bisse, depilacion de cejas araceli entro 10:20\r\n8/sept/12 trat de pies y manos con parafina araceli\r\n19/sept/12 excel therapy 02 araceli entro 5:25 llevo almohada herbal de cuello\r\n10/oct/12 excel therapy 02 araceli entro 6:00\r\n20/oct/12 mdm completo, glycocure araceli entro 12:20\r\n10/nov/12 facial royal jelly, depilacion de cejas araceli entro 10:30 llevo 2 amp. pilosome\r\n29de noviembre12 vitamina c de atache atendio araceli entro a las 9 salio 1030 matriz\r\n13/dic/12 trat de oro con amp. royal jelly araceli entro 5:15\r\n28/dic/12 timexpert lift, depilacion de cejas araceli entro 5:05\r\n10/ene/13 excel therapy 02, trat. pies y manos rosy entro 4:45\r\n2/feb/13 mdm, facial so-delicate ofe entro 11:10 tratamiento de manos y pies con parafina \r\n15/feb/13 timexpert lift lucy entro 3:25\r\n1/marzo/13 facial retinol de atache depilacion de cejas lucy entro 12:00\r\n1/marzo/13 mdm rosy entro 6:00\r\n11/abril/13 facial so-delicate lucy entro 5:15\r\n3/mayo/13 timexpert lift ofelia entro 11:10\r\n20/junio/13 mdm full relax, facial hydracure lucy entro 4:40\r\n3/julio/13 facial nb y depilacion de cejas bego entro 5:30\r\n3/julio/13 trat de manos y pies susy\r\n4/julio/13 llevo crema ceutical de nb\r\n17/julio/2013 facial de hydracure vitamina c depilacion de cejas ofelia entro 12:40\r\n2/agosto/13 facial vitamina c nb, depilacion de cejas lucy entro 4:30\r\n14/sept/13 facial glycocure rosy entro 1:25\r\n29/nov/13 facial timexpert lift lucy entro 1:45\r\n20/dic/13 facial excel therapy 02 lucy entro 5:05\r\n4/ene/14 facial con amp. de lendan y masc. plastica de excel therapy mariana entro 11:35\r\n16/ene/14 facial lift therapy de atache susy entro 4:50 llevo serum recuperador intensivo contorno d\r\nojos timexpert srns\r\n4/feb/14 exfoliacion de cuerpo vitamina c, mdm full relax, facial timexpert rides reyna entro 3:15\r\n4/feb/14 llevo crema reafirmante de cuello y escote de timexpert lift\r\n18/feb/14 facial retinol de jabotiere, depilacion de cejas rosy entro 5:00\r\n28/feb/14 facial percollagen lucy entro 8:10\r\n17/marzo/14 facial desafio antiedad natura bisse yusiria entro 9:40\r\n nuevos tratamientos\r\n1.- aqua natura bisse 27/marzo/14 rosy entro 5:35\r\n3/mayo/14 mdm full relax nelli entro 8:00\r\n2.-retinol jabotiere 3/mayo/14 lucy entro 9:00\r\n3.-percollagen jabotiere\r\n4.- revitalizante jabotiere\r\n5.- vitamina c jabotiere\r\n6.- lifting natura bisse\r\n7.- inhibit 3-d natura bisse\r\n8.- ceutical natura bisse\r\n9.- oxigeno natura bisse\r\n10.- skinligth\r\n11.- catiodermia\r\n12.-dermorelax\r\n13.-hidraveil\r\n14/abril/14 full-relax, timexpert susy entro 4:00\r\n24/mayo/14 mdm full relax, facial aqua de natura bisse, lifting yusiria entro 8:10\r\n20/junio/14 mdm full relax, facial retinol mirena entro 4:45 no le gusta las amp. de ácido glicólico\r\n5/julio/14 lift therapy ofe entro 12:20 llevo crema cuello y escote timexpert lift\r\n09/agosto/14 mdm full relax atendió carmen facial excel therapy atendio reyna \r\n17/oct/14 vitamina c atache yusiria entro 4:20 \r\n29/nov/14 promocion trat antiedad humectante-nutritivo se aplico amp. hidratante, \r\ndepilacion de cejas ana entro 12:20\r\n30/dic/14 facial hydracure, depilacion de cejas yusiria entro 10:15\r\n14/enero/15 facial aqua reyna entro 5:30\r\n31/enero/15 facial de vitamina c natura bisse y dep de cejas ana entro 10:25\r\npara la siguiente sesion quiere facial de exelterapy, lifting de natura bisse, modeladora cuello\r\n14/feb/15 trat facial so-delicate con amp. extra, depilacion de cejas mirena entro 10:20 \r\n16/mayo/15 trat facial royal jelly, lifting de colageno, depilacion de cejas ofelia entro 11:20\r\n12/junio/15 facial de catiodermia lucy entro 4:10\r\n02/julio/15 facial timexpert lift reyna entro 4:30\r\n18/nov/15 facial hydracure, depilacion de cejas lucy entro 5:20\r\n3/dic/15 facial exel therapy 02 mariana entro 4:30\r\n21/dic/15 facial reafirmante con radio $1400.00 reyna entro 5:10\r\n8/ene/16 facial retinol lucy entro 4:45\r\n4/feb/16 facial timexpert vit c, depilacion de cejas lucy entro 2:25\r\n11/marzo/16 facial hydradermie lucy entro 4:30\r\n13/abril/16 facial timexpert lift in de germaine reyna entro 4:35\r\n3/mayo/16 facial hydracure nely enro 5:20\r\n7/junio/16 facial glycocure mariana entro 5:00\r\n1/sept/16 facial hydracure lucy entro 5:10\r\n23/sept/16 facial excel therapy o2 y dep de cejas lucy entro 5:00\r\n30/nov/16 facial excel therapy o2 lucy entro 5:00\r\n19/dic/16 facial so delicate reyna entro 5:10\r\n10/marzo/17 facial excel therapy 02 y dep de cejas susy entro 4:20\r\n24/mayo/17 facial hydracure andrea entro 5:35\r\n8/junio/17 timexpert rides andrea entro 5:40\r\n29/julio/17 facial timexpert lift in susy entro 12.20\r\n18/agosto/17 facial hydracure y dep de cejas lucy entro 5:00\r\n8/dic/17 facial excel therapy antipolución lucy \r\n25/01/18 TRATAMIENTO FACIAL TIMEXPERT WHITE MARIANA ENTRO 12:20\r\n09/FEB/18 FACIAL VITAMINA C GERMAINE REYNA ENTRO 1:05\r\n5/MARZO/18 FACIAL VITAMINA C GERMAINE MARY ENTRO 12:15\r\n6/ABRIL/18 FACIAL TIMEXPERT RIDES  REYNA ENTRO 5:30\r\n19/MAYO/18 FACIAL SRNS CHARITO ENTRO 12:10\r\n27/JULIO/18  FACIAL  ROYAL JELLY  MARY\r\n20/SEP/18 FACIAL TAIMEX  EXPERT IN ANITA\r\n5/OCT/18 FACIAL EXCEL THERAPY O2 EVOLUTION LUCY\r\n3/NOV/18 FACIAL HYDRACURE  OFELIA\r\n3/NOV/18 EMULSIÓN EXCEL THERAPY Y CREMA CUELLO Y ESCOTE\r\n7/DIC/18 FACIAL TIMEXPERT RIDES REYNA ENTRO ENTRO 4:05 \r\n29/DIC/18 FACIAL DE VITAMINA C  DE GERMAINE  MONICA ENTRO 12:00\r\n1/FEB/19 FACIAL HYDRACURE LUPITA ENTRO 5:15\r\n21/FEBRERO/19 FACIAL VITAMINA C DE GERMAINE REYNA\r\n21/MARZO/19 HYDRACURE MARY ENTRO 4:45\r\n9/ABRIL/19 FACIAL DE TIMEXPERT RIDES ANITA ENTRO 4:20\r\n17/MAYO/19 FACIAL DE VITAMINA C DE GERMAINE ANITA ENTRO 12:00\r\n5/JUNIO/19 HYDRACURE ANITA ENTRO 1:15\r\n11/JULIO/19 FACIAL SRNS ANITA ENTRO 4:50\r\n12/AGOSTO/19 FACIAL DE GERMAINE ANTIEDAD MARY LAZARO ENTRO 5:00\r\n25/SEPT/19 FACIAL DETOX DE GERMAINE REYNA ENTRO 10:05\r\n30/OCTUBRE/19 FACIAL ANTIPOLUTION MARY LAZARO ENTRO 4:45\r\n28/NOVIEMBRE/19 FACIAL HYDRACURE LUPITA ENTRO 5:00\r\n28/DIC/19 FACIAL TIMEXPERT IN ANITA ENTRO 11:00\r\n8/ENERO/20 TRATAMIENTO FACIAL DE ORO  REVITALIZANTE Y REAFIRMANTE MARY  LAZARO ENTRO 5:05\r\n21/FEBRERO/20 FACIAL FACIAL VITAMINA C DE GERMAINE ANITA ENTRO 4:55\r\n25/MAYO/20 LIMPIEZA FACIAL PROFUNDA 550.00 SE LE APLICO APARTE AMP DE ACIDO HIALURONICO Y AMP S.O.S. DE GERMAINE OFELIA ENTRO 10:10\r\n1/JUNIO/20 LIMPIEZA FACIAL  CON AMP. ACIDO HIALURONICO Y MASC. TISSU ANTIEDAD DE GERMAINE 1,200.00 OFELIA ENTRO 9:10\r\n1/JUNIO/2020 DEPILACION DE CEJAS OFELIA\r\n18/JUNIO/20 TRATAMIENTO FACIAL ROYAL JELLY MARY LAZARO  ENTRO 3:55\r\n9/JULIO/2020 FACIAL NEO AGE TIMEXPERT RIDES Y DEPILACION DE CEJAS ANITA ENTRO 1:00\r\n28/AGOSTO/2020 FACIAL HYDRACURE LUCY ENTRO 1:00\r\n22/SEPT/2020 FACIAL VITAMINA C DE NATURA BISSE OFELIA ENTRO 1:55\r\n12/NOV/2020 FACIAL EXCEL THERAPY 02 OFELIA ENTRO 5:05\r\n12/DIC/2020 FACIAL XCEL THERAPY Y LIFTING DE COLAGENO OFELIA ENTRO 12:55\r\n17/FEB/2021 FACIAL HYDRACURE MONICA ENTRO 3:05\r\n22/MARZO/2021 FACIAL TIMEXPERT IN MARY LAZARO ENTRO 3:55\r\n7/MAYO/2021 TRATAMIENTO FACIAL ROYAL JELLY ANITA ENTRO 3:00 \r\n19/MAYO/2021 FACIAL  DE GERMAINE CON AMP. SENSIBLE Y MASCARILLA DE ARGAI MARY LAZARO ENTRO 3:05\r\n30/JUNIO/2021 PROM. TRATAMIENTO FACIAL RETINOL ANITA ENTRO 3:50\r\n16/JULIO/2021 FACIAL PEELOFF MARIANA ENTRO 4:00 \r\n5/AGOSTO/2021 TRATAMIENTO FACIAL PEEL OFF (SE LE APLICO AMP. STABILIZING DE NATURA BISSE) SE LE COBRO &1,000.00 PESOS  LUCY ENTRO 4:50  \r\n20/AGOSTO/2021 LIMPIEZA FACIAL PROFUNDA CON AMPOLLETA OXIGENANTE DE NATURA BISSE MARIANA ENTRO 9:55     \r\n8/SEPT/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY LAZARO ENTRO 2:05            \r\n5/OCTUBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CON AMP. OXIGENANTE MARY LAZARO ENTRO 1:00\r\n19/OCTUBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE Y AMP. OXIGENANTE MARIANA \r\n 3/NOVIEMBRE/2021 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE Y AMP. OXIGENANTE MARY LAZARO ENTRO 5:00\r\n1/DICIEMBRE/2021 LIMPIEZA FACIAL CON AMP. OXIGENANTE LUCY EN TRO 5:00\r\n22/DIC/2021 LIMPIEZA DE ACNE CON AMP. OXIGENANTE MARY LAZARO ENTRO 1:00\r\n17/ENERO/2022 LIMPIEZA FACIAL  CON AMP. DESINCRUSTANTE Y AMP. OXIGENANTE DE NATURA BISSE MARIANA ENTRO 3:05LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE,  AMP. OXIGENATE DE NSTURS BISSE Y DEPILACION DE CEJAS MARIANA \r\n7/MARZO/2022 LIMPIEZA FACIAL CON AMP. DESICNRUSTANTE MAS AMP  OXIGENANTE MARY LAZARO EWNTRO 5:00\r\n25/MARZO/2022 PROM. TRATAMIENTO FACIAL SHOCK DE COLAGENO CON AMP. DESINCRUSTANTE Y AMP. DE COLAGENO LUCY ENTRO 4:20\r\n7/ABRIL/2022 FACIAL HYDRACURE MARY LAZARO ENTRO 2:05\r\n20/ABRIL/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE  MARIANA ENTRO 4:55\r\n6/MAYO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CON AMP. ESTABALANZING LUCY\r\n16/JUNIO/2022 TRATAMIENTO PROMOCION FACIAL YOGA FACIAL CON AMPOLLETA DESINCRUSTANTE OFELIA ENTRO 12:10 \r\n13/JULIO/2022 LIMPIEZA FACIAL CON AMP. STABALAZING LUCY ENTRO 5:00\r\n1/AGOSTO/2022 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARIANA\r\n************LLEVO CREMA ROYAL JELLY COMFORT*************\r\n25/AGOSTO/2022 TRATAMIENTO FACIAL VITAMINA C RADIANCE OFELIA ENTRO 12:00\r\n8/SEPT/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE LUCY ENTRO 1:10\r\n26/SEPTIEMBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CON AMP. DE OXIGENO DE NATURA BISSE MARY LAZARO ENTRO 2:00\r\n1/NOVIEMBRE/2022 HIDRODERMABRASION MARIANA ENTRO 3:05\r\n6/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN  MARY LAZARO ENTRO 5:05\r\n13/ENERO/2023 LIMPIEZA FACIAL PROFUNDA CON AMP. ACIDO HIALURONICO DE CASMARA MARIANA ENTRO 1:10\r\n10/febrero/2023 FACIAL DE 800.00 LIMPIEZA FACIAL CON AMP. AINHOA Y MASCARILLA DE AINHOA OFELIA ENTRO 3:55\r\n27/FEBRRO/2023 LIMPIEZA FACIAL CON AP. EXTRA DE CASMARA LUCY ENTRO 5:00\r\n20/MARZO/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUISTANTE ROSY ENTRO 4:00 (MEGA)\r\n26/ABRIL/2023 LIMPIEZA FACIAL CON AMP. STABILIZING DE NATURA BISSE OFELIA ENTRO 5:50\r\n15/MAYO/2023 LIMPIEZA FACIAL CON AMP. EXTRA DE AGE DE CASMARA JOHANY ENTRO 4:05\r\n8/JUNIO/2023 LIMPIEZA FACIAL CON AMP. PIEL SENSIBLE OFELIA ENTRO  11:20\r\n20/JUNIO/2023 LIMPIEZA FACIAL JHOANY ENTRO 6:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-13 13:07:21', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('311', 'C-100311', '', 'ENMANUEL ROBLES SALOMON', '9931565041', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('312', 'C-100312', '', 'DANIELA ALMAZA CASTILLO', '9933556604', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('313', 'C-100313', '', 'CRISTINA SANCHEZ OLIVIER', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('314', 'C-100314', '', 'LILI DELGADO HERNANDEZ', '9934301161', '', '14/abril/18 limpieza facial 2x600 monica 3.05 (mega)\r\n02/noviembre/18 limpieza facial 2x600 lupita entro 1:05 (mega)\r\n10/SEPTIEMBRE/2020 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 LUCY ENTRO 10:00 L\r\n10/SEPT/2020 LLEVO ROLL-ON SPOT S.O.S PUREXPERT\r\n17/AGOSTO/2021 LIMPIEZA FACIAL ROSI ENTRO 14:05 MEGA\r\n18/AGOSTO/2021 LIMPIEZA DE ESPALDA MONICA ENTRO 18:48 MEGA\r\n05/NOV/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MONICA ENTRO 17:10 MEGA\r\n04/ENERO/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE MONICA ENTRO 7:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-04 16:37:26', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('315', 'C-100315', '', 'KARINA SANCHEZ OLIVIER', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('316', 'C-100316', '', 'MARITZA ROSADO GALLEGOS', '9335938181', '', '4-10-15 se realizó promo del mes y MDM 2x1 mirena cristal 12pm\r\n4/ene/16 promocion desintoxicante lucy entro 4.55\r\n29/ene/16 promocion desintoxicante carmen entro 11:00\r\n26/feb/16 promocion roll & lift y mdm holístico maria entro 9:40\r\n8/julio/16 promocion de colageno anita entro 10:30\r\n29/julio/16 promocion de coalgeno lucy entro 11.10\r\n29/julio/16 masaje geotermal carmen entro 12.30\r\n28/oct/16 masaje full relax y promocdion de colageno  charito entro 9:15\r\n27/ene/17 promocion desintoxicante y masaje fullr elax carmen entro 10:50\r\n31/marzo/17 mdm full relax, promocion estimulante de colageno con luz leds yennifer entro 9:00\r\n21/abril/17 mdm holistico, promocion termico anita entro 3:40\r\n5/junio/17 promocion antioxidante anita entro 3:30\r\n5/agosto/17 masaje holistico y promocion desvanece las lineas del tiempo mariana entro 10.25\r\n10/nov/17 mdm holistico, promocion termico-humectante lucy entro 3:50\r\n14/12/17 MASAJE HOLISTICO PROMOCION TRATAMIENTO GOLD LUCY ENTRO 4:00\r\n09/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO OFELIA ENTRO 3:50 \r\n21/MARZO/18 PROMOCION CATIODERMIA LUPITA- MARY LAZARO ENTRO 2:10\r\n25/MAYO/18 MDM HOLÍSTICO Y  PROM TRATAMIENTO FACIAL ANTIEDAD MARY ENTRO 10:10\r\n15/AGOSTO/18 MDM FULL RELAX Y PROM TRATAMIENTO FACIAL HUMECTANTE LUPITA \r\n20/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE ANITA ENTRO 10:00\r\n12/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE MARY ENTRO 9:10\r\n20/FEB/19 PROMOCION REAFIRMANTE MARY LAZARO ENTRO 1:45\r\n5/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE Y MDM HOLÍSTICO ANITA ENTRO 11:00\r\n15/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX REYNA ENTRO 9:45\r\n1/JULIO/19 PROMOCION COLAGENO HIDROLIZADO LUCY ENTRO 2:25\r\n25/JULIO/19 TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO Y MDM FULL RELAX YANETH ENTRO 9:10\r\n27/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA LUPITA ENTRO 9:55\r\n15/NOV/19 PROMOCION TRAT DE PERLA ANITA ENTRO 10:10\r\n20/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K MARY LAZARO ENTRO 3:50\r\n11/FEBRERO/20 TRATAMIENTO FACIAL 4F LUPITA ENTRO 2:35\r\n17/JUNIO/2020 PROMOCION TRAT REPARADOR ANTIEDAD MARY LAZARO ENTRO 9:55\r\n3/AGOSTO/2020 MASAJE FULL RELAX 2 X 600, PROMOCION TRAT OXIGENANTE MARIANA ENTRO 9:10\r\n9/OCT/2020 PROMOCION TRAT GOLD REGENERANTE LUCY ENTRO 9:45\r\n16/DIC/2020 PROMOCION TRAT PORCELANA ANITA ENTRO 1:10\r\n4/MARZO/2021 PROMOCION TRAT. ACIDO HIALURONICO LUCY ENTRO 9:50\r\n26/MARZO/2021 PROM. TRATAMIENTO FACIAL ACIDO HIALURONICO MARY LAZARO ENTRO 10:00\r\n20/ABRIL/2021 MASAJE FULL RELAX 2 X 600, PROMOCION TRAT. VIT C JHOANY ENTRO 10:40\r\n16/JULIO/2021 PROMOCION TRAT CAVIAR Y ORO LUCY ENTRO 11:30\r\n30/AGOSTO/2021 PROMOCION TRAT. ORGANICO REVITALIZANTE MARIANA ENTRO 10:25\r\n5/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD MARY LAZARO ENTRO 10:10\r\n4/DIC/2021 MASAJE FULL RELAX 2 X 600, PROMOCION TRAT. FACE PURE JHOANY ENTRO 11:40\r\n27/ENERO/2022 MASAJE FULL RELAX 2 X 600, PROMOCION TRAT. DETOX MARIANA ENTRO 9:10\r\n2/ABRIL/2022 MASAJE FULL RELAZ Y PROM. TRATAMIENTO FACIAL CINETICO MIRENA ENTRO 8:00\r\n27/MAYO/2022 PROM. TRATAMIENTO FACIAL FITO-HIDRATANTE JOHANY\r\n27/MAYO/2022 MASAJE FULL RELAX 2X600 SUSI\r\n24/JUNIO/2022 PROMOCION TRAT YOGA FACIAL MARIANA ENTRO 11:00\r\n26/JULIO/2022 HIFU FACIAL $2500.00 SRA. BEGO ENTRO 12:15\r\n24/SEPTIEMBRE/2022 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 ARIANA ENTRO 10:45\r\n31/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA  ARIANA ENTRO  2:05\r\n2/DICIEMBRE/2022 PROMOCION TRAT. FACIAL GOLDEN ARIANA ENTRO 2:00\r\n29/DICIEMBRE/2022 MASAJE HOLISTICO, LIMPIEZA FACIAL ARIANA ENTRO 9:00\r\n24/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE ARIANA ENTRO 11:00\r\n21/FEBRERO/2023 DUO MASAJE FULL RELAX Y PROMO TRATAMIENTO FACIAL ELIXIR JUVENTUD ARIANA ENTRO 1:55\r\n13/ABRIL/2023 DUO LIMPIEZA FACIAL KARLA ENTRO 8:50\r\n20/JUNIO/2023 PROMOCION TTRAT. FACIAL ULTRASOUND LUCY ENTRO 10:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-15 20:22:18', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('317', 'C-100317', '', 'NARDA BEATRIZ BERNAL SANCHEZ', '9931508993', '', '29/dic/15 pantorrilla y bikini 30ms 18j lucy\r\n02/MARZO/18 LIMPIEZA FACIAL 2 X 600 REYNA ENTRO 5:25\r\n23/MAYO/18 LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 4:40', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('318', 'C-100318', '', 'AMPARO MARTINEZ CRUZ', '9361067010', '', '17/marzo/16 promocion hidratación charito entro 10:25\r\n17/marzo/16 llevo heliocare compacto brown, heliocare gel y heliocare oral \r\n25/agosto/17 promocion desvanece las lineas del tiempo mariana entro 11:25\r\n14/octubre/17 prom. del mes trat. reafirmante entro 11:50 (mega)\r\n17/ENERO/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO REYNA ENTRO 11:35\r\n19/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE MONICA ENTRO 1:35\r\n12/DIC/18 PROMOCION DIAMANTE, LIFTING PARCHES ACIDO HIALURONICO REYNA ENTRO 11:15 (SE LE RECOMENDO HYDRAFACIAL, LIFTING TIMEXPERT RIDES)\r\n12/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE Y LIFTING DE COLÁGENO  REYNA ENTRO 11:15\r\n17/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD REGENERANTE MONICA ENTRO 10:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('319', 'C-100319', '', 'ALFONSO MARTINEZ CEFERINO', '9363640129', '', '17/marzo/16 promocion hidratante maria entro 10:25\r\n25/agosto/17 promocion desvanece las líneas del tiempo charito entro 11:25\r\n17/01/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO MARIANA ENTRO 11:35\r\n19/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE MARY ENTRO 1:40\r\n17/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD REGENERANTE LUCY ENTRO 10:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('320', 'C-100320', '', 'YUMAILA LETICIA OLMOS TIQUE', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('321', 'C-100321', '', 'ALEJANDRO PEREZ GUEVARA', '9932126681', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('322', 'C-100322', '', 'VACIO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('323', 'C-100323', '', 'ROSA CARMEN VARGAS BALLESTEROS', '9932425120', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('324', 'C-100324', '', 'SILVIA LEE DELGADO', '9931732133', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('325', 'C-100325', '', 'LUIS ALEJANDRO ORAMAS HERNANDEZ', '9333350113', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('326', 'C-100326', '', 'DULCE MARIA CHAVEZ VELEZ', '', '', '30/sept/16 promocdion de colageno susy entro 10:35\r\n8/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS SANDY ENTRO  3:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('327', 'C-100327', '', 'ELIAS ZACARIAS NARVAEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('328', 'C-100328', '', 'ANNEL RAMIREZ DE PAZ', '9932120616', '', '03/julio/16 mdm holistico 2x600 andrea entro 3:20 (mega)\r\n27/octubre/18 mdm full relax y limpieza facial 2x600 susy entro 11:00 (mega)\r\n07/JULIO/19 MDM FULL RELAX 2X600 CARMEN ENTRO 6:10 MEGA\r\n24/agosto/19 mdm full relax 2x600 rosy entro 3:55 mega\r\n27/OCTUBRE/19 MDM FULL RELAX 2X600 MONI ENTRO 1:10 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('329', 'C-100329', '', 'IRASEMA DE PAZ CRUZ', '', '', '03/julio/16 mdm holistico 2x600 charito entro 3:15 (mega)\r\n27/octubre/18 mdm full relax y limpieza facial 2x600 lupita entro 11:00 (mega)\r\n07/JULIO/19 mdm full relax mony entro 6:05 mega\r\n27/OCTUBRE/19 MDM FULL RELAX 2X600  ALE ENTRO 1:10 MEGA\r\n09/OCT/2021 MASAJE FULL RELAX 2X600 ROSI ENTRO 11:00 MEGA\r\n11/OCT/2021 LIMPIEZA FACIAL 2X600 ROSI ENTRO 16:10 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('330', 'C-100330', '', 'MARIBEL ANGEL GONZALEZ', '9361310562', '', ' 21/dic/10 limpieza de acne con amp. desincrustante marina entro 8:00 salio 9:15 \r\n28/dic/10 limpieza de acne marina entro 9:04 \r\n4/ene/11 limpieza de acne sara entro 10:00 \r\n se le dio gel oil-control y crema extracto de caracol\r\n1.-12/ene/11 punta de diamante reyna entro 10:45 \r\n2.-17/ene/11 punta de diamante ofelia\r\n3.-1/feb/11 punta de diamante lucy entro 9:01\r\n4.-8/feb/11 punta de diamante reyna entro 9:05 \r\n5.-15/feb/11 punta de diamante reyna \r\n6.-22/feb/11 punta de diamante mariana entro 9:03 \r\n7.-2/marzo/11 punta de diamante reyna entro 9:05\r\n11/marzo/11 limpieza de acne con amp. piel grasa, masaje de espalda reyna entro 9:15\r\n8.-16/marzo/11 micro punta de diamante sara entro 8:55\r\n9.-28/marzo/11 micro punta de diamante sara entro 11:05\r\n10.-7/abril/11 micro punta de diamante karina entro 9:41\r\n20/abril/11 limpieza de acne susy entro 11:10\r\n11.29/abril/11 micro punta de diamante karina entro 8:50 la masc. de azuleno y sabila le arde, se le\r\nrecomienda evitar asolearse* llevo pantalla solar\r\n19/mayo/11 limpieza de acne susy entro 9:00\r\n12.-2/junio/11 micro punta de diamante mariana entro 9:15\r\n13.-16/junio/11 micro punta de diamante gladys entro 9:00\r\n14.-15julio/11 micro punta de diamante karina entro 10:50\r\n30/junio/11 limpieza de acne con amp. desincrustante karina entro 9:10\r\n15julio/11 llevo crema clear y meladermic\r\n27/julio/11 micro punta de diamante mariana entro 11:00\r\ntermino tratamiento micro solo va a venir a limpieza de acne.\r\n20/agosto/11 limpieza de acne reyna entro 9:40 llevo jabon acnaid, crema facial acida ph5\r\n09/sep/11 limpieza de acne dulce se llevo locion y shampoo de pilosome\r\n12/occt/11 limpieza de acne con amp. desinc. reyna entro 10:50\r\n11/nov/11 limpieza de acne con amp. desincrustante y amp. aclaradora dulce\r\n22/dic/11 limpieza de acne con amp. desincrustante rocio entro 12:40\r\n27/feb/12 limpieza de acne lucy entro 4:40\r\n25/mayo/12 limpieza de acne con amp. desincrustante rosy entro 11:55\r\n8/junio/12 limpieza de acne con amp. desincrustante aracely entro 10:50\r\n11-07-16 SE REALIZO L-A PROFUNDA ANITA 8-30\r\n18/julio/12 limpieza de acne con amp. desincrustante reyna entro 11:25 llevo crema white line lendan\r\n23/julio/12 micro punta de diamante mariana entro 12:30\r\n7/feb/13 limpieza de acne con amp. purificante reyna entro 9:00\r\n27/sept/13 limpieza de acne con amp. desincrustante rosy entro 1:00\r\n26/dic/13 limpieza de acne con amp. desincrustante reyna entro 12:15\r\n18/julio/14 limpieza de acne candy entro 8:55\r\n\r\n16/enero/15 limpieza de acne con amp. desincrustante mariana entro 9:17\r\n29/enero/15 delineado de cejas ofelia, se le dieron $100.00 a ofelia\r\n12/febrero/15 limpieza de acne con amp. desincrustante johany entro 8:50\r\n12/feb/15 ret de cejas ofelia, se le dieron $100.00a ofelia\r\n22/junio/15 limpieza de acne con amp. desincrustante carmen entro 9:00 salio 10:10\r\n19/oct/15 limpieza de acne con amp. desincrustante andrea entro 8:45 \r\n26/oct/15 limpieza de acne con amp. desincrustante fernanda entro 8:50\r\n9/nov/15 limpieza de acne con amp. desincrustante lizvet entro 8:55\r\n14/nov/15 limpieza facial con amp. desincrustante lizvet entro 9:00\r\n18/nov/15 microdermoabrasion mariana entro 8:30\r\n25/nov/15 microdermoabrasion graciela entro 8:20\r\nUSAR SOLO MICRO CON PUNTA DE DIAMANTE ES ALÉRGICA AL POLVO.\r\n2/dic/15 micro graciela entro 8:20\r\n18/dic/15 limpieza de acne graciela entro 8:50\r\n18/dic/15 micro punta de diamante graciela entro 10:00\r\n27/ene/16 limpieza de acne con amp. desincrustante lizvet entro 8:00\r\n21/marzo/16 limpieza de acne con amp. desicnrustante charito entro 8:45\r\n9/mayo/16 limpieza de acne con amp. desincrustante compartida carmen entro 9:00\r\n4/julio/16 limpieza de acne con amp. desincrustante mirena entro 8:50\r\n11-07-16 se realizo l-f profunda  9:00 anita\r\n21/julio/16 limpieza de acne con amp. desincrustante mary lazaor entro 9:00\r\n5/agosto/16limpieza de acne con amp. desincrustante mariana entor 9:05\r\n12/enero/17 promocion desintoxicante mary lazaro entro 9:05\r\n16/ene/17 limpieza de acne ofelia entro 9:10\r\n26/ene/17 micro ofelia entro 9:05\r\n30/ene/17 masaje fullr elax (Cliente frecuente ) susy entro 9:00\r\n24/agosto/17 limpieza de acne con amp. desincrustante yeni entro 9:00\r\n30/sept/17 promocion resveratrol mariana entro 8:55\r\n1/dic/17 limpieza de acne con amp. desincrustante mariana entro 9:00\r\n6/JUNIO/18  PROM TRATAMIENTO FACIAL ANTIOXIDANTE SUSY ENTRO 9:00\r\n16/JULIO/18 MDM DE CLIENTE FRECUENTE Y LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ANITA ENTRO 9:00\r\n26/OCT/18 PROMOCION REAFIRMANTE MONICA ENTRO 9:00\r\n10/ENE/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE KARLA ENTRO 11:30\r\n24/ENERO/19 PROMOCION REVITALIZANTE MONICA ENTRO 9:20\r\n12/ABRIL/19 DELINEADO DE CEJAS OFELIA\r\n30/ABRIL/19 RETOQUE DE CEJAS, SE LE DIO $100.00 PESOS A OFELIA ENTRO 9:00\r\n30/ABRIL/19 PROMOCION HUMECTANTE MONICA ENTRO 9:10\r\n17/SEPT/19 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE REYNA ENTRO 9:00\r\n10/DIC/19 PROMOCION TRAT 24 K CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 12:05\r\n13/MAYO/2021 PROMOCION TRAT. CELULAS MADRE CON AMP. DE COLAGENO DE GERMAINE JHOANY ENTRO 12:00\r\n27/MAYO/2021 PROM. TRATAMIENTO FACIAL DE CELULAS MADRE CON AMP DE COLAGENO MONICA ENTRO 12:40\r\n14/NOVIEMBRE/2021 PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO  JOHANY ENTRO 8:50\r\n18/NOVIEMBRE/2021  DELINEADO DE CEJAS SE LE DIO 300 OFELIA ENTRO 8:55\r\n7/DIC/2021 PROMOCION TRATAMIENTO FACE PURE MIRENA ENTRO 9:00 \r\n4/AGOSTO/2022 PROMOCION TRAT FACIAL ANTIOXIDANTE MARIANA ENTRO 11:20', 'no', 'activo', '2021-12-07 00:49:45', '2022-08-04 08:38:50', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('331', 'C-100331', '', 'MARIA GUADALUPE JIMENEZ ZAMUDIO', '9932513915', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('332', 'C-100332', '', 'CAROLINA ALVAREZ UGALDE', '', '', '14-02-16 se realizo  limp facial cristal sussy 3pm', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('333', 'C-100333', '', 'AUSTRALIA HIDALGO', '9931606501', '', '1-sept-15 promocion equilibrante de ph ofelia entro 9:05\r\n17/oct/15 promocion reafirmante ofelia entro 9:50\r\n20/nov/15 promocion antiedad humectante y nutritivo ofelia entr 9:05\r\ndejo pagada una sesion de skylight\r\n25/nov/15 skinlight ofelia entro 9:00 es el que estaba pagado\r\n7/ene/16 promocion desintoxicante ofelia entro 9:10\r\n27/feb/16 promocion rol & lift ofelia entro 1:00\r\n26/abril/16 promocion trat luxury ofelia entro 9:00\r\n30/junio/16 promocidon de elastine ofelia entro 9:10\r\n27/agosto/16 promoción de caviar ofelia entro 10:00\r\n29/oct/ promocion de colageno ofelia entro\r\n25/nov/16 promocion oxigenante ofelia entro 12:00\r\n13/dic/16 promocion trat multivitaminico ofelia entro 9:00\r\n26/ene/17 promocion desintoxicante ofelia entro 12.00\r\n25/marzo/17 promocion estimulante de colageno con luz leds ofelia entro 8:00\r\n2/mayo/17 promocion antiedad con lifting ofelia entro 9:10\r\n20/junio/17 promocion antioxidante ofelia entro 9:15\r\n9/agosto/17 promocion desvanece las lineas del tiempo susy entro 10:50\r\n19/sept/17 promocion resveratrol ofelia entro 10:45\r\n20/nov/17 promocion termico humectante ofelia entro 1:15\r\n19/12/17 PROMOCIÓN TRATAMIENTO GOLD OFE ENTRO 10:00\r\n20/ENERO/18 PROMOCION TRAT OXIGENANTE CON ULTRASONIDO OFELIA ENTRO 2:00\r\n14/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE OFELIA ENTRO 8:00\r\n26/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD OFELIA ENTRO 8:00\r\n7/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL OFELIA ENTRO 8:50\r\n11/AGOSTO/18  PROM TRATAMIENTO FACIAL HUMECTANTE ANITA ENTRO 8:00\r\n6/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE ANITA ENTRO 8:00\r\n20/DIC/18 PROMOCION DIAMANTE OFELIA ENTRO 4:00\r\n4/FEB/19 PROMOCION REAFIRMANTE OFELIA ENTRO 9:00\r\n2/MARZO/19 DELINEADO DE PARPADO SUPERIOR OFELIA\r\n2/MAYO/19 PROMOCION EFECTO BOTOX OFELIA ENTRO 10:55\r\n24/JULIO/19  TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO OFELIA ENTRO 9:35\r\n19/DIC/19 PROMOCION TRAT 24 K OFELIA ENTRO 9:00\r\n6/MARZO/2020 PROMOCION TRAT RECUPERADOR FACIAL OFELIA ENTRO 10:00\r\n15/OCT/2021 PROMOCION TRATAMIENTO ORGANICO CBD OFELIA ENTRO 8:00 \r\n17/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE  OFELIA ENTRO 9:00\r\n11/MARZO/2022 PROMOCION TRAT SHOCK DE COLAGENO OFELIA ENTRO 9:10\r\n20/AGOSTO/2022 PROM TRATAMIENTO FACIAL ANTIOXIDANTE OFELIA ENTRO V8:00\r\n15/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA OFELIA ENTRO 9:00 \r\n3/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN OFELIA ENTRO 9:50\r\n10/FEBRERO/2023 PROMOCION TRAT. FACIAL ELIXIR DE JUVENTUD OFELIA ENTRO 9:00\r\n16/MARZO/2023 PROMOCION TRAT. FACIAL MICRODERMA ANTIEDAD OFELIA ENTRO 9:10\r\n28/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND OFELIA ENTRO 9:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-01 12:02:07', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('334', 'C-100334', '', 'MIGUEL CASTRO TORRES', '9931365567', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('335', 'C-100335', '', 'ADELIA GARZA RUBALCAVA', '9931283378', '', '21/agosto/14 mdm drenaje linfatico yusiria entro 10:50\r\n21/agosto/14 facial desafio antiedad bego entro 12:20\r\n16/oct/14 facial vitamina c de natura bisse bego entro 11:00\r\n24/nov/14 mdm drenaje linfatico lucero entro 5:10\r\n28/nov/14 facial oxigenante natura bisse reyna entro 10:00\r\n13/02/15 serealizo excel terapi atendio sra bego entro alas 12. cristal llevo producto emulsion exe\r\nexcel terapi crema excel terapi contorno de ojos excel y rolon de formen \r\n17/marzo/15 radiofrecuencia facial bego entro 10:15 llevo crema contorno de ojos de natura bisse\r\n31/marzo/15 regeneración celular con frioterapia y mascariilla de leds sra bego ($1,500.00)\r\n20/abril/15 botox dr. oscar garcia\r\n29/abril/15 facial retinol de atache sra.bego \r\n6/mayo/15 mdm full relax (cliente frecuente) eva entro 8:55\r\n6/mayo/15 facial retinol de jabotiere sra. bego\r\n30/junio/15 facial velo de colageno sra bego\r\n06/julio/15 facial retinol de germaine de capuccini $1400.00 sra. bego\r\nllevo crema hidratante intensiva piel seca de natura bisse, retinol fluido de essetial shock de natura bisse, crema contorno de ojos de natura bisse, glyco peelin exfoliante para todo tipo del pieles nb y crema remodelante de cuello y escote de timexpert lift neck\r\n10/sept/15 facial oxigeno NB sra. bego\r\n22/oct/15 facial oxigenante nbbego entro 10:10\r\n27/oct/15 botox 1/3 sus 42u dr. oscar garcia\r\n11/dic/15 facial vitamica natura bisse sra. bego\r\n27/feb/17 masaje full relax (cleinte frecuente) yenni entro 4:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('336', 'C-100336', '', 'AURORA DEL CARMEN ORTEGA ALOR', '9211025565', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('337', 'C-100337', '', 'SANDY LIZBETH PEREZ FRIAS', '9331037249', '', '10/dic/15 limpieza facial con amp. desincrustante reyna entro 2:10\r\n2/JULIO/20 INICIA LASER DE BIGOTE 30 MS 10 J LUCY\r\n1/AGOSTO/2020 LASER DE BIGOTE 30 MS 10 J SRA BEGO ENTRO 9:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('338', 'C-100338', '', 'ROSALINDA ESPINOSA DE RUBIO', '9933111486', '', '29/agosto/16 promocion de caviar mariana entro 10:45\r\n11/nov/17 limpieza facial anita entro 12:25\r\n29/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE LUCY\r\n7/SEPTIEMBRE/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MONICA ENTRO 12:05\r\n23/ABRIL/2021 LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 1:30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('339', 'C-100339', '', 'RAFAEL HERNANDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('340', 'C-100340', '', 'EVELIN VIDAL AGUILAR', '9931 559614', '', '16/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN BELÉN ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('341', 'C-100341', '', 'VANIA PATRICIA PELAEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('342', 'C-100342', '', 'LORENZA MUSI DE BOSH', '9933114947', '', 'el producto que usa en casa es teo vital \r\nno quiere vapor, ni extraccion.\r\n31/oct/08 dejo pagada una promocion de colageno. \r\n5/nov/08 promocion colageno bego entro 10:40 \r\n5/nov/08 desintoxicación de pies con iozen lucy \r\n20/nov/08 promocion lifting de parpados bego \r\n20/nov/08 desintoxicacion de pies con iozen \r\n19/dic/08 promocion vitamina c bego entro 10:30 salio 12:00 \r\n16/ene/09 promcoion jalea real bego entro 10:40 salio 12:00\r\n27/ene/09 promocion jalea real bego entro 10:40\r\n11/feb/09 promocion percollagen bego entro 10:30 \r\n10/marzo/09 micro bego entro 10:15 \r\n31/marzo/09 promocion spa therapy perla bego entro 10:00 salio 11:40 \r\n28/abril/09 micro con impulsos con equipo magic bego entro 10:00 \r\nse llevo hidramat puretskin, espuma limpiadora purificante puretskin lo va a usar 6 meses.\r\n14/junio/11 promocion estimulante de endorfinas bego entro 10:45\r\n\r\n26/mayo/09 anticouperose bego entro 10:15\r\n30/junio/09 micro bego llevo espuma limpiadora purificante puretskin\r\n8/julio/09 llevo emulsion hidramat puretskin\r\n30/julio/09 promocion extraperformance bego entro 10:30 salio 12:10 \r\n17/agosto/09 micro bego entro 10:30 \r\n25/agosto/09 promocion revitalizante bego entro 10:30\r\n22/sept/09 promocion termico de azuleno bego entro 10:25 \r\nllevo hidramat y espuma limpiadora puretskin\r\n26/oct/09 promocion hidronutritivo bego entro 10:35 \r\n17/nov/09 promocion restructurante bego entro 10:30 \r\nllevo espuma limpiadora purificante hidramat crema contorno de labios excell therapy \r\n4/dic/09 promocion flash beaute bego entro 10:30 \r\n15/dic/09 promocion flash beaute bego entro 10:30\r\n5/enero/09 promocion vinoterapia bego\r\n \r\n19/ene/10 pegatinas bego entro 10:40 llevo gel contorno de ojos vitamina c de lendan\r\n3/feb/10  facial bego entro 10:35\r\n16/feb/10 promocion estimulante de endorfinas bego entro 11:00 \r\n2/marzo/10 promocion de cristal bego entro 10:35 \r\nllevo mascarilla reguladora calmante y\r\n gel-crema matizador hidratante pure control de lendan.\r\n16/marzo/10 promocion de cristal bego entro 10:35\r\n12/abril/10 promocion 3 geles bego entro 10:40\r\n27/abril/10 promocion 3 geles bego entro 10:30 \r\nllevo espuma limpiadora piel grasa, \r\ngel-crema matizador hidratante pure control de lendan.\r\n11/mayo/10 promocion catiodermia bego entro 10:40\r\n llevo crema contorno de ojos de vitamina c lendan \r\n24/mayo/10 promocion catiodermia bego entro 10:37 \r\n31/mayo/10 promocion catiodermia con amp. jalea real bego entro 12:00\r\n8/junio/10 micro skinlight bego entro 10:30 \r\n21/junio/10 promocion botanico 4 f bego entro 11:00\r\n6/julio/10 promocion relajante e hidratante bego entro 10:30 \r\n20/julio/10 promocion relajante e hidratante bego entro 10:35\r\n7/agosto/10 promocion antiarrugas bego entro 10:00\r\n17/agosto/10 micro skinlight bego entro 10:30 \r\n31/agosto/10 promocion antiarrugas bego entro 10:36 \r\nllevo espuma limpiadora purificante puretskin, \r\ncrema facial fluida vitamina c de lendan\r\n14/sept/10 promocion termico bego entro 10:30 \r\n28/sept/10 promocion termico bego entro 10:25\r\n12/oct/10 promocion efecto botox bego entro 10:40\r\n llevo gel descongestivo de lendan.\r\n19/oct/10 promocion efecto botox bego entro 12:15\r\n25/oct/10 promocion efecto botox bego entro 11:00\r\n9/nov/10 promocion modeladora bego entro 10:30\r\n23/nov/10 promocion modeladora bego entro 10:45 \r\n7/dic/10 promocion velos de colageno bego entro 10:35\r\n14/dic/10 limpieza facial con amp. piel grasa de lendan bego entro 10:40 \r\n\r\n11/ene/11 promocion porcelana con amp. piel grasa de lendan bego entro 10:30\r\n25/ene/11 limpieza facial con amp. piel grasa bego entro 10:38\r\n llevo gel biocontrol y crema reafirmante cuelo y escote de timexpert lift\r\n8/feb/11 limpieza facial bego entro 10:26 \r\n22/feb/11 limpieza facial bego entro 10:30 \r\n23/feb/11 llevo gel descongestivo de ojos de lendan\r\n8/marzo/11 limpieza facial bego entro alas 11:00\r\n11/ene/16 promocion desintoxicante sra, bego \r\n22/marzo/11 promocion elastine bego entro 10:40\r\n5/abril/11 promocion vinoterapia bego entro 10:36\r\n12/abril/11 promocion de vinoterapia bego \r\n17/mayo/11 promocion botanico bego entro 10:30 \r\n31/mayo/11 promocion botanico bego entro 10:3\r\n14/junio/11 promocion estimulante de endorfina bego entro 10.45\r\n14/junio/11 llevo el gel descongestivo de ojos de lendan\r\n11/julio/11 promocion de amaranto bego entro 10:40\r\n9/agosto/11  promocion piel de seda   sra bego entro 10:30\r\n06/agosto/11 promocion del mes de sep tra. azteca bego se llevo contorno de ojos exceltherapy o2 \r\n20/sep/11 promocion azteca bego \r\n04/oct/11 promocion relajante bego\r\n18/oct/11 promocion relajante bego\r\n08/nov/11 promocion germen de trigo bego \r\n22/nov/11 promocion germen de trigo y vitamina e bego entro 10:30\r\n6/dic/11 promocion velo de colageno bego entro 10:30\r\n\r\n4/ene/12 promocion revitalizante bego entro 10:30\r\n10/ene/12 micro bego entro 10:35\r\n23/ene/12 promocion revitalizante bego entro 10:35\r\n7/feb/12 promocion 3 geles bego entro 10:30\r\n21/feb/12 promocion 3 geles con amp. equilibrante bego entro 10:45 llevo crema contorno de ojos\r\nde vitamina c de lendan\r\n6/marzo/12 promocion hidradermis bego entro 10:30\r\n20/marzo/12 facial con masc. bioxidea bego entro 10:30\r\n26/marzo/12 promocion hidradermis bego entro 10:40\r\n17/abril/12 promocion revitalizante bego entro 10:35\r\n2/mayo/12 promocion de velo de colageno bego entro 10:35\r\n16/mayo/12 promocion velo de colageno bego entro 10:30\r\n28/mayo/12 promocion velo de colageno bego entro 10:30\r\n13/junio/12 promocion reafirmante con amp. aclaradora bego entro 10:35\r\n27/junio/12 promocion reafirmante bego entro 10:30\r\n10/julio/12 promocion hidratante de arroz bego entro 10:35\r\n1/agosto/12 promocion reafirmante e hidratante bego entro 10:40\r\n14/agosto/12 promocion hidratante y reafirmante bego entro 10:35\r\n28/agosto/12 promocion hidratante y reafirmante bego entro 10:00\r\n18/sept/12 promocion de agave bego entro 10:40 llevo recuperador timexpert srns\r\n2/oct/12 promocion reafirmante de cuello bego entro 10:30\r\n16/oct/12 promocion reafirmante de cuello bego entro 10:35\r\n8/nov/12 micro bego entro 10:40 se le dio crema manchas white line de regalo\r\n20/nov/12 promocion de colageno lucy entro 10:40\r\n4/dic/12 promocion de oro bego entro 10:30\r\n18/dic/12 promocion de oro bego entro 10:30\r\n\r\n4/ene/13 cortesia cliente frecuente promocion lifting de parpados bego entro 10:35\r\n22/ene/13 promocion lifting de parpados bego entro 10:35\r\n13/feb/13 promocion catiodermia con amp. royal jelly bego entro 11:00\r\n26/feb/16 promocion catiodermia bego entro 10:30\r\n12/marzo/13 promocion royal jelly bego entro 10:35\r\n2/abril/13 promocion de porcelana bego entro 10:40\r\n23/abril/13 promocion porcelana bego entro 10:35\r\n14/mayo/13 promocion relajante e hidratante bego entro 10:40\r\n28/mayo/13 promocion relajante e hidratante bego entro 10:35\r\n11/junio/13 promocion coco y mango bego entro 10:35\r\n25/junio/13 promocion coco y mango bego entro 10:30\r\n31/julio/13 promocion colageno y elastine bego entro 10:35\r\n14/agosto/13 promocion oxigenante bego entro 10:30\r\n27/agosto/13 promocion oxigenante bego entro 10:30\r\n9/sept/13 promocion lifting antiarrugas bego entro 10:30\r\n25/sept/13 promocion lifting antiarrugas bego entro 10:30\r\n9/oct/13 promocion the verde bego entro 10:30\r\n24/oct/13 promocion the verde bego entro 10:30\r\n11/nov/13 promocion intensivo antiestres bego entro 10:50\r\n27/nov/13 promocion intensivo antiestres bego entro 10:40\r\n17/dic/13 promocion de oro bego entro 10:35\r\n\r\n7/ene/14 promocion desintoxicante bego entro 10:30\r\n15/ene/14 promocion desintoxicante bego entro 10:30\r\n29/ene/14  promocion desintoxicante bego entro 10:30\r\n10/feb/14 promocion eternamente joven bego entro 11:50\r\n26/feb/14 promocion eternamente joven bego entro 10:30\r\n12/marzo/14 promocion humectante bego entro 10:35\r\n5/mayo/14 promocion facial hidratante bego entro 10:40\r\n21/mayo/14 facial hidratante bego entro 10:35\r\n4/junio/14 promocion antioxidante bego entro 10:00\r\n16/junio/14 promocion antioxidante bego entro 10:30\r\n2/julio/14 promocion colageno bego entro 10:30\r\n16/julio/14 promocion de colageno bego entro 10:30\r\n13/agosto/14 promocion oxigenante bego entro 12:10\r\n28/agosto/14 promocion oxigenante bego entro 12:10\r\n10/sept/14 promocion trat. facial azteca bego entro 10:30\r\n24/sept/14 promocion trat facial azteca bego entro 10:30\r\n13/oct/14 promocion trat smoothie bego entro 12:00\r\n27/oct/14 promocion trat smoothie bego entro 12:00\r\n10/nov/14 limpieza facial con amp. equilibrante de atache bego entro 12:05\r\n24/nov/14 promocion antiedad humectante y nutritivo bego entro 12:10\r\n15/dic/14 promocion global antiedad bego entro 8:50\r\n\r\n7/enero/15 promocion trat. desintoxicante y oxigenante sra bego ento 9:30\r\n26/enero/15 promoción trat desintoxicante y oxigenante sra bego entro 9:25\r\n19/febrero/15 promocion tratamiento reafirmante sra bego entro 9:25\r\n16/marzo/15 promocion tratamiento anti-edad sra. bego \r\n9/abril/15 promoción tratamiento de porcelana sra. bego entro 10:40\r\n27/abril/15 promocion tratamiento de porcelana sra. bego entro 10:30\r\n2/junio/15 promocion antioxidante bego entro 10:30\r\n23/junio/15 promocion trat antioxidante sra. bego entro 10:30\r\n15/julio/15 promocion trat de cuello sra, bego entro 10.30\r\n30/julio/15 promocion trat de cuello sra. bego\r\n25/agosto/15 promocion chocoterapia sra. bego entro 10:30\r\n7/sept/15 promocion equilibrante de ph sra. bego entro 10:30\r\n30/sept/15 promocion equilibrante del ph sra bego entro 10:30\r\n14/oct/15 promocion equilibrante del ph sra. bego entro 10:30\r\n4/nov/15 promocion humectante y nutritiva sra. bego entro 10.30\r\n23/nov/15 promocion antiedad humectante y nutritivo sra. bego\r\n15/dic/15 promocion reafirmante modeladora sra.bego\r\n\r\n22/ene/16 promocion desintoxicante sra. bego\r\n14/marzo/16 promocion hydrtante sra. bego\r\n14/abril/16 promocion trat luxury sra. bego\r\n2/mayo/16 promocion sr5. bego\r\n24/mayo/16 promocion de colageno sra. bego\r\n4/julio/16 promoción de colageno sra, bego\r\n29/agosto/16 promocion de caviar sra. bego entro 5:00\r\n6/oct/16 promocion colageno sra. bego entro 10:10\r\n21/nov/16 promocion oxigenante sra. bego entro 11:30\r\n7/dic/16 promocion trat multivitaminico sra. bego\r\n21/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO SRA BEGO\r\n18/ene/17 promocion desintoxicante sra. bego entro 5:00\r\n30/ene/17 promocion desintoxicante sra. bego entro 4:30\r\n13/feb/17 promocion trat de elastine sra. bego entro 4:30\r\n19/abril/17 promocion termico sra bego entro 4:25\r\n24/julio/17 promocion trat relajante hidratante sra. bego entro 4:30\r\n4/agosto/17 masaje full relax (cliente frecuente) monica entro 4:20\r\n20/nov/17 promocion termico humectante sra. bego entro 4:30\r\n18/12/17  LIMPIEZA FACIAL BEGO ENTRO 10:35\r\n24/01/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO SRA BEGO\r\n13/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE SRA BEGO\r\n28/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD SRA BEGO\r\n22/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE SRA BEGO\r\n27/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE SRA BEGO\r\n31/AGOSTO/18 MDM DE CUELLO SRA BEGO\r\n3/SEP/18 MDM DE CUELLO SRA BEGO  $400.00\r\n9/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN SRA BEGO\r\n3/DIC/18 PROM TRATAMIENTO FACIAL ANTIEDAD SRA BEGO\r\n14/ENE/19 PROM TRATAMIENTO FACIAL REVITALIZANTE SRA. BEGO\r\n20/FEB/19 PROMOCION REAFIRMANTE SRA. BEGO ENTRO 4:40\r\n20/MARZO/19 PROM TRATAMIENTO FACIAL DETOX SRA BEGO\r\n29/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE\r\n20/MAYO/19 PROMOCION EFECTO BOTOX SRA. BEGO ENTRO 4:30\r\n10/JUNIO/19 PROMOCION REVOLUCIONARIO ANTIEDAD SRA BEGO ENTRO 4:40\r\n24/JUNIO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO ANTIEDAD SRA BEGO\r\n28/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA SRA BEGO\r\n23/SEP/19 TRATAMIENTO FACIAL OXIGENANTE SRA BEGO\r\n28/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION SRA BEGO ENTRO 4:40\r\n16/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K SRA BEGO\r\n27/ENERO/20 TRATAMIENTO FACIAL DESINTOXICANTE OFELIA ENTRO 4:30\r\n23/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD REGENERANTE SRA BEGO ENTRO 4:05\r\n24/MAYO/2021 PROM. TRATAMIENTO FACIAL CELLAS MADRE SRA BEGO ENTRO 3:55\r\n15/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD SRA BEGO\r\n28/FEBRERO/2022 PROM. TRATAMIENTO FACIAL AGE DEFENSE BEGO ENTRO 4:35\r\n28/MARZO/2022 PROM. TRATAMIENTOFACIAL SHOCK DE COLAGENO SRA BEGO\r\n27/ABRIL/2022 PROM. TRATAMIENTO FACIAL CINETICO SRA BEGO\r\n6/JULIO/2022 PROMOCION TRAT ROLL & LIFT SRA. BEGO ENTRO 4:25\r\n23/ENERO/2023 PROMO TRATAMIENTO FACIAL PURIFICANTE SR ABEGO ENTRO 4:35\r\n10/ABRIL/2023 PROMO TRATAMIENTO FACIAL PLASMA MARINO SRA BEGO ENTRO 4:20\r\n19/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND SRA. BEGO ENTRO 4:30 LLEVO MASCARILLA HYALURONIC DE CASMARA', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-12 12:47:27', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('343', 'C-100343', '', 'LILIA FERNANDEZ PEDRERO DE CRUCES', ' CEL: 9933112019', '', '1/feb/17 promocion de elastine mariana entro 11:10 llevo aceite de rosa mosqueta ceutical nb\r\n8/mayo/17 facial vitamina c de germaine lucy entro 12:00\r\n28/NOV/18 FACIAL DE VITAMINA C DE GERMAINE LUPITA ENTRO 4:05\r\n8/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX REYNA ENTRO 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('344', 'C-100344', '', 'LUPITA ANDRADE DE SANCHEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('345', 'C-100345', '', 'ERIKA LILIANA SANCHEZ GAMAS', '9372837988', '', '21/ENERO/20 MASAJE DESCONTRACTURANTE MARIANA ENTRO 12:20\r\n4/JULIO/2020 HYDRAFACIAL LUCY ENTRO 12:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('346', 'C-100346', '', 'MARIA REMEDIOS SANTOS MADRIGAL', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('347', 'C-100347', '', 'SUSANA LOPEZ SANTOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('348', 'C-100348', '', 'ROSA OMAIRA VARGAS PEREZ', '9933997793', '', '4/agosto/17 masaje descontracturante charito entro 3:00\r\n2/ENE/19 INICIÓ TRATAMIENTO CORPORAL COSTÓ 8,000 ABONO 4,000 DEBE 4,000\r\n10/ENE/19 TERMINO DE PAGAR SU TRATAMIENTO //PAGADO//\r\n1.-  MASAJE Y CAVI 2/ENE/19 BELEN\r\n2.- CARBOX, MASAJE, CÁPSULA  4/ENE/19 BELÉN Y LUPITA\r\n3.- LASER LIPOLITICO, MASAJE  7/ENE/19 KARLA\r\n4.- CARBOX, MASAJE, TERMOSLIN  8/ENE/19 BELEN\r\n5.- MASAJE Y CORPO   9/ENE/19 BELEN ENTRO 9:15\r\n6.- CARBOX, MASAJE, G5 Y VENDAS CALIENTES   10/ENE/19 BELEN ENTRO 4:35\r\n7.- MASAJE Y CÁPSULA  11/ENE/19 BELEN ENTRO 10:10\r\n8.- CARBOX, MASAJE, RADIOFRECUENCIA 14/ENE/19 BELEN \r\n9.- MASAJE Y VENDAS CALIENTES\r\n10.- CARBOX, ULTRASONIDO, MASAJE  Y VENDAS CALIENTES \r\n23/ABRIL/2022 MASAJE SENSORELAX ROSI ENTRO 10:20 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('349', 'C-100349', '', 'HECTOR BRICE', '9933200018', '', '4/agosto/17 limpieza facial con amp,. desincrustante mariana entro 3:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('350', 'C-100350', '', 'YAZMIN DE MARIA CANABAL RUSSI', '9932756480', '', '25/OCTUBRE /2022 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE MONICA ENTRO 10:05 (MEGA)\r\n5/NOVIEMBRE/2022 FACIAL  EXCEL THERAPY SRA BEGO ENTRO 8:55\r\n23/NOVIEMBRE/2022 FACIAL VITAMINA TIMEXPERT RADIANCE SRA. BEGO ENTRO 9:55\r\n12/DICIEMBRE/2022 FACIAL TIMEXPERT SRNS BEGOÑA ENTRO 2:00\r\n14/ENERO/2023 TRATAMIENTO FACIAL VELOS ELASTICOS $2000.00 SRA. BEGO ENTRO 10:15 LLEVO LOCION TONIFICANTE PIEL SECA DE GERMAINE, LECHE DESMAQUILLANTE PIEL SECA DE GERMAINE ', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-06 16:33:52', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('351', 'C-100351', '', 'SARA DURAN AVILES', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('352', 'C-100352', '', 'MARIA DEL CARMEN AGUILERA HERNANDEZ', '9931603849', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2022-11-04 12:34:19', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('353', 'C-100353', '', 'JORGE AGUILERA CERON', '9931603849', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('354', 'C-100354', '', 'ELOISA PE', '9932076636', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('355', 'C-100355', '', 'DANIEL VILLA SALINA', '9932076636', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('356', 'C-100356', '', 'ROSA MARIA SALINAS HERNANDEZ', '9932226509', '', '19/OCTUBRE/19 LIMPIEZA FACIAL PROFUNDA JANETH ENTRO 7:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('357', 'C-100357', 'PEML770227219', 'LUCIA PEREZ MARTINEZ', '9931036749', 'ame.enmanosexpertos@gmail.com', '02/01/16 PROMOCIÓN FULL RELAX ATENDIÓ ROSITA. 3:55 MEGA.\r\n28/marzo/16 mdm full relax andrea entro 4:20 (mega)\r\n17/julio/16 mdm full relax andrea entro 3:00 (mega)\r\n12/dic/16 masaje full relax reyna etro 12:10\r\n28/dic/16 masaje full relax reyna entro 2:00\r\n13/nov/17 mdm sensorelax mary lazaro entro 12:10\r\n14/marzo/18 mdm sensorelax candy entro 1:10 (mega)\r\n03/diciembre/18 full relax entro 2.00 atendio charito (mega)\r\n8/ABRIL/19 MASAJE GEOTERMAL MARY LAZARO ENTRO \r\n15/JULIO/19 MASAJE GEOTERMAL ANITA ENTRO 4:50\r\n19/JUNIO/2023 MASAJE FULL RELAX ROSY ENTRO 7:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-19 20:30:44', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('358', 'C-100358', '', 'LUZ ANTONIA DE DIOS JIMENEZ', '9933112229', 'gapa95@msn.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('359', 'C-100359', '', 'OMAR MANZUR CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('360', 'C-100360', '', 'ARIEL MANZUR CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('361', 'C-100361', '', 'JULIA ARIADNA MOLINA GAMEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('362', 'C-100362', '', 'KARINA ULIN ORUETA', '9932005545', '', '15-12-15 se realizo promocion del mes cristal lisbeth 5-15 \r\n01-02-16 SE REALIZO LIMP FACIAL CRISTAL SUSSY 5PM\r\n13/dic/16 limpieza facial con amp. desincrustante reyna entro 12:00\r\n09/febrero/17 limpieza facial candy entro 2:10 (mega)\r\n20/julio/17 promocion trat relajante e hidratante mary lazaor entro 12-40\r\n28/sept/17 limpieza facial carmen entro 12:00 (mega)\r\n14/noviembre/17 mdm cliente frecuente y promocion del mes carmen entro 12:00 (mega)\r\n22/diciembre/17 prom. del mes trat. gold candy entro 12:45 (mega)\r\n07/FEB/18 LIMPIEZA FACIAL MARY ENTRO 9:05\r\n12/ABRIL/18 LIMPIEZA FACIAL CON PROM DE LIFTING DE LOS OJOS REYNA  ENTRO 3:40\r\n2/JUNIO/18 LIMPIEZA FACIAL REYNA ENTRO 9:00\r\n27/AGOSTO/18 LIMPIEZA FACIAL MONICA 1:25\r\n07/octubre/18 prom. del mes trat. reafirmante lupita entro 3 (mega)\r\n21/noviembre/18 limpieza facial atendio susy entro 5.00 (mega)\r\n16/diciembre/18 limpieza facial monica entro 2:00 (mega)\r\n15/ENERO/19 MDM DESCONTRACTURANTE LUPITA ENTRO 3:20\r\n1/FEB/19 PROM TRATAMIENTO FACIAL REAFIRMANTE MARY LAZARO ENTRO 3:00\r\n26/MARZO/19 PROM TRATAMIENTO FACIAL DETOX MONICA ENTRO 9:00\r\n5/JULIO/19 LIMPIEZA FACIAL LUPITA ENTRO 2:55\r\n16/agosto/19  limpieza facial susy entro 3:00 mega\r\n21/SEP/19 LIMPIEZA FACIAL MONY ENTRO 4:55 MEGA\r\n24/sep/19 mdm full relax cliente frecuente rosy entro 1:00 mega\r\n21/OCTUBRE/19 LIMPIEZA FACIAL 2X600 MONI ENTRO 10:55 MEGA\r\n10/DIC/19 PROMOCION TRAT 24 K CON AMP. ACLARADORA LUPITA ENTRO 9:00\r\n5/SEPTIEMBRE/2020 LIMPIEZA FACIAL ANITA ENTRO 3:00\r\n27/OCT/2020 PROMOCION TRAT GOLD REGENERANTE ROSY ENTRO 11:20\r\n11/FEB/2021 LIMPIEZA FACIAL ANITA ENTRO  2:55\r\n10/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE MARY LAZARO ENTRO 2:00\r\n15/AGOSTO/2022 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE SUSY ENTRO 4:20 (MEGA)\r\n3/OCTUBRE/2022 PROMO. TRATAMIENTO FACIAL PREVENTIVO DE MANCHAS MARIANA ENTRO 5:35', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-03 15:49:10', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('363', 'C-100363', '', 'GUADALUPE ADRIANA GONZALEZ ALVARADO', '9931174333', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('364', 'C-100364', '', 'LUZ MERCEDES PERAZA ARAMBURO', '9931169090', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('365', 'C-100365', '', 'JUAN LORENZO HERNANDEZ DIAZ', '', '', '7/feb/11 limpieza facial 2 x 1 jhoany entro 12:10 salio 1:05 (sucursal) \r\n10/nov/12 mdm sara entro 12:40\r\n11/08/13 masaje express martha mega\r\n06/10/13 limp´.facial y mdm 2x1 martha mega 10:10\r\n14/01/14 masaje full relax atendio jhoany mega entro 7:00\r\n20/07/14 mdm full relax y lim facial susi mega 11:00\r\n08/nov/14 mdm full relax y limpieza facial candy entro 10:25 (mega)\r\n23/ene/15 mdm full relax y limpieza facial candy entro 12:20 (mega)\r\n05/SEPTIEMBRE/15 LIMPIEZA FACIAL Y MDM FULL RELAX MARIBEL ENTRO 3:05 (MEGA)\r\n30/enero/16 prom. del mes andrea entro 10:35 (mega)\r\n05/marzo/16 mdm full relax maria entro 10:10 (mega)\r\n01/noviembre/16 mdm full relax y limpieza facial lizbeth entro 6:00 (mega)\r\n28/octubre/17 limpieza facial anita entro 5:55 (mega)\r\n22/julio/18 mdm full relax y limpieza facial 2x600 lupita entro 3:00 (mega)\r\n06/ABRIL/19 MDM FULL RELAX Y LIMPIEZA FACIAL 2X600 LUPITA ENTRO 2:10 MEGA\r\n07/JUNIO/2022 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 ROSI ENTRO 16:35 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2022-06-07 16:58:17', '1', '26', null, null);
INSERT INTO `clientes` VALUES ('366', 'C-100366', '', 'SILVIA DIAZ TRINIDAD', '', '', '01/MAYO/2023 MASAJE FULL RELAX ROSY ENTRO 1:00 (MEGA)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('367', 'C-100367', '', 'GUADALUPE ALVARADO GONZALEZ', '19363621803', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('368', 'C-100368', '', 'MIGUEL ANGEL GONZALEZ ALVARADO', '19363621803', '', '23/diciembre/16 limpieza facial 2x600 lizbeth entro 6:50 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('369', 'C-100369', '', 'PAOLA MORENO OCHOA', '9931605037', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('370', 'C-100370', '', 'BERTHA LILIA RODAS CANTON', '9933115992', '', '29/ENERO /2016/ SE REALIZO DEPILACIO VIKINY Y AXILA ENTRO 6:00 ATENDIO NELLY \r\n10/febrero /2016 liftin atendio nelly entro 5:30 altozano\r\n18/03/2016 full relax de cliente frecuente atendio nelly entro 5:50\r\n21/marzo/2016/ full relax atendio nelly entro 3:50 altozano\r\n03/abril/2016 full relax atendio nelly entro 10:30 altozano \r\n25/mayo/2016 facial basico atendio nelly entro 5:45 altozano\r\n12/junio/2016 dep axila y bikiny atendio nelly entro 10:15 altozano\r\n1/JULIO/2022 DEPILACION CON CERA BIKINI TOTAL Y AXILA JHOANY ENTRO 11:05 ', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-01 10:01:34', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('371', 'C-100371', '', 'PATRICIA HERRERA AGUILAR', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('372', 'C-100372', '', 'PAULINA CADENA DE LA CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('373', 'C-100373', '', 'DAVID CADENA DE LA CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('374', 'C-100374', '', 'ADELA ROSALDO GONZALEZ', '99331057504/019333345566', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('375', 'C-100375', '', 'NORMA SANTOS ROSALDO', '9331220953', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('376', 'C-100376', '', 'LISBETH RAMIREZ CHAN', '9991215349', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('377', 'C-100377', '', 'GUILLERMO BARRERA SANCHEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('378', 'C-100378', '', 'CARMEN YNES DELGADO SERRATE', '9933200647', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('379', 'C-100379', '', 'MIRIAM DE AGUILAR', '9931777047', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('380', 'C-100380', '', 'JESUS ANTONIO RODRIGUEZ VAZQUEZ', '9141003892', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('381', 'C-100381', '', 'SANDRA MONTOYA ARIAS', '9931323235', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('382', 'C-100382', '', 'JULIA ETHEL MONTOLLA ARIAS', '9931323235', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('383', 'C-100383', '', 'IVAN PEDRERO PULIDO', '9933185706', '', '18/02/04 limpieza de acne rosy\r\n02/03/04 limpieza de acne yesy\r\n11/03/04 limpieza de acne consuelo\r\n17/03/04 limpieza de acne consuelo\r\n18/03/05 limpieza de acne mary lazaro\r\n27/ene/06 limpieza facial marcela\r\n15/junio/07 limpieza de acne mary lazaro entro 3:00\r\n11/abril/08 limpieza facial mary lazaro entro 5:15\r\n2/oct/09 limpieza facial y micro sara entro 4:25\r\n20/julio/10 micro lupita entro 5:10\r\n8/feb/11 micro punta de diamante mariana entro 5:26\r\n30/agosto/12 micro cristales sara entro 5:05\r\n13/sept/13 micro cristales ana entro 5:20\r\n13/03/12 micro atendio graciela entro 12.25 (mega)\r\n17/01/15 se realizo micro y limpieza de acne atendio susy cristal entro alas 2.00\r\n15/oct/15 micro reyna entro 6:00 llevo fluido exfoliante de puerexpert, crema no-estrés y espuma purificante de purexpert\r\n20/nov/15 micro reyna entro 3:40\r\n7/julio/17 micro cristales mariana entro 6:00\r\nLLEVO LOCION REPARADORA INTENSIVA (TONICO) DE THE CURE DE NATURA BISSÉ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('384', 'C-100384', '', 'JANETH DE LA CRUZ BAYONA', '9932101655', '', '28/ENERO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 12:10\r\n******************************DATOS DE FACTURACION*********************************\r\nJANET DE LA CRUZ BAYONA\r\nRFC: CUBJ8411065P9\r\nCALLE PRINCIPAL, EL HORMIGUERO\r\nNACAJUCA TABASCO  CP: 86220\r\nCORRERO: yetabayona@gmail.com\r\n4/FEB/2022 LIMPIEZA DE ACNE JHOANY ENTRO 12:10\r\n11/FEB/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 12:00\r\n18/FEB/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 12:10 LLEVO MASCARILLA PH5 Y HELIOCARE GEL\r\n7/MARZO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ARLETH ENTRO 12:20', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('385', 'C-100385', '', 'MARIA TERESA ENRIQUEZ  IBARRA', '9932199078', '', '24/11/03 limpieza facial consuelo\r\n13/12/03 limpieza facial tete\r\n13/01/04 limpieza facial lupita\r\n13/03/04 limpieza facial consuelo\r\n15/05/04 limpieza facial yesy\r\n24/06/04 limpieza facial rosy\r\n28/08/04 limpieza facial yesy\r\n19/11/04 limpieza facial lupita\r\n30/12/04 limpieza facial gladys\r\n02/04/05 limpieza facial mary lazaro\r\n28/05/05 limpieza facial yesy\r\n02/07/05 limpieza facial rosy\r\n26/07/05 limpieza facial gladys\r\n03/09/05 limpieza facial gladys\r\n29/09/05 limpieza facial marcela\r\n01/nov/05 limpieza facial rosy\r\n14/dic/05 limpieza facial reyna\r\n12/ene/06 limpieza facial yesy\r\n25/marzo/06 limpieza facial marcela\r\n06/mayo/06 limpieza facial ofelia\r\n17/junio/06 limpieza facial gladys\r\n15/julio/06 limpieza facial marcela\r\n30/sept/06 limpieza facial yesy entro 10:00\r\n11/nov/06 promocion antiarrugas reyna entro 10:10\r\n13/dic/06 limpieza facial tana \r\n10/feb/07 limpieza facial fanny entro 8:15\r\n19/marzo/07 limpieza facial lupita entro 9:05\r\n04/mayo/07 promocion antiarrugas y reafirmante marcela entro 4:35 salio 6:30\r\n llevo gel moussant espumoso\r\n29/junio/07 limpieza facial gladys entro 2:45\r\n14/julio/07 limpieza facial lucy entro 12:10\r\n15/sept/07 limpieza facial mary lazaro entro 11:40\r\n13/oct/07 limpieza facial mary lazaro entro 9:25\r\n14/dic/07 limpieza facial odet entro 4:30\r\n12/abril/08 limpieza facial gladys entro 11:45 \r\n7/junio/08 limpieza facial odet entro 11:50 \r\n2/julio/08 limpieza facial sara entro 4:30 \r\n9/agosto/08 limpieza facial sara entro 9:20 \r\n14/oct/08 limpieza facial rosy entro 4:35 salio 6:00 \r\n13/dic/08 limpieza facial julia entro 11:05 salio 12:20  \r\n28/feb/09 limpieza facial reyna entro 9:40 \r\n3/abril/09 promocion spa therapy oro bety entro 10:45\r\n30/mayo/09 limpieza facial mary lazaro entro 11:10 \r\n27/junio/09 promocion white line mary lazaro entro 12:20 \r\n5/sept/09 limpieza facial karina entro 9:25\r\n12/oct/09 promocion hidronutritivo reyna \r\n7/nov/09 limpieza facial reyna entro 10:30\r\n5/dic/09 limpieza facial gladys entro 9:25 \r\n1/feb/10 limpieza facial reyna entro 5:05\r\n9/marzo/10 promocion de cristal lucy entro 4:15\r\n5/mayo/10 promocion catiodermia sara entro 3:05 \r\n4/junio/10 limpieza facial karina entro 8:30\r\n10/julio/10 limpieza facial karina entro 9:15\r\n3/sept/10 promocion termico karina entro 5:40\r\n9/oct/10 promocion efecto botox araceli entro 9:45\r\n15/nov/10 limpieza facial marina entro 6:00\r\n9/feb/11 promocion trat. de seda karina entro 8:16 \r\n2/abril/11 promocion vinoterapia sara entro 11:50\r\n5/mayo/11 limpieza facial mariana entro 8:30\r\n27/mayo/11 llevo hydraserum gel de hidratacion intensa\r\n28/julio/11 limpieza facial susy entro 2:30\r\n10/sep/11 limpieza facial mariana entro 11:20\r\n26/11/11 limpieza facial atendio jhoany entro 11:05 (mega)\r\n4/feb/12 limpieza facial gladys entro 9:20\r\n19/marzo/12 promocion hidraderm mariana entro 4:00\r\n12/abril/12 promocion revitalizante karina\r\n2/junio/12 promocion reafirmante gladys entro 9:10\r\n28/julio/12 limpieza facial graciela entro 8:15\r\n8/sept/12 limpieza facial gladys entro 8:20\r\n14/marzo/13 promocion royal jelly ofelia entro 5:30\r\n13/junio/13 limpieza facial mariana entro 4:30\r\n12/sept/13 limpieza facial reyna entro 4:30\r\n22/nov/13 limpieza facial mariana entro 3:30\r\n01/julio/14 limpieza facial mariana entro 4:35\r\n11/nov/14 limpieza facial johany entro 4:40\r\n15/dic/14 tratamiento contorno de ojos timexpert lift, top ten cream cytokines \r\n26/agosto/15 promocion chocoterapia reyna entro 5:00\r\n4/nov/15 limpieza facial lucy entro 4:15\r\n30/sept/16 promocdion de coalgeno maria entro 4:15\r\n15/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA MARIANA ENTRO 4:15\r\n26/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD ANITA ENTRO 9:35\r\n29/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN MARY ENTRO 4:35\r\n11/OCT/19 PROMOCION DOBLE ACCION ANITA ENTRO 3:15\r\n9/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K ANITA ENTRO 3:55\r\n28/ABRIL/2022 PROM. TRATAMIENTO FACIAL CINETICO SUSI ENTRO 2:00\r\n30/JUNIO/2022PROM. TRATAMIENTO YOGA FACIAL LUCY ENTRO 3:05\r\n6/SEPT/2022 PROMOCION TRAT. PREVENTIVO DE MANCHAS MARIANA ENTRO 3:05\r\n21/NOVIEMBRE/2022 PROMOCION TRAT FACIAL REPARADOR FACIAL MARY LAZARO ENTRO 9:10\r\n7/ENERO/2023 PROMO TRATAMIENTO FACIAL PURIFICANTE MARIANA ENTRO 9:00\r\n19/ABRIL/2023 PROMO TRATAMIENTO FACIAL PLASMA MARINO JHOANY ENTRO 4:00\r\n22/MAYO/2023 LIMPIEZA FACIAL PROFUNDA ENTRO 3:15', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-20 15:42:23', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('386', 'C-100386', '', 'ROSELVY DOMINGUEZ AREVALO', '', '', '14/enero/16 MDM full relax susy entro 7:25 (cristal)\r\n16/enero/16 limpieza de acne con amp. desincrustante martha entro 10:10 (cristal)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('387', 'C-100387', '', 'CLAUDIA PAOLA VILLA REYES', '9933477922', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('388', 'C-100388', '', 'BLANCA GARCIA YA', '9932654838', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('389', 'C-100389', '', 'DENIS ALVAREZ ARMENTA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('390', 'C-100390', '', 'JUAN CARLOS OVANDO LEON', '9931963707', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2023-04-11 12:28:33', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('391', 'C-100391', '', 'FABIOLA BERMUDEZ ENCALADA', '9931503371', '', '25/febrero/16 limpieza facial 2x1 candy entro 5:05 (mega)\r\n27/ene/17 masaje en pies 2x400 susy entro 11:00\r\n1/DICIEMBRE/2020  MASAJE FULL RELAX 2X600 ANITA ENTRO 5:50\r\n5/DIC/2020 PROMOCION TRAT. PORCELANA OFELIA ENTRO 1:00 LLEVO PACK HYDRACURE (CREMA PIEL MIXTA, SERUM)\r\n28/SEPT/2021 INICIA TRATAMIENTO REDUCTIVO COSTO 3500.00 PAGADO\r\n1.- MASAJE 45 29/SEPT/2021  JHONY ENTRO 12:00\r\n2.- MASAJE 45 30/SEPT/2021 JHOANA ENTRO 4:00\r\n3.- MASAJE 45 1/OCTUBRE/2021 JHOANY ENTRO 10:00\r\n4.- MASAJE 45 4/OCTUBRE/2021 MARIANA ENTRO 3:00\r\n5.- MASAJE 45 5/OCTUBRE/2021 JHOANY ENTRO 11:50\r\n6.- MASAJE 45 6/OCTUBRE/2021 JHOANY ENTRO 12:00\r\n7.- MASAJE 45 7/OCT/2021 MIRENA ENTRO 12:00\r\n8.- MASAJE 45 18/OCTUBRE/2021 JHOANY ENTRO 12:05\r\n9.- MASAJE 45  20/OCTUBRE/2021 JHOANY ENTRO 12:00\r\n10.- MASAJE 45\r\n10/ENERO/2022 INICIA TRATAMIENTO REDUCTIVO COSTO 3500.00 PAGADO\r\n1.- MASAJE 45 10/ENERO/2022 ARLETH\r\n2.- MASAJE 45 11/ENERO/2022 ARLETH ENTRO 1:15 \r\n3.- MASAJE 45 12/ENERO/2022 ARLETH ENTRO 9:00\r\n4.- MASAJE 45 18/ENERO/2022 MIRENA ENTRO 1:00\r\n5.- MASAJE 45 20/ENERO/2022 MONICA ENTRO 1:00\r\n6.- MASAJE 45 21/ENERO/2022 MIRENA ENTRO 1:10\r\n7.-MASAJE 45 M 25/ENERO/2022 MIRENA ENTRO 1:20\r\n8.-MASAJE 45 M 2/FEB/2022 MIRENA ENTRO 1:10\r\n9.-MASAJE 45 M 4/FEB/2022 MIRENA ENTRO 1:15\r\n10.-MASAJE 45 M \r\n21/ENERO/2022 TRATAMIENTO FACIAL DIAMOND LIFT INFUSION OFELIA ENTRO 2:10\r\n27/OCTUBRE/2022 MASAJE FULL RELAX 2X600 MARIANA ENTRO 5:50\r\n31/OCTUBRE/2022 INICIA TRATAMIENTO REDUCTIVO COSTO 4,000.00 PAGADO\r\n1.- MASAJE 45 M 31/OCTUBRE/2022 MARIANA \r\n2.- MASAJE 45 M 1/NOV/2022 MARIANA ENTRO 9:10\r\n3.-MASAJE 45 M 4/NOV/2022 MARIANA ENTRO 9:00\r\n4.- MASAJE 45 M  7/NOVIEMBRE/2022  MARIANA ENTRO 10:00\r\n5.-MASAJE 45 M 9/NOV/2022 MARIANA ENTRO 12:10\r\n6.-MASAJE 45 M 10/NOVIEMBRE/2022 MARIANA ENTRO 12:10\r\n7.- MASAJE 45M\r\n8.- MASAJE 45M\r\n9.- MASAJE 45M\r\n10.- MASAJE 45M\r\n****************28/ABRIL/2023 SE ROMPIO EXPEDIENTE******************\r\n19/MAYO/2023 TRATAMIENTO FACIAL VITAMINA C DE NATURA BISSE SRA. BEGO ENTRO 12:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-19 14:15:32', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('392', 'C-100392', '', 'MANUEL MARTINEZ JIMENEZ', '9371234874', '', '16/ENERO/2023 LIMPIEZA FACIAL ARIANA ENTRO 11:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-14 14:37:01', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('393', 'C-100393', '', 'GUADALUPE LIEVANO MORALES', '9931292431', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('394', 'C-100394', '', 'ROSARIO VASTO QUIROZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('395', 'C-100395', '', 'BERTA MARINA CIPAGAUTA BEJARANO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('396', 'C-100396', '', 'MARIA FERNANDA VIVEROS TORQUINO', '9932420916', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('397', 'C-100397', '', 'AMALIA RAMOS LOPEZ', '9932878426', '', '9/feb/11 limpieza facial 2 x 1 karina entro 11:19 \r\n29/junio/11 limpieza facial 2 x 1 reyna entro 4:00\r\n28/03/12 limp facial 2x1 atendio brenda entro 4.05 (mega) con amp equilibrante\r\n12/09/12 lim. facial 2x1 atendio jenifer entro 7:00 mega\r\n20/12/12 lim. facial 2x1 atendio brenda entro 6:20 mega\r\n19/03/13 lim. facial 2x1 atendio bety entro 2:55 mega \r\n27/03/14 lim facial jhoany mega 4:50 firmo autorizacion para eser extraccion profunda\r\n11/03/15 limpieza facial 2x1  atendio maribel entro 5.15mega\r\n29/octubre/15 limpieza facial 2x1 maribel entro 3:00 (mega)\r\n14/diciembre/16 limpieza facial 2x600 maria entro 5:15 (mega)+\r\n18/marzo/17 limpieza facial 2x600 candy entro 11:05 (mega)\r\n05/mayo/17 mdm full relax 2x600 candy entro 5:50 (mega)\r\n12/mayo/17 masaje express candy entro 3:55 (mega)\r\n20/agosto/17 limpieza facial 2x600 candy entro 4:00 (mega)\r\n05/noviembre/17 mdm full relax  2x600 candy entro 1:05 (mega)\r\n11/enero/18 limpieza facial 2x600 candy entro 11:15 (mega)\r\n23/febrero/18 limpieza facial 2x600 monica entro 2:10 (mega)\r\n11/abril/18  limpieza facial 2x600 monica entro 3.10 (mega)\r\n25/julio/18 limpieza facial susy entro 11:10 (mega)\r\n19/DIC/18 LIMPIEZA FACIAL  KARLA ENTRO 11:00\r\n20/MARZO/19 LIMPIEZA FACIAL 2 X 600 ANITA ENTRO 3:00\r\n22/junio/19 mdm full relax 2x600 carmen entro 6:10 mega\r\n16/DICIEMBRE/19 FULL RELAX Y LIMPIEZA FACIAL SUSI ENTRO 1:00 MEGA\r\n23/OCTUBRE/2020 MASAJE FULL RELAX MIRENA ENTRO 2:55+\r\n28/AGOSTO/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 ROSI ENTRO 12:55 MEGA\r\n08/NOV/2021 LIMPIEZA FACIAL MONICA ENTRO 17:00 MEGA\r\n23/JUNIO/2022 LIMPIEZA FACIAL BASICA ROSI ENTRO 5:58 (MEGA) \r\n03/ NOVIEMBRE /2022 MASAJE RELAJANTE EN PROMOCION DE PERSONAL MAS AMPOLLETA DESINCRUSTANTE MONICA ENTRO 3:05 (MEGA)\r\n19/ NOVIEMBRE/2022 MASAJE HOLISTICO ROSY ENTRO 3:50 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-11-19 14:59:50', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('398', 'C-100398', '', 'MARIA DEL CARMEN LOPEZ VIDAL', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('399', 'C-100399', '', 'KARINA ARELLANO IZAZAGA', '9932670561', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('400', 'C-100400', '', 'EMILIO RENE MACARIO ALVAREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('401', 'C-100401', '', 'MARTHA LAURA LAMAS COUTIÑO', '9931689549', '', '18/agosto/15 planchado de cejas y limpieza facial con amp. desincrustante nely 9:20\r\n16/dic/15 planchado de cejas y promocion reafirmante modeladora lucy entro 2:00\r\n30/dic/15 limpieza facial 2x500 y dep de cejas  lucy entro 9:10\r\n30/ene/16 promocion desintox signate y planchado de cejas lucy entro 10:20\r\n15/marzo/16 limpieza facial y planchado de cejas mary lazaro entro 10:15\r\n15/marzo/16 llevo tonico ceutical de natura bisse\r\n1/junio/16 limpieza facial y planchado de cejas lucy entro 10:10\r\n28/dic/16 promocion trat multivitaminico mary lazaro entro 10:00\r\n6/abril/17 limpieza de acne con amp. desincrustante jennifer entro 9:45\r\n9/junio/17 limpieza de acne con amp. desincrustante andrea entro 9:15\r\n21/julio/17 limpieza facial con amp. desincrustante yeni ntro 11:00\r\n15/nov/17 promocion termico-humectante anita entro 9:00\r\n27/12/17 PROMOCION TRATAMIENTO GOLD MARIANA ENTRO 10:00\r\n3/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE LUCY ENTRO 5:45\r\n15/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE, DEPILACION DE PATILLAS Y DE CEJAS MARY ENTRO 8:30\r\n15/DIC/18 CREMA TIMEXPERT LIFT IN\r\n5/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE Y DEPILACION DE CEJAS REYNA ENTRO 10:10\r\n2/MAYO/19 PROMOCION EFECTO BOTOX, DEPILACION DE CEJAS CON PINZA Y CERA REYNA ENTRO 9:00\r\n18/SEPT/19 PROMOCION OXIGENANTE MARY CARMEN ENTRO 10:25\r\n7/FEB/2022 PROMOCION TRAT AGE DEFENSE JHOANY ENTRO 10:00\r\n13/JULIO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ARIANA ENTRO 9:00\r\n26/SEPT/2022 PROMOCION TRAT. PREVENTIVO DE MANCHAS ARIANA ENTRO 9:10\r\n16/NOVIEMBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 9:20\r\n21/DICIEMBRE/2022 LIMNPIEZA FACIAL ARIANA ENTRO 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-07 16:32:07', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('402', 'C-100402', '', 'URIEL GUILLERMO RUIZ  LAMAS', '19143360119', '', '30/dic/15 limpieza facial mariana entro 9:10\r\n01/MARZO/18 LIMPIEZA FACIAL 2 X 600 REYNA 6:30\r\n19/JULIO/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MONICA\r\n21/DICIEMBRE  LIMPIEZA FACIAL  JHOANY ENTRO 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-20 19:00:54', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('403', 'C-100403', '', 'AIDE GAUDIANO ROVIROSA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('404', 'C-100404', '', 'VICTOR GUTIERREZ NOTARIO', '9933114267', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('405', 'C-100405', '', 'MARISOL MU', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('406', 'C-100406', '', 'IVONNE ROMERO ', '9931669316', '', '02/abril/16 dep. cadera andrea entro 5:30 (mega)\r\n11/NOVIEMBRE/19 MDM FULL RELAX Y LIMPIEZA FACIAL SANDY ENTRO 9:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('407', 'C-100407', '', 'DANIELA PATRICIA JIMENEZ GOMEZ', '', '', '24/OCTUBRE/2022 LIMPIEZA DE ACNE 2X600 ARIANA ENTRO 6:05', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-24 16:20:46', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('408', 'C-100408', '', 'JOSE MANUEL RAMIREZ CALDERON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('409', 'C-100409', '', 'ADRIANA BEATRIZ GOMEZ PEREZ', '9935900263-3534018', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('410', 'C-100410', '', 'AMANDA MORALES BURELO', '9935900998', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('411', 'C-100411', '', 'DIANA ALEJANDRA MARTINEZ CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('412', 'C-100412', '', 'ROSITA ESCALANTE OROPEZA', '9371168674', '', '26/DIC/18 LIMPIEZA FACIAL 2 X 600 KARLA ENTRO 4:30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('413', 'C-100413', '', 'JUANA MARIA FALCONI', '9333345260', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('414', 'C-100414', '', 'ADRIANA OROPEZA HERNANDEZ', '9371168674', '', '26/DIC/18 LIMPIEZA FACIAL 2 X 600 MARY ENTRO 4:30\r\n30/ENE/19 LIMPIEZA FACIAL 2X600 ROSY ENTRO 11:50 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('415', 'C-100415', '', 'ADRIANA CAMPOS LEON', '9931666278', '', '17/sept/15 promocion equilibrante del ph graciela entro 12:15\r\n6/ene/16 promocion desintoxicante con amp. de colageno de germaine candy entro 1:45\r\n21/ene/16 promocion desintoxicante maria entro 1:10\r\n10/feb/16 promocion roll & lift charito entro 2:10\r\n12/marzo/16 promocion hydrtante charito entro 12.30\r\n6/mayo/16 promocion masaje holistico y facial con lifting #2 carmen entro 10:25\r\n15/junio/16 promocidon de colageno anita entro 3:45\r\n8/agosto/16 promoción de caviar mariana entro 10:45\r\n15/sept/16 promoción de colageno anita entro 1:15\r\n26/nov/16 promocion oxigenante mirena entro 2:15\r\n22/dic/16 promocion multivitaminico ofelia entro 10:15\r\n27/dic/16 mdm full relax cliente frecuente ofelia entro 9:10\r\n28/junio/17 promocion antioxidante monica entro 5:00\r\n18/oct/17 promocion reafirmante ofelia entro 3:55\r\n24/nov/17 promocion termico humectante anita entro 12:55\r\n7/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE LUPITA ENTRO 11:15\r\n28/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE ANITA ENTRO 10:20\r\n20/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE Y MDM COMBO REYNA\r\n17/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN CHARITO\r\n10/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE MONICA ENTRO  12:40\r\n18/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE REYNA ENTRO 3:15\r\n4/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION ALEGRIA ENTRO 3:00\r\n18/DIC/19 PROMOCION TRAT 24 K MARY LAZARO ENTRO 11:05\r\n11/FEB/2020 PROMOCION TRAT 4 F LUPITA ENTRO 12:00\r\n30/AGOSTO/2021 INICIA TRATAMIENTO REDUCTIVO COMPLETO COSTO 10,000.00\r\n1.- CAVITACION Y MASAJE 45  30/AGOSTO/2021 ARLETH ENTRO 4:20\r\n2.- MASAJE 45 Y TERMO  31/AGOSTO/2021 ARLETH ENTRO 4:20 \r\n3.- MASAJE 45 Y CAPSULA 1/SEPT/2021 ARLETH ENTRO 4:00\r\n4.- MASAJE 45 Y CORPO  2/SEPT/2021 ARLETH ENTRO 4:00\r\n5.- LASER LIPOLITICO, MASAJE, VC 30 3/SEPT/2021 ARLETH ENTRO 4:25\r\n6.- MASAJE 45, G-5, VF 45M 6/SEPT/2021 ARLETH ENTRO 4:15\r\n7.- MASAJE 45, TERMO 7/SEPT/2021 ARLETH ENTRO 4:10\r\n8.- MASAJE 45 Y CAPSULA 8/SEPT/2021 ARLETH ENTRO 4:23 \r\n9.- MASAJE 45 Y VF 13/SEPT/2021 ARLETH ENTRO 4:10\r\n10.- MASAJE 45 Y CRIOPTERAPIA 40M 14/SEPT/2021 ARLETH\r\n14/SEPT/2021 TERMINO TRATAMIENTO OMBLIGO 83 cm-78KG \r\n30/AGOSTO/2021 8 DISPAROS DE LIPOSONIX ARLETH ENTRO 4:20 \r\n3/SEPT/2021 LIMPIEZA FACIAL CON AMP 350.00 ARLETH ENTRO 4:25\r\n6/DICIEMBRE/2021 MASAJE SENSORELAX ARLETH ENTRO 3:15\r\n17/SEPTIEMBRE FULL RELAX MONICO ENTRO 3:10 (MEGA)\r\n17/OCTUBRE/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA CON AMP. DESINCRUSTANTE MARIANA ENTRO 12:15\r\n10/NOVIEMBRE/2022 PROMOCION TRAT. FACIAL REPARACION CELULAR CON AMP. DESINCRUSTANTE ARIANA ENTRO 11:00\r\n03/ DICIEMBRE/2022 PROMOCION DEL MES TRATAMIENTO GOLDEN ROSY ENTRO 9:50 (MEGA)\r\n15/DICIEMBRE/2022 PROMOCION TRAT. FACIAL GOLDEN MARIANA ENTRO 3:15\r\n28/ DICIEMBRE/2022 PROMOION DEL MES TRATAMIENTO FACIAL GOLDEN  MAS AMPOLLETA DESINCRUSTANTE ROSY ENTRO6:55 (MEGA)\r\n16/ENERO/2023 LASER DE CARBONO CON AMP CASMARA ACLARADORA  MARIANA ENTRO 3:25\r\n2/MAYO/2023 PROMOCION TRAT. FACIAL MAGIC FACE CON AMP. DESINCRUSTANTE KARLA ENTRO 5:30\r\n11/JULIO/2023 PROMOCION TRAT. COOPING FACIAL KARLA ENTRO 9:20', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-11 11:46:44', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('416', 'C-100416', '', 'MARIANA PONCE PASTRANA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('417', 'C-100417', '', 'OLIVIA AZCONA PRIEGO', '9931360288', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('418', 'C-100418', '', 'MARIA ANTONIA MENA ESPA', '9373726540', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('419', 'C-100419', '', 'JULIETA VARGAS CALVILLO', '9931607335', '', '14/dic/15 masaje ful relax y limpieza facial fernanda entro 11:20\r\n21/abril/17 promocion termico charito entro 12:00\r\n03/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO LUCY ENTRO 1:00\r\n5/FEB/18 MDM FULL RELAX 2X600 MARIANA ENTRO 1:10\r\n15/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD  LUCY\r\n20/SEPT/19 PROMOCION OXIGENANTE, SE LE APLICO AMP. BEAUTE I OFELIA ENTRO 11:00\r\n26/MAYO/2021 PREOM. TRATAMIENTO FACIAL CELULAS MADRE ANITA ENTRO 11:00\r\n11/JULIO/2023 LIMPIEZA FACIAL JHOANY ENTRO 1:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-11 14:07:55', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('420', 'C-100420', '', 'ANA ELENA SETZER MENDOZA', '9931601658', '', '26/JULIO/2021 LIMPIEZA FACIAL 2X600 MARIANA ENTRO 12:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('421', 'C-100421', '', 'NANCY FOSTER MARTINEZ', '9931561830', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('422', 'C-100422', '', 'JUAN CARLOS CAZARES GONZALEZ', '9931161077', '', '13/DIC/2021 MASAJE DESCONTRACTURANTE ANITA ENTRO 15:15 MEGA\r\n22/ENE/2022 RADIO FRECUENCIA FACIAL ROSI ENTRO 16:05 MEGA\r\n27/ENE/2022 RADIOFRECUENCIA FACIAL ROSI ENTRO 14:30 MEGA\r\n02/FEB/2022 RADIOFRECUENCIA FACIAL ROSI ENTRO 14:30 MEGA\r\n11/FEB/2022 RADIOFRECUENCIA FACIAL ROSI ENTRO 14:20 MEGA\r\n16/FEB/2022 RADIOFRECUENCIA FACIAL ROSI ENTRO 14:20 MEGA\r\n23/FEB/2022 RADIOFRECUENCIA FACIAL ROSI ENTRO 14:00 MEGA NO QUISO MASCARILLA NI MANOS NI PIES NO SOPORTABA EL CALOR* NO HAY CLIMA*\r\n02/MARZO/2022 RADIOFRECUENCIA FACIAL ROSI ENTRO 14:28 MEGA no quiso mascarilla, ni manos, ni pies.\r\n04/ ENERO/2023  LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE ROSY ENTRO 7.20 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-04 15:08:11', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('423', 'C-100423', '', 'ERICKA CARRERA ORTIZ', '9931971518', '', 'depilacion laser en candado $360.00 c/s brasileña $450.00 c/s axila $360.00\r\n5/nov/14 1ra. candado 30 ms 11 j, brasileña 30 ms 11 j, axila 30 ms 12 j mas abajo 400 ms reyna\r\nINICIA CAVITACION Y MASAJE $4000.00 PAGADO CON MEDIDAS EN \r\nA-106,113.C-110. CA-121, CB-122, BR-57, M-81 Y PESO 93 1/2KG\r\n1.-CAVITACION 60M ,MASAJE 45M 29/sept/15 fernanda entro 4:35\r\n2.-CABO, MASAJE 45m  30/sept/15 fernanda entro 9:50\r\n3.-MASAJE 45M  01/oct/15  fernanda entro 9:40\r\n4.-.-CAVITACION 60M, MASAJE 45M 2/oct/15 fernanda entro 9:30\r\n5-CARBO, MASAJE 45M 6/oct/15 fernanda entro 11:00\r\n6.-MASAJE 45M 7/oct/15 fernanda entro 4:05\r\n7.-CAVITACION 60M ,MASAJE 45M 8/oct/15 fernanda entro 12:10\r\n8.-CARBO, MASAJE 45M 9/oct/15 fernanda entro 9:50\r\n9.-MASAJE 45M 12/oct/15 fernanda entro 10:10\r\n10.-CAVITACION 60M ,MASAJE 45M 13/oct/15 fernanda entro 11.00\r\ntermino el tratamiento con medida en a-103, b-113,c-100, ca-111. cb-120, br-54, m-76 y peso 93kg.', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('424', 'C-100424', '', 'MARIA FERNANDA SALA CASTILLO', '9931179417', '', '19/NOV/2020 LIMPIEZA DE ACNE ARLETH ENTRO 10:10\r\n26/NOV/2020 LIMPIEZA DE ACNE MIRENA\r\n###########################################################################\r\n26/NOV/2020 LLEVO PRODUCTOS\r\nGEL DESMAQUILLANTE EQUILIBRANTE PIEL GRASA\r\nROLL-ON SPOT S.O.S PUREXPERT\r\nLOCION PURIFICANTE EQUILIBRANTE PIEL GRASA\r\nGEL-CREMA HIDRO-MATIFICANTE PUREXPERT\r\nSERUM PUREXPERT\r\n###########################################################################\r\n3/DICIEMBRE/2020 LIMPIEZA DE ACNE MONICA ENTRO 11:00\r\n28/DIC/2020 LIMPIEZA DE ACNE MARY LAZARO ENTRO 11:00\r\n16/FEB/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE OFELIA ENTRO 9:55\r\n9/MARZO/2021 PROMOCION TRAT. ACIDO HIALURONICO MARIANA ENTRO 10:00\r\n11/JUNIO/2021 LIMPIEZA FACIAL MARIANA ENTRO 9:05\r\n21/JUNIO/2021 PROM. TRATAMIENTO FACIAL RETINOL MARY LAZARO ENTRO 1:00\r\n23/JULIO/2021 PROMOCION DE CAVIAR Y ORO LUCY ENTRO 12:00\r\n22/SEPT/2021 PROM. TRATAMIENTO FACIAL ISOFLAVONAS DE SOYA ARLETH ENTRO 9:50\r\n12/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD MARIANA ENTRO \r\n3:50\r\n7/DIC/2021 PROMOCION TRAT FACE PURE JHOANY ENTRO 11:15\r\n17/FEB/2022 PROMOCION TRAT AGE DEFENSE MIRENA ENTRO 1:00\r\n21/FEBRERO/2022****************HACER LA EXTRACCION MAS SUAVE********************\r\n10/MARZO/2022 PROM. TRATAMIENTO FACIAL SCHOK DE COLAGENO ARLETH ENTRO 1:20\r\n18/MAYO/2022 PROMOCION TRAT FITO HIDRATANTE MARIANA ENTRO 11:00\r\n19/JULIO/2022 PROMOCION TRAT ROLL & LIFT JHOANY ENTRO 12:30\r\n13/SEPT/2022 PROMOCION TRAT. PREVENTIVO DE MANCHAS CRISTINA ENTRO 12:00\r\n11/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA ARIANA ENTRO 1:0\r\n14/OCTUBRE/2022 PROMOCION DE VIERNES PACK TRATAMIENTO MICRODERMAOBRASION CON LED ANTIEDAD ROSY ENTRO 4.00 (MEGA)\r\n11/ NOVIEMBRE/2022 PACK TRATAMIENTO MICRODERMOABRASION CON LED ROSY ENTRO 10:50 (MEGA)\r\n******LA SEÑORITA DIJO QUE EL GLYCOCELL NO LE ARDIO COMO OTRAS VECES SELE DEJO 5 MINUTOS Y NO SINTIO QUE LE ARDIARA*****\r\n16/DICIEMBRE/2022 PROMOCION TRAT. FACIAL GOLDEN MARY LAZARO ENTRO 11:15\r\n11/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE ARIANA ENTRO 12:10\r\n18/ENERO/2023 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ARIANA ENTRO 11:20\r\n////////////////////////////////////////////////////////////////////////////////////////////\r\n        LLEVO PRODUCTOS 18/ENERO/2023\r\n** SERUM SHINE CONTROL DE CASMARA\r\n** CREMA HIDRATANTE NO ESTRES PUREXPERT\r\n** GEL DESMAQUILLANTE EQUILIBRANTE PIEL GRASA\r\n** LOCION TONIFICANTE PIEL SECA\r\n//////////////////////////////////////////////////////////////////////////////////////////////\r\n15/ FEBRERO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL ELIXIR DE JUVENTUD SUSY ENTRO 6:10 (MEGA)\r\n29/MARZO/2023 PROMOCION DEL MES TRATAMIENTO MICRODERMA ANTI EDAD ROSY ENTRO 6:15 (MEGA)\r\n19/MAYO/2023 PROMOCION TRAT. FACIAL MAGIC FACE KARLA ENTRO 12:00\r\n20/JUNIO/2023 DUO MASAJE KARLA Y LIMPIEZA FACIAL MARIFER ENTRO 10:05 VALE DE REGALO\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-19 17:21:56', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('425', 'C-100425', '', 'DENISE MORALES VIDAL', '9933995186', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('426', 'C-100426', '', 'RENE ESPINOZA MENDEZ', '9932074922', '', '5/nov/14 mdm descontracturante jhoany entro 12:05\r\n6/nov/14 mdm drenaje linfatico brenda entro 12:35\r\n7/nov/14 mdm descontracturante jhoany entro 12:00\r\n11/nov/14  mdm descontracturante carmen entro 11:00\r\n12/dic/14 mdm descontracturante jhoany entro 5:15\r\n12/dic/14 reflexologia podal jhoany entro 5:15\r\n18/dic/14 mdm descontracturante jhoany entro 11:00\r\n23/ene/15 mdm full relax candy entro 7:07 (mega)\r\n4/junio/15 mdm quirogolf mirena entro 9:00 salio 10:25 (spa altozano)\r\n5/junio/15 mdm quirogolf mirena entro 9:25 salio 11:45 (spa altozano)\r\n6/junio/15 masaje de espalda mirena entro 12:30 salio 1:05 (spa altozano)\r\n9/agos/15 mdm quirogolf nely entro 11:40\r\n19/agosto/15 mdm full relax (cliente frecuente) nely entro 11:30\r\n22/agosto/15 mdm full relax nely entro 1:20\r\n4/sept/15 mdm full relax nely entro 6:00\r\n9/sept/15 mdm full relax nely entro 5:50\r\n13/sept/15 masaje de espalda nely entro 10:40\r\n14/sept/15 masaje de espalda nely entro 9:05\r\n24/enero/16 mdm full relax nelly entro 10:00 (altozano)\r\n1/FEBRERO/2016/ MDM full relax nelly entro 11:00 altozano\r\n05/febrero/2016/ se realizo mdm full relax atendio nelly entro 10:30 altozano\r\n08/febrero/2016/mdm fuul relax (cliente frecuente ) atendio nelly entro 11:55 altozano\r\n25/febrero/2016/ mdm de espalda entro 5:40 atendio nelly  altozano\r\n28/febrero/2016 mdm espalda atendio nelly entro 3:40 altozano\r\n06/marzo/2016/ mdm espalda atenio nelly entro 1:10 altozano \r\n11/marzo/2016/prom del mes y  full relax atendio nelly entro 10:00 altozano\r\n13/marzo/2016 mdm de espalda atendio nelly entro 9:00 altozano\r\n17/ marzo/2016/ full relax atendio nelly entro 10:30 altozano\r\n19/marzo 2016/ full relax atendio nelly entro 11:00 altozano\r\n30/ marzo/2016 full relax atendio nelly entro 10:30 altozano.\r\n06/ abril/2016 full relax atendio nelly entro 11:45 altozano\r\n08/ abril/2016 mdm espalda atendio nelly  entro 10:30 altozano\r\n10/abril/2016 full relax de cliente frecuente atendio nelly entro 12:10 altozano\r\n14/abril/2016 fullrelax atendio nelly entro 10:00 (altozano)\r\n18/ abril/2016 mdm espalda atendio nelly  entro 9:30 altozano\r\n21/abril/2016 mdm de espalda atendio nelly entro 11.45 (altozano)\r\n22/ abril/2016 mdm de espalda  atendio nelly entro10:20 (altozano)\r\n25/abril/2016 full relax atendio nelly entro 11:00 (altozano)\r\n29/ abril /2016 masaje de espalda atendio nelly entro 11:35 altozano\r\n1/mayo/16 mdm full relax carmen entro 10:40 altozano\r\n4/mayo/2016 fullrelax atendio nelly entro 10:30 altozano\r\n06/mayo/2016 full relax atendio nelly entro 11:15 altozano\r\n09/ mayo/2016 mdm de espalda atendio nelly entro 11:15 altozano\r\n13/mayo/2016 mdm de cliente frecuente atendio nelly entro 5:00 altozano\r\n16/mayo/2016 full relax atendio nelly entro 11:30 altozano\r\n25/ mayo/2016 full relax atendio nelly entro 10:20 altozano\r\n27/mayo/2016 /mdm espaldaa atendio nelly entro 10:40 altozano\r\n28/mayo/2016 mdm de espalda atendio nelly entro 12:45 altozano\r\n30/mayo/2016 mdm de espalda atendio nelly entro 10:15 altozano\r\n1/junio/2016 full relax atendio nelly entro 11:30 altozano\r\n4/junio /2016 mdm espalda atendio nelly entro 12:00 altozano.\r\n6/junio/2016 full relax atendio nelly entro 10:50 altozano\r\n12/junio/2016 full relax atendio nelly entro 11:45 altozano\r\n15/junio/2016 mdm de espalda atendio nelly entro 11:20 altozano\r\n18/junio /2016 mdm de cliente frecuente atendio nelly entro 12:00 altozano\r\n22/junio/2016 mdm espalda atendió nelli entro 10:30 altozano\r\n29/06/2016 mdm espalda atendio nelli entro 3:30 altozano\r\n2/julio/16 mdm quirogolf mirena entro 12:20\r\n9/julio/2016 MDM Espalda Atendió Carmen Entro 1:45 (Altozano) \r\n28/julio/16 mdm full relax mirena entro 12:25\r\n17/agosto/16 mdm full relax mariana entro 11:25\r\n25/agosto/16 masaje fullr elax mirena entro 12:45\r\n23/MARZO/2022 FACIAL VITAMINA C RADIANCE OFELIA ENTRO 4:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('427', 'C-100427', '', 'FERNANDO FAUSTINO MENDOZA HURTADO', '9371209156', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('428', 'C-100428', '', 'VIVIANA PRIETO ZACARIAS', '9932323499', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('429', 'C-100429', '', 'VICTORIA CAZANOVA LASTRA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('430', 'C-100430', '', 'GRACIELA CONTRERAS FERNANDEZ', '9933119032', '', '14/agosto/18 mdm full relax y limpieza facial susy entro 6:05 (mega)\r\n20/julio/19 promocion del mes tratamiento de colageno hidrolizado alex entro 6:05 mega\r\n01/septiembre/19 mdm full relax y limpieza facial 2x600 janeth entro 6.05 mega\r\n3/NOVIEMBRE/19 MASAJE COMBO LUPITA ENTRO 6:00 MEGA\r\n21/NOVIEMBRE/2020 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 ROSITA ENTRO 4:55\r\n2/DICIEMBRE/2021 RADIOFRECUENCIA FACIAL MARIANA ENTRO 10:50\r\n7/DICIEMBRE/2021 RADIOFRECUENCIA FACIAL MARIANAENTRO 1: 50\r\n30/DIC/2021 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 3:20\r\n7/ENERO/2022 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 5:00\r\n4/MARZO/2022 RADIOFRECUENCIA FACIAL MIRENA ENTRO 10:00\r\n20/JUNIO/2022 DERMOSONIC MARIANA ENTRO 11:15\r\n5/OCTUBRE/2022 INICIA TRATAMIENTO DE CELULITIS COSTO 12,000.00\r\n1.- DERMOSONIC 5/OCTUBRE/2022 MARIANA ENTRO 10:55\r\n2.- CORPO 6/OCTUBRE/2022 LUCY ENTRO 12:00\r\n3.- VACUN 30M VF 30M 7/OCTUBRE/2022 MARIANA ENTRO 11:00\r\n4.- DERMOSONIC 10/OCTUBRE/2022 MARIANA ENTRO 11:00\r\n5.- LUMICELL 12/OCTUBRE/2022 MARIANA ENTRO 11:00\r\n6.- VACUN 30M, VF 30M 13/OCTUBRE/2022 MARIANA ENTRO 12:00\r\n7.- DERMOSONIC 14/OCTUBRE/2022 MARIANA ENTRO 12:15\r\n8.- LUMICELL 17/OCTUBRE/2022 MARIANA ENTRO 12:00\r\n9.-VACUNTERAPIA 18/OCTUBRE/2022 MARY LAZARO ENTRO 12:00 NO SE LE PUSIERON LAS VENDAS PORQUE IBA POR SUS HIJOS.\r\n10.- DERMOSONIC 19/OCTUBRE/2022 MARIANA\r\n11.-LUMICELL 24/OCT/2022 MARIANA\r\n12.-VACUM 30 M, V F 30 M 9/NOVIEMBRE/2022 MARIANA\r\n13.-DERMOSONIC \r\n14.-LUMICELL 10/NOVIEMBRE/2022 MARIANA ENTRO 11:00\r\n15.-VACUM 30 M, V F 30 M 14/NOV/2022 MARIANA ENTRO 11:05\r\n16.-DERMOSONIC 15/NOVIEMBRE/2022 MARIANA ENTRO 11:15\r\n17.-LUMICELL 28/NOVIEMBRE/2022 MARIANA ENTRO 11:00\r\n18.-VACUM 30 M, V F 30 M 29/NOVIEMBRE/2022 MARIANA ENTRO 11:10\r\n19.-DERMOSONIC\r\n20.-LUMICELL\r\n**************28/ABRIL/2023 SE ROMPIO EXPEDIENTE******************\r\n20/ FEBRERO/2023 MASAJE FULL RELAX ROSY ENTRO 4:55 (MEGA)\r\n21/MARZO/2023 TRATAMIENTO V-MAX LUCY ENTRO 10:00\r\n29/MARZO/2023 MASAJE SENSORELAX MONICA ENTRO 11:03 (MEGA)\r\n31/MAYO/2023 MASAJE FULL RELAX MONICA ENTRO 11:00 (MEGA)\r\n27/JUNIO/2023 MASAJE FULL RELAX ANI ENTRO 12:00\r\n4/JULIO/2023 MASAJE FULL RELAX JANETH ENTRO 9:45', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-04 13:47:09', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('431', 'C-100431', '', 'LUIS ALBERTO MARCIAL', '9931497266', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('432', 'C-100432', '', 'DANIELA BECERRIL LEMUS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('433', 'C-100433', '', 'EUNICE CERINO JAVIER', '9931473021', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('434', 'C-100434', '', 'NAIVIS GUTIERREZ ORAMAS', '9932221611', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('435', 'C-100435', '', 'LILI NAYELI VALENZUELA ROMERO', '9331181483/9932435672', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('436', 'C-100436', '', 'JAZIVE KIRAN GARCIA', '9933345324', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('437', 'C-100437', '', 'CELIA ANDRADE DELGADO', '4423360088', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('438', 'C-100438', '', 'GUADALUPE ZURITA BARRAGAN', '9932073125', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('439', 'C-100439', '', 'BARBARA HERRERA ROMERO', '5548702942', '', 'CONTINUIDAD (LE MARCO UN PROGRAMA LA SRA. BEGO)\r\n29/junio/16 new lift ofelia entro 11:25\r\n2.-RADIOFRECUENCIA FACIAL\r\n3.-SKINLIGHT \r\n4.-DESAFIO ANTIEDAD\r\n5.-VITAMINA C NB\r\n6.-FACIAL AQUA NB\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('440', 'C-100440', '', 'ALMA ROMO RODRIGUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('441', 'C-100441', '', 'LENIA PATRICIA DE LA FUENTE', '9932932581', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('442', 'C-100442', '', 'ALFREDO FLORES RANJEL', '7821133740', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('443', 'C-100443', '', 'LUIS EMILIO HERNANDEZ', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2022-12-17 14:00:49', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('444', 'C-100444', '', 'ARACELY FERNANDEZ DE LARA VADILLO', '9933156657', '', '9/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE ANITA ENTRO 12:00\r\n11/ABRIL/18 MDM DRENAJE LINFATICO REYNA ENTRO 12:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('445', 'C-100445', '', 'BERNI MENDEZ PEREZ', '9932399717', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('446', 'C-100446', '', 'YUCLEXI BENAVIDEZ BERMUDEZ', '7821428418', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('447', 'C-100447', '', 'PRISILA GARCIA MARTINEZ', '9933069004', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('448', 'C-100448', '', 'VICTOR OCTAVIO SANCHEZ CRUZ', '9372826741', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('449', 'C-100449', '', 'KAREN JIMENEZ JEREZ', '9933608788', '', '8/ febrero/2011 limpieza facial 2x1 atendio indira entro 2:35 salio 3:45 sucursal\r\n11/feb/11 depilacion de cejas rosy entro 11:53\r\n8/feb/12 limpieza facial 2 x 1 mariana entro 4:20\r\n28/marzo/12 limpieza facial 2 x 1 gladys entro 9:00\r\n16/julio/2012 masaje relajante 2x1 karina entro 3:30\r\n25/oct/12 depilacion de cejas mariana\r\n9/nov/12 depilacion de cejas lucy entro 11:00\r\n15/mayo/13 limpieza facial, depilacion de bigote mariana entro 2:25\r\n25/sept/13 limpieza facial 2 x 1 reyna entro 12:10\r\n29/01/14 lim facial 2x1 atendio anita mega entro 1:10\r\n19-02-15 lim f y msj 2x1 atendio graciela  entro 2-05.\r\n21/noviembre/15 mdm full relax 2x1 rosy entro 4:00 (mega)\r\n30/nov/15 mdm full relax, limpieza facial 2x500 candy entro 4:30\r\n7/dic/15 masaje full relax lizvet entro 4:30\r\n14/dic/15 masaje full relax candy entro 4:15\r\n24/julio/16 mdm holistico 2x600 lizbeth entro 12:15 (mega)\r\n26/julio/16 mdm holistico 2x600 charito entro 11:15 (mega)\r\n27/julio/16 mdm holistico 2x600 andrea entro 7:25 (mega)\r\n9/agosto/16 depilacion de brasileño( no fue total pero se le cobro $650.00 porque se le depilo un pokito de los lados de muslo) mary lazaro entro 1:45\r\n30/agosto/16 mdm full relax 2x600 rosy entro 4:10 (mega)\r\n02/septiembre/16 mdm full relax 2x500 charito entro 5:15 (mega)\r\n07/septiembre/16 mdm full relax 2x500 charito entro 4:10 (mega)\r\n19/octubre/16 mdm full relax 2x500 charito entro 2:00 (mega)\r\n15/enero/17 mdm full relax 2x600 candy entro 3:10 (mega)\r\n12/febrero/17 mdm full relax 2x600 candy entro 6:10 (mega)\r\n19/marzo/17 mdm full relax 2x600 andrea entro 1:00 (mega)\r\n23/abril/17 mdm full relax 2x600 andrea entro 3:05 (mega)\r\n24/abril/17 mdm full relax 2x600 rosy entro 3:20 (mega)\r\n01/mayo/17 mdm full relax 2x600 candy entro 1:10 (mega)\r\n24/junio/17 mdm full relax y limpieza facial 2x600 candy entro 5:05 (mega)\r\n23/julio/17 mdm full relax 2x600 andrea entro 5:15 (mega)\r\n03/sept/17 mdm full relax andrea entro 1:00 (mega)\r\n16/sept/17 mdm combo andrea entro 5:05 (mega)\r\n27/AGOSTO/18 INICIA TRATAMIENTO REDUCTIVO COMPLETO COSTO 8,000 PAGADO\r\n1.- CAVITA Y MASAJE 45  27/AGOSTO/18 ANITA ENTRO 1:20\r\n2.- MASAJE Y G-5   28/AGOSTO/18 ANITA ENTRO 9:15\r\n3.- LASER LIPOLITICO, MASAJE 45 Y G-5  29/AGOSTO/18 MARY ENTRO 9:25\r\n4.- MASAJE, G-5 Y CÁPSULA   30/AGOSTO/18 MARY\r\n5.- MASAJE, G-5 Y CORPO   31/AGOSTO/18 MARY\r\n6.-MASAJE, G-5 Y RADIO 40  3/SEP/18  MARY ENTRO 9:20\r\n7.- MASAJE, G-5 TERMOS 4/SEPT/18 MARY LAZARO ENTRO 2:00\r\n8.- MASAJE, G-5 Y LUMICELL 30 5/SEPT/18 MARY LAZARO ENTRO 1:15\r\n9.- MASAJE, G-5 Y CRIOLIPOLISIS 60 6/SEPT/18 MARY LAZARO ENTRO 1:15\r\n10.- CARBO, MASAJE, CÁPSULA 12/SEPT/18 MARY LAZARO ENTRO 12:40 \r\nTÉRMINO TRATAMIENTO REDUCTIVO CON MEDIDA EN OMBLIGO DE 85 CM\r\n2/OCT/18 INICIA TRATAMIENTO REDUCTIVO DE CAVITACION COSTO 4,000 PAGADO\r\n1.- CAVITACION 60M, MASAJE 45M  2/OCT/18 MARY\r\n2.-CARBO, MASAJE 45 M 4/OCT/18 MARY ENTRO 9:45\r\n3.-MASAJE 45 M, VACUNTERAPIA 5/OCT/18 MARY LAZARO ENTRO 9:50\r\n4.- CAV Y MASAJE  6/OCT/18 MARY\r\n5.- CARBOX, MASAJE    9/OCT/18 MARY\r\n6.- MASAJE, VACUN  10/OCT/18  ANITA ENTRO 2:10\r\n7.- CAV MASAJE    11/OCT/18 MARY ENTRO 10:15\r\n8.- CABOX, MASAJE  12/OCT/18 CHARITO ENTRO 9:45\r\n9.- MASAJE, VACUN  16/OCT/18 MARY ENTRO 9:50\r\n10.- CAV Y MASAJE  17/OCT/18 MARY ENTRO 9:00\r\n14/octubre/18 masaje express susy entro 12:30 (mega)\r\n17/OCT/18 TERMINO TRATAMIENTO REDUCTIVO\r\n23/OCT/18 INICIA TRATAMIENTO REDUCTIVO COSTO 3,900 PAGADO\r\n1.- CARBOX, VF  23/OCT/18 OFELIA\r\n2.- VF   24/OCT/18 MARY ENTRO 5:20\r\n3.- CARBOX, VF   25/OCT/18 MARY\r\n4.- VF  29/OCT/18 MARY\r\n5.- CARBOX, VF  30/OCT/18 MARY\r\n6.- VF 31/OCT/18 LUPITA ENTRO 5:00\r\n7.- CARBOX, VF\r\n8.- VF\r\n9.- CARBOX, VF\r\n10.- VF\r\n11.- CARBOX, VF\r\n12.- VF\r\n13.- CARBOX, VF\r\n06/enero/19 mdm full relax belen entro 4:40 (mega)\r\n4/FEB/19  LIPOSONIX   8 DISPARO DE LIPOSONIX LUCY\r\nINICIA TRATAMIENTO REDUCTIVO PAQUETE DE $6000.00 \r\n6/FEB/19 ABONO 2,000 DEBE 3,000\r\n1.-RADIO 5/FEB/19 LUPITA ENTRO 4:20\r\n2.-CORPO  6/FEB/19 LUPITA ENTRO 4:45\r\n3.-CRIOLIPOLISIS 40 M  7/FEB/19 LUPITA\r\n7/FEB/19 MASAJE DE PIES LUPITA\r\n4.-RADIO 8/FEB/19 LUPITA ENTRO 9:10\r\n5.-CORPO 13/FEB/19 LUPITA ENTRO 4:10\r\n6.-CRIOLIPOLISIS 14/FEB/19 LUPITA ENTRO 5:00\r\n7.-RADIO 19/FEB/19 ANITA ENTRO 5:05\r\n8.-CORPO 21/FEBRERO/19 LUPITA ENTRO 5:20\r\n9.-CRIOLIPOLISIS 22/FEB/19 LUPITA ENTRO 10:25\r\n10.-RADIO 25/FEB/19 LUPITA ENTRO 5:10\r\n25/FEB/19 MDM FULL RELAX LUPITA \r\n25/FEB/19 TERMINO TRATAMIENTO Y TERMINO DE PAGARLO\r\n26/FEB/19 INICIA TRATAMIENTO CORPORAL COSTO 6, 000\r\n27/FEB/19 ABONO  2,300\r\n1.- CARBOX Y TERMO  26/FEB/19 MONICA\r\n2.- VACUN Y VC  27/FEB/19 MARY ENTRO 5:15\r\n3.- CARBOX Y TERMO  28/FEB/19 REYNA\r\n4.- VACUN Y VC 1/MARZO/19 REYNA ENTRO 6:25\r\n5.- CARBOX Y TERMO  2/MARZO/19 BETTY ENTRO 9.30\r\n6.-  VACUN Y VC  4/MARZO/19 REYNA\r\n7.- CARBOX Y TERMO 5/MARZO/19 REYNA ENTRO 5:30\r\n8.- VACUN Y VC\r\n9.- CARBOX Y TERMO\r\n10.- VACUN Y VC\r\n9/MARZO/19 BAÑO DE NOVIA FACIAL, EXFOLIACIÓN Y MDM COMBO LUCY ENTRO 8:50\r\n26/AGOSTO/19 MASAJE FULL RELAX 2 X 600 LUPITA ENTRO 1:00\r\n29/AGOSTO/19 INICIA TRATAMIENTO REDUCTIVO COMPLETO COSTO 8,000\r\nCON MEDIDAS CINTURA 94 PESO 69\r\n29/agosto/19 ABONO 4,000 DEBE 4,000\r\n1.- CAV 60M Y MASAJE 45 29/AGOSTO/19 ALE ENTRO 3:00\r\n2.- CARBOX, LASER LIPOLI 30 M MASAJE 45 30/AGOSTO/19 ALEGRIA ENTRO 11:45\r\n3.-  MASAJE 45 Y TERMO    31/AGOSTO/19 ALEGRIA ENTRO 8:05\r\n31/AGOSTO/19 LIFTING DE TIMEXPERT RIDES LUCY\r\n4.- CARBOX, MASAJE 45 CAPSULA 2/SEP/19 REYNA \r\n5.- MASAJE 45 CORPO 5/SEP/19 LIZBETH Y LUCY\r\n6.- CARBOX, MASAJE 45 ( RADIO 40M EN ABDOMEN)  9/SEP/19 LIZBETH ENTRO 5:00\r\n7.- LASER LIPOLI 20M, MASAJE 45 ( VF 30M EN ABDOMEN)  10/SEP/19 REYNA ENTRO 5:00\r\n8.- CARBOX, MASAJE 45 Y TERMO 11/SEP/19 LIZBETH\r\n9.- MASAJE 45 RADIO 40M\r\n10.- CARBOX, CAVITACION 60 Y MASAJE 45 12/SEP/19 LIZBETH ENTRO 4:30\r\n29/AGOSTO/19 FACIAL DIAMOND LIF INFUSION MARY LAZARO\r\n4/DICIEMBRE/19 HYDRAFACIAL LUCY ENTRO 5:10\r\n10/DICIEMBRE/19 MDM FULL RELAX LUPITA ENTRO 5:35\r\n3/FEBRERO/20 MDM SENSORELAX LUPITA ENTRO 4:10\r\n10/MARZO/20 MDM SENSORELAX LUPITA ENTRO 5:05\r\n10/JULIO/2020 MDM FULL RELAX LUCY ENTRO 5:10\r\n11/JULIO/2020 MASAJE FULL RELAX LUCY ENTRO 12:00\r\n22/JULIO/2020 MASAJE FULL RELAX LUCY ENTRO 4:50\r\n30/JULIO/2020 MASAJE DESCONTRACTURANTE LUCY ENTRO  4:15\r\n6/AGOSTO/2020 MASAJE FULL RELAX LUCY ENTRO 5:05\r\n17/SEPTIEMBRE/2020 MASAJE FULL RELAX LUCY ENTRO 3:10\r\n2/OCTUBRE/2020 MASAJE FULL RELAX ANITA\r\n9/NOVIEMBRE/2020 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 MONICA ENTRO 12:05 MEGA\r\n23/DIC/2020 TRATAMIENTO FACIAL VITAMINA C DE GERMAINE LUCY ENTRO 3:05\r\n4/FEB/2021 MASAJE COMBO VALE DE REGALO YOANA ENTRO 3:00\r\n5/FEB/2021 FACIAL DIAMOND COCOON DE NATURA BISSE OFELIA ENTRO 3:00\r\n11/FEB/2021 MASAJE FULL RELAX YOANA ENTRO 2:00\r\n26/FEB/2021 FACIAL VITAMINA C DE NATURA BISSE LUCY ENTRO 2:00\r\n29/MAYO/2021 FACIAL NEW AGE CON RADIO LUCY ENTRO 11:30\r\n12/JULIO/2021 INICIA TRATAMIENTO REDUCTIVO SOLO 6 DIAS COSTO 7,000.00 PAGADO\r\n1.- MASAJE 45 12/JULIO/2021 JOHANY ENTRO 6:00\r\n2.- CARBOX, MASAJE Y TERMOSLIN 13/JULIO/2021 JOHANY ENTRO 5:00\r\n3.- MASAJE Y CAPSULA  14/JULIO/2021 JOHANY ENTRO 5:00\r\n4.- CARBOX, MASAJE,  15/JULIO/2021 JOHANY ENTRO 5:30\r\n5.- MASAJE Y CAPSULA 16/JULIO/2021 JHOANA ENTRO 5:10\r\n6.- CARBOX, MASAJE Y TERMOSLIM 17/JULIO/2021 MARIANA ENTRO 10:10 \r\n6/SEPT/2021   MASAJE FULL RELAX JHOANY ENTRO 2:00\r\n21/SEPT/2021   MASAJE DE TE VERDE    JHOANY ENTRO 1:10\r\n9/FEB/2022 TRATAMIENTO FACIAL DIAMOND LIFT INFUSION LUCY ENTRO 3:50\r\n2/ABRIL/2022 FACIAL VITAMINA C DE NATURA BISSE LUCY ENRRO 12:40\r\nLLEVO CREMA ESPECIFICO PARA ESTRIAS\r\n20/MAYO/2022 DEPILACION BRASILEÑA LUCY ENTRO 2:20 LLEVO LOCION CITRICA REVITALIZANTE C+C VITAMIN SPLASH, DESMAQUILLANTE Y LIMPIADOR REVITALIZANTE C+C VITAMIN MICELLAR\r\n4/OCTUBRE/2022 FACIAL VITAMINA C DE NATURA BISSE LUCY ENTRO 5:05\r\n13/ENERO/2023 MASAJE DRENAJE LINFATICO LUCY ENTRO 5:10\r\n19/ENERO/2023 MASAJE FULL RELAX, FACIAL ORO DE CASMRA LUCY ENTRO 12:10\r\n27/ENERO/2023 MASAJE DRENAJE LINFATICO LUCY  ENTRO 2:15\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-27 12:51:52', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('450', 'C-100450', '', 'CATALINA JEREZ VARGAS', '9931602446', '', '19/abril/16 limpieza facial mariana entro 2:45\r\n19/julio/16 limpieza facial 2x600 charito entro 12:25 (mega)\r\n11/enero/17 limpieza facial 2x600 rosy entro 6:35 (mega)\r\n27/julio/17 limpieza facial 2x600 andrea entro 5:20 (mega)\r\n31/JULIO/18 LIMPIEZA FACIAL 2 X 600 ANITA ENTRO 11:00\r\n6/MARZO/19 INICIA TRATAMIENTO REDUCTIVO PESO 61 KG, ABDOMEN 83 Y BUSTO 103 COSTO 3,000 PAGADO\r\n1.- MASAJE, CARBOX 6/MARZO/19 MONICA\r\n2.- MASAJE 7/MARZO/19 MONICA ENTRO 10:30\r\n7/MARZO/19 TERMOSLIN MONICA \r\n3.- MASAJE, CARBOX 8/MARZO/19 MONICA ENTRO 10:20\r\n4.- MASAJE  9/MARZO/19 LUPITA ENTRO 10:20\r\n5.- MASAJE, CARBOX 10/marzo/19 mony entro 1.05\r\n6.- MASAJE  11/MARZO/19 LUPITA ENTRO 10:15\r\n7.- MASAJE, CARBOX 12/marzo/19 monica entro 3:35\r\n8.- MASAJE  13/MARZO/19 MONICA\r\n9.- MASAJE, CARBOX\r\n10.- MASAJE\r\n9/MARZO/19 LIMPIEZA FACIAL 2 X 600 ATENDIÓ ROSY ENTRO 12.15 (MEGA)\r\n24/FEBRERO/2020 LIMPIEZA FACIAL 2X600 MONI ENTRO 1:55 MEGA\r\n11/MARZO/20 TRATAMIENTO FACIAL RECUPERADOR LUPITA ENTRO 5:00\r\n26/FEB/2021 FACIAL VITAMINA C DE NATURA BISSE VALE DE REGALO LUCY ENTRO 4:00\r\n15/SEPT/2021 PROM. TRATAMIENTO FACIAL ISOFLAVONAS DE SOYA CON AMP DE COLAGENO 800.00 LUCY\r\n25ENERO/2023 PROMO TRATAMIENTO FACIAL PURIFICANTE CON AMP. DE CAMSARA OXIGENO LUCY', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-20 12:27:28', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('451', 'C-100451', '', 'MONICA ALICIA RAMIREZ GARCIA', '9931386442', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('452', 'C-100452', '', 'MARTHA HILDA PEREZ VEGA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('453', 'C-100453', '', 'ROSA MARIA CORDOVA DE LA CRUZ', '9933987881', '', '6/nov/15 promocion antiedad humectante y nutritivo fernanda entro 9:20\r\n18/ene/16 promocion desintoxicante lizvet entro 9:10\r\n4/mayo/16 promocion de colageno mariana entro 3:45\r\n11/julio/16 promocion colageno reyna entro 1:15\r\n25/agosto/16 promoción de caviar mariana entro 6:15 EMULSIÓN DE JUVENTUD DE EXCEL THERAPY O2 DE GERMAINE\r\n29/dic/16 promocion trat multivitamínico reyna entro 12:00\r\n2/marzo/17 promocion estimulante de colageno con masc. led mary lazaro entro 12:45\r\n15/julio/17 promocion trar relajante e hidratante y dep de patillas mary lazaro entro 8:05\r\n15/12/17 PROMOCION TRATAMIENTO GOLD ANITA ENTRO ENTRO 4:15\r\n11/ABRIL/18 DEPILACION DE PATILLAS ANITA ENTRO 11:40\r\n2/MAYO/18 PROM TRATAMIENTO ANTIEDAD LUCY ENTRO 4:50\r\n19/JUNIO/18 DEPILACION CON CERA DE PATILLA MARY ENTRO 10:00\r\n3/JULIO/18 PROM TRATAMIENTO FACIAL CON RETINOL MARY ENTRO 9:15\r\n14/AGOSTO/19 DEPILACION DE PATILLAS OFELIA ENTRO 3:40\r\n2/SEP/19 LLEVO SO DELICATE PIEL SECA\r\n19/FEB/2021 PROM. TRATAMIENTO FACIAL PEEL OFF MIRENA ENTRO 8:50\r\n5/MARZO/2022 **********LLEVO LIMPIADORA FACIAL ACIDA Y CREMA HYDRACTIVA PIELES NORMALES A MIXTAS HYDRACURE***********\r\n12/MARZO/2022 PROMOCION TRAT SHOCK DE COLAGENO MARY LAZARO ENTRO 9:10\r\n30/ABRIL/2022 PROM. TRATAMIENTO FACIAL CINETICO JOHANY ENTRO 8:00\r\n23/JUNIO/2022 PROMOCION YOGA FACIAL CRISTINA ENTRO 8:50\r\n28/SEPTIEMBRE/2022 PROM. TRATAMIENTO FACIAL PREVENTIVO DE MANCHAS MARIANA ENTRO 5:00\r\n1/NOVIEMBRE/2022 PROMO TRATAMIENTO FACIAL REPARACION CELULARJHOANY ENTRO 3:00\r\n12/DICIEMBRE/2022 PROMO TRATAMIOENTO FACIAL GOLDEN  ARIANA ENTRO 9:00 LLEVO SERUM HYDRACURE', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-12 09:00:37', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('454', 'C-100454', '', 'VICTORIA CORNELIO ALVAREZ', '9931439340', '', '02/12/15 prom.del mes atendio maribel entro 2:20 (mega)\r\n19/diciembre/15 promocion del mes tratamiento reafirmante rosy entro 3:50 (mega)\r\n11/febrero/16 promocion del mes roll & lift massage anrea entro 10:05 (mega)\r\n03/marzo/16 prom. del mes trat. hidratante candy entro 11:20 (mega)\r\n31/marzo/16 prom. del mes trat. hidratante charito entro 4:20 (mega)\r\n05/mayo/16 prom. del mes trat. colageno susy entro 10:00 (mega)\r\n09/junio/16 prom. del mes trat. elastine charito entro 11:05 (mega)\r\n29/julio/16 prom. del mes colageno andrea entro 2:30 (mega)\r\n07/diciembre/16 prom. del mes multivitaminico lizbeth entro 1:15 (mega)\r\n02/agosto/17 prom. del mes candy entro 5:00 (mega)\r\n26/FEB/19 PROM TRATAMIENTO FACIAL REAFIRMANTE OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('455', 'C-100455', '', 'GLORIA MARGARITA ARGAIZ CORNELIO', '9931439340', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('456', 'C-100456', '', 'BIANCA REBECA RUIZ AZUA', '9931348100', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('457', 'C-100457', '', 'DORA RODRIGUEZ CARVALLO', '', '', '', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('458', 'C-100458', '', 'LAURA RIOS DE MU', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('459', 'C-100459', '', 'MARIA CONCEPCION MORENO REYES', '9932152875', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('460', 'C-100460', '', 'ERIKA GALLEGOS CASTRO', '9931209707', '', '25/feb/08 limpieza facial mary entro 6:10 \r\n7/marzo/08 limpieza facial julia entro 6:25 \r\nllevo 2 amp. mineralizante y 2 tabletas equilibrium.\r\n9/ene/09 promocion jalea real julia entro 5:20\r\n22/junio/09 promocion white line sara entro 6:10\r\n24/sept/09 limpieza facial 2 x 1 sara entro 4:00 \r\n7/oct/09 limpieza facial 2 x 1 karina entro 6:00\r\n7/dic/09 promocion flash beauty gladys entro 1:40\r\n12/dic/09 exfoliacion de cuerpo gladys entro 8:20\r\n20/ene/10 limpieza facial 2 x 1 con amp. piel grasa de\r\n sothys gladys entro 3:00	\r\n6/marzo/10 promocion de cristal marina entro 9:15 \r\n13/oct/10 promocion efecto botox sara entro 3:10\r\n9/feb/11 limpieza facial 2 x 1 graciela entro 4:15 salio 5:15 (sucursal) \r\n29/junio/11 promocion estimulante de endorfinas araceli entro 3:15\r\n11/ene/12 promocion revitalizante mariana entro 5:35\r\n15/agosto/12 limpieza facial 2 x 1 con amp. desincrustante y amp. hidratante karina entro 11:10\r\n17/dic/12 promocion de oro karina entro 3:45\r\n29/dic/12 mdm, limpieza facial con amp. royal jelly karina entro 10:05\r\n5/junio/13 promocion coco y mango martha entro 10:00\r\ninicia tratamiento reductivo completo $8000.00 pagado\r\ncon medidas a-134, b-142, c-140, ca-149, cb-150, br-56, m-102 pesa 135 1/2 k.g\r\n1.-cavitacion 60 m, masaje 45 m 17/junio/13 yusiria entro 8:35\r\n2.-carbo, masaje 45 m, termo 18/junio/13 yusiria entro 8:30\r\n3.-masaje 45 m, g-5 19/junio/13 yusiria entro 8:30\r\n4.-carbo, masaje 45 m, corpo 20/junio/13 yusiria entro 8:30\r\n5.-laser lipolitico, tabla, masaje 45 m 21/junio/13 yusiria entro 8:35\r\n6.-cavitacion 60 m, masaje 45 m 24/junio/13 yusiria entro 8:30\r\n7.-carbo, masaje 45 m 25/junio/13 yusiria entro 8:35 se debe el termoslim\r\n8.-masaje 45 m, g-5 10 m, v f 45 m 27/junio/13 yusiria entro 8:40\r\n27/junio/13 reflexologia podal yusiria\r\n9.-carbo, masaje 45 m, g-5 45 m 28/junio/13 yusiria entro 8:30\r\n29/junio/13 se le dio la sesion de termo que se le debía yusiria entro 8:10\r\n21/dic/13 promocion de oro lucy entro 1:25\r\n13/mayo/14 promocion facial hidratante nelli entro 11:00\r\n2/sep/14 promocion azteca mariana entro 9:55\r\n4/febrero/15 promoción tratamiento reafirmante mariana entro 8:55\r\n28/agosto/15 promocion chocoterapia lucy entro 8:25\r\n17/junio/16 promocion de elastine mariana entro 8:30\r\n9/nov/17 promocion termico-humectante lucy entro 9:00\r\n6/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL REYNA ENTRO 1:20\r\n14/NOVIEMBRE/19 TRAMIENTO FACIAL DE PERLAS LUPITA ENTRO 4:55\r\n28/SEPT/2020 PROMOCION TRAT REVITALIZANTE MONICA ENTRO 3:45\r\n9/NOV/2020 MASAJE FULL RELAX MIRENA ENTRO 2:50\r\n10/NOV/2020 FACIAL VITAMINA C DE GERMAINE +RADIO ANITA ENTRO 11:15\r\n21/DIC/2020 PROMOCION TRAT. DE PORCELANA LUCY ENTRO 3:10\r\n30/DIC/2020 MASAJE FULL RELAX, PROMOCION TRAT. DE PORCELANA MIRENA ENTRO 12:20\r\n12/MARZO/2021 PROM. TRATAMIENTO FACIAL ACIDO HIALURONICO LUCY ENTRO 8:50\r\n22/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL MAZADA DE GERMAINE MONICA ENTRO 3:05\r\n29/DICIEMBRE/2021 FACIAL GLYCOCIUR  JOHANY  ENTRO 2:10\r\n22/JULIO/2022 TRATAMIENTO FACIAL HYDRACURE LUCY ENTRO 4:15', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-02 22:27:24', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('461', 'C-100461', '', 'HILDA SOFIA DE LA O OCA', '9932175104', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('462', 'C-100462', '', 'ROCIO CASTILLO GOMEZ', '9932428871', '', '13/oct/10 promocion efecto botox sara entro 3:10\r\n9/feb/11 limpieza facial 2 x 1 deyanira entro 4:15 salio 5:15 (sucursal) \r\n29/junio/11 promocion estimulante de endorfinas sara entro 3:15\r\n11/ene/12 promocion revitalizante rosy entro 5:20\r\n15/agosto/12 limpieza facial 2 x 1 con amp. hidratante reyna entro 11:10\r\n17/dic/12 promocion de oro, depilacion de cejas y menton mariana entro 3:45\r\n29/dic/12 mdm, limpieza facial con amp. royal jelly araceli entro 10:05\r\n5/junio/13 promocion coco y mango lucy entro 10:00\r\ninicia tratamiento reafirmante con vendas frias y corpo $4000.00 pagado\r\n1.-corpo 17/junio/13 ana\r\n2.-v f 45 m 18/junio/13 ana entro 8:30\r\n3.-corpo 19/junio/13 ana\r\n4.-v f 45 m 20/junio/13 ana entro 8:30\r\n5.-corpo 21/junio/13 ana entro 8:35\r\n6.-v f 45 m 24/junio/13 ana entro 8:30\r\n7.-corpo 25/junio/13 ana entro 8:35\r\n8.-v f 45 m 27/junio/13 ana\r\n9.-corpo 28/junio/13 ana\r\n10.-corpo 29/junio/13 ana entro 8:10\r\ntermino tratamiento\r\ninicia trat de busto $8000.00 pagado\r\n1.-limpiar, peeling, brosh, busting 7 m, amp. elastine, masc. modeladora 30 m 17/junio/13 ana\r\n2.-limpiar, brosh, busting 7 m, amp. elastine, masc. elastine 15 m 18/junio/13 ana \r\n3.-limpiar, brosh, busting 7 m, amp. elastine, masc. modeladora 19/junio/13 ana\r\n4.-limpiar, brosh, busting 7 m, amp. elastine, masc. elastine 20/junio/13 ana\r\n5.-limpiar, brosh, busting 7 m, amp. elastine, masc. modeladora 21/junio/13 ana\r\n6.-limpiar, brosh, busting 7 m, amp. elastine, masc. elastine 24/junio/13 ana entro 8:30\r\n7.-limpiar, brosh, busting 7 m, amp. elastine, masc. modeladora 25/junio/13 ana entro 8:35\r\n8.-limpiar, brosh, busting 7 m, amp. elastine, masc. elastine 27/junio/13 ana entro 8:40\r\n9.-limpiar, brosh, busting 7 m, amp. elastine, masc. modeladora 28/junio/13 ana entro 8:30\r\n10.-limpiar, brosh, busting 7 m, amp. elastine, masc. elastine 29/junio/13 ana entro 8:10\r\ntermino tratamiento\r\n21/dic/13 promocion de oro rosy entro 1:25\r\n13/mayo/14 promocion facial hidratante carmen llevo meladermic, clear crema aclaradora\r\n2/sep/14 promocion azteca ana entro 9:55\r\n26/10/14 se realizo mdm full relax atendio susy cristal entro alas 5.10\r\n\r\n4/febrero/15 promoción tratamiento reafirmante jhoany entro 8:55\r\n28/agosto/15 promocion chocoterapia mariana entro 8:25\r\n18/sept/15 promocion equilibrante del ph eva entro 4:15\r\n25/sept/15 promocion equilibrante del ph graciela entro 4.50\r\n3/oct/15  promocion reafirmante candy entro 4:10\r\n17/oct/15 masaje full relax maria entro 9:10\r\n17/junio/16 promocion de elastine anita entor 8:30\r\n8/oct/16 promocion de coalgeno mirena entro 12:30\r\n8/oct/16 LLEVO MOUSSE OXIGENO NB, CREMA OXIGENO NB Y CREMA CONTORNO DE OJOS NATURA BISSE \r\n3/dic/16 promocion trat multivitaminico mariana entro 8:05 \r\n01/mayo/17 prom. del mes antiedad candy entro 6:50 (mega)\r\n9/nov/17 promocion termico-humectante mariana entro 9:00\r\n20/JULIO/ 18 FACIAL DIAMOND LIFE INFUSION  LUCY ENTRO 1:05\r\n20/JULIO/18  LLEVO TIMEXPERT LIFT VECTOR LIFT, TIMEXPERT C+ EMULSIÓN INTENSIVO Y TIMEXPERT C+ CREMA CORRECCIÓN\r\n20/SEP/18 PROM TRATAMIENTO  FACIAL REGENERANTE REYNA ENTRO 9:15\r\n4/DIC/18 PROMOCION DIAMANTE MONICA ENTRO 9:15  LLEVO MASCARA NOCHE RENOVADORA TIMEXPERT RIDES, ELIXIR ABSOLUTO DE NUTRICIÓN TIMEXPERT RIDES, VELO HIDRATANTE ANTIEDAD ESSENTIAL SHOCK, REAFIRMANTE CONTORNO DE OJOS Y LABIOS ESSENTIAL SHOCK, CREMA TENSO-REAFIRMANTE CUELLO Y ESCOTE TIMEXPERT LIFT IN.\r\n14/ENE/19 INICIA TRATAMIENTO DE NEW LIFT - $8,000 PAGADO\r\n1.- NEW LIFT -14/ENE/19  REYNA ENTRO 9:20\r\n2.- NEW LIFT 15/ENE/19 REYNA ENTRO 9:00\r\n3.- NEW LIFT 16/ENERO/19 REYNA ENTRO 9:00\r\n4.- NEW LIFT 17/ENERO/19 REYNA ENTRO 9:00\r\n5.- NEW LIFT 18/ENERO/19 REYNA ENTRO 9:15\r\n6.- NEW LIFT 21/ENERO/19 REYNA ENTRO 9:00\r\n7.- NEW LIFT 22/ENERO/19 REYNA ENTRO 9:10\r\n8.- NEW LIFT 23/ENERO/19 REYNA ENTRO 9:00\r\n9.- NEW LIFT 24/ENERO/19 OFELIA ENTRO 9:00\r\n24/ENERO/19 FACIAL TIMEXPERT IN OFELIA \r\n24/ENERO/19 LLEVO CREMA CHAUFFANTE\r\n10.- NEW LIFT 25/ENERO/19 LUCY ENTRO 9:00\r\nTERMINO TRATAMIENTO.\r\n1/FEB/19 RADIOFRECUENCIA FRACCIONADA LUCY ENTRO 9:10\r\n11/FEB/19 RADIOFRECUENCIA FRACCIONADA LUCY ENTRO 9:00\r\n18/FEB/19 RADIOFRECUENCIA FRACCIONADA LUCY ENTRO 9:10\r\n27/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE LUCY ENTRO 12:15\r\n27/ABRIL/19 LLEVO CREMA TIMEXPERT SRNS Y CREMA TIMEXPERT C+\r\n2/MAYO/19 TRATAMIENTO REVERSE CON AMP.  SHOCK FLUIDS PHOTO-AGED RECOVERY PARA PIELES DESVITALIZADAS DE GERMAINE LUCY ENTRO 9:00\r\n9/MAYO/19 FACIAL REVERSE OFELIA ENTRO 9:05\r\n24/JULIO/19 LLEVO TIMEXPERT RIDES CREMA RE, CREACION ARRUGAS 1785.00 Y TIMEXPERT RIDES RETINAGE X-CEL 2560.00\r\n29/OCT/19 LLEVO EMULSION OXIGENANTE EXCEL THERAPY 02 POLLUTION, CONTORNO DE OJOS OXIGENANTE EXCEL THERAPY 02 \r\n14/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS MARY LAZARO ENTRO 4:55\r\n14/JULIO/2020 MASAJE DESCONTRACTURANTE LUCY ENTRO 2:05\r\n28/SEPT/2020 PROMOCION TRAT REVITALIZANTE MARY LAZARO ENTRO 3:45\r\n9/NOV/2020 MASAJE FULL RELAX ARLETH ENTRO 2:50\r\n10/NOV/2020 FACIAL VITAMINA C DE GERMAINE + RADIO LUCY ENTRO 11:15\r\n21/DIC/2020 PROMOCION TRAT. DE PORCELANA JHOANY ENTRO 3:10 LLEVO MOUSSE DE OXIGENO NATURA BISSE\r\n30/DIC/2020 MASAJE FULL RELAX, PROMOCION TRAT DE PORCELANA CON AMP. OXIGENANTE MONICA ENTRO 12:20\r\n12/MARZO/2021 PROM TRATAMIENTO DE FACIAL ACIDO HIALURONICO CON AMP OXIGENANTE OFELIA ENTRO 8:50\r\n18/MARZO/2021 PROM. TRATAMIENTO FACIAL ACIDO HIALURONICO CON AMP NUTRITIVA DE GERMAINE  OFELIA ENTRO 1:05 \r\nLLEVO EXCEL THERAPY CREMA OXIGENANTE Y ACTIVADOR DEFENSAS\r\n8/SEPT/2021 FACIAL VIT. C DE RADIANS  LUCY   ENTRO 11:35\r\nLLEVO  EMULSION ANTIOXIDANTE, CREMA ANTIOXIDANTE Y CONTORNO DE OJOS DE VITAMINA C RADIANS Y SERUM AMPOLLETAS \r\n22/DICIEMBRE/2021 TRATAMIENTO MAZADA DE GERMAINE CON AMP DE COLAGENO DE NATURA BISSE   OFELIA ENTRO 3:15\r\nLLEVO REPARADOR DE TIMEXPERT SRNS\r\n29/DICIEMBRE/2021 FACIAL GLYCOCIUR MARIANA ENTRO 2:10\r\n30/MARZO/2022 TRATAMIENTO FACIAL VITAMINA C DE NATURA BISSE MARIANA ENTRO 10:00 LLEVO CREMA RECUPERADORA INTENSIVA TIMEXPERT SRNS, CONCENTRADO NOCTURNO TIMEXPERT SRNS \r\n22/JULIO/2022 TRATAMIENTO FACIAL MASSADA MARIANA ENTRO 4:15\r\n***************************LLEVO PRODUCTOS**********************************\r\n***LECHE CLARIFICANTE EXFOLIANTE  TIMEXPERT WHITE\r\n*** SERUM   TIMEXPERT WHITE\r\n*** SPOT DIMINISH   TIMEXPERT WHITE\r\n*** POWER LIGHT   TIMEXPERT WHITE\r\n*** CREMA CORRECCION MANCHAS   TIMEXPERT WHITE\r\n*** CREMA PROTECTORA SOLAR  DIAMON WHITE\r\n*** LASMASKIN 4%\r\n*** ELDOQUIN 2%\r\n*** CREMA CUELLO Y ESCOTE TIMEXPERT LIFT NECK\r\n*** TONICO CLARIFICANTE DE GERMAINE\r\n26/JULIO/2022 1RA. IPL MANCHAS PROG. I INT. 4 OFELIA\r\n5/AGOSTO/2022 LASER YAG 320/7 MARIANA ENTRO 9:00\r\n22/AGOSTO/2022 LASER DE CARBONO OFELIA ENTRO 9:10\r\n30/AGOSTO/2022 FACIAL HYDRACURE LUCY ENTRO  3:05\r\n6/SEPT/2022 2DA. IPL MANCHAS PROG. 1 INT. 5 MARY LAZARO \r\n27/SEPTIEMBRE/2022 LASER YAG OFELIA ENTRO 3:00\r\n11/OCTUBRE/2022 FACIAL CASMARA MARY LAZARO ENTRO 2:20\r\n11/NOVIEMBRE/2022 LASER DE CARBONO Y AMP DE CANAVIS LUCY ENTRO 1:00\r\n22/NOVIEMBRE/2022 PEELING QUIMICO JHOANY ENTRO 2:30\r\n6/DICIEMBRE/2022 PEELING QUIMICO PARA MACHAS JHOANY\r\nLLEVO SERUM TIMEXPERT WHITE\r\n0/DICIEMBRE/2022  PROXIMO TRATAMIENTO CASMARA DE MANCHAS\r\n19/DICIEMBRE/2022 PEELING QUIMICO OFELIA ENTRO 11:00\r\n2/ENERO/2023 FACIAL DE CASMARA DE MANCHAS, LIFTING TIMEXPERT RIDES OFELIA entro 2:05\r\nlLLEVO CONCENTRADO NOCTURNO DTOX NIGHT\r\n17/ENERO/2023 FACIAL CASMARA MANCHAS OFELIA ENTRO 2:00\r\n31/ENERO/2023 FACIAL EXCEL THERAPY JHOANY ENTRO 2:05', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-31 16:32:13', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('463', 'C-100463', '', 'ALEJANDRO GARCIA CRUZ', '', '', '19/nov/15 masaje ful relax fernanda entro 11:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('464', 'C-100464', '', 'LIDIA CRUZ CASTELLANOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('465', 'C-100465', '', 'SOFIA LOPEZ CASTILLO', '9931565660', '', '5/ABRIL/2021 LIMPIEZA FACIAL 2X600 MARIANA ENTRO 9:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('466', 'C-100466', '', 'ANA ALICIA NASUNO BASTAR', '9933476397', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('467', 'C-100467', '', 'ALICIA BASTAR CORDERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('468', 'C-100468', '', 'YULIANA MADRIGAL', '9933111076', '', '8/DICIEMBRE/19 FULL RELAX JANETH ENTRO 2:20 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('469', 'C-100469', '', 'TERESITA DE JESUS HIDALGO ROMERO', '9931098788', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('470', 'C-100470', '', 'CRISTINA GARCIA PEREZ', '9933995510', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('471', 'C-100471', '', 'LUCRECIA EUGENIA CABADAS AYLUARDO', '', 'lucrecia.eugenia.cabadas@pemex.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('472', 'C-100472', '', 'MARIO CARBAJAL LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('473', 'C-100473', '', 'NORA ABIGAIL LIRA FREGOSO', '13141200073', 'lirafregoso@live.com.mx', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('474', 'C-100474', '', 'CAROLINA CADENA', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('475', 'C-100475', '', 'MARIA DEL CARMEN MUNGUIA HERNANDEZ', '9931105395', '', '11/dic/15 masaje reductivo y promocion reafirmante modeladora fernanda entro 10.50\r\n23/julio/16 promocion de colageno lucy entro 10.10\r\n5/nov/16 masaje reductivo y reflexologia podal anita entro 11:40\r\n22/dic/16 promocion trat multivitaminico lucy entro 11:45\r\n7/abril/17 exfoliación de cuerpo charito entro 3:30\r\n12/abril/17 promocion termico, reflexologia podal carmen entro 11:05\r\n5/ABRIL/18 MASAJE REDUCTIVO LUPITA ENTRO 12:50\r\n13/JULIO/18 MDM REDUCTIVO Y PROM TRATAMIENTO FACIAL DE RETINOL  LUPITA\r\n10/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE MONICA ENTRO 12:00\r\n29/SEP/18 MDM FE REFLEXOLOGÍA PODAL  REYNA ENTRO 1:20\r\n1/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN ANITA ENTRO 1:20\r\n21/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE Y MDM REDUCTIVO MONICA ENTRO 1:25\r\n21/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K  SANDY ENTRO 1:55\r\n25/JULIO/2020 TRATAMIENTO FACIAL ANTIEDAD A BASE DE ALGAS CON LIFTING DE COLAGENO, MASAJE REDUCTIVO, VENDAS FRIAS OFELIA ENTRO 9:55\r\n13/MAYO/2021 MASAJE REDUCTIVO, PROMOCION TRAT. CELULAS MADRE JHOANY ENTRO 12:50\r\n31/JULIO/2021 MASAJE REDUCTIVO Y PROM. TRATAMIENTO FACIAL CAVIAR Y ORO ARLETH ENTRO 1:00\r\n14/MAYO/2022 MASAJE REDUCTIVO ARIANA ENTRO 12:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('476', 'C-100476', '', 'DOLORES MARCELA BATISTA FUENTES', '9933115817', '', '10/diciembre/16 prom. del mes multivitaminico mirena entro 4:10 (mega)\r\n3/abril/17 promocion termico charito entro 1:25\r\n5/abril/17 delineado de cejas, parpado superior e inferior, se le dio $300.00 pesos a ofelia\r\n4/SEPT/18 PROMOCION TRAT REGENERANTE Y ESTIMULANTE LINDA ENTRO 2:00\r\n27/JULIO/19 TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO ANITA ENTRO  ENTRO 11:35\r\n10/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K MARY LAZARO ENTRO 3:10\r\n20/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD REGENERANTE CON LIFTING DE PARCHE 350.00  LUCY ENTRO 3:15\r\n30/DIC/2020 PROMOCION TRAT DE PORCELANA JHOANY ENTRO 12:00\r\n5/ABRIL/2021 INICIA TRATAMIENTO DE NEW LIFT PAGARA 1000.00 C/SESION\r\nLLEVO CONTORNO OJOS DIA Y NOCHE TIMEXPERT RIDES, CREMA DIA Y NOCHE CON EXTRACTO DE CAVIER  AINHOA Y SERUM FACIAL AINHOA\r\n1.- NEW LIFT 5/ABRIL/2021 MARY LAZARO ENTRO 9:00\r\n2.- NEW LIFT 6/ABRIL/2021 MARY LAZARO ENTRO 9:30\r\n3.- NEW LIFT 7/ABRIL/2021 MARY LAZARO ENTRO 9:05\r\n4.- NEW LIFT 8/ABRIL/2021 MARY LAZARO ENTRO 9:25\r\n5.- NEW LIFT 9/ABRIL/2021 MARY LAZARO ENTRO 9:55\r\n6.- NEW LIFT 12/ABRIL/2021 MARY LAZARO ENTRO 9:00\r\n7.- NEW LIFT  14/ABRIL/2021 MARY LAZARO ENTRO  9:25\r\n8.- NEW LIFT  15/ABRIL/2021 MARY LAZARO ENTRO 10:05\r\n9.- NEW LIFT 19/ABRIL/2021 MARY LAZARO ENTRO 10:05\r\n10.- NEW LIFT26/ABRIL/2021 MARY LAZARO ENTRO MARY LAZARO ENTRO 9:30\r\n30/ABRIL/2021 PAGO SALDO VENCIDO 1000.00\r\n4/ENERO/2022 PROM. TRATAMIENTO FACIAL DETOX JOANHY ENTRO 2:00\r\n28/ENERO/2022 PROM. TRATAMIENTO FACIAL DETOX  ARLETH ENTRO 3:15\r\n5/JULIO/2022 FACIAL TIMEXPERT SRNS LUCY ENTRO 3:00 \r\n5/OCT/2022 TRATAMIENTO FACIAL TIMEXPERT RIDES CON RADIO LUCY ENTRO 2:25\r\n4/NOVIEMBRE/2022 TRATAMIENTO FACIAL CASMARA JHOANY ENTRO 9:55\r\n4/NOVIEMBRE/2022 RETOQUE DE CEJAS OFELIA ENTRO 12:30\r\n*************10/NOVIEMBRE/2022  ***LLEVO PRODUCTOS******************\r\n1.- LOCION TONIFICANTE DE GERMAINE\r\n2.- LECHE DESMAQUILLANTE DE GERMSINE\r\n3.- SERUM REPARADOR NIGHT TIMEXPERT SRNS\r\n4.- CREMA RECUPERADORA TIMEXPERT SRNS\r\n5.- CREMA CONFORT NIGHT\r\n*******************************************************************************\r\n                                                      DATOS DE FACTURACIO\r\nNOMBRE: DOLORES MARCELA BATISTA FUENTES\r\nRFC:  BAFD530116KW4\r\nDIRECCION: CALLE ARRECIFE NUM 5 MANZANA 1     \r\n FRACC VALLE MARINO     CP: 86026\r\nVILLAHERMNOSA TAB.         GASTOS EN GENERAL\r\nPERSONA FISICA CON ACTIVIDAD EMPRESARIAL\r\nCORREO:    dolores_batista@hotmail.com\r\n***********************************************************************************\r\n17/MARZO/2023 FACIAL TIMEXPERT RIDES JHOANY ENTRO 5:00 ', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-13 17:53:06', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('477', 'C-100477', '', 'ALMA RIVES ROBLES', '9935904964', '', '12/dic/15 promocion reafirmante modeladora sra. bego\r\nRadio facial $1000.00 cada sesion\r\n22/dic/15 radio facial sra, bego entro 1:00 \r\n29/dic/15 llevo oxygen perfecting oil aceite seco\r\n\r\n24/feb/16 facial timexpert life sra. bego\r\n23/marzo/16 facial invento de la   sr. bego\r\n14/JUNIO/16 LLEVO CREMA TENSO-REAFIRMANTE CUELLO Y ESCOTE TIMPEXET LIFT NECK Y CREMA SUPREMA DEFINICIÓN TIMEXPERT LIF IN\r\n14/JUNIO/16 FACIAL DE $1000.00 SRA. BEGO\r\n12/julio/16 facial (tratamiento de  señora bego con radio) sra. bego\r\n16/agosto/16 facial combinado bego entro 5:10 llevo concentrado nocturno detox TIMEXPERT SRNS\r\nSE LE REALIZAN TRATAMIENTO DE $1200.00\r\n8/sept/16 facial (tratamiento de la señora bego con radio) $1000.00 sra. bego\r\n28/enero/17 facial bego LLEVO PACK TIMEXPERT SRNS PRO 60+\r\n18/feb/17 facial de $1000.00 sra. bego\r\n20/abril/17 crema AGE timexpert + C \r\n5/mayo/17 promocion antiedad con lifting bego\r\n5/mayo/17 trat de manos iroha carmen\r\nINICIA CINCO SESIONES DE RADIO FACIAL $1000.000 CADA SESION\r\n1.-RADIO FACIAL  31/mayo/17  sra bego entro 12:30 \r\nllevo oxygen aceite seco hidrata-nutre-tonifica de natura bisse\r\n2.-RADIO FACIAL 27/junio/17 sra. bego entro 12:00\r\n3.-RADIO FACIAL 5/julio/17 sra.- bego \r\nLLEVO CREMA ROYAL JELLY CONFORT Y HELIOCARE GEL \r\n4.-RADIO FACIAL\r\n5.-RADIO FACIAL\r\n27/ENERO/17 FACIAL EXCEL THERAPY $1000.00 SRA. BEGO ENTRO 11:00 LLEVO CREMA EXTRA NUTRITIVA ALTA EXIGENCIA TIMEXPERT SRNS PRO 60+, FORMULA DETOX ILUMINADORA BOLSAS Y OJERAS TIMEXPERT SRNS\r\n17/FEB/18 TRATAMIENTO FACIAL (1,000) LLEVÓ FILTRO SOLAR, Y PRO-RESILIENCIA EXTREME DE ROYAL JELLY SRA BEGO\r\n23/JULIO/18  TRATAMIENTO FACIAL (1,000) LEVO CREMA X CEL TIMEXPERT RIDES\r\n1/DIC/18 FACIAL ///1,000/// SRA BEGO\r\n1/DIC/18 LLEVO TIMEXPERT RIDES NUTRICIÓN, TIMEXPERT RIDES CREMA RE-CREACIÓN\r\n12/ENERO/19 LLEVO MÁSCARA RENOVADORA DE NOCHE TIMEXPERT RIDES\r\n9/ABRIL/19 TRATAMIENTO FACIAL REVERSE COSTO 1,000.00 SRA BEGO\r\n4/OCT/19 TRATAMIENTO FACIAL REVERSE $1,000.00 SRA. BEGO ENTRO 11:00\r\n11/OCT/19 FACIAL REVERSE DE $1000.00 BEGO ENTRO 11:20\r\n25/NOVIEMBRE/19 TRATAMIENTO FACIAL PERLA DE VELO SRA BEGO\r\n5/AGOSTO/2020 PROMOCION TRAT OXIGENANTE CON AMP. BEAUTE II SRA. BEGO ENTRO 11:10 $1,000.00 \r\n26/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD REGENERANTE SRA BEGO\r\n18/MARZO/2021 FACIAL CON MASCARILLA ELECTROESTIMULANTE 1,200.00 SRA BEGO\r\n8/NOVIEMBRE/2021 LLEVO CREMA GLOBAL ARRUGAS SUPREME TIMEXPERT RIDES\r\n6/JULIO/2022 LLEVO CREMA ANTIOXIDANTE ILUMINADORA VITAMINA C RADIANCE\r\n12/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE CON AMP. BEAUTE IV SRA. BEGO ENTRO 12:25 ', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-10 12:54:08', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('478', 'C-100478', '', 'ELIZABETH MORALES SANTOS', '9363890846', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('479', 'C-100479', '', 'LILIAN QUI', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('480', 'C-100480', '', 'MAGALI VAZQUEZ DE COLIN', '9933113557', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('481', 'C-100481', '', 'MARTHA PATRICIA CRUZ OLAN', '9931706544', '', '04/abril/16 mdm drenaje linfatico charito entro 4:05 (mega)\r\n10/diciembre/16 mdm drenaje linfatico mirena entro 12:15 (mega)\r\n06/MAYO/2022 MASAJE DESCONTRACTURANTE MONICA ENTRO 18:05 MEGA\r\n18/MAYO/2023 MASAJE FULL RELAX SUSY ENTRO 7:10 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-22 17:45:52', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('482', 'C-100482', '', 'ARLET GARDU', '', '', '02/diciembre/16 limpieza facial  2x600 maria entro 10:00 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('483', 'C-100483', '', 'MARIANA CHAVEZ FERNANDEZ', '9931605601', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('484', 'C-100484', '', 'GLORIA GARCIA REYES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('485', 'C-100485', '', 'ALEJANDRA OROPEZA DOMINGUEZ', '9931577342', '', '8/dic/16 masaje de espalda charito\r\n22/dic/16 masaje de espalda mirena entro 2:15\r\n16/FEBRERO/2022  MASAJE DE ESPALDA LUCY \r\n18/FEB/2022 MASAJE DE ESPALDA LUCY ENTRO 9:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('486', 'C-100486', '', 'MIGUEL ZARATE GARRIDO', '9932205553', '', '22/junio/17 mdm full relax 2x600 candy entro 5:10 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('487', 'C-100487', '', 'MARIA DEL REFUGIO PEREZ RODRIGUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('488', 'C-100488', '', 'KARINA CRISTEL PRIEGO CUETO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('489', 'C-100489', '', 'MARIA GUADALUPE TORRUCO CADENAS', '93711183187', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('490', 'C-100490', '', 'GUADALUPE MEDINA DE BUENDIA', '9933591804', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('491', 'C-100491', '', 'TATIANA BUENDIA MEDINA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('492', 'C-100492', '', 'MARIA LUISA GARCIA GALVAN', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2023-07-12 16:20:53', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('493', 'C-100493', '', 'CAROLINA VARGAS MU', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('494', 'C-100494', '', 'BECKY GOCHICOA SENTIES', '9933110753', '', '5/MARZO/20 TRATAMIENTO FACIAL  RECUPERADOR  ANITA ENTRO 1:15\r\n19/MAYO/2021 DELINEADO DE CEJAS SE LE DIO 300 OFELIA ENTRO 11:10\r\n9/JUNIO/2021 RETOQUE DE CEJAS OFELIA ENTRO 10:35\r\n24/NOVIEMBRE/2021 DELINEADO DE CEJAS SE LE DIO 300 OFELIA ENTRO 8:55', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-13 12:47:37', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('495', 'C-100495', '', 'PAMELA LOPEZ VILLA', '9931800203', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('496', 'C-100496', '', 'ESTELA ALVARES AVALOS', '9932178730', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('497', 'C-100497', '', 'HUGO ALBERTO NU', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('498', 'C-100498', '', 'JOHANNA KOPP', '9932092710', '', '', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('499', 'C-100499', '', 'JENNIFER ALONSO DE LA O', '9932791992', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('500', 'C-100500', '', 'ANARELI PEREZ ISIDRO', '9141210190', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('501', 'C-100501', '', 'ROCIO ALVAREZ CAMACHO', '9935901219', '', '05/junio/16 mdm holistico 2x600 charito entro 1:15 (mega)\r\n28/agosto/16 mdm full relax 2x600 mary entro 2:10 (mega)\r\n12/marzo/17 mdm full relax 2x600 lizbeth entro 3:00 (mega)\r\n01/octubre/17 mdm full relax 2x600  andrea entro 11:00 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('502', 'C-100502', '', 'ENA CUELLO LIZARRAGA', '9932381626', '', '27/JULIO/19 TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO Y LIFTING DE COALGENO OFELIA ENTRO 10:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('503', 'C-100503', '', 'BERTHA ALICIA HERNANDEZ INFANTE', '9932339744', '', '01/SEPTIEMBRE/15 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X1 CANDY ENTRO 11:20 (CRISTAL)\r\n20/noviembre/15 mdm full relax y limpieza facial 2x1 maribel entro 11:15 (mega) quiso extracción profunda que no importara que quedara roja \r\n27/01/16 MDM  Y LIMPIEZA FACIAL CON DESCUENTO ENTRO 12.15 (CRISTal) martha\r\n21-07-16 se realizo l-f y mdm 2x600 cristal doña rosy 5:00\r\n20/octubre/16 mdm full relax y limpieza facial 2x500 carmen entro 12:20 (mega) la señorita pidio salir antes por que tiene prisa\r\n30/dic/16 limpieza facial 2x600 andrea entro 11:25\r\n18/marzo/16 mdm holistico y limpieza facial rosy entro 11:25 (mega)\r\n08-06-16 se realizo l-f y masaje 2x600 cristal doña rosy 10-35\r\n16/feb/17 masaje full relax y limpieza facial 2x600 carmen entro 11:45\r\n19/abril/17 limpieza facial 2x600 carmen entro 11:30\r\n19/abril/17 llevo jabon acnipop, crema facial textura ligera timexpert rides, crema contorno de ojos timexpert rides\r\n14/junio/17 limpieza facial carmen entro 4:30\r\n02/agosto/17 limpieza facial 2x600 carmen entro 11:10 (mega)\r\n18/octubre/17 mdm full relax y limpieza facial 2x600 rosy entro 12:15 (mega)\r\n22/12/17 LIMPIEZA FACIAL 2X600 MARIANA 9:05\r\n09/marzo/18 mdm full relax y limpieza facial rosy entro 11:15 (mega)\r\n08/diciembre/18 limpieza facial 2x600 susy entro 5:05 (mega)CARMITA MENDE\r\n14/marzo/19 limpieza facial susy entro 12:00 mega\r\n23/MAYO/19 MDM FULL RELAX Y LIMPIEZA FACIAL REYNA ENTRO 10:50\r\n19/sep/19 limpieza facial 2x600 mony entro 1:00 mega\r\n20/12/17 LIMPIEZA FACIAL 2X600 Y DEP DE CEJAS MARY ENTRO 9:25\r\n20/MAYO/19 LIMPIEZA FACIAL 2 X 600 REYNA ENTRO 2:05\r\n16/OCTUBRE/19 LIMPIEZA FACIAL 2 X 600 REYNA ENTRO 11:25\r\n7/ENERO/2020 LIMPIEZA FACIAL 2X600 JANETH ENTRO 4:11 MEGA\r\n13/FEBRERO/2020 LIMPIEZA FACIAL 2X600 MONI ENTRO 7:00 MEGA\r\n17/DIC/2021 MASAJE FULL RELAX 2X600, LIMPIEZA FACIAL 2X600 ARLET ENTRO 3:30\r\n26/AGOSTO/2022 LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 1:20\r\n2/ENERO/2023 LIMPIEZA FACIAL 2X600 LUCY ENTRO 1:10\r\n13/ABRIL/2023 DUO LIMPIEZA FACIAL KARLA ENTRO 10:15\r\n5/JUNIO/2023 DUO LIMPIEZA FACIAL LUCY ENTRO 12:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-05 14:11:37', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('504', 'C-100504', '', 'ANDRES CABRERA', '9932339744', '', '02/agosto/17 limpieza facial 2x600 candy entro 11:10 (mega)\r\n26/AGOSTO/2022 LIMPIEZA FACIAL 2 X 600 ARIANA ENTRO 1:20', 'no', 'activo', '2021-12-07 00:49:45', '2022-08-26 13:23:43', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('505', 'C-100505', '', 'DULCE MARIA GALLEGOS SOLIS', '9931172180', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('506', 'C-100506', '', 'FRANCISCO RAMIREZ GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('507', 'C-100507', '', 'FERNANDO GARCIA LUCAS', '9142791782', '', '01/marzo/18 limpieza facial con amp. desincrustante monica entro 3:55 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('508', 'C-100508', '', 'MARY CARMEN SANDOVAL ESTRADA', '', '', '13/abril/17 prom. del mes trat. termico lizbeth entro 11:55 (mega) no quiso masaje linfatico en cara ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('509', 'C-100509', '', 'ALONSO SANDOVAL CORREA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('510', 'C-100510', '', 'ANDRES SANDOVAL SANCHEZ', '9931351992', '', '14/dic/15 masaje full relax andrea entro 1:30\r\n11/julio/16 mdm full relax 2x600 mirena entro 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('511', 'C-100511', '', 'JAVIER VIDAL HERNANDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('512', 'C-100512', '', 'YESICA IVETTE FRIAS FRIAS', '9931656625', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('513', 'C-100513', '', 'JANETH SUAREZ RINCON', '9931603330', '', '27/oct/15 prp c cel ma $12000.00, tbx 1/3 sup $5000.00 dr. oscar garcia\r\n13/nov/15 micro ofelia entro 1:45\r\n1/feb/16 facial the cure y liftin #2 lucy entro 1:15\r\n8/marzo/16 facial timexpert lift reyna entro 5.35\r\n19/mayo/16 promocion colageno reyna entro 2:00\r\n25/oct/16 prp cce $7000.00 y txb 1/3 sup $6000.00 dr, oscar garcia\r\n11/nov/16 desafio antiedad de natura bisse ofelia/mariana entro 12:30\r\n5/ene/17 promocion trat multivitaminico susy entro 11:35\r\n19/ene/17 promocion trat desintoxicante anita entro 1:10\r\n15/feb/17 promocion trat de elastine susy  entro 2:50\r\n4/marzo/17 promocion estimulante de colageno ofelia entro 12.00\r\n4/marzo/17 llevo reafirmante contorno de ojos y labios de essential shock NB \r\nquedo restando $825.00 de la crema \r\n06/marzo/17 pago los 825 (mega)\r\n25/marzo/17 promocion estimulante de colageno con luz leds carmen entro 12:50\r\n22/abril/17 promocion termico, lifting # 2 rosy entro 1:40\r\n16/mayo/17 prp, botox dr. oscar\r\n20/mayo/17 llevo crema contorno de ojos natura bisse\r\n--------DEBE $1260.00 DE LA CREMA, LA VA A PAGAR EN LA MEGA------------\r\n27/mayo/17 Pago la crema que debía (mega) \r\n3/junio/17 micro mariana entro 12:40\r\n14/julio/17 lifting de germaine lucy entro 12.30\r\n2/sept/17 promocion resveratrol lucy entro 1:45\r\n23/sept/17 promocion resveratrol lucy entro 2:05\r\n27/nov/17 prp, botox dr. oscar\r\n14/12/17 promocion tratamiento gold\r\n15/12/17 PROMOCION TRATAMIENTO GOLD  ENTRO 9:50 SUSY\r\n18/ABRIL/18 PRP CCE 7,000 - TXB 1/3 SUP 6,000 DOCTOR OSCAR\r\n5/MAYO/18 MICRO OFELIA ENTRO 1:15\r\n12/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL MARY\r\n27/OCT/18 PRP CCE, TXB 1/3 SUP BOTOX DR OSCAR\r\n12/ABRIL/19 CK VOLUMA 8,000 TXB 1/3 SUP BOTOX 6,000 DR OSCAR', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('514', 'C-100514', '', 'NEREYDA DEL CARMEN GARCIA GURRIA', '9323220115', '', '13/02/18 promocion del mes multivitaminico atendio rosy entro 5.10 (mega) se le dio nota de remision pero exigio el tiket y se molesto\r\n18/agosto/18 prom. del mes trat. humectante susy entro 3:10 (mega)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('515', 'C-100515', '', '(DOCTORA) TERE BETANCOURT', '9931606173', '', '22/junio/17 limpieza facial 2x600 andrea entro 9:00\r\n24/ENERO/18 LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 12:30\r\n14/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE MARY ENTRO 4:55\r\n13/JULIO/19 DEPILACION DE BIKINI ANITA ENTRO 9:00\r\n29/ENERO/20 DEPILACION DE BIKINI MARY LAZARO ENTRO ENTRO 1:00\r\n29/FEBRERO/20 FACIAL TIMEXPERT IN Y LIMPIEZA DE ESPALDA Y TRATAMIENTO DE CUELLO DE NATURA BISSE 700.00 LUCY ENTRO 10:15\r\n16/JUNIO/2020 FACIAL VITAMINA C DE NATURA BISSE ROSY ENTRO 11:50\r\n22/OCT/2020 TRAT FACIAL OXIGENANTE DE NATURA BISSE, LIFTING TIMEXPERT RIDES ROSY ENTRO 12:15\r\n10/FEB/2021 FACIAL DIAMOND MULTISENSORIAL OFELIA\r\n1.- 15/FEB/2021 REVERSE Y LIFTING DE TIMEXÉRT RIDES LUCY \r\n2.- 17/FEB/2021 RADIO FACIAL OFELIA ENTRO 9:05\r\n3.- 19/FEB/2021 NEW LIFT OFELIA  ENTRO 9:05\r\n4.- 25/FEB/2021 REVERS OFELIA ENTRO 10:50\r\n5.-2/MARZO/2021 RADIO OFELIA ENTRO 9:10\r\n6.-13/MARZO/2021 TRATAMIENTO FACIAL DE GERMAINE CON MICRO Y MASC. DE AINOA DE MANCHAS, LIFTING TIMEXPERT RIDES OFELIA ENTRO 9:05\r\n20/MARZO/2021 \r\n7.-20/MARZO/2021 FACIAL VITAMINA C DE NATURA BISSE CON MICRO, LIFTING DE COLAGENO OFELIA ENTRO 9:05\r\n7/MAYO/2021 TRATAMIENTO FACIAL HYDRACURE MARIANA ENTRO 9:05\r\n20/MAYO/2021 VITAMINA C DE GERMAINE CON HYDRACURE OFELIA ENTRO 9:00\r\n29/MAYO/2021 TRATAMIENTO FACIAL EXCEL THERAPY O2 CON MASCARA ESTIMULANTE $2000.00 OFELIA ENTRO 7:50\r\n17/SEPT/2021 FACIAL HYDRACURE 1800.00 OFELIA \r\n2/FEB/2022 HYDRAFACIAL Y LIMPIEZA FACIAL PROFUNDA OFELIA ENTRO 12:10\r\n19/FEB/2022 TRATAMIENTO FACIAL EXCEL THERAPY O2, DEPILACION DE BIKINI OFELIA ENTRO 9:00\r\n11/FEBRERO/2023 TRATAMIENTO FACIAL HYDRACURE OFELIA ENTRO 11:10\r\n27/MARZO/2023 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CON AMP. OXIGENANTE DE NATURA BISSE OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-27 13:16:18', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('516', 'C-100516', '', 'ANEL BEATRIZ ALVARADO TOSCA', '9933832975', '', '16/ene/16 dejo pagado el paquete de cavitacion y masaje $4000.00 pagado\r\ninicia tratamiento de cavitacion y masaje $4000.00 pagado\r\ncon peso 84 1/2 kg\r\n1.-CAVITACION 60M, MASAJE 45M 25/ene/16 maria entro 5:05\r\n2.-CARBO, MASAJE 45M 26/ene/16 maria entro 5:25\r\n3.-MASAJE 45M 27/ene/16 maria entro 5:45\r\n4.-CAVITACION 60M, MASAJE 45M 28/ene/16 maria entro 5:00\r\n5.-CARBO, MASAJE 45M 1/feb/16 maria entro 5:00\r\n6.-MASAJE 45M 2/feb/16 maria entro 5:20\r\n7.-CAVITACION 60M, MASAJE 45M 3/feb/16 maria\r\n8.-CARBO, MASAJE 45M 4/feb/16 maria entro 5:30\r\n9.-MASAJE 45M 5/feb/16 maria entro 5:40\r\n10.-CAVITACION 60M, MASAJE 45M 6/feb/16 maria entro 9:50\r\ntermino tratamiento\r\n6/feb/16 g-5 maria (se le cobra 150 por cada sesion de g5) \r\n11/feb/16 carbox maria entro 11:00\r\n13/feb/16 carbox reyna entro 11:30\r\n18/feb/16 carbox mary lazaro entro 10.35\r\n22/feb/16 carbox reyna entro 3:00\r\n1/marzo/16 mary lazaro entro 11:30 llevo full lashes de germaine de capuccini\r\nINICIA TRATAMIENTO REDUCTIVO $6000.00PAGADO\r\n CON MEDIA EN C-OMBLIGO-103 Y PESO 78 1/2 KG.\r\n1.-CARBOX, MASAJE 45M, TERMOS 14/marzo/16 charito entro 5:25\r\n2.-MASAJE 45M, G-5 10, CAPSULA 15/marzo/16 maria entro 5:05\r\n3.-CARBOX, MASAJE 45M, TERMOS 16/marzo/16 maria entro 5:20\r\n4.-MASAJE 45M, G-5 10, CAPSULA 18/marzo/16 maria entro 5:00\r\n5.-MASAJE 45M, G-5 10, CAPSULA 21/marzo/16 maria entro 5:00\r\n6.-MASAJE 45M, G-5 10, CAPSULA 22/marzo/16 maria entro 4_40\r\n23/marzo/16 llevo shampoo pilosome, locion pilosome y gel anti chute.\r\n7.-CARBO, MASAJE 45M, TERMOS 23/marzo/16 maria entro 4:50\r\n23/marzo/16 desmaquillador de ojos y labios cutical de natura bisse, leche y locion desmaquillante esencial piel seca y delicada de germaine de capuccini.\r\n8.-MASAJE 45M, G5 10, CAPSULA 29/marzo/16 maría entro 10.00\r\n9.-CARBO, MASAJE 45M, TERMOS 30/marzo/16 mariana entro 11.15\r\n10.-MASAJE 45M, G-5 10, CAPSULA 31/marzo/16 maria entro 5:00\r\ntermino el tratamiento con media en a-100 cm y peso 77 1/2 kg. .\r\n//////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n       10/JUNIO/2023\r\n***LLEVO SERUM THREE ACTION PEEL DE CASMARA\r\n***ESPUMA EXFOLIANTE EXCEL THERAPY O2\r\n***LECHE DESMAQUILLANTE ESENCIAL PIEL SECA\r\n***LOCION TONIFICANTE ESENCIAL PIEL SECA\r\n***FORMULA DETOX BOLSAS Y OJERAS TIMEXPERT SRNS\r\n***VECTOR LIFT MASTER SERUM DE FIRMEZA TIMEXPERT LIFT IN\r\n***EMULSION OXIGENANTE EXCEL THERAPY O2\r\n***CREMA OXIGENANTE EXCEL THERAPY O2\r\n***CREMA RESTRUCTURANTE TENSE LIFT DE CASMARA\r\n***CREMA  CORPORAL REVITALIZANTE VITAMINA C TIMEXPERT RADIANCE\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('517', 'C-100517', '', 'EVA MARIANA CEDILLO FERNANDEZ', '9931775824', '', ' 19/agosto/17 mdm descontracturante andrea entro 11:10 (mega)\r\n11/nov/17 micro charito entro 12:15 llevo glycocure y crema bolsas y ojeras timexpert SRNS de germaine\r\n18/nov/17 limpieza facial, micro lucy entro 11:10\r\n25/nov/17 micro mary lazaro entro 9:10\r\n2/dic/17 micro cristales susy entro 12:15 llevo bruma solar de germaine\r\n8/dic/17 micro, promocion trat gold mary lazaro entro 10:20\r\n16/dic/17 micro lucy entro 10:10\r\n23/12/17 MICRO CHARITO ENTRO 11:10\r\n29/DIC/17 MICRO PUNTA DE DIAMANTE MARIANA ENTRO 11:10\r\n13/01/18 MICRO PUNTA DE DIAMANTE  Y LIFTING TIME RIDES MARY ENTRO 10:35\r\n27/01/18 LIMPIEZA FACIAL, MICRO PUNTA DE DIAMANTE ANITA ENTRO 11:30\r\n10/FEB/18  MICROCRISTALES LUCY ENTRO 12:30\r\nLLEVO HELIOCARE COMPACTO MEDIO\r\n04/marzo/18 limpieza facial monica entro 6:50 (mega)\r\n19/MARZO/18 MICRO ANITA ENTRO 1:10\r\n06/mayo/18 micro punta de diamante y lifting de colageno candy entro 6:55 (mega)\r\n2/JULIO/18 MICRO DE PUNTA DE DIAMANTE Y LIMPIEZA FACIAL ANITA ENTRO 5:10\r\n2/AGOSTO/18 MICRO CON PUNTA DE DIAMANTE LUPITA ENTRO 3:20\r\n18/agosto/18 limpieza facial monica entro 6:00 (mega)\r\n29/septiembre/18 limpieza facial lupita entro 7:15 (mega)\r\n18/octubre/18 mdm full relax cliente frecuente susy entro 12:10 (mega)\r\n01/noviembre/18 limpieza facial lupita entro 5:05 (mega)\r\n08/noviembre/18 micro punta de diamante susy entro 6:00 (mega)\r\n11/12/18 limpieza facial atendi charito entro 7.15 (mega)\r\n16/ABRIL/19 HYDRAFACIAL OFELIA\r\n4/MAYO/19 INICIA TRATAMIENTO REDUCTIVO COSTO 5,000\r\nLASER LIPOLITICO ROSTRO\r\n1.- CARBOX, L LIPOLITICO 4/MAYO/19 OFELIA\r\n2.- CARBOX, L LIPOLITICO 6/MAYO/19 OFELIA\r\n3.- CARBOX,  L LIPOLITICO 7/MAYO/19 OFELIA\r\n4.- CARBOX, L LIPOLITICO  8/MAYO/19 OFELIA ENTRO 9:15\r\n5.- CARBOX, L LIPOLITICO  9/MAYO/19 OFELIA\r\n6.- CARBOX, L LIPOLITICO 13/MAYO/19 OFELIA\r\n7.- CARBOX, L LIPOLITICO 14/MAYO/19 OFELIA ENTRO 10:00\r\n8.- CARBOX, L LIPOLITICO 21/MAYO /19 OFELIA\r\n9.- CARBOX, L LIPOLITICO 22/MAYO/19 OFELIA\r\n10.- CARBOX, L LIPOLITICO  23/MAYO/19 OFELIA\r\n27/MAYO/19 MDM DE CLIENTE FRECUENTE FULL RELAX MONICA ENTRO 6:30 MEGA\r\n08/JULIO/19 LIMPIEZA FACIAL BASICA SUSY ENTRO 11.00 MEGA\r\n22/sep/19 limpieza facial  2x600 mony entro 1.05 mega\r\n29/MAYO/2020 HYDRAFACIAL LUCY ENTRO 11:55\r\n1/JUNIO/2020 LASER LIPOLITICO EN MEJILLAS OFELIA ENTRO 3:00\r\n11/AGOSTO/2020 MASAJE FULLRELAX  DE CLIENTE FRECUENTE MARIANA  ENTRO 4:45\r\n24/SEPT/2020 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 12:10\r\n6/OCTUBRE/2020 DEPILACION CON CERA DE BIKINI TRADICIONAL MARY LAZARO ENTRO 6:30\r\n14/NOV/2020 DEPILACION BIKINI MARY ENTRO 2:05\r\n12/DICIEMBRE/2020 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 MICRODERMABRASION Y DEPILACION CON CERA DE BIKINI TRADICIONAL MARY LAZARO ENTRO 11:15\r\n08/02/2021 promocion del mes tratamiento peel off atendio rosi suc mega \r\n20/FEB/2021 INICIA DEPILACION LASER DE BIKINI 30MS 10J/100MS 10J OFELIA ENTRO 1:50\r\n27/FEB/2021 INICIA TRATAMIENTO DE CARBOXITERAPIA COSTO 2500.00 PAGADO\r\n1.- CARBOX 27/FEB/2021 MARIANA ENTRO 12:10\r\n2.- CARBOX 1/MARZO/2021 MONICA\r\n3.-CARBOX 2/MARZO/2021 MONICA\r\n4.-CARBOX 4/MARZO/2021 MONICA\r\n5.-CARBOX 5/MARZO/2021 MONICA\r\n6.-CARBOX 8/MARZO/2021 MONICA\r\n7.-CARBOX 13/MARZO/2021 MONICA\r\n8.-CARBOX 16/MARZO/2021 MONICA\r\n9.- CARBOX  20/MARZO/2021 MARIANA\r\n10.- CARBOX 23/MARZO/2021 SRA BEGO\r\n11.- CARBOX 24/MARZO/2021 MARIANA\r\n12.- CARBOX 25/MARZO/2021 MARIANA\r\n13.- CARBOX 26/MARZO/2021 LUCY\r\n14.- CARBOX 29/MARZO/2021 MARIANA\r\n15.- CARBOX 30/MARZO/2021 MONICA\r\n16.- CARBOX 31/MARZO/2021 ANITA ENTRO 3:35\r\n17.- CARBOX 1/ABRIL/2021 MONICA ENTRO 9:00\r\n18.- CARBOX 6/ABRIL/2021 MONICA ENTRO 9:20\r\n19.- CARBOX 9/ABRIL/2021 ANITA ENTRO 9:45\r\n20.- CARBOX 12/ABRIL/2021 LUCY  ENTRO 9:10\r\n\r\nINICIA TRATAMIENTO DE MASAJE REDUCTIVO $3500.00 ABONO $1750.00 RESTA $1750.00\r\n1.-MASAJE 45 M 1/MARZO/2021 MONICA ENTRO 9:00\r\n2.-MASAJE 45 M 2/MARZO/2021 MONICA ENTRO 9:15\r\n3.-MASAJE 45 M 4/MARZO/2021 MONICA ENTRO 9:05\r\n4.-MASAJE 45 M 5/MARZO/2021 MONICA ENTRO 9:15\r\n5.-MASAJE 45 M 8/MARZO/2021 MONICA ENTRO 9:10\r\n6.-MASAJE 45 M 13/MARZO/2021 MONICA ENTRO 8:20\r\n7.-MASAJE 45 M 16/MARZO/2021 MONICA ENTRO 9:15\r\n8.-MASAJE 45 M 29/MARZO/2021 MONICA ENTRO 9:25\r\n9.-MASAJE 45 M 1/abril/2021 MONICA ENTRO 9:00\r\n10.-MASAJE 54 M 6/ABRIL/2021 MONICA 9:20\r\nTERMINO TRATAMIENTO REDUCTIVO.\r\n1/ABRIL/2021 PROMOCION TRAT. VIT C  MONICA ENTRO 10:00\r\n29/JUNIO/2021 MASAJE FULL RELAX CTE FTE MONICA ENTRO 9:05 MEGA\r\n31/JULIO/2021 LIMPIEZA FACIAL  MIRENA ENTRO 8:15\r\n31/JULIO/2021 2DA BIKINI 30MS 10J MARY LAZARO\r\n16/OCT/2021 LIMPIEZA FACIAL 2X600 MONICA ENTRO 12:00 MEGA\r\n21/DIC/2021 LIMPIEZA FACIAL 2X600 ANITA ENTRO 14:01 MEGA\r\n7/ENERO/2022 3RA. BIKINI AUT 10J/ENTRE LABIOS 100MS 11J LUCY\r\n7/ENERO/2022 LIMPIEZA FACIAL 2 X 600 JHOANY ENTRO 9:10\r\n7/ENERO/2022 CARBOX, 2 DISPAROS DE LIPOSONIC EN ABDOMEN LUCY \r\n21/MAYO/2022 CARBOXITERAPIA JOHANY ENTRO 3:15\r\n26/AGOSTO/2022 RETOQUE DE AXILA 30 MS 10 J LUCY\r\n26/AGOSTO/2022 4TA. BIKINI AUTOM. 10 J/ENTRE LABIOS 100 MS 11 J LUCY \r\n26/AGOSTO/2022 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600, CARBOX LUCY ENTRO \r\n15/OCRUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA, CARBOXITERAPIA MARY LAZARO ENTRO 10:00\r\n15/OCTUBRE/2022 LASER BIKINI AUT 10J MARY LAZARO', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-15 10:09:38', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('518', 'C-100518', '', 'KARLA TORRES IZQUIERDO', '9931601221', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('519', 'C-100519', '', 'DORIS VENTURA LEYVA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('520', 'C-100520', '', 'SILVIA ELIZABETH COLLI BORGUES', '19161037957', '', '14/marzo/16 carbo mariana entro 10:20\r\n22/marzo/16 carbo mariana entro 9:40\r\n31/marzo/16 carbox lucy entro 12.15\r\n15/abril/16 carbox reyna entro 12:50\r\n6/mayo/16 carbox mary lázaro entro 10:20\r\n12/mayo/16 carbox susy entro 2.15 (mega)\r\n1/ABRIL/2022 CARBOX MARIANA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('521', 'C-100521', '', 'MILAGROS MORALES CASTILLO', '9381248548', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('522', 'C-100522', '', 'VICENTE MOLINA MARTINEZ', '9381373189', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('523', 'C-100523', '', 'JORGE ROVIROSA TORRES', '9931070326', '', '29/JUNIO/18 LIMPIEZA FACIAL 2 X 600 Y LIMPIEZA DE ESPALDA  SUSY ENTRO 2:55\r\n14/JULIO/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARY LAZARO ENTRO 3:00\r\n1.- 28/JULIO/2020 RADIO 20 MIN  GASA CON GEL CRIOGENICO ANITA $500.00\r\n2.- 29/JULIO/2020  CARBOX, LASER LIPOLITICO LUCY ENTRO 11:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('524', 'C-100524', '', 'FLORENTINA LEON DE DIOS', '9141057448', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('525', 'C-100525', '', 'AMPARO JIMENEZ VELAZCO', '9931323778', '', '12/feb/11 delineado de cejas, se le dio $100.00 pesos a ofelia \r\n26/feb/11 retoque de cejas, se le dio $100.00 pesos a ofelia\r\n2/abril/11 promocion vinoterapia susy entro 12:30 \r\n27/agosto/11 promocion piel de seda lucy \r\n21/sep/11 limpieza con ampolleta desincrustante brenda entro 5:35\r\n26/nov/11 hydracure karina entro 1:10\r\n28/nov/11 radiofrecuencia facial reyna entro 5:15\r\n12/dic/11 radiofrecuencia araceli entro 5:00\r\n21/dic/11 radiofrecuencia lucy entro 9:15\r\n28/dic/11 radiofrecuencia sara entro 9:00\r\n11/ene/12 radiofrecuencia aracely entro 9:10\r\n25/ene/12 radiofrecuencia lucy entro 5:00\r\n4/feb/12 radiofrecuencia reyna entro 11:40\r\n11/feb/12 radiofrecuencia gladys entro 10:10\r\n25/feb/12 timexpert lift sara entro 11:25\r\n3/marzo/12 timexpert lift reyna entro 1:40\r\n5/marzo/12 rll sng juved up 5 m, txb ec pg 34 u 5 m dr. oscar\r\n10/nov/12 promocion de colageno ofelia entro 1:00\r\n17/dic/12 promocion de oro araceli entro 9:30 llevo tonico ceutical, crema so-delicate piel normal\r\n21/ene/13 facial lift therapy de atache ofe entro 10:30\r\n12/oct/13 promocion the verde graciela entro 9:50\r\n19/oct/13  delineado de cejas ofelia entro 12:15\r\n31/oct/13 limpieza facial con amp. desincrustante mirena entro 5:00\r\n06/12/13 promocion de mes diciembre atendio jhoany mega entro 1:00\r\n9/dic/13 criolipolisis en abdomen mariana entro 8:30\r\n9/dic/13 llevo crema timexpert rides x-cel\r\n7/ene/14 promocion desintoxicante reyna entro 2:00 llevo crema hidratante no estres, espuma\r\npurificante, fluido piel grasa\r\n10/ene/14 criolipolisis en abdomen nelli entro 6:10\r\n1/marzo/14 criolipolisis en abdomen nelli entro 2:00\r\n29/marzo/14 criolipólisis en abdomen carmen entro 12:15\r\n29marzo/14 prom. humectante carmen entro 1:00\r\n26/abril/14 promocion lim. de porcelana rosy entro 1:00\r\n3/mayo/14 criolipolisis en abdomen mariana entro 10:20\r\n9/junio/14 criolipolisis en abdomen nelli entro 6:30\r\n11/julio/14 criolipolisis en abdomen reyna entro 5:20\r\ninicia ipl $1000.00 c/s\r\n4/sep/14 1ra. ipl prog. 2 int. 3 reyna entro 10:50\r\ndejo pagada una sesion de criolipolisis\r\n5/sep/14 criolipolisis carmen entro 9:00\r\n3/oct/14 2da. ipl prog. 2 int. 5 reyna llevo espuma purificante, fluido exfoliante piel grasa, \r\ngel-crema hidro-matificante purexpert\r\n 6/oct/14 criolipolisis en abdomen carmen entro 5:15\r\n17/nov/14 3ra. ipl prog. 2 int. 4 ofelia entro 12:10\r\n18/nov/14 criolipolisis brenda entro 4:20\r\n16/dic/14 criolipolisis abdomen ana entro 9:15\r\n23/dic/14 promocion global antiedad mirena entro 8:15\r\n6/enero/15 promocion trat. desintoxicante y oxigenante brenda 2:30\r\n14/sep/15 promocion equilibrante del ph eva entro 6:00\r\n17/dic/15 promocion reafirmante modeladora reyna entro 8:20\r\n29/dic/15 promocion reafirmante modeladora ofelia entro 11:15\r\n29/dic/15 llevo crema textura ligera timexpert rides y contorno de ojos timexpert lift\r\n17/marzo/16 promocion hidrante charito entro 10:25\r\n19/julio/16 limpieza facial con amp. desicnrustante maria entró 6:05\r\n4/agosto/16 promoción de caviar susy entro 5:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('526', 'C-100526', '', 'MARISOL ALCOCER AGUILAR', '9931334056', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('527', 'C-100527', '', 'CYNTHIA PARIZOT WOLTER', '9331111520', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('528', 'C-100528', '', 'SANDARA CABRERA CABRALES', '9932137788', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('529', 'C-100529', '', 'DAMARIS JIMENEZ GARDUZA', '9171133722', '', '1-sept-15 promocion equilibrante del ph ofelia entro 11:00\r\n16/oct/15 promocion reafirmante ofelia entro 11:30\r\n26/oct/15 rellen sng juv $6000.00 y botox 1/3 sup 35u $5000.00 dr. oscar garcia\r\n9/nov/15 promocion antiedad humectante y nutritivo ofelia entro 11.10\r\n7/dic/15 promocion reafirmante ofelia entro 11:20\r\n4/ene/16 promocion desintoxicante ofelia entro 10.35\r\n4/ene/16 llevo crema correcion lineas/arrugas de timexpert rides \r\n1/feb/16 promocion roll & lift ofelia entro 11.10 llevo heliocare color light\r\n1/marzo/16 promocion hidratante ofelia entro 11_15\r\n4/abril/16 promocion trat luxury ofelia entro 11:45\r\n2/mayo/16 promocion del meas mdm holistico y facial con liftin#2 ofelia/Reyna entro 11.20\r\n2/mayo/16 llevo crema correccion lineas/arrugas timexpert rides textura rica\r\n6/junio/16 promocion de elastine ofelia entro 9:30\r\n4/julio/16 promocion de colageno ofelia entro 11:45\r\n01/agosto16 promocidon de caviar ofelia entro 11:\r\n 1/agosto/16 llevo reafirmante contorno de ojos y labios de essential shock y crema correcion lineas/Arrugas textura rica de timexpert rides\r\n5/sept/16 promocion colageno ofelia entro 11:20 llevo crema correccion lineas/arrugas textura rica timexpert rides\r\n05/10/16 promocion del mes atendio ofelia entro 2.10 \r\n24/oct/16 rell sng $7000.00 y txb 1/3 sup $6000.00 dr. oscar garcia \r\n1/noct/16 promocion oxigenante ofelia entro 11:15\r\n1/dic/16 promocion multivitaminico ofelia entro 11:30\r\n2/ene/16 promocion trat desintoxicante ofelia entro 10:40 \r\n6/feb/17 promocion trat de elastina y dep de bigote ofelia entro 11:05\r\n3/marzo/17 promocion estimulante de colageno con luz leed ofelia entro 9:05\r\n28/marzo/17 promocion estimulante de colageno con luz leds ofelia entro 11:25 llevo crema correccion lineas textura rica timexpert rides\r\n24/abril/17 promocion termico ofelia entro 11:20\r\n12/junio/17 promocion antioxidante ofelia entro 11:30\r\n3/julio/17 promocion relajante e hidratante ofelia entro 11:25\r\n24/julio/17  llevo crema correccion lineas textura rica timexpert rides\r\n8/agosto/17 promocion desvanece las lineas del tiempo ofelia entro 11:10\r\n12/sept/17 promocion resveratrol ofelia entro 11.-30\r\nLLEVO CREMA CORRECCION LINEAS TEXTURA LIGERA DE TIMPER RIDES \r\n9/oct/17 promocion reafirmante ofelia entro 11:15\r\n13/nov/17 promocion termico-humectante ofelia entro 12:00\r\n28/nov/17 botox y relleno dr. oscar\r\n4/dic/17 promocion trat gold ofelia entro 11:35 llevo crema textura rica timexpert rides\r\n08/01/18 PROM TRATAMIENTO OXIGENANTE OFE ENTRO 11:40\r\n29/01/18 LLEVO CREMA TEXTURA RICA TIMEXPERT\r\n05/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO OFELIA ENTRÓ 11:35\r\n02/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA OFELIA ENTRO 9:30\r\n9/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE, MDM CLIENTE FRECUENTE FULL RELAX OFELIA ENTRO 11:25\r\n7/MAYO/18 PROM TRATAMIENTO ANTIEDAD OFELIA ENTRO 11:30\r\n7/MAYO/18    LLEVO CREMA TIMEXPERT RIDES \r\n4/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE OFELIA ENTRO 11:25\r\n2/JULIO/18 PROM TRATAMIENTO FACIAL CON RETINOL OFE ENTRO 11:20\r\n6/AGOSTO/18  PROM TRATAMIENTO FACIAL HUMECTANTE  OFELIA ENTRO 11:25\r\n22/AGOSTO/18 LLEVO CREMA TIMEXPERT RIDES  TEXTURA RICA\r\n3/SEP/18 PROM TRATAMIENTO FACIAL REGENERANTE OFELIA\r\n3/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE,MDM DE CLIENTE FRETE  OFELIA\r\n26/OCT/18 T X B 1/3 SUP BOTOX, CK1 CK3 VOLUMA 1 ML  DR OSCAR\r\n10/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE OFELIA ENTRO 12:35\r\n14/ENE/19 PROM TRATAMIENTO FACIAL REVITALIZANTE OFELIA ENTRO 11:30\r\n11/FEB/19 PROMOCION REAFIRMANTE OFELIA ENTRO 12:00\r\n1/MARZO/19 CREMA TIMEXPERT RIDES TEXTURA RICA\r\n4/MARZO/19 PROM TRATAMIENTO FACIAL DETOX  OFELIA\r\n15/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE OFELIA\r\n6/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX OFELIA\r\nLLEVO CREMA TIMEXPERT RIDES ARRUGAS  xcel 1,785\r\n3/MAYO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO  OFELIA ENTRO 11:15\r\n1/JULIO/19 PEOM TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO OFELIA ENTRO 11:35 Y LLEVO CREMA TIMEXPERT IN TEXTURA RICA\r\n5/AGOSTO/19 PROMOCION PORCELANA OFELIA ENTRO 11:20\r\n2/SEP/19 TRATAMIENTO FACIAL OXIGENANTE OFELIA ENTRO 11:00\r\nLLEVO CREMA TIMEXPERT RIDES TEXTURA RICA\r\n7/OCT/19 MASAJE FULL RELAX CLIENTE FRECUENTE, PROMOCION DOBLE ACCION OFELIA ENTRO 11:00\r\n4/NOV/19 PROMOCION TRAT DE PERLA OFELIA ENTRO 11:05 LLEVO CREMA TEXTURA RICA TIMEXPERT RIDES\r\n2/DICIEMBRE/19 TRATAMIENTO FACIAL 24K OFELIA\r\n6/ENERO/20 PROMOCION TRAT DESINTOXICANTE OFELIA ENTRO 12:00\r\n3/FEB/2020 PROMOCION TRAT 4 F OFELIA ENTRO 11:10\r\n21/FEBRERO/20 LLEVO CREMA TIMEXPERT RIDES TEXTURA RICA\r\n2/MARZO/2020 PROMOCION TRAT REGENERADOR OFELIA ENTRO 11:10\r\n2/JUNIO/2020 LLEVO CREMA TIMEXPERT RIDES TEXTURA RICA\r\n7/SEPTIEMBRE/2020 LLEVO CREMA TIMEXPERT RIDES TEXTURA RICA\r\n28/OCTUBRE/2020 LLEVO CREMA TIMEXPERT RIDES TEXTURA RICA\r\n10/NOV/2020 PROMOCION TRAT BOTANICO+AMP. DE OXIGENO DE NATURA BISSE, DEPILACION LASER DE BIGOTE 30 MS 11 J OFELIA ENTRO 11:45\r\n7/DICIEMBRE/2020 TRATAMIENTO FACIAL DE PORCELANA OFELIA \r\n5/MARZO/2021 PROMOCION TRAT. ACIDO HIALURONICO OFELIA ENTRO 10:00 LLEVO CREMA TIMEXPERT RICH\r\n12/ABRIL/2021 PROM. TRATAMIENTO FACIAL VITAMINA C OFELIA ENTRO 8:55\r\n5/JULIO/2021 PROMOCION TRATAMIENTO CAVIAR Y ORO OFELIA ENTRO 10:15 \r\n2/AGOSTO/2021 PROMOCION TRAT ORGANICO REVITALIZANTE OFELIA ENTRO 10:00 \r\n3/AGOSTO/2021 ABONO $1500.00 DEL PACK TIMEXPERT IN\r\n6/SEPT/2021 PROMOCION ISOFLAVONAS DE SOYA OFELIA ENTRO 10:50\r\n18/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD OFELIA ENTRO 11:30\r\n6/DIC/2021 PROMOCION TRAT FACE PURE OFELIA ENTRO 11:00 LLEVO CREMA RICH TIMEXPERT RIDES\r\n10/ENERO/2022 PROMOCION TRAT DETOX OFELIA ENTRO 11:00\r\n7/FEB/2022 PROMOCION AGE DEFENSE OFELIA ENTRO 11:35 LLEVO CREMA TIMEXPERT RIDES RICH\r\n7/MARZO/2022 PROMOCION TRAT SHOCK DE COLAGENO OFELIA ENTRO 11:30\r\n11/MARZO/2022 MASAJE DE CLIENTE FRECUENTE, PROM. TRATAMIENTO FACIAL CINETICO OFELIA **LLEVO CREMA TIMEXPERT RIDES RICH**\r\n2/MAYO/2022 PROMOCION TRAT FITOHIDRATANTE OFELIA ENTRO 9:40\r\n9/JUNIO/2022 PROMOCION TRAT YOGA FACIAL OFELIA ENTRO 11:15\r\n8/JULIO/2022 PROMOCION TRAT ROLL & LIFT, DEPILACION DE BIGOTE CON CERA OFELIA \r\n12/AGOSTO/2022 PROMOCION TRAT ANTIOXIDANTE OFELIA ENTRO 10:45 LLEVO CREMA TIMEXPERT RIDES RICH\r\n2/SEPTIEMBRE/2022 PROM. TRATAMIENTO FACIAL PREVENTIVO DE MANCHAS OFELIA ENTRO 10:30\r\n7/OCTUBRE/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA ENTRO 11:00\r\n*****LLEVO CREMA GLOBAL RICH TIMEXPERT RIDES******\r\n9/NOVIEMBRE/2022 PROMOCION TRAT. REPARADOR CELULAR OFELIA ENTRO 10:40\r\n7/DICIEMBRE/2022 PROMOCION TRAT. FACIAL GOLDEN OFELIA ENTRO 10:45 LLEVO CREMA RICH TIMEXPERT RIDES \r\n4/ENERO/2023 PROMO TRATAMIENTO FACIAL PURIFICANTE OFELIA ENTRO 9:00\r\n8/FEBRERO/2023 PROMOCION TRAT. FACIAL ELIXIR DE JUVENTUD OFELIA ENTRO 10:45 LLEVO CREMA TIMEXPERT RIDES RICH\r\n8/MARZO/2023 PROMO TRATAMIENTO FACIAL MICRODERMA OFELIA ENTRO 11:15\r\n3/ABRIL/2023 MASAJE DE CLIENTE FRECUENTE Y PROMO TRATAMIENTO FACIAL PLASMA MARINO OFELIA ENTRO 9:25\r\n3/MAYO/2023 PROMOCION TRAT. FACIAL MAGIC FACE OFELIA ENTRO 11:00 LLEVO CREMA TIMEXPERT RICH PACK DE PROMOCION DE REGALO CONTORNO DE OJOS EXCEL THERAPY O2\r\n1/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND OFELIA ENTRO 9:00 LLEVO DISCOS CON TONICO HIDRATANTE DE IROHA\r\n5/JULIO/2023 PROMOCION TRAT. FACIAL COOPING OFELIA ENTRO 11:00 LLEVO CREMA GLOBAL ARRUGAS RICH TIMEXPERT RIDES', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-05 15:40:08', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('530', 'C-100530', '', 'DENNIS RAMOS PADILLA', '932644195', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('531', 'C-100531', '', 'FABIOLA MOSCOSO SIBILLA', '9932776275', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('532', 'C-100532', '', 'VIRIDIANA MAY VILLEGAS', '9931087262', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('533', 'C-100533', '', 'MARTIN MENDEZ MONDRAGON', '9171010112', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('534', 'C-100534', '', 'JORGE LUIS VAZQUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('535', 'C-100535', '', 'TAMARA RAMON DOMINGUEZ', '9932771132', '', '2/ene/16 limpieza facial con amp, desincrustante lizvet entro 12.00\r\n23/ene/16 promocion desintoxicante lizvet entro 11.15\r\n18/mayo/17 limpieza facial yennifer entro 5:55\r\n13/junio/17 limpieza facial mariana entro 11:00\r\n19/JULIO/19 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIA DEL C ALEGRIA ENTRO 6:00\r\n24/NOVIEMBRE/19 LIMPIEZA FACIAL PROFUNDA SANDY ENTRO 10:53 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('536', 'C-100536', '', 'MARIA DEL PILAR HUERTA RUIZ', '9934452423', '', '18/FEB/2021 MASAJE DESCONTRACTURANTE YOANA ENTRO 10:55\r\n23/FEB/2021 MASAJE DESCONTRACTURANTE YOANA \r\n8/NOV/2021***********INICA DEPILACION LASER CARA COMPLETA***************\r\n8/NOV/2021 1° DEPILACION LASER CARA COMPLETA 30ms 11J MARY LAZARO ENTRO 10:00\r\n10/NOVIEMBRE/2021  PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO MARIANA ENTRO 9:55\r\n8/DIC/2021 2DA. CARA COMPLETA AUTOM. 12 J OFELIA\r\n17/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE OFELIA ENTRO  10:55\r\nLLEVO CREMA ROYAL JELLY EXTREME\r\n10/ENERO/2022 3RA. CARA COMPLETA AUTOM. 14 J OFELIA\r\n10/FEB/2022 4TA. CARA COMPLETA AUTOM. 17 J OFELIA\r\n10/MARZO/2022 5TA CARA COMPLETA AUT 18J OFELIA\r\n31/MAYO/2022 6TA. CARA COMPLETA AUTOM. 17 J OFELIA\r\n6/JUNIO/2022 PROMOCION TRAT YOGA FACIAL OFELIA ENTRO 1:00\r\n3/AGOSTO/2022 8ª CARA COMPLETA AUT 15J OFELIA\r\n10/OCTUBRE/2022 LIMPIEZA FACIAL 2X600 OFELIA ENTRO 4:05\r\n14/ABRIL/2023 PROMOCION DEL MES TRATAMIENTO PLASMA MARINO ROSY ENTRO 6;00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-04-14 11:57:20', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('537', 'C-100537', '', 'GERARDO ARIAS MOGUEL', '9931160603', '', '13/marzo/17 limpieza facial 2x600 con amp. desincrustante candy entro 11:05 (mega)\r\n27/sept/17 limpieza facial 2x600 con amp. desincrustante carmen entro 10:55 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('538', 'C-100538', '', 'MARIA DE LOURDES RODRIGUEZ PACHECO', '9931369316', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('539', 'C-100539', '', 'DEBBY GONZALEZ LOPEZ', '9931369316', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('540', 'C-100540', '', 'ELIZABETH SANTANA SAMANIEGO', '9931783358', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('541', 'C-100541', '', 'MARIA LUISA MARTINEZ RODRIGUEZ', '9363610274', '', '19-sept-15 masaje sensorelax, facial completo mary lazaro entro 10:40\r\n14/nov/15 masaje sensorelax, facial completo mariana entro 10:20\r\n21/dic/15 masaje sensorelax, facial completo mariana entro 11.00\r\n19/ene/16 masaje sensorelax. facial completo mariana entro 11:00\r\n20/feb/16 masaje sensorelax mariana entro 11:00\r\n20/feb/16 facial completo mary lazaro entro 12:30\r\n18/marzo/16 mdm sensorelax y facial completo mariana entro 10.30\r\n16/abril/16 mdm sensorelax(cliente frecuente) y facial completo mariana entro 10.55\r\n15/junio/16 masaje sensorelax y facial completo mariana entro 10.50\r\n21/julio/16 masaje full relax y promocion de colageno mary lazaor entro 10:45\r\n10/sept/16 masaje sensorelax y facial completo mary lázaro entro 10:30\r\n15/oct/16 masaje sensorelax y facial completa mariana entro 10:35\r\n26/nov/16 masaje sensorelax y facial completo mariana entro 10:35\r\n23/dic/16 masaje sensorelax y facial completo mariana entro 11:15\r\n21/ene/17 masaje sensorelax y facial completo rosy entro 11:45\r\n25/feb/17 masaje descontracturante y facial completo con micro rosy entro 10.35\r\n25/marzo/17 mdm descontracturante, facial completo con micro rosy entro 11:05\r\n19/abril/17 facial completo mary lazaro entro 12:00\r\n20/mayo/17 mdm sensorelax, facial vitamina C de natura bisse rosy entro 10:40\r\n26/julio/17 mdm sensorelax , promocion trat relajante e hidratante anita entro 11.55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('542', 'C-100542', '', 'KELI BOCANEGRA MARTINEZ', '', '', '23/dic/16 masaje fullr elax y promocion tratt multivitaminico charito entro 11.15\r\n19/abril/17 mdm full relax monica entro 12:00\r\n19/abril/17 facial hydracure carmen entro 1:10\r\n26/julio/17 promocion trat relajante e hidratante y mdm sensorelax mary lazaro entro 11:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('543', 'C-100543', '', 'VIVIAN PADRON SOTO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('544', 'C-100544', '', 'ADELAIDA GARCIA RUIZ', '9933082754', '', '02-09-15 SE REALIZO PROM DEL MES ENTRO 12-15 CANDY CRISTAL \r\n9/mayo/17 promocion antiedad con lifting mariana entro 12:15\r\ninicia tratamiento reductivo de $3000.00 pesos pago $3000.00 pesos con medidas de a.91 b.100 c.92 ca.100 cb.102 b.30 m.57 y peso de 59 kg.\r\n1.- masaje 45 min 03/julio/17 candy entro 5:00 (mega)\r\n2.- masaje 45 min 04/julio/17 lizbeth entro 5:05 (mega)\r\n3.- masaje 45 min 05/julio/17 carmen entro 12:05 (mega)\r\n4.- masaje 45 min 06/julio/17 lizbeth entro 5:05 (mega)\r\n5.- masaje 45 min 07/julio/17 lizbeth entro 5:05 (mega)\r\n6.- masaje 45 min 10/julio/17 charito entro 5:05 (mega)\r\n7.- masaje 45 min 11/julio/17 andrea entro 5:05 (mega)\r\n8.- masaje 45 min 12/julio/17 andrea entro 2.05 (mega)\r\n9.- masaje 45 min 13/julio/17 andrea entro 5:00 (mega)\r\n10.- masaje 45 min 14/julio/17 andrea entro 2:15 (mega)\r\nTermino tratamiento reductivo con medidas de a.87 b.100 c.85 ca.100 cb.102 b.29 m.53 y peso \r\nde 58 kg\r\n11/agosto/17 promocion del mes desvanece las lineas del tiempo charito entro 10:20 (mega)\r\n9/dic/17 promocion trat gold anita entro 10:15\r\n16/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA MARY ENTRO 12:45\r\n29/mayo/18 inicio tratamiento de vendas calientes pago total de 3000.00\r\n1.- vendas calientes 29/mayo/18 candy entro 5:30 (mega)\r\n2.- v. frias 30/mayo/18 charito entro 6:50 (mega)\r\n3.- v. calientes 31/mayo/18 charito entro 5:20 (mega)\r\n4.- v. frias 01/junio/18 candy entro 5:30 (mega)\r\n5.- v. calientes 04/junio/18 candy entro 5:15 (mega)\r\n6.- v. frias 05/junio/18 candy entro 5:20 (mega)\r\n7.- v. calientes 06/junio/18 candy entro 5:20 (mega)\r\n8.- v. calientes 11/junio/18 candy entro 5:15 (mega)\r\n9.- v. calientes 12/junio/18 charito entro 5:15 (mega)\r\n10.- v. calientes 13/junio/18 candy entro 5:20 (mega)\r\n14/junio/18 limpieza facial 2x600 candy entro 5:05 (mega)\r\n03/julio/18 mdm full relax cliente frecuente charito entro 3:05 (mega)\r\n20/FEBRERO/19 PROM TRATAMIENTO FACIAL REAFIRMANTE SUSI ENTRO 7.10\r\n21/marzo/19 tratamiento reafirmante detox susy entro 3:00 mega\r\n11/ABRIL/19 PROMOCION DEL MES ROSY ENTRO 2.00 MEGA\r\n09/MAYO/19 promocion del mes susy entro 2:10 mega\r\n09/JULIO/19 INICIO MASAJE CORPO.DE VENDAS FRIAS PAGADO\r\n1.- V. FRIAS 09/JULIO/19 MONY ENTRO 4:25 MEGA\r\n2.- V. CALIENTES 10/JULIO/19 SUSY ENTRO 4.10 MEGA\r\n3.- V. FRIAS 11/julio/19 mony entro 4:10 mega\r\n4.- V.CALIENTES 12/JULIO/19 MONY ENTRO 4:05\r\n5.- V.FRIAS 13/JULIO/19 MONY ENTRO 11:05 MEGA\r\n6.- V.CALIENTES 15/julio/19 mony entro 4.10 mega\r\n7.- V.FRIAS 16/JULIO/19 SUSY ENTRO 4:05 MEGA\r\n8.- V.CALIENTES 17/J7ULIO/19 SUSY ENTRO 4.05 (MEGA)\r\n9.- V.FRIAS 18/julio/19 mony entro 1:10 mega\r\n10.-V.CALIENTES 19julio/19 rosy entro 1:00 mega TERMINO SU TRATAMIENTO  DE VENDAS FRIAS\r\n19/SEP/19 PROM DEL MES TRATAMIENTO OXIGENANTE JANETH ENTRO 3:00 MEGA\r\n16/NOVIEMBRE/19 TRATAMIENTO DE PERLAS JANETH ENTRO 2:10 MEGA\r\n28/ENERO/2020 MDM FULL RELAX  C/F SUSI ENTRO 11:11 MEGA\r\n28/JULIO/2022 LLEVO DABALASH\r\n22/OCT/2020 PROMOCION TRAT GOLD REGENERANTE ANITA ENTRO 12:00\r\n17/12/2020 promoción del mes tratamiento de porcelana aatendio rosi suc mega \r\n21/ENERO/2021 PROMOCION ANTIPOLUCION MONICA ENTRO 1:00\r\n5/ABRIL/2021 LLEVO CREMA TENSO REAFIRMANTE CUELLO Y ESCOTE TIMEXPERT LIFT Y CREMA GLOBAL SOFT TIMEXPERT RIDES\r\n31/03/2021 promoción del mes tratamiento acido hialuronico atendio rosy suc mega \r\n6/MAYO/2021 PROMOCION DE CELULAS MADRE ANITA ENTRO 10:00\r\n17/JUNIO/2021 PROMO. TRAT. RETINOL ARLETH ENTRO 14:06 MEGA\r\n21/OCT/2021 PROMOCION TRATAMIENTO ORGANICO CBD MARY LAZARO ENTRO 1:02\r\n25/OCTUBRE/2021  INICIA TRATAMIENTO REDUCTIVO DE VENDAS CALIENTES COSTO 3500.00 PAGADO\r\n1.-  VENDAS CALIENTES 25/OCTUBRE/2021 JOHANY ENTRO 5:00\r\n2.- VENDAS CALIENTES 26/OCT/2021 JHOANA ENTRO 4:58\r\n3.- VENDAS FRIAS 27/OCT/2021 JHOANA ENTRO 6:08 \r\n4.- VENDAS FRIAS 28/OCTUBRE/2021 JOHANY ENTRO 5:15\r\n5.- VENDAS CALIENTES 29/OCT/2021 JHOANA ENTRO 5:59 \r\n6.- VENDAS FRIAS 1/NOVIEMBRE/2021 JOHANY ENTRO 1:00\r\n7.- VENDAS CALIENTES 3/NOVIEMBRE/2021 LUCY ENTRO 12:00\r\n8.- VENDAD FRIAS 4/NOVIEMBRE/2021 MARIANA ENTRO 2:00\r\n9.- VENDAS CALIENTES 5/NOVIEMBRE/2021 MIRENA ENTRO 1:00\r\n10.- VENDAS FRIAS 8/NOVIEMBRE/2021 JOHANY EN TRO 5:00\r\n12/FEB/2022 PROMO. TRAT. AGE DEFENSE ROSI ENTRO 12:57 MEGA\r\n25/MAYO/2022 PROMOCION TRAT FITO HIDRATANTE JHOANY ENTRO 1:10\r\n****LLEVO CREMA GLOBAL ARRUGAS SUPREME TIMEXPERT RIDES****\r\n30/JUNIO/2022 PROM. TRATAMIENTO YOGA FACIAL MARIANA ENTRO 12:00\r\n30/JUNIO/2022 PROM. TRATAMIENTO YOGA FACIAL MARIANA ENTRO 12:00\r\n*****17/ENERO/2023 INICIA PAQUETE DE MASAJE REDUCTIVO ALTERNADO CON VENDAS FRIAS \r\n            PAGO 4000 PESOS.\r\n1.- MASAJE 45 M 17/ENERO/2023 MONICA ENTRO 4:00 (MEGA)\r\n2.- VF 45 M 18/ENERO/2023 MONICA ENTRO 4:15 (MEGA)\r\n3.- MASAJE 45 M 19/ENERO/2023 MONICA ENTRO 4:05 (MEGA)\r\n4. - VF 45M 23/ ENERO/2023 MONICA ENTRO 4:05 (MEGA)\r\n5.- MASAJE 45M 20/ENERO/2023 MONICA ENTRO 4:05 (MEGA)\r\n6.- VF 45M ****MASAJE 45M*** 26/ENERO /2023 MONICA ENTRO 4:05 (MEGA) **** LASEÑORITA \r\n        CAMBIO LAS VENDAS FRIAS  POR MASAJE**************************\r\n7.-MASAJE 45 M 24/ENERO/2023 MONICA ENTRO 4:10 (MEGA)\r\n8.-MASAJE 45 MIN 30/ENERO/2023 MONICA ENTRO 5:08 (MEGA)\r\n9.-MASAJE 45 M 25/ENERO/2023 MONICA ENTRO 4:00 (MEGA)\r\n10.- MASAJE 45 MIN 02/FEBRERO/2023 MONICA ENRO 4:10 (MEGA)\r\n++++++++++TERMINO TRATAMIENTO REDUCTIVO 02/FEBRERO/2023\r\n***************************************************************************\r\n20/ENERO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL PURIFICANTE Y AMPOLLETA  DE ACIDO HIALURONICO MONICA ENTRO 5:00 \r\n23/MARZO/2023 PROMO TRATAMIENTO FACIAL MICRODERMA SRA BEGO ENTRO 4:05\r\nLLEVO SERUM DE CAVIAR Y CREMA CAVIAR DE AINHOA\r\n11/MAY0/2023 PROMOCION DEL MES TRATAMIENTO FACIAL MAGIC FACE SUSY ENTRO 2:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-31 15:35:39', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('545', 'C-100545', '', 'KARLA SANCHEZ GONZALEZ', '9931938367', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('546', 'C-100546', '', 'MARIELA RIOS SUAREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('547', 'C-100547', '', 'ARTURO CARBAJAL GOMEZ', '9932196612', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('548', 'C-100548', '', 'JUAN CARLOS VAZQUEZ GOMEZ', '9932196612', '', '21/JUNIO/18 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY ENTRO 1:35', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('549', 'C-100549', '', 'HEYDI RICA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('550', 'C-100550', '', 'CRISTEL PEREZ AREVALO', '9932773865', '', '14/feb/11 mdm drenaje linfatico jhoany entro 7:20 salio 8:30 (sucursal) \r\ninicia tratamiento de cavitacion $4000.00\r\nmedida en cintura (pancita) 93 cm peso 71 1/2 kg llevo trat. # 1 \r\n1.-cavitacion 40 m, masaje 45 m 28/feb/12 aracely\r\n2.-carbox, masaje 45 m 29/feb/12 aracely entro 9:10\r\n3.-masaje 45 m, g-5 10 m 1/marzo/12 lucy entro 10:00\r\n4.-carbo, masaje 45 m 2/marzo/12 reyna entro 9:30\r\n5.-cavitacion 40 m, masaje 45 m 3/marzo/12 reyna \r\n6.-masaje 45 m, g-5 20 m 6/marzo/12 rosy entro 9:25\r\n7.-carbo, masaje 45 m 9/marzo/12 aracely entro 10:10\r\n8.-masaje 45 m, g-5 10 m 12/marzo/12 aracely entro 9:50\r\n9.-cavitacion 40 m, masaje 45 m 13/marzo/12 aracely entro 9:20\r\n10.-carbo, masaje 45 m 16/marzo/12 aracely\r\ntermino tratamiento con medidas en cintura (pancita) 87 cm  peso 70 kilos \r\ndepilacion laser de bigote $180.00 c/s menton $180.00 c/s\r\n1.-28/feb/12 bigote, menton 30 ms 10 j rosy \r\n16/marzo/12 llevo trat. # 2 peso 70 kilos\r\n03/04/12 trat # 2 peso 67kg ella quiso el trat dos (cortesia).sra. bego.\r\n14/05/12 peso 68kg la peso la señora bego \r\n20/06/2012 prom. del mes atendio brenda entro 6:17 ( mega)\r\n29/11/12 mdm y lim. facial atendio diana entro 7:15 mega\r\n23/dic/14 mdm full relax nelly entro 5:58 (mega)\r\n28/mayo/15 prom. del mes trata. catiodermia con amp. desincrustante rosy entro 4:10 (mega)\r\n23/noviembre/15 mdm full relax maribel entro 6:00 (mega)\r\n31/marzo/16 mdm combo reyna entro 4;30\r\n31/marzo/16 depilacion bigote y mentón  AUT-10J REYNA\r\n6/mayo/16 mdm drenaje linfatico lizbet entro 5:20\r\n6/mayo/16 bigote y menton aut-10j sra. bego\r\n3/agosto/16 masaje fullr elax maria entor 6:15\r\n13/septiembre/16 mdm full relax rosy entro 6:05 (mega)\r\n20/marzo/17 mdm full relax y limpieza facial lizbeth entro 3:00 (mega)\r\nINICIA TRATAMIENTO REDUCTIVO $3000.00 PAGADO\r\nCON MEDIDA EN OMBLIGO 99 CM, PESO 79 KILOS\r\n1.-CARBO, MASAJE 45 M 21/marzo/17 monica entro 12:20\r\n2.-MASAJE 45 M 22/marzo/17 monica entro 9:00\r\n3.-CARBO, MASAJE 45 M 23/marzo/17 monica entro 9:35\r\n4.-MASAJE 45 M 24/marzo/17 monica entro 9:00\r\n24/marzo/17 dep. laser de bigote, dedos de pies en empeine autom. 10 j mary\r\n5.-CARBO, MASAJE 45 M 27/marzo/17 monica entro 9:20\r\n6.-MASAJE 45 M 28/marzo/17 monica entro 9:30\r\n7.-CARBO, MASAJE 45 M 29/marzo/17 monica entro 9:00\r\n8.-MASAJE 45 M 3/abril/17 monica entro 10:20\r\n9.-CARBO, MASAJE 45 M 4/abril/17 monica entro 10:30\r\n10.-MASAJE 45 M \r\nINCIA MASAJE REDUCTIVO $3000.00 PAGADO\r\n 1.-CARBOX, MASAJE 45 26 Junio/17 monica entro 9:35\r\n2.-MASAJE 45M 27/junio/17 monica entro 9:00\r\n3.-CARBOX, MASAJE 45M 28/junio/17 monica entro 9:20\r\n28/junio/17 bigote,menton, dedos de los pies autom. 11 j mary lazaro\r\n4.-MASAJE 45M 29/junio/17 monica entro 9:00\r\n5.-CARBOX, MASAJE 45M 30/junio/17 monica entor 10:45\r\n6.-MASAJE 45M 5/julio/17 monica entro 9:00\r\n7.-CARBOX, MASAJE 45M 11/julio/17 monica entro 9:00 llevo crema chauffante\r\n8.-MASAJE 45M 12/julio/17 monica entro 8:55\r\n9.-CARBOX, MASAJE 45M 13/julio/17 monica entro 9:00\r\n10.-MASAJE 45M 14/julio/17 monica entro 9.10\r\n termino el tratamiento.\r\nINICIA PAQUETE DE PROMOCIÓN DE CARBOXITERAPIA $2500.00 APAGADO\r\nCON PESO 79KG\r\n1.-CARBOX 24/julio/17 ofelia entro 2:20\r\n2.-CARBOX 26/julio/17 ofelia entro 10:35\r\n28/julio/17 bigote, menton, dedos aut-11j ofelia\r\n3.-CARBOX 22/febrero/18 monica entro 6:35 (mega)\r\n22/febrero/18 reflexologia podal monica entro 6:35 (mega)\r\n4.-CARBOX 27/febrero/18 monica entro 7:05 (mega)\r\n5.-CARBOX 01/marzo/18 monica entro 7:15 (mega)\r\n6.-CARBOX 03/marzo/18 monica entro 11:05 (mega)\r\n7.-CARBOX 09/marzo/18 monica entro 6:35 (mega)\r\n8.-CARBOX 13/marzo/18 monica entro 7.00 (mega)\r\n9.-CARBOX 15/marzo/18 monica entro 7:10 (mega)\r\n10.-CARBOX 21/marzo/18 monica entro 6.45 (megA)\r\n11.-CARBOX 22/marzo/18 monica entro 7:00 (mega)\r\n12.-CARBOX 23/marzo/18 monica entro 7:10 (mega)\r\n13.-CARBOX 26/MARZO/18 MARIANA ENTRO 3:30\r\n14.-CARBOX 03/abril/18 monica entro 7:10 (mega)\r\n15.-CARBOX 02/julio/18 monica entro 7:40 (mega)\r\n16.-CARBOX 06/julio/18 monica entro 7:35 (mega)\r\n17.-CARBOX\r\n18.-CARBOX\r\n19.-CARBOX\r\n20.-CARBOX\r\n21/MARZO/18 MASAJE CHAMPI MONICA ENTRO 7.00 (MEG<A)\r\n16/noviembre/148 mdm sensorelax susy entro 7:00 (mega)\r\n26/MARZO/19 LIPOSONIX  12 DISPAROS  LUCY\r\n23/abril/19 mdm descontracturante susy entro 6.00 mega\r\n23/NOVIEMBRE/19 FULL RELAX MONI ENTRO 4:10 MEGA\r\n19/JUNIO/2020 MASAJE DRENAJE LINFATICO MARY LAZARO ENTRO 2:00\r\n3/SEPTIEMBRE/2020 TRATAMIENTO FACIAL REVITALIZANTE ANITA  Y MDM DE AROMAS MARY LAZARO ENTRO 3:10\r\n21/NOVIEMBRE/2020 MASAJE FULL RELAX  MONICA ENTRO 6:10 MEGA\r\n04/NOV/2021 MASAJE FULL RELAX MONICA ENTRO 18:00 MEGA\r\n03/FEB/2022 MASAJE FULL RELAX MONICA ENTRO 18:37 MEGA PIDIO ENFOCARSE MAS EN AREA DE ESPALDA\r\n26/SEPTIEMBRE/2022 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE ENTRO 6:00 (MEGA)\r\n07/ NOVIMBRE/2022 MASAJE CHAMPI D4E ESPALDA ROSY ENTO 7:00 (MEGA)\r\n25/ENERO/2023 HIFU 7 SRA BEGO 8000.00 ', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-17 12:53:18', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('551', 'C-100551', '', 'RIXIO MORALES VILLEGAS', '9933180707', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('552', 'C-100552', '', 'VALMORE BRICE', '9932831435', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('553', 'C-100553', '', 'VERONICA ROSALES RIVERA', '9931327307', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('554', 'C-100554', '', 'VIVIANA ROSALES RIVERA', '9931327307', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('555', 'C-100555', '', 'DANIELA LARA LOPEZ', '9931579226', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('556', 'C-100556', '', 'PAOLA HERNANDEZ VELAZQUEZ', '9932075145', '', '3/ABRIL/19 MDM FULL RELAX MONICA ENTRO 6:15\r\n14/NOV/2020 MASAJE THE VERDE MIRENA ENTRO 10:15\r\n8/FEBRERO/2021 MASAJE LASAI MARY LAZARO ENTRO 3:05\r\n*************************LE GUSTA LAS CABINAS  AMPLIAS****************************** \r\n11/MARZO/2021 MASAJE THE VERDE MARY LAZARO ENTRO 1:45\r\n/////////////////////////////////// LE GUSTA QUE LE COBREN AL FINAL //////////////////////////\r\n1/ABRIL/2021 MASAJE DE TE VERDE MONICA ENTRO 1:05\r\n13/MAYO/2021 MASAJE TE VERDE, LIMPIEZA DE ESPALDA ANITA ENTRO 11:15\r\n2/JULIO/2021 MASAJE DE TE VERDE JOHANY \r\n27/JULIO/2021 CAPSULA LUCY ENTRO 5:50\r\n2/SEPT/2021 MASAJE DE TE VERDE LUCY ENTRO 5:00\r\n27/OCTUBRE/2021 MASAJE TE VERDE MARIANA ENTRO 1:10\r\n*********************LE GUSTAN LOS MOVIMENTOS LENTOS, EL PRODUCTO LO TIENE QUE IR GRADUANDO EN TODO EL CUERPO, Y QUE LE DEN MASAJE EN CUELLO************************\r\n4/FEB/2022 CAPSULA MIRENA ENTRO 12:00\r\n4/FEB/2022 MASAJE TE VERDE JHOANY ENTRO 1:00\r\n19/JULIO/2022 MASAJE TE VERDE MARIANA ENTRO 11:00', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('557', 'C-100557', '', 'RENE HERNANDEZ VELAZCO', '9933113012', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('558', 'C-100558', '', 'ELIA MARGARITA DE LA CRUZ PEREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('559', 'C-100559', '', 'YAMILE MENA OROPEZA', '9931608296', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('560', 'C-100560', '', 'MARIAM PADILLA MENA', '9931608296', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('561', 'C-100561', '', 'MARIA GUADALUPE MENA OROPEZA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('562', 'C-100562', '', 'FRANCISCO RAMON GARDUZA', '9933998282', '', '04/febrero/18 mdm aromatico susy entro 5:25 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('563', 'C-100563', '', 'CLAUDIA PEREZ AGUILAR', '9933998282', '', '04/febrero/18 mdm sensorelax monica entro 5:25 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('564', 'C-100564', '', 'MAYRA AYULIETT CRUZ GARCIA', '9931194949', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('565', 'C-100565', '', 'LORENA ALFONSO GIL', '9932176510', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('566', 'C-100566', '', 'VIVIAN RAMIREZ RIVERA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('567', 'C-100567', '', 'REYNA DOMINGUEZ GASPAR', '7821456813', '', '9/oct/15 depilacion de cejas lucy entro 1:10\r\n1/dic/15 promocion reafirmante modeladora maria entro 5:00\r\nse le recomendó hydrasun para la próxima sesion $1450.00\r\n22/marzo/16 depilacion de cejas y bigote ofelia\r\n22/marzo/16 promocion hidratante mary lazaro entro 12:00\r\n11/04/16 depilacion de pantorrila y axila atendio suusy entro 1.00 (mega)\r\n26/oct/16 facial vitamina c de germaine de capuccini lucy entro 11.30\r\n17/dic/16 promocion trat multivitaminico reyna entro 10.40\r\n30/DIC/19 PROMOCION TRAT 24 K LUPITA ENTRO 12:25\r\n6/ENERO/2021 FACIAL HYDRACURE ANITA ENTRO 9:25 LLEVO CREMA EXCEL THERAPY, CONTORNO DE OJOS EXCEL THERAPY, CREMA TIMEXPERT RIDES SOFT, CREMA CUELLO Y ESCOTE TIMEXPERT LIFT IN, GEL DESMAQUILLANTE EQUILIBRANTE PIEL GRASA DE GERMAINE\r\n22/MAYO/2021 LLEVO CREMA TIMEXPERT RIDES SOFT, CREMA OXIGENANTE EXCEL THERAPY, CREMA CONTORNO DE OJOS EXCEL THERAPY \r\n12/OCT/2021 LLEVO CREMA OXIGENANTE ACTIVADORA DE JUVENTUD EXCEL THERAPY Y CREMA GLOBAL ARRUGAS TIMEXPERT RIDES \r\n13/DICIEMBRE/2021 LLEVO CREMA GLOBAL TIMEXPERT RIDES SOFT', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('568', 'C-100568', '', 'PATRICIA JUSTILIANO GONZALEZ', '9932605114', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('569', 'C-100569', '', 'HERNAN FLORES CELI', '9933181698', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('570', 'C-100570', '', 'CITLALI LOPEZ VAZQUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('571', 'C-100571', '', 'JULIANA MARSELENE MADRIGAL LOPEZ', '9933111076', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('572', 'C-100572', '', 'YERANIA CORDOVA RICARDEZ', '9932116608', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('573', 'C-100573', '', 'ROSA CECILIA GRAJEDA MACHIN', '9365635268', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('574', 'C-100574', '', 'ROSAURA SANCHEZ OVANDO', '9931527854', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('575', 'C-100575', '', 'PETRONA CUJ SANCHEZ DE ROSIQUE', '9931141785', '', '18/octubre/18 prom. del mes trat. reafirmante rosy entro 11:10 (mega) tiene cancer de mama del lado izquierdo, se le dio el masaje de brazos muy suave de ese lado, trae en cervical cirugia y tiene placa de titanio para que el masaje linfatico se le de suave en esa area y no quiero ningun aparato electrico, la ampolleta se le aplico topica y en ojos no quiso lifting, en vapor se le protegio con una toalla los ojos por que se hincha por una semana y no quiere nada de calor ni luz en los ojos.\r\n9/ENERO/2020 M. CHAMPI SUSI ENTRO 12:27 MEGA\r\n10/ENERO/2020 M. CHAMPI Y LIMPIEZA FACIAL PROFUNDA JANETH ENTRO 1:05 MEGA\r\n16/ENERO/2020 M. CHAMPI SUSI ENTRO 1:05 MEGA\r\n18/ENERO/2020 M. CHAMPI SUSI ENTRO 6:05 MEGA\r\n23/ENERO/2020 FULL RELAX Y TRATAMIENTO DESINTOXICANTE SUSI ENTRO 2:00 MEGA (NO QUISO QUE SE LE DIERA LA CORTESIA DEL LIFTING PORQUE ES ALERGICA, SE LE CUBRIERON LOS OJOS CON LOS LENTES ANTIFASES)\r\n28/OCT/2021 PROMO. TRAT. ORGANICO CBD ROSI ENTRO 11:16 MEGA\r\n15/DIC/2021 PROMO. TRAT. FACE PURE ANITA ENTRO 16:00 MEGA\r\n29/DIC/2021 PROMO. TRAT. FACE PURE ROSI ENTRO 10:00 MEGA\r\n25/FEB/2022 PROMO. TRAT. AGE DEFENSE MONICA ENTRO 10:05 MEGA\r\n31/MARZO/2022 PROMO. TRAT. SHOCK DE COLAGENO ROSI ENTRO 10:21 MEGA *no quiso que le tocaran elarea de los ojos*\r\n11/ABRIL/2022 PROMO. TRAT. CINETICO ROSI ENTRO 16:16 MEGA -TRAE EN EL ROSTRO DE LADO DERECHO ALGUNAS LLAGAS TIPO QUEMADURAS* DIJO SER DE ESTRES UNICAMENTE Y QUE SU DOCTOR DIJO QUE NO ERAN CONTAGIOSAS* Y QUE SE IBA A REALIZAR EL TRAT. BAJO SU RESPONSABILIDAD.\r\n06/JUNIO/02022 PROMO. TRAT, YOGA FACIAL ROSI ENTRO 10:27 MEGA\r\n04/OCTUBRE/2022 PROMOCION DE MES TRATAMIENTO FACIAL DE OBSIDIANA LA SEÑORA NO QUISO QUE SE LE MUEVA L CABEZA PORQUE TRAE MUCHO DOLOR SE LE RTIRO LA MASCARILLA NO QUISO MASAJE EN LA MANO DERECHA  Y EN LA MANO IZUIERDA UNICAMENTE PRESION ROSY ENTRO 5:20 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-09-30 17:27:54', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('576', 'C-100576', '', 'LUIS ALBERTO MU', '9333371088', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('577', 'C-100577', '', 'DOLORES GUTIERREZ ZURITA', '9933995808', '', '03/11/03 prom. trat. hidratante con lifting de parpados lucy\r\n18/02/04 limpieza facial mary\r\n12/06/04 promocion catiodermia consuelo\r\n21/08/04 promocion regenerador antioxidante consuelo\r\n27/11/04 prom. trat. hydratante con lifting reyna\r\n04/03/05 dermazuleno mary lazaro\r\n04/05/05 promocion 3 geles marcela\r\n15/08/05 promocion regenerador antioxidante yesy\r\n19/nov/05 promocion hidratante con lifitng marcela\r\n04/marzo/06 promocion chocoterapia reyna\r\n20/junio/06 promocion efecto botox mary\r\n03/nov/06 promocion antiarrugas yesy \r\n16/ene/07 promocion relajante e hidratante ofelia entro 1:25 \r\n27/abril/07 promocion botanico carmen \r\n04/06/01 md. de 1 hora carmen\r\n03/11/03 mdm completo  lucy\r\n12/06/04 mdm geotermal consuelo\r\n21/08/04 mdm completo consuelo\r\n27/11/04 mdm completo reyna\r\n04/05/05 mdm completo marcela\r\n15/08/05 mdm completo yesy\r\n19/nov/05 mdm completo marcela\r\n04/marzo/06 mdm completo reyna\r\n20/junio/06 mdm completo mary\r\n10/agosto/06 mdm completo mary\r\n03/nov/06 mdm completo yesy entro 10:20\r\n27/abril/07 mdm completo carmen entro 10:00\r\n16/oct/07 mdm full relax odet\r\n18/dic/07 mdm completo odet entro 9:10 salio 10:15\r\n4/julio/08 mdm completo reyna entro 9:35 \r\n10/marzo/09 mdm completo lupita entro 10:15 \r\n19/mayo/09 mdm completo mary lazaro entro 2:05 \r\n18/agosto/09 mdm completo marina entro 11:00\r\n16/oct/09 mdm completo sara entro 9:05\r\n15/mayo/10 mdm completo karina entro 9:00\r\n28/julio/10 mdm completo lupita entro 10:15 \r\n22/sept/10 mdmcompleto araceli entro 10:05 \r\n16/oct/07 promocion modeladora odet entro 10:20\r\n18/dic/07 promocion vitamina c odet entro 10:15 salio 11:40\r\n24/abril/08 trat. caviar ofelia entro 12:15\r\n4/julio/08 promocion termico reyna entro 10:45 \r\n12/ene/09 trat. de seda y perla mary \r\n10/marzo/09 promocion spa therapy perla ofelia entro 11:15 \r\n19/mayo/09 promocion intensivo parpados y labios mary lazaro entro 3:20 \r\n18/agosto/09 promocion revitalizante marina entro 12:00\r\n16/oct/09 promocion hidronutritivo sara entro 10:15\r\n12/marzo/10 promocion de cristal gladys \r\n15/mayo/10 promocion catiodermia karina entro 10:15\r\n28/julio/10 promocion relajante e hidratante lupita entro 10:15\r\n22/sept/10 promocion termico araceli entro 11:15 \r\n11/dic/10 limpieza de acne con amp. desincrustante entro 8:40 \r\n15/feb/11 mdm sensorelax, promocion trat. de seda reyna entro 3:07\r\n1/julio/11 promocion estimulante de endorfinas, lifting # 2 reyna entro 4:05\r\n17/agosto/11 mdm, promocion piel de seda mariana entro 3:50\r\n08/nov/11 promocion germen de trigo sara entro 12:10\r\n21/ene/12 mdm sensorelax, promocion revitalizante aracely entro 9:15\r\n10/marzo/12 mdm sensorelax, promocion hidradermis con amp. desincrustante reyna entro 11:15\r\n10/julio/12 mdm drenaje, promocion hidratante de arroz araceli entro 8:10\r\n2/09/12 promocion trat. de agave atendio jenifer entro 11:00 mega\r\n2/09/12 se le aplico ampolleta desincrustante mega\r\n21/10/12 mdm y lim. facial atendio jenifer entro 10:40 mega\r\n22/dic/12 mdm, promocion de oro reyna entro 9:30\r\n03/03/13 mdm,lim.facial 2x1 con ampo. acido hialurogico atendio bety entro 10:10 mega \r\n1/junio/13 mdm sensorelax, promocion coco y mango reyna entro 8:10\r\n21/sept/13 mdm sensorelax, promocion lifting antiarrugas graciela entro 9:15\r\n28/dic/13 mdm sensorelax, promocion de oro nelli entro 8:10\r\n30/03/14 mdm y limp facial con lifting martha mega 11:10\r\n11/junio/14 promocion antioxidante nelli entro 5:30\r\n9/agosto/14 promocion oxigenante atendió lucy entro 2:10\r\n4/oct/14 mdm full relax, promocion trat smoothie con amp. de colageno carmen entro 10:00\r\n20/dic/14 mdm full rela, promocion trat. global antiedad brenda entro 8:10\r\n15/02/15 se realizó lim facial y msj full relax. atendió lucero cristal entro alas 12-03.\r\nse aplico ampolleta buty 11. \r\n25/abril/15 full relax y limp.facial del 2x1 con lifting de jalea real y ampolleta de ácido hialurónico\r\nmartha entro 2:06 (mega)\r\n30-08-15 SE REALIZO LIM FACIAL CON AMPOLLETA HIDRATANTE GRACIELA CRISTAL 4PM\r\n22/noviembre/15 mdm full relax y limpieza facial 2x1 con amp. beauté II rosy entro 12:15 (mega)\r\n28/dic/15 llevo tonico ceutical, crema ceutical, diamond white oil free\r\n26/dic/15 masaje full relax y promocion reafirmante modeladora andrea entro 10:15\r\n6/feb/16 mdm holistico, promocion roll & lift massage carmen entro 11:10\r\n6/feb/16 llevo crema hidroreparadora detox the cure, crema chauffante\r\n21-05-16 se realizo mdm l-f x 600 candy cristal 10am \r\n15/julio/16 masaje full relax y limpieza facial con amp. dem colageno susy entro 11:00\r\n04/septiembre/16 mdm full relax y prom. del mes colageno lizbeth entro 10:05 (mega)\r\n12/oct/16 masaje full relax y promocion de coalgeno anita entro 12:00\r\n13/dic/16 masaje full relax y promocion trat multivitaminico mary lazaro entro 12.00\r\n21/ene/17 masaje full relax promocion desintoxicante lizvet entro 11:20\r\n25/marzo/17 mdm descontracturante, promocion estimulante de colageno con luz leds carmen entro 10:15\r\n13/mayo/17 mdm descontracturante, promocion antiedad con lifting mary L entro 12:25 llevo serum intensivo timexpert white, crema ceutical\r\n26/JUNIO/17  LLEVO TONICO DE CEUTICAL NB\r\n22/julio/17 masaj full relax y promocion trat facial relajante hidratante rosy entro 10:10\r\n23/sept/17 promocion resveratrol lucy entro 12:00\r\n2/dic/17 mdm full relax, promocion gold charito entro 10:20 llevo crema de ojos duo de timexpert rides\r\n8/dic/17 lifting timexpert rides lucy entro 3:10\r\n12/01/18 PROM TRATA OXIGENANTE C/ULTRASONIDO Y LIFTING REYNA ENTRO  MARY ENTRO 3:15\r\n10/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO, MDM DESCONTRACTURANTE Y LIFTING TIMEXPERT RAID REYNA ENTRO 10:15\r\n10/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA, LIFTING TIMEXPERT RIDES MARIANA ENTRO 11:10\r\n3/MAYO/18 MDM FULL RELAX, TRAT FACIAL HYDRACURE, LIFTING TIMEXPERT RIDES, TRAT DE MANOS CON GUANTE MARIANA ENTRO 4:05\r\n29/MAYO/18  MDM FULL RELAX DE CLIENTE FRECUENTE, LIFTING DE COLÁGENO Y RADIO FRACCIONADA  OFELIA ENTRO 1:10\r\n29/MAYO/18 LLEVO TONICO CEUTICAL Y FILTRO SOLAR DIAMOND WHITE\r\n6/OCT/18  MDM FULL RELAX CHARITO ENTRO 10:10\r\n6/OCT/18  LIMPIEZA FACIAL Y RADIOFRECUENCIA FACIAL MARY\r\n13/OCT/18 RADIOFRECUENCIA FACIAL LUCY\r\n27/OCT/18 RADIOFRECUENCIA TRADICIONAL  LUCY\r\n19/NOV/18 RADIOFRECUENCIA FRACCIONADA MARY ENTRO 2:55\r\n14/DIC/18 RADIOFRECUENCIA FRACCIONADA REYNA ENTRO 1:25\r\n27/DIC/18 RADIO FRACCIONADA  REYNA \r\n8/FEB/19 RADIO FRACC LUCY ENTRO 11:00\r\n16/MARZO/19  PROM TRATAMIENTO FACIAL DETOX Y MDM DESCONTRACTURANTE LUPITA ENTRO 10:;15\r\n24/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE REYNA ENTRO 5:00\r\n15/MAYO/19 FACIAL REVERSE REYNA \r\n25/JUNIO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO ANTIEDAD MARY ENTRO 11:10\r\n17/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA YANETH ENTRO 10:05\r\n9/OCT/19 PROMOCION DOBLE ACCION LUPITA ENTRO 12:20\r\n14/oct/19 masaje  full relax de cliente frecuente monica entro 12:00 mega\r\n8/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS  CON AMP DE COLAGENO MARY LAZARO ENTRO 2:20\r\n23/NOVIEMBRE/19 TRATAMIENTO FACIAL REVERSE ((NO PASAR EN LABIOS)) LUCY ENTRO 10:15\r\n7/DICIEMBRE/19 FACIAL REVERSE REYNA ENTRO 10:40\r\n11/ENERO/20 TRAT REVERSE OFELIA ENTRO 11:10 LLEVO VECTOR LIFT TIMEXPERT IN \r\n22/FEB/2020 TRAT REVERSE ANITA ENTRO 12:10\r\n18/MARZO/20 TRAT REVERSE LUCY ENTRO 12:10\r\n20/NOVIEMBRE/2021 FACIAL COMPLETO  MIRENA ENTRO 12:10\r\n18/ABRIL/2022 LASER DE CARBONO Y AMP DE ACIDO HIALURONICO OFELIA ENTRO 5:30\r\n27/JUNIO/2022 PROMO. TRAT. YOGA FACIAL CON AMP, DESINCRUSTANTE MONICA ENTRO 18:05 (MEGA)\r\n29/JUNIO/2022 MASAJE FULL RELAX ROSI ENTRO 10:00 (MEGA)\r\n02/AGOSTO/2022 PROMOCION TRATAMIENTO ANTIOXIDANTE  SUSY ENTRO 10:00 (MEGA)\r\n26/SEPTIEMBRE/2022 PROMOCION DEL MES TRATAMIENTO PREVENTIVO DE MANCHAS MONICA ENTRO 11:00 (MEGA)\r\n19/ DICIEMBRE/2022PROMOCIONDEL MES TRATAMIENTO GOLDEN ROSY ENTRO 6.00 (MEGA)\r\n6/MARZO/2023 MASAJE FULL RELAX, PROMOCION TRAT. FACIAL MICRODERMA SUSY ENTRO 10:00\r\n5/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND OFELIA ENTRO 5:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-05 17:14:13', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('578', 'C-100578', '', 'PATRICIA CRUZ OLAN', '9931706544', '', '04/abril/16 mdm drenaje linfatico charito entro 4:05 (mega)\r\n10/diciembre/16 mdm drenaje linfatico mirena entro 12:15 (mega)\r\n06/MAYO/2022 MASAJE DESCONTRACTURANTE MONICA ENTRO 18:05 MEGA', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('579', 'C-100579', '', 'ERIKA CRISTINA PEREZ PULIDO', '9931253615', '', 'DEPILACION DE AXILA $360.00 C/S PIERNAS COMPLETAS $1500.00 C/S\r\n17/mayo/17 1ra. axila, piernas completas autom. 18 j mary L\r\n19/junio/17 2da. axila aut-20j, piernas aut-22j ofelia\r\n20/julio/17 3era. piernas aut-23j y axila aut-21j mary lazaro\r\n19/agosto/17 4ta piernas aut-23j, axila aut-21j lucy\r\n3/oct/17 5ta. piernas completas autom. 25 j, axila autom. 23 j ofelia\r\n8/nov/17 6ta. piernas completas autom. 25 j, axila autom. 24 j ofelia\r\n9/dic/17 7ta. piernas completas, axilas autom. 26 j ofelia\r\n9/dic/17 limpieza facial con amp. desincrustante susy entro 10:10\r\n09/FEB/18 PIERNAS COMP AUT 25J, AXILA AUT 26J OFE\r\n09/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO OFE ENTRO 11:05\r\n15/MARZO/18 AXILA AUT 25 J, PIERNAS COMP AUT 14 J MARY\r\n15/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA MARY\r\n27/ABRIL/18  PIERNAS COMP AUT 24J AXILA AUT 24 J MARY\r\n27/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE MARY\r\n30/ABRIL/18 MDM FULL RELAX DE CLIENTE FRECUENTE OFELIA\r\n6/JUNIO/18 LASER PC AUT 24 J AXILA AUT 24 J LUCY\r\n19/MARZO/20 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY ENTRO 4:45', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('580', 'C-100580', '', 'YOLANDA ELVIRA PULIDO MAGAÑA', '9933117886', '', '19/ene/17 promocion desintoxicante susy entre 5:10\r\n7/sept/17 promocion resveratrol yenifer entro 4:00\r\n7/sept/17 retoque de axila aut-17j lucy\r\n09/01/18 LPL MANCHAS  Y PROM TRATAMIENTO OXIGENATE C/ULTRASONIDO REYNA\r\n9/FEB/18 PROMOCION MULTIVITAMINICO REYNA ENTRO 9:00\r\n9/FEB/18 2DA IPL MANCHAS PROG. 1 INT. REYNA\r\n9/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA REYNA ENTRO 10:10\r\n9/MARZO/18 IPL MANCHAS INT 4 REYNA\r\n15/MARZO/18 TRATAMIENTO MANCHAS ANITA ENTRO 9:20\r\n11/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE REYNA \r\n11/ABRIL/18 IPL PROG 1 INT 5 REYNA\r\n7/SEPT/2022 PROMOCION TRAT. PREVENTIVO DE MANCHAS LUCY ENTRO 2:45\r\n8/NOV/2022 PROMOCION TRAT. REPARACION CELULAR LUCY ENTRO 1:40\r\nINICIA TRATAMIENTO REDUCTIVO COMPLETO $12,000.00 PAGADO\r\nCON MEDIDAS EN OMBLIGO 82 CM \r\nCADERA BAJA 108 CM \r\n1.-CAVITACION 50 M, MSAJE 45 M 8/NOV/2022 CRISTINA ENTRO 11:50\r\n2.-MASAJE 45 M, CAPSULA 9/NOV/2022 CRISTINA ENTRO 11:00\r\n3.-MASAJE 45 M, CORPO 10/NOVIEMBRE/2022 CRISTINA ENTRO 11:15\r\n4.-MASAJE 45 M, TERMO 11/NOVIEMBRE/2022 CRISTINA ENTRO 11:10\r\n5.-ULTRASONIDO 50 M, MASAJE 45 M 14/NOVIEMBRE/2022 CRISTINA ENTRO 1:00\r\n6.-MASAJE 45 M, PRESOTERAPIA 40 M 15/NOVIEMBRE/2022 CRISTINA ENTRO 11:10\r\n15/NOVIEMBRE/2022 RADIOFRECUENCIA FACIAL LUCY ENTRO 9:00\r\n7.-MASAJE 45 M, V F 45 M 16/NOVIEMBRE/2022 CRISTINA ENTRO 11:00\r\n8.-LASER LIPOLITICO 30 M, MASAJE 45 M 17/NOVIEMBRE/2022 CRISTINA ENTRO 11:10\r\n9.-MASAJE 45 M, CRIOTERAPIA 50 M  18/NOVIEMBRE/2022 CRISTINA \r\n10.-MASAJE 45 M, G-5 20 M, V F 30 M   19/NOVIEMBRE/2022 CRISTINA ENTRO 8:05*********TERMINO TRATAMIENTO************\r\nPESO 66 TERMINO 64 1/2 MEDIDAS CINTURA OMBLIGO 82 TERMINO 74 CADERA BAJA 108 TERMINO 100\r\n****************************************************************************\r\n25/NOVIEMBRE/2022 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 9:10\r\n3/DICIEMBRE/2022 RADIOFRECUENCIA FACIAL LUCY ENTRO 8:20\r\n9/DICIEMBRE/2022 RADIOFRECUENCIA FACIAL LUCY ENTRO 9:20\r\n17/DICIEMBRE/2022 RADIOFRECUENCIA FACIAL LUCY ENTRO 8:15', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-09 11:16:01', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('581', 'C-100581', '', 'YOLANDA GUADALUPE HERNANDEZ CONTRERAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('582', 'C-100582', '', 'MARBELLA PEREZ RUIZ', '9931389631', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('583', 'C-100583', '', 'CARMELA RUEDA LARA', '9931160212', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('584', 'C-100584', '', 'VIVIANA AMBROSIO NIETO', '9931779895', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('585', 'C-100585', '', 'BLANCA LOERA NU', '9932077777', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('586', 'C-100586', '', 'JOSE LOPEZ PEREZ', '9931601651', '', '15/NOV/2021 MASAJE FULL RELAX ROSI ENTRO 10:15 MEGA\r\n02/JULIO/22 MASAJE DESCONTRACTURANTE MONICA  ENTRO 3;00 MEGA\r\n\r\n', 'no', 'inactivo', '2021-12-07 00:49:45', '2022-11-15 12:18:14', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('587', 'C-100587', '', 'SANTA IRAIS PAREDES DE LA CRUZ', '9931175145', '', '01/feb/16 depilacion de bikini carmen entro 3:30\r\n19/feb/16 promocion rol & lift maria entro 9:05\r\n25-05-16 se realizo dep bikini doña rossy cristal 12pm\r\n10/JUNIO/2021 PROMO. TRAT. RETINOL  ARLETH ENTRO 17:08 MEGA\r\n05/ABRIL/2022 PROMO. TRAT. CINETICO ROSI ENTRO 10:10 MEGA\r\n15/JULIO/2022 PROMOCION TRAT ROLL & LIFT CRISTINA ENTRO 11:00\r\n23/ NOVIEMBRE/2022 PROMOCION DEL MES TRATAMIENTO REPARACION CELULAR SUSY ENTRO 6:05 (MEGA)\r\n24/MAYO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL MAGIC FACE ALONDRA ENTRO 11:15 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-23 20:25:06', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('588', 'C-100588', '', 'GIOVANNI DE JESUS TORRES MENA', '9931116668', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('589', 'C-100589', '', 'NORA PATRICIA IGLESIAS FALCON', '9931302228', '', '04/ABRIL/19 MDM FULL RELAX VALE DE REGALO SUSY ENTRO 5:10 MEGA\r\n03/MAYO/19 MDM FULL RELAX SUSY ENTRO 6:00 MEGA', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('590', 'C-100590', '', 'DAYANARA GUTIERREZ CONTERA', '9931302228', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('591', 'C-100591', '', 'MERNA YAÑEZ', '9933936411', '', '24/mayo/11 limpieza facial 2 x 1 mariana entro 6:15\r\n25/mayo/11 mdm 2 x 1 mariana entro 2:25 salio 3:30\r\n9/09/12 exfoliación corporal y mdm y lim. facial 2x1 atendio jhoany entro 5:05 mega\r\n10/02/13 m de drenaje linfatico entro chela ( suc comer)\r\n08/03/13 mdm y lim. facial 2x1 atendio jhoanny entro 2:00 mega \r\n07/04/13 masaje full relax atendio brenda entro 7:15 mega \r\n20/abril/13 mdm full relax, promocion porcelana yusiria entro 11:10 llevo crema reafirmante al collage\r\n27/04/13  masaje full relax jhoany entro 4.30 mega\r\n05/05/13 mdm y lim. facial 2x1  atendio bety y nelly entro 6:15 mega \r\n08/05/13 exfoliacion corporal 2x1 atendio bety entro 2:30 mega \r\n18/mayo/13 mdm full relax, facial hidratante reyna entro 8:20\r\n26/05/13 lim. facial y mdm 2x1 atendio nelly entro 3.35 mega \r\n06/06/13 mdm fuii relax atendio bety entro 2:30 mega\r\n16/06/13 limp facial y mdm 2x1 atendio nelly entro 6:00 mega\r\n07/07/13 lim. facial y mdm 2x1 jhoany mega\r\n25/08/13 lim. facia y mdm 2x1 jhoany mega\r\n01/0913 mdm y limp. facal 2x1 jhoany mega6:00\r\n09/09/13 masaje full relax jhoany mega 4:00\r\n22/MARZO/19 MDMFULL RELAX SUSY ENTRO 7:15 MEGA\r\n15/09/13 masaje full relax joay entro 6:00 mega\r\n29/09/13 lim. facial y mdm 2x1 atendio carolina entro 1:45 mega\r\n06/10/13 mdm 2x1 jhoany mega 6.00\r\n10/10/13 masaje cliente frecuente carolina mega 7.10\r\n26/11/13 mdm y limp facial 2x1 atendio martha mega entro 4:15\r\n03/12/13 mdm 2x1 lim.facial atendio martha mega 2:00\r\n08/12/13 mas full relax atendio jhoany mega entro 5\r\n28/12/13 promocion mes diciembre atendio jhoany mega entro 6:30\r\n29/12/13 mas full relax atendio jhoani mega entro 2:05\r\n17/02/14 lim facial y mdm 2x1 mirena mega 3:40\r\n27/02/14 masaje full relax susi mega 3:25\r\n03/03/14 masaje cliente frecuente johany mega 7:15\r\n12/03/14 mdm full relax mega johany 7:00\r\n01/04/14 mdm full relax johany mega 3:40\r\n16/04/14 mdm y limp facial 2x1 johany mega 5:35\r\n25/04/14 mdm full relax anita mega 6:20\r\n01/05/14 mdm full relax rosy mega 6:10\r\n28/06/14 masaje de espalda carmen mega 7.45\r\n25/agosto/14 mdm full relax candy entro   6:10  (mega)\r\n21/feb/15 mdm full relax cliente frecuente y limpieza facial candy entro 12:11 (mega)\r\n01/feb/15 mdm full relax y limpieza facial 2x1 nelly entro 6:08 (mega)\r\n27/sept/15 mdm full relax maribel entro 6:10 (mega)\r\n23/feb/16 mdm full relax charito entro 5:50\r\n29/feb/16 mdm full relax lizvet entro 5:50\r\n06/septiembre/16 mdm full relax lizbeth entro 5:45 (mega\r\n19/agosto/17 mdm full relax y limpieza facial anita entro 12:05 (mega)\r\n03/sept/17 mdm full relax y limpieza facial carmen entro 6:05 (mega)\r\n18/JULIO/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE Y MDM FULL RELAX 2 X 600 LUPITA ENTRO 4:40\r\n19/ENE/19 MDM FULL RELAX Y LIMPIEZA FACIAL 2X600, LIFTING MARY ENTRO 12:05 (MEGA)\r\n26/ENE/19 MDM FULL RELAX 2X600 SUSI ENTRO 11:05 (MEGA)\r\n2/FEB/19 MDM FULL RELAX 2X600 SUSI ENTRO 11:15 (MEGA)\r\n01/ABRIL/19 MDM FULL RELAX Y LIMPIEZA FACIAL 2X600 CARMEN ENTRO 3:00 MEGA\r\n02/ABRIL/19 MDM FULL RELAX 2X600 SUSY ENTRO 11:00 MEGA\r\n2/ABRIL/19 PROMOCION HUMECTANTE LUCY ENTRO 9:15\r\n18/JUNIO/19 MDM FULL RELAX  CLIENTE FRECUENTE ROSY ENTRO 11:05 MEGA\r\n23/junio/19 prom. del mes  tratamiento revolucionario antiedad carmen entro 11:15 mega\r\n25/junio/19 drenaje linfatico susy entro 6:05 mega\r\n19/FEB/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE JHOANY ENTRO 3:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('592', 'C-100592', '', 'MARIBEL SALAZAR CRUZ', '9163480848', '', '12/agosto/17 carbox andrea entro 10:20 (mega)\r\n19/agosto/17 carbox anita entro 3:15 (mega)\r\n02/sept/17 carbox carmen entro 5:00 (mega)\r\n03/sept/17 carbox candy entro 2:15 (mega)\r\n14/MARZO/20 TRATAMIENTO FACIAL RECUPERADOR ANITA ENTRO 1:00\r\n29/SEPTIEMBRE/2020 RADIOFRECUENCIA FACIAL LUCY ENTRO 11:10\r\n14/MAYO/2021 PROMOCION TRAT. CELULAS MADRE MARIANA ENTRO 2:40', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('593', 'C-100593', '', 'LUCIA MAGDALENA EPITACIO HERNANDEZ', '9933426385', '', '12/ene/07 promocion relajante e hidratante bety entro 4:00\r\n01/agosto/07 limpieza facial 2 x 1 ligia entro 9:40\r\n15/agosto/07 limpieza facial 2 x 1 ligia entro 10:10\r\n03/sept/07 limpieza facial 2 x 1 rosy entro 11:00 salio 12:10\r\n17/sept/07 limpieza facial 2 x 1 reyna \r\n25/oct/07 limpieza facial mary lazaro entro 3:00\r\n7/ene/08 limpieza facial lucy entro 11:00 \r\n30/mayo/08 limpieza de acne con amp. \r\nbalancing extract mary lazaro entro 1:55 salio 3:05 \r\n30/junio/08 limpieza facial araceli entro 11:35 \r\n5/sept/08 limpieza facial 2 x 1 rosy entro 10:30 \r\n10/oct/08 limpieza facial 2 x 1 rosy entro 6:05 \r\n15/oct/08 limpieza facial 2 x 1 reyna entro 11:10 \r\n8/dic/08 promocion vitamina c lucy entro 12:40\r\n30/ene/09 promocion jalea real sara entro 3:05 \r\n13/feb/09 promocion percollagen julia entro 12:00 \r\n4/marzo/09 limpieza de acne con amp. desincrustante lupita entro 4:35 \r\n31/marzo/09 promocion spa therapy perla gladys\r\n22/abril/09 promocion spa therapy oro gladys \r\nllevo masc. ak, hydragel sebum control.\r\n14/mayo/09 promocion trat intensivo parp y labios sara\r\n23/mayo/09 limpieza de acne con amp. piel grasa de sothys araceli entro 10:35 \r\n17/junio/09 promocion white line lupita entro 10:20 \r\n20/julio/09 promocion extraperformance araceli entro 11:00\r\n3/agosto/09 limpieza facial de acne 2 x 1 marina entro 10:45\r\n12/agosto/09 limpieza facial 2 x 1 gladys entro 11:45 \r\n31/agosto/09 limpieza facial de acne 2 x 1 gladys entro 12:10\r\n15/sept/09 limpieza de acne karina con amp balancing\r\n29/sept/09 promocion termico de azuleno lucy entro 10:40\r\n14/oct/09 limpieza facial 2x1 lucy entro 12:20\r\n28/oct/09 limpieza facial de acne 2 x 1 con amp. \r\nbalancing extract gladys entro 9:35 \r\n11/nov/09 limpieza facial 2 x 1 rosy entro 6:30\r\n2/dic/09 limpieza facial 2 x 1 reyna entro 11:30 \r\n16/dic/09 limpieza facial de acne 2 x 1 rosy entro 2:50\r\n30/dic/09 limpieza facial de acne 2x1 \r\n6/enero/10 limpieza facial de acne 2x1 gladys entro 12:30\r\n20/ene/10 limpieza facial 2 x 1 ofe entro 11:40 \r\n23/ene/10 micro sara entro 12:20\r\n27/ene/10 limpieza facial de acne 2x1 ofelia entro 1:20\r\n17/feb/10 limpieza facial de acne 2 x 1 reyna entro 12:50 salio 2:00 \r\n24/feb/10 limpieza facial de acne 2 x 1 mariana entro 11:10 \r\n27/feb/10 micro ofe entro 10:30 \r\n6/marzo/10 micro ofe entro 11:20\r\n8/marzo/10 promocion de cristal lucy entro 1:00 \r\n18/marzo/10 tiene una limpieza facial 2 x 1 pagada para el miercoles 24/marzo/10\r\n24/marzo/10 limpieza facial 2 x 1 lupita entro 8:25 salio 9:35 \r\n31/marzo/10 limpieza facial 2 x 1 mariana\r\n llevo gel moussant exfoliant, locion biocontrol.\r\n7/abril/10 limpieza facial de acne 2x1 indira\r\n21/abril/10 limpieza facial de acne 2x1 indira \r\n28/abril/10 limpieza facial de acne 2 x 1 sara entro 1:15 \r\n5/mayo/10 limpieza facial de acne 2 x 1 indira 12:10 \r\n19/mayo/10 limpieza facial de acne 2 x 1 con amp.\r\n piel grasa de lendan gladys entro 3:15\r\n2/junio/10 limpieza facial de acne 2x1 sara  entro 12:25\r\n16/junio/10 limpieza facial de acne 2x1 reyna entro 1:05\r\n23/junio/10 limpieza facial de acne 2 x 1 indira \r\n30/junio/10 limpieza facial 2 x 1 sara entro 1:30 \r\n2/julio/10 micro reyna entro 5:05\r\n7/julio/10 limpieza facial de acne 2 x 1 indira entro 5:10\r\n10/julio/10 micro skinlight lupita entro 10:35\r\n14/julio/10 limpieza facial 2 x 1 reyna entro 3:40\r\n21/julio/10 limpieza facial de acne 2 x 1 indira entro 3:40 \r\n28/julio/10 limpieza facial de acne 2 x 1 sara entro 11:25 \r\n11/agosto/10 limpieza facial 2 x 1 sara entro 12:05\r\n14/agosto/10 limpieza de acne reyna entro 11:50 \r\n llevo spot diminish timexpert white, crema correctora timexpert white.\r\n18/agosto/10 limpieza de acne 2x1 indira\r\n21/agosto/10 micro ofe entro 11:25\r\n1/sept/10 limpieza facial 2 x 1 indira entro 10:30\r\n10/sept/10 limpieza de acne sara entro 11:50 \r\n20/sept/10 limpieza facial de acne 2 x 1 indira entro 2:00 salio 3:00\r\n27/sept/10 limpieza facial de acne 2 x 1 araceli entro 11:00\r\n13/oct/10 limpieza facial de acne 2x1 ofelia\r\n20/oct/10 limpieza facial de acne 2 x 1 rosy entro 11:35\r\n27/oct/10 limpieza facial de acne rosy entro 1:35\r\n8/nov/10 limpieza facial de acne 2 x 1 reyna entro 2:05 \r\n16/nov/10 limpieza facial de acne 2 x 1 mary lazaro entro 3:22\r\n24/nov/10 limpieza facial de acne 2 x 1 lucy entro 12:30 \r\n9/dic/10 limpieza facial de acne 2 x 1 reyna entro 3:11 salio 4:18 \r\n22/dic/10 limpieza facial 2 x 1 reyna entro 2:30 \r\n29/dic/10 limpieza facial 2 x 1 reyna entro 1:30 \r\n7/ene/11 limpieza de acne con amp. desincrustante de cortesia\r\n lifting # 2 sara entro 11:13 \r\n12/ene/11 limpieza facial de acne 2 x 1  con amp.\r\n piel grasa de lendan reyna entro 11:41 \r\n19/ene/11 limpieza facial de acne 2 x 1 reyna entro 2:00 \r\n26/ene/11 limpieza facial de acne 2 x 1 reyna entro 11:45 \r\n2/feb/11 limpieza facial de acne 2 x 1 con amp. piel grasa ofe entro 9:55\r\n16/feb/11 limpieza facial de acne 2 x 1 reyna entro 11:00 \r\n23/feb/11 limpieza facial de acne 2 x 1 con amp. piel grasa reyna \r\n2/marzo/11 limpieza facial de acne 2 x 1 con amp. piel grasa de lendan araceli entro 1:25\r\n9/marzo/11 limpieza facial de acne 2 x 1 araceli entro 11:50 \r\n16/marzo/11 limpieza facial de acne 2 x 1 sara \r\n23/marzo/11 punta de diamente karina\r\n30/marzo/11 limpieza facial de acne 2 x 1 gladys entro 12:50\r\n13/abril/11 limpieza facial de acne 2 x 1 araceli entro 11:30 \r\n16/04/11 micro-cristales. atendio.graciela entro:12:30pm salio:1:30pm(suc)\r\n20/abril/11 limpieza facial de acne 2 x 1 susy entro 1:30\r\n02/05/11 limpieza acne atendio. indira. entro:12:20pm salio:1:30pm(suc)\r\n4/mayo/11 limpieza facial de acne 2 x 1 con amp. piel grasa sara entro 11:25\r\n9/mayo/11 limpieza de acne 2 x 1 gladys entro 11:15\r\n16/mayo/11 limpieza facial de acne 2 x 1 araceli entro 11:45\r\n25/mayo/11 limpieza facial de acne 2 x 1, planchado de cejas reyna entro 11:10\r\n02/06/11 limpieza facial 2x1 atendio:rosy entro:2:20pm salio:3:25pm (suc)\r\n10/junio/11 limpieza facial de acne 2 x 1 reyna entro 2:05\r\n13/junio/11 promocion estimulante de endorfinas mariana entro 11:45\r\n22/junio/11 limpieza facial de acne 2 x 1 araceli entro 12:00\r\n11/julio/11 limpieza facial de acne 2 x 1 reyna entro 12:10\r\n22/julio/11 limpieza facial de acne 2 x 1 gladys entro 1:40\r\n4/agosto/11 limpieza facial 2x1 reyna entro 3:15\r\n24/agosto/11 limpieza facial 2x1 con ampolleta desincrustante dulce entro a las 5:00\r\n31/agosto/11 limpieza facial 2x1, depilacion de cejas mariana entro a las 2.20\r\n14/sep/11 limpieza del 2x1 aracely entro 12:30\r\n21/sep/11 limpieza del 2x1 sara entro 1:45\r\n06/oct/11limpieza facial 2x1 sara entro 1:55 salio 3:00\r\n26/oct/11 limpieza facial 2x1 ryna entro 3:50\r\n08/nov/11 limpieza del 2x1 rocio entro 12:15\r\n16/nov/11 limpieza facial 2 x 1 reyna entro 1:15\r\n30/11/11 limpieza facial 2x1 atendio deyanira\r\n9/dic/11 promocion velo de colageno brenda entro 2:10\r\n14/12/11 limpieza de acne 2x1 atendio dulce entro 3.00 (mega)\r\n26/dic/11 limpieza de acne 2 x 1, depilacion de bigote reyna entro 1:50\r\n4/ene/12 limpieza de acne 2 x 1 ofe entro 12:50\r\n7/ene/12 trat. facial strategist ofelia entro 1:40\r\n17/ene/12 limpieza de acne 2 x 1, depilacion de cejas sara entro 12:45 llevo gel vientre plano\r\n21/ene/12 limpieza facial de acne 2 x 1 ofe entro 2:00\r\n1/feb/12 limpieza facial 2 x 1 con amp. acido hialuronico karina entro 1:25\r\n9/feb/12 limpieza facial 2 x 1 rosy llevo emulsion de gardenia\r\n16/feb/12 limpieza facial 2 x 1 con amp. equilibrante ofe entro 12:20\r\n16/feb/12 depilacion de bigote ofe \r\n28/feb/12 limpieza facial 2 x 1  karina entro  12:50\r\n9/marzo/12 limpieza facial 2 x 1 con amp. desincrustante reyna entro 2:05\r\n21/marzo/12 limpieza facial de acne 2 x 1 reyna entro 3:05\r\n4/abril/12 limpieza facial de acne 2 x 1 sara entro 11:45\r\n4/abril/12 depilacion de cejas y bigote sara\r\n17/abril/12 limpieza de acne sara\r\n30/abril/12 limpieza facial de acne 2 x 1 lucy entro 1:10\r\n8/mayo/12 promocion velo de colageno, depilacion de bigote aracely entro 12:55\r\n17/mayo/12 limpieza facial de acne 2 x 1, depilacion de cejas sara entro 1:10\r\n26/mayo/12 limpieza de acne, lifting # 2 con amp. hydracure karina entro 12:10\r\n5/junio/12 limpieza de acne 2 x 1 rosy entro 2:05\r\n18/junio/12 limpieza facial de acne 2 x 1, depilacion de cejas de cortesia lifting # 2 aracely\r\n25/junio/12 limpieza facial de acne 2 x 1 sara entro 11:20\r\n2/julio/12 limpieza facial de acne 2 x 1 susy entro 2:00\r\n14/julio/12 limpieza facial de acne 2 x 1 rosy entro 1:45\r\n14/julio/12 depilacion de cejas y bigote rosy entro 1:45\r\n24/julio/12 limpieza facial de acne 2 x 1 con amp. serum 2 karina entro 12:00\r\n2/agosto/12 limpieza facial de acne 2 x 1 graciela entro 1:00\r\n15/agosto/12 limpieza facial de acne 2 x 1, depilacion de cejas y bigote sara entro 2:25 llevo gel hipotermico\r\n27/agosto/12 limpieza facial de acne 2 x 1 araceli entro 4:00\r\n27/agosto/12 depilacion de cejas araceli\r\n5/sept/12 limpieza facial de acne 2 x 1 con amp. hidratante reyna entro 2:15\r\n21/sept/12 limpieza facial de acne 2 x 1 con amp. piel grasa atache, dep. de cejas sara entro 1:20\r\n29/sept/12 limpieza de acne 2 x 1 , depilacion de bigote karina\r\n8/oct/12 limpieza facial de acne 2 x 1, depilacion de cejas sara entro 1:35\r\n18/oct/12 limpieza facial de acne con amp. equilibrante de atache 2 x 1 karina entro 4:50\r\n27/oct/12 limpieza de acne 2 x 1 lucy entro 2:00\r\n5/nov/12 limpieza facial de acne 2 x 1 con amp. piel grasa, depilacion de cejas reyna entro 4:25\r\n12/nov/12 limpieza de acne 2 x 1 con amp. piel grasa de atache gladys entro 2:00\r\n22/nov/12 limpieza de acne 2 x 1 gladys entro 11:00\r\n28/nov/12 limpieza de acne 2 x 1 con amp. piel grasa lucy entro 2:35\r\n13/dic/12 limpieza facial de acne 2 x 1 araceli entro 11:00\r\n2/enero/13 limpieza facial de acne 2 x 1, depilacion de cejas rosy\r\n14/ene/12 limpieza facial de acne 2 x 1  reina entro 1:05\r\n14/feb/13 limpieza facial de cortesía rosy entro 11:50\r\n13/mayo/13 limpieza facial  2x1 ana entro 12.40\r\n30/mayo/13 limpieza facial 2x1 reyna entro 12:30\r\n5/nov/13 limpieza facial 2x1 reyna entro 3:15\r\n11/nov/13 mdm cliente frecuente susy entro 4:00\r\n21/11/13 lim acne 2x1 atendió martha mega entro 5:15\r\n22/nov/13 se le realizo de nuevo la limpieza  atendió gladys \r\n10/dic/13 limpieza facial 2x1 yusiria entro 1:25\r\n28/dic/13 cortesía de limpieza facial susy entro 1:00\r\n30/dic/13 depilacion de cejas reyna\r\n20/feb/14 limpieza de acne con amp. desincrustante yusiria entro 1:05\r\n24/07/14 lim de acne martha mega 4:40\r\n6/nov/14 limpieza de acne brenda entro 5:10\r\n6/dic/14 limpieza de acne brenda entro 11:45\r\n20/dic/14 limpieza de acne 2x1 rosy entro 1:14 (mega)\r\n20/dic/14 dep.de ceja entro rosy 2:15 (mega)\r\n14/enero/15 limpieza facial 2x1 reyna entro 12:30\r\n21/01/15 serealizo un 2x1 de lim acne atendio mari cristal entro alas 4.15\r\n10/02/15 serealizo un 2x1 de lim acne atendio gracela cristal entro ala 3.15\r\n                 llevo jabon acnipop y locion biocontrol y hydragel sebum control \r\n02-03-15 se realizo lim facial 2x1 entro 12-35 pm atendio mary\r\n30/abril/15 limpieza de acne 2x1 lucerito entro 3:15 (mega)\r\n23/mayo/15 limpieza de acne rosy entro 1:05 (mega)\r\n11/junio/15 limpieza de acne 2x1 martha entro 3:05 (mega)\r\n14/SEPTIEMBRE/15 LIMPIEZA DE ACNE Y DEP. CEJAS MARIBEL ENTRO 3:10 (MEGA)\r\n29/enero/16 limpieza de acne 2x1 andrea entro 3:00 (mega)\r\n11/febrero/16 limpieza de acne 2x1 andrea entro 1:10 (mega)\r\n18/febrero/16 limpieza de acne  2x1 martha entro 1:05 (mega)\r\n03/marzo/16 limpieza de acne 2x600 andrea entro 3:55 (mega)\r\n18/marzo/16 limpieza de acne y dep. bigote andrea entro 2:15 (mega)\r\n25-08-16 se realizo l-f 2x600 cristal candy4:00 \r\n11/febrero/15 limpieza capilar mariana entro 4:00\r\n21/febrero/15 limpieza de acne martha entro 2.05 mega\r\n25/marzo/15 limpieza de acne 2x1 lucero entro 1:25\r\n13/abril/15 micro mirena entro 5:45\r\n8/mayo/15 micro ana entro 4:00\r\n16/mayo/15 limpieza facial 2x600 mirena entro 2:05\r\n3/junio/15 limpieza de acne 2x600 maribel entro 3:30\r\n24/junio/15 limpieza  de acne 2x600 lucy entro 3:33\r\n8/julio/15 limpieza facial 2x600 eva entro 12:30\r\n23/sept/15 limpieza de acne 2x600 mariana entro 4:20\r\n28/sept/15 micro graciela entro 5:35\r\n4/nov/15 limpieza de acne 2x600 fernanda entro 10.25\r\n12/NOV/15 TRATAMIENTO DE ACNE. EVA MEGA. ENTRO 11:10.\r\nLLEVO HYDRAGEL ELASTINE Y CREMA REAFIRMANTE ESPECIAL BRAZOS PERFECT FRONS\r\n2/dic/15 limpieza de acne con amp. equilibrante de germine graciela entro 1:15\r\n9/dic/15 limpieza de acne fernanda entro 5:20\r\nINICIA TRATAMIENTO DE MICRODERMOABRASIÓN $650.00 cada sesion\r\nllevo glycocell, crema clear y heliocare gel\r\n10/dic/15 micro graciela entro 4:55\r\n21/dic/15 micro mary lazaro entro 12:35\r\n29/dic/15 micro mary lazaro entro 9:15\r\n6/ene/16 limpieza de acne fernanda entro 12:40\r\n7/ene/16 micro mariana entro 11:00\r\n13/ene/16 limpieza de acne 2x600 y dep de cejas mary lazaro entro 1:35\r\n9/marzo/16 micro mary lazaro entro 1:10\r\n30/marzo/16 limpieza de acne 2x600 mary lazaro entro 1:20\r\nincia carboxiterapia pago 20 sesiones $2500.00 apagado\r\n1.-30/marzo/16 carbox mary lazaro entro 1:20\r\n30/marzo/16 llevo locion y shampoo pilosome\r\n2.-CARBO 01/abril/16 mary lazaro entro 10:35\r\n3.-CARBO 5/abril/16 mary lazaro entro 11:10\r\n4.-CARBO 7/abril/16 mary lazaro entro 12:50\r\n5.-CARBO 13/abril/16 mary lazaro entro 11:30\r\n13/abril/16 limpieza de acne mary lazaro entro 11:45\r\n6.-CARBO 15/abril/16 mary lazaro entro 12:20\r\n7.-CARBO 15/abril/16 mary lazaro((( se la puso al licenciado oscar brindis))\r\n8.-CARBO 18/abril/16 mary lazaro entro 12.30\r\n18/abril/16 tbx 1/3 sup $6000.00 dr. oscar garcia\r\n9.-CARBO 22/abril/16 reyna\r\n10.-CARBO 3/mayo/16 mary lazaor entro 12.35\r\n11.-CARBO 6/mayo/16 reyna entro 3:00\r\n12.-CARBO 17/mayo/16 reyna entro 4:20\r\n13.-CARBO 23/mayo/16 reyna entro 5.50\r\n14.-CARBO 30/mayo/16 reyna entro 5:05\r\n15.-CARBO 08/junio/16 mary lazaro\r\n16.-CARBO 10/junio/16 anita\r\n17.-CARBO\r\n18.-CARBO\r\n19.-CARBO\r\n20.-CARBO\r\n27/abril/16 limpieza facial 2x600 y dep de cejas mariana entro 3:00\r\n6/mayo/16 micro mary lazaro entro 1:00\r\n17/mayo/16 limpieza de acne 2x600 reyna entro 4:20\r\n23/mayo/16 micro reyna entro 6:00\r\n30/mayo/16 promocion de colageno y planchado de cejas  reyna entro 5:05\r\n30/mayo/16 llevo peeling scrub y full lashes.\r\n8/junio/16 limpieza facial  2x600 y dep, bigote lizvet entro 12:40\r\n10/junio/16 micro anita entor 5:00\r\n17/junio/16 limpieza de acne ofelia entro 3:35\r\n24/junio/16 limpieza de acne y lifting#2 reyna entro 3:45\r\n29/junio/16 micro ofelia entro 1:35 llevo oxygen mousse natura bisse\r\n6/julio/16 limpieza de acne 2x600 y dep de cejas mary lazaro entro 1:40\r\n12/julio/16 micro anita entro 3:\r\n20/julio/16 limpieza de acne 2x600  y planchado de cejas reyna entro 2:00\r\n30/julio/16 micro ofelia entro 10:30\r\n3/agosto/16 limpieza facial 2z600 anita entro 2:00\r\n19/agosto/16 micro ofelia entro 11:50\r\n19/agosto/16 emulsion excel therapy 02, body lotion tiare, esencia restauradora brillo y juventud \r\n31/agosto/16 limpieza de acne susy entro 4:15\r\n6/sept/16 mdm full relax 2x500 mary lazaro entro 3:25\r\n19/sept/16 limpieza facial ofelia entro 2:15\r\n3/oct/16 limpieza de acne 2x500 ofelia entro 12:15\r\n18/oct/16 limpieza facial 2x500  y planchado de cejas ofelia entro 11:35\r\n22/oct/16 micro ofelia entro 12:00\r\n24/oct/16 botox 1/3sup $6000.00 dr. oscar garcia \r\n28/oct/16 limpieza facial 2x500 anita entro 12:20\r\n8/nov/16 limpieza de acne 2x500 ofelia entro 4:00\r\n18/nov/16 lipieza de acne 2x500  y dep bigote mary lazaro entro 11:35\r\n25/no/16 limpeiza de acne 2x500 reyna entro 11:50\r\n5/dic/16 promocion trat multivitaminico reyna entro 12:40\r\n16/dic/16 limpieza facial y planchado ofelia entro 12:25\r\n29/dic/16 limpieza facial 2x600 ofelia entro 9:00\r\n12/ene/17 promocion desintoxicante carmene entro 4:05\r\n18/ene/17 limpieza facial y planchado de cejas ofelia entro 2:15\r\n23/ene/17 micro susy entro 3:30\r\n31/enero/17 llevo locion reparadora intensiva the cure natura bisse\r\n4/feb/17 limpieza de acne y dep de ceja sofelia entro 11:15\r\n14/feb/17 limpieza de acne ofelia entor 11:05\r\n24/feb/17 limpieza de acne mary lazaro entro 11:25\r\n1/marzo/17 limpieza de acne con amp. de oxigeno anita entor 3:15\r\n10/marzo/17 limpieza facial ofelia entro 12:50\r\n22/marzo/17 limpieza de acne carmen entro 3:50\r\n31/marzo/17 limpieza de acne charito entro 3:15\r\n10/abril/17 limpieza facial de acne 2x600 anita entro 3:15\r\n17/abril/17 limpieza de acne con amp. acido hialuronico, planchado de cejas ofelia\r\n28/abril/17 limpieza de acne anita entro 3:40\r\n3/mayo/17 limpieza de acne, planchado de cejas ofelia entro 4:00\r\n15/mayo/17 botox dr. oscar\r\n22/mayo/17 limpieza de acne charito entro 2:00\r\n29/mayo/17 limpieza de acne, planchado de cejas ofelia entro 1:35\r\n8/junio/17 limpieza de acne lucy entro 5:10\r\n12/junio/17 micro, depilacion de cejas ofelia entro 10:15\r\n29/junio/17 depilacion de cejas y limpieza de acne ofelia entro 12:00\r\nllevo crema chauffante\r\n5/julio/17 micro mary lazaro entro 2:30\r\n11/julio/17 limpieza de acne con amp. de colageno ofelia entro 3.45 llevo mousse oxigen de natura bisse \r\n24/julio/17 limpieza facial 2x600 con amp. beauti 2 y planchado de cejas ofelia\r\n31/julio/17 micro anita entro 12.00\r\n5/agosto/17 limpieza facial 2x600 mary lazaro entro 1:00\r\n11/agosto/17 micro ofelia entro 11:15\r\n31/agosto/17 limpieza facial ofelia entro 11:25\r\n12/sept/17 promocion resveratrol  y dep de bigote charito entro 12:10\r\n15/sept/17 limpieza facial y dep de cejas ofelia entro 5:20\r\n2/oct/17 limpieza facial de acne 2x600 anita entro 1:10\r\n13/oct/17 limpieza de acne 2x600, planchado de cejas ofelia\r\n20/oct/17 micro con amp. de colageno ofelia entro 12:40\r\n30/oct/17 micro ofelia entro 12:20\r\n7/nov/17 limpieza de acne 2x600 ofelia entro 1:20\r\n11/nov/17 reflexologia podal 2x400 mary lazaro entro 1:00\r\n16/nov/17 limpieza facial 2x600 ofelia entro 3:15\r\n24/nov/17 limpieza de acne mary lazaro entro 4:50\r\n29/nov/17 botox dr. oscar\r\n6/dic/17 micro cristales ofelia entro 3:45\r\n15/12/17 DEBE 1400 DEL FACIAL DE PTV \r\n15/12/17 1 PTV HYDRACURE OFELIA ENTRO 11:25 (APLICO AMPOLLETA DE COLÁGENO Y MASCARILLA DE ORO )\r\n22/12/17 2 PTV (APLICO LA AMPOLLETA HIALURÓNICO) OFE ENTRÓ 11:00\r\n22/11/17 SE LLEVO JABON ACNIPOP, FÓRMULA DETOX-ILUMINADORA, BIO CONTROLE\r\n29/12/17 PTV (APLICO AMPOLLETA DE ÁCIDO HIALURÓNICO Y MASCARILLA TYMAXLING CON GASA)\r\n30/12/17 PLANCHADO DE CEJAS Y LIMPIEZA FACIAL OFE ENTRO 11:25\r\n03/01/18 LIMPIEZA DE ESPALDA OFELIA ENTRO 3:15\r\n5/ENERO/18 4 PTV (AMPOLLETA DE ÁCIDO HIALURONICO, MASC. GOLD) OFELIA ENTRO 12:20\r\n26/01/18 LIMPIEZA DE ACNE OFE ENTRO ENTRO 3:30\r\n30/01/18 DEPI DE BIGOTE C/CERA, MICRO OFE\r\n7/FEB/18 LIMPIEZA DE ACNE 2X600, PLANCHADO DE CEJAS OFELIA ENTRO 12:15\r\n13/FEB/18   MICRO  OFELIA ENTRÓ 11:30\r\n23/FEB/18 MICRO, LIFTING DE COLÁGENO OFELIA ENTRO 12:00\r\n02/MARZO/18 LIMPIEZA DE ACNE CON AMP EQUILIBRANTE LUCY ENTRO 11:15\r\n9/MARZO/18 LIMPIEZA DE ACNE OFE ENTRO 2:10\r\n27/MARZO/18 LIMPIEZA DE ACNE LUPITA\r\n5/ABRIL/18 LIMPIEZA FACIAL 2 X 600 OFELIA ENTRO 2:50\r\n7/ABRIL/18  MICRO OFELIA ENTRO 10:10\r\n16/ABRIL/18  LIMPIEZA DE ACNE OFELIA\r\n17/ABRIL/18 TXB 1/3 SUP BOTOX 6.000 DOCTOR OSCAR\r\n7/MAYO/18 LIMPIEZA FACIAL 2 X 600 Y AMP CLARIFICANTE OFELIA ENTRO 3:00\r\n11/MAYO/18 LIMPIEZA FACIAL CON AMP CLARIFICANTE OFELIA ENTRO 2:20\r\n25/MAYO/18 LIMPIEZA DE ACNE CON AMP CLARIFICANTE OFELIA\r\n01/JUNIO/18 LIMPIEZA DE ACNE CON AMP DE COLÁGENO OFELIA ENTRO 12:00\r\n5/JUNIO/18      MICRO OFELIA\r\n25/JUNIO/18 LIMPIEZA DE ACNE CON AMP. CLARIFICANTE DE GERMAINE OFELIA ENTRO 2:10\r\n25/JULIO/18 LIMPIEZA DE ACNE   ANITA ENTRO 1:40\r\n10/AGOSTO/18 LIMPIEZA DE ACNE 2 X 600 CON AMP DE COLÁGENO OFELIA\r\n31/AGOSTO/18 LIMPIEZA DE ACNE  OFELIA\r\n22/SEP/18 LIMPIEZA DE ACNE OFELIA\r\n11/OCT/18 LIMPIEZA DE ACNE OFELIA\r\n17/OCT/18 LIMPIEZA DE ACNE CON AMP ACIDO HIALURONICO OFELIA \r\n24/OCT/18 TX B 1/3 SUP BOTOX  DR OSCAR\r\n5/NOV/18 LIMPIEZA DE ACNE Y AMP DE ÁCIDO HIALURÓNICO MARY\r\n12/NOV/18 LIMPIEZA DE ACNE OFELIA\r\n15/NOV/18 LIMPIEZA DE ACNE OFELIA\r\n15/NOV/18 LLEVO CREMA  PUREXPERT \r\n20/NOV/18 LIMPIEZA DE ACNE OFELIA\r\n26/NOV/18 LIMPIEZA DE ACNE MONICA ENTRO 3:45\r\n30/NOV/18 LIMPIEZA DE ACNE CON AMP DE COLÁGENO OFELIA\r\n9/ENE/19 LIMPIEZA DE ACCE  KARLA ENTRO 5:05\r\n17/ENERO/19 LIMPIEZA DE ACNE OFELIA ENTRO 12:10\r\n24/ENERO/19 LIMPIEZA DE ACNE OFELIA ENTRO 11:40\r\n13/MARZO/19 LIMPIEZA DE ACNE 2 X 600 LUCY ENTRO 12:20\r\n21/MARZO/19  LIMPIEZA DE ACNE OFELIA ENTRO 12:15\r\n11/ABRIL/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY ENTRO 11:45\r\n13/ABRIL/19 TXB 1/3 SUP BOTOX 6,000 DR OSCAR\r\n2/MAYO/19 LIMPIEZA DE ACNE OFELIA ENTRO 2:15\r\n6/ENERO/20 DEBE 5600.00 DESDE 30 NOVIEMBRE DEL 2018', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('594', 'C-100594', '', 'MARTHA MIER Y TERAN MORET', '9931609941', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('595', 'C-100595', '', 'JOSE VICTOR PEDRERO HERNANDEZ', '9931571759', '', '23-01-16 SE REALIZO PROMO DEL MES CRISTAL SUSSY  5 PM\r\n26/feb/16 limpieza facial lizvet entro 1:55\r\n21-04-16 se realizo prom del mes cristal martha 5pm\r\n15/diciembre/16 prom. del mes multivitaminico rosy entro 1:00 (mega)\r\n17/junio/17 prom. del mes trat. antioxidante anita entro 1:00 (mega)\r\n15/diciembre/17 prom. del mes trat. gold monica entro 2:55 (mega)\r\n04/agosto/18 prom. del mes trat. humectante lupita entro 1:05 (mega)\r\n08/diciembre/18 prom. del mes trat. diamante rosy entro 11:00 (mega)\r\n18/SEPTIEMBRE/2020 TRATAMIENTO FACIAL REVITALIZANTE OFELIA ENTRO 12:00\r\n18/NOV/2021 PROMO. TRAT. TENSOR MONICA ENTRO 14:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('596', 'C-100596', '', 'LOURDES TREJO PEREZ', '9931018369', '', '30/oct/15 prp $7000.00 y botox $5000.00 dr. oscar garcia\r\n17/diciembre/15 prom. del mes trat. reafirmante eva entro 6:15 (mega) tiene claustrofobia y no aguanto la mascarilla modeladora se le puso de elastina \r\n10/enero/16 microdermoabracion rosy entro 12:05 (mega)\r\n01/febrero/16 microdermoabrasion candy entro 2:55 (mega)\r\n28/febrero/16 microdermoabrasion candy entro 10:55 (mega)\r\n13/marzo/16 microdermoabrasion candy entro 11:00 (mega)\r\n03/abril/16 microdermoabrasion andrea entro 1:15 (mega)\r\n16/abril/16 prp cce $700.00 rsng $7000.00, txb 1/3 suo $6000.00 sr. oscar garcia\r\n28/oct/16 prp cce $7000.00 txb 1/3 supo $6000.00 dr. oscar garcia\r\n19/mayo/17 PRP CCE 7.0, TXB 1/3 SUP 6.0 Dr. Oscar\r\n27/nov/17 prp, botox dr. oscar\r\n05/febrero/18 prom. del mes trat. multivitaminico susy entro 2:00 (mega)\r\n18/febrero/18 prom. del mes trat. multivitaminico susy entro 11:25 (mega)\r\n18/ABRIL/18 PRP CCE 7,000 - TXB 1/3 SUP 6,000 DOCTOR OSCAR\r\n23/julio/18 promocion del mes atendio rosy entro 5.00 (mega)\r\n27/agosto/18 prom. del mes tra. humectante charito entro 5:00 (mega)\r\n25/OCT/18 TXB 1/3 SUP BOTOX DR OSCAR\r\n03/enero/19 prom. del mes trat. revitalizante mary entro 4:00 (mega)\r\n10/ABRIL/19 TXB 1/3 SUP Y 10 PLATISMA 8,000 DR OSCAR\r\n01/OCT/19 PROM. DEL MES DOBLE ACCION YANETH ENTRO 1.05 MEGA\r\n22/NOVIEMBRE/19 TXB 1/3 SUP BOTOX 6,000.00 DR OSCAR\r\n27/ENERO/2020 TRATAMIENTO DESINTOXICANTE ROSY ENTRO 12:55 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('597', 'C-100597', '', 'AMADA DE LA CRUZ CASTILLO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('598', 'C-100598', '', 'HECTOR CAMARA ORDAZ', '9931561707', '', '28/marzo/17 promocion estimulante del colageno con luz leds anita entro 5:00\r\n17/nov/17 promocion termico humectante mary lazaro entro 1:30\r\n23/MARZO/19 PROM TRATAMIENTO FACIAL DETOX LUCY ENTRO 11:10\r\n13/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE OFELIA\r\n13/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE OFELIA\r\n8/MAYO/2023 PROMO TRATAMIENTO FACIAL MAGIC FACE KARLA ENTRFO 3:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-06 15:09:09', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('599', 'C-100599', '', 'MARGARITA DEL CARMEN PALOMEQUE HERNANDEZ', '9931595414', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('600', 'C-100600', '', 'YOLANDA MONDACA QUEVEDO', '9931753305', '', '14/ABRIL/2023 1RA. LASER DE BIGOTE, MENTON, MEJILLAS AUTOM. 18 SRA. BEGO BRASILEÑO AUT 10J/100MS 10J LUCY\r\n15/MAYO/2023 2DA. BIOGTE, MENTON, MEJILLA AUTOM. 18 J, BRASILEÑA AUTOM. 10 J/100 MS 11 J LUCY\r\n21/JUNIO/2023 3º BIGOTE,  MENTON, MEJILLA, PATILLAS AUTOM. 12 J, BRASILEÑA AUTOM. 12 J/30 MS 12 J OFELIA ENTRO 11:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-21 13:43:53', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('601', 'C-100601', '', 'MARISSA QUEVEDO DE MONDACA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('602', 'C-100602', '', 'AGUSTINA LOPEZ LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('603', 'C-100603', '', 'MARCELA VIDAL DE FERNANDEZ', '', '', '7/ene/16 limpieza facial con amp. desincrustante lizvet entro 1:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('604', 'C-100604', '', 'MARIA ELENA RUIZ OSORIO', '9935900673', '', '12/abril/17 limpieza facial 2x600 charito entro 10:25\r\n24/abril/17 promocion termico ofelia entro 9:35\r\n4/mayo/17 promocion antiedad con lifting ofelia entro 10:20', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('605', 'C-100605', '', 'OSCAR DAVID BRINDIS GONZALEZ', '9931888290', '', '15/agosto/07 limpieza facial 2 x 1 lupita entro 10:10\r\n03/sept/07 limpieza facial 2 x 1 ligia entro 11:00 salio 12:10\r\n17/sept/07 limpieza facial 2 x 1 lupita\r\n25/oct/07 limpieza facial marcela entro 3:00\r\n7/ene/08 limpieza facial lupita entro 11:00\r\n2/junio/08 promocion 3 geles lupita entro 10:00 \r\n30/junio/08 promocion catiodermia odet entro 11:35 \r\n5/sept/08 limpieza facial 2 x 1 sara entro 10:35 \r\n10/oct/08 limpieza facial 2 x 1 araceli entro 6:10 \r\n15/oct/08 limpieza facial 2 x 1 julia entro 11:10 \r\n8/dic/08 promocion vitamina c julia entro 12:40\r\n30/ene/09 promocion jalea real mary entro 3:05 \r\n13/feb/09 promocion percollagen gladys entro 12:10 \r\n4/mazo/09 promocion spa therapy perla mary entro 4:45 \r\n31/marzo/09 promocion spa therapy oro sara entro 1:30\r\n14/mayo/09 promocion intesivo parp y labios y amp \r\nserum equilibrante intensiva mary m\r\n17/junio/09 promocion white line araceli entro 10:20 \r\n20/julio/09 promocion extraperformance sara entro 11:00\r\n3/agosto/09 limpieza facial 2 x 1 con amp. hidratante sara entro 10:45\r\n12/agosto/09 limpieza facial 2 x 1 karina entro 11:45 \r\n31/agosto/09 limpieza facial 2 x 1 sara entro 12:10\r\n15/sept/09 limpieza facial 2x1 sara\r\n29/sept/09 promocion termico de azuleno sara entro 10:45 \r\n14/oct/09 limpieza facial 2x1 reyna entro 12:25\r\n28/oct/09 limpieza facial 2 x 1 lucy entro 9:40 salio 11:00\r\n11/nov/09 limpieza facial 2 x 1 karina entro 6:15\r\n2/dic/09 limpieza facial 2 x 1 karina entro 11:30\r\n16/dic/09 limpieza facial 2 x 1 gladys entro 3:00\r\n30/dic/09 limpieza facial 2x1\r\n6/enero/10 limpieza facial 2x1 marina entro 12:15\r\n20/ene/10 limpieza facial 2 x 1 lupita entro 11:40\r\n27/ene/10 limpieza facial 2x1 marina entro 1:35 \r\n17/feb/10 limpieza facial 2 x 1 sara entro 12:50 salio 2:00 \r\n24/feb/10 limpieza facial 2 x 1 con amp. hidratante karina entro 11:15\r\n8/marzo/10 promocion de cristal lupita entro 1:00 \r\n31/marzo/10 limpieza facial 2 x 1 sara\r\n7/abril/10 limpieza facial 2x1 rosy\r\n21/abril/10 limpieza facial 2x1 mary l \r\n28/abril/10 limpieza facial 2 x 1 gladys entro 1:25 \r\n5/mayo/10 limpieza facial 2 x 1 ofe entro 12:10 \r\n19/mayo/10 limpieza facial 2 x 1 mariana entro 3:15 \r\n2/junio/10 limpieza facial 2x1 karina entro 12:25\r\n16/junio/10 limpieza facial 2x1 sara entro 1:05\r\n23/junio/10 limpieza facial 2 x 1 karina\r\n30/junio/10 limpieza facial 2x1 mariana\r\n7/julio/10 limpieza facial 2 x 1 lupita entro 5:10\r\n14/julio/10 limpieza facial 2 x 1 mariana entro 3:40\r\n21/julio/10 limpieza facial 2 x 1 mariana entro 3:40 \r\n28/julio/10 limpieza facial 2 x 1 mariana entro 11:25\r\n11/agosto/10 limpieza facial 2 x 1 indira entro 12:05\r\n18/agosto/10 limpieza facial 2x1 sara entro 1:25\r\n1/sept/10 limpieza facial 2 x 1 sara entro 10:30\r\n10/sept/10 promocion termico karina entro 11:50 \r\n20/sept/10 limpieza facial 2 x 1 mariana entro 2:00 salio 3:00\r\n13/oct/10 limpieza facial 2x1 mariana entro 1:15\r\n20/oct/10 limpieza facial 2 x 1 araceli entro 11:35 \r\n27/oct/10 limpieza facial 2 x 1  lucy entro 1:20\r\n8/nov/10 limpieza facial 2 x 1 mariana entro 1:05\r\n16/nov/10 limpieza facial 2 x 1 marina entro 3:22\r\n24/nov/10 limpieza facial 2 x 1 mariana entro 12:30 \r\n9/dic/10 limpieza facial 2 x 1 mariana entro 3:11 salio 4:18 \r\n22/dic/10 limpieza facial 2 x 1 araceli entro 2:30 \r\n29/dic/10 limpieza facial 2 x 1 mariana entro 1:30 \r\n12/ene/11 limpieza facial 2 x 1 mariana entro 11:41 \r\n19/ene/11 limpieza facial 2 x 1 mariana entro 2:00\r\n26/ene/11 limpieza facial 2 x 1 susy entro 11:45 \r\n2/feb/11 limpieza facial 2 x 1 deyanira entro 9:55 \r\n16/feb/11 limpieza facial 2 x 1 gladys entro 11:00 \r\n23/feb/11 limpieza facial 2 x 1 araceli \r\n2/marzo/11 limpieza facial 2 x 1 gladys entro 1:25 \r\n9/marzo/11 limpieza facial 2 x 1 gladys entro 12:00\r\n16/marzo/11 limpieza facial 2 x 1 gladys\r\n23/marzo/11 punta de diamante  reyna\r\n30/marzo/11 limpieza facial 2 x 1 mariana entro 12:50\r\n13/abril/11 limpieza facial 2 x 1 mariana entro 11:30\r\n2/mayo/11 limpieza facial 2 x 1 graciela entro 12:05(suc)\r\n4/mayo/11 limpieza facial 2 x 1 con amp. beaute ii karina entro 11:25\r\n9/mayo/11 limpieza facial 2 x 1 mariana entro 11:15\r\n16/mayo/11 limpieza facial 2 x 1 sara entro 11:35\r\n25/mayo/11 limpieza facial 2 x 1 deyanira entro 11:10\r\n02/06/11 limpieza facial 2x1 atendio:graciela entro:2:20 salio:3:20 (suc)\r\n10/junio/11 limpieza facial 2 x 1 con amp. placent plant sara entro 2:05 \r\n10/junio/11 llevo crema facial de hidratacion activa formen\r\n22/junio/11 limpieza facial 2 x 1 mariana entro 12:00\r\n11/julio/11 limpieza facial 2 x 1 gladys entro 12:10\r\n22/julio/11 limpieza facial 2 x 1 sara entro 1:40\r\n4/agosto/11 limpieza facial 2x1 susy entro 3:15\r\n24/agosto/11 limpieza facial 2x1  susy entro 5:00\r\n31/agosto/11 limpieza facial con ampolleta para piel grasa 2x1 2x1 sara entro 2:20\r\n14/sep/11 limpieza facial  2x1 reyna entro 12:50\r\n21/sep/11 limpieza facial 2x1 mariana entro 1:45\r\n06/oct/11 limpieza facial 2x1 karina entro 1:55\r\n26/oct/11 limpieza facial 2x1 sara entro 3:50\r\n08/nov/11  limpieza facial 2x1 dulce entrop 12:15\r\n16/nov/11 limpieza facial 2 x 1 brenda entro 1:15\r\n30/11/11 limpieza facial 2x1 atendio dulce (mega)\r\n14/12/11 limpieza facail 2x1 atendio graciela (mega)\r\n26/dic/11 limpieza facial 2 x 1 rocio entro 1:50\r\n29/12/11 masaje relajante 2x1 atendio jhoany entro 3.00 (mega)\r\n4/ene/12 limpieza facial 2 x 1 mariana entro 12:50 llevo serum antifatiga formen\r\n17/ene/12 limpieza facial 2 x 1 aracely entro 12:45\r\n21/ene/12 limpieza facial 2 x 1 sara entro 2:00\r\n1/feb/12 limpieza facial 2 x 1 lucy entro 1:25\r\n9/feb/12 limpieza facial 2 x 1 mariana\r\n16/feb/12 limpieza facial 2 x 1 con amp. equilibrante mariana entro 12:40\r\n28/feb/12 limpieza facial 2 x 1  mariana entro 12:40\r\n9/marzo/12 limpieza facial 2 x 1 aracely entro 2:05\r\n21/marzo/12 limpieza facial 2 x 1 mariana entro 3:00\r\n4/abril/12 limpieza facial 2 x 1 mariana entro 12:00\r\n30/abril/12 limpieza facial 2 x 1 con amp. equilibrante mariana entro 1:10\r\n8/mayo/12 promocion velo de colageno gladys entro 12:55 llevo rollon de ojos formen\r\n17/mayo/12 limpieza facial 2 x 1 gladys entro 1:10\r\n26/mayo/12 promocion velo de colageno gladys entro 12:10\r\n5/junio/12 limpieza facial 2 x 1 aracely entro 2:25\r\n18/junio/12 limpieza facial 2 x 1 de cortesia lifting # 2 gladys entro 2:50\r\n25/junio/12 limpieza facial 2 x 1 mariana entro 11:25\r\n2/julio/12 limpieza facial 2 x 1 sara entro 2:00\r\n14/julio/12 mdm 2 x 1 lucy entro 1:50\r\n24/julio/12 limpieza facial 2 x 1 araceli entro 12:00\r\n2/agosto/12 limpieza facial gladys entro 1:00\r\n15/agosto/12 limpieza facial 2 x 1 gladys entro 2:25\r\n27/agosto/12 limpieza facial 2 x 1 lucy entro 4:35\r\n5/sept/12 limpieza facial 2 x 1 graciela entro 2:15\r\n21/sept/12 limpieza facial 2 x 1 gladys entro 1:20\r\n29/sept/12 limpieza facial 2 x 1 araceli \r\n8/oct/12 limpieza facial 2 x 1 karina entro 1:35\r\n18/oct/12 limpieza facial 2 x 1 mariana entro 4:50\r\n27/oct/12 limpieza facial 2 x 1 mariana entro 2:10\r\n5/nov/12 limpieza facial 2 x 1 mariana entro 4:25\r\n9/nov/12 limpieza capilar gladys entro 3:00\r\n12/nov/12 limpieza facial 2 x 1 mariana entro 2:00\r\n22/nov/12 limpieza facial 2 x 1 araceli entro 11:00\r\n28/nov/12 limpieza facial 2 x 1 reyna entro 2:35\r\n13/dic/12 limpieza facial 2 x 1 karina entro 11:00\r\n2/enero/13 limpieza facial 2 x 1 lucy \r\n14/ene/13 limpieza facial 2 x 1  graciela entro 1:05\r\n14/feb/13 limpieza facial de cortesia ofelia entro 11:50\r\n13/mayo/13 limpieza facial 2 x 1 gladis entro 12.40\r\n30/mayo/13 limpieza facial 2 x 1 martha entro 12:00\r\n5/nov/13 limpieza facial 2 x 1 mariana entro 3:15\r\n11/nov/13 mdm cliente frecuente nelli entro 4:00\r\n22/nov/13 limpieza facial 2 x 1 susy\r\n10/dic/13 limpieza facial 2 x 1 mariana entro 1:20\r\n28/dic/13 cortesia limpieza facial yusiria entro 1:00\r\n30/dic/13 cortesia mdm geotermal susy entro 12:00\r\n20/feb/14 limpieza facial con amp. desincrustante nelli entro 1:05\r\n6/nov/14 limpieza facial lucero entro 5:10\r\n20/dic/14 limpieza facial 2x1 nelly entro 1:14 (mega)\r\n14/enero/15 limpieza facial 2x1 brenda entro 12.30\r\n21/01/15 serealizo un 2x1 de lim facial atendio susy cristal entro ala 4..15\r\n10/02/15 serealizo un 2x1 de lim facial atendio mari cristal entro alas 3.15\r\n07-03-15 se realizo masaje full relax promocion atendio mary. entro 12-20\r\n8/mayo/15 mdm full relax (cliente frecuente) eva entro 4:00\r\n16/mayo/15 limpieza facial 2x600 maribel entro 2:05\r\n03/junio/15 limpieza facial 2x600 eva entro 3:30\r\n24/junio/15 limpieza facial 2x600 mariana entro 3:33\r\n8/julio/15 limpieza facial 2x600 mariana entro 12:30\r\n20/agosto/15 mdm full relax (cliente frecuente) reyna entro 5:00\r\n14/SEPTIEMBRE/15 LIMPIEZA FACIAL  2X1 SUSY ENTRO 3:10 (MEGA)\r\n23/sept/15 limpieza facial 2x600 candy entro 4:20\r\n8-10-15 se realizo limp facial 2x1 5 mirena cristal\r\n4/nov/15 limpieza de acne charito entro 10.25\r\n12/NOV/15 LIMPIEZA FACIAL. ANDREA  MEGA.  ENTRO 11:10.\r\n5/dic/15 limpieza facial mariana entro 11.50\r\n9/dic/15 masaje full relax (cliente frecuente) lizvet teno 5:25\r\n21/dic/15 limpieza facial con gelula verde fernanda entro 12:35\r\n6/ene/16 limpieza facial 2x600 lizvet entro 12.35\r\n13/ene/16 limpieza facial 2x600 lizvet entro 1:35\r\n29/enero/16 limpieza facial 2x1 candy entro 3:05 (mega)\r\n11/febrero/16 limpieza facial 2x1 rosy entro 1:10 (mega)\r\n18/febrero/16 limpieza facial 2x1 rosy entro 1:05 (mega)\r\n03/marzo/16 limpieza facial 2x600 candy entro 3:55 (mega)\r\n9/marzo/16 mdm full relax charito entro 2:00\r\n18/marzo/16 limpieza facial 2x600 candy entro 2:15 (mega)\r\n30/marzo/16 limpieza facial 2x600 carmen entro 1:20\r\n13/abril/16 limpieza facial 2x600 maria entro 11:10\r\n18/abril/16 prp cc $7000.00 dr. oscar garcia\r\n27/abril/16 limpieza facial 2x600 carmen entro 3:00\r\n6/mayo/16 mdm holistico y facial con lifting lizvet entro 12:40\r\n17/mayo/16 limpieza facial 2x600 lizvet entro 4:15\r\n30/mayo/16 mdm holístico y facial con lifting#2 lizvet entro 5:10\r\n8/junio/16 limpieza facial 2z60 mariana entro 12:30\r\n17/junio/16 limpieza facial mirena entro 4:00 QUEDO PENDIENTE EL MASAJE DE ESPALDA DE 30 MINUTOS\r\n24/junio/16 masaje de espalda carmen entro 3:45 ERA EL QUE LE DEBÍAMOS\r\n29/junio/16 masaje fullr elax (cliente frecuente) mariana entro 1:35\r\n6/julio/16 limpieza facial 2x600 maria entro 1:40\r\n13/julio/16 mdm full relax cliente frecuente charito entro 6:15 (mega)\r\n20/julio/16 limpieza facial 2x600 lucy entro 2:00\r\n3/agosto/16 limpieza facial 2x600 mirena entro 2:00\r\n19/agosto/16 mdm full relax cliente frecuente anita entro 11:15\r\n25-08-16 se realizo l-f2x600 cristal rosy 4:00\r\n31/agosto/16 limpieza facial mirena entro 4:15\r\n6/sept/16 mdm full relax 2x500 maria entro 3:25\r\n19/sept/16 limpieza facial maria entro 2:15\r\n3/oct/16 limpieza facial 2x500 mariana entro 12:15\r\n18/oct/16 limpieza facial 2x500 mariana entro 11:35\r\n22/oct/16 masaje full relax 2x500 andrea entro 12:05\r\n28/oct/16 limpieza facial 2x500 charito entro 12:20\r\n8/nov/16 limpieza facial 2x500 mariana entro 4:00\r\n18/nov/16 limpieza facial 2x500 charito entro 11:35\r\n25/nov/16 masaje full relax (cliente frecuente) y limpieza facial 2x500 mariana entro 11:50\r\n5/dic/16 promocion trat multivitaminico mariana entro 12:40\r\n16/dic/16  limpieza facial 2x600 anita entro 12.35\r\ndejo pagado una limpieza facial basica\r\n12/ene/17 promocion desintoxicante susy entro 4:05\r\n23/ene/17 limpieza facial mariana entro 3.30 (era la que tenia pagada) \r\n4/feb/17 limpieza facial rosy entro 11:15\r\n14/feb/17 promocion trat de elastine mariana entro 11.05\r\n24/feb/17 limpieza facial 2x600 andrea entro 11.15\r\n1/marzo/17 limpieza facial 2x600 andrea entro 3:15\r\n10/marzo/17 masaje full relax (cleinte frecuente) monica entro 12:50 \r\n22/marzo/17 promocion estimulante de colageno con leeds yennifer entro 3:50\r\n\r\n10/abril/17 limpieza facial 2x600 charito entro 3:15\r\n28/abril/17 promocion termico mariana entro 3:40\r\n15/mayo/17 prp dr. oscar\r\n29/mayo/17 promocion antiedad con lifting carmen entro 1:35\r\n8/junio/17 mdm full relax cliente frecuente monica entro 5:00\r\n29/junio/17 promocion antioxidante yeni entro 11:25\r\n5/julio/17 masaje fullr elax (cliente frecuente) andrea entro 2:30\r\n11/julio/17 promocion relajante e hidratante lizvet entro 3:30\r\n24/julio/17 limpieza facial 2x600 susy entor 12.25\r\n5/agosto/17 limpieza facial 2x600 yeni entro 2:00\r\n11/agosto/17 micro anita entro 1:30\r\n31/agosto/17 limpieza facial con amp. de ácido hialurónico y planchado de cejas  anita entro 11.20 \r\n12/sept/17 promocion resveratrol mariana entro 12:10\r\nLE QUEDO PAGADA UNA LIMPIEZA FACIAL DEL 2X1 \r\n23/sept/17 limpieza facial carmen entro 1:55 (mega)\r\n2/oct/17 limpieza facial 2x600 monica entro 1:10\r\n13/oct/17 limpieza facial 2x600 anita entro 1:15\r\n20/oct/17 mdm full relax cliente frecuente monica entro 12:40\r\n30/oct/17 promocion reafirmante anita entro 12:25\r\n7/nov/17 limpieza facial 2x600 lucy entro 1:20\r\n11/nov/17 reflexologia podal 2x400 susy entro 1:00\r\n16/nov/17 limpieza facial 2 x 600 anita entro 3:15\r\n24/nov/17 trat de colageno de pies con botas monica entro 4:50\r\n6/dic/17 limpieza facial anita entro 3:15\r\n29/12/17 PROMOCION TRATAMIENTO GOLD SUSY ENTRO 12:10\r\n03/01/18 MASAJE CLIENTE FRECUENTE SUSY ENTRO 3:10\r\n26/01/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO MARY ENTRO 3:20\r\n7/FEB/18 LIMPIEZA FACIAL 2 X 600 MARY LAZARO ENTRO 12:15\r\n23/FEB/18  PROM TRATAMIENTO MULTIVITAMÍNICO ANITA ENTRÓ 12:00\r\n02/MARZO/18 MDM FULL RELAX CLIENTE FRECUENTE MARIANA ENTRÓ 11:15\r\n27/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA MARIANA ENTRO 11:15\r\n5/ABRIL/18 LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 2:50\r\n16/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE ANITA\r\n17/ABRIL/18 PRP CC 7,000 DOCTOR OSCAR\r\n7/MAYO/18 LIMPIEZA FACIAL 2 X 600 MARY ENTRO 3:00\r\n25/MAYO/18 LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 12:30\r\n25/JUNIO/18 PROMOCION TRAT ANTIOXIDANTE REYNA ENTRO 2:15\r\n25/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL  MONICA 1:40\r\n10/AGOSTO/18 LIMPIEZA FACIAL 2 X 600 MARY\r\n31/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE MONICA ENTRO 12:10\r\n22/SEP/18 PROM TRATAMIENTO FACIAL REGENERANTE MARY ENTRO 11:00\r\n11/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE ANITA\r\n17/OCT/18 MDM DE CLIENTE FRECUENTE MONICA\r\n25/OCT/18 PRP CC DR OSCAR\r\n5/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN MONICA-ISABEL \r\n12/NOV/18 LIMPIEZA FACIAL 2 X 600 MONICA-KARLA ENTRO 11:20\r\n30/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN \r\n9/ENE/19 LIMPIEZA FACIAL  MONICA ENTRO 5:05\r\n24/ENERO/19 LIMPIEZA FACIAL MARY LAZARO ENTRO 11:55\r\n13/MARZO/19 LIMPIEZA FACIAL 2 X 600 REYNA ENTRO  12:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('606', 'C-100606', '', 'JANETH RODRIGUEZ RAMOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('607', 'C-100607', '', 'NOEMY BANOS HERNANDEZ', '9931976471', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('608', 'C-100608', '', 'ILEANA DE LOS ANGELES CERVANTE VIDAL', '9933120560', '', '16/nov/16 limpieza facial 2x500 mirena entro 5:55\r\n21/AGOSTO/2021 MASAJE FULL RELAX 2X600 MIRENA ENTRO 8:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('609', 'C-100609', '', 'ILEANA CERVANTE VIDAL', '', '', '', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('610', 'C-100610', '', 'REYNA PALACIOS PEREZ', '9931106921', '', '10/enero/17 limpieza facial 2x600 monica entro 5:15 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('611', 'C-100611', '', 'ERIKA DE LA CRUZ DE LA CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('612', 'C-100612', '', 'REINA PALACIOS PEREZ', '9931106921', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('613', 'C-100613', '', 'ALEJANDRO LOPEZ GONZALEZ', '', '', '2/marzo/16 limpieza de acne mariana entro 1:10\r\n12/JULIO/19 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE YANETH ENTRO 12:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('614', 'C-100614', '', 'LOURDES ROMERO CAUDANA', '9931560700', '', 'inicio trat reductivo 3000.00 se le dio de cortesia carbox en abdomen\r\ncadera alta ( ombligo) 88cm peso 58 kilos\r\nllevo crema chauffante  \r\n1.-masaje 45m 25/junio/14 lucero entro 6:10\r\n2.-carbox, masaje 45m 26/junio/14 lucero entro 6:10\r\n3.-masaje45m 27/junio/14 lucero entro 6:00\r\n4.-carbox, masaje 45m 1/julio/14 lucero entro 5:55\r\n5.-masaje 45m 02/julio/14 lucero entro 6:00\r\n6.- carbox, masaje 45m 3/julio/14 lucero\r\n7.-masaje 45m 7/julio/14 lucero\r\n8.-carbox, masaje 45m 9/julio/14 mirena entro 6:05\r\n9.- masaje45m 10/julio/14 lucero entro 6:10\r\n10.-carbox, masaje45m 11/julio lucero entro : 6:10\r\ntermina tratamiento con medida en abdomen (ombligo) 83 cm\r\n28/julio/14 mdm drenaje linfatico yusiria entro 5:00\r\n29/julio/14 promocion de colageno mariana entro 6:05\r\ninicia tratamiento de celulitis $8000.00 abono $3000.00 resta $5000.00\r\n1.-lumicell 31/julio/14 yusiria entro 6:00\r\n2.-cavitacion 60 m, masaje 45 m 01/agosto/14 carmen entro 5:05\r\n3.-dermosonic 02/agosto/14 yusiria entro 12:15\r\ndesafio antiedad yusiria entro 12:15\r\n4.-lumicell 04/agosto/14 graciela entro 6:05\r\n5.-dermosonic 06/agosto/14 tusiria entro 6:15\r\n6.-lumicell 07/agosto/14 yusiria entro 6:25\r\n7.-dermosonic 11/agosto/14 reyna entro 6:00\r\n11/agosto/14 abono $3000.00 resta $2000.00\r\n8.-lumicell 12/agosto/14 ana entro 6:20\r\n9.-dermosonic 13/agosto/14 yusiria entro 6:15\r\n10.-lumicell 15/agosto/14 yusiria entro 6:20\r\n11.-cavitacion 60 m, masaje 45 m 18/agosto/14 yusiria entro 5:15\r\n12.-dermosonic 19/agosto/14 yusiria entro 6:15\r\n13.-lumicell 22/agosto/14 yusiria entro 6:00\r\n14.-dermosonic 25/agosto/14 yusiria entro 6:00\r\n15.-lumicell 26/agosto/14 yusiria entro 6:10\r\n16.-dermosonic 28/agosto/14  ana entro 6.00\r\n17.-lumicell 29/agosto/14 yusiria entro 6:10\r\n18.-dermosonic 1/sept/14 yusiria entro 6:00\r\n19.-lumicell 2/sep/14\r\n20.-dermosonic 3/sep/14 yusiria entro 6:20\r\n30/agosto/14 masaje holistico entro carmen 1:20\r\n30/agosto/14 promocion oxigenante entro carmen 1:20\r\n01/nov/14 desafio antiedad yusiria entro 12:15\r\n\r\n9/febrero/15 facial de vitamina c natura bisse mariana entro 6:00 \r\nllevo crema de dia y noche timexpert rides\r\n20/febrero/15 radio facial johany entro 5:30\r\n21/febrero/15 masja full relax  lucero entro 10.10\r\n27/febrero/15 radio facial  jhoany entro 5:30\r\n6/marzo/15 radio facial sra. bego entro 5:30\r\n17/marzo/15 radio facial mariana entro 5:45\r\n27/marzo/15 radio facial ofelia entro 5:35\r\n28/marzo/15 mdm drenaje linfatico mirena entro 1:20\r\n22/mayo/15 mdm drenaje linfatico maribel entro 5:50\r\n22/mayo/15 llevo crema recuperadora intensiva de dia timexpert srns\r\nse le recomienda llevar serum contorno de ojos, booster recuperador sincronizado y crema confort alta recuperación de timexpert srns \r\n03/julio/15 reflexologia podal candy entro 5:10\r\n28/julio/15 mdm drenaje linfatico eva entro 5:05\r\n11/sept/15 mdm drenaje linfatico eva entro 5:05\r\n9/sept/15 promocion equilibrante del ph lucy entro 1:15\r\n29/oct/15 masaje full relax fernanda entro 5:40\r\n6/nov/15 masaje drenaje linfatico reyna entro 5:00\r\n11/nov/15 tratamiento de manos reyna\r\n4/dic/15 drenaje linfatico lizvet entro 4:10\r\n5/dic/15 promocion reafirmante modeladora mariana entro 1:25\r\n16/dic/15 reflexologia podal lizvet entro 5:00\r\n16/dic/15 llevo crema royal jelly confort de germaine de capuccini para el dia y noche\r\n8/ene/16 drenaje linfatico reyna entro 4:20\r\n8/feb/16 drenaje linfatico charito entro 5:45\r\n12/feb/16 modeladora lucy entro 11:35\r\n19/feb/16 promocion roll & lift mariana entro 5:35\r\n8/abril/16 mdm drenaje linfatico maria entor 5:30\r\n\r\ninicia new lift $8000.00\r\n1.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla porcelana 11/ABRIL/16 ROSY ENTRO 5:05\r\n2.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nbotanica 19/ABRIL/16 ROSY ENTRO 5:05\r\n3.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nporcelana 20/ABRIL/16 ROSY ENTRO 6:00\r\n4.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nbotanica 21/ABRIL/16 ROSY ENTRO 5:05\r\n5.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla\r\nmodeladora 26/ABRIL/16 ROSY ENTRO 5:05\r\n6.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nmodeladora 28/ABRIL/16 ROSY ENTRO 5:05 TERMINO DE PAGAR EL TRATAMIENTO.\r\n7.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nmodeladora  5/MAYO/16 ROSY ENTRO 5:00\r\n13/mayo/16 mdm drenaje linfatico lucy entro 5:05\r\n8.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla\r\nmodeladora  16/MAYO/16 REYNA ENTRO 5:00\r\n9.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nmodeladora\r\n10.-limpiar, brosh, oxigeno 5m, linfatico 10m, new lift, lifting #2, beauti 1, mascarilla \r\nmodeladora\r\n(((OJO)))))DE LAS DOS SESIONES DE NEW LIFT QUE LE QUEDABAN SE LE DARÁN TRES MASAJE DE DRENAJE LINFÁTICO DE 80 MINUTOS TIENEN UN MES DE VIGENCIA PARA REALIZARSELO AUTORIZO LA SRA. BEGO))))\r\n13/agosto/16 promocion de caviar maria entro 12:10\r\n14/oct/16 masaje drenaje linfatico anita entro 5:30\r\n21/oct/16 facial tiempxerr rides susy entro 5:35\r\n28/oct/16 rsng vol $7000.00 dr. oscar garcia\r\n4/nov/16 facial glycocure mariana entro 5:30\r\n2/dic/16 masaje ful relax anita entro 6:10\r\n2/DIC/16 LLEVO CREMA MANOS DE ESSENTIAL SHOCK NB, EMULSION DE VITAMINA C PARA EL DIA DE GERMINE Y CREMA VITAMINA C PARA LA NOCHE DE GERMINE \r\n15/dic/16 masaje drenaje linfatico mariana entro 5:40\r\n16/ene/17 masaje drenaje linfatico carmen entro 5:20\r\n20/ene/17 facial srns de germaine de capuccini lucy entro 5:10\r\n17/feb/17 masaje drenaje linfatico anita entro 5:35\r\n17/marzo/17 mdm drenaje linfatico mariana entro 5:05\r\n18/marzo/17 promocion estimulante de colageno con leeds mariana entro 11:15\r\n18/marzo/17 llevo crema recuperadora intensiva timexpert SRNS \r\n3/mayo/17 mdm drenaje linfatico andrea entro 5:45\r\n2/junio/17 mdm sensorelax carmen entro 5:45\r\n22/junio/17 masaje hidratante susy entor 5:35\r\n24/junio/17 facial de colageno en 3D  rosy entro 12:15\r\n 1/julio/17 facial colageno 3D mary lazaro entro 1:10\r\n4/agosto/17 masaje drenaje linfatico yeni entro 5:40\r\n26/agosto/17 masaje drenaje linfatico lizvet entro 12.25\r\n06/octubre/17 mdm drenaje linfatico candy entro 6:50 (mega)\r\n22/octubre/17 mdm full relax andrea entro 4:00 (mega)\r\n28/oct/17 facial colageno 3D lucy entro 12:15\r\n9/dic/17 mdm drenaje linfatico mariana entro 12:10\r\n10/diciembre/17 prom. del mes trat. gold candy entro 11:20 (mega)\r\n12/DIC/18 MDM HOLISTICO ANITA ENTRO 6:00\r\n03/febrero/18 mdm drenaje linfatico monica entro 6:10 (mega)\r\n27/FEB/18 MDM DRENAJE LINFATICO LUCY ENTRO 5:20\r\n17/MARZO/18 PROM TRATAMIENTO CATIODERMIA OFELIA ENTRO 2:10 LLEVO CREMA RE-CREACIÓN JUVENTUD X.CEL TIMEXPERT RIDES, BRUMA SOLAR, SERUM PERFECCIONADOR X.CEL TIMEXPERT RIDES\r\n15/abril/18 mdm drenaje linfatico susy entro 4:20 (mega)\r\n20/mayo/18 prom. del mes trat. antiedad monica entro 6:10 (mega)\r\n29/MAYO/18 MDM DRENAJE LINFATICO REYNA ENTRO 4:05\r\n2/JUNIO/18 RADIO FRACCIONADA LUCY ENTRO 11:35\r\n7/JUNIO/18 MDM DESCONTRACTURANTE SUSI ENTRO 5:15\r\n9/JUNIO/18 RADIO FRACCIONADA LUCY ENTRO 12:15\r\n16/JUNIO/18  RADIO FRACCIONADA LUCY ENTRO 12:10\r\n23/JUNIO/18 RADIO FRACCIONADA LUCY ENTRO  12:00\r\n14/JULIO/18 RADIO FRACCIONADA  LUCY ENTRO 12:00\r\n1/AGOSTO/18  MDM DRENAJE LINFATICO  LUPITA  ENTRO 5:15\r\n11/AGOSTO/18 RADIO FRACCIONADA LUCY ENTRO 1:25\r\n11/SEPT/18 MDM DRENAJE LINFATICO ANITA ENTRO 5:15\r\n11/OCT/18 MDM FULL RELAX MONICA ENTRO 6:05\r\n17/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE LUCY\r\n25/octubre/18 reflexologia podal rosy entro 5:00 (mega)\r\n13/NOV/18 MDM DRENAJE LINFATICO REYNA ENTRO 5:10\r\n19/DIC/18 FACIAL VITAMINA C DE NATURA BISSÉ BELÉN ENTRO 2:10\r\n19/DIC/18 LLEVO  TIMEXPERT C+ EMULSIÓN Y CREMA\r\n28/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE Y GELULA AMARILLA BELEN\r\n25/ENERO/19 MASAJE DE DRENAJE LINFATICO LUCY ENTRO 5:05\r\n27/FEB/19 MDM DE TE VERDE MONICA ENTRO 5:20\r\n09/MARZO/19 MDM HOLÍSTICO MONY ENTRO 7:05 MEGA\r\n28/MARZO/19 PROM TRATAMIENTO FACIAL DETOX MARY ENTRO 5:15\r\n5/ABRIL/19 MDM DOMINO ANITA ENTRO 5:20\r\n14/JUNIO/19 MDM HOLISTICO LUPITA ENTRO 5:10\r\n22/JULIO/19 MDM SENSORELAX MARY ENTRO 5:25\r\n3/AGOSTO/19 DESAFIO ANTIEDAD DE NATURA BISSE OFELIA ENTRO 1:15\r\n24/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA YANETH ENTRO 12:25\r\nLLEVO ELIXIR DE GERMINE\r\n2/SEP/19 MDM FULL RELAX LUPITA ENTRO 6:00\r\n14/OCTUBRE/19 MDM DRENAJE LINFATICO ALEGRIA ENTRO 5:10\r\n23/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS ANITA ENTRO 12:20\r\n29/DICIEMBRE/19 DRENAJE LINFATICO SANDY ENTRO 5:05 MEGA \r\n10/FEBRERO/20 MDM DRENAJE LINFATICO LUPITA ENTRO 5:10\r\n1/MARZO/2020 TRATAMIENTO RECUPERADOR FACIAL JANETH ENTRO 3:05 MEGA\r\n29/MAYO/2020 MASAJE FULL RELAX ANITA ENTRO 12:40\r\n3/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD ANITA ENTRO 12:10\r\nLLEVO CONTORNO DE OJOS TIMEXPERT LIFT IN CRME SOFT Y OXYGEN MOUSSE\r\n7/OCTUBRE/2020 TRATAMIENTO DE CUELLO DE NATURA BISSE 1,800.00 LUCY ENTRO 3:15\r\n14/OCTUBRE/2020 TRATAMIENTO DE CUELLO DE NATURA BISSE MARY LAZARO ENTRO 5:10\r\nTRATAMIENTO DE BRAZOS $5000.00 (PAGA $500.00 CADA SESION)\r\n1.-REVERSE 18/NOV/2020 LUCY\r\n2.-CRIOTERAPIA 19/NOV/2020 LUCY ENTRO 4:20\r\n3.-RADIO 23/NOV/2020 LUCY ENTRO 4:30\r\n4.-CORPO 25/NOV/2020 BEGO\r\n25/NOV/2020 MASAJE DE PIES ARLETH ENTRO 3:10\r\n5.-CRIOTERAPIA 5/DIC/2020 MARY LAZARO ENTRO 1:00\r\n6.-RADIO\r\n7.-REVERSE\r\n8.-CRIOTERAPIA\r\n9.-RADIO\r\n10.-REVERSE\r\n5/MARZO/2021 PROMOCION TRAT  JHOANY ENTRO 3:00\r\n19/MARZO/2021 MASAJE FULL RELAX MARIANA ENTRO 3:10\r\n18/MAYO/2021 MASAJE DRENAJE LINFATICO MARIANA ENTRO 2:10\r\n29/MAYO/2021 FACIAL ESSENTIAL SHOCK 3D DE COLAGENO CON AMP RETINOL DE NATURA BISSE MARY LAZARO 10:05\r\n6/JULIO/2021 MASAJE SENSORELAX ANITA ENTRO 3:05\r\n8/JULIO/2021 MASAJE BOMBON LAVANDA  MARIANA ENTRO 2:15\r\n27/AGOSTO/2021 MASAJE FULL RELAX MONICA ENTRO 18:55 MEGA\r\n27/SEPT/2021 MASAJE DRENAJE LINFATICO LUCY ENTRO 3:10\r\n6/NOVIEMBRE/2021 FACIAL HYDRACURE MIRENA ENTRO 11:05\r\n10/NOVIEMBRE/2021 MASAJE DE TE VERDE JOHANY ENTRO 5:05\r\n23/NOVIEMBRE/2021 MASAJE LASAI JOHANY ENTRO 5:15\r\n30/DIC/2021 TRATAMIENTO FACIAL SRNS MARY LAZARO ENTRO 5:05\r\n04/ENE/2022 MASAJE HOLISTICO MONICA ENTRO 17:00 MEGA\r\n8/ENERO/2022 TRATAMIENTO FACIAL SRNS MARY LAZARO ENTRO 12:15\r\n11/ENERO/2022 MASAJE BOMBON DE FRUTOS ARLETH ENTRO 3:15\r\n14/ENERO/2022 MASAJE COMBO ARLETH ENTRO 3:10\r\n15/ENERO/2021 FACIAL SRNS  MARY LAZARO ENTRO 1:15\r\n3/MARZO/2022  MASAJE BOMBON VAINILLA ARLETH ENTRO 5:10\r\n12/ABRIL/2022 MASAJE DRENAJE LINFATICO SUSI ENTRO 5:40\r\n6/JUNIO/2022 MASAJE BOMBON ROSAS CRISTINA ENTRO 5:10\r\n22/JULIO/2022 TRATAMIENTP YOGA FACIAL JHOANY ENTRO06\r\n06/AGOSTO/2022 MASAJE FULL RELAX  MONICA 4:55 (MEGA)\r\n15/AGOSTO/2022 MASAJE DRENAJE LINFATICO LUCY ENTRO 2:25\r\n10/SEPTIEMBRE/2022 MASAJE FULL RELAX ROSY ENTRO 4:00 MEGA\r\n12/SEPT/2022 MASAJE BONBON ROSAS MARIANA ENTRO 3:10\r\n17/OCTUBRE/2022 MASAJE FULL RELAX LUCY ENTRO 6:10\r\n24/OCTUBRE/2022 FACIAL REVERS MARY LAZARO ENTRO 3:15\r\n5/DICIEMBRE/2022 MASAJE DRENAJE LINFATICO MARIANA ENTRO 5:10 \r\n15/FEBRERO/2023  MASAJE BOMBON ROSAS  LUCY ENTRO 1:15\r\n17/MAYO/2023 MASAJE DE TE VERDE LUCY ENTRO 4:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-17 12:40:45', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('615', 'C-100615', '', 'CESAR MAGAÑA', '9933300889', '', '05/abril/17 mdm full relax candy entro 7:15 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('616', 'C-100616', '', 'DANIEL OCA', '9363840260', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('617', 'C-100617', '', 'LARRY CANTUN VILLARREAL', '8111936484', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('618', 'C-100618', '', 'NORBERTO ALVAREZ QUIROGA', '6421190472', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('619', 'C-100619', '', 'MARTIN GARCIA ROLDAN', '9931010723', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('620', 'C-100620', '', 'ITZEL DE LA ROSA TORRES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('621', 'C-100621', '', 'LANDY TORRES ALCAZAR', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('622', 'C-100622', '', 'ARMANDO DE LA ROSA SANTOS', '9932078248', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('623', 'C-100623', '', 'MARIA ELENA ALIPI PAZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('624', 'C-100624', '', 'VALERIA PRIEGO DE LA FUENTE', '9931016360', '', '22/oct/16 limpieza facial lucy entro 1:05\r\n18/ene/17 limpieza de acne con amp. desicnrustante lucy entro 6:00\r\n15/feb/17 limpieza facial 2x600 lucy entro 1:05\r\n25/abril/17 limpieza de acne con amp. desincrustante lucy entro 4:00\r\n30/mayo/17 limpieza de acne lucy entro 10:50 (DEBE LA LIMPIEZA, VA A PAGAR LA SRA. LORENA) PAGADO.\r\n14/junio/17 limpieza facial con amp. desincrustante carmen entro 12:25\r\n27/junio/17 limpieza de acne con amp. desincrustante lucy entro 5:00\r\n24/nov/17 2da. piernas completas autom. 16 j lucy\r\n7/12/17  DEP BIKINI 30MS 11J LUCY\r\n12/01/18 CARBOXITERAPIA, CÁPSULA LUCY\r\n15/01/18 INICIA TRATAMIENTO CORPORAL\r\n1.-  CARB TERMO 15/01/18 LUCY\r\n2.- V CALIENTES 45 16/01/18 LUCY ENTRO 9:25\r\n3.-CORP  18/01/18 OFE ENTRO 9:20\r\n4.- V CALIENTES 19/01/18 LUCY ENTRO 9::30\r\n5.- V CALIENTES  22/01/18 LUCY ENTRO 9:25\r\n6.- CARB, CÁPSULA 23/ENERO/18 ANITA ENTRO 2:20\r\n7.-V CALIENTES  24/01/18 ANITA ENTRO 9:55\r\n8.-CORP   25/01/18  LUCY \r\n9.-V CALIENTES  26/01/18 ANITA\r\n10.- CARB Y TERM  29/01/18\r\n16/ENERO/18 DEP BIKINI 30MS 11J LUCY\r\n05/FEB/18 LIMPIEZA DE ACNE OFELIA ENTRO 9:25\r\n05/FEB/18 INICIA CORPORAL CON MEDIDAS DE CINTURA 64 CM Y PESO 56 1/2\r\n1.-LASER LIPOLÍTICO Y VF  05/FEB/18 LUCY\r\n2.-CARBOX, VF EN SECO EN PIERNAS Y ABDOMEN 06/FEB/18 REYNA\r\n3.-LASER LIPOLITICO, VF 07/FEB/18 OFE ENTRO 9:30\r\n4.-CARBOX   14/FEB/18   LUCY ENTRO 9:05\r\n5.-CARBOX, TERMO 19/FEB/18 LUCY ENTRO 11:40\r\n6.-CARBOX, CRIOLIPOLISIS  20/FEB/18 LUCY ENTRO 10:00\r\n7.- LASER LIPOLITICO, VF 35    22/FEB/18 OFE\r\n01/MARZO/18 DEP LASER DE PIERNAS COMPLETA 30MS, 10J OFELIA\r\n8.-TERMOSLIN  5/MARZO/18 LUCY ENTRO 10:00\r\n9.- MASAJE 45   14/MARZO/18 LUPITA ENTRO 10:15\r\n10.- MASAJE 45 15/MARZO/18 LUPITA ENTRO 11:05\r\n21/MARZO/18 TERMOSLIN OFELIA ENTRO 9:45\r\n19/ABRIL/18 LIPOSONIX  4 DISPAROS CON EL ELECTRODO 0.8 38J OFELIA\r\n25/ABRIL/18 LIMPIEZA FACIAL ANITA ENTRO 12:00\r\n7/MAYO/18 CABOX LUCY ENTRO 4:15\r\n14/MAYO/18 CABOX, TERMOSLIN LUCY\r\n18/MAYO/18 CARBOX, CÁPSULA LUPITA\r\n20/AGOSTO/18 CARBOX LUCY\r\n24/AGOSTO/18 CORPO LINDA ENTRO 9:25\r\n29/agosto/18 mdm full relax susy entro 6:30 (mega)\r\n19/SEP/18 LIMPIEZA DE ACNE LINDA\r\n11/OCT/18 VACUNTERAPIA LUPITA\r\n23/OCT/18  LIMPIEZA DE ACNE REYNA\r\n26/octubre/18 mdm full relax susy entro 5:00 (mega)\r\n30/OCT/18 MDM FULL RELAX  BELEN\r\n18/DIC/18 CARBO, TERMO, YESO TERMICO\r\n19/DIC/18 CARBO, TERMO\r\n21/ENERO/20 CARBOX Y TERMOSLIN LUCY\r\n23/ENERO/20 LIMPIEZA FACIAL Y CARBOX MARIANA ENTRO 1:00\r\n10/DICIEMBRE/2020 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 LUCY ENTRO 3:00\r\n24/AGOSTO/2021 ARO JHOANY ENTRO 10:00\r\n26/AGOSTO/2021 CAPSULA BEGO ENTRO 10:15\r\n27/AGOSTO/2021 LASER LIPOLITICO MARIANA ENTRO 10:00\r\n30/AGOSTO/2021 TERMOSLIN JHOANY ENTRO 10:25\r\n31/AGOSTO/2021 VENDAS CALIENTES JHOANY ENTRO 10:30\r\n2/SEPT/2021 ARO MIRENA ENTRO 10:30\r\n3/SEPT/2021 CAPSULA DE INFRATERAPIA JOANA/MARY LAZARO ENTRO 10:00 \r\n6/SEPT/2021 VENDAS CALIENTES Y CARBOX  JOHANY \r\n13/SEPT/2021TERMOSLIN\r\n14/SEPT/2021 LIMPIEZA DE ACNE SRA BEGO\r\n4/FEB/2022 MASAJE DESCONTRACTURANTE, LIMPIEZA FACIAL MARIANA ENTRO 11:10\r\n24/FEB/2022 LASER DE CARBONO LUCY ENTRO 1:20\r\n16/MARZO/2022 LIMPIEZA FACIAL LUCY ENTRO 21:40\r\n4/ABRIL/2022 LIMPIEZA FACIAL JOHANY \r\n31/MAYO/2022 HI EMT OFELIA\r\n30/AGOSTO/2022 LIMPIEZA FACIAL CRISTINA ENTRO 5:10\r\n11/ABRIL/2023 LIMPIEZA FACIAL MARIA\r\n13/ABRIL/2023 LIMPÌEZA FACIAL MARIA ENTRO 12:20\r\n18/ABRIL/2023 LIMPIEZA FACIAL KARLA ENTRO 12:45', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-22 13:56:10', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('625', 'C-100625', '', 'VALENTIN BAUTISTA GUILLEN', '1841150637', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('626', 'C-100626', '', 'LUIS FELIPE AGUILAR GARCIA', '9931468466', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('627', 'C-100627', '', 'ADRIAN RAMIREZ CARRILLO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('628', 'C-100628', '', 'MARIA ROSIVEL PEREZ OROPEZA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('629', 'C-100629', '', 'ROCIO ANGELICA LEON SANCHEZ', '9932518536', '', '7/OCT/2015  FULL RELAX  ROSITA (MEGA) 12:05.\r\n17-03-16 se realizo masaje full relax cristal 12pm\r\n28/sep/19 full relax 2x600 janeth entro 11:10 mega\r\n19/OCTUBRE/19 MDM FULL RELAX 2X600 ROSI ENTRO 4:55 MEGA', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('630', 'C-100630', '', 'LUCIA SOLIS CRUZ', '9933010212', '', ' 21/10/03 promocion modeladora marcela\r\n04/11/03 prom. trat. hidratante con lifting de parp. lupita\r\n19/11/03 trat. de colageno marcela\r\n01/12/03 jalea real consuelo\r\n22/12/03 promocion vitamina c mary\r\n20/01/04 jalea real tete\r\n02/02/04 shok de colageno mary\r\n18/02/04 revitase consuelo\r\n03/03/04 shock de colageno consuelo\r\n26/03/04 shock de colageno consuelo\r\n16/04/04 promocion botanico 4 f hermi\r\n07/05/04 jalea real lupita c\r\n21/05/04 hydrasoin bego\r\n10/06/04 revitase lucy\r\n25/06/04 tratamiento botanico mary\r\n09/07/04 revitase mary lazaro\r\n03/08/04 shock de colageno consuelo\r\n18/08/04 promocion regenerador antioxidante ofelia\r\n01/09/04 promocion colageno reyna\r\n20/09/04 promocion colageno yesy\r\n08/10/04 promocion modeladora ofelia\r\n28/10/04 trat. botanico mary lazaro\r\n12/11/04 prom. trat. hydratante con lifting yesy\r\n02/12/04 promocion vitamina c mary\r\n16/12/04 jalea real gladys\r\n29/12/04 revitase lupita\r\n18/01/05 promocion relajante e hidratante reyna\r\n1/02/05 promocion ginseng ofelia\r\n22/02/05 promocion ginseng ofelia\r\n15/03/05 promocion antiarrugas mary\r\n06/04/05 promocion botanico 4 f reyna\r\n18/04/05 revitase ofelia\r\nno quiere que la vuelva atender reyna\r\n13/05/05 revitase ofelia\r\n08/06/05 shock colageno gladys\r\n21/06/05 revitase mary\r\n08/07/05 catiodermia gladys\r\n22/07/05 revitase ofelia\r\n09/08/05 timexpert ofelia\r\n09/09/05 timexpert ofelia\r\n28/09/05 timexpert ofelia\r\n11/oct/05 timexpert ofelia\r\n24/oct/05 timexpert lucy\r\n08/nov/05 timexpert ofelia\r\n24/nov/05 timexpert de ojos ofelia\r\n08/dic/05 timexpert de ojos ofelia\r\n23/dic/05 timexpert de ojos, limpieza capilar ofelia\r\n10/ene/06 timexpert de ojos, limpieza capilar mary\r\n27/ene/06 timexpert de ojos, limpieza capilar ofelia\r\n14/feb/06 revitase, limpieza capilar ofelia\r\n14/feb/06 llevo la crema reafirmante nutritiva de jalea real y\r\n la seda para el cabello\r\n07/marzo/06 citoquinas y limpieza capilar ofelia\r\n23/marzo/06 timexpert ofelia\r\n04/abril/06 revitase ofelia\r\n18/abril/06 hydrasoin ofelia\r\ninicia tratamiento de pidele al tiempo que vuelva son 4 sesiones\r\n viene cada 8 dias $1000.00 cada una.\r\n1.-micro-velos elasticos de colageno 04/mayo/06 ofelia\r\n2.-micro-excel therapy\r\n3.-micro-revitase\r\n4.-micro-timexpert\r\n02/junio/06 revitase ofelia\r\n20/junio/06 trat. criogenico ofelia\r\n05/julio/06 una sesion de new lift ofelia\r\n14/agosto/06 revitase ofelia\r\n20/sept/06 go expression ofelia\r\n02/oct/06 jalea real ofelia entro 9:20\r\n09/nov/06 modeladora con amp. jalea real ofelia\r\n04/ene/07 trat. tisular ofelia entro 11:00\r\n23/feb/07 trat. champagne ofelia entro 9:30\r\n22/marzo/07 trat. pure control ofelia entro 12:30\r\n30/abril/07 vitamina c ofelia\r\n26/mayo/07 trat strategist ofelia entro 11:45\r\n28/julio/07 revitase ofelia \r\n17/agosto/07 strategist ofelia entro 1:30\r\n15/sept/07 trat. gingko biloba ofelia entro 10:30\r\n06/oct/07 trat. seda y perla ofelia entro 12:45\r\n27/oct/07 strategist refine ofelia entro 1:25\r\n26/nov/07 trat. de parafina facial ofelia entro 12:45 salio 2:30\r\n18/dic/07 go-expressions ofelia entro 1:25 salio 3:10\r\n21/ene/08 timexpert lift ofelia entro 10:30 \r\n2/feb/08 timexpert lift ofelia entro 11:15 \r\n16/feb/08 timexpert lift ofelia entro 12:10 \r\n1/marzo/08 timexpert lift ofelia entro 11:30 \r\n17/marzo/08 timexpert lift ofelia entro 11:30 \r\n5/abril/08 strategist refine ofelia entro 11:50 \r\n2/mayo/08 strategist refine ofelia entro 12:00\r\n17/mayo/08 strategist refine ofelia entro 12:40\r\n30/mayo/08 hidratacion intensa ofelia entro 12:15\r\n14/junio/08 trat. pure control ofelia entro 12:30 \r\n23/agosto/08 trat. caviar ofelia entro 12:30 \r\n13/sept/08 revitase ofelia entro 12:30 \r\n27/sept/08 seda y perla ofelia entro 12:45 \r\n11/oct/08 pure control ofelia entro 1:15 \r\n25/oct/08 pure control ofelia \r\n8/nov/08 trat. pieles acneicas de lendan ofelia entro 12:15 \r\n22/nov/08 limpieza de acne con amp. serum equilibrante ofelia entro 12:00 \r\n6/dic/08 limpieza de acne con amp. serum equilibrante ofelia entro 12:20 \r\n20/dic/08 hydrasoin ofelia entro 12:40\r\n5/ene/09 jalea real ofelia \r\n17/ene/09 trat. piel grasa de sothys ofelia entro 12:35 \r\n31/ene/09 hydrasoin ofelia entro 12:30 \r\n14/feb/09 timexpert white ofelia entro 12:30 \r\n28/feb/09 timexpert white, lifting 02 ofelia entro 12:35 \r\n14/marzo/09 timexpert white ofelia entro 12:30 \r\n31/marzo/09 timexpert white, lifting excel therapy 02 ofelia entro 12:40 \r\n18/abril/09 timexpert white, lifting excel therapy o2 ofelia entro 12:35\r\n8/mayo/09 caviare ofelia entro 1:15 \r\n25/mayo/09 infinitime ofelia entro 1:00\r\n6/junio/09 trat de oro ofelia\r\n10/julio/09 trat. facial completo ofelia entro 1:00\r\n27/julio/09 deluxe ofelia entro 1:30\r\n17/agosto/09 strategist ofe entro 11:40\r\n4/sept/09 trat. anti-manchas de tegor ofe entro 9:30\r\n19/sept/09 trat. mavachi ofe entro 12:30 \r\n2/oct/09 trat. facial eye care ofe entro 12:45\r\n17/oct/09 revitase ofe entro 12:40 \r\n4/nov/09 timexpert vitamina c ofe \r\n16/nov/09 hydrasoin ofe entro 1:00\r\n5/enero/09 strategist refine ofe\r\n25/ene/10 strategist refine ofe entro 12:30\r\n13/feb/10 strategist refine ofe entro 9:45 \r\n1/marzo/10 strategist refine ofe entro 1:08\r\n12/marzo/10 strategist ofe entro 10:45 \r\n5/abril/10 facial wellbox ofe\r\n19/abril/10 facial wellbox ofe\r\n1.-4/mayo/10 skinlight mascara ofe entro 1:10\r\n2.-17/mayo/10 skinlight mascara ofe entro 10:45 \r\n3.-1/junio/10 skinlight mascara ofe \r\n19/julio/10 trat. mavachi ofe entro 12:30\r\n17/agosto/10 strategist ofe entro 12:30\r\n1/sept/10 strategist ofe entro 12:30\r\n15/sept/10 trat. pure control ofelia entro 12:15 \r\n18/oct/10 hydrasoin ofe\r\n3/nov/10 infinitime ofe \r\n9/dic/10 strategist ofe entro 9:13  \r\n5/ene/11 straegist ofe entro 12:30 \r\n17/ene/11 strategist refine ofelia\r\n2/feb/11 strategist refine ofelia entro 12:06 \r\n16/feb/11 strategist ofelia entro 12:08 \r\n2/marzo/11 timexpert white ofe\r\n16/marzo/11 facial maskra despigmentante ofelia \r\n2.-ipl 16/marzo/11 ofelia\r\n6/abril/11 hydracure ofelia entro 12:30\r\n27/abril/11 hydracure ofe entro 1:10\r\n11/mayo/11 trat. cosmeceuticals ofe entro 12:45 llevo masc. ak\r\n13/julio/11 trat. oxigenante excel therapy ofelia entro 9:15\r\n30/julio/11 strategist ofelia entro 9:10\r\n19/agosto/11 strategist ofelia entro 11:05\r\n02/sept/11 tratamiento facial piel grasa de lendan ofelia  entro 9:50\r\n15/sep/11 strategy ofelia entro 10:05\r\n06/oct/11 taimex per whiten  ofelia\r\n27/oct/11 dizao con amp. balancing ofelia entro 5:00\r\n15/nov/11 trat. facial combinado tensor de germaine con gelula verde ofelia entro 9:35\r\n5/dic/11 excel therapy o2 ofelia entro 1:25\r\n19/dic/11 modeladora ofe entro 12:25\r\n9/ene/12 trat. facial celulas madres ofelia entro 12:30\r\n30/ene/12 celulas madres de manzana ofelia entro 1:25\r\n15/feb/12 facial control de grasa ofelia entro 9:50\r\n15/marzo/12 strategist ofelia entro 9:55\r\n13/abril/12 timepxert white ofelia entro 1:10 llevo pantalla solar\r\n21/mayo/12 celulas madres de manzana ofelia \r\n9/junio/12 glycocure ofelia entro 12:25\r\n2/julio/12 trat facial para piel gra sa con amp. desincrustante ofe entro 11:30\r\n16/julio/2012 trat facial para piel grasa con amp. desincrustant ofe entro 11:00\r\n21/julio/12 limpieza facial con amp. desincrustante y amp. equilibrante ofelia entro 11:10\r\n1/agosto/12 trat facial para piel grasa ofelia entro 11:00\r\n18/agosto/12 trat piel grasa de atache con amp. desincrustante y equilibrante ofelia entro 11:40\r\n25/agosto/12 limpieza de acne con amp. desincrustante y equilibrante ofelia entro 12:15\r\n8/sept/12 trat piel grasa de atache con amp. desincrustante ofelia entro 12:15\r\n20/sept/12 the cure natura bisse ofelia entro 12:45\r\n12/oct/12 the cure natura bisse ofelia entro 12:45\r\n13/nov/12 strategist, lifting de colageno ofelia\r\n19/julio/2013 skinlaing ofelia entro 11:30\r\n1/dic/12 glycocure ofelia entro 1:00\r\n21/dic/12 strategist ofelia entro 12:40\r\n2/marzo/13 strategist ofelia entro 12:00\r\n19/marzo/13 facial oxigenante nb ofelia entro 12:50\r\n 22/abril/13 facial hydracure ofelia entro 1:00\r\n11/mayo/13 facial strategist ofe entro 1:00\r\n25/mayo/13 facial royal jelly ofelia entro 9:10\r\n7/junio/13 facial velo de colageno ofelia entro 10:20\r\n1/julio/13 facial desafio antiedad de nb ofelia entro 12:30\r\n13/sept/13 facial hydracure ofelia entro 12:30\r\n26/sep/13 facial timexpert white, lifting go-expression ofelia entro 1:20\r\n11/oct/13 facial hydracure ofelia entro 1:00\r\n11/dic/13 facial hydracure, lifting de colageno ofelia entro 9:30 llevo crema de ojos timexpert lift\r\n20/dic/13 facial timexpert lift ofelia entro 10:35\r\n10/ene/14 facial equilibrante piel grasa ofelia entro 12:40\r\n31/ene/14 facial equilibrante piel grasa ofelia entro 12:05\r\n17/feb/14 timexpert lift ofelia entro 12:30\r\n3/marzo/14 timexpert lift ofelia entro 12:00\r\n17/marzo/14 facial stabilizing ofelia entro 12:50\r\n4/abril/14 facial hydracure ofe entro 12:50\r\n25/abril/14 lifting de nb y promocion de porcelana atendio ofelia\r\n12/mayo/14 facial vitamina c ofelia entro 12:35 llevo crema de ojo timexpert lift\r\n4/junio/14 facial stabilizing ofelia entro 12:30\r\n16/junio/14 facial vitamina c natura bisse ofelia entro 1:00\r\n02/julio/14 vitamina c ofelia entro 1:10\r\n25/julio/14 facial stabilizing de natura bisse ofelia entro 12:30\r\n08/agosto /facial time lift atendio ofe entro 12:30\r\n27/agosto/14  limpieza facial con amp de colageno, lifting de natura bisse atendio ofe entro 12:20\r\n12/sept/14 facial stabilizing de nb ofelia entro 12:30\r\n3/oct/14 facial vitamina c de natura bisse ofelia entro 12:20\r\n28/oct/14 timexpert white ofelia entro 4:45\r\n10/feb/15 facial vitamina c nb ofelia entro 12:45\r\n27/febrero/15 facial timexpert white y liftin colageno ofelia entro 10:35\r\n4/mayo/15 facial de hydracure con amp. royal jelly ofelia entro 10:00\r\n01/julio/15 facial vitamina c natura bisse ofelia entro 9:15\r\n11/sept/15 facial stabilizing natura bisse ofelia entro 9.50\r\n12/ene/16 facial equilibrante de grasa ofelia entro 9:45\r\n29/ene/16 facial stabilizing ofelia entro 9:30\r\n23/marzo/16 delienado de cejas ofelia, se le dio $100.00 a ofelia\r\n6/abril/16 facial vitamina c de natura bisse ofelia entro 11:40\r\n6/abril/16 retoque de cejas ofelia, se le dio $100.00 a ofelia\r\n29/abril/16 facial hydracure ofelia entro 1:10\r\n31/mayo/16 facial de hydracure ofelia entro 12:20\r\n6/julio/16 facial de vitamina c de natura bisse ofelia entro 12:50\r\n24/agosto/16 facial desafio antiedad  nb lucy entro 4:00\r\n9/sept/16 facial vitamina c de natura bissé ofelia entro 2:05\r\n23/sept/16 facial desafio antiedad ofelia entro 2:10\r\n8/oct/16 facial ácido pirúvico natura bisse $1800.00 ofelia entro 1:30\r\n6/feb/17 facial desafio antiedad natura bisse ofelia entro 1:25\r\n31/marzo/17 facial vitamina c, lifting de colageno ofelia entro 11:30\r\n21/abril/17 facial timexpert IN con amp. de ácido hialurónico ofe entro 3:30\r\n01/agosto/ tratamiento oxigenante andrea entro 04:30 (mega)\r\n4/sept/17 facial vitamina c natura bisse ofelia entro 12:40\r\n18/oct/17 micro con facial excel therapy o2 ofelia entro 12:25 $1.800.00\r\n9/MARZO/18 FACIAL VITAMINA C DE NATURA BISSÉ Y LIFTING DE COLÁGENO OFELIA\r\n11/ABRIL/18 FACIAL DIAMOND WHITE OFELIA ENTRO  11:15\r\n7/SEPT/18 FACIAL VITAMINA C DE NATURA BISSÉ, LIFTING DE ÁCIDO HIALURÓNICO OFELIA ENTRO 3:35\r\n29/SEP/18 FACIAL TIMEXPERT RIDES, LIFTING DE COLÁGENO OFELIA LLEVO MÁSCARA NOCHE RENOVADORA TIMEXPERT RIDES\r\n19/OCT/18  FACIAL TIMEXPERT SRNS Y LIFTING DE COLÁGENO OFELIA \r\n19/OCT/18 LLEVO CREMA PUREXPERT  HIDRA MATIFICANTE GEL\r\n1/NOV/18 FACIAL DE VENDAJE Y LIFTING NÚM II OFELIA\r\n16/NOV/18 FACIAL CEUTICAL DE NB Y LIFTING DE COLÁGENO OFELIA\r\n30/NOV/18 HYDRAFACIAL CON VITAMINA C DE GERMAINE Y LIFTING DE ÁCIDO HIALURÓNICO OFELIA ENTRO 12:25 Y SALIÓ 2:30\r\n14/DIC/18 LIFTING DE COLÁGENO Y FACIAL EXCEL THERAPY O2 OFELIA ENTRO 12:45\r\n28/DIC/18 FACIAL DE VENDAJE , RADIO, LIFTING DE COLÁGENO Y MANOS OFELIA\r\n11/ENE/19 FACIAL COMPLETO Y AMP CLARIFICANTE OFELIA\r\n25/ENERO/19 HYDRAFACIAL CON VITAMINA C DE GERMAINE OFELIA ENTRO 12:00 SE LE COBRO $2000.00\r\n16/FEB/19 FACIAL CEUTICAL OFELIA ENTRO 1:30\r\n5/MARZO/19 FACIAL DE TIMEXPERT RIDES, LIFTING DE TIMEXPERT RIDES Y AMP DE SO-DELICATE OFELIA\r\n15/MARZO/19 FACIAL HYDRACURE CON AMP DE COLÁGENO Y LIFTING DE TIMEXPERT RIDES OFELIA\r\n14/ABRIL/19 FACIAL REVERSE Y AMP DE COLÁGENO OFELIA\r\n26/ABRIL/19 FACIAL CEUTICAL DE NATURA BISSÉ Y AMP SO-DELICATE OFELIA\r\n16/MAYO/19 TIMEXPERT RIDES CON REVERSE  CON OFELIA ENTRO 1:35\r\n6/JUNIO/19 FACIAL INHIBIT OFELIA\r\n2/JULIO/19 FACIAL DIAMOND INFUSHION Y LITONG DE COLAGENO OFELIA\r\n2/AGOSTO/19 FACIAL DIAMOND LIFT INFUSION OFELIA \r\n15/AGOSTO/19 FACIAL B-CALM DE GERMAINE OFELIA  ENTRO 11:40\r\nLLEVO CREMA X-CEL TIMEXPERT RIDES 1,785\r\n30/AGOSTO/19 FACIAL VITAMINA C DE NATURA BISSE YLIFTONG DE COLAGENO OFELIA ENTRO 1:30\r\n3/DIC/19 FACIAL CEUTICAL OFELIA ENTRO 11:20\r\nLLEVO XCEL THERAPY  PACK\r\n8/AGOSTO/2020 FACIAL TIMEXPERT IN (SO-DELICATE) PROMOCION 10 DE MAYO OFELIA ENTRO 12:25\r\n21/AGOSTO/2020 CREMA SO-DELICATE PIEL SECA\r\n23/OCTUBRE/2020 LLEVO CREMA SRNS TIMEXPERT NIGHT PACK\r\n8/DIC/2020 FACIAL TIMEXPERT IN CON LIFTING OFELIA ENTRO 10:00 (PROM. 10 DE MAYO) \r\n27/FEB/2021 LLEVO CREMA SRNS NIGTH\r\n6/MARZO/2021 FACIAL NUTRITIVO CON AMP. NUTRITIVA, MASCARILLA DE PERLA Y MASCARA BIO-REGENERADOR OFELIA ENTRO 11:15 $2,000.00\r\nLLEVO CREMA GLOBAL TIMEXPERT RIDES\r\n9/ABRIL/2021 DELINEADO DE CEJAS SE LE DIO 300.00 PESOS OFELIA\r\n23/ABRIL/2021 RETOQUE DE CEJAS OFELIA ENTRO 12:00\r\n8/MAYO/2021 FACIAL VITAMINA C DE GERMAINE CON AMPOLLETA DE COLÁGENO OFELIA ENTRO 12:05 LLEVO CREMA CONFORT ALTA RECUPERACIÓN TIMEXPERT SRNS\r\n11/AGOSTO/2021 TRATAMIENTO FACIAL TIMEXPERT SRNS OFELIA ENTRO 12:15\r\n9/SEPT/2021 LLEVO PACK DE SRNS\r\n4/ENERO/2022 TRATAMIENTO FACIAL EXCEL THERAPY O2 OFELIA ENTRO 11:25\r\n5/FEB/2022 TRATAMIENTO FACIAL VITAMINA C DE NATURA BISSE OFELIA ENTRO 11:40\r\n6/ABRIL/2022 LLEVO CREMA SUPREMA DEFINICION TIMEXPERT LIFT\r\n17/MAYO/2022 TRATAMIENTO FACIAL SINERGY CON RADIO OFELIA ENTRO 12:50\r\n****LEVO CREMA SUPREMA DEFINICION TIMEXPERT LIFT IN\r\n27/JUNIO/2022 TRATAMIENTO FACIAL NEW AGE CON MASCARA DE ELECTROESTIMULACION OFELIA ENTRO 11:40\r\n*********21/JULIO/2022  LLEVO CREMA TIMEXPERT SRNS NIGH********\r\n9/AGOSTO/2022 FACIAL VITAMINA C DE NATURA BISSE OFELIA ENTRO 9:15\r\n*******LLEVO CONCENTRADO NOCTURNOI DETOX TIMEXPERT SRNS********\r\n10/OCTUBRE/2022 FACIAL FORMEN OFELIA ENTRO 2:25\r\n14/DICIEMBRE/2022 FACIAL HYDRACURE OFELIA ENTRO 2:10\r\n29/DICIEMBRE/202 DELINEADO DE CEJAS Y HYDROADERMABRASION CON AMP. STABALANZING OFELIA\r\n13/ENERO/2023 RETOQUE DE CEJAS OFELIA ENTRO 1:25\r\n14/ENERO/2023 LLEVO CREMA CONTORNO DE OJOS TIMEXPERT IN\r\n3/FEBRERO/2023 FACIAL MESOBOOTS CON AMPOLLETA OFELIA ENTRO 1:15\r\n22/FEBRERO/2023 FACIAL FORMEN OFELIA ENTRO 12:30\r\n11/MARZO/2023 LLEVO CREMA VITAMINA C TIMEXPERT RADIANCE\r\n15/MARZO/2023 FACIAL VITAMINA C  RADIANCE OFELIA\r\n1/ABRIL/2023 COOLIFTING OFELIA ENTRO 11:00\r\n22/ABRIL/2023 COOLIFTING OFELIA ENTRO 12:15\r\n4/JULIO/2023 FACIAL VITAMINA C DE NATURA BISSE OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-04 17:23:44', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('631', 'C-100631', '', 'ANDRES DAGDUG CABAL', '9333033848', '', '16/feb/11 promocion trat. de seda mariana entro 11:05 \r\n7/ene/12 promocion revitalizante rosy entro 11:45\r\n19/oct/12 promocion reafirmante de cuello con amp. desincrustante sara \r\n29nov12promocion de colageno y masaje de drenaje linfatico atendio graciela matriz 1210\r\nsalio 230\r\n8/feb/13 promocion catiodermia graciela entro 10:00\r\n6/junio/13 promocion coco y mango yusiria entro 10:15\r\n12/julio/13 promocion colageno y elastine mariana entro 11:00\r\n8/oct/13 promocion the verde graciela entro 1:25\r\n6/dic/13 promocion de oro reyna entro 1:30\r\n3/marzo/14 promocion humectante mirena entro 12:00\r\n19/junio/14 promocion antioxidante ana entro 12:00\r\n18/agosto/14 limpieza facial cliente frecuente mirena entro 11:00\r\n25/nov/14 promocion trat antiedad humectante-nutritivo  y mdm full relax brenda entro 2:00\r\n22/dic/14 mdm full relax y promocion trat. global antiedad  yusiria entro 10:15\r\n2/marzo/15 mdm full relax reyna, promocion antiedad mariana entro 11:55\r\n30/julio/15 promocion trat de cuello reyna entro 11.30\r\n26/agosto/15 mdm full relax y promocion chocoterapia mary lazaro entro 11:30\r\n30/sept/15 mdm full relax y promocion equilibrante del ph graciela entro 11:10\r\n29/unio/16 masaje fullr elax y promocion de elastine lizvet entro 12:45\r\n14/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX Y MDM FULL RELAX REYNA Y MONICA\r\n2/OCT/19 MASAJE FULL RELAX OFELIA , PROMOCION DOBLE ACCION LUPITA ENTRO 11:45\r\n4/MARZO/2020 MASAJE FULL RELAX, PROMOCION TRAT REGENERADOR ANITA ENTRO 10:10\r\n8/FEB/2021 MASAJE FULL RELAX Y TRATAMIENTO FACIAL PEEL OFF LUCY ENTRO 12:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('632', 'C-100632', '', 'ADELA VIDAL HERRERA', '9933300536', '', '5/mayo/16 mdm full relax carmen entro 1:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('633', 'C-100633', '', 'MIRNA GOMEZ GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('634', 'C-100634', '', 'CARMEN JACOBO REYES', '9931603448', '', '31/julio/06 promocion oxigenoterapia rosy\r\n31/oct/06 promocion renove carmen entro 1:40\r\n12/marzo/07 promocion antiarrugas mary entro 2:00 salio 3:22\r\n28/mayo/07 limpieza facial ofelia\r\n09/julio/07 promocion colageno lucy entro 10:35\r\n04/oct/07 promocion modeladora ofelia entro 9:00\r\n12/feb/08 promocion dermorelax con amp. desincrustante bety entro 4:20\r\n29/sept/08 limpieza facial 2 x 1 reyna entro 1:00 \r\n6/agosto/09 promocion revitalizante karina entro 2:35 \r\n18/marzo/10 promocion de cristal sara entro 11:00\r\n16/feb/11 promocion trat. de seda reyna entro 1:15 \r\n10/nov/11 limpieza del 2x1 mariana entro 11:35\r\n21/feb/12 limpieza facial sara entro 3:55\r\n3/dic/12 promocion de oro gladys entro 11:20\r\n9/abril/13 trat. # 0 dieta 13 dias no se peso\r\n27/mayo/13 promocion relajante e hidratante reyna entro 1:20\r\n24/julio/13 promocion colageno y elastine ana entro 1:10\r\n27/sept/13 promocion lifting antiarrugas lucy entro 11:50\r\n29/oct/13 promocion the verde reyna entro 12:40\r\n3/marzo/14 limpieza facial, mdm full relax nelli entro 12:15\r\n21/10/14 serealizo promocion dwel mes atedio lucero cristal entro alas 1.30\r\n14/abril/15 limpieza facial maribel entro 1.25\r\n30/junio/15 promocion trat antioxidante reyna entro 1:25\r\n22/oct/15 limpieza facial con amp. desincrustante graciela entro 3:50\r\n27/01/16 LIMPIEZA FACIAL ATENDIO MARTHA ENTRO 1.30(CRISTAL)\r\n23/junio/16 limpi facial lizvet entro 3:40\r\n12/agosto/16 promocion de caviar susy entro 2:10\r\n5/julio/17 limpieza facial ofelia entro 1:15\r\n5/ENERO/17 LIMPIEZA CAPILAR MARY LAZARO ENTRO 11:15 LLEVO CREMA LIP RECOVERY BALM CEUTICAL DE NB\r\n8/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO LUCY ENTRO 11:00\r\n27/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE LUCY ENTRO 1:00\r\n8/OCT/18 PROM TRATAMIENTO FACIAL DE RETINOL LINDA \r\n15/FEB/19 PROMOCION REAFIRMANTE MARY LAZARO ENTRO 12:45\r\n18/SEP/19 TRATAMIENTO FACIAL OXIGENANTE ANITA ENTRO 4:35\r\n20/FEBRERO/20 TRATAMIENTO FACIAL 4 F ANITA ENTRO 12:50\r\n22/MARZO/2021 PROM. TRATAMIENTO FACIAL ACIDO HIALURONICO CON AMP DESINCRUSTANTEMARIANA ENTRO 11:55\r\n21/JULIO/2021 LIMPIEZA FACIAL 2X600 OFELIA ENTRO 3:55\r\n22/SEPT/2021 PROM. TRATAMIENTO FACIAL ISOFLAVONAS DE SOYA CON AMP. DESINCRUSTANTE JHOANY ENTRO  10:55\r\n10/FEB/2022 PROMOCION TRAT AGE DEFENSE ARLETH ENTRO 12\r\n16/FEBRERO/2023 PROMOCION TRAT. FACIAL ELIXIR DE JUVENTUD ARIANA ENTRO 11:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-02-15 18:48:19', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('635', 'C-100635', '', 'LORENA GOMEZ ESTRADA', '9931603686', 'cristinalorena12@hotmail.com', '29/diciembre/15 prom. del mes tratamiento reafirmante rosy entro 4:00 (mega)\r\n30/diciembre/15 mdm full relax 2x1 charito entro 2:15 (mega)\r\n2/feb/16 promocion Roll & lift massage maria entro 11:45\r\n4/abril/16 promocion trat luxury lizvet entro 11:00 (no quedo agusto con el servicio se le va a reponer la limpieza)\r\n26/mayo/16 promocion de colageno mary lazaro entro 11.25 ( se le cobro la diferencia del tratamiento se le repuso el facial) \r\n4/agosto/16 promocion de caviar lucy entro 10:05\r\nLLEVO SPOT DIMINISH TIMEXPERT WHITE, TÓNICO FORTALECEDOR DE CEUTICAL NB, TRATAMIENTO CONTORNO DE OJOS DE TIMEXPERT LIFT EYES, CREMA TENSORA-REAFIRMANTE CUELLO Y ESCOTE DE TIMEXPERT LIFT IN.\r\n8/sept/16 promocion colageno mary lazaro entro 10:10\r\n8/dic/16 limpieza de acne, mdm descontracturante mary lazaro entro 10:15\r\n8/dic/16 dejo pagada la promocion del mes\r\n15/di/16 promocion trat multivitaminico mary lazaro entro 11:05 (era la promo que tenia pagada)\r\n11/ene/17 velo hidratante antiedad essential shock, reafirmante contorno de ojos y labios de essential shock y filtro solar de diamond.\r\n12/ene/17 facial so delicate lucy entro 11.25\r\n8/marzo/17 limpieza de acne con amp. desincrustante ofelia entor 12:40 \r\nllevo gel biocontrol\r\n10/marzo/17 limpieza de acne ofelia entro 10.50\r\n11/mayo/17 promocion antiedad con lifting mary llevo crema reafirmante de cuello y escote TIMEXPERT IN\r\n29/junio/17 promocion antioxidante mary lazaro entro 2:00\r\nLLEVO FILTRO SOLAR DIAMOND DE NATURA BISSÉ \r\n17/agosto/17 promocion desvanece las lineas del tiempo monica entro 4:30\r\n19/agosto/17 limpieza de acne con amp. desincrustante lizvet entro 10:05\r\n23/agosto/17 limpieza de acne con amp, desincrustante mary lazaro entro 10:00\r\n23/agosto/17 masaje fullr elax (cliente frecuente) mariana\r\nLLEVO GEL-CREMA PUREXPERT DE GERMAINE\r\n25/sept/17 promocion resveratrol con amp. desincrustante, lifting de colageno lucy entro 11:00\r\n30/ENERO/18 LIMPIEZA FACIAL MARIANA ENTRO 10:10 LLEVO LIMPIADORA FACIAL ACIDA LLEVO PARA SU ESPOSO EXCEL THERAPY CONTORNO DE OJOS EXCEL THERAPY\r\n30/01/18 LIMPIEZA FACIAL MARIANA ENTRO 10:10\r\n6/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA MARY ENTRO 2:00\r\n24/MAYO/18 PROMOCION ANTIEDAD HUMECTANTE LUCY ENTRO 10:05\r\n24/MAYO/18 LLEVO CREMA OJOS TIMEXPERT \r\n26/JULIO/18  PROM TRATAMIENTO FACIAL DE RETINOL Y SE LE APLICÓ LIFTING DE PROM JUEVES  MONICA\r\n11/OCT/18 LIMPIEZA FACIAL OFELIA\r\n11/OCT/8 LLEVO SERUM DIAMOND WHITE \r\n3/ENE/19 LIMPIEZA FACIAL MARY ENTRO 2:00\r\n16/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX MARY ENTRO 10:00\r\n24/OCT/19 PROMOCION DOBLE ACCION CON AMP. CLARIFICANTE DE GERMAINE ANITA ENTRO 12:20 LLEVO FILTRO SOLAR DIAMOND WHITE\r\n25/SEPTIEMBRE/2020 LLEVO TIMEXPERT LIF IN CONTORNO OJOS, EXCEL THERAPY O2 EMULSION OXIGENANTE Y TIMEXPERT C+ EMULSION AGE.\r\nLLEVO LA MAMA DE LA SRA LORENA TIMEXPERT SRNS EYES FORMULA DETOX BOLSAS Y OJERAS, TIMEXPERT X-CEL CREMA Y TIMEXPERT X-CEL SERUM RETINAGE\r\n23/DIC/2020 PROMOCION TRAT DE PORCELANA CON AMP. OXIGENANTE DE NATURA BISSE ANITA ENTRO 12:10 LLEVO LIMPIADORA FACIAL ACIDA\r\n26/MAYO/2021 PROM. TRATAMIENTO FACIAL CELULAS MADRE MARY LAZARO ENTRO 2:00  ****LLEVO  CREMA DEFENSA SKIN DEFENCE, CREMA RICA DEFENSA DE AINHOA  Y SERUM ACIDO HIALURONICO\r\n16/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD JHOANY ENTRO 11:00\r\nLLEVO CONTORNO DE OJOS RADIANCE Y CONCENTRADO PURE VITAMINA C RADIANCE\r\n23/OCTUBRE/2021 RADIOFRECUENCIA FACIAL CON LIFTING DE TIMEXPERT RIDES LUCY ENTRO 10:00\r\n28/DIC/2021 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 10:10\r\n6/ENERO/2022 RADIOFRECUENCIA FACIAL MARIANA ENTRO 10:00\r\nLLEVO EMULSION TIMEXPERT RADIANCE Y CREMA TIMEXPERT RADIANCE \r\n2/ABRIL/2022 LIMPIEZA FACIAL CON AMP. DESINCRUDTANTE MARY LAZARO ENTRO 9:10\r\n6/ABRIL/2022 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 10:05\r\n10/OCTUBRE/2022 LLEVO CREMA GLOBAL ARRUGAS SOFT TIMEXPERT RIDES, TRAT. CONTORNO DE OJOS DIA/NOCHE TIMEXPERT RIDES\r\n14/OCTUBRE/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA MARY LAZARO ENTRO 10:15', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-11 09:01:59', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('636', 'C-100636', '', 'YADIRA MAGAÑA CERINO', '9932061572', '', '29/mayo/14 desafio antiedad bego entro 10:40\r\n20/junio/14 llevo crema facial diamond\r\n6/sep/14 promocion azteca,full relax y liftin de parpados entro yusi 1:05\r\n02/octubre/14 promo. tratamiento ----facial smoothie lucero entro 7:05 (mega)\r\n4/dic/14 promocion trat global antiedad johany entro 6:10\r\n21/mayo/15 promocion de catiodermia mariana entro 4.25\r\n21/mayo/15 llevo essential shock reafirmante intensivo piel seca y timexpert rides eyes tratamiento\r\ncontorno de ojos dia y noche}\r\n10/julio/15 promocion trat de cuello mariana entro 8:10\r\n24/sept/15 promocion equilibrante del ph reyna entro 2:25\r\n21/ene/16 promocion desintoxicante charito entro 12:15 llevo contorno de ojos de timexpert lift y emulsion de timexpert lift.\r\n25/septiembre/16 mdm full relax 2x500 lizbeth entro 5:15 (mega)\r\n09/octubre/16 mdm full relax 2x500 charito entro 7:10 (mega)\r\n20/oct/16 promocion de colageno y dep de cejas mary lazaro entro 2:45\r\n29/dic/16 masaje drenaje linfatico carmen entro 4:50\r\n09/julio/17 prom. del mes trat. relajante y rizado de pestañas lizbeth entro 11:20 (mega)\r\nNO LE AGARRO EL RIZADO DE PESTAÑA EN LA MEGA\r\n14/julio/17 masaje full relax (solo pago $200.00 pesos porque se le repuso lo del rizado de pestaña que no le agarro) monica entro 5:10\r\n23/nov/17 promocion termico humectante anita entro 5:50\r\n7/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE  LUPITA Y MDM FULL RELAX 2 X 600 OFELIA ENTRO 4:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('637', 'C-100637', '', 'PATRICIA FELIX CORNELIO', '9361061303', '', '10/marzo/16 limpieza facial lizvet entro 4:15\r\n26/JUNIO/19 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ALE ENTRO 5:00\r\n9/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA LUPITA ENTRO 5:20\r\n27/AGOSTO/2020 LIMPIEZA FACIAL 2X600 MONICA ENTRO 2:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('638', 'C-100638', '', 'YADIRA CID CHUC', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('639', 'C-100639', '', 'MARIANA ALMEIDA DZIB', '9931899797', '', '4/10/12 lim.  d acne atendio jenifer entro 3:20 mega\r\n16/01/13 mdm drenaje atendio jeny entro 12:00 mega\r\nincia depilacion laser de axila $360.00 cada sesion\r\n5/agosto/15 1era. axila 30ms 18j sra bego\r\n05/agosto/15 limpieza facial lucy entro 5:15\r\n5/sept/15 axila 30ms 18j lucy\r\n3/oct/15 3era. axila 30ms 19j reyna\r\n14/nov/15 4ta. axila 30ms 20j sra. bego\r\n15/dic/15 axila 30ms 20j lucy\r\n30/enero/16 limpieza facial andrea entro 3:15 (mega)\r\n1/feb/16 6ta axila aut-20j ofelia\r\n6/agosto/16 limpieza facial con amp. desicnrustante maria entor 1:00\r\n08/sept/17 mdm full relax 2x600 carmen entro 3:20 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('640', 'C-100640', '', 'LAURA GARCIA PEREZ DE CANTON', '9933099090', '', '9/dic/15 promoción reafirmante modeladora y lifting 2 reyna entro 10:10\r\n10/feb/16 masaje reductivo maria entro 11:00\r\n10/feb/16 mdm drenaje linfatico charito entro 12:30\r\n25/abril/16 promocion trat luxury y lifting #2 mary lazaro entro 12:10\r\n26/oct/16 promocdion de colágeno y lifting #2 mariana entro 12:05\r\n4/nov/16 promocion oxigenante, lifting de colageno mary lazaro entro 9:10\r\n16/ene/17 limpieza facial con amp. desicnrustante y lifting#2 lucy entro 11:55\r\n17/ene/17 limpieza de espalda lucy entro 11:40\r\n23/ene/17 limpieza facial con amp. desincrustante y lifting de ácido hialurónico ofelia entro 11:35\r\n7/abril/17 limpieza facial con amp. equilibrante ofelia entro 11:10\r\n29/abril/17 promocion termico, lifting de colageno rosy entro 12:20\r\n9/oct/17 mdm drenaje linfatico anita entro 12:15\r\n12/01/18 MDM DRENAJE LINFATICO REYNA ENTRO 11:10\r\n22/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE OFELIA ENTRO 12:00\r\n25/FEB/19 MDM DRENAJE LINFATICO OFELIA ENTRO 10:15\r\n27/MARZO/19 MASAJE DE DRENAJE LINFATICO OFELIA ENTRO 11:00\r\n3/MAYO/19 MDM DRENAJE LINFATICO OFELIA ENTRO 12:00\r\n7/NOVIEMBRE/19 MDM DRENAJE LINFATICO OFELIA\r\n12/NOV/19 MASAJE DRENAJE LINFATICO OFELIA ENTRO 11:00\r\n13/ENERO/20  MDM DRENAJE LINFATICO OFELIA ENTRO 10:10\r\n15/ENERO/20 LIMPIEZA FACIAL CON AMP. VITAMINA C DE NB Y MASC. DE CEUTICAL. MASAJE LINFATICO CON CREMA DE OXIGENO $2000.00 OFELIA\r\n5/FEB/2020 MASAJE DE DRENAJE LINFATICO OFELIA ENTRO 1:00\r\n6/FEB/2020 FACIAL DIAMOND WHITE, LIFTING TIMEXPERT RIDES OFELIA ENTRO 1:10\r\n11/FEBRERO20 FACIAL DIAMOND MULTISENSORIAL OFELIA ENTRO 12:55\r\n17/FEBRERO/20 DRENAJE LINFATICO OFELIA ENTRO 12:15\r\n20/FEBRERO/20 FACIAL ESSENTIAL SCHOK  2,000.00 Y TRATAMIENTO DE CUELLO 1,800.00 OFELIA ENTRO 12:05 LLEVO CREMA DE MANOS DIAMOND NATURA BISSE\r\n26/FEBRERO/20 MASAJE CON TRATAMIENTO HIDRATANTE DESC 650.00 OFELIA\r\n4/MARZO/20 MDM DRENAJE LINFATICO OFELIA ENTRO 12:10\r\n13/ENERO/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE Y AMP. BEAUTE I, LIFTING TIMEXPERT RIDES JHOANY ENTRO 12:15\r\n21/ABRIL/20221 HYDRAFACIAL  1200.00 OFELIA \r\n10/JUNIO/2021 MASAJE  DRENAJE LINFATICO MARY LAZARO ENTRO 12:10\r\n11/JUNIO/2021 FACIAL EXCEL THERAPY, LIFTING # 2 ANITA ENTRO 11:55\r\n6/OCT/2021 MASAJE DRENAJE LINFATICO JHOANA ENTRO 1:10 \r\n23/JUNIO/2022 TRATAMIENTO FACIAL HYDRACURE OFELIA ENTRO 12:20\r\n***************************************************************************************\r\n***********************SIEMPRE SE HACE MASAJE LASAI********************************\r\n***************************************************************************************\r\n1/JULIO/2022 MASAJE LASAI LUCY ENTRO 11:09 LLEVO FORMULA DETOX ILUMINADORA- BOLSAS Y OJERAS \r\n7/JULIO/2022 MASAJE LASAI MARIANA ENTRO 12:00\r\n12/JULIO/2022 MASAJE LASAI MARIANA  ENTRO 5:00\r\n17/AGOSTO/2022 MASAJE LASAI JHOANY ENTRO 4:15\r\n22/AGOSTO/2022 MASAJE LASAI JHOANY ENTRO 1:10\r\n15/FEBRERO/2023 MASAJE LASAI MARIANA ENTRO 1:15\r\n27/MARZO/2023 MASAJE LASAI JHOANY ENTRO 1:10\r\n11/MAYO/2023 MASAJE LASAI LUCY ENTRO 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-15 20:39:43', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('641', 'C-100641', '', 'LUIS GERARDO CAMPOS ORTIZ', '9931098757', '', '15/NOVIEMBRE/2021 MASAJE FULL RELA X Y LIMPIEZA FACIAL 2X600 MIRENA ENTRO 12:45\r\n14/DICIEMBRE/2021 LIMPIEZA FACIAL 2X600 MARY LAZARO ENTRO 5:44\r\n29/ENERO/2022 LIMPIEZA FACIAL 2X600 JOHANY ENTRO 2:50\r\n7/JUNIO/2022 LIMPIEZA FACIAL 2X600 CRISTINA ENTRO 6:00\r\n26/JULIO/2022 MASAJE FULL RELAX 2X600 ARIANA ENTRO 5:25', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-26 09:24:59', '1', '25', null, null);
INSERT INTO `clientes` VALUES ('642', 'C-100642', '', 'ISAC BARRETA RAMOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('643', 'C-100643', '', 'FLOR DE LIZ CERINO LOPEZ', '9931670348', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('644', 'C-100644', '', 'ENRIQUE REYES ALVAREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('645', 'C-100645', '', 'KARIN GARCIA SANCHEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('646', 'C-100646', '', 'CINTHIA GUADALUPE FIGUEROA MENDEZ', '9931087677', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('647', 'C-100647', '', 'RUBI ARMENGOL ESCALANTE', '9932796536', '', '10/junio/16 depilacion de cejas mirena entro 3:15\r\n6/sept/16 depilacion de cejas ofelia entro 2:25\r\n6/sept/16 masaje de espalda ofelia\r\n28/oct/16 depilacion de cejas anita entro 6:00\r\n12/dic/17 limpieza facial 2x600 mariana entro 12:45\r\n24/ENERO/19 MASAJE DE ESPALDA LUCY ENTRO 2:10\r\n3/DICIEMBRE/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY ENTRO 11:05\r\n28/DIC/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 9:20\r\n18/ABRIL/2022 PROMOCION TRAT CINETICO JHOANY ENTRO 11:15\r\n17/FEBRERO/2023 FACIAL VITAMINA C DE CASMARA MARIANA ENTRO 11:20', 'no', 'activo', '2021-12-07 00:49:45', '2023-02-16 16:45:56', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('648', 'C-100648', '', 'MARIA JOSE VILLAMAYOR PERALTA', '9932426516', '', '15/julio/16 promocion de colageno \r\n13/oct/17 promocion reafirmante mary lazaro entro 10:10\r\n24/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE REYNA ENTRO 9:30\r\n22/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE MONICA ENTRO 12:00\r\n22/FEBRERO/19 LASER LIPOLITICO Y PROM TRATAMIENTO FACIAL REAFIRMANTE CON AMP DESINCRUSTANTE MONICA ENTRO  10:55\r\n25/FEB/19 LASER LIPOLITICO Y CARBOX 500.00 MARY LAZARO ENTRO 5:15\r\n28/FEB/19 LASER LIPOLITICO Y CARBOX  OFELIA ENTRO 12:00\r\n4/MARZO/19 LASER LIPOLITICO Y CARBOX OFELIA  ENTRO 11:40\r\n4/MARZO/19 INICIA TRATAMIENTO DE CELULITIS COSTO 8,000 ABONO 2,000 DEBE 6,000 11/FEB/19 ABONO 2, 000 DEBE 4,000\r\n19/MARZO/19 ABONO 2,000 DEBE 2,000\r\n25/MARZO/19 TERMINO DE PAGAR SU TRATAMIENTO \r\n1.-  DERMOSONIC 4/MARZO/19 LUPITA\r\n2.-VACUNTARAPIA,CARBOX 5/MARZO/19 LUPITA\r\n3.- LUMICELL 6/MARZO/19 LUPITA ENTRO 12:45\r\n4.-CARBOX, DERMOSONIC  7/MARZO/19 LUPITA ENTRO 1:20 \r\n5.- LUMICELL 8/MARZO/19 LASER LIPOLITICO OFELIA ENTRO 1:20\r\n6.- CARBOX, DERMOSONIC 11/MARZO/19 Y LASER LIPOLITICO CON CARBOX (OFELIA) LUPITA \r\n7.- LUMICELL  12/MARZO/19 LUPITA ENTRO 12:40\r\n8.- CARBOX, DERMO  13/MARZO/19 LUPITA ENTRO 5:00\r\n9.- LUMICELL  14/MARZO/19 LUPITA\r\n14/MARZO/19 LASER  LIPOLÍTICO CON CARBOX OFELIA\r\n10.- CARBOX, DERMO  15/MARZO/19 LUPITA ENTRO 3:00\r\n11.- LUMICELL  19/MARZO/19 LUPITA\r\n19/MARZO/19 LASER LIPOLITICO OFELIA\r\n12.- CARBOX, DERMO  20/MARZO/19 LUPITA ENTRO 4:55\r\n13.- LUMICELL  21/MARZO/19 LUPITA ENTRO 12:45\r\n21/MARZO/19 LASER LIPOLITICO OFELIA\r\n14.- CARBOX, DERMO  22/MARZO/19 LUPITA ENTRO 10:00\r\n15.- LUMICELL  23/MARZO/19 LUPITA ENTRO 8:10\r\n16.- CARBOX, DERMO  25/MARZO/19 LUPITA ENTRO \r\n25/MARZO/19 LASER LIPOLITICO  OFELIA ENTRO 12:45\r\n17.- LUMICELL  26/MARZO/19 LUPITA ENTRO 12:35\r\n18.- CARBOX, DERMO 27/MARZO/19 LUPITA ENTRO 11:50\r\n27/MARZO/19 MASAJE CLIENTE FRECUENTE LUPITA ENTRO 11:50\r\n19.- LUMICELL 28/MARZO/19 OFELIA ENTRO 12:45\r\n28/MARZO/19 LASER LIPOLITICO OFELIA\r\n20.- CARBOX, DERMO  29/MARZO/19 LUPITA ENTRO 12:50\r\n9/MAYO/19 LASER LIPOLITICO, PROM TRATAMIENTO FACIAL EFECTO BOTOX CON AMP DESINCRUSTANTE CARMEN  OFELIA ENTRO 8:50\r\n4/JULIO/19 LASER LIPOLITICO CON CARBOX OFELIA ENTRO 12:10\r\n11/DICIEMBRE/19 TRATAMIENTO FACIAL 24K  SANDY ENTRO 4:55\r\n9/ENERO/2020 TRATAMIENTO DESINTOXICANTE C/AMP DESINCRUSTANTE MONI ENTRO 1:05 MEGA\r\n13/FEBRERO/2020 TRATAMIENTO 4F C/AMP DESINCRUSTANTE SUSY ENTRO 1:10 MEGA\r\n24/JUNIO/2020 PROMOCION TRAT REPARADOR ANTIEDAD ANITA ENTRO 10:45\r\n28/JULIO/2020 MASAJE DRENAJE LINFATICO MONICA ENTRO 10:50\r\n15/OCT/2020 PROMOCION TRAT GOLD REGENERANTE ROSY ENTRO 10:40\r\n10/DIC/2020 PROMOCION TRAT. DE PORCELANA CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 9:50\r\n25/FEB/2022 PROMOCION TRAT AGE DEFENSE NUTRITIVO CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 12:00\r\n26/AGOSTO/2022 MASAJE DRENAJE LINFATICO MONICA ENTRO 9:55 (MEGA) \r\n18/OCTUBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ARIANA ENTRO 4:00\r\n30/NOVIEMBRE/2022 PROMO TRATAMIENTO FACIAL REPARADOR CELULAR CON AMP. DESINCRUSTANTE JHOSNY ENTRO 8:50\r\n07/ MARZO/2023 LIMPIEZA FACIAL MONICA ENTRO 4:50 (MEGA)\r\n\r\n12/ABRIL/2023 PROMO TRATAMIENTO FACIAL PLASMA MARINO CON AMP. DESINCRUSTANTE MARIA FERNANDA ENTRO 8:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-04-12 10:48:06', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('649', 'C-100649', '', 'SAMANTA VILLAGOMEZ  MARTINEZ', '9931835529', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('650', 'C-100650', '', 'VERONICA MORALES CRUZ', '9321092080', '', '7/dic/15 limpieza de acne con gelula verde reyna entro 5:10\r\n25/ene/16 limpieza de acne fernanda entro 4:25\r\n30/junio/16 limpieza de acne mariana entro 6:05\r\n4/julio/6 limpieza de acne cona mp. desicnrustante mirena entor 3:15\r\n27/sept/16 limpieza de acne candy entro 4:00\r\n13/oct/16 limpieza del acne 2z500 mariana entro 5:10\r\n11/nov/16 limpieza de acne 2x500 charito entro 2:00\r\n21/feb/17 limpieza de acne carmen entro 4:25\r\n17/abril/17 limpieza de acne andrea entro 5:10\r\n18/julio/17 limpieza facial con amp. desincrustante anita entor 4:10\r\n4/agosto/17 limpieza de acne 2x600 anita entor 5:10\r\n22/sept/17 limpieza facial 2x600 monica entro 1:30\r\n30/noviembre/17 prom. del mes trat. térmico- humectante andrea entro 2:20 (mega) no quiso masaje linfatico ni masaje en brazos solo quiere cara se le reporto a doña rosy .\r\n5/SEPT/18 12 DISPAROS DE LIPOSONIC ELECTRODO 1.8 50 J (ABDOMEN, ESPALDA, BAJA, DE LADO)  LUCY LLEVÓ GEL HIPOTERMICO, CREMA CHAUFFANTE\r\n5/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE CARMEN ENTRO 5:00\r\n10/ENE/19 LIMPIEZA DE ACNE MARY ENTRO 9:14\r\n7/MAYO/19 LIMPIEZA FACIAL 2 X 600 ANITA ENTRO 1:10\r\n27/NOVIEMBRE/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE OFELIA ENTRO 2:25\r\n25/AGOSTO/2021 PROM. TRATAMIENTO FACIAL ORGANICO REVITALIZANTE JOHANY ENTRO 4:20\r\n2/SEPT/2021 LIMPIEZA DE ACNE 2X600 ARLETH ENTRO 3:25\r\n1/MARZO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE Y DERMAPEN OFELIA ENTRO 2:35\r\n29/MARZO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE, LASER DE CARBONO ACTIVO JHOANY ENTRO 1:55 LLEVO AMP. DE COLAGENO DE GERMAINE\r\n***********PROXIMO TRATAMIENTO QUE SE LE RECOMENDO IPL************\r\n19/ABRIL/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MIRENA\r\n19/ABRIL/2022 INICIA TRATAMIENTO DE LUZ PULSADA IPL MARY LAZARO\r\nLLEVO HELIOCARE 360ª\r\n24/MAYO/2022 LIMPIEZA DE ACNE Y LUZ PULSADA IPL LUCY ENTRO 4:55 \r\n24/JUNIO/2022 LIMPIEZA FACIAL Y DERMAPEN   JOHANY ENTRO 4:20\r\n30/JUNIO/2022  LLEVO CREMA GLOBAL CONTORNO DE OJOS DIA Y NOCHE TIMEXPERT RIDES\r\n6/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN MARIANA ENTRO 4:55', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-03 17:57:44', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('651', 'C-100651', '', 'MARIA DE LA SALUD ALBA FUENTES', '9933406487', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('652', 'C-100652', '', 'JUAN FRANCISCO SALAS ALBA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('653', 'C-100653', '', 'MARIELA ZU', '9931148568', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('654', 'C-100654', '', 'MILA CLEMENTE TORRES', '9931709766', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('655', 'C-100655', '', 'MAURICIO MANRIQUE FOJACO', '9933200083', '', '04/09/04 promocion colageno rosy\r\n03/06/05 promocion catiodermia yesy\r\n04/dic/06 promocion nutritiva e hidratante reyna entro 11:20\r\n20/abril/07 promocion botanico bety entro 6:00\r\n14/dic/07 promocion vitamina c mary entro 6:00\r\n23/julio/08 limpieza facial con amp. desincrustante lupita entro 4:55 \r\n21/agosto/08 promocion regenerador antioxidante sara entro 4:35 \r\n29/dic/08 promocion vitamina c sara entro 4:50 salio 6:00 \r\n30/oct/09 promocion hidronutritivo karina entro 5:50 \r\n4/mayo/10 promocion catiodermia reyna entro 6:25\r\n29/julio/10 promocion relajante e hidratante mariana entro 5:45\r\n15/oct/10 promocion efecto botox marina entro 5:40 \r\n27/dic/10 promocion velos de colageno mary lazaro entro 5:32 \r\n16/feb/11 promocion trat. de seda deyanira entro 4:55 \r\n20/mayo/11 promocion botanico reyna entro 5:00\r\n1/sept/11 promocion trat. azteca susy entro 2:00\r\n15/nov/11 promocion germen de trigo con vitamina e reyna entro 5:50\r\n22/dic/11 promocion velo de colageno araceli entro 12:05\r\n07/02/12 lim fac mdm 2x1 atendio jhoany entro 3.40 (mega)\r\n30/marzo/12 promocion hidraderm aracely entro 1:20\r\n31 mayo 12 promocion de velo de colageno atendio lucy entro a las 2 salio   alas 315\r\n30/agosto/12 promocion hidratante y reafirmante gladys \r\n4/oct/12 promocion del mes reafirmante de cuello  araceli entro 1.35\r\n28/nov/12 promocion de colageno mariana entro 1:45\r\n28/nov/12 mdm mariana \r\n16/julio/2013 promocion de colageno y elastina atendio ana entro 5.45 \r\n5/oct/13 promocion té verde graciela entro 11:00\r\n13/nov/13 promocion intensivo antiestres rosy entro 5:20\r\n4/dic/13 promocion de oro susy entro 1:30\r\n12/junio/14 promocion antioxidante lucy entro 5:50\r\n26/agosto/14 promocion oxigenante lucero entro 5:00\r\n07/oct/14 mdm cliente frecuente maribel, promocion trat smoothie mirena entro 4.30 \r\n10/dic/14 promocion trat. global antiedad carmen entro 4:38\r\n20/ene/15 promocion desintoxicante y oxigenante ofelia entro 12:40\r\n11/febrero/15 promocion tratamiento reafirmante mariana entro 1.50\r\n12/marzo/15 promocion tratamiento reafirmante lucy/jhoany entro 5:45\r\n28/abril/15 promocion tratamiento de porcelana maribel entro 4.15\r\n08/agosto/15 promocion chocoterapia mariana entro 1:00\r\n23/oct/15 promocion reafirmante graciela entro 5:10\r\n5/ene/16 promocion desintoxicante reyna entro 5:50\r\n18/feb/16 promocion roll & lift mariana entro 5:30\r\n29/abril/16 promocion trta luxury rosy entro 4:00\r\n7/sept/16 mdm full relax (cleinte frcunte) y promocidon de coalgeno mirena entro 5:00\r\n7/junio/17 promocion antioxidante carmen entro 5:40\r\n11/agosto/17 promocion desvanece las líneas del tiempo yeni entro 5:40\r\n02/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA  LUCY ENTRO 5:05\r\n16/AGOSTO/18 PROMOCION TRAT HUMECTANTE CON ACIDO HIALURÓNICO ANITA ENTRO 5:00\r\n3/JULIO/19 PROM TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO LUPITA ENTRO 4:50\r\n26/JUNIO/2020 TRATAMIENTO FACIAL RECUPERADOR ANTIEDAD  LUCY ENTRO 12:50\r\n16/OCT/2020 PROMOCION TRAT GOLD REGENERANTE MARY ENTRO 1:00\r\n7/ENERO/2021 PROMOCION TRAT OXIGENANTE ANITA ENTRO 9:55\r\n17/ DICIEMBRE/2022 PROMOCION DEL MES TRATAMIENTO G0LDEN  ROSY ENTRO 12:55 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-17 11:46:20', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('656', 'C-100656', '', 'NATIVIDAD TOSCA GURRIA', '9931288581', '', '23/dic/16 limpieza de acne andrea entro 11.40\r\n16/junio/17 promocion antioxidante andrea entro 4:35\r\n25/ENERO/2021 PROMOCION ANTIPOLUCION MONICA ENTRO 11:00\r\n24/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE JHOANY ENTRO 9:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-23 16:38:58', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('657', 'C-100657', '', 'SALVADOR FERNANDEZ LEON', '9935900736', '', ' 9/dic/13 promocion de oro lucy entro 5:30\r\n22/ene/14 promocion desintoxicante rosy entro 5:30\r\n6/marzo/14 promocion del mes humectante mirena entro 5:10\r\n16/julio/14 promocion trat de colageno reyna entro 2:10\r\n27/agosto/14 promocion oxigenante lucero entro 5:10\r\n30/septiembre/14 promocion azteca atendio brenda entro 5:07\r\n09/dic/14 promocion trat. global antiedad mirena entro 6:00\r\n11/abril/15 promocion trat. de porcelana mirena entro 8:00\r\n2/mayo/15 promocion tratamiento de catiodermia reyna entro 9:30\r\n5/junio/15 promocion trat antioxidante maribel entro 6:10\r\n26/sept/15 promocion equilibrante del ph mariana entor 9.15\r\n26/dic/15 promocion reafirmante modeladora ofelia entr 2:25\r\n18/marzo/16 promocion hydrtante lucy entro 6:00\r\n10/julio/16 prom. del mes trat. colageno charito entro 10:05 (mega)\r\n24/septiembre/16 prom. del mes colageno charito entro 10:20 (mega)\r\n22/dic/16 promocion trat multivitaminico mirena entro 11:55\r\n26/enero/17 prom. del mes desintoxicante candy entro 5:15 (mega)\r\n26/febrero/17 prom. del mes elastine lzibeth entro 1:15 (mega)\r\n07/abril/17 prom. del mes trat. termico lizbeth entro 7:00 (mega)\r\n19/mayo/17 prom. del mes trat. antiedad candy entro 6:00 (mega)\r\n29/julio/17 prom. del nes trat. relajante 6:10 (mega)\r\n06/diciembre/17 prom. del mes trat. gold andrea entro 11:00 (mega)\r\n15/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD LUCY ENTRO 12:10\r\n02/octubre/18 prom. del mes trat. reafirmante susy entro 5:50 (mega)\r\n10/enero/19 limpieza facial 2x600 susy entro 4:00 (mega) se le pregunto en la extaccion coo lo estaban atendiendo dijo que todo bien y a la salida se le volvio a preguntar y todo bien\r\n26/MAYO/19 promocion del mes efecto botox susy entro 6:50 mega\r\n14/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA LUPITA ENTRO 5:55\r\n13/NOVIEMBRE/19 TRATAMIENTO FACIAL DE  PERLAS REYNA ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('658', 'C-100658', '', 'MARLENE IRIS HERRERA', '9931435569', '', '2/marzo/16 promocion hidratante mariana entro 5:30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('659', 'C-100659', '', 'ITZEL SEMINA TORRUCO FLORES', '9371119051', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('660', 'C-100660', '', 'MARIA LASTRA EVERARDO', '9931776665', '', '12/marzo/16 limpieza facial con amp. desincrustante mariana entro 1:10\r\n11/junio/16 limpieza facial con amp. desincrustante rosita entro 1:10\r\n5/nov/16 limpieza facial mirena entor 1:50\r\n17/dic/16 limpieza de acne con amp. desincrustante y limpieza de espalda reyna entro 1:30\r\n14/ene/17 masaje full relax (vale regalo) y dep bikini mary lazaor entro 1:15\r\n13/feb/17 depilacion de brasileña 7 Total mary lazaro entro 2:45\r\n4/marzo/17 limpieza de acne susy  entro 1:50\r\n13/marzo/17 depilacion brasileño/total  mariana entro 12.40\r\n3/mayo/17 depilacion brasileña total carmen entro 1:00\r\n2/junio/17 depilacion brasileña total lucy entro 4:45\r\n12/junio/17 limpieza facial con amp. desincrustante rosy entro 2:00\r\n8/julio/17 depilacion de brasileño/total y axila ofelia entro 1:30\r\n30/agosto/17 depilacion de brasileño/total mary lazaro entro 2:00\r\n2/oct/17 depilacion de bikini mariana entro 1:20\r\n14/nov/17 depilacion brasileña total, axila anita entro 3:35\r\n7/dic/17 depilacion bikini lucy entro 10:10\r\n11/enero/18 dep. bikini rosy entro 5:10 (mega)\r\n04/febrero/18 dep. bikini total y axila carmen entro 1:20 (mega)\r\n10/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO  ANITA ENTRÓ 2:05\r\n30/JUNIO/18 LIMPIEZA FACIAL  CON AMP DESINCRUSTANTE ANITA ENTRO 9:00\r\n20/JULIO/18 DEP CON CERA DE BIKINI TOTAL  MARY ENTRO 2:20\r\n8/SEPT/18 DEPILACION DE BIKINI OFELIA ENTRO 12:05\r\n1/NOV/18 DEPILACION CON CERA DE BIKINI TOTAL Y AXILA MARY\r\n11/DIC/18 DEPILACION CON CERA DE BIKINI Y DE AXILA OFELIA ENTRO 12:20\r\n21/FEBRERO/19 DEPILACION DE BIKINI Y AXILA LUCY ENTRO 12:20\r\n23/FEB/19 PROM TRATAMIENTO FACIAL REAFIRMANTE CON AMP DESINCRUSTANTE ANITA ENTRO 9:10\r\n18/MARZO/19 DEPILACION CON CERA DE BIKINI TOTAL Y AXILA OFELIA ENTRO 12:30\r\n18/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX Y DEPILACION CON CERA DE BIKINI TOTAL Y AXILA REYNA ENTRO 9:10\r\n25/MAYO/19 LIMPIEZA DE ESPALDA ANITA ENTRO 9:15\r\n22/JUNIO/19 LIMPIEZA ENTRE PIERNAS ANITA ENTRO 8:05\r\n25/JUNIO/19  MDM FULL RELAX DE CLIENTE FRECUENTE MARY ENTRO 3:10\r\n29/JUNIO/19 PROM TRATAMIENTO FACIAL ANTIEDAD Y LIFTING DE COLAGENO MARY ENTRO 8:05\r\n4/JULIO/19 INICIA DEPILACION DE BRASILEÑA AUT 10 J LUCY\r\n13/JULIO/19 LIMPIEZA DE ESPALDA MARIA DEL C ALEGRIA 8:20\r\n3/AGOSOT/19  LASER DE BRASILEÑA 30 MS 11 J AXILA 30 MS 11J MARY LAZARO ENTRO 8:15\r\n31/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA MARY LAZARO ENTRO 8:15\r\n31/AGOSTO/19 LASER BRASILEÑA AUT 13 J AXILA AUT 13 J MARY LAZARO\r\n7/SEPT/19 LIMPIEZA DE ESPALDA, LIMPIEZA ENTRE PIERNAS OFELIA ENTRO 8:20\r\n7/SEPT/19 LIFTING # 2 CON AMP. BEAUTE II OFELIA\r\n28/SEP/19 TRATAMIENTO FACIAL OXIGENANTE CON AMP DESINCRUSTANTE ALEGRIA ENTRO 8:15\r\n28/SEP/19 LASER BRASILEÑA AUT 14 J AXILA 14J REYNA\r\n26/OCT/19 5TA. BRASILEÑA, AXILA  AUTOM. 15 J LUCY\r\n9/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS Y LIMPIEZA DE ESPALDA ALEGRIA ENTRO 8:20\r\n22/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS LUPITA ENTRO 8:15\r\nLLEVO DABALASH\r\n7/DICIEMBRE/19 LASER BRASILEÑA AUT 16 J AXILA AUT 16J  REYNA\r\n14/DIC/19 PROMOCION TRAT 24 K, LIMPIEZA ENTRE PIERNAS LUPITA ENTRO 8:10\r\n21/DIC/19 LIMPIEZA DE ESPALDA MARY LAZARO ENTRO 8:25\r\n11/ENERO/20 LASER BRASILEÑA AUT 17 J AXILA AUT 17 J LUCY\r\n11/ENERO/20 LIFTIND NUM II SANDY ENTRO 8:55\r\n1/FEB/2020 PROMOCION TRAT 4 F, LIMPIEZA DE ESPALDA, LIMPIEZA DE PECTORAL ANITA ENTRO 8:20\r\n8/FEB/2020 LASER AXILA, BRASILEÑA AUT 17 LUCY \r\n8/FEB/2020 MASAJE DE PIERNAS MILAGROS ENTRO 9:00\r\n22/FEB/2020 DRENAJE LINFATICO, LIFTING TIMEXPERT RIDES, SE LE APLICO AMP. BEAUTE II OFELIA ENTRO 8:15\r\n7/MARZO/20 LASER BRASILEÑA AUT 18 J AXILA AUT 18 J LUCY ENTRO 9:10\r\n21/MARZO/20 TRATAMIENTO FACIAL RECUPERADOR Y LIMPIEZA DE ESPALDA LUPITA ENTRO 8:15\r\n20/JUNIO/20 LIMPIEZA DE ESPALDA, LIMPIEZA PECTORAL, PROMOCION RECUERADOR ANTIEDAD Y DRENAJE LINFATICO SUSI ENTRO 10:30\r\n27/JUNIO/20 LIMPIEZA ENTREPIERNA YANETH ENTRO 8:15\r\n27/JUNIO/2020 LASER BRASILEÑA Y AXILA AUT 18 J ROSITA\r\nLLEVO DABALASH\r\n4/JULIO/2020 MASAJE LASAI, LIMPIEZA DE ESPALDA MARY LAZARO ENTRO 10:10\r\n27/JULIO/2020 MASAJE FULL RELAX DE CLIENTE FRECUENTE OFELIA ENTRO 4:55\r\n28/JULIO/2020 LASER BRASILEÑA AUT 19 J AXILA AUT 20 J OFELIA\r\n29/JULIO/2020 INICIA TRATAMIENTO DE CELULITIS COSTO $10,000.00 ABONO $5,000.00\r\n1.- DERMOSONIC 29/JULIO/2020 ANITA ENTRO 4:55\r\n2.- CARBO, VAC 40 VF SECO 20 30/JULIO/2020 ANITA ENTRO 9:00\r\n3.- DERMOSONIC  31/JULIO/2020 ANITA ENTRO 5:00\r\n4.- CARBO, VAC 40 VF SECO 20 3/AGOSTO/2020 ANITA ENTRO 5:00\r\n5.- DERMOSONIC 4/AGOSTO/2020 ANITA ENTRO 9:10\r\n6.- CARBO, VAC 40 VF SECO 20 5/AGOSTO/2020 ANITA ENTRO 9:10\r\n7.- DERMOSONIC  10/AGOSTO/2020 ANITA ENTRO 5:00\r\n8.- CARBO, VAC 40 VF SECO 20  11/AGOSTO/2020 ANITA ENTRO 5:00\r\n9.- DERMOSONIC 13/AGOSTO/2020  ANITA ENTRO 9:10\r\n10.- CARBO, VAC 40 VF SECO 20 14/AGOSTO/2020 ANITA ENTRO 9:10\r\n11.- DERMOSONIC 17/AGOSOT/2020 ANITA ENTRO 5:00\r\n12.- CARBO, VAC 40 VF SECO 20 19/AGOSTO/2020 ANITA ENTRO 5:00\r\n13.- DERMOSONIC 20/AGOSTO/2020 ENTRO 9:10\r\n14.- CARBO, VAC 40 VF SECO 20 21/AGOSTO/2020 ANITA ENTRO 9:05\r\n15.- DERMOSONIC 25/AGOSTO/2020 ANITA ENTRO 5:05\r\n16.- CARBO, VAC 40 VF SECO 20 26/AGOSTO/2020 ANITA ENTRO 5:00\r\n17.- DERMOSONIC 27/AGOSTO/2020 ANITA ENTRO 9:05\r\n18.- CARBO, VAC 40 VF SECO 20 28/AGOSTO/2020 ANITA ENTRO 9:10\r\n19.- DERMOSONIC 31/AGOSTO/2020 ANITA ENTRO 9:20\r\n20.- CARBO, VAC 40 VF SECO 20 1/SEPT/2020 ANITA ENTRO 9:15\r\nTERMINO TRATAMIENTO DE CELULITIS\r\n1/AGOSTO/2020 TRATAMIENTO FACIA OXIGENANTE, LIMPIEZA DE ESPALDA Y LIFTNG DE TIMEXPERT RIDES MARIANA ENTRO 11:00\r\n15/AGOSTO/2020 LIMPIEZA DE PECTORAL, MICRO DE ESPALDA MONICA ENTRO 8:10 15/AGOSTO/2020 LLEVO CONTORNO DE OJOS TIMEXPERT VITAMINA C \r\n29/AGOSTO/2020 LIMPIEZA DE PECTORAL MONICA ENTRO 8:15\r\n12/SEPT/2020 LIMPIEZA DE PECTORAL, MICRO DE ESPALDA OFELIA ENTRO 8:10 SE LE APLICO AMP. DE ACIDO HIALURONICO EN OVALO FACIAL. \r\n12/SEPT/2020 LLEVO EMULSION EXCEL THERAPY O2, CREMA EXCEL THERAPY O2, CONTORNO DE OJOS EXCEL THERAPY O2, LOCION PURIFICANTE PUREXPERT, GEL EQUILIBRANTE PUREXPERT Y JABON ACNIPOP.\r\n(((((((PROXIMO TRATAMIENTO EN CABINA TRATAMIENTO FACIAL EXCEL THERAPY O2))))))\r\n15/SEPTIEMBRE/2020 MASAJE FULL RELAX DE CLIENTE FRECUENTE ANITA ENTRO 4:05\r\n15/SEPTIEBRE/2020 INICIA TRATAMIENTO DE CELULITIS COSTO $10,000.00 ABONO $5,000.00\r\n1.- LUMICELL 15/SEPTIEMBRE/2020 ANITA \r\n2.-VAC. 30 M, V F 30 M 22/SEPT/2020 ANITA ENTRO 9:15\r\n3.-DERMO 23/SEPT/2020 ANITA ENTRO 9:10\r\n4.-CARBO, LUMICELL 24/SEPT/2020 ANITA ENTRO 9:15\r\n5.-VAC. 30 M, V F 30 M 25/SEPT/2020 ANITA ENTRO 9:10\r\n6.-DERMO 28/SEPTIEMBRE/2020 ANITA\r\n7.-CARBO, LUMICELL 30/SEPTIEMBRE/2020 ANITA ENTRO 9:05\r\n8.-VAC. 30 M, V F 30 M 1/OCTUBRE/2020 ANITA ENTRO 9:10\r\n9.-DERMO 2/OCT/2020 ANITA ENTRO 9:05\r\n10.-CARBO, LUMICELL 6/OCT/2020 ANITA\r\n11.-VAC. 30 M, V F 30 M 7/OCT/2020 ANITA ENTRO 9:10\r\n12.-DERMO  9/OCT/2020 ANITA ENTRO 9:10\r\n13.-CARBO, LUMICELL 12/OCTUBRE/2020 ANITA ENTRO 5:05\r\n14.-VAC. 30 M, V F 30 16/OCT/2020 LUCY ENTRO 9:10\r\n15.-DERMO 21/OCT/2020 ANITA ENTRO 5:15\r\n16.-CARBO, LUMICELL 22/OCTUBRE/2020 ANITA ENTRO 5:10\r\n17.-VAC. 30 M, V F 30 M 26/OCTUBRE/2020 ANITA ENTRO 5:05\r\n18.-DERMO 28/OCT/2020 ANITA ENTRO 9:20\r\n19.-CARBO, LUMICELL 29/OCT/2020 ANITA ENTRO 9:10\r\n20.-VAC. 30 M, V F 30 M 4/NOV/2020 ANITA ENTRO 5:10 TERMINO DE PAGAR EL TRATAMIENTO.\r\nTERMINO TRATAMIENTO DE CELULITIS.\r\n26/SEPTIEMBRE/2020 LIMPIEZA DE PECTORAL, MICRO DE ESPALDA Y FACIAL OXIGENANTE DE EXCEL THERAPY  ANITA ENTRO  12:05\r\n8/OCT/2020 12° BRASILEÑA AUTOM. 20 J/17 J, AXILA AUTOM. 22 J OFELIA\r\n10/OCT/2020 ACLARADO DE BIKINI ($1,000.00) LIMPIEZA DE ESPALDA CON AMP. DESINCRUSTANTE LUCY ENTRO 1:05\r\n17/OCT/2020 ACLARADO DE BIKINI $1,000.00 Y LIFTING NUM II LUCY ENTRO 8:15\r\n14/NOV/2020 13° BRASILEÑA TOTAL AUTOM. 20/17 J, AXILA AUTOM. 22 J OFELIA\r\n7/DICIEMBRE/2020 MASAJE FULL RELAX DE CLIENTE FRECUENTE ANOITA ENTRO 6:00\r\n20/ENERO/2021 MASAJE DRENAJE LINFATICO LUCY ENTRO 3:00 LLEVO DABALASH\r\n25/ENERO/2021 LIMPIEZA ENTRE PIERNAS CON AMP. ACLARADORA OFELIA ENTRO 4:00\r\n27/ENERO/2021 BRASILEÑA AUTOM. 15 J, AXILA AUTOM. 18 J MARY LAZARO\r\n28/ENERO/2021 LIMPIEZA DE ESPALDA LUCY ENTRO 4:00\r\n4/FEB/2021 MASAJE COMBO MIRENA ENTRO 3:00\r\n6/MARZO/2021 PROM. TRATAMIENTO ACIDO HIALURONICO, LIFTING DE TIMEXPERT RIDES Y LIMPIEZA DE ESPALDA MARIANA ENTRO 8:10 \r\n3/MAYO/2021 15° BRASILEÑA AUTOM. 15 J, AXILA AUTOM. 19 J MARY LAZARO\r\n3/MAYO/2021 MASAJE FULL RELAX CLIENTE FRECUENTE ANITA ENTRO 5:00\r\n5/MAYO/2021 LIMPIEZA DE ESPALDA, LIMPIEZA DE ENTRE PIERNAS MIRENA ENTRO 9:15\r\n26/JUNIO/2021 LIMPIEZA DE ESPALDA Y LIMPIEZA ENTRE PIERNAS JOHANY ENTRO 12:30\r\n24/JULIO/2021 MASAJE BONBON VAINILLA, PROMOCION TRAT CAVIAR Y ORO MIRENA ENTRO 8:15\r\n10/AGOSTO/2021 MASAJE DE TE VERDE MIRENA ENTRO 4:00\r\n17/AGOSTO/2021 16° DEPIULACION LASER AXILA AUTO 10J, BRASILEÑA 30ms 10J/100ms 10J LUCY ENTRO 9:00 \r\n18/AGOASTO/2021 LIMPIEZA ENTRE PIERNAS JOHANY ENTRO 5:00\r\n18/SEPT/2021   17ª AXILA AUT 13J, BRASILEÑA 30MS 13J/MAS ABAJO 100MS 10J LUCY ENTRO 9:56\r\n18/SEPT/2021 MASAJE FULL RELAX JHOANY ENTRO 12:05\r\n15/OCT/2021 MASAJE DESCONTRACTURANTE LUCY ENTRO 8:10\r\n16/OCT/2021 18° DEPILACION LASER AXILA AUTO 13J / BRASILEÑA 30ms 13J / MAS ABAJO 100ms 11J LUCY ENTRO 11:00 \r\n8/ENERO/2022 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 (VALE DE REGALO) MIRENA ENTRO 8:15\r\n5/FEB/2022 LASER AXILA AUTOM. 13 J, BRASILEÑA 30 MS 10 J/100 MS 10 J LUCY \r\n5/FEB/2022 LIMPIEZA Y ACLARADO DE ENTRE PIERNAS LUCY $850.00\r\n5/FEB/2022 MASAJE BONBON VAINILLA ARLETH ENTRO 10:00 LLEVO DABALASH\r\n24/MARZO/2022 MASAJE BOMBON FRUTOS ROJOS SUSI ENTRO 3:10\r\n7/MAYO/2022 RETOQUE LASER DE BRASILEÑA 30 MS 10 J OFELIA\r\n11/JUNIO/2022 RETOQUE LASER DE AXILA, BRASILEÑA 30MS 10J  LUCY ENTRO 8:15\r\n11/JUNIO/2022 MASAJE COMBO, LIMPIEZA DE ENTRE PIERNAS LUCY\r\n6/AGOSTO/2022 DRENAJE LINFATICO JHOANY ENTRO 8:20\r\n27/AGOSTO/2022 MASAJE DE DRENAJE LINFATICO MARIANA ENTRO 8:10\r\n27/AGOSTO/2022 RETOQUE AXILA, BRASILEÑA 30 MS 10 J/ 100 MS 10 J LUCY\r\n3/SEPTIEMBRE/2022 PROM. TRATAMIENTO FACIAL PREVENTIVO DE MANCHAS Y LIMPIEZA Y ACLARADO ENTRE PIERNAS CRISTINA ENTRO 8:05\r\n15/OCTUBRE/2022 RETOQUES BRASILEÑO AUT 12J/MAS ABAJO 100MS 12J Y AXILA 30MS 12J LUCY ENTRO 8:20\r\n15/OCTUBRE/2022 MASAJE FULL RELAX ARIANA ENTRO 8:50\r\n10/DICIEMBRE/2022 MASAJE FULL RELAX ARIANA ENTRO 8:20\r\n10/DICIEMBRE/2022 RETOQUES BRASILEÑO AUT 12/MAS ABAJO 100MS 12J Y AXILA 30MS 12J MARY  LAZARO\r\n10/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN Y LIMPIEZA DE ENTRE PIERNA MARY LAZARO                                                                                                                                                                  07/ ENERO/2023 MASAJE RELAJANTE Y LIMPIEZA FACIAL EN PROMOCION PERSONAL TRAJO VALE DE REGALO SUSY ENTRO 10:05 (MEGA)\r\n14/ENERO/2023 MASAJE LASAI ARIANA ENTRO 12:10 ((((VALE DE REGALO))))\r\n19/ENERO/2023 LIMPIEZA DE ESPALDA OFELIA ENTRO 10:50\r\n9/MARZO/2023 MASAJE DRENAJE LINFATICO Y LIMPIEZA ENTRE PIERNAS LUCY ENTRO 2:10\r\n10/MARZO/2023 AXILA 30 MS 12 J, BRASILEÑA  AUT 12/30 MS 12 J, MAS ABAJO 100MS 12J LUCY\r\n30/MAYO/2023 MASAJE DRENAJE LINFATICO JHOANY ENTRO 3:00\r\n11/JULIO/2023 RETOQUE LASER DE AXILA 30 MS 10 J, BRASILEÑA 30 MS 10 J/100 MS 10 J LUCY', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-11 12:21:37', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('661', 'C-100661', '', 'RICARDO CRUZ LASTRA', '', '', '21/DIC/19 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ANITA ENTRO 8:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('662', 'C-100662', '', 'NANCY PAULINA HERNANDEZ GUERRERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('663', 'C-100663', '', 'ANA ISABEL HERNANDEZ GUERRERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('664', 'C-100664', '', 'MARIA ELIZABETH VENTURA GIL', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('665', 'C-100665', '', 'ELVIRA CAROLINA SANTOME GARCIA', '9931609551-3166877', '', '11-01-16 INICIO CAVITACION Y MASAJE ANDREA MEGA ABDOMEN MEGA 91\r\nBUSTO 101 CINTURA 91 CADERA ALTA 92 CADERA BAJA 107 BRAZO 32 MUSLO 63.5\r\n2.- CARBOX Y MASAJE 45M. ANDREA MEGA 12-01-16\r\n3.- MASAJE 45 MINUTOS 13/01/16 andrea entro 11:00 mega\r\n4.-CAVITACION Y MASAJE 14-01-16 CANDY MEGA 11AM\r\n5.- CARBOX Y MASAJE 45M 18-01-16 andrea 12pm\r\n6.- MASAJE 45 MINUTOS 19/enero/16 andrea entro 1:15 (mega)\r\n7.- CAVITACION  Y MASAJE 20/enero/15 rosy entro 11:05 (mega)\r\n8.- CARBOX Y MASAJE 21/enero/16 andrea entro 11:15 (mega)\r\n9 MASAJE 45 MINUTOS \r\n10.- CAVITACION Y MASAJE 45 MINUTOS  02/febrero/16 andrea entro 1:00 (mega)\r\ntermino tratamiento con medidas de a.88 c.83 ca.90 cb.103 b.30 m.59  y peso de 67 1/2 \r\n30/julio/16 mdm full relax charito entro 7:00 (mega)\r\n23/ABRIL/2022 PROMO. TRAT. CINETICO ROSI ENTRO 16:50 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('666', 'C-100666', '', 'JOSE ANTONIO CABRERA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('667', 'C-100667', '', 'JOSEFA IZQUIERDO TORRES', '9933939350', '', '26/feb/16 presoterapia maria entro 8:30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('668', 'C-100668', '', 'ALEJANDRO DIAZ JIMENEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('669', 'C-100669', '', 'ELVIRA MUSTAFA PINETE', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('670', 'C-100670', '', 'ELSA GARZA PULIDO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('671', 'C-100671', '', 'GISELA PEREZ FUENTES', '9931605389', 'giselapef@hotmail.com', '16/oct/15 promocion reafirmante y liftin#2 reyna entro 12:00\r\nINICIA TRATAMIENTO CORPORAL $8000.000 RESTA $4000.000\r\n1.--CAVITACION 60M, MASAJE 45M 17/oct/15 reyna entro 10:10\r\n2.-CARBO, MASAJE 45M, TERMOS 19/oct/15 reyna entro 11:00\r\n3.-MASAJE 45M, CORPO 20/oct/15 reyna entro 12:25\r\n4.-CARBO, MASAJE 45, VC 40 26/oct/15 reyna entro 1:30\r\n5.-MASAJE 45M, aspired en brazos 27/oct/15 reyna entro 12:05\r\n27/oct/15 radio facial sra. bego , termino de pagar el tratamiento\r\n6.-CARBO, LASER LIPOLITICO 20, MASAJE 45M 28/oct/15 reyna\r\n7.-MASAJE 45M, VC 40 29/oct/15 reyna entro 11:00\r\n8.-CARBO, MASAJE 45M, TERMOS 3/nov/15 reyna entro 11:20\r\n9.-cavitacion 60m MASAJE 45M, 28/nov/15 reyna entro 10.40\r\n10.-CARBO, MASAJE 45M, VC 40 21/MARZO/16 CHARITO ENTRO 11.00}\r\nTERMINO EL TRATAMIENTO.\r\n27/nov/15 facial inveNTADO POR LA SRA. BEGO\r\n27/nov/15 llevo crema EXTREME royal jelly , aceite regenerador intensivo ceutical, crema protector solar de diamond\r\n20/ene/16 facial vitamina c de germaine de capuccini sra. bego llevo botas relajante $250.00 cada una\r\n19/marzo/16 hydrabelt de jabotiere sra. bego entro 11.15\r\n23/mayo/16 promocion de colageno  reyna entro 12.00\r\n23/mayo/16 masaje en pies 30 m $250.00 (solo masaje)  reyna\r\n25/mayo/165 mdm drenaje linfatico ofelia entro 9.45\r\n30/mayo/16 masaje drenaje linfatico ofelia entro 9:55\r\nLE DEJARON PAGADO UN PAQUETE DE 3 MASAJE S Y G-5 CON TRES FACIALES $4500.00 \r\n1.-MASAJE 45M, G-5 15M 31/mayo/16 reyna entro 12.15\r\n2.-MASAJE 45M, G-5 15M 6/junio/16 reyna entro 12:15\r\n3.-MASAJE 45M, G-5 15M 30/julio/16 reyna entro 10:10 \r\ntermino le tratamiento.\r\n1.-PROMOCIÓN DE COLÁGENO 31/mayo/16 sr. bego entro 11:00\r\n2.-PROMOCIÓN 6/junio/16 mirena entro 10:15\r\n3.-FACIAL DE VITAMINA C DE NATURA BISSÉ 2/junio/16 sra. bego entro 1:15\r\n25/julio/16 facial hydra veil sras. bego entro 12.10\r\n30/julio/16 exfoliación de brazos de uva $650.00 reyna\r\n18/septiembre/16 mdm full relax 2x500 andrea entro 2.05 (mega)\r\n28/oct/16 promocion de colageno  sra. bego entro 1:15\r\ninicia radio facial $1500.00 cada sesion\r\n3/dic/16 radio facial sra. bego enro 11.30\r\n3/dic/16 tratamiento de pies mary lazaro\r\n8/dic/16 radiofrecuencia facial sra. bego entro 11:30\r\n18/ene/17 promocion desintoxicante sra. bego entro 12:10\r\n13/mayo/17 promocion antiedad con lifting, trat de pies sra. bego entro 11:00\r\n1/julio/17 promocion antioxidante con amp. royal jelly y lifting de colageno sra. bego\r\nLLEVO CONTORNO DE OJOS DE TIMEXPERT LIF IN \r\n26/julio/17 facial modeladora sra, bego entro 11:00\r\n17/agosto/17 facial modeladora sra. bego entro 1:30\r\n26/agosto/17 lifting de timexpert rides sra. bego\r\n22/sept/17 lifting de timexpert rides sra, bego entro 11:15\r\n18/12/17 PROMOCION TRATAMIENTO GOLD ENTRO 10:25\r\n03/MARZO/18 TRATAMIENTO FACIAL DE ROYAL JELLY  SRA BEGO\r\n03/MARZO/18 LLEVO CREMA CUELLO Y ESCOTE DE NATURA BISSÉ\r\n5/MARZO/18 INICIA TRATAMIENTO REDUCTIVO VF EN BRAZOS COSTO $3,000 PAGADO\r\n1.- VF 45  5/MARZO/18 SRA BEGO ENTRO 8:30\r\n2.- VF 45  6/MARZO/18 SRA BEGO ENTRO 8:30\r\n3.- VF 45  7/MARZO/18  SRA BEGO ENTRO 8:30\r\n4.- VF 45  8/MARZO/18 SRA BEGO ENTRO 8:30\r\n5.- VF 45  10/MARZO/18 SRA BEGO ENTRO 9:05\r\n10/MARZO/18 LIFTING DE TIMEXPERT RIDES SRA BEGO\r\n6.- VF 45   15/MARZO/18 SRA BEGO ENTRO 9:05\r\n17/MARZO/18  RADIO EN CUELLO (1,400)   SRA BEGO ENTRO 9:20\r\n7.- VF 45   \r\n8.- VF 45\r\n9.- VF 45\r\n10.- VF 45\r\n28/MARZO/18 RADIOFRECUENCIA FACIAL SRA BEGO\r\n27/JULIO/18 FACIAL COMBINADO CON ALGINATOS DE $1,400.00 SRA. BEGO \r\n18/AGOSTO/18 RADIOFRECUENCIA FACIAL SRA BEGO\r\n18/AGOSTO/18 LLEVO CREMA CHAUFFANTE\r\n5/OCT/18 FACIAL ($1,000) Y TERMOSLIN  SRA BEGO\r\n9/OCT/18 TRATAMIENTO DE 10 SESIONES DE TERMOSLIN COSTO 4,000 PAGADO\r\n1.- TERMOSLIN   9/OCT/18 SRA BEGO\r\n2.- TERMOSLIN  10/OCT/18 SRA BEGO\r\n3.- TERMOSLIN  11/OCT/18 SRA BEGO\r\n4.- TERMOSLIN  12/OCT/18 SRA BEGO\r\n5.- TERMOSLIN  13/OCT/18 SRA BEGO\r\n6.- TERMOSLIN  15/OCT/18 SRA BEGO\r\n7.- TERMOSLIN  16/OCT/18 SRA BEGO\r\n8.- TERMOSLIN  17/OCT/18 SRA BEGO\r\n9.- TERMOSLIN  18/OCT/18 SRA BEGO\r\n10.- TERMOSLIN  15/DIC/18 SRA BEGO\r\n14/DIC/18 FACIAL  COMBINADO 1400.00 SRA BEGO ENTRO 10:00\r\n8/ENE/19 PROM TRATAMIENTO FACIAL REVITALIZANTE SRA BEGO\r\n8/ENE/18 PAGO TRATAMIENTO DE TERMOSLIN COSTO 4,000 PAGADO\r\n1.-TERMOSLIN 11/ENE/19 SRA. BEGO\r\n2.-LASER LIPOLITICO 12/ENE/19 SRA. BEGO\r\n3.-TERMOSLIN  14/ENE/19  SRA. BEGO \r\n4.-LASER LIPOLITICO 15/ENERO/19 SRA. BEGO\r\n5.-TERMOSLIN 16/ENERO/19 REYNA ENTRO 1:25\r\n6.-LASER LIPOLITICO 17/ENERO/19 BEGO ENTRO 3:00\r\n7.-TERMOSLIN 21/ENERO/19 REYNA ENTRO 1:00\r\n8.-TERMOSLIN 22/ENERO/19 OFELIA ENTRO 10:10\r\n9.-TERMOSLIN 23/ENERO/19 SRA. BEGO\r\n24/ENERO/19 FACIAL DE $1,000.00 SRA BEGO \r\n10.-TERMOSLIN\r\n20/MARZO/19 FACIAL VITAMINA C DE GERMAINE SRA BEGO\r\n29/ABRIL/19 FACIAL SRA BEGO\r\n8/MAYO/19 FACIAL REVERSE SRA BEGO\r\n17/MAYO/19 FACIAL ORO SRA BEGO ENTRO 10:00\r\n15/JULIO/19 FACIAL MASC. DE ARGAN CON ACIDO GLICOLICO SRA. BEGO ENTRO 10:20\r\n1/JULIO/20 LLEVO CREMA TIMEXPERT IN CUELLO Y ESCOTE\r\n1/JULIO/20 RADIOFRECUENCIA SRA BEGO\r\n8/JULIO/2020 FACIAL  MODELADORA  SRA BEGO\r\n20/JULIO/2020 FACIAL WELL-BOY CON MASCARILLA DE ALGAS SRA BEGO\r\n3/AGOSTO/2020 RADIOFRECUENCIA EN CUELLO SRA. BEGO ENTRO 11:00\r\n21/AGOSTO/2020  LLEVO CREMA CUELLO Y ESCOTE TIMEXPERT IN\r\n21/AGOSTO/2020 FACIAL CATIODERMIA CON VELO DE COLAGENO SRA BEGO \r\n2/SEPT/2020 RADIOFRECUENCIA, MANOS, PIES Y PARCHES DE COLAGENO  SRA. BEGO ENTRO 11:15\r\n5/SEPTIEMBRE/2020 LLEVO SERUM  TENSOLIF NECK CUELLO Y ESCOTE Y CREMA DE CUELLO Y ESCOTE DE INHIBITH\r\n10/OCT/2020 TRAT. DE CUELLO INHIBIT VELO DE NATURA BISSE SRA. BEGO ENTRO 10:00\r\n7/NOV/2020 FACIAL REVERSE SRA. BEGO ENTRO 12:10\r\n15/ENERO/2021 TRATAMIENTO FACIAL LPG (WELLBOX) CON AMP. ALGOTERAPIA DE NATURA BISSE SRA. BEGO\r\n16/FEB/2021 TRATAMIENTO DE MANOS Y PIES Y FACIAL DE TOX DE GERMAINE LLEVO CREMA SUPREME  SRA BEGO ENTRO 12:15\r\n30/ABRIL/2021 TRATAMIENTO FACIAL CON MASC. DE KIWI SRTA. BEGO LLEVO CREMA Y SERUM DE ORO Y CAVIAR DE AINHOA\r\n21/MAYO/2021 TRATAMIENTO FACIAL PEEL OFF MASC. THE VERDE, TRAT. MANOS CON GUANTE SRA. BEGO ENTRO 9:00\r\n26/JUNIO/2021 FACIAL CANABIS SRA BEGO\r\n8/JULIO/2021 FACIAL BEGO ENTRO 12:25\r\n8/JULIO/2021 FACIAL VALE DE REGALO SRA BEGO Y MASAJE DE ESPALDA OFELIA\r\n12/JULIO/2021 MASAJE BOMBON VAINILLA  MIRENA ENTRO 12:00\r\n1/OCTUBRE/2021 FACIAL REVERS, TRATAMIENTO DE MANOS Y PIES SRA BEGO ENTRO 11:00 \r\n3/NOVIEMBRE/2021 FACIAL VITAMINA C GERMAINE SRA BEGO ENTRO 9:30\r\n12/FEBRERO/2022 FACIAL LASER DE CARBONO CON CANNABIS 1800.00  SRA BEGO ENTRO 10:05********LLEVO CREMA CUELLO Y ESCOTE TIMEXPERT LIFT NECK********\r\n14/FEB/2022 MASAJE BONBON FRUTOS JHOANY ENTRO 1:25\r\n21/ABRIL/2022 FACIAL SRNS Y HAIP TEP SRA BEGO\r\n7/MAYO/2022 FACIAL TIMEXPERT RIDES SRA  BEGO\r\n20/JUNIO/2022 FACIAL EXCEL THERAPY O2 2000.00 SRA BEGO ENTRO 4:10\r\n24/JUNIO/2022 MASAJE DESCONTRACTURANTE, CORPO MARIANA ENTRO 2:20\r\n25/JULIO/2022 FACIAL HYDRACURE Y PARCHES  SRA BEGO ENTRO 1:00\r\n4/AGOSTO/2022 TRATAMIENTO FACIAL CON MASCARILLA DE ALGINATOS DE GERMAINE SRA. BEGO ENTRO 10:50\r\n3/OCTUBRE/2022 FACIAL MESSOBOT SRA BEGO ENTRO 12:55\r\n22/OCTUBRE/2022 TRATAMIENTO FACIAL COLAGENO DE AINHOA  CON CRIOTERAPIA SRA. BEGO ENTRO 11:00 LLEVO ELIXIR ABSOLUTO DE NUTRICION TIMEXPERT RIDES \r\n14/NOVIEMBRE/2022 FACIAL SRA. BEGO ENTRO 11:25\r\n7/DICIEMBRE/2022 MASAJE BONBON FRUTOS ROJOS JHOANY ENTRO 1:00\r\n7/DICIEMBRE/2022 TRATAMIENTO FACIAL CASMARA SRA. BEGO ENTRO 2:30\r\n12/ENERO/2023 TRATAMIENTO FACIAL INFINITUM DE CASMARA SRA. BEGO ENTRO 9:15 LLEVO CREMA HYDRACURE PIEL NORMAL/MIXTA\r\n20/ENERO/2023 TRATAMIENTO FACIAL EXCEL THERAPY SRA. BEGO ENTRO 11:15 ***CORTESIA MANOS CON GUANTES, PIES BOTAS*** SE LE DIO CREMA OXIGENANTE E HIDRATANTE DE CASMARA PURIFYNG\r\n4/MARZO/2023 COOLIFTING,  MANOS  Y PIES  SRA BEGO ENTRO 1:15\r\n15/ABRIL/2023 FACIAL CASMARA OCEAN PLUS HIDRATANTE, MANOS Y PIES SRA BEGO ENTRO 12:45\r\n27/ABRIL/2023 MASAJE FULL RELAX MARIA ENTRO 11:10\r\n27/ABRIL/2023 TRATAMIENTO FACIAL DE CASMARA SRA. BEGO ENTRO 11:10\r\n11/MAYO/2023 FACIAL DE VITAMINA C DE NATURA BISSE SRA BEGO ENTRO 1:50\r\nLLEVO CREMA VITAMINAS DE CASMARA\r\n27/MAYO/2023 FACIAL GLYCOCIUR Y PRESOTERAPIA EN BRAZOS SRA BEGO ENTRO 9:55\r\n9/JUNIO/2023 TRATAMIENTO REVERSE $2000.00 SRA. BEGO ENTRO 2:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-09 10:53:07', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('672', 'C-100672', '', 'NORA HERNANDEZ RODRIGUEZ', '9932101743', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('673', 'C-100673', '', 'JUANA MARIA PEREZ PEREZ', '9932905994', '', '29/MAYO/2023 VALE DE REGALO DUO MASAJE RELAJAN TE DE 45 MINUTOS Y LIMPIEZA FACIAL BASICA SUSY ENTYRO 12:50 (MEGA)\r\n14/JUNIO/2023 DUO MASAJE RELAJANTE Y LIMPIEZA FACIAL SUSY ENTRO 1:10 MEGA\r\n******* ES ALERGICA A LA MASCARILLA DE AVENA, SE LE APLICO LA MASCARILLA DE AZULENO QUE ES PARA PIEL SENCIBLE SE LE TUBO QUE RETIRAR LA CREMA PORQUE TAMBIEN LE DIO REACCION, SE TERMINO CON PANTALLA SOLAR***************\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-14 11:57:01', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('674', 'C-100674', '', 'CECILIA NADAL DEL RIO', '9931609620', '', '22/septiembre/16 lifting carmen entro 4:05 (mega)\r\n20/octubre/16 lifting charito entro 3:10 (mega)\r\n22/febrero/17 masaje de espalda candy entro 4:10 (mega)\r\n11/mayo/17 lifting lizbeth entro 4:15 (mega)\r\n21/sept/17 masaje express carmen entro 4:05 (mega)\r\n13/octubre/17 prom. del mes trat. reafirmante carmen entro 1:00 (mega)\r\n09/noviembre/17 masaje express rosy entro 4:05 (mega)\r\n27/noviembre/17 prom. del mes trat. termico-humectante candy entro 4:05 (mega) quiso que la promocion se le hiciera en una hora por que tenia un compromiso a las 5, se le reporto a doña rosy. \r\n27/febrero/18 prom. del mes trat. multivitaminico monica entro 4:00 (mega) qusio la promocion se le hiciera en una hora por que solo una hora tenia disponible se le reporto a doña rosy. \r\n16/julio/18 prom. del mes trat. intensivo con retinol charito entro 3:35 (mega)\r\n04/octubre/18 mdm full relax susy entro 4:00 (mega)\r\n17/ENE/19 LIMPIEZA FACIAL Y MDM 2X600 SUSI ENTRO 11:00 (MEGA)\r\n12/AGOSTO/2020 LIOMPIEZA FACIAL Y MASAJE FULL RELAX 2X600 MONICA ENTRO 4:00\r\n15/01/2021 masaje full relax 2x1 atendio arleth suc mega ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('675', 'C-100675', '', 'ANGELA AVILA FERNANDEZ', '7772546010', '', '22/mayo/16 prom. del mes colageno susy entro 4:40 (mega)\r\n13/02/18 prom del mes multivitaminico atendio monica entro 4.05 (mega)\r\n31/07/19 limpieza facial 2x600 c/amp. lupita emtro 4.10 (mega) ', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('676', 'C-100676', '', 'TERESA FERNANDEZ MAGA', '7772546010', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('677', 'C-100677', '', 'GLADYS PEREZ CRUZ', '9932349490', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('678', 'C-100678', '', 'RAUL LANESTOSA HERNANDEZ', '9931555129', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('679', 'C-100679', '', 'ANDRES ALEJANDRO PALOMEQUE CADENA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('680', 'C-100680', '', 'MONICA CASANOVA PRIEGO', '9933996302', '', '28/sept/09 limpieza facial 2x1 mary l entro 5:25\r\n28/oct/09 limpieza facial 2 x 1 reyna entro 5:00\r\n llevo crema facial complex marine de lendan\r\n23/dic/09 limpieza facial 2 x 1 lupita entro 9:10 salio 9:10\r\n27/ene/10 limpieza facial 2x1 reyna entro 1:05\r\n5/mayo/10 limpieza facial 2 x 1 araceli entro 10:10 \r\n26/mayo/10 limpieza facial 2 x 1 mary entro 2:00 \r\n16/junio/10 limpieza facial 2 x 1 karina entro 2:00\r\n14/julio/10 limpieza facial 2x1 marina\r\n4/agosto/10 limpieza facial 2 x 1 mariana entro 10:55\r\n6/oct/10 limpieza facial 2 x 1 karina entro 5:15 \r\n1/dic/10 limpieza facial 2 x 1 sara entro 10:10 \r\n llevo concentrado instant lift reafirmante, emulsion facial \r\ny crema contorno de ojos timexpert lift eleva\r\n16/feb/11 limpieza facial 2 x 1 indira entro 5:05 (sucursal) \r\n26/julio/11 retoque de axila autom. 35 j lucy\r\n07/06/11 limpieza facial 2x1 atendio indira entro 5:15 pm salio 6.50 pm (suc)\r\n15/09/11 limpieza de acne 2x1 atendio:jhoany entro:5:15pm salio:6:00pm (suc mega)\r\n17/11/1 limpieza de acne 2x1 atendio:deyanira entro.4.50pm salio:5:45pm (suc mega)\r\n17/11/11 llevo timexpert lift emulsion volumenes perfectos.\r\n15/12/11 trat. velo de colageno atendio graciela entro 4.00 (mega)\r\n17/01/12 limp facial 2x1atendio deyanira entro 6,05 (mega)\r\n22/02/12 limp facial 2x1 atendio (mega)\r\n8/marzo/12 prp cce 7m dr. oscar\r\n03/04/12 limp facial 2x1 atendio jhoany entro 5.00 (mega)\r\n16/06/2012 lim.acne 2x1 atendio jhoani  entro 12:17 (mega)\r\n20/julio/12  lim. acne 2x1 atendio jeny entro 11:10\r\ndepilacion laser de pantorrilla $750.00 c/s\r\n26/julio/12 1ra. pantorrilla autom. 34 j lucy\r\n20/agosto/12 2da. pantorrilla autom. 38 j lucy \r\n20/sept/12 3ra. pantorrilla autom. 42 j lucy\r\n20/sept/12 retoque de axila autom. 40 j lucy\r\n17/10/12 lim. facial 2x1 atendio jenifer entro 5:05 mega\r\n22/oct/12 4ta. pantorrilla autom. 28 j lucy\r\n23/11/12 lim. facial 2x1 atendio jenifer entro 10:00 mega\r\n22/nov/12 5ta. pantorrilla lucy \r\n4/ene/13 6ta. pantorrilla autom. 28 j reyna\r\n8/abril/13 7ta pantorrila   autom. 28j               lucy\r\n25/01/13 lim. de acne atendio jeny entro 5:00 mega\r\n26/03/13 lim. facial 2x1 atendio jhoany entro 11:10 mega\r\n15/05/13 lim. acne 2x1 atendio nelly entro 4:05 mega \r\n26/06/13 lim. nelly 2x1 nelly 5:05 mega\r\n27/07/13 lim. facial 2x1 jhoany mega 10.00\r\n30/julio/13 8ta. pantorrilla autom. 30 j lucy llevo dabalash\r\n30/08/13 limp.2x1 acne nelly mega 10:00\r\n2/oct/13 9na. pantorrilla autom.30j lucy \r\n26/10/13 limp. acne 2x1 nelly mega 1:00\r\n2/dic/13 limpieza de acne reyna entro 5:05\r\n17/dic/13 10° pantorrilla 30 ms 30 j lucy\r\n03/01/14 lim de acne 2x1 atendio martha mega entro 6:10\r\n07/02/14 lim facial 2x1 jhoany mega 10:00\r\n12/04/14 lim de acne 2x1 jhoany mega 10:10 firmo autorizacion para realizar extraccion profunda\r\n21/mayo/14 limpieza facial 2 x 1 carmen entro 10:30\r\n21/mayo/14 depilacion de pantorrilla autom. 10 j lucy\r\n01/07/2014 lim facial 2x1 martha mega 10.20 llevo pure expert crema hidratante no stress y espuma \r\nlimpiadora matificante\r\n08/08/14 lim de acne 2x1 candy mega 10.00\r\n13/sept/14 limpieza facial 2x1  candy entro 6:10 (mega)\r\n08/dic//14 limpieza facial 2x1 nelly entro 6:15 (mega)\r\n07/ene/14 lim.acne 2x1 martha entro 11:00 (mega)\r\n06/feb/15 limpieza facial 2x1 martha nelly entro 12:00 (mega)\r\n01/julio/15 limpieza facial 2x600 mariana entro 12:08\r\ninicia radio facial $1500.00 cada sesion \r\n04/agos/15 radio facial mariana entro 10.00\r\n11/agosto/15 radio facial reyna entro 10:00\r\n19/agosto/15 radiofrecuencia facial reyna entro 10:05\r\n26/agosto/15 radiofrecuencia facial mariana entro 10:00\r\n2-sept-15 radiofrecuncia facial mariana entro 10:10\r\n9/sept/15 radiofrecuencia facial lucy entro 11:00\r\n15/sept/15 radio facial ofelia entro 9:55\r\n17/oct/15 radio facial mariana entro 10:00\r\n10/enero/16 limpieza facial 2x1 charito entro 12:05 (mega)\r\n08/abril/16 limpieza de acne 2x600 charito entro 10:05 (mega)\r\n13/abril/16 axila aut-23j, bikini aut-23j mary lazaro\r\n1/junio/16 promocion de elastine carmen entro 11.00\r\n22/julio/16 limpieza de acne 2x600 charito entro 5:00 (mega)\r\n27/diciembre/16 limpieza de acne 2x600 rosy entro 5:00 (mega)\r\n30/junio/17 limpieza de acne 2x600 candy entro 5:55 (mega)\r\n05/febrero/18 limpieza de acne 2x600 rosy entro 6:05 (mega)\r\n27/marzo/18 limpieza de acne 2x600 monica entro 11:05 (mega)\r\n13/JULIO/18 LASER DE AXILA RETOQUE  AUT 20 J LUCY\r\n27/NOVIEMBRE/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE REYNA\r\n27/NOVIEMBRE/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE REYNA ENTRO 11:00\r\nINICIA TRATAMIENTO DE NEW LIFT $10,000.00 ABONO $5,000.00 RESTA $5,000.00\r\n1.-NEW LIFT 17/FEB/2020 MARY LAZARO ENTRO 12:15\r\n2.-NEW LIFT 18/FEB/2020 MARY LAZARO ENTRO 10:00\r\n3.- NEW LIFT 19/FEB/20 MARY LAZARO ENTRO  11:55\r\n4.- NEW LIFT 20/FEB/20 MARY LAZARO ENTRO 12:00\r\n5.- NEW LIFT 21/FEB/20 MARY LAZARO ENTRO 11:50\r\n6.- NEW LIFT 24/FEB/20 MARY LAZARO ENTRO 12:00\r\n7.- NEW LIFT 25/FEB/20 MARY LAZARO ENTRO 12:00\r\n8.- NEW LIFT 26/FEB/20 MARY LAZARO ENTRO 12:00\r\n9.-NEW LIFT  27/FEB/20 MARY LAZARO ENTRO 12:05\r\n10.- NEW LIFT 28/FEB/20 MARY LAZARO ENTRO 12:00\r\nTERMINO TRATAMIENTO\r\n13/ABRIL/2022 LIMPIEZA FACIAL 2 X 600 CON AMP. OXIGENANTE DE NATURA BISSE MARY LAZARO ENTRO 6:00\r\n8/JUNIO/2022 PROMOCION TRAT YOGA FACIAL LUCY ENTRO 5:00\r\n2/FEBRERO/2023 PROMOCIONTRAT. FACIAL ELIXIR DE JUVENTUD ARIANA ENTRO 5:20\r\n02/JUNIO/2023 PROMOCION DEL MES TRATAMIENTO ULTRASOUND ROSY ENTRO 6:45 (MEGA)\r\n**************LA SEÑORITA NO QUISO MASAJE EN LA ESPALDA. NI EN LA CABEZA Y \r\n                              NO SE QUISO PONER LA BATA**************************************', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-01 21:48:32', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('681', 'C-100681', '', 'JAIR DIAZ CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('682', 'C-100682', '', 'KARLA MARIN MORALES', '9932390587', '', '14/nov/15 limpieza de acne graciela entro 9:45\r\n8/dic/15 limpieza de acne 2x500 reyna entro 5:55\r\n23-04-16 SE REALIZO LIMP DE ACNE CRISTAL CANDY 4PM\r\n12/abril/17 limpieza de acne con amp. desincrustante carmen entro 5:50\r\n14/julio/17 limpieza de acne  mariana entro 6:15\r\n15/FEB/18 LIMPIEZA DE ACNE MARIANA ENTRO 6:10\r\n25/SEP/18 LIMPIEZA FACIAL 2 X 600 LUPITA ENTRO 4:05\r\n10/OCT/18 LIMPIEZA DE ACNE 2 X 600 COM AMP DESINCRUSTANTE LUCY\r\n26/MARZO/2022 PROMOCION TRAT SHOCK DE COLAGENO MARIANA ENTRO 11:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('683', 'C-100683', '', 'PERLA JUAREZ GARAY', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('684', 'C-100684', '', 'KAREN IVET HERNANDEZ JUAREZ', '9931051024', '', '01/JULIO/2022 LIMPIEZA FACIAL CON AMP DESENCRUSTANTE ROSY ENTRO 11:00AM MEGA.', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-01 11:07:04', '1', '26', null, null);
INSERT INTO `clientes` VALUES ('685', 'C-100685', '', 'ANA LAURA ABREU BASTAR', '9931353579', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('686', 'C-100686', '', 'ARTURO MACIAS MORALES', '9931605500', '', '24/05/04 promocion 3 geles bego\r\n14/nov/07 promocion trat hidratante con lifting en párpados reyna entro 9:50\r\n26/sept/08 limpieza facial lupita entro 11:25 \r\n14/oct/08 promocion colageno lupita entro 12:00 \r\n25/feb/09 promocion per collagen lupita entro 12:20 \r\n17/dic/09 promocion flash beaute lupita entro 9:05\r\n10/mayo/10 promocion catiodermia araceli entro 10:45\r\n21/julio/10 limpieza facial con amp. desincrustante mariana entro 11:50\r\n17/feb/11 promocion trat. de seda ofelia \r\n5/abril/11 promocion vinoterapia karina entro 4:22\r\n13/sept/11 limpieza facial sara entro 9:35 la sra bego autorizo el uso de la puntita\r\n28/dic/11 promocion velo de colageno sara entro 10:55\r\n6/junio/12 se realizo limpieza facial  gladys entro 11:15\r\n18/julio/12 limpieza facial 2x1 reyna entro 5:20\r\n10/abril/13 limpieza facial 2 x 1 yusiria entro 9:50\r\n28/agosto/14 masaje descontracturante mariana entro 12.40\r\n10/nov/14 mdm full relax brenda entro 11:10\r\n10/nov/14 limpieza facial brenda entro 12:25\r\n20/abril/15 mdm full relax ana entro 1:30\r\n26/sept/15 promocion equilibrante graciela entro 11:15\r\n26/dic/15 limpieza facial ofelia entro 9:55 \r\n26/dic/15 masaje full relax lucy\r\n13/ene/16 mdm full relax fernanda entro 12:35\r\n19/ene/16 mdm full relax fernanda entro 4:15\r\n16/feb/16 mdm full relax lizvet entro 3:55\r\n12/marzo/16 masaje de espalda charito entro 8:20\r\n18/marzo/16 mdm full relax reyna entro 2:10\r\n20-03-16 SE REALIZO MASAJE CHAMPI MARTHA CRISTAL 10AM\r\n30/marzo/16 masaje de espalda lizvet entro 12.00\r\n((((((((((MASAJE EN PIERNAS 30 MINUTOS $250.00)))))))\r\n22/abril/16 masaje en piernas 30 minutos maria entro 5:00\r\n30/mayo/16 masaje 30 minutos en espalda y 30 minutos en piernas lizvet entro 10:35\r\n8/julio/16 masaje full relax 30 m en espalda y 30 m en piernas reyna entro 12:50\r\n14-07-16 se realizo mdm full relax cristal maria 3-20\r\n19/agosto/16 mdm full relax mariana entro 1:00\r\n25/agosto/16 masaje full relax susy entro 12:05\r\n6/sept/16 masaje en piernas 30m, y espalda 30m mirena entro 12:55\r\n13/sept/16 masaje full relax reyna entro 12:45\r\n13/oct/16 masaje full relax maria entro 12:00\r\n27/oct/16 masaje full relax mariana entro 11:15\r\n31/ocr/16 masaje de 80 minutos en piernas y espalda reyna entro 11.30\r\n7/ene/17 masaje full relax anita entro 10:55\r\n21/feb/17 masaje de espalda susy entro 11:\r\n23/feb/17 masaje full rels susy entro 1:05\r\n10/marzo/17 masaje full relax carmen entro 12:10\r\n03/01/18 MASAJE FULL RELAX MARY ENTRO 2:10\r\n29/SEP/18 LIMPIEZA FACIAL  MARY ENTRO 11:05\r\n3/OCT/19 MASAJE FULL RELAX MARIA DEL C ALEGRIA ENTRO 12:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('687', 'C-100687', '', 'ADRIANA ALVAREZ FALCON', '9323239182', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('688', 'C-100688', '', 'JOSE DANIEL HERNANDEZ HERNANDEZ', '9932074263', '', '10/OCT/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ANITA ENTRO 10:30\r\n22/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN CARMEN ENTRO 11:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('689', 'C-100689', '', 'ASTRID ROSALES ESPINOSA', '', '', '17/feb/11 depilacion de bigote karina \r\n30/junio/14 dep. piernascomp, bigote reyna entro 2:00\r\n31/oct/14 dep piernas completas y bigote yusi entro 10.40\r\n13/enero/15 dep.de piernas completas y bigote lucy entro 5:45\r\n06/julio/15 dep bigote sra bego entro 6:05\r\n17/oct/15 depilacion de bigote candy entro 9:25\r\n18/nov/15 depilacion de bigote reyna entro 5:50\r\n18/dic/15 depilacion de bigote ofelia\r\n18/dic/15 depilacion de bigote ofelia entro 3:10\r\n09/junio/16 depilación de bigote mary lazaro entro 3:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('690', 'C-100690', '', 'MARIANDRE ALEJANDRA MONTERO RODRIGUEZ', '9141209566', '', '30/marzo/16 limpieza facial con laser de acne rosy entrop 3:00', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('691', 'C-100691', '', 'FABIOLA ESTHER DE LA TORRE QUE', '9931767315', '', '9/junio/17 promocion antioxidante anita entro 4:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('692', 'C-100692', '', 'HILDA DEL CARMEN RODRIGUEZ ROMERO', '9141209566', '', '08/nov/11 se iso un tratamiento de manchas mariana entro 3:05\r\n15/nov/11 trat. de manchas karina entro 3:50\r\n29/nov/11 trat. de manchas araceli entro 3:45\r\n7/marzo/12 trat. de manchas lucy entro 3:05\r\n28/marzo/12 trat. de manchas mariana entro 2:55\r\n18/abril/12 trat de manchas lucy entro 3:05\r\n9/mayo/12 trat de manchas gladys entro 2:50\r\n23/06/2012 l.facial atendio deyanira entro 2:00 (mega) salio 3:05\r\n16/07/2012 trat. de manchas  atendio deya entro 10:55 (mega) salio  12:05\r\n16/agosto/12 trat de manchas araceli entro 4:00\r\n11/10/12 promocion del mes atendio jhoany entro 6:00 mega\r\n7/12/12 promocion del mes atendio jhoany entro 3:55 mega\r\n5/enero/13 promocion del mes atendio diana entro 1:50 mega\r\n6/marzo/13 limpieza facial con amp. aclaradora y rayo laser rosy entro 5:00\r\n15/05/13 lim. facial 2x1 atendio nelly entro 10:00 mega \r\n25-04-15 se realizo limp 2x1 entro 2-55 candy\r\n29/07/13 lim. facial 2x1 jhoany mega 10.00\r\n21/09/13 limp facial 2x1  martha amp. serum equilibrante mega 6:00\r\n18/11/13 limp. facial 2x1 con amp aclaradora anita mega 1:55\r\n27/02/14 lim facial c/amp serum  jhoany mega 3:10\r\n18/octubre/15 limpieza facial 2x1 maribel entro 3:05 (mega)\r\n18/diciembre/15 limpieza facial 2x1 eva entro 12:50 (mega)\r\n30/marzo/16 limpieza facial con laser de acne lucy entro 3:00\r\n3/agosto/16 limpieza facial 2x600 con laser de acné marian entro 4:20\r\n17/septiembre/16 limpieza facial 2x500 andrea entro 3:10 (mega)\r\n05/enero/17 limpieza facial 2x600 candy entro 4:00 (mega)\r\n08/julio/17 limpieza facial 2x600 carmen entro 2:55 (mega)\r\n24/febrero/18 limpieza facial 2x600 candy entro 3:00 (mega)\r\n2/MAYO/18 LIMPIEZA CAPILAR 2 X 600 CON LASER ($80) REYNA ENTRO 12:35\r\n18/JULIO/18 LIMPIEZA FACIAL 2 X 600 CON LASER  REYNA\r\n01/diciembre/18 limpieza facial 2x600 lupita entro 2:10 (mega)\r\n28/ABRIL/19 LIMPIEZA FACIAL 2X600 MONY ENTRO 11:00 MEGA\r\n09/AGOSTO/19 limpieza facial 2x600 rosy entro 3:05 mega\r\n1/NOVIEMBRE/19 LIMPIEZA FACIAL 2X600 JANETH ENTRO 1:05 MEGA\r\n4/NOV/2020 LIMPIEZA FACIAL 2 X 600 ANITA ENTRO 9:00 SE LE PUSO LASER DE ACNE $100.00 PESOS\r\n19/MARZO/2021 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 JHOANY ENTRO 3:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('693', 'C-100693', '', 'LEIDY ROMERO RODRIGUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('694', 'C-100694', '', 'ADRIANA IZQUIERDO CRUZ', '9931564884', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('695', 'C-100695', '', 'SILVIA CORTES VASQUEZ', '9931671675', '', 'INICIA TRATAMIENTO REDUCTIVO $4000.00 ABONO $2000.00 RESTA $2000.00 \r\nCON MEDIDA EN OMBLIGO 111 CM Y PESO 79 KG.\r\nLLEVO DIETA DE CALORÍAS\r\n1.-CAVITACION 60M, MASAJE 45M 13/marzo/17 monica entro 5:15\r\n2.-MASAJE 45M 14/marzo/17 monica entro 5:40\r\n3.-MASAJE 45M 15/marzo/17 monica\r\n4.-CAVITACION 60M, MASAJE 45M 16/marzo/17 monica entro 5:20\r\n5.-CARBOX, MASAJE 45M 17/marzo/17 monica entro 6:20\r\n6.-MASAJE 45M\r\n7.-CAVITACION 60M, MASAJE 45M\r\n8.-CARBOX, MASAJE 45M\r\n9.-MASAJE 45M\r\n10.-CAVITACION 60M, MASAJE 45M', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('696', 'C-100696', '', 'EDUARDO JIMENEZ ALVAREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('697', 'C-100697', '', 'PATRICIA CORNELIO CONTRERAS', '9932391861', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('698', 'C-100698', '', 'CLAUDIA MONRROY LOPEZ', '9333276103', '', 'carbo $350.00 c/s\r\n1.-17/feb/11 carbo mary lazaro entro 3:35 \r\n2.-22/feb/11 carbo gladys entro 3:19\r\n3.-25/feb/11 reyna\r\n4.-11/marzo/11 carbo maryl. entroo alas 6:20.\r\n25/feb/11 depilacion de piernas, axilas, promocion trat. de seda reyna entro 4:15\r\n5.-12/marzo/11 carbo gladys entro alas 6:30\r\n6.-8/abril/11 carbo mary lazaro\r\n7.-20/abril/11 carbo sara\r\n8.-9/mayo/11 carbo rosy \r\n9.-18/mayo11 carbo karina \r\n10.-20/mayo/11 carbo araceli\r\n11.-23/mayo/11 carbo sara\r\n12.-25/mayo/11 carbo rosy\r\n13.-27/mayo/11 carbo rosy \r\n8/abril/11 promocion vinoterapia mary lazaro entro 4:05\r\n8/abril/11 termoslin mary lazaro entro 5:32\r\n20/abril/11 micro punta de diamante, termoslin sara entro 5:15\r\n9/mayo/11 depilacion de piernas completas rosy entro 6:00\r\n19/junio/10 trat. # 1 peso 59 kilos \r\n22/julio/10 trat. # 2 peso 57 1/2 kilos\r\n18/agosto/10 trat. # 3 peso 56 1/2 kilos\r\n17/sept/10 trat. # 4 peso 55 1/2 kilos\r\n23/oct/10 trat. # 5 peso 55 1/2 kilos\r\n19/nov/10 trat. # 6 peso 55 1/2 kilos\r\n7/ene/11 trat.# 7 peso 54/600 kilos\r\n9/mayo/11 llevo trat. # 3 y 4 no se peso\r\n18/mayo/11 promocion botanico karina entro 4:50\r\n19/mayo/11 peso 54 1/2 kilos \r\ninicia trat. de vendas frias solo se va a dar 7 sesiones $2450.00\r\n1.-v f 40 m 19/mayo/11 araceli \r\n2.-v f 40 m 20/mayo/11 araceli entro 5:05\r\n3.-v f 40 m 23/mayo/11 sara \r\n4.-v f 40 m 24/mayo/11 araceli entro 5:10\r\n5.-v f 40 m 25/mayo/11 deyanira entro 5:35\r\n6.-v f 40 m 26/mayo/11 araceli\r\n7.-v f 40 m 27/mayo/11 deyanira entro 5:20\r\ntermino tratamiento de vendas.\r\n17/junio/11 delineado de cejas, se le dio $100.00 pesos a ofelia\r\n17/junio/11 carbo lucy entro 6:10\r\n18/junio/11 depilacion de piernas completas, strategist ofelia entro 10:45\r\n1/julio/11 retoque de cejas, se le dio $100.00 pesos a ofelia \r\n1/julio/11 mdm sensorelax susy entro 5:30\r\n14/julio/11 carbo, termoslin, trat. facial hydracure sara entro 1:00\r\n14/julio/11 llevo trat. # 1 y 2 peso 56 1/2 kilos\r\n14/julio/11 llevo pantalla solar y gel hypotermico\r\ndepilacion laser de axila $360.00 c/s\r\n1.-14/julio/11 axila 30 ms 18 j rosy \r\n18/julio/11 carbo reyna \r\n20/julio/11 carbo sara\r\n22/julio/11 carbo sara\r\n24/07/11 tratamiento hidracure atendio indira entro 2.00 pm salio 3:50 pm (suc mega)\r\n27/julio/11 carbo gladys entro 3:10\r\n27/julio/11 llevo serum liporeductor\r\n18/agosto/11 carbo bety entro 6:40\r\n18/agosto/11 trat. # 3 peso 55/400 k.g. llevo pantalla solar\r\n\r\n\r\ntratamiento carbox $350 c/s\r\n1.- carbo 06/sept/11 reyna entro 3:00\r\nllevo tratamiento homeopatico  #4 \r\n24/09/11 carbox indira entro 1:37 pm salio 2.00 (mega) \r\n\r\n11/09/11 se realizo limpieza de acne, g5, carbo, amp hyaluronico se le peso:54kg por q no se le peso\r\nel dia que compro el trat # 4  atendio:deyanira e indira entro:3:05pm   salio: 5.23   (suc mega).\r\n24/09/11 dep de piernas, prom azteca atendio indira entro 2.00   salio4.10  (suc mega) \r\n24/09/11 52/900 kg  y compro el trat. # 5 homeopatia (mega)\r\n30/09/11 carboxiterapia y dep de axila entro 6.00 am salio  6:45 (mega)\r\n2/10/11 carbo atendio graciela entro 4:30 salio 4.50 (mega)\r\n06/10/11 lleva trat#6 homeopatia peso 51.800kgs \r\n06/10/11 carboxiterapia atendio:graciela entro.3:10pm salio:3:30 (suc mega)\r\n06/10/11 llevo gel hypotermico e hydragel de collageno.\r\n12/10/11 carbox y prom del mes octub atendio deyanira entro 6.35 (mega)\r\n14/10/11 carbox y limp. de acne atendio graciela entro 6.00 salio (mega)\r\n16/10/11 carbox y limpieza acne mdm 2x1 atendio graciela entro 4:55 salio 6:50 (mega)  \r\n21/10/11 carbox atendio indira entro 7.05 salio7:20(mega)\r\n21/10/11 compro meladermi manos cuerpo y trat.homehopatico # 7\r\n23/10/11 carbox atendio graciela entro 6.30 salio 6:40 (mega) \r\n02/11/11 carbox prom.dep de piernas atendio deyanira entro 5:35 salio (mega)\r\n04/11/11 carbox , inicio de vendas frias, dep axila atendio graciela entro 6.00 salio 8:10 (mega) \r\n04/nov/11 inicio tratamiento de vendas frias cada sesion $300 autorizo bego\r\n05/11/11 vendas frias atendio deyanira entro 5:50 salio7.00  (mega)\r\n06/11/11 masaje de velas aromaticas (vainilla&chocolate) , carbox y vendas frias atendio: graciela\r\nentro:1:30pm salio:4:00pm   (suc mega)\r\n11/11/11 carbox atendio graciela entro 7.15 salio (mega)\r\n25/11/11 carbox -promocion atendio graciela entro 6:30 (mega)\r\n27/11/11 carbox atendio graciela entro 4:40 (mega)\r\n03/12/11 peso 52 kg carbox,prom, depi, cejas,axila,piernas.entro 3:00 deyanira  \r\n18/12/11 carbox atendio graciela entro 5.30 (mega)\r\n26/12/11 carboxiterapia atendio graciela entro 3:50 (mega) \r\ninicio trat. homeopatico #0\r\n29/12/11 carbox atendio graciela entro 4:25 (mega)\r\n06/01/12 carbox atendio graciela entro 4,05 (mega)\r\n06/01/12 trat revitalizante atendio brenda entro 4:20 (mega)\r\n7/ene/12 masaje 45 m, termoslin sara entro 10:30\r\n08/01/12 carbox atendio graciela entro 6:00 (mega9\r\n13/ene/12 carbo, masaje reductivo mariana entro 5:15\r\n14/ene/12 termoslin lucy entro 12:30\r\n14/01/12 reductivo y promocion de l mes entro 1:56 atendio brenda ( mega )\r\n15/01/12 carbox,reductivo,dep de pierna y axila, cejas atendio deyanira y brenda entro 4:45 salio\r\n7:00 (mega) \r\n20/01/12 carbox y reductivo atendio jhoany e brenda entro 6.55 (mega)\r\n27/ene/12 carbo, masaje reductivo aracely entro 3:35\r\n28/ene/12 limpieza de acne con amp. desincrustante, termoslin mariana entro 12:30\r\n28/01/12  masaje reductivo atendio brenda entro 3.00 (mega)\r\n29/01/12 masaje reductivo carbox atendio brenda graciela (mega)\r\n03/02/12 carbox atendi bego entro 7:05 (mega\r\n6/feb/12 carbo, laser lipolitico 10 m, vibracion 10 m, masaje 10 m lucy entro 4:25\r\n8/feb/12 carbo, laser lipolitico 10 m, vibracion 10 m, masaje 10 m aracely entro 2:40\r\n13/feb/12 carbo, laser lipolitico gladys entro 2:35\r\n17/feb/12 carbo, laser lipolitico mariana entro 3:10\r\n18/feb/12 laser lipolitico ofelia entro 1:30\r\n19/02/12 masaje reductivo y tra. tres geles atendio brenda entro 2:00 (mega)\r\n24/feb/12 carbo, laser lipolitico reyna entro 5:55\r\n29/feb/12 laser lipolitico, carbo gladys entro 2:30\r\n2/marzo/12 carbo sara entro 6:45\r\n5/marzo/12 carbo mariana\r\n8/marzo/12 carbo aracely\r\n8/marzo/12 termoslin, depilacion de cejas aracely\r\ndepilacion de piernas completas $1500.00 c/s\r\n1.-9/marzo/12 piernas completas 30 ms 18 j rosy\r\n5/marzo/12 rell cictr acne carrillo der y sng con juvederm  5 m, btx 25 u ec y pg 3 m\r\n14/abril/12 2da. piernas completas 30 ms 20 j lucy\r\n14/abril/12 1ra. axila 30 ms 18 j lucy\r\n14/abril/12 timexpert white lucy entro 10:15\r\n20/abril/12 carbo mariana\r\n20/abril/12 exfoliacion de cuerpo vitamina c karina\r\n20/abril/12 1ra ipl prog. 2 int. 3 rosy\r\n27/abril/12 carbo karina entro 4:25\r\n5mayo12 carboxiterapia y promocion del mes joana carboxi y brenda facial(mega)\r\n19/mayo/12 carbo lucy \r\n19/mayo/12 2da. axila 30 ms 20 j lucy\r\n19/mayo/12 2da. ipl prog. 2 int. 5 lucy\r\n9/junio/12 carbo rosy\r\n9/junio/12 laser lipolitico, tabla, masaje rosy-diana\r\n22/06/2012 carbox atendio graciela entro 3.21 (mega) salio 3.29\r\n24/06/2012  carbox y masaje reductivo entro 3:10(mega) salio 3:17\r\n29/junio/12 carbo rosy entro 6:00\r\n6/julio/12 carbo karina\r\n6/julio/12 lase lipolitico susy\r\n7/julio/12 laser lipolitico, mdm mariana entro 12:30\r\n08/07/2012 carbox atendio jhoany masaje reductivo  atendio diana entro 6:25 (mega) salio 7:25\r\n10/julio/12 carbo deyanira entro 3:04 salio 3:11 (suc. la mega)\r\n14/07/2012 masaje reductivo atendio jenny carbox atendio deyanira entro 3:25 (mega) salio  4:30\r\n28/julio/12 termo mariana entro 10:35\r\n28/julio/12 ipl lucy\r\n28/julio/12 carbo lucy\r\n28/08/12 inc. v.f. atendio deya entro 6:30 mega\r\n29/08/12 trat. vendas frias atendio deya entro 6:30 mega\r\n30/08/12 trat, vendas frias atendio jhoany entro 6.10 mega\r\n31/08/12 trat. vendas frias atendio deyanira entro 7:05 mega\r\n31/08/12 depilacion de axilas atendio deyanira entro 7:00  mega\r\n1/ 09/12 trat, vendas frias atendio deyanira entro 10:45 mega\r\n4/09/12 trat. vendas frias atendio deyanira entro 6.15 mega\r\n5/09/12 trat. vendas frias atendio deyanira entro 6:20 mega\r\n06/09/12 v,frias atendio jhoany entro 7:15 m ega\r\n7/09/12 trat. vendas frias atendio deya entro 6:30 mega\r\n8/09/12 trat. vendas frias atendio deya entro 2.05 mega\r\n28/08/12 se le dio tarjeta d cliente frecuente\r\n24/oct/12 botox 37 u, relleno dr. oscar\r\n5/abril/13 termoslin yusiria \r\n5/abril/13 depilacion de cejas lucy\r\n24/abril/13 relleno cicatriz de acne $5,000.00 dr. oscar\r\n01/06/13 exfoliacion corporal y masaje reductivo atendio nelly entro 2:00 mega\r\n02/05/13 masaje reductivo y depilacion pierna completa atendio bety entro 3:15 mega \r\n9/agosto/13 masaje reductivo carolina entro 6:15\r\n10/agosto/13 masaje reductivo, timexpert lift ana entro 10:00\r\n21/oct/13 prp03  7.0  txb 5.0  12,00\r\n17/dic/13 ipl cicatriz lucy $500.00 c/s\r\n01/05/14 trat timexpert lift y dep de bigote sr bego mega 12:30 llevo crema de relleno natura bisse\r\n12/mayo/14 prp $7000.00 botox $5000.00\r\n27/junio/14 the cure sra bego entro 4:50 llevo shampoo , mascarilla y crema capilar hidronutitiva\r\n27/junio limpieza capilar bego entro 4:50\r\n27/junio/14 depilacion de cejas entro 4:50\r\n28/junio/14 delineado de cejas, se le dio $100.00 a ofelia\r\n28/junio/14 ipl cicatriz ofelia llevo diamond white protector solar\r\n11/julio/14 masaje reductivo candy \r\n11/julio/14 retoque de cejas, se le dio $100.00 pesos a ofelia\r\n11/julio/14 masaje reductivo candy\r\n13/07/14 masaje reductivo carmen mega 1:20\r\n15/agosto/14 masaje reductivo carmen\r\n15/agosto/14 ipl en cicatriz se le cobro $250.00 ofelia\r\n29/oct/14 plasma rico en plaqueta c/celulas madres $11000.00 y botox $5000.00 dr. oscar garcia\r\n21/nov/14 masaje reductivo y  micro mariana entro 5:20\r\n22/nov/14 masaje reductivo brenda entro 1:30\r\n23/nov/14 masaje reductivo martha entro 1:27 (mega)\r\n24/abril/15 prp c/madres $12000.00 y botox $5000.00 dr. oscar garcia\r\n24/mayo/15 vitamina c, masaje reductivo nelly entro 3:00 salio 6:10 (suc. cristal)\r\n24/mayo/15 depilacion de cejas, medio brazo nelly entro 6:10 salio 6:30 (suc. cristal)\r\n17/julio/15 masaje reductivo mariana entro 5:15\r\n18/julio/15 depilacion de piernas completas, brazos completos, bikini ofelia entro 9:40\r\n18/julio/15 cavitacion 60 m, masaje 45 m ofelia\r\n18/julio/15 llevo luminoso de diamond white\r\n01/agosto/15 cavitacion ofelia entro 11.30\r\n12/oct/15 masaje reductivo charito entro 6:10\r\n25/oct/15 rinoplastia $7000.00 bp angulo mandibular $16000.00 prp cce $7000.00 , botox 1/3 superior y puntia $10000.00 dr. oscar garcia\r\n3/dic/15 masaje reductivo y termoslim lizvet entro 4:50\r\n22/abril/16 prp cce + cell madre $12000.00 dr. oscar garcia\r\n27/mayo/17 masaje reductivo yennifer entro 1:35\r\n18/AGOSTO/18  FACIAL DE VITAMINA C DE NATURA BISSE, LIMPIEZA CAPILAR Y MDM REDUCTIVO REYNA \r\n26/agosto/18 vendas frias, carbox monica entro 4:25 (mega) se llevo gel hyportemico \r\n02/agosto/18 vendas frias, carbox lupita entro 2:10 (mega)\r\n03/FEB/18 DESAFIO ANTIEDAD ANITA ENTRO 12:15\r\n17/MARZO/18 MASAJE REDUCTIVO REYNA ENTRO 2:10\r\n1.- CARBOX, VF Y FACIAL DESAFIO ANTIEDAD  25/AGOSTO/18 MARY ENTRO 11:50\r\n2.- CARBOX, VF  31/AGOSTO/18  ANITA\r\n3.- CARBOX, V.F   1/SEP/18  CHARITO\r\n4.- CARBOX, Y MASAJE REDUCTIVO  9/SEP/18  LUPITA (MEGA)\r\n5.- CARBOX, TERMOS, TIMEXPERT RIDES\r\n6.- CARBOX, CAPSULA, PROMOCION\r\n7.- CARBOX, VF, FACIAL VIT C\r\n8.- CARBOX, TERMOS, PROMOCION\r\n9.- CARBOX, CÁPSULA, TIMEXPERT IN\r\n10.- CARBOX, VF,  PROMOCION\r\n8/SEPT/18 CARBO, MASAJE REDUCTIVO MONICA-LINDA ENTRO 1:10\r\n10/SEPT/18 CARBO, MASAJE REDUCTIVO MARY LAZARO, LINDA ENTRO 2:30\r\n27/OCT/18 PRP CCE, CK1 CK2 VOLUMA 1 ML, TXB 1/3 SUP Y PLATISMA DR OSCAR\r\n16/MAYO/19 MDM REDUCTIVO Y PROM TRATAMIENTO FACIAL EFECTO BOTOX LUPITA ENTRO 1:50\r\n7/SEPT/19 PROMOCION OXIGENANTE LUPITA ENTRO 1:00\r\n07/SEPT/19 TRATAMIENTO REDUCTIVO UNA SECION MONY ENTRO 6.10 MEGA\r\n23/NOVIEMBRE/19 PRP CCE 7,000.00 Y TXB 1/3 SUP PLATISMA 12,000.00 DR OSCAR\r\n30/NOVIEMBRE/19 MICRODERMABRASION SUSI ENTRO 2:50 MEGA\r\n6/MARZO/20 FACIAL DESAFIO ANTIEDAD DE NATURA, LIFTING DE COLAGENO, CARBOX Y 18 DISPAROS DE LIPOSONIX 12 EN ABDOMEN 2 EN ESPALDA Y 1 EN EL GORDITO DE ESPALDA LUCY- MARY LAZARO ENTRO 3:45\r\n24/ABRIL/2021 TRATAMIENTO FACIAL COMPLETO ROSY ENTRO 12:08 (SUC. MEGA)\r\n1/MAYO/2021 TRAT. HOLLYWOOD PEEL SRA. BEGO ENTRO 10:50\r\n1/MAYO/2021 HOLLYWOOD PEEL SRA. BEGO ENTRO 10:50 LLEVO TONICO FACIAL WHITESS AINHOA, CREMA DESPIGMENTANTE AINHOA Y ESPUMA EXFOLEANTE EXCEL THERAPY \r\n8/MAYO/2021 TRATAMIENTO FACIAL DIAMOND LIFT INFUSION ANITA ENTRO 11:30 LLEVO SPOT DIMINISH TIMEXPERT WHITE \r\n29/MAYO/2021 FACIAL  DESPIGMENTANTE AINHOA, Y HOLLEWOOB PEEL ANITA-OFELIA\r\n3/JULIO/2021 TRATAMIENTO FACIAL TIMEXPERT WHITE SRA. BEGO ENTRO 12:35\r\n3/JULIO/2021 **LLEVO ELDOQUIN 4%\r\n** TRATAMIENTO GLOBAL DIA Y NOCHE CONTORNO OJOS\r\n** SERUM ACTIVADOR DEFENSAS EXCEL THERAPY\r\n** SFOT SCRUB ESPUMA ESFOLIANTE DE EXCEL THARAPY\r\n** CREMA TENSO REAFIRMANTE CUELLO Y ESCOTE TIMEXPERT LIFT NECK\r\n10/JULIO/2021 HOLLEWOOB PEEL CON AMP DE OXIGENO DE NATURA BISSE OFELIA ENTRO 1:10 LLEVO CREMA ANTIEDAD DE TIMEXPERT RIDES\r\n24/JULIO/2021 FACIAL VIT C NATURA BISSE, TRAT. BRAZOS NATURA BISSE MARY LAZARO ENTRO 11:35\r\n10/OCTUBRE/2022 INICIA TRATAMIENTO REDUCTIVO COSTO 4,000.00 PAGADO\r\nMEDIDAS CINTURA-OMBLIGO 90 Y PESO 56 1/2\r\n1.- MASAJE 45 10/OCRUBRE/2022 ARIANA ENTRO 2:00\r\n2.- MASAJE 45 11/OCTUBRE/2022 ARIANA ENTRO 2:15\r\n3.- MASAJE 45 12/OCTUBRE/2022 ARIANA ENTRO 1:35\r\n4.- MASAJE 45 13/OCTUBRE/2022 ARIANA ENTRO 1:00\r\n5.- MASAJE 45 14/OCTUBRE/2022 ARIANA ENRO 2:00\r\n6.- MASAJE 45 17/OCTUBRE/2022 CRISTINA ENTRO  3:00\r\n7.- MASAJE 45 19/OCTUBRE/20225 ARIANA ENTRO 3:15\r\n8.- MASAJE 45 20/OCRUBRE/2022 ARIANA ENTRO 2:30\r\n9.- MASAJE 45 21/OCTUBRE/2022 ARIANA ENTRO 3:00\r\n10.- MASAJE 45 24/OCTUBRE/2022 ARIANA ENTRO 11:00\r\nTERMINO TRATAMIENTO CON MEDIDAS CINTURA-OMBLIGO 80CM PESO 56KG\r\n25/OCTUBRE/2022 TRATAMIENTO FACIAL HIDRODERMABRASION CON VITAMINA C DE GERMAINE SRA. BEGO ENTRO 11:00 ((((((( SE LE COBRO $2500.00 PESOS)))))))\r\n///////////////////////////////////////////////////////////////////////////////////////////////\r\n25/OCTUBRE/2022 LLEVO PRODUCTOS:\r\n-ESPUMA EXFOLIANTE EXCEL THERAPY O2\r\n-LOCION TONIFICANTE EXCEL THERAPY O2\r\n-EMULSION OXIGENANTE EXCEL THERAPY O2\r\n-ACTIVADOR DEFENSAS EXCEL THERAPY O2\r\n-CONTORNO DE OJOS EXCEL THERAPY O2\r\n-CREMA OXIGENANTE EXCEL THERAPY O2\r\n-CREMA CUELLO Y ESCOTE COLLAGENT+ DE AINHOA\r\n-GEL HYPOTERMICO\r\n-LE DIO DE REGALO LA MASCARILLA SRNS\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-21 15:05:58', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('699', 'C-100699', '', 'ELIZABETH REYES GOMEZ', '9932071463', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('700', 'C-100700', '', 'KARLA ROSIQUE FERNANDEZ', '9931026494', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('701', 'C-100701', '', 'YARA INES VAZQUEZ MOSQUEDA', '9932420873', '', '13-12-15 SE REALIZO LIMP FACIAL CRISTAL MARTHA 7PM\r\n17/septiembre/16 limpieza facial 2x500 carmen entro 6:10 (mega)\r\n13/mayo/18 limpieza facial 2x600 candy entro 6:00 (mega)\r\n12/agosto/18 limpieza facial 2x600 susy entro 3:55 (mega)\r\n11/DICIEMBRE/19 LIMPIEZA FACIAL 2 X 600 SANDY', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('702', 'C-100702', '', 'MARIA EUGENIA CANCINO CHACON', '9931082088', '', '17/feb/11 promocion trat. seda, dep. de cejas mariana entro 6:01 \r\n24/feb/11 limpieza facial 2 x 1 mary lazaro entro 5:24 \r\n3/marzo/11 limpieza facial 2 x 1 rosy entro 5:50 \r\n10/marzo/11 limpieza facial 2 x 1 mariana entro 5:45\r\n17/marzo/11 limpíeza facial 2x1 deyanira entro 5:53\r\n24/marzo/11 limpieza facial 2 x 1 mary lazaro entro 6:09\r\n7/abril/11 limpieza facial 2 x 1 sara entro 5:20 \r\n13/junio/11 promocion estimulante de endorfinas, depilacion de cejas araceli entro 4:00\r\n28/julio/11 promocion de amaranto lucy entro 12:40\r\n10/agosto/11 depilacion de cejas, limpieza facial 2x1 gladys entro a las 2:00\r\n14/sep/11 promocion y depilacion de cejas sara entro 5:25\r\n06/12/11 prom.velo de colageno dep. cejas atendio dulce entro 5:33 (mega) \r\n11/01/12 limp facial 2x1 atendio deyanira entro 5.05 (mega)\r\n29/03/12 limp facial 2x1 dep cejas atendio jhoany entro 12.45 (mega) con amp hidracuré.\r\n3/agosto/12 limpieza facial 2 x 1 reyna entro 2:00\r\n14/mayo/14 limpieza facial 2x1 mariana entro 8:05\r\n28/mayo/14 limpieza facial 2 x 1 yusiria entro 6:00\r\n27/junio/14 depilacion de cejas nelli entro 1:15\r\n9/julio/14 limpieza facial 2 x 1 ana entro 4:00\r\n14/julio/14 depilacion de cejas nelli entro 9:20\r\n20/agosto/14 limpieza facial 2 x 1 mariana entro 8:10\r\n20/agosto/14 depilacion de cejas mariana\r\n1/oct/14 limpieza facial 2 x 1 mariana entro 2:55\r\n1/oct/14 depilacion de cejas reyna\r\n12/nov/14 depilacion de cejas mariana entro 8:05\r\n26/nov/14 limpieza facial 2x1 carmen entro 4:05\r\n8/dic/14 depilacion de cejas yusiria entro 4:45\r\n14/enero/5 limpiza facial 2x1 carmen entro 5:05\r\n19/enero/15 depilacion de cejas johany enrtro 1:45\r\n21/feb/15 planchado de cejas reyna entro 12:50\r\n9/marzo/15 depilacion de cejas reyna entro 8:00\r\n26/marzo/15 dep. de cejas mariana entro 6.05\r\n22/abril/15 dep de cejas reyna entro 4:50\r\n12/mayo/15 dep de cejas lucy entro 6.00\r\n13/mayo/15 limpieza facial 2x600 carmen entro 8.15\r\n15/junio/15 dep de cejas mariana entro 11:35\r\n19/agosto/15 limpieza facial 2x600 candy entro 8:10\r\n15/SEPTEIMBRE/15 LIMPIEZA FACIAL 2X1 ROSY ENTRO 2:00 (MEGA)\r\n20/SEPTIEMBRE/15 DEP. CEJAS SUSY ENTRO 12:30 (MEGA)\r\n05/noviembre/15 limpieza facial 2x1 maribel entro 7:15 (mega)\r\n17-11-15 se realizo dep de cejas cristal martha 7pm\r\n14/diciembre/2015 limpieza facial eva entro 5:50 (mega)\r\n26/diciembre/15 dep. cejas eva entro 5:30 (mega)\r\n13/junio/16 limpieza facial andrea entro 2:00 (mega)\r\n29/dic/16 promocion trat multivitaminico charito entro 4:35', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('703', 'C-100703', '', 'MARLIS CUPIL LOPEZ', '9931603424', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('704', 'C-100704', '', 'CECILIA PUIG ALBARRAN', '9933111196', '', '31/10/03 promocion modeladora marcela\r\n15/01/04 prom. trat. relajante e hidratante alba\r\n10/06/05 promocion catiodermia ofelia\r\n26/07/05 promocion termico mary lazaro\r\n11/oct/05 promocion modeladora ofelia\r\n22/feb/06 promocion vinoterapia yesy\r\n12/abril/06 limpieza facial mary\r\n16/junio/06 limpieza facial rosy\r\n28/julio/06 limpieza facial mary\r\n02/sept/06 promocion anti couperose mary entro 10:50\r\n04/dic/06 promocion nutriente e hidratante yesy entro 4:10 salio 5:15\r\n27/dic/06 promocion trat. corrector líneas de expresión en párpados y\r\n micro gladys entro 11:10\r\n22/feb/07 limpieza facial bety\r\n16/marzo/07 limpieza facial gladys entro 1:10\r\n25/abril/07 promocion botanica gladys entro 11:00\r\n24/mayo/07 micro y limpieza facial mary lazaro entro 4:05\r\n21/junio/07 limpieza facial odet entro 9:00\r\n13/marzo/08 promocion criogenico bety entro 10:25 termino mary\r\n24/abril/08 limpieza facial araceli entro 11:30\r\n05/JULIO/19  LIMPIEZA FACIAL MONY ENTRO 5.10 MEGA \r\n11/junio/08 promocion catiodermia lupita entro 10:00 \r\n29/julio/08 promocion termico lucy entro 3:30 salio 5:15 \r\n30/sept/08 micro gladys entro 11:20 \r\n22/oct/08 limpieza facial marcela entro 3:50\r\n19/dic/08 limpieza facial mary lazaro entro 4:20 salio 5:45 \r\n20/feb/09 limpieza facial gladys entro 10:10 salio 11:40\r\n2/abril/09 limpieza facial reyna entro 11:00\r\n2/abril/09 micro\r\n12/junio/09 micro araceli entro 10:30 salio 11:45 \r\n16/julio/09 limpieza facial mary entro 4:35 \r\n27/agosto/09 limpieza facial con amp. piel grasa de lendan mary entro 9:40\r\n15/oct/09 micro gladys entro 11:15 \r\n28/oct/09 limpieza facial gladys entro 10:55 \r\n27/nov/09 limpieza facial gladys entro 9:40\r\n18/feb/10 promocion estimulante de endorfinas gladys entro 9:20 \r\n24/marzo/10 promocion de cristal gladys entro 12:10\r\n20/abril/10 promocion 3 geles gladys entro 10:10\r\n16/junio/10 promocion botanico 4 f gladys entro 8:30\r\n6/sept/10 micro mary lazaro entro 4:45\r\n18/feb/11 limpieza facial gladys entro 8:35 \r\ninicia tratamiento de ipl manchas $1000.00 c/s\r\n1.-18/feb/11 prog. i int. 3 lucy \r\n13/abril/11 promocion vinoterapia con amp. desincrustante, dep. bigote gladys entro 10:30\r\n12/mayo/11 micro punta de diamante gladys entro 10:45\r\n29/sep/11 promocion azteca gladys entro 9:25\r\n29/marzo/12 limpieza facial, depilacion de bigote gladys entro 8:05\r\n3/mayo/12 limpieza facial, micro cristales gladys entro 8:25\r\n21/agosto/12 micro punta de diamante gladys entro 8:00\r\n29/oct/12 llevó crema contorno de ojos de timexpert lift \r\n19 de dic 12 se llevó crema hydracure piel mixta\r\n2feb13 promocion del mes catiodermia atendio gladis entro a las 1230 salio 2\r\n12/marzo/12 limpieza facial gladys entro 12:15\r\n7/mayo/13 limpieza facial, depilacion de bigote gladys entro 8:00\r\n19/junio/13 micro punta de diamante rosy entro 8:00\r\n26/junio/13 limpieza facial, depilacion de bigote gladys entro 10:15\r\n9/sept/13 limpieza facial, depilacion de bigote gladys entro 10:05\r\n13/nov/13  gladys \r\n14/dic/13 limpieza facial, depilacion de bigote gladys entro 8:05\r\n12/junio/14 limpieza facial, depilacion de cejas mariana entro 8:20\r\n06/agosto/4 limpieza facial, dep de cejas y bigote mariana entro 10:15\r\n10/sept/14 limpieza facial, micro, depilacion de bigote mariana entro 9:15\r\n28/oct/14 limpieza facial dep de cejas y dep bigote mariana entro 9:20\r\n16/dic/14 limpieza facial, depilacion de bigote y cejas mariana entro 8:00\r\n22/abril/15 limpieza facial, micro y dep. bigote y cejas mariana entro 8.25\r\n24/junio/15 micro, limpieza facial  y dep. cejas mariana entro 9:10\r\n22/agosto/15 micro mariana entro 12:00\r\n12/sept/15 micro y dep de cejas mariana entro 10:20 llevó filtro solar de diamond\r\n27/oct/15 limpieza facial mariana entro 12:05 llevó desmaquillador de ojos y labios de ceutical\r\n27/oct/15 botox 1/3 sup $5000.00 dr. oscar garcia\r\n1/dic/15 limpieza facial andrea entro 5:25\r\n1/dic/15 depilacion de bigote mariana\r\n7/ene/16 limpieza facial, depilacion de bigote y cejas mariana entro 12:10\r\n17/feb/16 limpieza facial y dep de bigote mariana entro 4:00\r\n5/abril/16 microdermoabrasion y dep de cejas y bigote mariana entro 10.30 \r\n14/mayo/16 limpieza facial y dep de, bigote mariana entro 11:15\r\n01/julio/16 micro mariana entro 12:30\r\n5/oct/16 pago la micro que debia\r\n31/oct/16 limpieza facial y dep de cejas  mariana entro 12:55\r\n4/abril/17 limpieza facial, micro mariana entro 1:15\r\n4/julio/17 limpieza facial mariana entro 5:00\r\n4/julio/17  depilacion de cejas y bigote mariana\r\n11/agosto/17 limpieza facial mary lazaro entro 12:30\r\n5/sept/17 limpieza facial, dep de cejas y bigote mariana entro 11:10\r\n23/ENERO/18 LIMPIEZA FACIAL, DEPILACION DE BIGOTE Y CEJAS MARIANA ENTRO 12:05 QUEDO A DEBER $172.00\r\n01/FEB/18 SALDO DE 172 PAGADO\r\n19/FEB/18 LIMPIEZA FACIAL MARIANA ENTRO 5:05\r\n3/MAYO/18 MICRO, DEPILACION DE CEJAS Y BIGOTE MARIANA ENTRO 1:10\r\n22/AGOSTO/18  LIMPIEZA  FACIAL  OFELIA  ENTRO  11:30\r\n11/SEPT/18 MICRO, DEPILACION DE CEJAS Y BIGOTE, SE LE APLICÓ LA AMP. CLARIFICANTE DE GERMAINE OFELIA ENTRO 11:20 LLEVÓ CREMA CONTORNO DE OJOS ESSENTIAL SHOCK DE NATURA BISSÉ\r\n12/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE Y DEP DE BIGOTE MONICA ENTRO 11:45\r\n28/ENERO/19 LIMPIEZA FACIAL, DEPILACION DE CEJAS OFELIA ENTRO 3:55\r\n11/ABRIL/19 LIMPIEZA FACIAL Y DEPILACION DE CEJAS Y BIGOTE OFELIA ENTRO 3:45\r\n31/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX MONICA ENTRO 5:40\r\n11/NOVIEMBRE/19 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY ENTRO 2:10\r\n27/DIC/19 LIMPIEZA FACIAL, DEPILACION DE CEJAS ANITA ENTRO 6:00\r\n19/FEB/2020 MICRO PUNTA DIAMANTE MONICA ENTRO 9:25\r\n9/OCTUBRE/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ROSITA ENTRO 4:55\r\n23/MARZO/2021 LIMPIEZA FACIAL OFELIA ENTRO 3:30\r\n22/SEPT/2021 HOLLEWOOB PEEL  OFELIA MARIANA ENTRO 1:00\r\n16/FEB/2022 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE  MARIANA ENTRO 10:10\r\n8/MARZO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARIANA ENTRO 1:00\r\n24/MAYO/2022 MICRODERMABRASION OFELIA ENTRO 3:15\r\n17/AGOSTO/2022 LIMPIEZA FACIAL OFELIA ENTRO 3:05\r\n26/AGOSTO/2022 MICRO MARIANA ENTRO 1:10\r\n19/ENERO/2023 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE, DEPILACION DE BIGOTE CON CERA MARIANA ENTRO 10:15\r\n30/MAYO/2023 LIMPIEZA DE ACNE OFELIA ENTRO 3:15', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-26 17:06:33', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('705', 'C-100705', '', 'MARIA LUISA OJEDA ORTIZ', '9935901407', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('706', 'C-100706', '', 'ALEJANDRA SANCHEZ MURGUIONDO', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('707', 'C-100707', 'SGA1207098S8', 'LIZBETH ESTELA RODRIGUEZ ESCAYOLA', '9141001186', 'serviplusgasolinero@gmail.com', '19-09-15 se realizo dep de axila  bnin mire cristal  10 am\r\n5/oct/15 masaje full relax graciela entro 12.20\r\n9/feb/16 masaje de espalda maria entro 2:15\r\n13/feb/16 promocion roll & lift carmen entro 11:20\r\n13/feb/16 masaje de espalda reyna entro 1:00\r\n21/abril/16 promocion trat luxury carmen entro 5:30\r\n28/abril/16 mdm holistico maria entro 6:15\r\n24/junio/16 promocion de elastine lizvet entro 3:00\r\n14/julio/16 masaje full relax ofelia entro 6:00\r\n24-07-16 se realizo dep bikini y linea de abdomen mire cristal 3:05\r\n30/ene/17 promocion desintoxicante susy entro 2:50\r\n7/marzo/17 promocion estimulante de colageno con masc. led mariana entro 1:25\r\n8/mayo/17 mdm full relax 2x600 carmen entro 1:10\r\n23/ENERO/18 PROMOCIÓN TRAT. OXIGENANTE CON ULTRASONIDO REYNA ENTRO 12:15 \r\n2/OCT/19 PROMOCION DOBLE ACCION REYNA ENTRO 10:20\r\n11/JULIO/2022 MASAJE FULL RELAX ARIANA ENTRO 10:54 \r\n20/FEBRERO/2023 PROMO TRATAMIENTO FACIAL ELIXIR JUVENTUD ARIANA ENTRO 3:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-29 09:36:42', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('708', 'C-100708', '', 'CLAUDIA LOPEZ MAGA', '9932154751', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('709', 'C-100709', '', 'ARTEMISA PULIDO CAMPOS', '', '', '13/julio/17 limpieza facial yeni entro 11.00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('710', 'C-100710', '', 'ROCIO PALMA MOLINA', '9931889473', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('711', 'C-100711', '', 'AIME VELEZ RIVES', '9933609937', '', '14/nov/15 limpieza de acne sra. bego \r\n14/nov/15 depilacion de bikini reyna \r\n23/marzo/16 limpieza facial sra. bego\r\n23/marzo/16 depilacion de bikini y patillas reyna\r\n5/mayo/16 limpieza de acne y dep de cejas sr. bego\r\n14/junio/16 limpiez de acne con gelula verde lucy entro 10:30\r\n23/julio/16 limpieza de acne con gelula verde sra. bego\r\n23/julio/16 depilacion de brasileño/total, gluteos y patillas ofelia \r\n23/julio/16 locion biocontrol, jabon acnipop, crema hidrante no-estrés de purexpert \r\n4/ene/17 limpieza de acne con gelula verde sra. bego\r\n4/ene/17 depilacion de bikini anita entor 12:30\r\n4/ene/17 llevo mousse oxígeno de natura bisse \r\n5/julio/17 limpieza de acne profunda lucy/sra. bego\r\nLLEVO MOUSSE DE OXIGENO, HELIOCARE GEL Y GEL-CREMA HIDRO MATIFICANTE DE PUREXPERT\r\n3/agosto/17 LLEVO EXFOLIANTE SCRUB, LOCION BIOCONTROL Y OXYGEN MOUSSE.\r\n05/01/18 MICRODERMOABRASION MARY ENTRO 2:00\r\n28/MARZO/18 LIMPIEZA FACIAL 2 X 600 SRA. BEGO ENTRO 11:30 LLEVO CREMA HIDRATANTE NO ESTRÉS DE PUREXPERT Y ESPUMA LIMPIADORA OXYGEN NB\r\n26/JULIO/18 LIMPIEZA FACIAL CON AMP. SO-DELICATE BEGO ENTRO 9:30 LLEVO CREMA SO-DELICATE TOLERANCE CARE PIEL NORMAL, ESPUMA LIMPIADORA OXYGEN MOUSSE DE NATURA BISSÉ.\r\nSE LE RECOMENDÓ EL TONICO DE CEUTICAL\r\n21/DIC/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARY ENTRO 12:20\r\n9/ENE/19 DEPILACION DE PATILLAS MARY\r\n30/JULIO/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE SRA BEGO\r\n30/JULIO/19 DEPILACION CON CERA DE BIKINI MARY\r\n8/AGOSTO/19 LLEVO JABON ACNIPOP Y LOCION BIO-CONTROL\r\n8/ENERO/20 LIMPIEZA FACIAL PROFUNDA SRA. BEGO ENTRO 11:00 LLEVO LOCION BIOCONTROL, JABON ACNIPOP \r\n10/FEB/2020 LIMPIEZA FACIAL PROFUNDA LUPITA ENTRO 11:15 LLEVO LOCION BIOCONTROL\r\n28/MAYO/2020 LIMPIEZA FACIAL PROFUNDA SRA. BEGO LLEVO LIMPIEADORA FACIAL ACIDA, LOCION BIOCONTROL, JABON ACNIPOP\r\n26/JUNIO/20 LIMPIEZA FACIAL PROFUNDA SRA BEGO\r\n26/JUNIO/20 DEPILACION CON CERA BRASILEÑA LUCY\r\n29/JULIO/2020 LIMPIEZA DE ACNE PROFUNDA Y DEPILACION DE PATILLAS SRA BEGO\r\n29/JULIO/2020 LLEVO LOCION BIO-CONTROL\r\n5/AGOSTO/2020 DEPILACION BRASILEÑA TOTAL, AXILA OFELIA ENTRO 11:10 LLEVO ROLL-ON PUREXPERT\r\n13/ENERO/2021 LIMPIEZA FACIAL PROFUNDA, DEPILACION DE CEJAS SRA. BEGO ENTRO  9:05 LLEVO LOCION BIOCONTROL Y CREMA HIDRATANTE NO ESTRES\r\n12/JULIO/2021 LLEVO JABON ACNIPOP, LOCION BIO-CONTROL Y ESPUMA DE NATURA BISSE\r\n19/ENERO/2022 HIDRODERMABRASION BEGO ENTRO 11:10\r\n5/JULIO/2022 LIMPIEZA DE ACNE PROFUNDA BEGO ENTRO 11:50 \r\n10/ENERO/2023 LIMPIEZA DE ACNE PROFUNDA SRA BEGO\r\nLLEVO LOCION BIO-CONTROL', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-09 14:57:21', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('712', 'C-100712', '', 'SABAS ARTURO GALLARDO RODRIGUEZ', '9931472145', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('713', 'C-100713', '', 'TANIA SOSA NAVARRO', '9933110893', '', '7/agosto/17 delienado de párpado inferior ofelia, se le dio $100.00 a ofelia\r\n26/agosto/17 retoque de parpado inferior ofelia, se le dio $100.00 a ofelia (no vino)\r\n28/OCTUBRE/2021 DELINEADO DE PARPADO INFERIOR SE LE DIO 300 OFELIA ENTRO 2:15\r\n10/NOVIEMBRE/2021 SE LE HABLO PARA COFIRMAR SU CITA Y COMENTO QUE NO LO REQUIERE', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('714', 'C-100714', '', 'MAYANIN PERALTA MADRIGAL', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('715', 'C-100715', '', 'GENESIS RODRIGUEZ PI', '', '', '9/nov/15 limpieza de acne con amp. desincrustante lizvet entro 2:30\r\n13/nov/15 limpieza de acne  con amp. desincrustante lizvet entro 12:30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('716', 'C-100716', '', 'SONIA MEDINA PEREZNIETO ', '9932073212', '', '05-09-15 SE REALIZO DEP DE PIERNAS C Y BIGOTE MARTHA CRISTAL 4\r\n11/diciembre/15 depilacion de píernas completas y bigote rosy entro 12:00 (mega)\r\n28/febrero/17 depilacion de bigote y piernas completas rosy entro 11:15 (mega)\r\n27/mayo/17 dep. piernas completas y bigote candy entro 2:55 (mega)\r\n07/julio/17 dep. piernas completas y bigote carmen entro 12:55 (mega)\r\n10/agosto/17 dep.piernas completas y bigote andrea entro 2:05 (mega)\r\n13/sept/17 dep. piernas completas y bikini carmen entro 12:50 (mega)\r\n14/octubre/17 dep. piernas completas y bikini total carmen entro 12:15 (mega)\r\n18/noviembre/17 dep. piernas completas andrea entro 6:55 (mega) tiene operados los ojos se le pregunto si se le podia poner el lifting de cortesia por el buen fin y autorizo que si. \r\n21/diciembre/17 dep. piernas completas andrea entro 3:50 (mega)\r\n02/febrero/18 dep. piernas completas candy entro 2:20 (mega)\r\n07/marzo/18 dep. piernas completas susy entro 1:55 (mega)\r\n24/julio/18 dep. piernas completas charito entro 2:00 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('717', 'C-100717', '', 'GUADALUPE PEREZ DE MADERA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('718', 'C-100718', '', 'ISILICOM, S.A DE C.V.', '9933125138', 'JVIDAL@ISILICOM.COM', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('719', 'C-100719', '', 'LORENA JUAREZ DE ARGUELLES', '9933999903', 'lorenajuarez67@hotmail.com', '18/feb/11 promocion trat. de seda araceli entro 21:43 salio 2:00\r\n22/oct/12 promocion reafirmante de cuello lucy entro 9:25\r\n3/nov/12 hydracure bego entro 10:25\r\ninicia vendas frias $3000.00 abono $1500.00 resta $1500.00\r\ncon medidas cintura (ombligo) 83, cadera alta 88, cadera baja 102 peso 61 kilos\r\n1.-vendas frias 27/agosto/15 mary entro 9:40\r\n2.-vendas frías 28/agosto/15 mary entro 8:55\r\n28/agosto/15 promocion chocoterapia sra. bego \r\n3.-vendas frias 31-agos-15 mary entro 9:25\r\n4.-vendas frias 1-sept-15 mary entro 10:25\r\n5.-vendas frias 2-sept-15 graciela entro 9:30\r\n6.-vendas frias 3/sept/15 mary entro 9:25\r\n7.-vendas frias\r\n8.-vendas frias\r\n9.-vendas frias\r\n10.-vendas frias\r\nSE LE REPONE EL TRATAMIENTO CON DOS FACIALES DE HYDRATACION.\r\n1.-12/oct/15 limpieza facial de hydratacion lucy entro 10:00 \r\n2.-\r\n12/JUNIO/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE JOHANY ENTRO 11:05\r\n20/ENERO/2023 MASAJE DESCONTRACTURANTE ARIANA ENTRO 9:10\r\n25/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE ARIANA ENTRO 10:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-24 18:46:31', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('720', 'C-100720', '', 'FERNANDO BURELO VALENZUELA', '9935902585', '', '18/12/04 limpieza facial consuelo\r\n07/05/05 limpieza facial marcela\r\n02/08/05 promocion regenerador antioxidante mary lazaro\r\n06/09/05 citoquinas mary\r\n29/oct/05 promocion modeladora mary lazaro\r\n14/dic/05 promocion vitamina c reyna\r\n31/ene/06 promocion relajante e hidratante reina\r\n24/abril/06 promocion coco y mango marcela\r\nse fue muy molesto porque se quejo dijo que no \r\nse le extrajo bien en la nariz atendio marcela.\r\nla proxima vez que venga no se le va a cobrar\r\n24/abril/06 promocion coco y mango marcela.\r\n05/oct/06 promocion renove mary entro 2:15 salio 4:00\r\n11/dic/06 prom. navideña nutriente e hidratante yesy entro 2:40 \r\n15/feb/07 promocion ginseng reyna entro 2:30\r\n llevo hydrasoin fresh, limpiadora facial acida\r\n27/abril/07 limpieza facial lupita entro 12:05\r\n01/junio/07 promocion trat. de cristal mary lazaro entro 2:25\r\n20/julio/07 promocion colageno y lifting de parafina marcela entro 2:15\r\n03/agosto/07  se llevo hidrasoin fresh\r\n11/sept/07 promocion colageno mary entro 2:50\r\n11/dic/07 promocion vitamina c mary lazaro entro 3:25\r\n15/dic/07 lifting de parafina mary entro 10:55\r\n17/ene/08 promocion relajante e hidratante,\r\n lifting de parafina mary lazaro entro 2:30 \r\n12/feb/08 promocion dermorelax mary lazaro entro 2:35 \r\n1/marzo/07 lifting de parafina gladys entro 10:30\r\n3/abril/08 promocion botanico y lifting de parafina reyna entro 11:40\r\n17/mayo/08 promocion de 3 geles reyna entro 12:00 y lifting de parafina reyna \r\n13/agosto/08 promocion regenerador antioxidante marcela entro 2:30\r\n20/sept/08 promocion modeladora, lifting de parafina lupita entro 10:40 \r\n20/sept/08 rizado y tinte de pestañas lucy \r\n16/oct/08 promocion colageno y lifting de parafina mary lazaro entro 2:45 \r\n14/nov/08 promocion lifting de parpados julia entro 3:10 \r\n19/dic/08 promocion vitamina c mary lazaro entro 3:00 salio 4:10 \r\n31/ene/09 promocion jalea real, lifting de parafina rosy entro 12:50\r\n21/feb/09 promocion percollagen, lifting de parafina mary entro 10:30 \r\n13/marzo/09 promocion spa therapy perla, \r\nlifting parafina mary lazaro entro 2:40 \r\n14/abril/09 promocion spa therapy oro,\r\n lifting de parafina reyna entro 11:00 \r\n13/mayo/09 promocion trat intensivo en parp y labios \r\nmary l entro 2:35 salio 4:00\r\n24/junio/09 promocion white line mary lazaro entro 2:25 \r\n24/julio/09 promocion extraperformance, \r\nlifting de parafina mary lazaro entro 2:35\r\n15/agosto/09 lifting de parafina reyna entro 10:05 \r\n27/agosto/09 promocion revitalizante con amp. aclaradora\r\n mary lazaro entro 2:35\r\n10/oct/09 limpieza facial y lifting de parafina lupita entro 11:00 \r\n29/oct/09 promocion de limpieza facial con  lifting de parpados \r\nmary lazaro entro 2:30\r\n11/dic/09 promocion flash beuate, lifting parafina sara \r\nllevo crema de labios timexpert\r\n14/ene/10 promocion vinoterapia, lifting parafina marina entro 2:50\r\n4/feb/10 promocion limpieza facial con lifting mary lazaro entro 2:30\r\n25/feb/10 limpieza facial gladys entro 2:30 \r\n12/marzo/10 promocion de cristal, lifting # 2 lupita entro 5:20\r\n30/marzo/10 promocion de cristal, lifting # 2 karina entro 2:30\r\n10/abril/10 lifting # 2 gladys entro 10:20 \r\n29/mayo/10 promocion catiodermia, lifting # 2 araceli entro 10:50 \r\n25/junio/10 promocion botanico 4 f, lifting # 2 araceli entro 10:50 \r\n20/agosto/10 promocion antiarrugas, lifting # 2 marina entro 2:40 \r\n29/oct/10 promocion efecto botox, lifting # 2 mariana entro 2:25 salio 3:05 \r\n22/dic/10 promocion velos de colageno, lifting # 2 gladys entro 2:10\r\n18/feb/11 promocion trat. de seda, lifting # 2 mary lazaro entro 2:21 \r\n20/abril/11 promocion vinoterapia con amp. desincrustante, lifting # 2 sara entro 2:40 \r\n31/oct/11 promocion relajante dulce entro 2:40\r\n9/dic/11 promocion velo de colageno gladys entro 2:15 llevo pack hydracure de contorno de ojos y \r\ncrema hydractiva\r\n12/ene/12 promocion revitalizante mariana entro 2:30\r\n19/abril/12 promocion revitalizante con amp. desincrustante sara entro 2:30\r\n28/junio/12 promocion reafirmante sara entro 2:30\r\n19/oct/12 promocion reafirmante de cuello con amp. desincrustante reyna\r\n13/dic/12 promocion de oro lucy entro 2:40\r\n26/marzo/13 promocion royal jelly con amp. desincrustante mariana entro 2:15\r\n25/abril/13 promocion porcelana reyna entro 2:25\r\n30/mayo/13 promocion relajante e hidratante reyna entro 2:30\r\n15/agosto/13 promocion oxigenante con amp. desincrustante atendio mariana entro 1:25\r\n18/oct/13 promocion the verde, lifting # 2 mariana entro 2:25\r\n14/nov/13 promocion intensivo antiestres carolina entro 2:25\r\n5/dic/13 promocion de oro yusiria entro 2:30\r\n4/abril/14 promocion de porcelana con amp. desincrustante mariana entro 2:25\r\n13/nov/14 promocion antiedad humectante y nutritivo yusiria entro 2:00\r\n23/dic/14 promocion global antiedad con amp. desincrustante, lifting # 2 mirena entro 2:45\r\n25/marzo/15 promocion tratamiento anti-edad carmen entro 2.30\r\nOJO:::USAR CREMA CON DESTELLOS PARA MASAJE EN MANOS \r\n21/abril/15 promocion tratamiento de porcelana con amp. desincrustante lucy entro 2:15\r\n23/oct/15 promocion reafirmante y liftin #2 reyna entro 2:30\r\n17/dic/15 promocion reafirmante modeladora mariana entro 2:30\r\n5/abril/16 promocion trata luxury y lifting #2 lucy entro 12.00\r\n17/junio/16 promocion de elastine con amp. desincrustante mariana entro 2:30\r\n17/nov/16 promocion oxigenante mirena entro 2:20\r\n12/ene/17 promocion desintoxicante mariana entro 2:00\r\n2/mayo/17 promocion antiedad con liftign con amp. desincrustante lucy entro 1:00\r\n20/julio/17 promocion trat relajante hidratante con amp. desoncrustantelucy/susy entro 1:20\r\n4/dic/17 promocion trat gold con amp. desincrustante mary lazaro entro 1:00\r\n1/FEB/18 PROMOCIÓN MULTIVITAMÍNICO CON AMP. DESINCRUSTANTE CARMEN ENTRO 3:00\r\n12/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD CHARITO ENTRO 9:25\r\n26/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL CON AMP DESINCRUSTANTE ANITA\r\n20/DIC/18 PROMOCION DIAMANTE CON AMP. DESINCRUSTANTE LUPITA ENTRO 12:50\r\n21/JUNIO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO ANTIEDAD CON AMP DESINCRUSTANTE CARMEN ENTRO 5:40\r\n15/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA CON AMP DESINCRUSTANTE  CARMEN ENTRO 11:25\r\n11/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS CON AMP DESINCRUSTANTE REYNA ENTRO 1:40\r\n27/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K CON AMP DESINCRUSTANTE Y LIFTING NUM II SANDY ENTRO 1:45\r\n23/ENERO/20 PROMOCION TRAT DESINTOXICANTE MARIANA ENTRO 1:45 LLEVO REAFIRMANTE DE OJOS Y LABIOS ESSENTIAL SHOCK NATURA BISSE\r\n5/AGOSTO/2021 PROM. TRATAMIENTO FACIAL ORGANICO REVITALIZANTE CON AMP. DESINCRUSTANTE  JOHANY\r\n14/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE CON AMP. DESINVRUSTANTE OFELIA ENTRO 1:50\r\n08/JULIO/2022 LIMPIEZA FACIAL PROFUNDA  ROSITA  ENTRO 11:00  MEGA\r\n19/SEPT/2022 PROMOCION TRAT. PREVENTIVO DE MANCHAS CON AMP. DESINCRUSTANTE JHOANY ENTRO 12:45\r\n14/NOVIEMBRE/2022 PROMO TRATAMIENTO FACIAL REPARACION CELULAR CON AMP. DESINCRUSTANTE JHOANY ENTRO 1:10\r\n15/FEBRERO/2023 PROMO TRATAMIENTO FACIAL ELIXIR JUVENTUD  CON AMP DESINCRUSTANTE JHOANY ENTRO 2:45\r\n277ABRIL/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE ENTRO 1:00 ROSY (MEGA)\r\n2/JUNIO/2023 PROMO TRATAMIENTO FACIAL ULTRASOUND  CON AMP. DESINCRUSTANTE  KARLA ENTRO 1:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-02 14:50:15', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('721', 'C-100721', '', 'LUPITA VAZQUEZ GOMEZ', '9933115626', '', '22/JULIO/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 MIRENA ENTRO 4:40\r\n3/MAYO/2023 MASAJE DUO KARLA ENTRO 5:50\r\n17/MAYO/2023 PROMOCION TRAT. FACIAL MAGIC FACE JHOANY ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-17 12:39:21', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('722', 'C-100722', '', 'AIDE RABELO GALAN', '9933591140', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('723', 'C-100723', '', 'IRMA MARQUEZ CARDENAS', '9371234816', '', '19/marzo/16 mdm full relax andrea entro 6:55 (mega)\r\n12-04-16 se realizo drenaje linfatico candy cristal 6pm\r\n17/abril/16 mdm drenaje linfatico andrea entro 7:05 (mega)\r\n22-04-16 se realizo sensorelax cristal martha 5pm', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('724', 'C-100724', '', 'ILDA DEL CARMEN  RODRIGUEZ ROMERO', '9141001697', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('725', 'C-100725', '', 'DULCE MARIA CORTES GRACI', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('726', 'C-100726', '', 'VALERIA FERNANDEZ DE LARA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('727', 'C-100727', '', 'RAFAEL HERNANDEZ HERRERA', '9932541062', '', '05/marzo/17 limpieza facial 2x600 lizbeth entro 6:10 (mega)\r\n16/marzo/17 limpieza facial y masaje express rosy entro 11:30 (mega)\r\n20/septiembre/18 limpieza facial 2x600 rosy entro 12:55 (mega) quizo el facial en 15 minutos por que no tenia tiempo, se le aplico mac. de sabila, azuleno, porcelana, elastine y regenerante pero todas le ardieron, se le termino con gel de colageno y no quiso masaje de espalda.\r\n11/JUNIO/19 LIMPIEZA FACIAL 2 X 600 ROSI ENTRO 4:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('728', 'C-100728', '', 'GLADYS PALACIOS AGUILAR', '9321207397', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('729', 'C-100729', '', 'ALLY DE JESUS CHAN LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('730', 'C-100730', '', 'LUISA ISELA AVALOS RAMON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('731', 'C-100731', '', 'IRMA QUINTANA FERNANDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('732', 'C-100732', '', 'MANUEL MENDOZA GOMEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('733', 'C-100733', '', 'OLGA HIDALGO DE OCHOA', '9931885856', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('734', 'C-100734', '', 'JANETH OVANDO BOCANEGRA', '', '', '5-10-15 SE REALIZO LIMP FACIAL SUSSY CRISTAL 5PM\r\n09/marzo/17 limpieza facial rosy entro 6:00 (mega)\r\n03/marzo/18 limpieza facial 2x600 susy entro 1:00 (mega)\r\n09/agosto/18 limpieza facial rosy entro 6:00 (mega)\r\n04/enero/18 limpieza facial 2x600 susy entro 12:05 (mega\r\n25/abril/19 limpieza facial rosy entro 3.10 mega)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('735', 'C-100735', '', 'DULCE ELENA PUGA ', '9982148875', '', '11/SEPTIEMBRE/2020 MASAJE FULL RELAX OFELIA ENTRO 1:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('736', 'C-100736', '', 'LUPITA GRANADO MEDINA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('737', 'C-100737', '', 'GUADALUPE PEREZ DE MADERA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('738', 'C-100738', '', 'TERESA LOPEZ CRUZ', '9931908788', '', '10/abril/17 mdm full relax candy entro 4:10 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('739', 'C-100739', '', 'PAULINA CHUC HERNANDEZ', '9933432857', '', '30-09-15 SE REALIZ LIMP FACIAL 2X1 ENTRO 7 PM CRISTAL\r\n22-12-15 SE REALIZO LIMP FACIAL CRISTAL MARTHA 1PM\r\n07-07-16 se realizo l-f candy cristal 11:00\r\n23/junio/17 limpieza facial  candy entro 2:15 (mega)\r\n10/julio/17 limpieza facial charito entro 9:55 (mega)\r\n15/agosto/17 limpieza facial 2x600 rosy entro 10:10 (mega)\r\n23/agosto/17 limpieza facial andrea entro 7:20 (mega)\r\n07/abril/18 limpieza facial 2x600 monica entro 11:05 (mega)\r\n22/junio/18 limpieza de acne monica entro 1:00 (mega)\r\n4/NOVIEMBRE/2020 LIMPIEZA FACIASL 2X600 ROSITA ENTRO 4.55 MEGA\r\n04/AGOSTO/2021 LIMPIEZA FACIAL 2X600 MONICA ENTRO 11:00 MEGA\r\n07/JUNIO/2022 LIMPIEZA FACIAL 2X600 MONICA ENTRO 15:57 MEGA\r\n5/JULIO/2023 LIMPIEZA FACIAL PROFUNDA MONI ENTRO 3:58 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-05 17:02:56', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('740', 'C-100740', '', 'YURIDIA HERNANDEZ HERRERA', '', '', '22-09-15 se realizo l-f entro 7-15 eva cristal\r\n23-03-16 SE REALIZO LIMP FACIAL CRISTAL SUSSY  4PM\r\n08-08-16 se realizo l-f  profunda cristal rosy 5-20\r\n16/agosto/17 limpieza facial 2x600 candy entro 7:20 (mega) se le puso mascarilla de so- delicate por que lleva un tratamiento que es a base de acido.\r\n15/julio/18 limpieza facial 2x600 candy entro 3:05 (mega)\r\n24/FEBRERO/2020 LIMPIEZA FACIAL BASICA MONI ENTRO 7:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('741', 'C-100741', '', 'SILVERIO SOSA GARCIA', '9331281090', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('742', 'C-100742', '', 'EMELY LOPEZ LOPEZ', '9191177351', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('743', 'C-100743', '', 'ANA MARIA COBOS MARTINEZ', '9932645225', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('744', 'C-100744', '', 'JAVIER ARANDA  SANCHEZ', '9931654560', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('745', 'C-100745', '', 'EDILA ESCALANTE CABRERA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('746', 'C-100746', '', 'LORENA CARBALLO CAPDEPOT', '9931650707', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('747', 'C-100747', '', 'YARENNY ORTEGA CORZO', '9931114353', '', '2/ene/17 limpieza de acne ofelia entro 9:40\r\n27/FEB/18 LIMPIEZA FACIAL OFELIA ENTRO 1:10\r\n27/FEB/18 INICIA DEP LASER DE BIGOTE, MENTÓN, PATILLA, 30 MS 12J \r\n LINEA DE ABDOMEN AUT 12J OFE ENTRO 2:30\r\n14/MARZO/18 LIMPIEZA FACIAL OFELIA ENTRO 10:45\r\n6/ABRIL/18 2.-D LASER DE BIGOTE, MENTÓN, PATILLA 30MS 10J L ABDOMEN 12J OFELIA\r\n15/MAYO/18 BIGOTE, MENTÓN, PATILLA, LINEA DE ABDOMEN AUT 15 J OFELIA\r\n15/MAYO/18 LIMPIEZA FACIAL OFELIA\r\n27/JUNIO/18 BIGOTE, MENTÓN AUT 17 LD ABDOMEN AUT 18 J OFE\r\n17/AGOSTO/18 LIMPIEZA FACIAL OFELIA\r\n17/AGOSTO/18 LASER DE BIGOTE, MENTÓN, PATILLA AUT 18J Y LINEA DE ABDOMEN AUT 20 J OFELIA\r\n10/SEPT/18 LIMPIEZA FACIAL MARY LAZARO ENTRO 6:00\r\n5/OCT/18  LIMPIEZA FACIAL OFELIA\r\n5/OCT/18 LASER  DE BIGOTE, MENTÓN, PATILLA AUT 19J LÍNEA DE ABDOMEN AUT 22J OFELIA\r\n19/NOV/18 LIMPIEZA FACIAL OFELIA ENTRO 2:30\r\n19/NOV/18 LASER DE BIGOTE, MENTÓN, PATILLA, AUT 20 J Y LÍNEA DE ABDOMEN AUT 24 J OFELIA\r\n14/DIC/18 LIMPIEZA DE ACNE KARLA ENTRO 2:25\r\n14/DIC/18 LASER DE BIGOTE, MENTÓN, PATILLA AUT 21 J LINEA DE ABDOMEN AUT 25 J OFELIA\r\n2/FEB/19 LIMPIEZA FACIAL OFELIA ENTRO 12:00\r\n2/FEB/19 LASER DE BIGOTE, MENTÓN, PATILLA AUT 18J Y LINEA DE ABDOMEN AUT 25 J OFELIA\r\n14/FEB/19 MASAJE FULL RELAX MONICA ENTRO 5:45\r\n6/ABRIL/19 LIMPIEZA FACIAL OFELIA ENTRO 11:55\r\n24/ABRIL/19 MDM DESCONTRACTURANTE MONICA ENTRO 9:20\r\n24/ABRIL/19 LASER DE BIGOTE, MENTON, PATILLA AUT 18J LINEA DE ABDOMEN AUT 26 J OFELIA\r\n25/MAYO/19 LIMPIEZA FACIAL OFELIA\r\n27/MAYO/19 11° BIGOTE, MENTON, PATILLA AUTOM. 20 J, LINEA DE ABDOMEN AUTOM. 26 J OFELIA ENTRO 3:00\r\n15/JULIO/19 LIMPIEZA FACIAL LUPITA ENTRO 9:25\r\n29/JULIO/19 LIMPIEZA FACIAL OFELIA ENTRO 3:00\r\n29/JULIO/19 12° BIGOTE, MENTON, PATILLA, AUTOM. 20 J, LINEA ABDOMEN AUTOM. 26 J OFELIA\r\n29/JULIO/19 LASER DE BIGOTE, MENTON, PATILLA AUT 20 J L DE ABDOMEN AUT 26J OFELIA\r\n19/OCTUBRE/19 LIMPIEZA FACIAL OFELIA ENTRO 12:15\r\n14/DICIEMBRE/19 LIMPIEZA FACIAL OFELIA ENTRO 8:00\r\n11/ENERO/20 MDM FULL RELAX OFELIA ENTRO 8:00\r\n18/ENERO/20 LIMPIEZA FACIAL OFELIA ENTRO 8:00\r\n8/FEB/2020 LIMPIEZA FACIAL OFELIA ENTRO 8:00\r\n21/MARZO/20 LIMPIEZA DE ACNE OFELIA\r\n29/MAYO/2020 LIMPIEZA DE ACNE OFELIA \r\n12/JUNIO/2020 LIMPIEZA DE ACNE OFELIA ENTRO 11:00\r\n17/JULIO/2020 LIMPIEZA DE ACNE OFELIA ENTRO 11:55\r\n16/OCT/2020 LIMPIEZA DE ACNE OFELIA ENTRO 1:00\r\n25/NOV/2020 LIMPIEZA DE ACNE OFELIA ENTRO 6:00 LLEVO LOCION BIOCONTROL\r\n5/DIC/2020 LIMPIEZA DE ACNE OFELIA ENTRO 9:00\r\n15/FEB/2021 LIMPIEZA DE ACNE  OFELIA ENTRO 12:00\r\n24/FEB/2021  LIMPIEZA FACIAL  OFELIA ENTRO 2:00\r\n15/MARZO/2021 LIMPIEZA FACIAL OFELIA ENTRO 10:40\r\nLLEVIO LOCION BIO-CONTROL\r\n1/MAYO/2021 LIMPIEZA FACIAL OFELIA ENTRO 10:05 LLEVO ESPUMA EXFOLIANTE LIMPIADORA FACIAL EXCEL THERAPY O2, LOCION PURIFICANTE EQUILIBRANTE PIEL GRASA, SERUM HYALURONIC AINHOA, HELIOCARE 360, CREMA HIDRATANTE NO ESTRES PUREXPERT\r\n8/MAYO/2021 MASAJE GEOTERMAL MARIANA ENTRO 2:00\r\n5/JUNIO/2021 LIMPIEZA FACIAL OFELIA ENTRO 7:55\r\n31/JULIO/2021 LIMPIEZA FACIAL BASICA  OFELIA ENTRO 7:55\r\n17/AGOSTO/2021 LIMPIEZA FACIAL PROFUNDA CON AMPOLLETA DESINCRUSTANTE OFELIA ENTRO 4:00 \r\n11/SEPT/2021 LIMPIEZA FACIAL CON AMP DESINRUSTANTE OFELIA EN TRO 2:05\r\n9/OCT/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ARLETH ENTRO 7:50\r\n23/OCT/2021 LIMPIEZA FACIAL BASICA OFELIA ENTRO 8:00 \r\n15/NOVIEMBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE OFELIA ENTRO 11:35\r\n15/NOV/2021 MASAJE FULL RELAX 2X600 ROSI ENTRO 18:50 MEGA\r\n8/DIC/2021 LIMPIEZA FACIAL OFELIA ENTRO 9:50\r\n3/ENERO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE OFELIA ENTRO 9:00\r\n22/ENERO/2022 LIMPIEZA FACIAL OFELIA ENTRO 7:50 LLEVO LOCION BIOCONTROL\r\n19/FEB/2022 LIMPIEZA DE ACNE OFELIA ENTRO 8:00\r\n9/ABRIL/2022 LIMPIEZA DE ACNE OFELIA ENTRO 8:00\r\n21/MAYO/2022 LIMPIEZA DE ACNE OFELIA ENTRO 8:40\r\n4/JUNIO/2022 LIMPIEZA DE ACNE  OFELIA ENTRO 7:50\r\n2/JULIO/2022 LIMPIEZA FACIAL BASICA OFELIA ENTRO 7:55 \r\n6/AGOSTO/2022 LIMPIEZA FACIAL OFELIA ENTRO 8:00\r\n24/SEPTIEMBRE/2022 LIMPIEZA DE ACNE OFELIA ENTRO 7:55\r\n8/OCTUBRE/2022 LIMPIEZA FACIAL OFELIA ENTRO 8:00\r\n5/NOVIEMBRE/2022 LIMPIEZA FACIAL OFELIA ENTRO 7:50\r\n26/NOVIEMBRE/2022 LIMPIEZA FACIAL OFELIA ENTRO 7:50\r\n* LLEVO CONTORNO DE OJOS DE EXCEL THERAPY\r\n* CREMA HYDRACURE PIELES NORMALES A MIXTAS\r\n* LOCION PURIFICANTE EQUILIBRANTE\r\n* HELIOCARE 360ª\r\n* SERUM HYDRACURE\r\n* ESPUMA DE EXCEL THERAPY\r\n8/DICIEMBRE/2022 MASAJE DRENAJE LINFATICO OFELIA ENTRO 11:10\r\n21/DICIEMBRE/2022 LIMPIEZA FACIAL OFELIA ENTRO 9:00\r\n7/ENERO/2023 LIMPIEZA FACIAL OFELIA ENTRO 12:20\r\n31/ENERO/2023 LIMPIEZA FACIAL OFELIA ENTRO 3:40\r\n4/MARZO/2023 LIMPIEZA FACIAL OFELIA ENTRO 7:55\r\n30/MARZO/2023 LIMPIEZA FACIAL OFELIA ENTRO 3:15\r\n22/ABRIL/2023 LIMPIEZA DE ACNE OFELIA ENTRO 8:50\r\n29/ABRIL/2023 LIMPIEZA FACIAL OFELIA ENTRO 8:05\r\n1/JULIO/2023 LIMPIEZA FACIAL OFELIA ENTRO 10:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-01 12:06:13', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('748', 'C-100748', '', 'JESSICA M GARCIA ROSALES', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('749', 'C-100749', '', 'EMILIA MANUELES MONTEJO', '9371265651', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('750', 'C-100750', '', 'GABRIELA RAMIREZ MARTINEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('751', 'C-100751', '', 'ANIE MICHELLE HERNANDEZ CARRILLO', '9321058709', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('752', 'C-100752', '', 'GABY BONFIL TORRES', '9933112213', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('753', 'C-100753', '', 'JUAN PABLO ANDRADE RUIZ', '9931959038', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('754', 'C-100754', '', 'RAQUEL CRUZ TORRES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('755', 'C-100755', '', 'PILAR OVANDO MAZA', '9933590226', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('756', 'C-100756', '', 'CESAR MENDO SANCHEZ', '9931994367', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('757', 'C-100757', '', 'JESUS MENDO SANCHEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('758', 'C-100758', '', 'MARIO MADERA ESTRADA', '9931269633', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('759', 'C-100759', '', 'ROCIO SANTOS MARQUEZ', '9932073520', '', '11/05/01 ginseng consuelo\r\n18/09/06 completo bety entro 10:05\r\n16/oct/06 go-expression ofelia entro 9:25\r\n24/oct/06 go-expression gladys entro 9:10\r\n31/oct/06 reflexologia podal bety entro 10:45\r\n13/dic/06 promocion navideña trat. nutritivo e hidratante gladys entro 9:50 salio 11:30\r\n23/feb/07 timexpert, lifting de parafina bety entro 10:00\r\n11/junio/07 promocion de cristal ofelia entro 9:00\r\n06/julio/07 promocion colageno gladys entro 2:15\r\n28/agosto/07 promocion regenerador antioxidante mary entro 10:05\r\n24/sept/07 promocion colageno lucy entro 9:20\r\n14/dic/07 mesoterapia facial rosy\r\n21/dic/07 mesoterapia facial rosy entro 10:35\r\n26/dic/07 mesoterapia facial ofelia entro 11:00\r\n3/ene/08 mesoterapia facial rosy entro 11:45 \r\n22/ene/08 seda y perla lucy entro 9:00 \r\n12/feb/08 rpomocion dermorelax odet entro 8:30 \r\n31/marzo/08 promocion criogenico mary entro 8:15 \r\n18/julio/08 promocion termico reyna entro 2:15 \r\n9/agosto/08 promocion regenerador antioxidante mary lazaro entro 10:15 \r\n10/sept/08 promocion modeladora, lifting de parafina odet entro 9:45 \r\n18/sept/08 limpieza de acne gladys entro 2:15 \r\n14/oct/08 promocion colageno lucy entro 8:15 \r\n22/dic/08 promocion vitamina c sara entro 3:55 salio 5:30\r\n17/ene/09 promocion jalea real y lifting de parpados de parafina lucy entro 8:20 \r\n5/marzo/09 promocion spa therapy perla gladys entro 8:30 \r\n3/abril/09 promocion spa therapy oro gladys entro 8:40 salio 10:30\r\n3/abril/09 trat. pies bety entro 8:40 \r\n13/abril/09 promocion spa therapy oro mary entro 3:45 \r\nno le gusta que la atienda sara, porque la ultima vez no le hizo bien la extraccion y \r\nla dejo marcada.\r\n19/mayo/09 promocion intensivo parpados y labios mary entro 9:45 \r\n9/julio/09 promocion extraperformance lucy entro 4:15 \r\n21/julio/09 promocion extraperformance araceli entro 3:05 \r\n17/agosto/09 promocion revitalizante bety entro 9:15 \r\n8/sept/09 vitamina c ofe entro 11:00\r\n19/nov/09 promocion reestructurante lucy entro 12:10\r\n15/dic/09 infinitime gladys entro 1:00\r\n19/ene/10 promocion vinoterapia, lifting de parafina ofe entro 1:00\r\n27/ene/10 promocion vinoterapia, lifting de parafina ofe entro 9:35\r\n23/feb/10 promocion estimulante de endorfinas ofe entro 11:00\r\n3/marzo/10 promocion de cristal ofe entro 11:45\r\n6/julio/10 promocion relajante e hidratante gladys entro 2:05\r\n3/agosto/10 promocion trat antiedad karina entro 3:00\r\n1/sept/10 promocion termico lucy entro 6:10  \r\n24/sept/10 promocion termico araceli entro 11:30 \r\n21/oct/10 promocion efecto botox, lifting go-expressions araceli entro 11:30\r\n\r\n21/feb/11 mdm full relax ofelia entro 9:20\r\n21/feb/11 promocion trat. de seda, lifting 02 susy entro 10:45 \r\n21/feb/11 reflexologia podal reyna \r\n9/mayo/11 mdm drenaje linfatico, promocion botanico karina entro 10:35\r\n25/mayo/11 mdm drenaje linfatico araceli entro 10:30\r\n28/sep/11 mdm y radio frecuencia y dejo pagado una promocion azteca 550.00\r\n03/oct/11 radio frecuencia y mdmd rena entro 3:45 \r\n13/oct/11 masaje de aromas y promocion relajante mariana entro 11:00\r\n20/oct/11 masaje de aromas aracely vainilla entro 11:05\r\n31/oct/11 promocion relajante, masaje aromas, dep. pierna, bigote, cejas aracely\r\n09/nov/11 promocion germen de trigo y masaje aromas aracely entro 11:40\r\n17/nov/11 masaje aromas, promocion germen de trigo y vitamina e araceli entro 9:35\r\n25/nov/11 masaje de aromas karina entro 12:50\r\n1/dic/11 masaje de aromas, promocion velo de colageno araceli entro 9:35\r\n17/ene/12 masaje de aromas, promocion revitalizante, lifting # 2, depilacion de cejas y\r\n bigote gladys entro 9:20\r\n8/feb/12 promocion 3 geles ofe entro 9:20\r\n6/marzo/12 rll sng juved up 5 m, rll apm voluma 0.5 ml 5 m, btx 48 u 5 m dr. oscar\r\n2/julio/12 mdm holistico, promocion hidratante de arroz reyna entro 10:05\r\n14/nov/12 mdm aromas mariana entro 11:30\r\n9/feb/13 promocion catiodermia mariana entro 9:00\r\n11/feb/13 mdm aromas ofelia entro 11:10\r\n22/feb/13 mdm aromas, promocion catiodermia lucy entro 10:10\r\n7/marzo/13 mdm combo lucy entro 10:50\r\n26/marzo/13 mdm aromas mariana entro 5:20\r\n8/abril/13 hydracure reyna entro 11:00\r\n15/abril/13 mdm drenaje linfatico gladys entro 8:35\r\n23/abril/13 botox, relleno dr. oscar\r\n16/mayo/13 mdm aromas, promocion relajante e hidratante mariana entro 10:30\r\n12/junio/13 promocion coco y mango ana entro 9:45\r\n22/julio/13 mdm aromas, promocion colageno y elastina reyna entro 9:00\r\n2/sept/13 promocion lifting antiarrugas yusiria entro 10:00\r\n27/sep/13 promocion lifting md de aromas dep bigote y cejas mariana entro 9:18.\r\n27/sept/13 radiofrecuencia mariana\r\n7/oct/13 mdm de aromas reyna \r\n24/oct/13  rsng  5.0   juvederm upx, relle tpm 5.0, txb 5.0\r\n31/oct/13 mdm aromas, promocion the verde reyna entro 10:15\r\n14/nov/13 mdm aromas, promocion intensivo anti estres mariana entro 1:00\r\n12/abril/14 limpieza de acne mariana entro 9:30\r\n3/febrero/15 limpieza de acne mariana entro 5:05\r\n21/abril/15 botox 1/3 sup. platisma $10,00.00  dr, oscar garcía\r\n27/abril/15 facial hydracure lucy entro 11:05\r\n5/mayo/15 mdm aromatico y desafio antiedad reyna entro 9.10\r\n14/mayo/15 mdm aromatico facial de vitamina c nb mariana entro 9:05\r\n21/mayo/15 mdm aromatico y facial timexpert rides mariana entro 8:50\r\n14/sept/15 mdm aromatico y promocion equilibrante del ph reyna entro 9:20\r\n6/oct/15 promocion reafirmante mary lazaro entro 9:00\r\n29/oct/15 botox 1/3 sup $10000.00 dr. oscar garcia\r\n4/nov/15 masaje aromatico y promocion humectante y nutritiva lucy entro 9:15\r\n28/ene/16 mdm aromatico y promocion desintoxicante fernanda entro 9:25\r\n19/abril/16 bp pomulo sup $8000.00l, txb 1/3 sup y plastima $12000.00 dr. oscar garcia\r\n25/oct/16 rell volume 1ml $8000.00 y txb 1/3 sup y platisma $12000.00 dr. oscar garcia\r\n16/MAYO/17 BOTOX DR. OSCAR\r\n25/agosto/17 masaje de aromas y promocion desvanece las lineas del tiempo lizvet entro 10:20\r\n28/nov/17 botox cara y cuello, relleno dr. oscar\r\n17/ABRIL/18  TXB SUP BOTOX  7,000 DOCTOR OSCAR', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('760', 'C-100760', '', 'DAYANARA GUTIERREZ CONTRERAS', '9931302228', '', '17/MARZO/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 MARIANA ENTRO 4:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('761', 'C-100761', '', 'YAMILE MENA OROPEZA', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('762', 'C-100762', '', 'CECILIA DE LOS ANGELES TORRES MORALES', '9931605468', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('763', 'C-100763', '', 'WENDY CASTILLO CORNELIO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('764', 'C-100764', '', 'JOSE MARCO RODRIGUEZ MU', '9931485964', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('765', 'C-100765', '', 'GUADALUPE JIMENEZ JUAREZ', '9931679178', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('766', 'C-100766', '', 'PATRICIA ARBOLEYA PASTRANA', '9935904692', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('767', 'C-100767', '', 'GUADALUPE VASQUEZ MORALES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('768', 'C-100768', '', 'SARAID RACHO JACOME', '17441004834', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('769', 'C-100769', '', 'ANA GUTIERREZ HERNANDEZ', '9931306645', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('770', 'C-100770', '', 'YOLANDA GRANIEL DE MAGA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('771', 'C-100771', '', 'DULCE GALLAN', '9933591319', '', '23/marzo/16 promocion hydrtante y dep de cejas ofelia entro 12.25\r\n14/AGOSTO/19 MASAJE DESCONTRACTURANTE LUPITA ENTRO 4:20', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('772', 'C-100772', '', 'LOLY HERNANDEZ HERNANDEZ', '9932299361', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('773', 'C-100773', '', 'JOSE ALEJANDRO HERNANDEZ LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('774', 'C-100774', '', 'MARIA ELIZABETH AQUINO SOLIS', '9931563080', '', '28-12-15 SE REALIZO LIMP FACIAL CRISTAL SUSSY  3-10\r\n8/abril/16 limpieza facial con amp. desincrustante carmen entro 4:10\r\n16-05-16 se realizo l-f cristal doña rosy 4:00\r\n30/nov/16 limpieza facial cn amp. desincrustante reyna entro 3:10\r\n11/mayo/17 limpieza facial con amp. desincrustante charito entro 3:15\r\n17/nov/17 limpieza facial con amp. desincrustante anita entro 11:20\r\n18/01/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARIANA ENTRO 2:40\r\n10/MAYO/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARY ENTRO 2:30\r\n8/NOV/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MONICA-KARLA ENTRO 4:05\r\n6/JUNIO/19 PROM TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO MARY ENTRO 8:10\r\n21/NOV/19 LIMPIEZA FACIAL ANITA ENTRO 10:50\r\n6/AGOSTO/2020 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ANITA ENTRO 9:00\r\n2/DICIEMBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE JOHANY ENTRO 10:50\r\n12/MAYO/2022 LIMPIEZA FACIAL CON AMP. HIALURONICO MARY LAZARO ENTRO 10:00\r\n16/JUNIO/2022 LIMPIEZA FACIAL CON AMP. STABILIZING DE NATURA BISSE LUCY ENTRO 9:05\r\n24/OCTUBRE/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA MARIANA ENTRO 12:00\r\n8/DCIEMBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 8:50\r\n14/DICIEMBRE/2022 DELINEADO DE CEJAS  Y LINEA LUMINOSAA  OFELIA ENTRO 12:10\r\n28/DICIEMBRE/2022 RETOQUE DE CEJAS Y LINEA LUMINOSA OFELIA ENTRO 10:00\r\n17/FEBRERO/2023 PROMO TRATAMIENTO FACIAL ELIXIR JUVENTUD MARIANA ENTRO 8:50\r\n31/MARZO/2023 PROMOCION DEL MES TRATAMIENTO MICRO-DERMA ANTIEDAD FERNANDA ENTRO 9:50 \r\n4/MAYO/2023 PROMO TRATAMIENTO FACIAL MAGIC FACE SRA BEGO\r\n15/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND KARLA ENTRO 9:45', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-15 10:53:21', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('775', 'C-100775', '', 'NAINA LOPEZ MISS', '9931591825', '', '17/abril/16 microdermoabrasion susy entro 3:10 (mega)\r\n08/mayo/16 microdermoabrasion susy entro 1:15 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('776', 'C-100776', '', 'CLAUDIA PERALTA AGUILAR', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('777', 'C-100777', '', 'FRANCISCA LOPEZ NARVAEZ', '9931039132', '', '', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('778', 'C-100778', '', 'LUIS ALBERTO HERRERA LOPEZ', '9931039132', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('779', 'C-100779', '', 'ALEJANDRA HERNANDEZ LOPEZ', '', '', '', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('780', 'C-100780', '', 'HILDA GONZALEZ GUTIERREZ', '9932074768', '', '4/dic/15 promocion reafirmante modeladora  reyna entro 4:10\r\n21/nov/16 promocion oxigenante charito entro 3:55\r\n27/dic/16 promocion trat multivitaminico andrea entro 5:20\r\n7/abril/17 promocion termico charito entro 11:00\r\n3/junio/17 promocion antioxidante mary L entro 12:00\r\n23/oct/17 promocion reafirmante lucy entro 10:35\r\n28/12/17 PROMOCIÓN TRATAMIENTO GOLD OFELIA ENTRO 9:10\r\n10/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA  ANITA ENTRO 12:00\r\n25/JUNIO/18  CAPSULA   LUCY ENTRO 5:00\r\n27/JUNIO/18 CAPSULA Y PROM TRATAMIENTO FACIAL ANTIOXIDANTE ANITA\r\n29/JUNIO/18 CAPSULA   LUCY ENTRO 5:05\r\n2/JULIO/18 CORPO LUCY ENTRO 4:55\r\n3/JULIO/18 CORPO REYNA ENTRO 4:55\r\n4/JULIO/18 CORPO ANITA ENTRO 5:00\r\n5/JULIO/18 VENDAS FRIAS LUCY ENTRO 5:00\r\n19/SEP/18 PROM TRATAMIENTO REGENERANTE REYNA ENTRO 11:20\r\n12/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE LUCY ENTRO 9:40\r\n20/FEBRERO/19 PROM TRATAMIENTO FACIAL REAFIRMANTE LUPITA\r\n11/MARZO/19 MDM FULL RELAX OFELIA ENTRO 12:15\r\n13/MARZO/19 PROM TRATAMIENTO FACIAL DETOX BETTY ENTRO 1:50\r\n25/JULIO/19 TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO MARY LAZARO ENTRO 5:00\r\n13/MARZO/2020 PROMOCION TRAT RECUPERADOR FACIAL LUPITA ENTRO 11:10\r\n4/ENERO/2021 PROMOCION TRAT ANTIPOLUCION MONICA ENTRO 9:10\r\n16/FEB/2021 PROM. TRATAMIENTO FACIAL PEEL OFF MONICA ENTRO 12:00\r\n2/OCTUBRE/2021 PEOM. TRATAMIENTO FACIAL ORGANICO CBD LUCY ENTRO 8:00\r\n28/OCTUBRE/2021 FACIAL VITAMINA C RADIANCE Y DEPILACION DE CEJAS MARIANA ENTRO 3:00\r\n21/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE MIRENA ENTRO 2:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('781', 'C-100781', '', 'ZOILA GUTIERREZ VAZQUEZ', '', '', '14/nov/15 promocion reafirmante graciela entro 10:20\r\n7/abril/17 mdm full relax, promocion térmico yennifer entro 11:00\r\n29/mayo/17 mdm geotermal, promocion antiedad con lifting charito entro 4:25\r\n26/12/17 MDM FULL RELAX MARY ENTRO 5:00\r\n31/ENERO/18 MDM FULL RELAX, PROMOCION OXIGENANTE CON ULTRASONIDO REYNA ENTRO 11:25\r\n3/ENE/18 PROM TRATAMIENTO FACIAL REVITALIZANTE OFELIA ENTRO 11:00\r\n21/FEB/19 MDM FULL RELAX, PROMOCION REAFIRMANTE MONICA ENTRO 10:00\r\n13/MARZO/19 MDM FULL RELAX  Y PROM TRATAMIENTO FACIAL DETOX  ANITA ENTRO 1:50\r\n16/ABRIL/19 MDM  TE VERDE Y PROM TRATAMIENTO FACIAL HUMECTANTE MONICA ENTRO 10:10\r\n15/ABRIL/2021 TRATAMIENTO FACIAL VITAMINA C GERMAINE (HYDRACURE) Y MASAJE FULL RELAX  MARIANA ENTRO 12:00\r\n17/ENERO/2022 PROMOCION TRAT. DETOX MARIANA ENTRO 9:00 (VALE DE REGALO DE LIMPIEZA FACIAL PROFUNDA, PAGO DIFERENCIA PARA LA PROMOCION DEL MES)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('782', 'C-100782', '', 'YOLANDA SALINAS FERNANDEZ', '9931433803', '', '06/septiembre/16 limpieza facial 2x500 rosy entro 4:00 (mega)\r\nDEPILACION LASER DE PANTORRILLA $750.00 C/S BIGOTE $180.00 C/S AXILA $360.00 C/S BRASILEÑA TOTAL $650.00 C/S\r\n6/oct/16 1ra. pantorrilla, bigote, axila, bikini autom. 12 j reyna\r\n4/nov/16 2da. pantorrilla aut-14 j, bigote aut-14 j, bikini/total aut-12j lucy\r\n3/dic/16 pantorrilla aut-16j, bigote aut-16j axila aut-16j, bikini aut-14j ofelia\r\n12/ene/17 pantorrilla aut-18j, bigote aut-16j, axila aut-17j bikini total aut-14j mary lazaro\r\n13/feb/17 pantorrilla aut-20j, axila aut-18j, bikini /Total aut-18j lucy\r\n16/marzo/17 pantorrilla aut-19, axila aut-18j, bikini/total aut-18j, bigote aut-16j mary lazar\r\n25/abril/17 6ta. pantorrilla aut-19, axila aut-18j, bikini/total aut-18j, bigote aut-16 j lucy\r\n25/mayo/17 7ta. pantorrilla, axila, brasileña total, bigote autom. 20 j lucy\r\n11/julio/17 9° pantorrilla, axila y bigote aut 20 j bikini aut-22j lucy\r\n11/agoto/17 pantorrilla, axila, bikini aut-23j, bigote aut-20j lucy\r\n10/agosto/17 masaje de cliente frecuente charito entro 7:00 (mega)\r\n5/oct/17 11° pantorrilla, axila, bikini autom. 23 j, bigote autom. 21 j lucy\r\n29/nov/17 12° pantorrilla, axila, bikini, autom. 20 j, bigote autom. 21 j mary lazaro\r\n09/FEB/18 PANTORRILLA AUT 21, AXILA, BIKINI AUT 20 BIGOTE AUT 20J REYNA  ENTRO 2:50\r\n10/noviembre/18 limpieza facial 2x600 lupita entro 7:05 (mega)\r\n30/JULIO/19 LASER DE BIKINI TOTAL, AUT 22 J AXILA AUT 30 Y BIGOTE AUT 22 J OFELIA\r\n8/OCT/19 RETOQUE BIKINI, AXILA, BIGOTE AUTOM. 22 J MARY LAZARO\r\n30/JULIO/19 LASER DE BIKINI TOTAL, AUT 22 J AXILA AUT 30 Y BIGOTE AUT 22 J OFELIA\r\n8/OCT/19 RETOQUE BIKINI, AXILA, BIGOTE AUTOM. 22 J MARY LAZARO\r\n05/julio/19 promocion del mes tratamiento  de colageno hidrolizado mony entro 7.10 mega\r\n13/sep/19 mdm full relax susy entro 2:45 mega\r\n2/MARZO/20 HYDRAFACIAL  MARY  LAZARO LLEVO BRUMA SOLAR\r\n5/SEPT/2020 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 MARY LAZARO ENTRO 8:05\r\n31/ENERO/2022 LIPOSONIX 4 DISPAROS LUCY ENTRO 9:20\r\n04/FEB/2022 LIFTING NATURA BISSE ROSI ENTRO 13:15 MEGA\r\n9/SEPT/2022 RETOQUE AXILA, BIGOTE, BIKINI ENTRE PIERNAS AUTOM. 21 J LUCY ENTRO 9:20\r\n10/SEPTIEMBRE/2022 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 SUSY ENTRO 10:5  MEGA\r\n20/ENERO/2023 RETOQUE DE BIGOTE, AXILA, BIKINI LUCY ENTRO 9:15\r\n14/JULIO/2023 DUO PERSONAL MASAJE RELAJANTE Y LIMPIEZA FACIAL MONI ENTRO 6:05 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-14 19:09:06', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('783', 'C-100783', '', 'KARLA SELENE REYES DE LA CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('784', 'C-100784', '', 'CECILIA BARRIENTOS NICOLAS', '9933041425', '', '1/nov/16 limpieza facial 2x500 mary lazaro entro 11:50\r\n9/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX LUCY\r\n9/MAYO/19 LLEVO EXCEL THERAPY O2 EMULSION Y HELIOCARE COMPACTO\r\n8/ABRIL/2021 PROMOCION TRAT VIT. C MARIANA ENTRO 1:00\r\n8/ABRIL/2021 DEJO PAGADA LA PROMOCION DE CARBOXITERAPIA $2500.00\r\n28/JUNIO/2021 NOSE REALIZO EL PAQUETE DE CARBOX LO CAMBIO POR PAQUETE DE VENDAS FRIAS DEBE $1,000.00\r\n29/JUNIO/2021 TERMINO DE PAGAR EL TRATAMIENTO REDUCTIVO 1,000.00\r\n1.- VENDAS FRIAS 28/JUNIO/2021 LUCY ENTRO 3:45\r\n2.- VENDAS FRIAS 29/JUNIO/2021 LUCY ENTRO 3:50\r\n3.- VENDAS FRIAS 30/JUNIO/2021 LUCY\r\n4.- VENDAS FRIAS 1/JULIO/2021 LUCY ENTRO 3:50\r\n5.- VENDAS FRIAS 2/JULIO/2021 LUCY ENTRO 3:50\r\n6.- VENDAS FRIAS 5/ULIO/2021 LUCY ENTRO 2:25\r\n7.- VENDAS FRIAS 7/JULIO/2021 LUCY ENTRO 4:10\r\n8.- VENDAS FRIAS 8/JULIO/2021 LUCY ENTRO 4:45\r\n9.- VENDAS FRIAS 9/JULIO/2021 LUCY ENTRO 4:25\r\n10.- VENDAS FRIAS 12/JULIO/2021 LUCY ENTRO 3:15\r\n29/JUNIO/2021 TRATAMIENTO DE CARBOXITERAPIA COSTO 2,500.00 PAGO 1,250.00 DEBE 1250.00\r\n*********28/AGOSTO/2021 TERMINO DE PAGAR SU TRATAMIENTO DE CARBOXITERAPIA 1250.00 PAGADO************************************************\r\n\r\nLLEVO PACK DE VITAMINA DE GERMAINE RADIANS\r\n1.- CARBOX  1/JULIO/2021 LUCY\r\n2.- CARBOX  2/JULIO/2021 LUCY\r\n3.- CARBOX  5/JULIO/2021 LUCY\r\n4.- CARBOX  7/JULIO/2021 LUCY\r\n5.- CARBOX  12/JULIO/2021 LUCY\r\n6.- CARBOX 7/AGOSTO/2021 LUCY ENTRO 2:00\r\n7.- CARBOX  26/AGOSTO/2021 OFELIA ENTRO 3:40\r\n8.- CARBOX  28/AGOSTO/2021 LUCY ENTRO 12:15\r\n9.- CARBOX  13/SEPT/2021 LUCY ENTRO 4:05\r\n10.- CARBOX 15/SEPT/2021 JHOANA ENTRO 4:15 \r\n11.- CARBOX 20/SEPT/2021 LUCY ENTRO 4:35\r\n12.- CARBOX 6/OCTUBRE/2021 LUCY ENTRO 3:30\r\n13.- CARBOX 8/OCT/2021 OFELIA ENTRO 4:40 \r\n14.- CARBOX 12/OCTUBRE/2021 LUCY ENTRO \r\n15.- CARBOX 15/OCTUBRE/2021 LUCY\r\n16.- CARBOX 25/OCTUBRE/2021 LUCY\r\n17.- CARBOX 27/OCTUBRE/2021 LUCY\r\n18.- CARBOX 29/OCTUBRE/2021 LUCY\r\n19.- CARBOX 1/NOVIEMBRE/2021 LUCY\r\n20.- CARBOX 3/NOVIEMBRE/2021 LUICY\r\n3/NOV/2021***********TERMINO TRATAMIENTO DE CARBOX*******************\r\n\r\n*********6/OCTUBRE/2021 INICIA TRATAMIENTO DE VENDAS FRIAS COSTO 3500.00***\r\n\r\n1.- VENDAS FRIAS  6/OCTUBRE/2021 LUCY\r\n2.- VENDAS FRIAS 7/OCT/2021 OFELIA ENTRO 3:30 \r\n3.- VENDAS FRIAS 8/OCT/2021 LUCY ENTRO 4:40 \r\n4.- VENDAS FRIAS  15/OCTUBRE/2021 LUCY\r\n5.- VENDAS FRIAS 25/OCTUBRE/2021 LUCY\r\n6.- VENDAS FRIAS 27/OCTUBRE/2021 LUCY\r\n7.- VENDAS FRIAS 29/OCTUBRE/2021 LUCY\r\n8.- VENDAS FRIAS 1/NOVIEMBRE/2021 LUCY\r\n9.- VENDAS FRIAS 3/NOVIEMBRE/2021 LUCY\r\n10.- VENDAS FRIAS 5/NOVIEMBRE/2021 LUCY\r\n\r\n15/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD LUCY\r\n1/NOVIEMBRE/2021 PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO LUCY\r\n3/NOVIEMBRE/2021 SE LE APLICO UNA AMPOLLETA DE ACIDO HIALURONICO 350.00 LUCY\r\n5/NOVIEMBRE/2021 TERMINO DE PAGAR SU TRATAMIENTO REDUCTIVO 2000.00 Y PAGO UNA AMPOLLETA\r\n8/NOVIEMBRE/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 LUCY ENTRO 9:15\r\n12/NOVIEMBRE/2021LIFTING NUMERO DE DOS CON AMP DE ACIDO HIALURONICO MARY LAZARO ENTRO  142:50\r\n18/NOVIEMBRE/2021 PROM. TRATAMIENTO FACIAL TENSOR DE CUELLO CON AMP ROYAL JELLY LUCY ENTRO 11:40 LLEVO CREMAQ GLOBAL ARRUGAS  RICH TIMEXPERT RIDES\r\n7/ABRIL/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE Y AMP OXIGENANTE JOHANY ENTRO 4:10\r\n14/JULIO/2022 PROMOCION TRAT ROLL & LIFT CON AMP. SERUM NUTRITICO DE GERMAINE CRISTINA ENTRO 12:45\r\n5/AGOSTO/2022 PROMOCION TRAT FACIAL ANTIOXIDANTE CRISTINA ENTRO 1:30\r\n10/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN JHOANY ENTRO 2:35\r\n30/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN OFELIA ENTRO 1:10\r\n6/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE CON AMP. BEAUTE III ARIANA ENTRO 1:05', 'no', 'activo', '2021-12-07 00:49:45', '2023-04-26 19:46:19', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('785', 'C-100785', '', 'AURA MEDINA CANO', '9931607220', '', '21/feb/11 promocion trat. de seda mary lazaro entro 4:22 \r\n8/julio/11 promocion de amaranto araceli entro 9:20 salio 10:40\r\n20/agosto/11 promoción piel de seda karina entro 9:02\r\n10/sep/11 limpieza facial karina entro 11:25 llevo limpiadora facial espumosa\r\n30/nov/11 promocion germen de trigo y vitamina e gladys entro 9:05\r\n16/01/12 limpieza facial profunda atendió graciela entro 4.25 (mega)\r\n24/abril/12 limpieza facial lucy entro 8:50\r\n16/mayo/12 promocion velo de colageno lucy entro 8:45\r\n9/oct/12 promocion reafirmante de cuello reyna entro 9:15\r\n19/05/13 lim. facial cn campo serum equilibrio atendió nelly entro 5:00 mega \r\n07/07/13 promoción de colageno y elastina nelly mega\r\n29/12/13 promocion mes diciembre atendió jhoany mega entro 5.50\r\n19/01/14 lim facial c/amp hialuronico y colageno beauty ii atendió anita mega entro 10:55\r\n03/06/14 limp. facial profundo con amp.designer. carmen mega 5.15\r\n25/oct/14 promocion trat smoothie carmen entro 9:50\r\n 02/feb/15 promocion del mes trat a basa de elastina martha entro 9:57 (mega)\r\n19-sept-15 promocion equilibrante Ph eva entro 9:30\r\n01/noviembre/15 prom. del mes trat. antiedad eva entro 12:02 (mega)\r\n26/dic/15 limpieza facial con amp. de placenta ofelia entro 11:10\r\nINICIA NEW LIFT $8000.00 ABONO $4405 RESTA $3595\r\nLLEVO CREMA CUELLO Y ESCOTE TIMEXPERT LIFT, CREMA CONFORT NIGT ALTA RECUPERACIÓN TIMEXPERT SRNS, CREMA RECUPERADORA INTENSIVA TIMEXPERT SRNS.\r\n1.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 1, MASCARILLA PORCELANA.  28/dic/15 lucy entro 9:05\r\n2.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 1, MASCARILLA PORCELANA 29/dic/15 lucy entro 11:30\r\n llevo booster recuperador timexpert srns\r\n3.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 1, MASCARILLA PORCELANA  30/dci/15 lucy entro 12:00\r\n4.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 1, MASCARILLA PORCELANA 4/ene/16 lucy entro 9:05 llevo serum contorno de ojos timexpert SRNS\r\n5.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 1, MASCARILLA PORCELANA 5/enero/16 lucy entro 11:05\r\n6.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 3, MASCARILLA MODELADORA 6/ene/16 lucy entro 9:15\r\n7.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 3, MASCARILLA MODELADORA  7/ene/16 lucy entro 11:10\r\n8.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 3, MASCARILLA MODELADORA 8/ene/16 lucy entro 9:00\r\n9.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 3, MASCARILLA MODELADORA 9/enero/16 lucy entro 8:30\r\n10.-LIMPIAR. BROSH, TÓNICO, OXIGENO, LINFÁTICO, NEW LIFT, LIFTING, BEAUTY 3, MASCARILLA MODELADORA. 11/ene/16 lucy entro 8:00\r\ntermino el tratamiento.\r\n16-01-16 se realizo promocion del mes mega candy 10am\r\n9/abril/16 limpieza facial mary lazaro entro 8:50 llevo crema recuperadora intensiva timexpert SRNS\r\n11/septiembre/16 limpieza facial charito entro 11:00 (mega)\r\n22/enero/17 prom. del mes desintoxicante maria entro 10:10 (mega)\r\n13/mayo/17 promocion antiedad con lifting mary L entro 9:00\r\n06/agosto/17 prom. del mes trat. desvanece el tiempo andrea entro 3:00 (mega)\r\n14/enero/18 prom. del mes oxigenante candy entro 1:10 (mega)\r\n28/abril/18 prom. del mes trat. humectante y revitalizante susy entro 6:55 (mega)\r\n18/JULIO/18  LIMPIEZA FACIAL  MARY ENTRO 9:25\r\n8/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE CHARITO ENTRO 8:05\r\n28/DIC/19 PROMOCION TRAT 24 K LUPITA ENTRO 8:00\r\n17/ENERO/20 SE LE QUITO UN GRANITO OFELIA ENTRO 9:00\r\n28/NOV/2020 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE Y AMP. BEAUTE MARY LAZARO ENTRO 8:00\r\n30/DIC/2020 LIMPIEZA FACIAL CON AMP. BEAUTE II LUCY ENTRO 9:00\r\n3/JULIO/2021 PROMOCION TRAT CAVIAR Y ORO MARY LAZARO ENTRO 8:10 LLEVO TONICO EXCEL THERAPY O2\r\n******************************************************************************\r\n****************16/JULIO/2022 TENIA UN VALE DE REGALO DE PAQUETE DE RELAJAMIENTO SE LE HIZO COMBIO AL FACIAL DE VITAMINA C Y MASAJE BOMBON*****************SOLO ESTA PENDIENTE EL MASAJE BOMBON\r\n******************************************************************************\r\n16/JULIO/2022 FACIAL VITAMINA C DE NATURA BISSE JOHANY ENTRO 8:05', 'no', 'activo', '2021-12-07 00:49:45', '2022-08-12 17:46:39', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('786', 'C-100786', '', 'JOHANA MAGA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('787', 'C-100787', '', 'ADELINA NADAL JUAREZ', '9932428789', '', '20/mayo/11 limpieza facial 2 x 1 gladys entro 2:30\r\n18/06/11 limpieza facial 2x1 atendio dellanira entro 3:00 pm salio4.20 pm (suc)\r\n18/06/11 depilacion de bigote atenbdio dellanira entro5:00 pm salio 5:20 pm (suc)\r\n26/nov/11 limpieza de acne con amp. desincrustante rosy entro 1:10\r\n18/abril/12 promocion revitalizante rosy entro 11:30 llevo pantalla solar, hydragel sebum control.\r\n17/nov/12 limpieza facial sara entro 1:55 llevo gel piel mixta c vital de atache\r\n20/dic/12 limpieza de acne con amp. desincrustante araceli entro 5:00\r\n2/abril/13 limpieza facial ana entro 12:10\r\n20/04/13 lim. facial con ampolleta desincrustante atendio brenda entro 2:05 mega \r\n8/junio/13 limpieza facial con amp. desincrustante mariana entro 2:00\r\n24/julio/13 promocion colageno y elastine ana entro 3:15\r\n21/sept/13 limpieza facial con amp. desincrustante rosy entro 9:20\r\n18/nov/13 limpieza facial con amp. desincrustante yusiria entro 5:10\r\n1/feb/14 limpieza facial con amp. desincrustante nelli entro 1:45\r\n17/mayo/14 promocion facial hidratante graciela entro 2:00\r\n21/junio/14 limpieza facial con amp. desincrustante graciela entro 1:15\r\n16/agosto/14 limpieza facial con amp. desincrustante mariana entro 2:00\r\n13/sept/14 limpieza facial con amp. desincrustante mariana entro 2:00\r\n15/nov/14 limpieza facial con amp. desincrustante mariana 2:30\r\ninicia tratamiento de cavitacion $4000.00 menos 10% buen fin $3600.00 pagado\r\ncon medida en ombligo 92 cm \r\n17/nov/14 carbo carmen\r\n1.-cavitacion 60 m, v c 30 m 18/nov/14 carmen entro 2:30\r\n2.-carbo, v f 45 m 19/nov/14 jhoany entro 3:00\r\n3.-v c 45 m 21/nov/14 yusiria entro 2:30\r\n4.-cavitacion 60 m, v c 30 m, 22/nov/14 johany entro 1:15\r\n5.-carbo, v c 45 m 24/nov/14 carmen entro 2:10 (solo se aplico la carbo)\r\n6.-v c 45 m \r\n7.-cavitacion 60 m, v c 30 m 27/nov/14 carmen entro 2:20 (solo se hizo cavitacion)\r\n8.-carbo, v c 45 m \r\n9.-v c 45 m\r\n10.-cavitacion 60 m, v c 30 m 2/dic/14 ana entro 2:25\r\nya no quizo tomar las sesiones de vendas frias y la cambio por la promocion del mes\r\ntermino el tratamiento. no se le debe nada\r\n6/dic/14 promocion global antiedad mariana entro 2:05\r\n31/marzo/15 promocion tratamiento anti-edad reyna entro 6:00 llevo hydragel de colageno\r\n6/junio/15 limpieza facial con amp. desincrustante mariana entro 8:20\r\n01/agosto/15 limpieza facial con amp. desincrustante mariana entro 11.30\r\n28/agosto/15 cavitacion y masaje mariana entro 2:10\r\ninicia tratamiento de cavitacion $4000.00 pagado\r\ncon medida en c-ombligo 89cm y peso 61 kg\r\n1.-cavitacion 60 m, masaje 45 m 7/sept/15 mariana entro 2:20\r\n2.-v c 11/sept/15 mari laazro entro 9:05\r\n3.-masaje 45m 15/sept/15 graciela entro 2:50\r\n4.-cavitacion 60 m, masaje 45 m 19-SEPT-15 graciela-charito entro 9:40\r\n19/sept/15 limpieza de acne con amp. desincrustante graciela entro 1:00\r\n5.-v f  23/sept/15 mariana entro 3:00\r\n6.-v f no vino este dia la perdio\r\n7.-cavitacion 60 m, masaje 45 m 25/sept/15 mariana entro 3:15 \r\n8.-v f\r\n9.-v f\r\n10.-cavitacion 60 m, masaje 45 m 29/sept/15 mariana entro 2:15\r\n7/oct/15 limpieza facial con amp. desincrustante mariana entro 2:05\r\n17/nov/15 limpieza facial con amp. desincrustante mariana entro 2:40\r\n28/dic/15 masaje full relax y limpieza facial mariana entro 10:15\r\n06/marzo/16 limpieza facial con amp. desincrustante 2x600 maria entro 4:17 (mega)\r\n05-05-16 SE REALIZO LIMP FACIAL PROFUNDA MARTHA CRISTAL 4-15\r\n25/junio/16 limpieza facial con amp. desincrustante maria entro 2:30\r\n04/octubre/16 limpieza facial rosy entro 5:00 (mega)\r\n17/dic/16 promocion trat multivitaminico mirena entro 2:30\r\n29/mayo/17 limpieza facial con amp. desincrustante mariana entro 4:10\r\n18/julio/17 limpieza facial con amp. desincrustante mariana entro 5:00\r\n19/sept/17 promocion resveratrol mariana entro 5:40\r\n26/octubre/17 prom.  del mes trat. reafirmante andrea entro 7:00 (mega)\r\n30/noviembre/17 limpieza facial con amp. desincrustante andrea entro 7:35 (mega) La señorita llego 7:15, paso al baño y se puso a desmaquillarse los ojos, anteriormente ya lo había hecho igual, andrea le dijo que ella podía desmaquillarla pero no quiso, entro a la cabina 7:35. termino 8:20 (mega)\r\n30/12/17 LIMPIEZA FACIAL MARY ENTRÓ 11:00\r\n22/FEB/18 LIMPIEZA FACIAL Y AMP DE COLÁGENO BEAUTE II  ANITA ENTRO 1:30\r\n12/ABRIL/18 RADIO FRACCIONADA OFELIA ENTRO 12:30\r\n21/ABRIL/18 RADIO FRACCIONADA OFELIA ENTRO 9:35\r\n9/JUNIO/18 LIMPIEZA FACIAL PROFUNDA REYNA ENTRO 2:35\r\n9/AGOSTO/18  PROM TRATAMIENTO FACIAL HUMECTANTE LUPITA ENTRO 3:40\r\n7/DIC/18 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CON AMP. COLÁGENO DE GERMAINE REYNA ENTRO 1:25\r\n9/MARZO/19 PROM TRATAMIENTO FACIAL DETOX LUPITA ENTRO 1:15\r\n31/junio/19 limpieza facial profunda carmen entro 5:10 mega01/MAYO/19 PROMOCION DEL MES EFECTO BOTOX ROSY ENTRO 12:25 MEGA\r\n05/septiembre/19 prom. del mes tratamiento oxigenante rosy entro 4:35 mega\r\n30/OCTUBRE/19 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUPITA ENTRO 1:40\r\n11/ENERO/2020 LIMPIEZA FACIAL PROFUNDA SUSI ENTRO 3:37 MEGA\r\n20/FEBRERO/2020 TRATAMIENTO 4F C/AMP DESINCRUSTANTE JANETH ENTRO 4:41 MEGA\r\n14/SEPT/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE OFELIA ENTRO 3:30\r\n9/NOV/2020 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MIRENA ENTRO 4:30\r\n11/DICIEMBRE/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY ENTRO 4:30\r\n11/FEB/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MIRENA ENTRO 10:25\r\nLLEVO DABALASH\r\n30/MARZO/2021 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY ENTRO 2:20\r\nINICIA TRATAMIENTO DE CAVITACION $4000.00 PAGADO\r\n40 MINUTOS DE CAVITACION EN ABDOMEN, G-5 EN CHAPARRERAS TODOS LOS DIAS\r\n1.-CAVITACION 40 M, MASAJE 45 M 30/MARZO/2021 ANITA ENTRO 4:20\r\n2.-MASAJE 45 M\r\n3.-MASAJE 45 M   \r\n4.-CAVITACION 40 M, MASAJE 45 M 5/ABRIL/2021 ANITA ENTRO 3:15\r\n5.-MASAJE 45 M \r\n6.-MASAJE 45 M \r\n7.-CAVITACION 40 M, MASAJE 45 M  12/ABRIL/2021 ANITA ENTRO 10:30\r\n8.-MASAJE 45 M \r\n9.-MASAJE 45 M \r\n10.-CAVITACION 40 M, MASAJE 45 M 28/ABRIL/2021 ANITA ENTRO 9:35\r\n10/JUNIO/2021 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUCY\r\n28/JUNIO/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA A ENTRO 4:30\r\n23/AGOSTO/2021 LIMPIEZA FACIAL MARIANA ENTRO 4:15\r\n15/OCTUBRE/2021 LIMPIERZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 3:10\r\n24/NOVIEMBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA\r\n11/ENERO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 12:25\r\n13/ENERO/2022 *******INICIA TRATAMIENTO DE NEW LIF COSTO $10,000.00*********PAGADO\r\n1.- DERMOSONIC 13/ENERO/2022 JOHANY ENTRO 3:25\r\n2.- LUMICELL 14/ENERO/2022 MARY LAZARO ENTRO 5:40\r\n3.- VACUN-VF 19/ENERO/2022 MARY LAZARO ENTRO 5:25\r\n4.- DERMOSONIC  20/ENERO/2022 MARY LAZARO ENTRO 5:15\r\n5.- LUMICELL  21/ENERO/2022 MARY LAZARO ENTRO 5:05\r\n6.- VACUN-VF 22/ENERO/2022 MIRENA ENTRO 8:15 ****LLEVO CREMA CHAUFFANTE****\r\n7.- DERMOSNIC 24/ENERO/2022 MARY LAZARO ENTRO 3:05\r\n8.- LUMICELL 25/ENERO/2022 MARY LAZARO ENTRO 3:15\r\n9.- VACUN-VF\r\n10.- DERMOSONIC\r\n11.- LUMICELL\r\n12.- VACUN-VF\r\n13.- DERMOSONIC\r\n14.- LUMICELL\r\n15.- VACUN-VF\r\n16.- DERMOSONIC\r\n17.- LUMICELL\r\n18.- VACUN-VF\r\n19.- DERMOSONIC\r\n20.- LUMICELL\r\n1.- CAVITACION Y MASAJE 45 1/FEBRERO/2022 ARLETH ENTRO 2:10 \r\n2.- MASAJE 45   2/FEBRERO/2022 ARLETH \r\n3.- MASAJE 45  3/FEBRERO/2022 ARLETH\r\n4.- CAVITACION Y MASAJE 45 4/FEBRERO/2022 ARLETH ENTRO 2:10\r\n5.-MASAJE 45 M 7/FEB/2022 ARLETH ENTRO 1:30\r\n6.- MASAJE 45 M 8/FEBRERO/2022 ARLETH ENTRO 5:20\r\n8/FEBRERO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MIRENA ENTRO 6:00\r\n16/FEBRERO/2022 CAVITACION Y MASAJE ARLETH ENTRO 4:30\r\n19/FEB/2022 CAVITACION MARY LAZARO ENTRO 8:30\r\n21/FEBRERO/2022 MASAJE ARLETH  ENTRO 5:25\r\n10/MARZO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 10:20\r\n24/MARZO/2022 LIMPIEZA DE ESPALDA MARIANA ENTRO 4:20\r\n12/SEPT/2022 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE OFELIA ENTRO 1:12 \r\n13/ENERO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL PURIFICANTE  MAS AMPOLLETA DESINCRUSTANTE  ROSY ENTRO 5:35 (MEGA)\r\n24/FEBRERO/2024 18 DISPAROS DE LIPOSONIC  50 J/ 35 J SRA. BEGO ENTRO 5:20  PESO 64 KILOS MEDIDA EN OMBLIGO 92 CM\r\n18/ABRIL/2023 PROMOCION DEL MES TRATAMIENTO PLASMA MARINO ROSY ENTRO 7:12 (MEGA) ****PAGO AMPOLLETA DESINCRUSTANTE****\r\n26/ABRIL/2023 INICIA DEPILACION LASER DE BIGOTE 100MS 10J LUCY ENTRO 3:15\r\n19/MAYO/2023  PROMOCION DEL MES TRATAMIENTO MAGIC FACE ROSY ENTRO 5:00 (MEGA)\r\n*************LA SEÑORITA NO LE GUSTO LA MASCARILLA DE YESO SE LE PUSO \r\n                            MASCARILLA DE AVENA**********************************', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-18 15:37:01', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('788', 'C-100788', '', 'ANA TERESA GARCIA JIMENEZ', '9371225052', '', '24/mayo/17 limpieza facial 2x600 candy entro 6:10 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('789', 'C-100789', '', 'MANUELA LUNA MAGAÑA', '9931523608', '', '28/dic/15 masaje full relax candy entro 3:10\r\n13/dic/16 masaje full relax 2x600 andrea entro 11.00\r\n16/MAYO/19 MDM FULL RELAX VALE DE REGALO ANITA ENTRO 11:55\r\n31/MAYO/2021  MASAJE FULL RELAX 2X600 LUCY ENTRO 4:05 VALE DE RAGALO\r\n29/NOVIEMBRE/2021 MASAJE FULL RELAX 2X600 JOHANY ENTRO 4:00 VALE DE REGALO\r\n1/SEPTIEMBRE/2022 MASAJE FULL RELAX 2X600 MARIANA ENTRO 12:10\r\n22/NOVIEMBRE/2022 MASAJE SENSORELAX LUCY ENTRO 11:55\r\n31/MARZO/2023 MASAJE FULL RELAX MARIA ENTRO 9:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-30 18:47:12', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('790', 'C-100790', '', 'LUCIA SANTIAGO PRIEGO', '', '', '14/OCT/2020 PAGO SU HERMANA LORENA SANTIAGO PRIEGO EL TRATAMIENTO GOLD\r\n15/OCT/2020 PROMOCION TRAT GOLD REGENERANTE ANITA ENTRO 2:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('791', 'C-100791', '', 'MARIA JOSE ESPONDA HIDALGO', '9931199261', '', 'depilacion de piernas completas $1500.00 c/s  axila $360.00\r\n1.-19/nov/10 axila autom. 18 j, piernas 30 ms 18 j  lucy \r\n2.-20/dic/10 axila autom. 20 j, piernas 30 ms 20 j lucy \r\n3.-19/ene/11 axila autom. 22 j, piernas 30 ms 22 j lucy\r\n4.-21/feb/11 axila autom. 22 j, piernas completas 100 ms 22 j lucy \r\n5.-30/marzo/11 axila autom. 22 j solo se hizo axila queda pendiente piernas ya esta pagada \r\n5.-6/abril/11 piernas completas lucy entro 4:00\r\n13/abril/11 rizado de pestañas reyna entro 3:15\r\n6.-11/mayo/11 axila autom. 22 j, piernas completas 100 ms 22 j rosy entro 3:45\r\n7.-17/junio/11 axila autom. 26 j, piernas completas 100 ms 26 j lucy entro 10:10\r\n4/junio/12 limpieza facial con amp. equilibrante ofelia\r\n30/ene/13 limpieza facial con amp. desincrustante ofelia entro 12:15\r\n6/junio/14 promocion antioxidante ofelia entro 12:10\r\n22/agosto/15 limpieza facial con amp. de colageno ofelia entro 11:30\r\n9/ene/16 masaje combo reyna entro 9:45\r\n9/ene/16 promocion desintoxicante con amp. colageno y beuti 1  ofelia \r\n30/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD OFELIA ENTRO 9:30', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('792', 'C-100792', '', 'ALMA EDITH GAMA CORONEL', '9931199170', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('793', 'C-100793', '', 'JOSE LUIS VALENCIA CANO', '9933115635', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('794', 'C-100794', '', 'CRISTELL PEREZ AREVALO', '9933403369', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('795', 'C-100795', '', 'RUBI JIMENEZ ARROLLO', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('796', 'C-100796', '', 'ANDREA VARELA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('797', 'C-100797', '', 'DULCE ESCAMILLA RAMON', '9931604852', '', 'INICIA TRATAMIENTO REDUCTIVO COMPLETO  $8000.00 BONO $4000.00 RESTA $4000.00\r\nCON PESO 645KG.\r\n1.-CAVITACION 60M, MASAJE 45M 13/marzo/17 carmen entro 12:40\r\n2.-MASAJE 45M, TERMOS 14/marzo/17 carmen entro 12.00\r\n3.-MASAJE 45, CAPSULA 15/marzo/17 carmen entro 12:40\r\n4.-MASAJE 45M, CORPO 16/marzo/17 carmen entro 12.40\r\n5.-MASAJE 45M, PRESO 40M 17/marzo/17 carmen entro 12:30\r\n6.-CARBO, CAVITACION 60 M, MASAJE 45 M 21/marzo/17 andrea-carmen entro 10:20\r\n7.-LASER LIPOLITICO 20M, MASAJE 45 22/marzo/17 mary entro 10:00\r\n8.-MASAJE 45M, CRIOLIPOLISIS 60M 23/marzo/17 andrea-carmen entro 10:30\r\n9.-MASAJE 45M, cápsula 25/marzo/17 andrea entro 8:10\r\n10.-CARBO, MASAJE 45, G-5 10, TERMO 27/marzo/17 carmen entro 11:00\r\ntérmino tratamiento con medida abdomen-74, cintura-81, cadera alta-91 peso 62 1/2 kilos\r\nINICIA TRATAMIENTO REDUCTIVO $3000.00\r\n1.-CARBO, MASAJE 45 M 31/marzo/17 andrea entro 3:00\r\n2.-MASAJE 45 M 3/abril/17 andrea entro 10:20 abono $1500.00 resta $1500.00\r\n3.-CARBO, MASAJE 45 M 4/abril/17 andrea entro 2:00 llevo crema chauffante\r\n4.-MASAJE 45 M 5/abril/17 andrea entro 10:30\r\n5.-CARBO, MASAJE 45 M 6/Abril/17 andrea entro 10:45\r\n6.-MASAJE 45 M 17/abril/17 anita entro 11:15\r\n7.-CARBO, MASAJE 45 M 18/abril/17 andrea entro 4:50\r\n8.-MASAJE 45 M 19/abril/17 andrea entro 11:00\r\n9.-CARBO, MASAJE 45 M 21/abril/17 mariana entro 11:40\r\n10.-MASAJE 45 M \r\nINICIA TRATAMIENTO DE VENDAS FRIAS $3000.00\r\nSE LE DIO 5 SESIONES DE CARBO DE CORTESIA\r\n1.-CARBO, VENDAS FRIAS 2/junio/17 lucy entro 5:50 (la carbo se la puso en la mega)\r\n2.-MASAJE 45 M 5/junio/17 andrea entro 1:50\r\n3.-CARBO, VENDAS FRIAS 6/junio/17 lucy entro 6:00\r\n4.-MASAJE 45 M 7/junio/17 andrea entro 2:30\r\n5.-CARBO, VENDAS FRIAS 8/junio/17 ofelia entro 3:00\r\n6.-MASAJE 45 M 12/junio/17 andrea entro 3:30 SE PUSO LA CARBO EN LA MEGA\r\n7.-CARBO, VENDAS FRIAS 13/junio/17 lucy entro 3:05\r\n8.-VENDAS FRIAS 16/junio/17 andrea \r\n9.-CARBO, VENDAS FRÍAS 20/junio/17 ofelia\r\n10.-VENDAS FRIAS 22/junio/17 andrea entro 2:30\r\nINICIA TRATAMIENTO DE CELULITIS $8000.00 ABONO 4,000\r\n1.-LUMICELL 21/MAYO/18 LUCY ENTRO 11:10\r\n2.-DERMO  22/MAYO/18 LUCY ENTRO 1:00\r\n3.-RADIO   23/MAYO/18 LUCY ENTRO 11:05\r\n4.-LUMICELL  24/MAYO/18 LUCY ENTRO  11:20\r\n5.-RADIO 25/MAYO/18 LUCY \r\n6.-LUMICELL 28/MAYO/18 LUCY ENTRO 10:45\r\n7.-RADIO     29/MAYO/18 LUCY ENTRO  12:50\r\n8.-LUMICELL   30/MAYO/18 LUCY ENTRO 11:00\r\n9.-RADIO    31/MAYO/18 LUCY ENTRO 11:40\r\n10.-LUMICELL    01/JUNIO/18 LUCY ENTRO 10:30\r\n11.-RADIO     2/JUNIO/18 LUCY ENTRO 11:20\r\n4/JUNIO/18 LLEVO CREMA TIMEXPERT IN\r\n12.-LUMICELL   4/JUNIO/18 LUCY\r\n13.-RADIO   5/JUNIO/18 LUCY\r\n14.-LUMICELL  8/JUNIO/18 LUCY ENTRO 12:05\r\n15.-RADIO 11/JUNIO/18 REYNA ENTRO 12:35\r\n16.-LUMICELL   12/JUNIO/18 LUCY ENTRO 1:00\r\n17.-RADIO    13/JUNIO/18 LUCY ENTRO  11:00\r\n18.-LUMICELL   14/JUNIO/18 LUCY ENTRO 12:20\r\n19.-RADIO   18/JUNIO/18 LUCY ENTRO 11:00\r\n20.-LUMICELL  25/JULIO/18  LUCY\r\n21/JULIO/18 TERMINO DE PAGAR EL TRATAMIENTO CORPORAL 4,000 PAGADOOOO\r\n21/JULIO/18 LLEVO BRUMA SOLAR Y CREMA CHAUFFANTE\r\n13/JUNIO/19 4 DISPAROS DE LIPOSONIX LLEVO CREMA CHAUFFANTE OFELIA\r\nINICIA TRATAMIENTO REDUCTIVO DE $4,000.00\r\nPESO 61 1/2 KILOS  DIETA 13 DIAS \r\nMEDIDA CINTURA (OMBLIGO) 82 CM\r\n24 DE JUNIO ABONO 2,000 DBBE 2,000\r\n1.-VENDAS FRIAS 24/JUNIO/19 MARY LAZARO ENTRO 10:25\r\n2.-ELECTROESTIMULACION   25/JUNIO/19 ANITA ENTRO 10:05\r\n3.-MASAJE 45 M 26/JUNIO/19 ANITA ENTRO 10:15\r\n4.-CRIOTERAPIA 27/JUNIO/19 MARY LAZARO ENTRO 10:30\r\n5.-MASAJE 45 M\r\n6.-ELECTROESTIMULACION\r\n7.-MASAJE 45 M \r\n8.-VENDAS FRIAS \r\n9.-CRIOTERAPIA\r\n10.-MASAJE 45 M \r\n30/SEPTIEMBRE/2020  CARBOXITERAPIA OFELIA ENTRO 1:20\r\n2/OCT/2020 CARBOXITERAPIA ROSY ENTRO 11:40\r\n5/OCT/2020 CARBOXITERAPIA ROSY ENTRO 12:50\r\n8/OCTUBRE/2020 CARBOX Y TRATAMIENTO FACIAL GOLD ROSITA ENTRO 3:00\r\n19/OCT/2020 CARBOX LUCY\r\n22/OCTUBRE/2020 CARBOX Y TRATAMIENTO FACIAL GOLD REGENERANTE LUCY ENTRO 3:05\r\n29/OCTUBRE/2020 CARBOX, TRATAMIENTO FACIAL GOLD REGENERANTE LUCY ENTRO 4:10\r\n5/NOV/2020 CARBOX, PROMOCION TRAT BOTANICO LUCY ENTRO 1:00\r\n9/NOV/2020 CARBOX ANITA ENTRO 12:50\r\n23/NOV/2020 CARBOX LUCY\r\n12/JULIO/2021 MASAJE CLIENTE FRECUENTE OFELIA ENTRO 12:15\r\nINICIA TRATAMIENTO REDUCTIVO $4000.00 PAGADO LLEVO CREMA CHAUFFANTE\r\nMEDIDA ABAJO DEL OMBLIGO 90 CM, CINTURA 79 CM PESO 65 1/2 KG\r\n1.-MASAJE 45 M 16/MAYO/2022 CRISTINA ENTRO 11:05\r\n2.-MASAJE 45 M 17/MAYO/2022 CRISTINA ENTRO 11:05\r\n3.-MASAJE 45 M 18/MAYO/2022 CRISTINA ENTRO 11:00\r\n4.-MASAJE 45 M 24/MAYO/2022 CRISTINA ENTRO 11:20\r\n5.-MASAJE 45 M 25/MAYO/2022 CRISTINA ENTRO 11:10\r\n6.-MASAJE 45 M  26/MAYO/2022 CRISTINA ENTRO 11:00\r\n7.-MASAJE 45 M  27/MAYO/2022 CRISTINA ENTRO 11:15\r\n8.-MASAJE 45 M  30/MAYO/2022 CRISTINA ENTRO 11:00\r\n9.-MASAJE 45 M 31/MAYO/2022 CRISTINA ENTRO 11:10\r\n10.-MASAJE 45 M  1/JUNIO/2022 CRISTINA  *****TERMINO TRATAMIENTO*****\r\n31/MAYO/2022 19 DISPAROS DE LIPOSONIC OFELIA\r\n1/JUNIO/2022 TRATAMIENTO DE VENDAS 4,000.00 PAGADO\r\nINICIA TRATAMIENTO DE VENDAS FRIAS\r\n1.-VENDAS FRIAS 2/JUNIO/2022 OFELIA ENTRO 11:10\r\n2.-VENDAS FRIAS 3/JUNIO/2022 OFELIA ENTRO 10:10\r\n3.-VENDAS FRIAS 9/JUNIO/2022 CRISTINA ENTRO 11:10\r\n4.-VENDAS FRIAS 10/JUNIO/2022 OFELIA ENTRO 11:20\r\n5.-VENDAS FRIAS 13/JUNIO/2022 JHOANY ENTRO 11:15\r\n6.-VENDAS FRIAS 14/JUNIO/2022 CRISTINA ENTRO 11:15\r\n7.- VENDAS FRIAS 15/JUNIO/2022 ARIANA ENTRO 11:25 \r\n8.- VENDAS FRIAS 16/JUNIO/2022 CRISTINA ENTRO 11:15 \r\n9.-VENDAS FRIAS 17/JUNIO/2022 CRISTINA ENTRO 10:50\r\n30/SEPT/2022 LLEVO CREMA CHAUFFANTE\r\n***************** INICIA TRATAMIENTO CORPORAL PERSONALIZADO DE $6,200.00 , PAGO $1,500.00, DEBE: $4,700.00*********\r\n30MARZO/2023 ABONO 600\r\n31/MARZO/2023 ABONO 600\r\n1. 27/MARZO/2023 LIPOSNIX DE RADIO  LUCY ENTRO 11:40\r\n2. 30/MARZO/2023 MASAJE REDUCTIVO MARIA ENTRO 1:00\r\n3. 31/MARZO/2023 VENDAS FRIAS LUCY ENTRO 1:00\r\n4.-4/ABRIL/2023 HI EMT LUCY ENTRO 9:10\r\n5.- LIPOSNIC\r\n6.- MASAJE\r\n7.- MASAJE\r\n8.- HI EMT\r\n4/ABRIL/2023 PROMOCION TRAT. FACIAL PLASMA MARINO LUCY ENTRO 10:00\r\n26/ABRIL/2023 PAGA POR SESION SE ROMPIO EXPEDIENTE', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-13 12:47:27', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('798', 'C-100798', '', 'ADRIANA ALVAREZ HERNANDEZ', '9363896021', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('799', 'C-100799', '', 'AURORA GOMEZ BENITES', '9932223372', '', '06-09-15 SE REALIZO MDM 2X1 MARTHA CRISTAL 4', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('800', 'C-100800', '', 'GUADALUPE GOMEZ BENITO', '9931929920', '', '21/01/15 serealizo msj de full relas de un 2x1 atendio mari cristal entro ala 2.30\r\n01/marzo/15 mdm full relax 2x1 nelly entro 3:15 (mega)\r\n6-09-15 se realizo mdm 2x1 cristal candy 4\r\n25/octubre/15 mdm full relax 2x1 maribel entro 7:05 (mega)\r\n08/noviembre/15 mdm full relax 2x1 andrea entro 7:15 (mega) no quiso que se le diera masaje \r\nen pienas, brazos y cara por que se sentia sensible \r\n3/JULIO/2020 MSAJE FULL RELAX 2 X 600 MARY LAZARO ENTRO 4:55\r\n07/ ENERO/2023 MASAJE RELAJANTE Y LIMPIEZA FACIAL EN PROMOCION PERSONAL \"VALE DE REGALO\" MONICA ENTRO 1:10 (MEGA) \r\n27/ ENERO/2023 MASAJE RELAJANTE Y LIMPIEZA FACIAL EN PROMOCION PERSONAL MONICA ENTRO 6:05 (MEGA)\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-02-25 12:01:07', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('801', 'C-100801', '', 'JULY PEREZ DE CRUZ', '9933181791', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('802', 'C-100802', '', 'PATRICIA BEZARES BETANZOS', '', '', '28/dic/16 limpieza facial 2x600 reyna entro 3:50\r\n29/12/17 PROMOCION TRATAMIENTO GOLD ENITA ENTRO 2:25', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('803', 'C-100803', '', 'ELENA CORTES CELORIO', '', 'elecorcel@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('804', 'C-100804', '', 'EDITH BARBOSA MACDONALD', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('805', 'C-100805', '', 'YADIRA DE CARRE', '9933939608', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('806', 'C-100806', '', 'ANDREA REYES RIOS', '9361012759', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('807', 'C-100807', '', 'AURORA MARIA CANABAL CASTA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('808', 'C-100808', '', 'ANA MARIA PRIEGO SAENZ', '9931599173', '', '25/02/05 promocion ginseng consuelo\r\n28/02/05 promocion ginseng marcela\r\n17/oct/05 limpieza facial 2 x 1 reyna\r\n26/marzo/07 promocion antiarrugas carmen entro 12:45\r\n8/oct/08 limpieza facial 2 x 1 rosy \r\n15/oct/08 limpieza facial 2 x 1 araceli entro 1:10 salio 2:30\r\n7/abril/10 limpieza facial 2x1 marina \r\n27/oct/10 limpieza facial 2 x 1 karina entro 12:05 \r\n3/nov/10 limpieza facial 2 x 1 lucy \r\n2/feb/11 limpieza facial 2 x 1 deyanira entro 12:06\r\ntratamiento reductivo de aspired y gel con osmotico $3500.00 pagado\r\n1.-aspired 35, gel con osmotico 30 m 22/feb/11 gladys entro 11:27 \r\n2.-aspired 35 m, gel con osmotico m 24/feb/11 gladys entro 12:55 \r\n3.-aspired 35 m, gel con osmotico 30 m 26/feb/11 gladys entro 11:45 \r\n4.-aspired 35 m, gel con osmotico 30 m 28/feb/11 gladys entro 12:00\r\n5.-masaje 35 m, gel con osmotico 30 m 2/marzo/11 reyna entro 4:50 \r\n6.-aspired, vendas 8/marzo/11 reyna entro 12:00\r\n7.-masaje, v f 10/marzo/11 reyna entro 1:00\r\n8.-masaje, v f 12/marzo/11 reyna entro 11:00\r\n9.-masaje,vf 14/marzo/11 gladys entro alas .\r\n10.-masaje, v f 16/marzo/11 deyanira entro 12:30\r\ntermino tratamiento.\r\n11/abril/11 mdm 2 x 1 reyna entro 11:00\r\n3/abril/12  masaj.descanso,micro entro reyna 10;00\r\n13/agosto/12 mdm 2x1 mariana entro 3:00\r\ninicia tratamiento de 10 sesiones de ultrasonido y drenaje linfatico $4000.00 pagado.\r\n1.-ultrasonido 30 m, drenaje linfatico 30 m 5/nov/12 lucy entro 4:40\r\n2.-ultrasonido 30 m, drenaje linfatico 30 m 6/nov/12 karina entro 10:00\r\n3.-ultrasonido 30 m, drenaje linfatico 30 m 7/nov/12 karina entro 9:10\r\n4.-ultrasonido 30 m, drenaje linfatico 30 m 8/nov/12 lucy entro 8:35\r\n5.-ultrasonido 30 m, drenaje linfatico 30 m 9/nov/12 karina entro 8:50\r\n6.-ultrasonido 30 m, drenaje linfatico 30 m 12/nov/12 karina entro 9:05\r\n7.-ultrasonido 30 m, drenaje linfatico 30 m 14/nov/12 karina entro 8:50\r\n8.-ultrasonido 30 m, drenaje linfatico 30 m 15/nov/12 graciela entro 8:55\r\n9.-drenaje linfatico 60 m 20/nov/12 reyna entro 10:00\r\n10.-drenaje linfatico 60 m 23/nov/12 reyna entro 10:00\r\ntermino tratamiento.\r\n1/dic/12 mdm cortesia cliente frecuente reyna entro 10:50\r\n07/08/13 mdm 2x1 brenda mega 2.00\r\n07/014/14 mdm 2x1 martha mega 6:00\r\n07/04/14 mdm 2x1 martha mega 6:00\r\n27/oct/14 mdm drenaje linfatico brenda entro 11:50\r\n28/oct/14 desafio antiedad reyna entro 11.00\r\n4/nov/14 se llevo serum perfeccionador y trat contorno de ojos\r\n13/01/15 mdm 2x1 entro 5.00 carmen (suc. cristal)\r\n14/enero/15limpieza de acne 2x1 carmen entro 4:00\r\n17/ene/15 rizado de pestañas jhoany entro 12:25\r\n7/feb/15 micro jhoany entro 12:30\r\n14/marzo/15 lim pieza facial 2x1 martha entro 4:09 (mega)\r\n08/abril/15 mdm full relax 2x1 rosy entro 2:02 (mega)\r\n16/diciembre/15 mdm full relax cliente frecuente maria entro 7:00 (mega)\r\n30/marzo/16 mdm full relax cliente frecuente charito entro 11:50 (mega)\r\n17/julio/116 mdm holistico 2x600 andrea entro 6:00 (mega)\r\n26/noviembre/16 mdm full relax 2x500 maria entro 1:10 (mega)\r\n02/abril/17 mdm full relax 2x600 lizbeth entro 4:00 (mega)\r\n21/julio/17 mdm full relax 2x600 candy entro 12:05 (mega)\r\n22/sept/17 mdm full relax 2x600 candy entro 11:05 (mega)\r\n26/FEB/18 MDM FULL RELAX ANITA ENTRO 2:15\r\n19/SEP/18 MDM FULL RELAX 2 X 600 OFELIA ENTRO 4:10\r\n23/NOVIEMBRE/19 MDM FULL RELAX 2X600 MONI ENTRO 11:03 MEGA\r\n25/SEPT/2021 MASAJE FULL RELAX 2X600 MARIANA ENTRO 10:00\r\n06/NOV/2021 MASAJE FULL RELAX 2X600 MONICA ENTRO 17:00 MEGA\r\n01/OCTUBRE/2022 MASAJE RELAJANTE Y LIMPIEZA FACIAL EN PROMOCION DE 2 PERSONAS ROSY ENTRO 3:05 (MEGA)\r\n8/OCTUBRE/2022 MASAJE FULL RELAX PROMOCION 2 PERSONAS CRISTINA ENTRO 10:55\r\n****************LE GUSTO MUCHO  EL AMSAJE  DE CRISTINAAAA**************\r\n\r\n08/FEBRERO/2023 DUO MASAJE FULL RELAX ROSY ENTRO 3:55 (MEGA)\r\n********************************************************************************************************************************************************************\r\n******** LA SEÑORITA EL 08/OCTUBRE/2022 SE QUEJO EN MATRIZ QUE NO SE LE HABIA SELLADO SU TARJETA DE CLIENTE FRECUENTE POR TODOS LOS SERVICIOS QUE TENIA ACUMULADOS, SE LE EXPLICO QUE NO SE SELLA A DESTIMPO, POR LO QUE SE LE HIZO LLEGAR UNA NUEVA TARJETA DE CLIENTE FRECUENTE. POR OTRO LADO, HOY 08/FEBRERO/2023, 4 MESES DESPUES DE EL ULTIMO INSIDENTE, VOLVIO A SOLICITAR QUE SE LE SELLARAN LOS SERVICIOS QUE TENIA ACUMULADOS, MENCIONO QUE SI TIENE LA TARJETA PERO QUE NO LA TRAIA, A LO QUE DESPUTAMENTE MENCIONO QUE TENDRIA QUE TENER UNA CARTERA POR TARJETA DANDO A ENTENDER CON EL PROPOSITO DE NO EXTRAVIARLA. EN CONCLUSION, SE LE HIZO LLEGAR UNA NUEVA TARJETA DE CLIENTE FRECUENTE JUENTO CON LA DEDIBA EXPLICACION DE LAS RESTRICCIONES DE ESTA MISMA. ******************************************************************************************************************************************************************************************************************************************************', 'no', 'activo', '2021-12-07 00:49:45', '2023-02-08 10:59:57', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('809', 'C-100809', '', 'MARBELLA VILLAMIL HERNANDEZ', '', '', '10/mayo/16 delineado de cejas ofelia, se le dio $100.00 a ofelia\r\n24/mayo/16 retoque de cejas ofelia, se le dio $100.00  a ofelia ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('810', 'C-100810', '', 'ZAIDA MENDOZA ECHENIQUE', '9932010801', 'mendoza_zaida@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('811', 'C-100811', '', 'EDNA SASTRE GONZALEZ', '993-315-34-16', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('812', 'C-100812', '', 'IVET CHAGA MONTANO', '9931600476', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('813', 'C-100813', '', 'ADRIANA ABREU GALLEGOS', '9164071638', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('814', 'C-100814', '', 'JUAN LUIS ROSADO RAMOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('815', 'C-100815', '', 'YESSICA ZAMORA MORILLO', '9933937283', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('816', 'C-100816', '', 'CARMEN SANCHEZ PERERA', '9932023250', '', '06/abril/06 limpieza facial marcela\r\n09/mayo/06 promocion papaya y piña yesy\r\n22/julio/06 promocion oxigenoterapia mary lazaro\r\n18/oct/06 promocion renove tana entro 8:35\r\n06/dic/06 limpieza facial yesy entro 9:05\r\n10/feb/07 promocion ginseng ofelia entro 11:35\r\n03/abril/07 promocion botanico reyna entro 10:30\r\n09/junio/07 promocion trat. de cristal oded entro 8:25\r\n08/sept/07 promocion colageno ligia entro 12:35\r\n17/dic/07 promocion vitamina c ofelia entro 9:45\r\n15/feb/08 promocion dermorelax lucy entro 8:10 \r\nsolo quiere que la atienda ofelia o lucy.\r\n14/abril/08 promocion botanico con amp. desincrustante lucy entro 4:15\r\n8/julio/08 promocion termico lucy entro 9:40 \r\n20/dic/08 promocion vitamina c mary lazaro entro 9:45 salio 12:20 \r\n31/ene/09 promocion jalea real mary lazaro entro 11:45 \r\n31/oct/09 promocion hidronutritivo gladys entro 12:15 \r\n25/marzo/10 promocion de cristal lucy entro 9:35 \r\n3/julio/10 promocion relajante e hidratante karina entro 8:50\r\n13/nov/10 promocion modeladora araceli entro 9:50 \r\n18/dic/10 promocion velos de colageno lucy entro 12:30 \r\n22/feb/11 promocion trat. de seda, rizado de pestañas y dep. de bigote lucy entro 3:10 \r\n1/junio/11 promocion estimulante de endorfinas, depilacion de cejas y bigote reyna entro 9:30\r\n1/junio/11 rizado de pestañas lucy \r\n13/agosto/11 promocion piel de seda, depilacion bigote y ceja  gladys 11:10\r\n28/julio/12 promocion hidratante de arroz, depilacion de cejas y bigote reyna entro 11:25\r\n6/nov/12 promocion de colageno, depilacion de cejas y bigote araceli entro 8:00\r\n18/dic/12 promocion de oro, depilacion de cejas y bigote karina entro 5:10\r\n17/abril/13 promocion porcelana, depilacion de cejas y bigote graciela entro 12:35\r\n14/sept/13 promocion lifting antiarrugas, depilacion de cejas y bigote mirena-bego entro 10:15\r\n14/sept/13 rizado de pestañas lucy entro 12:00 llevo dabalash, crema de ojos y crema hidroprotectora\r\ny antioxidante c-vital de atache\r\n19/dic/13 rizado de pestañas lucy entro 4:00 no le quedo el rizado se le va a hacer de nuevo\r\nviene en enero y no se le va a cobrar\r\n8/marzo/14 se le hizo el rizado de pestañas que estaba pendiente lucy entro 12:30\r\n8/marzo/14 promocion humectante, depilacion de cejas y bigote lucy entro 12:40\r\n26/julio/14 dep de cejas reyna entro 11:10\r\n26/julio/14 depilacion de bigote reyna (la quemo se le levanto el pellejito y le salio sangre)\r\n25/agosto/14 depilacion de cejas y rizado de pestañas lucy entro 9:45\r\n18/octubre/14 promocion trat facial smoothie, rizado de pestaña y dep de cejas rosy 12:35 (mega)\r\n21/dic/14 limpieza facial y depilacion de cejas rosy rizado de pestañas nelly entro 3:58 (mega)\r\n08/feb/15 rizado de pestañas y dep cejas rosy entro 10:02 (mega) le quedaron muy rizadas\r\npor que todavia tenia el rizado anterior y se le comento a ella \r\n1/abril/15 rizado de pestaña, dep de cejas lucy entro 2:15\r\ninciia depilacion laser de bigote $180.00 cada sesion\r\n1/abril/15 1°vez bigote 30ms 18j lucy\r\n2/mayo/15 2da. bigote 30 ms 18 j lucy\r\n6/junio/15 3era. bigote 30ms 18j ofelia\r\n24/julio/15 4ta. bigote 30ms 18j sra. bego\r\n20/agosto/15 promocion chocoterapia, depilacion de cejas, rizado de pestañas lucy entro 9:30\r\n3/oct/15 depilacion de cejas mariana entro mariana entro 1:50\r\n10/oct/15 bigote 30ms 18j reyna \r\n24/enero/16 limpieza facial, rizado de pestañas y dep. cejas rosy entro 1:00(mega)\r\n23/junio/16 depilacion de ceja y rizado de pestaña lucy entro 10:35\r\n22/oct/16 promocion de colageno, dep de cejas y rizado de pestaña rosy entro 1:10\r\nSE LE DEBE UN RIZADO DE PESTAÑA PORQUE NO LE AGARRO Y SE LE VOLVERÁ A REALIZAR,\r\n\r\n/((((((((((((ELLA NO SE DEBE HACER FACIAL Y RIZADO PORQUE NO LE AGARRARA))))))))\r\n\r\n3/dic/16 rizado de pestaña lucy entro 1:00 (era el que tenia pendiente)\r\n20/ene/17 depilacion de cejas susy entro 12:25\r\n4/marzo/17 rizado de pestaña lucy entro 1:00\r\n6/JULIO/19 PROM TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO Y RIZADO DE PESTAÑA LUCY ENTRO  11:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('817', 'C-100817', '', 'MARTHA ESTEFANIA CERINO', '9932079171', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('818', 'C-100818', '', 'ROMELIA VIVAS RUIZ', '9371155394', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('819', 'C-100819', '', 'ALMA DORIS DE LA CRUZ OLIVA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('820', 'C-100820', '', 'YARELI ZEPEDA GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('821', 'C-100821', '', 'SILVIA QUINTERO MAGA', '9931337163', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('822', 'C-100822', '', 'ALEJANDRO DIAZ ACOSTA', '9931175483', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('823', 'C-100823', '', 'ALEJANDRA AVALOS GARCIA', '2321236374', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('824', 'C-100824', '', 'DEYANIRA SANCHEZ ALVARADO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('825', 'C-100825', '', 'ERIKA DEL SOCORRO GALVAN CHAVEZ', '9932426498', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('826', 'C-100826', '', 'KARLA COBIAN PONCE', '9931307119', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('827', 'C-100827', '', 'MARY MASARIEGO MASARIEGO', '9932301539', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('828', 'C-100828', '', 'DENISSE CAMPOS OLAN', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('829', 'C-100829', '', 'MARIANA MANZANILLA FOJACO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('830', 'C-100830', '', 'ADRIANA ORTIZ MANZANILLA', '9931172771', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('831', 'C-100831', '', 'JAVIER ANTONIO PEREZ ALVARADO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('832', 'C-100832', '', 'ADRIANA RAMON SANDOVAL', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('833', 'C-100833', '', 'PATRICIA CACERES DE LA FUENTE', '9933112635', '', 'inicia radio facial $1500.00 cada sesion\r\n1-sept-15 radio facial reyna entro 4:42\r\nINICIA MASAJE REDUCTIVO $3000.00 PAGADO\r\ncon medida c-ombligo 98cm y peso 72kg\r\n1.-masaje 45 7/sept/15 fernanda entro 5:15\r\n2.-masaje 45 8/sept/15 fernanda entro 5:00\r\n3.-masaje 45  9/sept/15 fernanda entro 4:55\r\n4.-masaje 45 11/sept/15 fernanda entro 4:50\r\n5.-masaje 45 15/sept/15 fernanda entro 5:00\r\n6.-masaje 45 17/sept/15 fernanda entro 4:35\r\n7.-masaje 45 18-sept-15 charito entro 4:45 \r\n18-sept-15 masaje de pies charito\r\n19-sept-15 radiofrecuencia facial ofelia entro 11:05\r\n8.-masaje 45 21-sept-15 charito entro 4:45\r\n9.-masaje 45 23/sept/15 charito entro 5:00\r\n10.-masaje 45m\r\n25/sept/15 radio facial ofelia entro 1:00\r\n29/oct/15 radio facial reyna entro 3:45\r\n14/nov/15 radio facial lucy entro 11.00\r\n11/dic/15 radio facial ofelia entro 12.45\r\n1/abril/16 facial timexpert vitamina c mary alzaro entro 11:45\r\n20/abril/16 radio facial mariana entro 4:45\r\n23/agosto/16 limpieza facial y radio facial reyna entro 4:40\r\n25/agosto/16 masaje drenaje linfatico mariana entro 5:00\r\n20/mayo/17 promocion antiedad con lifting ofelia entro 12:10\r\n1/julio/17 promocion antioxidante susy entro 11:55\r\n14/agosto/17 radio facial anita entor 4:30\r\n27/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO LUCY ENTRO 12:55\r\n26/FEB/19 PROM TRATAMIENTO FACIAL REAFIRMANTE ANITA ENTRO 4:50\r\n10/MAYO/19 PROM TRATAMIENTO EFECTO BOTOX MONICA ENTRO 11:00\r\n10/JULIO/19 PROM TRATAMIENTO DE COLAGENO HIDROLIZADO LUPITA ENTRO 4:45\r\n7/ENERO/20 TRATAMIENTO FACIAL DESINTOXICANTE OFELIA 4:20\r\n9/ABRIL/2021 PROM. TRATAMIENTO FACIAL VITAMINA C MONICA ENTRO 11:10\r\n7/MAYO/2021 PROMOCION DE CELULAS MADRE MIRENA ENTRO 12:00\r\n29/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE MARIANA  ENTRO 11:00\r\n9/MARZO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE LUCY ENTRO 2:50\r\n12/ABRIL/2022 PROMOCION TRAT CINETICO CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 12:00\r\n18/JULIO/2022 PROMOCION TRAT ROLL & LIFT CON AMP. DESINCRUSTANTE JHOANY ENTRO 9:10\r\n28/JULIO/2022 LIMPIEZA FACIAL 2 X 600 CON AMP. CANNABIS DE AINHOA OFELIA ENTRO 11:00\r\n28/ABRIL/2023 PROMOCION TRAT. FACIAL PLASMA MARINO CON AMP. DESINCRUSTANTE KARLA ENTRO 11:00\r\n13/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND CON AMP. DESINCRUSTANTE KARLA ENTRO 4:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-12 20:58:06', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('834', 'C-100834', '', 'SAMARIA SITLALI HERNADEZ MARTINEZ', '9931908334', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('835', 'C-100835', '', 'JOSE ANTONIO MALTES CUEVAS', '', 'josea_458@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('836', 'C-100836', '', 'DORIS ELENA CUEVAS TEJEDA', '', 'doris 9499@hotmail.com', '21-09-15 SE REALIZO DEP DE AXILA MIRE CRISTAL', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('837', 'C-100837', '', 'YAZMINA COBOS PEREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('838', 'C-100838', '', 'MARGARITA VILLANUEVA ICAMPOS', '', '', '10/MARZO/19 MDM FULL RELAX 2X600 CARMEN ENTRO 6:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('839', 'C-100839', '', 'MARTHA CASTRO ', '', '', '29/SEPTIEMBRE/2020 RADIOFRECUENCIA FACIAL ANITA ENTRO 9:05\r\n10/JULIO/2021 PROM. TRATAMIENTO FACIAL CAVIAR Y ORO ANITA ENTRO 8:05\r\nLLEVO GEL BIO-CONTROL, LOCION BIO-CONTROL', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('840', 'C-100840', '', 'ELFEGO ROMERO MAZARIEGO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('841', 'C-100841', '', 'LAURA ARMERIA TRAPALA', '9932078145', '', '21/nov/17 radiofrecuencia facial mariana entro 10:20\r\n28/nov/17 radiofrecuencia facial mariana entro 9:50\r\n17/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO   Y SE LE PUSO AMP SERUM ENVEJECIDAS DESVITALIZADAS OFE ENTRO 8:20\r\n6/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA YANETH ENTRO 1:00\r\n15/ABRIL/2021 HYDRAFACIAL MARY LAZARO ENTRO 12:00\r\n9/ENERO/2023 MASAJE DESCONTRACTURANTE LUCY ENTRO 10:05\r\n30/ ENEROM /2023N PROMOCION DEL EMS TRATAMIENTO FACIAL PURIFICANTE MONICA ENTRO 1:15 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-28 17:23:03', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('842', 'C-100842', '', 'MARIA DE LOS SANTOS HERNANDEZ GERONIMO', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('843', 'C-100843', '', 'AMALIA CONCHA GARRIDO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('844', 'C-100844', '', 'PRISILA VERA PADILLA', '9983848914', '', '12/SEPTIEMBRE/2020 LIMPIEZA FACIAL 2X600 LUCY ENTRO 2:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('845', 'C-100845', '', 'CLAUDIA HERNANDEZ ZAMORA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('846', 'C-100846', '', 'LAURA DIAZ ROMERO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('847', 'C-100847', '', 'DIANA GONZALEZ MACIAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('848', 'C-100848', '', 'KARINA MERINO PRIEGO', '', '', '26/noviembre/16 mdm full relax 2x500 charito entro 1:10 (mega)\r\n19/MARZO/18 MDM FULL RELAX DE CLIENTE FRECUENTE LUCY ENTRO 2:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('849', 'C-100849', '', 'MARIA JOSE JIMENEZ SOLANA', '9933113714', '', '30/dic/15 limpieza facial lizvet entro 2:10\r\n16/feb/16 depilacion de bikini mariana entro 5:05\r\n14/junio/16 depilacion de bikini mary lazaor entro 11:00\r\n17/agosto/16 limpieza facial 2x600 anita entro 1:10\r\n7/nov/16 depilacion de bikini reyna entro 11:45\r\n4/ene/17 limpieza facial 2x600 mariana entro 11.00\r\n30/agosto/17 limpieza facial 2x600 ofelia entro 11:00\r\n4/oct/17 limpieza facial 2x600 mariana entro 12:20\r\n11/01/18 LIMPIEZA FACIAL 2 X 600 ANITA ENTRO 6:15\r\n24/NOV/18 LIMPIEZA FACIAL REYNA ENTRO 12:40\r\n13/FEB/19 DEPILACION BRASILEÑA LUCY ENTRO 4:20\r\n13/FEB/19 LIMPIEZA FACIAL MARY CARMEN ENTRO 5:00\r\n13/FEB/19 LIFTING TIMEXPERT RIDES MARY CARMEN LLEVO CREMA HYDRACURE PIEL MIXTA\r\n13/febrero/19 depilación de bigote susy 11:00 mega (no quiso q se le aplicara crema nectar la reviso doñ rosy y salió bien)\r\n24/ABRIL/19 LIMPIEZA FACIAL 2 X 600 ANITA ENTRO 11:45\r\n3/JUNIO/19 DEPILACION CON CERA BRASILEÑA T OFELIA ENTRO 12:50\r\n10/SEPT/19 PROMOCION OXIGENANTE ANITA ENTRO 9:50\r\n11/SEPT/19 DEPILACION BRASILEÑA MARY LAZARO ENTRO 12:00\r\n2/DICIEMBRE/2020 TRATAMIENTO FACIAL DE PORCELANA MARY LAZARO ENTRO 2:25\r\n25/FEB/2021 PROM. TRATAMIENTO FACIAL PEEL OFF MARIANA ENTRO 8:55\r\nLLEVO CREMA HYDRACTIVA PIELES NORMALES A MIXTAS\r\n14/ABRIL/2021 LIMPIEZA FACIAL ANITA ENTRO 9:05\r\n21/MAYO/2021 LIMPIEZA DE ACNE PROFUNDA CON AMPOLLETA STABALLIZING DE NATURA, DEPILACION DE BIKINI ANITA ENTRO 10:40 LLEVO ROLL-ON-SPOT S.O.S PUREXPERT GERMAINE. \r\n27/MAYO/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ANITA ENTRO 11:00\r\n8/JUNIO/2021 LIMPIEZA DE ACNE CON AMP DESINCRUISTANTE ANITA  ENTRO 10:55\r\n23/JUNIO/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE, DEPILACION DE BIKINI JHOANY ENTRO 12:20\r\n20/JULIO/2021 LIMPIEZA DE ACNE BASICA MARIANA ENTRO 11:54 \r\n25/AGOSTO/2021 LIMPIEZA DE ACNE MARIANA ENTRO 11:55\r\n8/SEPT/2021 LIMPIEZA DE ACNE MARY LAZARO ENTRO 6:00 \r\n21/SEPT/2021 LIMPIEZA DE ACNE LUCY\r\n21/SEPT/2021 DEPILACION CON CERA DE BIKINI OFELIA\r\n28/SEPT/2021 LIMPIEZA DE ACNE LUCY ENTRO 10:05\r\n5/OCTUBRE/2021 LIMPIEZA DE ACNE  LUCY ENTRO 9:50\r\n13/OCT/2021 LIMPIEZA DE ACNE LUCY ENTRO 11:00 \r\n27/OCT/2021 LIMPIEZA DE ACNE LUCY ENTRO 11:00 LLEVO LOCION BIOCONTROL \r\n5/NOVIEMBRE/2021 LIMPIEZA DE ACNE OFELIA ENTRO 12:50\r\n1/DICIEMBRE/2021 LIMPIEZA DE ACNE  Y DEPILACION DE BIKINI MARIANA ENTRO 10:00\r\n9/MARZO/2022 DEPILACION CON CERA DE BIKIMI MARIANA ENTRO 10:00\r\n9/MAYO/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JHOANY ENTRO 11:50\r\n30/JUNIO/2022 LIMPIEZA DE ACNE Y DEPILACION CON CERA DE BIKINI  MARY LAZARO ENTRO 11:00\r\n23/AGOSTO/2022 LIMPIEZA DE ACNE MARIANA ENTRO 11:50\r\n9/MARZO/2023 LIMPIEZA DE ACNE OFELIA ENTRO 11:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-08 17:57:07', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('850', 'C-100850', '', 'JUANITA MORALES JIMENEZ', '9332094568', '', '23/junio/09 limpieza de acne con amp. desincrustante araceli entro 6:15 \r\n13/agosto/09 limpieza facial 2 x 1 lupita entro 5:15 \r\n9/sept/09 promocion termico de azuleno sara entro 11:20 llevo crema renove de ojos\r\ntimexpert 19/sept/09 reyna entro 11:00\r\njalea real 11/nov/09 entro lupita 10:30\r\nhidrasoin\r\nexcell therapy\r\nrevitase\r\ncaviar\r\nseda y perla\r\ntimexpert lift\r\nnota lifting anticuperosis (ojeras ) $450c/s\r\n26/sept/09 llevo go-expressions, emulsion de perla, crema de ojos de perla, \r\ngel desmaquillante purificante germaine, locion piel grasa de germaine\r\n17/nov/09 infinitime gladys entro 1:30 \r\n26/nov/09 limpieza de acne lupita entro 5:30\r\n23/ene/10 limpieza de acne con amp. desincrustante lupita\r\n5/marzo/10 limpieza de acne con amp. balancing extract sara entro 10:00\r\n29/marzo/10 limpieza de acne indira entro 12:20 \r\n21/abril/10 fotoelectroporacion ofe entro 10:45 \r\n28/abril/10 skinlight mascara lucy entro 8:20 \r\n24/mayo/10 skinlight mascara rosy\r\n24/mayo/10 exfoliacion corporal karina entro 10:30\r\n10/junio/10 skinlight mascara mary lazaro entro 3:00\r\n20/julio/10 trat. facial begoña marina entro 11:00\r\n3/agosto/10 infinitime mary lazaro entro 5:00\r\n12/agosto/10 vitamina c de germaine, limpieza capilar gladys \r\n10/sept/10 trat de caviar gladys entro 9:45 \r\n20/oct/10 trat. de caviar mary lazaro entro 3:15 \r\n9/nov/10 infinitime araceli entro 9:55\r\n7/dic/10 celulas madres de manzana sara entro 11:10\r\n22/ene/11 strategist refine, lifting excel therapy o2 mary lazaro entro 10:00\r\n3/feb/11 trat. facial control de grasa karina entro 8:10 \r\ncarbo $350 400 c/c \r\nen brazos derechos, brazos izquierdos, \r\npierna derecha e izquierda, busto,y gorditos\r\n1.-9/sept/09 rosita\r\n2.-12/sept/09 lucy\r\n3.-14/sept/09 rosy \r\n4.-19/sept/09 reyna\r\n5.-21/sept/09 mary\r\n6.-26/sept/09 reyna\r\n7.-28/sep/09 ofe entro 11:20\r\n8.-3/oct/09 lupita\r\n9.-5/oct/09 lucy 10:30\r\n10.-10/oct/09 reyna\r\n11.-12/oct/09 gladys\r\n12.-17/oct/09 mary entro 11:00\r\n13.-19/oct/09 mary \r\n14.-11/nov/09 lupita \r\n15.-17/nov/09 gladys \r\ntermino\r\n\r\n\r\n11/nov/09 cavitacion lupita\r\n\r\ninicia carbo\r\n1.-23/ene/10 carbo lupita\r\n2.-28/ene/10 gladys entro 12:25\r\n3.-3/feb/10 lucy entro 2:50\r\n4.-5/marzo/10 sara\r\n5.-12/marzo/10 sara entro 9:05 salio 9:20\r\n6.-18/marzo/10 sara entro 5:40\r\n7.-26/marzo/10 sara\r\n8.-29/marzo/10 rosy\r\n9.-31/marzo/10 lucy entro 11:45\r\n10.-12/abril/10 lupita\r\n11.-23/abril/10 lucy \r\n12.-26/abril/10 lupita\r\n13.-28/abril/10 lucy\r\n14.-24/mayo/10 lupita\r\n15.-4/junio/10 lupita \r\ntermino.\r\n\r\n1.-8/sept/10 karina entro 9:30\r\n2.-10/sept/10 gladys entro 9:45\r\n3.-21/sept/10 rosy\r\n4.-24/sept/10 sara \r\n5.-8/oct/10 sara\r\n6.-20/oct/10 karina\r\n7.-1/nov/10 gladys\r\n8.-9/nov/10 gladys\r\n9.-7/dic/10 sara\r\n10.-22/ene/11 lucy\r\n11.-31/ene/11 gladys entro 2:55\r\n12.-3/feb/11 karina \r\n13.-23/feb/11 karina\r\n14.-24/feb/11 gladys\r\n15/marzo/11  gladys\r\n16.-29/marzo/11 carbo sara\r\n23/feb/11 depilacion de bigote karina entro 1:05 \r\n se realizo trat. hydracure y se realizo liftin  de pepino 15/marzo/11 mary l\r\n29/marzo/11 depilacion de bigote y cejas sara entro 12:12\r\n30/abril/11 limpieza de acne con amp. desincrustante, carbo, depilacion de bigote gladys\r\n26/mayo/11 carbo ofelia entro 10:00\r\n26/mayo/11 exfoliacion de cuerpo deyanira entro 10:15\r\n26/mayo/11 mdm con aroma, facial celulas madres de manzana, lifting excel therapy o2, depilacion de\r\nbigote gladys entro 11:30\r\n16/junio/11 carbo reyna entro 4:47\r\ntermino 15 sesiones de carbo.\r\n\r\ninicia de nuevo la carbo\r\n1.-21/junio/11 carbo karina \r\n2.-29/julio/11 carbo, promocion de amaranto con ampolleta desincrustante, depilacion de cejas,\r\nbigote y piernas completas, gladys entro 12:20\r\n3.-18/agosto/11 exfoleacion de cuerpo vitamina c, carbox,tratamiento facial, depilacion bigote\r\n y cejas\r\ngladys entro 12:30\r\n4.-06/sept/11 carbo y masaje sensorelax gladys entro 10:30\r\n17/sep/11 dep. pierna completa carvox gladys entro 12:35\r\n5.- carbox ofelia\r\n6.- carbox gladys\r\n7.- carbox rosa \r\n8.- 19/oct/11 rosa \r\n\r\n10/sept/11 trat. completo hidronutritivo , depilacion bigote y cejas karina entro 9:55\r\n\r\n1.- 03/oct/11 inicio tratamiento de new lift. rosy\r\n2.- mewlift rosa entro 11:20\r\n3.- newlift rosa entro 11.30\r\n4.- newlift rosa entro 12:30\r\n5.- new lift gladys entro 8:15 depilacion de cejas y bigote\r\n6.- mew lift gladys entro 10:05\r\n7.- newlift gladys entro 8:55 19/oct/11 \r\n 8.- new lift, gladys 21/oct/11\r\n\r\n21/oct/11 carvox dep. pierna, rizado de peztaña gladys\r\n28/oct/11 carbox gladys entro 11:00\r\n \r\n19/oct/11 mdm, se llevo crema de vientre plano una cuellera, crema de jazmin, espuma de ducha energi\r\n31/oct/11 carbox gladys entro 9:50\r\n08/nov/11  carbox, hidracure gladys entro 10:45\r\n09/nov/11 carbox gladys\r\n12/nov/11 carbox gladys entro 1:00\r\n\r\n09/nov/11 dep. bigote, exfo vc, m de aromas gladys entro 10:30\r\ncompro vacuna de terapia celular con un costo de $40,500.00\r\n15/nov/11 carbo gladys \r\n15/nov/11 pago $6,680.00 de 2 vitaminas de terapia celular\r\n18/nov/11 inicio con la terapia celular\r\n21/nov/11 carbo sara entro 12:00\r\n28/nov/11 carbo, termoslim, caviar mariana entro 10:30\r\n6/dic/11 carbo sara entro 6:05\r\n9/ene/12 depilacion de cejas y bigote karina entro 9:55\r\n18/ene/11 lumicell lucy entro 9:15 dejo pagada 2 sesiones mas de lumicell\r\nlumicell pagado ya se lo hizo el 8/marzo/12\r\nlumicell pagado ya se lo hizo el 9/marzo/12\r\n18/ene/12 depilacion de piernas completas con amp. depifin, strategist lucy entro 9:15\r\n9/feb/12 promocion 3 geles, depilacion de cejas y bigote sara entro 10:40\r\n23/feb/12 depilacion de piernas completas gladys entro 12:30\r\n7/marzo/12 carbo gladys entro 1:15\r\n7/marzo/12 relleno sng 5m tiene $5,000.00 de saldo a favor\r\n8/marzo/12 exfoliacion de cuerpo vitamina c gladys \r\n8/marzo/12 lumicell gladys\r\n9/marzo/12 lumicell gladys \r\n9/marzo/12 carbo gladys\r\ninicia tratamiento $8000.00\r\n1.-cavitacion 40 m, masaje 30 m 12/marzo/12 gladys entro 12:25\r\n2.-carbox, aspired 20 m, v f en seco 20 m 13/marzo/12 gladys\r\n3.-dermo 14/marzo/12 gladys entro 12:35\r\n4.-lumicell 19/marzo/12 reyna\r\n5.-carbo, presoterapia 40 m 20/marzo/12 gladys entro 8:20\r\n6.-aspired 20 m, v f 20 m 22/marzo/12 gladys\r\n7.-laser lipolitico 23/marzo/12 gladys\r\n8.-carbo, lumicell 27/marzo/12 gladys entro 12:20\r\n9.-termoslin 28/marzo/12 gladys entro 12:30\r\n10.-cavitacion 40 m, masaje 30 m 30/marzo/12 gladys entro 11:10\r\n\r\n7/marzo/12 rell sng suved vp 5 m dr. oscar\r\n10/marzo/12 prp dr. oscar\r\n20/marzo/12 depilacion de cejas y bigote gladys\r\n24/marzo/12 depilacion de piernas completas, micro gladys entro 11:15\r\n4/mayo/12 bioxidea, depilacion de bigote karina entro 12:45\r\n18/mayo/12 depilacion de piernas completas karina, trat de caviar gladys entro 12:05\r\n25/mayo/12 exfoliacion de cuerpo vit c, carbo, limpieza capilar de chocolate aracely entro 9:45\r\n25/mayo/12 dejo pagado el rizado de pestañas viene mas tarde\r\n7/junio/12 mdm aroma vainilla, facial excel therapy 02 sara entro 1:55\r\n6/julio/12 carbo ofelia\r\n6/julio/12 mdm aromas lucy entro 1:15\r\n12/julio/12 carbo, depilacion de bigote, mdm holistico reyna entro 12:25\r\n12/julio/12 timexpert white \r\n20/julio/12 carbo karina entro 2:55\r\n20/julio/12 mdm aromas karina entro 2:55\r\n6/agosto/12 exf.vitamina c,dep.bigote,dep.cejas y carbo entro12:10\r\n7/agosto/12 rizado de petañas y compro crema para celulitis atache aracely\r\n8/agosto/12 capsula graciela entro 12:15\r\n9/agosto/12 dep.de piernas completa con cera aracely entro 2:20\r\n10/agosto/12 se realizo trat. de infinitime reyna entro 10:25\r\n28/sept/12 vit c natura bisse, lifting # 2 bego entro 11:45\r\n17 de oct 2012 empezo homeopatia trat 0 dieta 13 dias se hizo carbox se depilo pierna completa y big\r\nbigote atendio mariana peso 79kilos y medio\r\n19/oct/12 carbo reyna entro 12:20\r\n22/oct/12 carbo, capsula araceli entro 12:15\r\n22/oct/12 depilacion de cejas araceli\r\n24/oct/12 carbo reyna \r\n27/oct/12 carbo reyna\r\n27/oct/12 jalera real royal jelly reyna entro 12:40\r\n29/oct/12 carbo reyna\r\n29/oct/12 llevo trat # 1 peso 77 1/2 kilo\r\n31/oct/12 carbo, capsula araceli entro 1:55\r\nreinicia tratamiento \r\n11.-carbo, aspired 20 m, v f 20 m 26/nov/12 gladys entro 11:15\r\n26/nov/12 mdm drenaje linfatico gladys entro 1:00\r\n12.-lumicell 27/nov/12 gladys entro 11:25\r\n13.-laser 20 m, tabla 10 m, masaje 45 m 28/nov/12 gladys\r\n28/nov/12 carbo gladys\r\n28/nov/12 depilacion de cejas y bigote gladys\r\n14.-corpo 29/nov/12 gladys\r\n15.-aspired 20 m, v f 20 m 30/nov/12 gladys\r\n29nov12 atendio gladis se aplico el corpo y se hizo promocion de colageno  entro 1130\r\nsalio 1 matriz se depilo pierna completa atendio gladis\r\n30/nov/12 carbo gladys\r\n16.-capsula 3/dic/12 gladys \r\n17.-laser, tabla, masaje 4/dic/12 gladys entro 10:30\r\n4/dic/12 carbo gladys\r\n4/dic/12 exfoliacion de cuerpo vit c gladys entro 10:30\r\n18.-carbo, termo 5/dic/12 gladys entro 11:30\r\n19.-aspired, vf 6/dic/12 gladys entro 11:50\r\n20.-carbo, dermosonic 7/dic/12 gladys entro 8:05\r\ntermino tratamiento de celulitis.\r\n6/dic/12 promocion de oro gladys entro 11:50\r\n10/ene/13 abono $22,750.00 para una terapia celular de su esposo\r\n23/ene/13 carbo, depilacion de piernas completas, bigote, facial diamond lucy entro 12:00\r\n20/feb/13 promocion catiodermia con amp. equilibrante, depilacion de cejas y bigote ofelia \r\n27/feb/13 carbo, mdm combo, facial oxigenante de nb reyna entro 9:30\r\n20/marzo/13 depilacion de cejas, bigote y piernas completas gladys entro 11:20\r\n22/marzo/13 carbo, mdm gladys entro 8:25\r\n22/marzo/13 facial vita c nb ofelia entro 9:40\r\n24/abril/13 facial vit c atache, lifting nb, depilacion de bigote lucy entro 11:40\r\n25/abril/13 depilacion de piernas completas, cejas, mdm holistico mariana entro 11:30\r\n30/abril/13 facial diamond, exfoliacion diamond lucy entro 11:30 llevo spot diminish timexpert white\r\n6/mayo/13 exfoliacion aclarante, mdm drenaje linfatico lucy entro entro 10:15\r\n13/mayo/13 promocion relajante e hidratante yusiria entro 9:15\r\n29/mayo/13 mdm combo, reflexologia podal yusiria entro 9:35\r\n5/junio/13 depilacion de piernas, bigote, promocion coco y mango reyna entro 2:45\r\n5/junio/13 reflexologia podal martha \r\n11/junio/13 mdm full relax mariana entro 2:00\r\n11/junio/13 facial inhibit 3d nb bego entro 3:00\r\n19/junio/13 mdm aromas graciela entro 3:30\r\n19/junio/13 facial inhibit 3d bego entro 5:00\r\n20/junio/13 depilacion de bigote, cejas, rizado de pestañas lucy entro 10:45\r\n6/sept/13 depilacion de piernas, bigote, cejas, promocion lifitng antiarrugas mariana entro 10:45\r\n10/sept/13 the cure gladys entro 11:50 llevo tonico diamond mist d nb\r\n25/ene/14 carbo lucy\r\n25/ene/14 facial the cure natura bisse bego entro 11:30 empezo peptonas drenante de grasa\r\n27/ene/14 carbo rosy entro 9:10\r\n27/ene/14 mdm combo lucy entro 9:30\r\n29/ene/14 carbo lucy entro 8:55\r\n31/ene/14 carbo lucy\r\n19/feb/14 depilacion de cejas, bigote, piernas completas reyna entro 9:00\r\n19/feb/14 mdm de aromas reyna\r\n19/feb/14 trat. facial begoña bego entro 11:10\r\n21/marzo/14 limpieza de acne con amp. desincrustante y amp. piel grasa de atache mariana entro 10:40\r\n2/abril/14 facial royal jelly bego entro 11:05\r\n4/abril/14 depilacion de piernas completas, bikini, cejas, bigote reyna entro 5:20\r\n7/abril/14 mdm aroma mariana entro 10:00\r\n7/abril/14 parche zona lumbar bego\r\n7/abril/14 facial despigmentante de atache bego entro 11:00\r\n12/abril/14 the cure ofelia entro 9:05\r\n12/abril/14 liftin n.b. ofelia entro 9.05\r\n14/abril/14 rizado de pestaña, exfoliante con vitamina c, cavitacion, mb vita c yusi entro 9:00\r\n14/abril/14 capilar nelli entro 9:00\r\n17/mayo/14 prp $7000.00 relleno sng $6000.00 relleno labios $6000.00 botox cara $5000.00\r\nbotox cuello $5000.00\r\n28/mayo/14 micro con amp. de colageno y multivitaminas bego entro 10:30\r\n28/mayo/14 lifting natura bisse, depilacion de cejas bego\r\n12/junio/14 mdm aromas mirena entro 9:30\r\n12/junio/14 facial aqua, lifting de natura bisse reyna entro 11:00\r\n26/junio/14 facial natura bise diamond lucy entro\r\n26/junio/14 depilacion de bigote y cejas ofelia\r\n01/julio/14 exfoliacion de cuerpo diamond ofelia entro 11:00\r\n01/julio/14 masaje holistico lucero entro 11:40\r\n01/julio/14 facial the cure sra bego entro 12:45\r\n01/julio/14 carboxiterapia sra bego \r\n09/oct/14 mdm aromas lucero, depilacion piernas comp. bigote, ceja ofelia,\r\ny limpieza facial mariana entro 8:40  \r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n19/julio/14 mdm linfatico reyna entro 9:30\r\n19/julio/14 rizado de pestaña \r\ninicia tratamiento corporal $4500.00 pagado\r\n1.-22/julio/14 drenaje linfatico mirena entro 9:25\r\n2.-23/julio/14 drenaje linfatico mirena entro 8:40\r\n3.-ultrasonido 30 m, drenaje 30 m 25/julio/14 mirena entro 1:00\r\n4.-ultrasonido 30 m, drenaje 30 m  26/julio/14 mirena entro 8:40\r\n5.-ultrasonido 30 m, drenaje 30 m 30/julo/14 yusiria entro 8:40\r\n6.-ultrasonido 30 m, drenaje 30 m  30/julio/14 yusiria entro 8.40\r\n7.-ultrasonido 30 m, drenaje 30 m  04/agosto/14  nelli entro 9:10\r\n8.-ultrasonido 30 m, drenaje 30 m  04/agosto/14 nelli entro 9:10\r\n9.-ultrasonido 30 m, drenaje 30 m  05/agosto/14 nelli entro 9:00\r\n10.-ultrasonido 30m drenaje 30m 05/agosto/14 nelli entro 9:00\r\n05/agsoto/14 depilacion de bigote nelly\r\ninicia ultrasonido $4500.00 pagado\r\n1.-ultrasonido 30m, drenaje 30m 06/agosto/14  nelli entro 9:15\r\n2.-ultrasonido 30m, drenaje 30m 06/agosto/14  nelli entro 9:15\r\n3.-ultrasonido 30m, drenaje 30m 07/agosto/14 nelli entro 9:25\r\n4.-ultrasonido 30m, drenaje 30m 07/agosto/14 neli entro 9:25\r\n7/agosto/14 contorno de ojos natura bisse \r\n7/agosto/14 times liff \r\n5.-ultrasonido 30m, drenaje 30m 4/sep/14 brenda entro 10:40\r\n6.-ultrasonido 30m, drenaje 30m 27/oct/14 yusiria entro 8:50\r\n7.-ultrasonido 30m, drenaje 30m 27/oct/14 yusiria entro 8:50\r\n8.-ultrasonido 30m, drenaje 30m 28/oct/14 yusiria entro 8:30\r\n9.-ultrasonido 30m, drenaje 30m 28/oct/14 yusiria entro 8:30\r\n10.-ultrasonido 30m, drenaje 30m 30/oct/14 yusiria entro 2:30\r\ndrenaje 30m yusiria entro 2.30\r\n3/sep/14 mdm mirena entro 4:30\r\n3/sep/14 the cure mirena 5:30\r\n3/sep/14 dep bigote y cejas mirena entro 5:30\r\n11/sept/14 diamond life infusion bego entro 12:45\r\n11/sept/14 exfoliacion diamond reyna\r\n22/oct/14 rizado de pestañas ya lo tenia pagado yusiria\r\n22/oct/14 mdm drenaje linfatico, facial ceutical, depilacion de cejas yusiria entro 8:50\r\n27/oct/14 dep de bogote yusiria entro 9:30\r\n28/oct/14 plasma rico en plaquetas c/celulas madres $11000.00 dr. oscar garcia\r\n28/oct/14 plasma rico en plaquetas cintura $2000.00 dr. oscar garcia\r\n28/oct/14 relleno $600.00 dr. oscar garcia \r\n28/oct/14 relleno de labios $6000.00  dr. oscar garcia \r\n28/oct/14 botox $5000.00 dr. oscar gacia\r\n28/oct/14 botox (cuello) $5000.00 dr. oscar garcia\r\ninicia tratamiento de drenaje linfatico $4500.00 pagado\r\n1.-drenaje 31/oct/14 yusiria entro 12:00\r\n2.-drenaje 31/oct/14 yusiria entro 1:00\r\n3.-drenaje 1/nov/14 mirena entro 1:45\r\n4.-drenaje 1/nov/14 mirena entro 1:45\r\n5.-drenaje 4/nov/14 carmen \r\n6.-drenaje 4/nov/14 carmen\r\n4/nov/14 micro carmen entro 12:00 llevo activador de celulas madres\r\n7.-drenaje 8/nov/14 yusiria entro 11:25\r\n8.-drenaje 8/nov/14 yusiria entro 11:25\r\n9.-drenaje 10/nov/14 yusiria entro 9:15\r\n10.-drenaje 10/nov/14 yusiria entro 9:15\r\ntermino tratamiento\r\ninicia tratamiento de drenaje linfatico $4500.00 pagado\r\n1.-drenaje 11/nov/14 yusiria entro 9:10\r\n2.-drenaje 11/nov/14 yusiria entro 9:10\r\n3.-drenaje\r\n4.-drenaje\r\n5.-drenaje\r\n6.-drenaje\r\n7.-drenaje\r\n8.-drenaje\r\n9.-drenaje\r\n10.-drenaje\r\n10/dic/14 facial diamond life infusion, depilacion de bigote y cejas lucy entro 9:50\r\n27/enero/15 facial the cure y carbox mariana entro 4:15\r\n14/feb/15 depilacion de bigote, cejas sra. bego\r\n30/marzo/15 dep. piernas completas, bigote y cejas mariana entro 3:15\r\n30/marzo/15 mdm aromatico maribel entro 4.10\r\n21/abril/15 prp c/madres $12000.00, rsng $6000.00, botox$5000.00, \r\nrinoplastia volumia $1000.00 dr. oscar llevo peptonas\r\n27/abril/15 carbox mirena entro 8.30\r\n28/abril/15 llevo contorno de ojos de diamond \r\n29/abril/15 cabox mirena entro 9:00\r\n2/mayo/15 carbo mariana entro 9:00\r\n6/mayo/15 carbox, dep de brasileña/Rectal y bigote ana entro 4:30\r\n6/mayo/15 dejo pagado baño de cleopatra y promocion facial de catiodermia\r\n9/mayo/15 carbo lucy entro 1:15\r\n19/mayo/15 baño de cleopatra y promocion catiodermia el que tenia pagado  mirena 1:45\r\n27/junio/15 depilacion de piernas completas carmen entro 11:15\r\n27/junio/15 depilacion de cejas, bigote, brasileña lucy entro 11:15\r\n27/juio/15 facial the cure natura bisse, lifting # 2 lucy entro 11:15\r\n27/junio/15 dejo pagada la exfoliación diamond rose \r\n27/junio/15 llevo limpiadora facial ácida, oxygen perfecting oil de nb (aceite seco hidrata, nutre y\r\ntonifica)\r\n6/nov/15 facial the cure y dep de cejas y bigote mariana entro 9:40\r\n6/nov/15 carboxiterapia mariana\r\n13/nov/15 facial diamond white lucy entro 2:50\r\n4/dic/15 facial diamond white y carbo mariana entro 3:30\r\n4/dic/15 depilacion de bikini y piernas completas candy entro 3:30\r\n3/feb/16 depilacion de bikini, cejas, bigote, mdm full relax, promocion Roll & lift massage reyna entro 3:25\r\n21/abril/16 facial the cure, dep de bigote y cejas reyna entro 12.10\r\n21/abril/16 lleco crema reafirmante especifico al colageno de germaine de capuccini\r\n21/abril/16tx b 1/3 sup $6000.00, b p pomulo voluma $8000.00 drt. oscar garcia\r\n29/julio/16 micro y limpieza de acne con amp. equilibrante de coalgeno mary lazaro\r\n17/agosto/16 depilacion de cejas y bigote reyna\r\n20/agosto/16 limpieza de acne con amp. desincrustante rosy entro 9:25\r\n27/agosto/16 limpieza de ance con amp. desicnrustante rosy entro 9:40\r\n27/agosto/16 masaje hydrtante rosy entro 11:00\r\n3/sept/16 limpieza de acne con amp. desincrustante maria entro 12:35\r\n14/sept/16 limpieza de acne profunda con amp. serum equilibrante susy entro 9:15\r\n14/sept/16 depilacion brasileña total, piernas completas, cejas mary lazaro entro 10:35\r\n14/sept/16 masaje hidratante  anita entro 12:35\r\n24/sept/16 limpieza de acne con amp. desicnrustante ofelia entro 11:30\r\n24/sept/16 depilación de bigote 30ms 10j ofelia\r\n1/oct/16 promocion de coalgeno maria entro 11:20\r\n25/oct/16 bigote 30ms 10j lucy\r\n16/nov/16 depilacion de piernas y bikini ofelia entro 9.15\r\n16/nov/16 masaje full relax charito entro 10:00\r\n16/nov/16 bigote 30ms 10j ofelia\r\n23/nov/16 promocion oxigenate y lifting de colageno mary lazaro entro 10:40\r\n16/dic/16 depilacion de piernas,bikini cejas y carbox reyna entro 11:35\r\n16/dic/16 bigote 30ms 12j reyna\r\n16/dic/16 dejo pagada un promocion del mes multivitaminico\r\n16/dic/16 promocion trat multivitamínico y lifting#2 lucy entro 4:00( la que estaba pagada)\r\n13/ene/17 depilacion de cejas , carbox, promocion desintoxicante mariana entro 4:40\r\n13/ene/17 bigote 0ms 12j lucy\r\n13/feb/17 carbox lucy entro 4:00\r\n13/feb/17 masaje hidratante y limpieza de acne con amp. desincrustante y equilibrante de grasa carmen entro 4:15\r\n13/feb/17 dep bigote 30ms 12j lucy\r\n21/feb/17 carbox, promocion trat de elastine susy entro 2:00\r\n6/marzo/17 promocion estimulante de colageno con masc led andrea entor 12:40\r\nINICIA CARBOXITERAPIA $350.00 CADA SESION\r\n8/marzo/17 CARBOX LUCY ENTRO 11:30\r\n27/marzo/17 depilacion de piernas completas, bikini mariana entro 1:00\r\n27/marzo/17 7ta. bigote 30 ms 13 j lucy\r\n24/abril/17 promocion termico, lifting # 2, depilacion de cejas lucy entro 11:30\r\n24/abril/17 8ta. bigote 30 ms 14 j lucy\r\n8/mayo/17 mdm aromas, promocion antiedad con lifting mariana entro 12:10\r\n9/junio/17 depilacion de bikini anita entro 12:50\r\n9/junio/17 5ta. bigote autom. 14 j ofelia\r\n26/julio/17 depilacion de piernas y bikini ofelia\r\n 26/julio/17 promocion trat relajante e hidratante ofelia entro 3:15\r\n26/julio/17 bigote 30ms 10j ofelia\r\n7/nov/17 termoslim, depilacion de bikini, promocion termico-humectante anita entro 11:50\r\n24/JULIO/18 FACIAL DESAFIO ANTIEDAD  MARY ENTRO 11:10\r\n24/JULIO/18 LLEVO TOALLITAS DESMAQUILLANTES, CREMA TIMEXPERT WHITE, SERUM TIMEXPERT WHITE Y SPOT DIMINISH\r\n20/OCT/18 DEPILACION CON CERA DE BIKINI SRA BEGO\r\n13/NOV/18 MDM FULL RELAX, PROM TRATAMIENTO FACIAL DE POLUCIÓN Y DEPILACION DE BIGOTE CON CERA MONICA- KARLA  ENTRO ENTRO 10:45\r\n5/DIC/18 DEPILACION CON CERA DE BIKINI REYNA ENTRO 3:50\r\n6/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE LUPITA ENTRO 4:50\r\n6/DIC/18 DEJO PAGADO 2 FACIALES DE 650.00 TOTAL 1,300\r\n13/DIC/18 TRATAMIENTO FACIAL DIAMANTE  BELÉN ENTRO 4:55\r\n20/DIC/18 PROMOCION DIAMANTE REYNA ENTRO 11:00\r\n21/FEBRERO/19 DEPILACION DE PIERNAS COMPLETAS, BIKINI Y PROM TRATAMIENTO FACIAL DIAMANTE ANITA ENTRO 1:00\r\n15/ABRIL/19 FACIAL REVERSE, LIFTING DE TIMEXPERT RIDES CON AMP DE COLÁGENO, DEPILACION DE PIERNAS COMPLETA Y DE BIKINI Y LLEVO CREMA TIMEXPERT IN DE CUELLO Y ESCOTE  OFELIA\r\n16/ABRIL/19 CARBOX, MASAJE COMBO Y LLEVO CREMA C+C DE VITAMINA C DE NATURA BISSE REYNA Y OFELIA ENTRO 2:30\r\n26/ABRIL/19 REVERSE Y AMP CLARIFICANTE OFELIA ENTRO 12:35\r\n19/DIC/2020 MASAJE LASAI, PROMOCION TRAT PORCELANA JHOANY ENTRO 12:05\r\n7/MAYO/2021 PROMOCION CELULAS MADRE MONICA ENTRO 4:50 \r\n27/MATO/2022 MASAJE LASAI  LUCY   Y PROM. TRATAMIENTO FACIAL FITO-HIDRANTANTE Y LIFTIN DE COLAGENO OFELIA ENTRO 9:40\r\n****LLEVO HELIOCARE COMPACT****\r\n23/JUNIO/2022 FACIAL STABALAZING DE NATURA BISSE MARIANA ENTRO 500\r\n****LLEVO SERUM HYDRACURE Y CREMA HYDRACTIVA PIELES NORAMLES A MIXTAS *******', 'no', 'activo', '2021-12-07 00:49:45', '2022-06-23 16:51:33', '1', '25', null, null);
INSERT INTO `clientes` VALUES ('851', 'C-100851', '', 'ALEJANDRA CORTAZAR RICARDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('852', 'C-100852', '', 'MARIA DEL CARMEN DOMINGUEZ DOPORTO', '9931171716', 'cadoporto@hotmail.com', '7/NOVIEMBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 9:10\r\n8/NOVIEMBRE/2022 DEPILACION CON CERA DE PATILLAS MARIANA ENTRO 10:00', 'no', 'activo', '2021-12-07 00:49:45', '2022-11-07 16:53:45', '1', '6', null, null);
INSERT INTO `clientes` VALUES ('853', 'C-100853', '', 'MIRIAM GUADALUPE CRUZ TOLENTINO', '99 32605229', '', '17/NOVIEMBRE/19 TRATAMIENTO DE PERLAS C/AMP DESINCRUSTANTE SANDY ENTRO 20/MARZO/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE ROSY ENTRO 1:08 (MEGA) ******NO QUEDO A GUSTO CON EL SERVICIO****', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-18 19:38:12', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('854', 'C-100854', '', 'ALICIA CARIDAD SALAZAR GUTIERREZ', '9932426216', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('855', 'C-100855', '', 'MELINA PEREZ DOMINGUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('856', 'C-100856', '', 'GILBERTO PUNARO GALAN', '9931084437', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('857', 'C-100857', '', 'MERCED RAMIREZ ALPIZAR', '9931634390', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('858', 'C-100858', '', 'GLADYS MORALES GARCIA', '9932073054', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('859', 'C-100859', '', 'XIMENA BALTIERRA GUZMAN', '9932425765', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('860', 'C-100860', '', 'GAMALIEL COLI ALCAZAR', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('861', 'C-100861', '', 'CATALINA CASTILLO CORDOVA', '9331017291', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('862', 'C-100862', '', 'LOYDA DE LA CRUZ ASCENCIO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('863', 'C-100863', '', 'ZENAIDA GODINEZ HERNANDEZ', '9933982991', '', '21/dic/15 limpieza facial lizvet entro 1:30\r\n21/dic/16 limpieza facial 2x600 andrea entro 11:40\r\n12/julio/17 limpieza facial 2x600 yeni entro 6:05\r\n31/ENERO/18 LIMPIEZA FACIAL 2X600 OFELIA ENTRO 9:15 SE LE APLICO AMPOLLETA  BEAUTE II\r\n05/noviembre/18 limpieza facial 2x600 rosy entro 6:55 (mega)\r\n29/OCTUBRE/19 LIMPIEZA FACIAL 2X600 JANETH ENTRO 2:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('864', 'C-100864', '', 'VIVIANA ALEJANDRA REYES ORTIZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('865', 'C-100865', '', 'KATHERINE PACHECO JIMENEZ', '7821280672', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('866', 'C-100866', '', 'VILLAHERMOSA MARTIN  AGUILAR', '9931986331', 'portadaempresarial@hotmail.comxml', '10/02/04 limpieza facial tete\r\n11/05/04 limpieza facial rosy\r\n11/09/04 limpieza facial mary lazaro\r\n09/12/04 limpieza facial yesy\r\n12/04/05 limpieza facial marcela\r\n26/nov/05 promocion hidratante con lifting ofelia\r\n20/marzo/06 limpieza facial reyna\r\n29/junio/06 promocion efecto botox mary lazaro\r\n13/oct/06 limpieza facial tana entro 12:25\r\n2/dic/06 limpieza facial mary lazaro entro 11:20\r\n29/ene/07 limpieza facial mary lazaro entro 5:20\r\n30/marzo/07 promocion antiarrugas gladys entro 11:25\r\n11/junio/07 limpieza facial mary lazaro entro 3:10\r\n30/julio/07 limpieza facial 2 x 1 lucy entro 12:00\r\n06/oct/07 limpieza facial mary lazaro \r\n01/dic/07 promocion vitamina c marcela entro 11:40\r\n9/ene/08 limpieza facial bety entro 12:00 \r\n12/marzo/08 promocion criogenico reyna entro 10:45 \r\n19/abril/08 promocion botanico odet entro 12:30 \r\n31/mayo/08 limpieza facial bety entro 12:10 \r\n16/julio/08 limpieza facial araceli entro 1:30 \r\n14/agosto/08 limpieza facial reyna entro 10:40\r\n24/oct/08 limpieza facial reyna entro 10:20\r\n9/dic/08 promocion vitamina c mary lazaro entro 4:15 \r\n20/feb/09 promocion percollagen lupita entro 5:25 \r\n30/marzo/09 limpieza facial mary lazaro entro 3:10 \r\n19/agosto/09 limpieza facial bety entro 2:20\r\n5/nov/09 promocion de limpieza facial con lifting reyna entro 12:00\r\n22/dic/09 limpieza facial marina entro 3:10 \r\n19/feb/10 limpieza facial sara entro 3:30 \r\n24/marzo/10 limpieza facial 2 x 1 lucy entro 4:15 \r\n3/julio/10 limpieza facial mary lazaro entro 11:00 \r\n15/sept/10 promocion termico indira entro 12:45 \r\n28/oct/10 promocion efecto botox con \r\namp. piel grasa de lendan araceli entro 1:05 salio 2:50\r\n1/junio/11 limpieza facial 2 x 1 karina entro 5:05\r\n05/04/11 limpieza facial atendio indira entro 4:00 pm salio 5:30 (sucmega)\r\n13/07/11 limpieza facial atendio deyanira entro 3:05 salio 4:56 pm (sucmega)\r\nle gusta que se le ponga doble algodon en sus ojos y al poner el vapor son 5min ,que la extraccion \r\nsea profunda y que la nariz no le hagan tan fuerte, pero que si le extraigan bien.\r\n13/agosto/11 promocion limpieza facial 2x1  aracely entro a las 12:00\r\n13/sep/11 limpieza facial  susy entro 3:15\r\n01/11/10 limpieza facial 2x1, dep de bigote y patilla, amp hydracure atendio:deyanira entro:1:40pm \r\nsalio:  3.15 (suc mega)\r\n6/02/12 limp facial 2x1 atendio deyanira entro 2:00 (mega)\r\n14/03/12 limp facial 2x1 atendio jhoany entro 5:00 (mega)\r\n4/agosto/12 promocion hidratante y reafirmante reyna entro 12:15\r\n4/10/12 lim. facial atendio jhoany entro 2:05 mega\r\n10/11712 lim facial atendio jhoany entro 3:20 mega\r\n4/enero/13 lim. facial 2x1 atendio jhoany entro 2:05 mega\r\n12/03/13 promocion del mes atendio brenda entro 4.45 mega \r\n24/04/13 lim. facia atendio brenda entro 3:35 mega \r\n17/07/13 promocion de julio colageno y  elastine nelly mega\r\n31/10/13 promocion the verde nelly mega 3:00\r\n07/sept/14 promocion trat azteca nely entro 11:45 (mega)\r\n27/dic/14 promocion del mes trat. global antiedad candy entro 1:56 (mega)\r\n07/agosto/15 prom. del mes chocoterapia susy entro 1:55 (mega)\r\n16/octubre/15 prom. del mes trat. reafirmante rosy entro 3:30 (mega)\r\n27/diciembre/15 promocion del mes tratamiento reafirmante rosy entro 2:55 (mega)\r\n10/abril/16 prom. del mes trat. luxury susy entro 12:10 (mega)\r\n29/mayo/16 prom. del mes trat. colageno susy entro 3:10 (mega)\r\n31/agosto/16 prom. del mes caviar charito entro 4:00 (mega)\r\n13/octubre/16 prom. del mes colageno rosy entro 11:15 (mega)\r\n21/enero/17 limpieza facial mary lazaro entro 1:45\r\n8/dic/17 promocion trat gold mariana entro 11:35\r\n02/MARZO/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE 2 X 600 MARY ENTRÓ 6:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('867', 'C-100867', '', 'ANA BERTHA ALVAREZ CASASUS', '9931082593', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('868', 'C-100868', '', 'VERONICA MOGUEL CORNELIO', '9931385795', '', '10/DIC/18 DELINEADO DE CEJAS OFELIA', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-14 17:02:33', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('869', 'C-100869', '', 'ELSY GARCIA GONZALES', '9932008737', '', '4/nov/15 limpieza facial 2x600 reyna entro 4:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('870', 'C-100870', '', 'MILAGRO VAZQUEZ ESCOBAR', '9932776494', '', '14-02-16 se realizo limp facial martha cristal micro  3pm\r\n17/abril/16 limpieza de acne con amp. desincrustante charito entro 1:05 (mega)\r\n30/julio/16 limpieza de acne con amp. desicnrustante ofelia entro 9:55\r\n1.-3/dic/16 facial desafio antiedad nb mariana entro 11:05\r\n2.-VITAMINA C NB (ya)\r\n3.-TIMEXPERT EXCEL THERAPY O2 (YA)\r\n4.-TIMEXPERT RIDES (YA)\r\n3/DIC/16 FILTRO SOLAR DE DIAMOND NB, EMULSIÓN EXCEL THERAPY 02, CONTORNO DE OJOS DE EXCEL THERAPY 02.\r\n10/dic/16 facial vitamina c natura vise reyna entro 11:10\r\n17/dic/16 facial timexpert excel therapy 02 ofelia entro 10.55\r\n17/dic/16 llevo emulsion de excel therapy 02\r\n26/dic/16 facial timexpert rides reyna entro 4:55\r\n8/julio/17 limpieza de acne con amp. desincrustante mary lazaro entro 10:45\r\n14/julio/17 micro anita entro 6.05\r\n2/agosto/17 limpieza de acne con amp. desincrustante lizvet entro 6:10\r\n29/sept/17 skinlight completo lucy entro 4:15\r\n4/nov/17 micro cristales ofe entro 10:10\r\n11/nov/17 limpieza facial con amp. desincrustante, micro cristales monica entro 9:45\r\n18/nov/17 limpieza de acne con amp. desincrustante, micro cristales anita entro 11:10\r\nINICIA DEPILACION LASER DE AXILA $360.00 C/S \r\n18/nov/17 1ra. axila autom. 10 j lucy\r\n6/dic/17 limpieza de acne con amp. desincrustante susy entro 4:15\r\n19/12/17 DEP AXILA AUT12J MARY \r\n19/01/18 DEP AXILA AUT 12J, PANTORRILLAS AUT 10J REYNA\r\n9/MARZO/18 PANTORRILLA AUT 14 J  AXILA  AUT 14 J SRA BEGO\r\n13/ABRIL/18 PANTORRILLA AUT 15J LUCY\r\n18/MAYO/18 DEP LASER DE PANTORRILLA AUT 16 J,  AXILA AUT 16 MARY\r\n16/JUNIO/2021 INICIA TRATAMIENTO DE IPL MANMCHAS PROG 1 INT 5 MARY LAZARO\r\nLLEVO  TONICO CLARIFICANTE\r\n22/JUNIO/2021 LASER  PANTORRILLASY AXILA  AUT 17J MARY LAZARO\r\n22/JUNIO/2021 LASER YAG  MANCHAS OFELIA, LLEVO HELIOCARE 360 \r\n16/JULIO/2021 DERMANPEN, MASCARILLA DE CUELLO DE NATURA BISSE OFELIA ENTRO 4:30 \r\n30/JULIO/2021 TRATAMIENTO FACIAL DE AINHOA ANITA ENTRO 5:05\r\n12/MAYO/2022 LLEVO LOCION BIO-CONTROL\r\n12/MAYO/2022 INICIA LASER BRASILEÑO AUT 10J Y AXILA  AUT 15J  MARY LAZARO\r\n2/JUNIO/2022 LASER BRASILEÑO AUT 11J MARY LAZARO\r\n2/JUNIO/2022 RADIOFRECUENCIA FACIAL MARIANA ENTRO 4:30\r\n7/JUNIO/2022 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO 4:55\r\n17/JUNIO/2022 RADIOFRECUENCIA FACIAL LUCY ENTRO 4:50 \r\n28/JUNIO/2022 RADIOFRECUENCIA FACIAL MARY LAZARO ENTRO  5:00\r\n5/JULIO/2022 RADIOFRECUENCIA FACIAL MARIANA ENTRO 5:00 \r\n13/JULIO/2022 RADIOFRECUENCIA FACIAL JOHANY ENTRO 5:00\r\n20/JULIO/2022 LASER DE CARBONO LUCY ENTRO 6:00\r\n3/AGOSTO/2022 RADIOFRECUENCIA FACIAL MARIANA ENTRO 4:00\r\n17/AGOSTO/2022 3RA  LASER  BRASILEÑO  AUT 11J LUCY ENTRO 5:50\r\n17/AGOSTO/2022 6TA PANTORRILLAS AUT 10J\r\n17/AGOSTO/2022 9ª  AXILA AUT 15J LUCY\r\n18/AGOSTO/2022 RADIOFRECUENCIA FACIAL JHOANY\r\n14/SEPTIEMBRE/2022 PEELING QUIMICO JHOANY ENTRO 6:05\r\nLLEVO GEL DESMAQUILLANTE\r\n30/SEPTIEMBRE/2022  2DA  PEELING QUIMICO LUCY ENTRO ENTRO 5:10\r\n7/OCTUBRE/2022 TRATAMIENTO DE CUELLO Y AMP. DESINCRUSTANTE LUCY\r\n14/OCTUBRE/2022 LIMPIEZADE ACNE CON AMP. DESINCRUSTANTE LUCY ENTRO 5:00\r\n17/OCTUBRE/2022 PEELING QUIMICO PARA MARCAS Y MANCHAS MARIANA ENTRO 9:05 AGUANTO BIEN, NO LE ARDIO Y NO SE FUE ROJA.\r\n31/OCTUBRE/2022 PEELING QUIMICO JHOANY\r\n*****ULTIMA SESION DE PEELING POR EL MOMENTO HASTA NUEVA VALORACION********\r\n18/NOVIEMBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CRISTINA ENTRO 5:40\r\n25/NOVIEMBRE/2022 LIMPIEZA DE ACNE CON AMPOLLETA DESINCRUSTANTE LUCY ENTRO 5:58 \r\nLLEVO ESPUMA 365, CREMA CUELLO Y ESCOTE DE CASMARA\r\n2/DICIEMBRE/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE CRISTINA ENTRO 6:00\r\n21/DICIEMBRE/2022 FACIAL SKIN LIGHT MARIANA \r\n21/DICIEMBRE/2022 7ª LASER PANTORRILLAS 30MS 15J MARY LAZARO \r\n21/DICIEMBRE/2022 20ª  AXILA AUT 15J ENTRO 3:50\r\n26/DICIEMBRE/2022 4TA. BRASILEÑA AUTOM. 11 J MARY LAZARO\r\n9/ENERO/2023 FACIAL OXIGENANTE DE CASMRA MARIANA ENTRO 5:10\r\n24/ENERO/2023 FACIAK  MANCHAS DE CASMARA JHOANY ENTRO 5:10\r\n7/FEBRERO/2023 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ARIANA ENTRO 6:00\r\n8/FEBRERO/2023  INICIA VENDAS CALIENTES $4000.00 PAGADO\r\nMEDIDA EN ABDOMEN (OMBLIGO) 91 CM LLEVO CREMA CHAUFFANTE\r\n1.-VENDAS CALIENTES 8/FEBRERO/2023 JHOANY 5:55\r\n2.-VENDAS CALIENTES 9/FEBRERO/2023 JHOANY ENTRO 6:00\r\n3.-VENDAS CALIENTES 27/FEBRERO/2023 JHOANY ENTRO 6:00\r\n4.-VENDAS CALIENTES\r\n5.-VENDAS CALIENTES\r\n6.-VENDAS CALIENTES\r\n7.-VENDAS CALIENTES \r\n8.-VENDAS CALIENTES\r\n9.-VENDAS CALIENTES\r\n10.-VENDAS CALIENTES\r\n8/MARZO/2023 LUZ PULSADA IPL PROG 2 INT 3 LUCY ENTRO 3:50\r\n28/ABRIL/2023***********SE ROMPIO EXPEDIENTE*************\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-13 08:44:04', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('871', 'C-100871', '', 'JEHOVAH SORONDO GUEVARA', '5537068472', 'jehovahsorondo29@gmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('872', 'C-100872', '', 'ROSY SANCHEZ GONZALEZ', '9933930990', 'rochy_sanchezg@hotmail.com', '27/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELAN ALE ENTRO 10:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('873', 'C-100873', '', 'ARNOL SANCHEZ GONZALEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('874', 'C-100874', '', 'SOCORRO CELIS DE BARCELO', '9932203237', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('875', 'C-100875', '', 'JENNIFER MARTINEZ UY', '', '', '23/feb/11 promocion trat. de seda mariana entro 4:13 \r\n28/feb/11 promocion trat. de seda, depilacion de bigote y cejas araceli entro 5:10\r\n15/junio/12 promocion reafirmante aracely entro 11:10\r\n22/junio/12 promocion reafirmante aracely entro 10:50\r\n17/julio/2012 limpieza facial con ampolleta desincrustante sara entro 11:05\r\n15/sept/12 limpieza de acne con amp. desincrustante reyna entro 12:15\r\n29/junio/15 limpieza facial con amp. desincrustante reyna entro 1:00\r\n25/nov/15 promocion antiedad humectante y nutritivo lizvet entro 12:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('876', 'C-100876', '', 'ELVIA PATRICIA VERA PADILLA', '9931536740', '', '24/abril/16 limpieza facial 2x600 andrea entro 12:10 (mega)\r\n01/mayo/16 limpieza de acne 2x600 susy entro 5:15 (mega)\r\n27/mayo/16 limpieza facial 2x600 andrea entro 2:55 (mega)\r\n18/agosto/16 limpieza facial 2x600 charito entro 6:55 (mega)\r\n02/septiembre/16 limpieza facial 2x500 carmen entro 6:50 (mega)\r\n20/enero/17 limpieza facial 2x600 lizbeth entro 6:40 (mega)\r\n06/mayo/17 limpieza de acne 2x600 anita entro 4:10 (mega)\r\n07/junio/17 limpieza facial 2x600 rosy entro 6:55 (mega)\r\n17/agosto/17 limpieza facial 2x600 andrea entro 7:00 (mega)\r\n15/enero/18 limpieza facial 2x600 candy entro 3:55 (mega)\r\n31/enero/18 limpieza facial 2x600 candy entro 7:10 (mega)\r\n21/junio/18 limpieza facial 2x600 monica entro 7:10 (mega)\r\n09/enero/19 limpieza facial 2x600 susy entro 7:00 (mega) se le reviso a la entrada y en la extraccion se le volvio a preguntar que como la estaban atendiendo que si no le molestaba la extraccion y dijo que todo bien, se le reviso a la salida y todo bien.\r\n18/SEP/19 LIMPIEZA FACIAL 2X600 ROSY ENTRO 7:00 MEGA\r\n26/01/2021 limpieza facial 2x1 atendio rosi suc mega\r\n24/AGOSTO/2021 LIMPIEZA FACIAL 2X600 ROSI ENTRO 16:54 MEGA\r\n17/SEPTIEMBRE/2021 LIMPIEZA FACIAL 2X600 ROSI ENTRO 14:55 MEGA\r\n13/OCT/2021 LIMPIEZA FACIAL 2X600 MONICA ENTRO 16:06 MEGA\r\n12/JULIO/2022 LIMPIEZA FACIAL 2X600  SUSY ENTRO 4:48  MEGA\r\n05/ ENERO/2023 LIMPIEZA FACIAL EN PROMOCION DE 2 PERSONAS ROSY ENTRO 7:05 (MEGA)\r\n28/ ENERO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL PURIFICANTE  MINICA ENTRO 10:00 (MEGA)\r\n25/MARZO/2023 DUO LIMPIEZA FACIAL BASICA MONICA ENTRO 1:00 (MEGA)\r\n12/JULIO/2023 DUO LIMPIEZA FACIAL BASICA MONI ENTRO 6:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-12 19:11:18', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('877', 'C-100877', '', 'JENNIFER ANDRADE MARTINEZ', '', '', '16/JUNIO/2022 LIMPIEZA FACIAL PROFUNDA JHOANY ENTRO 11:05', 'no', 'activo', '2021-12-07 00:49:45', '2022-06-15 17:38:42', '1', '25', null, null);
INSERT INTO `clientes` VALUES ('878', 'C-100878', '', 'MONSERRAT MONTEJO CANEPA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('879', 'C-100879', '', 'SERGIO MONTEJO CANEPA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('880', 'C-100880', '', 'CARINA RUTH DOMINGUEZ REZA', '9931439890', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('881', 'C-100881', '', 'LAURA PALACIOS ZARATE', '9931650422', '', '23/julio/16 masaje drenaje linfatico reyna entro 8:00\r\n2/OCT/18 MDM DRENAJE LINFATICO Y PROM TRATAMIENTO FACIAL REAFIRMANTE  LUPITA ENTRO 11:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('882', 'C-100882', '', 'LILIANA SANTIZ MENDEZ', '9932253436', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('883', 'C-100883', '', 'ANGEL WADE BAEZA', '9931974778', '', '24/ENE/19 LIMPIEZA FACIAL 2 X 600 SUSI ENTRO 4:05 MEGA\r\n17/JUNIO/2022 LIMPIEZA FACIAL 2X600 MONICA ENTRO 4.10\r\n28/SEPTIEMBRE/2022 LIMPIEZA FACIAL DE PROMOCION DE 2 PERSONAS SUSY ENTRO 5:00 (MEGA)\r\n29/ NOVIEMBRE/2022 LIMPIEZA FACIAL EN PROMOION DE 2 PERSONAS MONICA ENTRO 5:00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-11-28 18:18:49', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('884', 'C-100884', '', 'ALEJANDRO DURAN ENRIQUEZ', '9931940404', '', '20/MAYO/19 MASAJE DESCONTRACTURANTE REYNA ENTRO 12:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('885', 'C-100885', '', 'ALAN DURAN ENRIQUEZ', '9931940404', '', '08/enero/16 limpieza facial 2x1 con ampolleta desincrustante  andrea entro 5:40 (mega)\r\n06/junio/16 limpieza de acne charito entro 12:00 (mega)\r\n09/julio/16 limpieza de acne 2x600 charito entro 11:00 (mega)\r\n12/OCT/2021 MASAJE FULL RELAX 2X600 ROSI ENTRO 8:50 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('886', 'C-100886', '', 'YULIANA HERNANDEZ DE WADE', '', '', '23/02/11 limpieza facial 2x1 atendio: graciela. entro 6:35pm. salio 7:35pm(suc)\r\n7/11/12 lim. facial 2x1 atendio brenda entro 7:00 mega\r\n19/09/13 limp. facial 2x1 graciela mega 6:15\r\n25/MAYO/2022 LIMPIEZA FACIAL 2X600 MONICA ENTRO 14.55 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('887', 'C-100887', '', 'LISBETH BERENICE ESPINOSA ESPINOSA', '9931324382', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('888', 'C-100888', '', 'ELVERI FIGUEROA ESCUDERO', '9171036092', '', 'inicia pidele al tiempo que vuelva $1000.00 c/s     \r\n28/sept/09 micro-hydrasoin reyna entro 6:30 \r\nse le recomendo crema contorno de ojos formen y fluido facial matificante formen\r\nmicro-excell therapy 5/oct/09 lupita entro 6:10\r\nmicro-revitase 12/oct/09 mary lazaro entro 6:05\r\nmicro-timexpert 19/oct/09 reyna entro 6:00 \r\n27/nov/09 promocion reestructurante reyna entro 2:00\r\n15/marzo/10 promocion de cristal marina entro 10:20\r\n20/julio/10 promocion relajante e hidratante mariana entro 6:15 \r\n29/ene/11 promocion porcelana susy entro 10:30 \r\nllevo crema contorno de ojos jabotiere, gel oil-control\r\n25/mayo/11 promocion botanico sara entro 2:25\r\n21/ene/13 depilacion de piernas completas mariana entro 10:45\r\n21/ene/13 promocion lifting de parpados gladys entro 10:15 llevo fluido facial matificante de formen\r\ny rollon contorno de ojos formen\r\n18/marzo/13 promocion royal jelly carmen entro 1:00\r\n1/nov/13 promocion intensivo antiestres mirena entro 12:30\r\n29/abril/14 depilacion de piernas completas reyna entro 6:00\r\n22/mayo/14 promocion facial hidratante reyna entro 6:00 llevo fluido facial matificante, serum ojos \r\nantifatiga formen\r\n27/dic/14 promocion global antiedad lucy entro 9:40\r\n27/dic/14 llevo crema de hidratacion activa, fluido facial matificante y serum formen\r\n10/febrero/15 fluido facial matificante, serum facial y serum ojos antifatiga  \r\n6/junio/15 promocion antioxidante mariana entro 11:45\r\n6/junio/15 llevo emulsion de juventud excel therapy 02\r\n27/oct/15 promocion reafirmante charito entro 4:50l llevo fluido facial matificante de formen \r\n23/ene/16 promocion desintoxicante carmen entro 11:35 llevo fluido facial matificante de formen y crema facial de hidratación activa de formen ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('889', 'C-100889', '', 'MIGUEL TOLEDO CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('890', 'C-100890', '', 'ALEJANDRA ALDAY SANTIAGO', '', 'ale@alday.hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('891', 'C-100891', '', 'ERIKA ALDAY SANTIAGO', '9931775457', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('892', 'C-100892', '', 'MARIA EUGENIA DIAZ DE LA CRUZ', '9931027861', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('893', 'C-100893', '', 'ELIANA FERREIRA VILLALOBOS', '9932423277', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('894', 'C-100894', '', 'DENISSE CARBAJAL BADILLO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('895', 'C-100895', '', 'JANET PALMA VILLANUEVA', '9931273170', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('896', 'C-100896', '', 'PATRICIA RUIZ GONZALEZ', '9931161561', '', '14/feb/17 masaje full relax lucy entro 12.10\r\n19/sept/17 mdm full relax, promocion resveratrol anita entro 4:15\r\n13/FEB/18 INICIA TRATAMIENTO REDUCTIVO (PAGADO 3,000)\r\nCON MEDIDAS CINTURA-OMBLIGO 96 Y PESO 73 1/2\r\n1.- CARB, MASAJE 45   14/FEB/18 ANITA ENTRÓ 1:05\r\n2.- MASAJE 45, G-5 10M   15/FEB /18  ANITA Y LIMPIEZA FACIAL ENTRÓ  1:00 \r\n3.- CARB, MASAJE 45      16/FEB/18 ANITA ENTRÓ 9:00\r\n4.- MASAJE 45 G-5 10M   17/FEB/18 ANITA ENTRO 8:05\r\n5.- CARB, MASAJE 45    19/feb/18  ANITA ENTRÓ 9:10\r\n6.- MASAJE 45 G-5 10M  20/FEB/18 ANITA ENTRÓ 9:15\r\n7.- CARB MASAJE 45     21/FEB/18 REYNA ENTRO 9:15\r\n8.- MASAJE 45  G-5 10M    22/FEB/18 ANITA ENTRÓ 9:15\r\n9.- CARB, MASAJE 45    23/FEB/18 ANITA ENTRÓ 9:10\r\n10.- MASAJE 45 G-5 10M\r\n\r\n*******************INICIA TRATAMIENTO REDUCTIVO*****************\r\nPESO:70.5 KG\r\nABDOMEN: 88 CM.\r\nBUSTO: 105 CM.\r\nCINTURA: 92 CM.\r\nCADERA ALTA: 104 CM.\r\nCADERA BAJE: 108 CM.\r\nBRAZO: 34 CM.\r\nMUSLO. 70 CM.\r\nDIETA DE LOS 13 DIAS, CAVITACION EN ABDOMEN\r\n1.-MASAJE 45 M 23 SEPTIEMBRE/ 2022 MONICA ENTRO 5:05 (MEGA)\r\n2.-CAVITACION Y MASAJE\r\n3.-MASAJE 45 M.\r\n4.- MASAJE 45 M.\r\n5.-CAVITACION Y MASAJE\r\n6.-MASAJE 45 M.\r\n7.-MASAJE 45 M.\r\n8.-CAVITACION Y MASAJE\r\n9.-MASAJE 45 M.\r\n10.- MASAJE 45 M.\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2022-09-23 17:52:19', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('897', 'C-100897', '', 'YOLANDA MONDRAGON AGUILAR', '9932301110', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('898', 'C-100898', '', 'SUGEY GONZALEZ AVALOS', '9933200538', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('899', 'C-100899', '', 'BRENDA PADRON RIVERA', '9335933071', '', '16/ene/07 promocion relajante e hidratante carmita entro 6:00\r\n29/ene/07 promocion relajante e hidratante gladys entro 3:15 salio 4:30\r\n21/feb/07 promocion ginseng reyna entro 5:20\r\n10/marzo/07 limpieza facial lupita entro 1:00\r\n24/marzo/07 hydrasoin rosy entro 12:40\r\n7/mayo/07 promocion antiarrugas y reafirmante marcela entro 6:35\r\n14/junio/07 promocion trat. de cristal reyna\r\n16/julio/07 promocion colageno marcela entro 6:00\r\n30/julio/07 promocion colageno ligia entro 5:55\r\n09/agosto/07 promocion regenerador antioxidante odet entro 5:25\r\nhacerle tratamientos en gel. nada en crema porque le queda brillosa la cara.\r\n terminar con locion biocontrol y gel sebum control.\r\n24/sept/07 promocion colageno rosy entro 5:15\r\n18/dic/07 promocion vitamina c julia entro 5:10\r\n27/dic/07 limpieza capilar bety entro 6:00 \r\n28/julio/12 mdm sensorelax atendio jeny entro 5:50 mega\r\n9/agosto/08 promocion regenerador antioxidante lucy entro 12:30 \r\n6/sept/08 promocion modeladora julia entro 11:50 \r\n26/dic/08 promocion vitamina c lucy entro 4:00 \r\n7/MAYO/21PROMOCION CELULAS MARES ROSITA ENTRO 11:20MEGA\r\n9/SEPTIEMBRE/2022 PROMOCION DEL MES TRATAMIENTO PREVENTIVO DE MANCHAS MONICA ENTRO 10:00 MEGA\r\n6/abril/09 promocion spa therapy oro mary entro 6:25 \r\n23/julio/09 promocion extraperformance araceli entro 6:30 \r\n30/sep/09 promocion termico de azuleno entro mary montes 5:35\r\n26/dic/09 promocion flash beaute mary lazaro entro 10:20\r\n19/abril/10 promocion 3 geles karina entro 2:15 \r\n27/oct/10 limpieza facial 2 x 1 karina entro 2:20 \r\n26/nov/10 promocion modeladora marina entro 2:00\r\n24/feb/11 promocion trat. de seda reyna entro 2:00 \r\n30/04/11 limpieza fac. atendio: jhoana. entro:5:15pm salio:6:15pm(suc)\r\n27/08/11 limpieza facial mdm 2x1 atendio graciela entro 4.30 pm salio 6:35 (suc mega) con amp desinc\r\n10/09/11 limpieza facial 2x1 atendio  graciela entro 6:05 pm salio (suc mega) con amp. desinc\r\n04/11/11 limpieza facial 2x1 atendio dulce entro 3:15 salio 4.30 (mnga)\r\n10/12/11 trat.velo de colageno atendio jhoany entro 1.02 (mega) \r\n22/dic/11 exfoliacion de cuerpo, mdm sensorelax, promocion velo de colageno mariana entro 9:55\r\n18/ene/12 promocion revitalizante mariana entro 1:25\r\n11/02/12 limp facia mdm 2x1 atendio deyanira entro 3.50 (mega) amp desc.\r\n03/03/12 limp facial 2x1 atendio deyanira entro 5.51 (mega amp desinc.\r\n06/05/12 limp facial 2x1 atendio brenda entro alas 1:55 mega\r\n31/05/12 serealizo un 2x1 de mdm atendio graciela entro 1:55 (mega)\r\n29/julio/12 limpieza facial 2x1 atendio jeny entro 12:20 mega\r\n29/agosto/12 mdm aroma de frutas sara entro 5:30\r\n2/09/12 lim. facial 2x1 atendio jeny entro5:05 mega\r\n20/09/12 lim. facial 2x1 atendio brenda entro 3:30 mega\r\n24/11/12 lim. facial 2x1 atendio jenifer entro 2:25 mega\r\n19/05/13 lim. facial 2x1 atendio nelly entro 12:00 mega \r\n13/07/13 promocion de julio colageno y elastine matha mega \r\n28/07/13 limp. facial 2x1 nelly mega 2.00\r\n22/09/13 limp. facial 2x1 jhoany  mega 3:00\r\n05/01/14 lim de acne atendio mirena mega 5:05\r\n16/03/14 li facial c/amp serum 2x1 susi mega 11:50\r\n17/mayo/14 promocion masaje holistico, facial hidratante mirena entro 10:30\r\n26/07/14 lim facial 2x1 con amp acido hialuronico candy mega 1:05\r\n23/09/14 lim facial 2x1 con amp serum equilibrante atendio brenda cristal 1.30\r\n03/octubre/14 promo, tratamietno facial smoothie martha entr4o 10.05 (mega)\r\n26/10/14 serealizo promocion del mes atendo susy ristal entro ala 3.40\r\n29/dic/14 mdm cliente frecuente, promocion global antiedad ana entro 3:00\r\n10/01/15 serealizo la promocion del mes atendio susy cristal entro alas 3.05\r\n31/01/15 serealizo la promocion del mes atendio mari cristal entro alas 5.05\r\n24/febre/15 promocion del mes reafirmante atendio nelly entro 2.00 mega\r\n01/octubre/15 limpieza facial rosy netro 10:15 (mega)\r\n23/oct/15 promocion reafirmante graciela entro 9:55\r\n13/febrero/16 mdm full relax y limpieza facial 2x1 lizbeth entro 6:15 (mega)\r\n07/junio/16 limpieza facial 2x600 andrea entro 11:20 (mega)\r\n27/agosto/16 limpieza facial 2x600 con amp. desincrustante anita entro 1:10 (mega)\r\n12/ene/17 promocion desintoxicante anita entor 5:55\r\n25/mayo/17 promocion antiedad con lifting, mdm full relax ofelia entro 9:05\r\n01/agosto/17 mdm cliente frecuente y limpieza facial 2x600 andrea entro 01:05 (mega)\r\n08/febrero/18 mdm full relax cliente frecuente monica entro 2:35 (mega) \r\n01/marzo/18 limpieza facial 2x600 rosy entro 6:00 (mega)\r\n12/MARZO/18  PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE LUPITA ENTRO 11:00\r\n20/mayo/18 prom. del mes trat. antiedad lupita entro 12:05 (mega)\r\n21/junio/18 mdm full relax y limpieza facial candy entro 1:05 (mega)\r\n17/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL LUPITA ENTRO 10:10\r\n24/agosto/18 mdm full relax y limpieza facial 2x600 susy entro 12:55 (mega)\r\n04/noviembre/18 prom. del mes trat. contra la polucion de la luz azul lupita entro 1:50 (mega)\r\n15/MARZO/2020 TRATAMIENTO RECUPERADOR FACIAL SUSI ENTRO 11:00 MEGA\r\n25/03/2021promocion del mes tratamiento acido hialuronico atenduio arleth suc mega \r\n27/ABRIL/2021 PROMOCION TRAT. VIT C ARLETH ENTRO 4:00 (SUC. MEGA)\r\n10/JUNIO/2021 PROMO.TRAT. RETINOL ARLETH ENTRO 10:57 MEGA\r\n08/JULIO/2021 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2X600 MONICA ENTRO 12:58 MEGA\r\n30/JULIO/2021 PROMO. TRAT. CAVIAR Y ORO MONICA ENTRO 16:02 MEGA\r\n07/OCT/2021 PROMO. TRAT. ORGANCO CBD MONICA ENTRO 15:34 MEGA\r\n28/OCT/2021 LIMPIEZA FACIAL 2X600 ROSI ENTRO 16:00 MEGA\r\n15/DICIEMBRE/2021 PROM. TRATAMIENTO FACIAL FACE PURE ARLETH ENTRO 11:00\r\n26/ENE/2022 PROMO. TRAT. DETOX MONICA ENTRO 13:00 MEGA\r\n02/MARZO/2022 PROMO. TRAT. SHOCK DE COLAGENO ROSI ENTRO 10:03 MEGA \r\n07/ABRIL/2022 PROMO. TRAT. CINETICO MONICA ENTRO 10:15 MEGA\r\n27/MAYO/2022 MASAJE FULL, RELAX 2X600 ARIANA WNTRO 9:00\r\n23/JUNIO/2022 PROMO- TRAT- YOGA FACIAL ROSI ENTRO 10:00 (MEGA)\r\n03/OCTUBRE/2022 PROMOCION DEL MES TRATAMIENTO FACIAL DE OBSIDIANA MONICA ENTRO 10.45 (MEGA)\r\n19/OCTUBRE /02022 MASAJE FULL RELAX Y LIMPIEZA FACIAL EN PROMOCION PERSONAL MONICA ENTRO 9.50 (MEGA)\r\n13/ ENERO/2023 PROMOCION DL MES TRATAMIENTO FACIAL PURIFICANTE MONICA ENTRO 10:00 (MEGA)\r\n14/ FEBRERO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL ELIXIR DE JUVENTUD  MONICA ENTRO 10:20 (MEGA)\r\n25/ABRIL/2023 PROMOCION DEL MES TRATAMIENTO PLASMA MARINO ENTRO 2:53 MONICA (MEGA)\r\n5/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND KARLA ENTRO 10:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-05 11:30:41', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('900', 'C-100900', '', 'JANET OCHOA VARGAS', '9841040544', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('901', 'C-100901', '', 'ANA LILIA HIDALGO ENRIQUEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('902', 'C-100902', '', 'THELMA JUAREZ CERINO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('903', 'C-100903', '', 'ELMI INES CAB YAH', '', '', '24/feb/11 limpieza facial 2 x 1 reyna entro 5:24 \r\n17/oct/11 limpieza facial 2x1 karina entro 2:40\r\n14/mayo/14 limpieza facial 2x1 nelli entro 8:05\r\n19/agosto/15 limpieza facial 2x600 eva entro 8:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('904', 'C-100904', '', 'THELMA CERINO FRIAS', '9931606118', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('905', 'C-100905', '', 'DAVID ROBLES MENDEZ', '9932426770', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('906', 'C-100906', '', 'JULIO CESAR HIDALGO AGUILAR', '9931604748', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('907', 'C-100907', '', 'DOLORES CECILIA DEL RIO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('908', 'C-100908', '', 'FABIOLA NARANJO CRUZ', '9931477244', 'fabi@hotmail.com', '16/junio/17 prom. del mes trat. antioxidante rosy entro 1:35 (mega)\r\n28/AGOSTO/2021 PROMOCION TRAT. ORGANICO REVITALIZANTE JHOANY ENTRO 8:10\r\n30/SEPT/2021 PROM. TRATAMIENTO FACIAL ISOFLAVONAS DE SOYA ARLETH ENTRO 5:00\r\n22/JULIO/2022 PROM. TRATAMIENTO FACIAL ROLL & LIF ARIANA ENTRO 5:00\r\n5/AGOSTO/2022 HYDRADERMABRASION JHOANY ENTRO 4:05\r\n23/DICIEMBRE/2022 LASER DE CARBONO LUCY ENTRO 10:05\r\n26/DICIEMBRE/2022 DEPILACION DE CEJAS  MARIANA ENTRO 2:05', 'no', 'activo', '2021-12-07 00:49:45', '2022-12-26 13:59:15', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('909', 'C-100909', '', 'ELENA BERNA AYESTARAN', '5554187951', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('910', 'C-100910', '', 'ANA ISABEL POZO ROSALDO', '9931601430', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('911', 'C-100911', '', 'ERIKA HERNANDEZ POZO', '9932546092', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('912', 'C-100912', '', 'JEANNIE PEREZ LEON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('913', 'C-100913', '', 'ELIZABETH MANZUR CEJA', '9932303891', 'mujernueva@prodigy.net.mx', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('914', 'C-100914', '', 'NAYELI FLORES MENDEZ', '9932025770', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('915', 'C-100915', '', 'ISIDORA VEGA', '9931600037', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('916', 'C-100916', '', 'JOSE ARIAS VEGA', '9931600037', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('917', 'C-100917', '', 'PAOLA CASTILLO CADENA', '9931170545', 'castillocadena@hotmail.com', '15/ABRIL/19 MDM FULL RELAX DE VALE REGALO  MARY ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('918', 'C-100918', '', 'CAROLINA FERRER', '', 'carolinaferrer-prieto@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('919', 'C-100919', '', 'ARACELI OLGUIN FERIA', '9931288363', '', '3/oct/10 promocion efecto botox  indira entro 11:15 salio 12:50 (sucursal)\r\n12/dic/10 limpieza facial 2 x 1 indira entro 1:00 (sucursal)\r\n11/feb/11promocion del mes y dep de bigote atendio graciela entro 12:05 salio1:10 sucursal\r\n25/02/11prom.limp.facial. mdm.2x1. atendio: indira. entro 10:30am salio\r\n06/05/11 tratamiento botanico 4 f atendio: rosi entro 12:15 pm salio 1:55 pm ( suc )\r\n15/07/11limpieza facial mdm 2x1 atendio deyanira entro 11.00am salio1.00 pm (suc mega)\r\n08/10/11 limpieza facial 2x1 atendio deyanira entro 12.15 pm salio1:13 (mega) amp. hidracuré\r\n13/11/11 limpieza facial 2x1 atendio jhoany entro 12.05 salio (mega).compro beaute iii \r\n13/12/11 limpieza facial atendio deyanira entro 11:05 (mega) compro amp beaute ii\r\n14/01/12 limpieza facial atendio deyanira entro 11:00 (mega)\r\n10/03/12 lim fac mdm 2x1 atendio brenda entro 11.00 (mega)\r\n01/06/12 mdm drenaje linfatiko atendio brenda entro 10:10 mega\r\n13/06/12 lim. facial 2x1 atendio brenda entro 12:00 mega\r\n  11/agosto/12 limpieza facial 2x1 atendio deyanira entro 1:00 mega\r\n28/11/12 lim. facial y mdm 2x1 atendio diana entro 11:05 mega\r\n11/04/13 promocion del mes atendio brenda entro 10:45 mega\r\n05/07/13 lim. facial 2x1 amp elastine nelly mega 10.20\r\n01/11/13 limp. facial 2x1 nelly mega 1:00 con amp. serum equili.\r\n30/01/14 mdm y lim facial 2x1 atendio mirena mega entro 11:05\r\n08/08/14 lim facial 2x1 con amp beaute iii susi mega 1:10\r\n14/octubre/14 mdm full relax y limpieza facial 2x1 rosy entro 12:00 (mega)\r\n04/septiembre/15 mdm descontracturante y prom. del mes rosy entro 11:00 (mega)\r\n13/mayo/16 prom. del mes masaje y facial charito entro 10:10 (mega)\r\n09/agosto/16 mdm full relax y limpieza facial charito entro 11:05 (mega)\r\n 09/mayo/17 mdm full relax y limpieza facial 2x600 rosy entro 11:05 (mega)\r\n17/julio/18 limpieza facial 2x600 con amp. acido hialuronico rosy entro 12:05 (mega)\r\n2/FEB/19 LIMPIEZA FACIAL 2X600 SUSI ENTRO 6:05 (MEGA)\r\n20/DICIEMBRE/19 TRATAMIENTO 24K SUSI ENTRO 11:15 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('920', 'C-100920', '', 'ALEJANDRA GUADALUPE GARCIA PANTOJA', '9932060754', 'gapa85@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('921', 'C-100921', '', 'FERNANDO HERNANDEZ RAMIREZ', '9931050255', 'her82@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('922', 'C-100922', '', 'VANLLY PRISCILLA TOLEDO ESCOBEDO', '9932456352', '', '28/mayo/16 mdm full relax ofelia entro 10.35', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('923', 'C-100923', '', 'KAROLINI DA ROCHA NOBRE', '5525632040', '', '8/JULIO/19 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE LUPITA ENTRO 9:55\r\n20/NOVIEMBRE/19 LIMPIEZA FACIAL LUPITA ENTRO 4:00\r\n8/ENERO/2021 PROMOCION TRAT ANTIPOLUCION LUCY ENTRO 12:00\r\n21/ENERO/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ANITA ENTRO 12:55\r\n9/FEB/2021 LIMPIEZA FACIAL  2X600 LUCY ENTRO 12:55\r\n11/MARZO/2021 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 12:00\r\n22/MAYO/21 MASAJE FULL-RELAX ARLETH ENTRO 13:00 MEGA\r\n7/ENERO/2022 MASAJE FULL RELAX 2 X 600 ARLETH \r\n7/ENERO/2022  LIMPIEZA FACIAL 2 X 600 MARIANA ENTRO 10:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('924', 'C-100924', '', 'ROCIO ALVAREZ GONZALEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('925', 'C-100925', '', 'MARIA JULIETA PRIEGO DE CHACON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('926', 'C-100926', '', 'ADALICIA DIAZ GUTIERREZ', '9932224340', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('927', 'C-100927', '', 'MARIA EUGENIA GONZALEZ MARTINEZ', '9933114472', '', '21/oct/06 timexpert ofelia\r\n28/oct/06 excel therapy con micro rosy entro 12:20\r\n23/dic/06 promocion navideña trat. nutritivo e hidratante ofelia entro 11:10\r\n02/mayo/07 promocion antiarrugas y reafirmante rosy entro 1:00\r\n03/oct/07 promocion modeladora mary entro 10:55\r\n10/nov/07 promocion hidratante con lifting lucy entro 12:30\r\n8/feb/08 promocion dermorelax mary entro 9:55 .\r\n19/mayo/08 promocion 3 geles bety entro 12:10 \r\n2/julio/08 promocion termico lupita entro 11:45 \r\n14/oct/08 promocion colageno lucy entro 11:10 \r\n21/feb/09 trat. hidro-nutritivo reyna entro 11:20 \r\n8/mayo/09 promocion intensivo parpados y labios lupita entro 1:00 \r\n31/jul/09 promocion extraperforman sara\r\n2/sept/09 promocion trat. termino de azuleno lucy entro 12:15\r\n22/sept/09 so-delicate reyna\r\n5/nov/09 promocion reestructurante ofe entro 10:10\r\n17/dic/09 promocion flash beaute gladys entro 11:40\r\n25/ene/10 promocion vinoterapia lucy entro 11:50\r\n19/feb/10 promocion estimulante de endorfinas con wellbox reyna entro 12:15 \r\n**se va hacer carbo 3 veces por semana, \r\nregresando de viaje el trat. que sigue es el de cavitacion \r\ny en los faciales siempre se le va a incluir el wellbox**\r\notro tratamiento intensivo de rostro es new lift\r\npromocion del mes con wellbox $650.00 \r\n24/marzo/10 promociond e cristal con wellbox rosy entro 11:35 \r\n31/marzo/10 promocion de cristal con wellbox reyna entro 5:15 \r\n26/abril/10 promocion 3 geles con wellbox llevo pack so-delicate\r\n14/mayo/10 trat. facial relajante, lifting # 2 sara entro 10:05\r\n10/julio/10 promocion relajante e hidratante, lifting excel therapy karina \r\n7/agosto/10 promocion antiarrugas con amp. retinol y \r\nlifting go-expressions araceli entro 11:45 \r\n27/sept/10 promocion termico mariana entro 10:35 \r\n16/oct/10 promocion efecto botox gladys\r\n12/nov/10 promocion modeladora araceli entro 5:10 \r\n8/ene/11 promocion porcelana mariana entro 11:00\r\n25/feb/11 mdm sensorelax, promocion trat. de seda karina entro 12:26 \r\n11/abril/11 promocion vinoterapia mary lazaro entro 2:42 \r\n14/mayo/11 promocion botanico deyanira entro 1:00\r\n4/julio/11 promocion de amaranto lucy entro 12:30\r\n10/agosto/11 promocion piel de seda y masaje sensorelax mariana entro 12:10\r\n01/septiembre/11 promocion facial azteca reyna entro 12:30\r\n11/oct/11 promocion relajante gladys entro 2:15\r\n19/nov/11 promocion germen de trigo y vitamina e ofelia entro 1:35\r\n14/ene/12 promocion revitalizante, depilacion de brazos, reflexologia podal lucy entro 12:50\r\n15/feb/12 llevo crema contorno de ojos de timexpert srns\r\n16/feb/12 promocion 3 geles rosy entro 11:20\r\n13/abril/12 promocion revitalizante rosy entro 1:40\r\n13/abril/12 depilacion de brazos aracely\r\n24/mayo/12 promocion velo de colageno karina entro 1:05\r\ninicia corporal $6000.00\r\ncarbo en brazos no\r\n1.-cavitacion 40 m, masaje 45 m 31/mayo/12 rosy entro 10:05\r\n2.-carbo, laser 20 m, tabla 10 m, masaje 45 m 1/junio/12mariana entro 10:00\r\n3.-masaje 45 m, termo 4/junio/12 mariana entro 10:00\r\n4.-carbo, laser 20 m, tabla 10  m, masaje 45 m 5/junio/12 mariana entro 10:00\r\n5.-cavitacion 40 m, masaje 45 m 6/jun/12 mariana entro 9:55 \r\n6.-carbo, laser 20 m, tabla 10, masaje 45 m 8/junio/12 mariana entro 10:00\r\n7.-masaje 45 m, termo 12/junio/12 mariana entro 10:00\r\n8.-carbo, laser 20 m, tabla 10 m, masaje 45 m 13/junio/12 mariana entro 10:00\r\n9.-cavitacion 40 m, masaje 45 m 15/junio/12 mariana entro 10:10\r\n10.-masaje 45 m, termo 19/junio/12 mariana entro 10:15\r\nmaxofilaxia suave, drenaje no\r\n6/junio/12 se realizo el trat. de glycocure\r\n12/junio/12 dejo pagado un trat. glycocure para su sobrina, ella habla para hacer la cita\r\n19/junio/12 promocion reafirmante mariana\r\n21/junio/12 se realizo su sobrina patricia flota el trat glicocure atendio aracely entro 4:30\r\ninicia new lift $8000.00\r\n1.-limpiar, oxigeno, new lift, amp. beaute 2, lifting, masc. porcelana 25/junio/12 reyna entro 2:35\r\n2.-limpiar, oxigeno, new lift, amp. beaute 1, lifting, masc. botanica 26/junio/12 reyna entro 5:05\r\n20/oct/12 promocion reafirmante de cuello bego entro 1:15\r\n23/oct/12 facial de jalea real ofe entro 9:20\r\n23/nov/12 promocion de colageno reyna entro 11:25\r\nreinica el tratamiento de new lift abono $2000.00 resta $6000.00\r\n3.-limpiar, oxigeno, new lift, amp. beaute 2, lifting, masc. porcelana 26/nov/12 sara entro 10:15\r\n4.-limpiar, oxigeno, new lift, amp. beaute 1, lifting, masc. botanica 27/nov/12 sara entro 10:00\r\n5.-limpiar, oxigeno, new lift, amp. beaute 2, lifting, masc. porcelana 28/nov/12 sara entro 1:00\r\n6.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 29nov12 atendio sara entro 1 salio3\r\n7.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 3/dic/12 reyna entro 1:00\r\n8.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 4/dic/12 sara entro 1:00\r\n9.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 5/dic/12 sara entro 1:20\r\n10.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 7/dic/12 sara entro 1:20\r\n5/dic/12 dejo pagada 2 promociones del mes para sus sobrinas patricia flota calvo y \r\nclaudia dominguez gonzalez.\r\n11.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 10/dic/12 sara entro 1:15\r\n12.-limpiar, oxigeno, new lift, amp. beaute 3, masc. modeladora 11/dic/12 sara entro 1:25\r\ntermino tratamiento.\r\n26/ene/13 mdm holistico, promocion lifting de parpados con amp. acido hialuronico gladys entro 11:35\r\n21/feb/13 promocion catiodermia, mdm holistico ofelia entro 12:00\r\n21/feb/13 depilacion de medio brazo reyna\r\n24/abril/13 prp, relleno labios 3,000 dr. oscar\r\n3/mayo/13 micro mariana entro 5:55\r\n12/junio/13 promocion coco y mango mariana entro 2:15\r\n5/sept/13 criolipolisis gladys entro 10:45\r\n5/sept/13 promocion lifting antiarrugas gladys \r\n9/oct/13 criolipolisis en abdomen gladys \r\n9/oct/13 promocion the verde graciela\r\ninicia tratamiento de masaje reductivo $3000.00\r\n1.-carbo, masaje 45 m 14/oct/13 mariana entro 5:20\r\n2.-masaje 45 m  15/10/13 mariana entro 12:10 mega\r\n3.-carbo, masaje 45 m  16/oct/13 mariana entro 12:00\r\n4.-masaje 45 m  17/oct/13 mariana entro 5:00\r\n5.-carbo, masaje 45 m 18/oct/13 mariana\r\n6.-masaje 45 m, aspired 21/oct/13 mariana entro 12:00\r\n7.-carbo, masaje 45 m 22/oct/13 mariana entro 12:20\r\n8.-masaje 45 m 23/oct/13 mariana entro 11:20\r\n9.-masaje 45 m 24/oct/13 mariana entro 12:05\r\n10.-carbo, masaje 45 m  25/oct/13  ana  entro 12:00\r\ntermino tratamiento. pago todo lo que debia.\r\n28/oct/13 terapia de oxigeno ofelia\r\n13/nov/13 promocion intencivo antiestres mariana 12.00\r\n13/nov/13 criolipolisis en piernas reyna 12.00\r\n6/dic/13 criolipolisis en piernas susy entro 1:00\r\n6/dic/13 promocion de oro nelli entro 2:00\r\n24/ene/14 promocion desintoxicante con amp. beaute 1 lucy entro 12:00\r\n7/marzo/14 facial aqua de natura bisse reyna entro 11:30\r\n18/marzo/14 criolipolisis en entrepierna mirena entro 12:05\r\ninicia tratamiento reductivo $6000.00\r\n1.-cavitacion 40 m, masaje 45 m 24/marzo/14 nelli entro 4:10\r\n2.-carbo, masaje 45 m, termo 25/marzo/14 carmen entro 1:20\r\n3.-masaje 45 m, aspired 30 m 26/marzo/14 nelli entro 12:40\r\n27/marzo/14 se le dio de cortesía una sesion de presoterapia\r\n4.-laser lipolitico 20 m, masaje 45 m 31/marzo/14 nelli entro 4:00\r\n5.-carbo, masaje 45 m, capsula 2/abril/14 reyna entro 1:10\r\n6.-masaje 45 m, aspired 30 m 3/abril/14 nelli entro 1:10\r\n7.-carbo, cavitacion 60 m, masaje 45 m 8/mayo/15 mariana entro 12:10\r\n8.-laser 20 m, masaje 45 m 3/nov/15 mariana entro 11:10\r\n10-.MASAJE 45M, V C30\r\n\r\n16/abril/14 promocion lim de porcelana reyna entro 9:00\r\n17/mayo/14 limpieza facial reyna entro 11:00\r\n17/mayo/14 prp $7000.00 botox cara $5000.00 botox cuello $5000.00\r\n11/jun/14 microdermabrasion lucy entro 12:55\r\n15/sept/14 promocion trat facial azteca reyna entro 5:10\r\n24/oct/14 promocion trat smoothie mariana entro 5:10\r\n30/oct/14 plasma rico en plaqueta c/célula madre $11000.00 y botox $5000.00 dr. oscar garcia\r\n03/dic/14 promocion trat global antiedad mirena entro 1:05\r\n22/enero/15 promocion trat desintoxicante y oxigenante lucy entro 1:15\r\n23/enero/15 ilpl progran 2 lucy\r\n9/abril/15 promocion tratamiento de porcelana mariana entro 11.20\r\ninicia tratamiento reductivo completo $8000.00\r\n1.-cavitacion 60m, masaje 45m 13/abril/15 mariana entro 12.00\r\n2.-masaje 45m 14/abril/15 mariana entro 1.00\r\n3.-masaje 45m  radio 40m 16/abril/15 mariana entro 12:25\r\n4.-cavitacion 60m, masaje 45m 20/abril/15 mariana entro 12.00\r\n5.-carbo, masaje 45m, termo 21/abril/15 mariana entro 1:25\r\n6.-masaje 45m ,radio 30m 22/abril/15 ana entro 12:00 abono $4000.00 resta $4000.00\r\n7.-masaje 45m, carbox, corpo 24/abril/15 mariana entro 12:00\r\n24/abril/15 prp con celulas madres $12000.00 y cotox $5000.00 dr. oscar garcia\r\n8.-masaje 45m , termos 4/mayo/15 mariana entro 10:30\r\n9.-carbo, laser 20, masaje 45m 5/mayo/15 mariana entro 12:00\r\n10.-masaje 45m, criolipolisis 60m 6/mayo/15 mariana entro 1.55\r\n8/mayo/15 llevo serum recuperador intensivo contorno de ojos timexpert sr, crema night timexpert srns \r\nconfort recuperador, timexpert srns crema recuperador intensivo.\r\n8/junio/15 promocion antioxidante eva entro 11:50\r\n19/junio/15 radio facial mariana entro 3:00 llevo locion fortalecedor de germaine de capuccini\r\n4/sept/15 radio facial mariana entro 1;10\r\n12/sept/15 promocion equilibrante del ph mary lazaro 12:10\r\n12/sept/15 llevo booster recuperador intensivo timexpert srns\r\n26/oct/15 prp $7000.00 botox triangulo pm $7500.00 botox 1/3 sup y plast $10000.00 dr. oscar garcia\r\n\r\nINICIA TRATAMIENTO CORPORAL $8000.00 \r\n1.-CAVITACION 60M, MASAJE 45M\r\n2.-CARBO, MASAJE 45M\r\n3.-MASAJE 45M, RADIO 30M\r\n4.-CAVITACION 60, MASAJE 45M\r\n5.- CARBO, MASAJE 45M,CRPO\r\n6.-MASAJE 45M, RADIO\r\n7.-CARBO, MASAJE 45M, CORPO\r\n8.-MASAJE 45M, TERMOS\r\n9.-CARBO, LASER 20M, MASAJE 45M\r\n10.-MASAJE 45M, CRIOLIPOLISIS 60M\r\n4/dic/15 promocion reafirmante modeladora andrea entro 5:10\r\n10/feb/16 promocion roll & lift mary lazaro entro 1:50\r\n10/feb/16 depilacion de cejas lucy\r\n17/abril/16 bp pómulos $8000.00, txb rell labios , txb 1/3 sup y platisma $12000.00dr. oscar garcia \r\n18/abril/16 prp cce $7000.00 dr. oscar garcia\r\n01/junio/16 promocion de elastina y dep de cejas reyna entro 12:00\r\n25/julio/16 promocion de coalgeno lucy entro 11.10\r\n31/agosto/16 promocion de caviar y dep de cejas lucy entro 9:00\r\n24/oct/16  hydrate $6000.00, rell m1, m2, m3 $8000.00, botox 1/3 sup y pun $12000.00 doctor oscar garcia\r\n19/dic/16 promocion trat multivitaminico  y dep de cejas mariana  entro 12:00\r\n19/dic/16 llevo  tonico piel seca de germaine, oxygen mousse y crema pro+60 de timexpert srns\r\n7/ene/17 promocion trat de elastina y dep de cejas mariana entro 2:00\r\n8/abril/17 promocion termico ofelia entro 12:50\r\n24/mayo/17 depilacion de cejas ofelia entro 10:20\r\n24/mayo/17 promocion antiedad con lifting, se le aplico amp. de colageno de germaine ofelia entro 10:20 \r\n24/MAYO/17 LLEVO CREMA Y EMULSIÓN MULTI-CORRECCIÓN INTENSIVA DE  TIMEXPERT C+ (A.G.E.)\r\n5/agosto/17 promocion resveratrol y dep de cejas mariana entro 5:15\r\n23/oct/17 promocion reafirmante, depilacion de cejas ofelia entro 1:15\r\n23/nov/17 promocion termico humectante con amp. de colageno, depilacion de cejas ofelia entro 11:45\r\nINICIA TRATAMIENTO DE CARBOXITERAPIA PAQUETE $2500.00 PAGADO\r\n1.-CARBO 23/nov/17 ofelia\r\n2.-CARBO 25/nov/17 susy\r\n3.-CARBO 27/nov/17 ofelia\r\n27/nov/17 botox, hilos dr. oscar\r\n4.-CARBO 29/nov/17 lucy\r\n5.-CARBO 1/dic/17 mariana\r\n6.-CARBO 5/dic/17 ofelia\r\n7.-CARBO  4/JUNIO/18 LUCY\r\n8.-CARBO  6/JUNIO/18 LUCY\r\n9.-CARBO  8/JUNIO/18 LUCY\r\n10.-CARBO 11/JUNIO/18 SUSY\r\n11.- CARBOX  13/JUNIO/18 SUSI ENTRO 2:05\r\n12.- CARBOX  15/JUNIO/18 SUSI ENTRO 5:00\r\n13.- CARBOX  18/JUNIO/18 REYNA ENTRO 5:30\r\n14.- CARBOX\r\n15.- CARBOX\r\n16.- CARBOX\r\n17.- CARBOX\r\n18.- CARBOX\r\n19.- CARBOX\r\n20.- CARBOX\r\n12/dic/17 promocion trat gold con amp. beaute 1, depilacion de cejas ofelia entro 3:10\r\n28/MARZO/18  PROM TRATAMIENTO DE CATIODERMIA MARIANA ENTRO 4:00\r\nLLEVO  LOCION TONIFICANTE\r\n3/ABRIL/18 TRATAMIENTO CORPORAL DE LIPOSONIC 10 DISPAROS OFELIA \r\n17/ABRIL/18  HYDRATE 8,000  HPDO LABIOS 5,000   BTX 1/3 SUP Y PLATISMA 12,000 DOCTOR OSCAR\r\n21/MAYO/18 LLEVO CREMA SRNS PRO 60+\r\n2/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE Y DEP DE CEJAS REYNA\r\n8/JUNIO/18 MASAJE REDUCTIVO Y RADIOFRECUENCIA FRACCIONADA OFELIA\r\n6/JULIO/18 RADIO FRACCIONADA Y LLEVO LOCION TONIFICANTE OFELIA\r\n3/SEP/18 PROM TRATAMIENTO FACIAL REGENERANTE  MONICA\r\n13/OCT/18 FACIAL ANTI POTION   REYNA ENTRO 11:00 \r\n25/OCT/18 TXB 1/3 SUP Y PLATISMA Y BOTOX  DR OSCAR\r\n7/NOV/18 FACIAL DE VITAMINA C DE GERMAINE  REYNA ENTRO 12:55\r\n11/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE MARY ENTRO 11:55\r\n29/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE REYNA\r\n29/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE Y DE PIES REYNA\r\n13/FEB/19 PROMOCION REAFIRMANTE LUCY ENTRO 12:00\r\n22/MAYO/19 FACIAL REVERSE Y DEPILACION DE CEJAS REYNA ENTRO 10:10\r\nLLEVO CREMA ESSENTIAL SHOCK DE NATURA BISSÉ  \r\n4/JULIO/19 PROMOCION COLAGENO HIDROLIZADO ANITA ENTRO 10:35\r\n14/SEP/19 TRATAMIENTO FACIAL OXIGENANTE  REYNA ENTRO 10:55\r\n21/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION REYNA ENTRO 5:10\r\n16/OCT/2020 PROMOCION TRAT GOLD REGENERANTE, DEPILACION DE BIGOTE  MARY LAZARO ENTRO 10:00\r\n19/OCT/2020 MASAJE FULL RELAX 2 X 600 OFELIA ENTRO 9:55 LLEVO LOCION TONIFICANTE ESENCIAL PIELES SECAS , PACK TIMEXPERT SRNS CREMA DE DIA Y NOCHE\r\n7/NOV/2020 PROMOCION TRAT BOTANICO MARY LAZARO ENTRO 11:00\r\n17/JULIO/2021 PROMOCION CAVIAR Y ORO MARIANA ENTRO 11:00 LLEVO SCRUB ESPUMA EXCEL THERAPY EXFOLIANTE, CONTORNO DE OJOS TIMEXPERT C+ AGE Y CREMA EXTREME ROYAL JELLY \r\n8/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD MARIANA ENTRO 9:50\r\n28/DICIEMBRE/2021 PROM. TRATAMIWNTO FACIAL FACE PURE  MARIANA ENTRO 12:15\r\nLLEVO EXPUMA EXFOLIANTE EXCEL THRAPY Y CREMA CUELLO Y ESCOTE TIMEXPERT IN\r\n9/MARZO/2022 PROM. TRATAMIENTO FACIAL SCHOK DE COLAGENO MARIANA ENTRO 1:00 9/MARZO/2022 LLEVO ACEITE FACIAL PIEL SECA CON BAKUCHIOL PHYTORETIN+, ELIXIR EN SERUM ANTIEDAD CON BAKUCHIOL PHYTORETIN+\r\n14/ABRIL/2022 PROMO. TRAT. CINETICO SRA BEGO ENTRO 10:55 MEGA\r\n9/MAYO/2022 LLEVO CREMA FACIAL ANTIEDAD, CREMA CONTORNO DE OJOS Y ELIXIR SERUM BAKUICHIOL PHYTO RETIN+ DE AINHOA\r\n***16/JULIO/2022 LLEVO ESPUMA EXFOLIANTE EXCEL TERAPY***', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-13 12:43:33', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('928', 'C-100928', '', 'LIDIA ALEJANDRA GUZMAN BALBOA', '9931084437', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('929', 'C-100929', '', 'CYNTHIA SUSANA CONTRERAS MORALES', '9933475516', 'acuaramageotacy@hotmail.com', '12/01/12 dep.bracileña,menton,cejas atendio graciela entro11:30 (mega)\r\n16/02/12 lim. facial atendio brenda entro 12:10 (mega)\r\n21/02/12 dep brasileña atendio deyanira entro 12:15 (mega) \r\n4/abril/12 depilacion brasileña lucy entro 11:35 llevo 2 amp. balsam algas\r\n19/julio/12 depilacion de brasileña y muslo karina entro 2:35\r\n5/sep/12 depilacion brasileña gladys entro 3:15\r\n5/sept/12 retoque de candado autom. 35 j lucy\r\n27/ene/14 depilacion brasileña/rectal mariana entro 12:30\r\n30/MAYO/16 promocion colageno lucy entro 10:30\r\n30/mayo/16 retoque de bigote, doble menton autom. 18 j lucy\r\n25/ NOVIEMBRE/2022 PROMOCION DEL MES TRATAMIENTO REPARACION CELULAR MONICA ENTRO 1:10 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-11-24 17:31:51', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('930', 'C-100930', '', 'IRENE TARACENA ROBLES ', '9931080177', '', '22/junio/ mdm 2x1 reyna \r\ninicia tratamiento reductivo de promocion 2x1 $5,000.00 (pagado 31/08/11)\r\n\r\n1.- masaje 45m. 18/oct/11 reyna \r\n2.- masaje 45m. 19/oct/11 reyna entro 9:00\r\n3.- masaje 45m.  25/oct/11 reyna entro 9:00\r\n4.- masaje 45m. 26/oct/11 reyna entro 8:10\r\n5.- masaje 45m. 27/oct/11 reyna entro 9:00\r\n6.- masaje 45m. 28/oct/11 reyna entro 5:40\r\n7.- masaje 45m. 29/oct/11 jhoany entro 3:00\r\n8.- masaje 45m. 30/oct/11 jhoany entro 10:00 se puso g5 y se le cobro 150.00\r\n9.- masaje 45m. 31/oct/11 reyna entro 8:00\r\n10.masaje 45m. 01/oct/11 reyna entro 8:45 se llevo el espadiente no dejo que anotaramos las medidas \r\nni el peso\r\ninicia masaje reductivo $3000.00 abono $1500.00 resta $1500.00\r\ncon peso 83kg\r\n1.-masaej 45m 30/junio/15 carmen entro 10:00\r\n2.-masaje 45m 4/julio/15 reyna entro 9:50\r\n3.-masaje 45m 07/julio/15 carmen entro 9:55\r\n4.-masaje 45m 13/julio/15 mariana entro 9:50\r\n5.-masaje 45m 03/agosto/15 eva entro 9.25 termino de pagar.\r\n6.-masaje 45m     18/MAYO/17 LAS 5 SESIONES QUE LE FALTABAN \r\n7.-masaje 45m     SE LE REPUSIERON A SU HIJA\r\n8.-masaje 45m    NO SE LE DEBE NADA.\r\n9.-masaje 45m\r\n10.-masaje 45m\r\n31/julio/15 delineado de cejas ofelia entro 4:10\r\n20/agosto/15 retoque de cejas, se le dio $100.00 pesos a ofelia\r\n5/OCT/18 DELINEADO DE CEJAS, SE LE DIO $100.00 PESOS A OFELIA\r\n12/JUNIO/19 DELINEADO DE PARPADO SUPERIOR, SE LE DIO $100.00 PESOS A OFELIA\r\n5/NOV/19 RETOQUE DE PARPADO SUPERIOR OFELIA ENTRO 10:15\r\n23/NOVIEMBRE/19 TXB 1/3 SUP BOTOX 6,000.00 DR OSCAR', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('931', 'C-100931', '', 'ALEJANDRO ORAMAS VARGAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('932', 'C-100932', '', 'ELSY PEREZ SANCHEZ', '9931266072', '', '14/julio/16 masaje full relax limpieza de acne  x600 maria entro 10.15 (suc. cristal)\r\n16/dic/16 masaje full relax y limpieza facial 2x600 charito entro 9:50\r\n21/junio/17 promocion antioxidante mary lazaro entro 1:00\r\n27/julio/17 limpieza de acne con amp. desincrustante mariana entro 5:40\r\n16/oct/17 limpieza de acne anita entro 2:40\r\n15/ENERO/18 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE REYNA\r\n01/JUNIO/18  PROM TRATAMIENTO FACIAL ANTIOXIDANTE LUCY ENTRO 12:45\r\n12/JULIO/18  LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE ANITA ENTRO 11:00\r\n26/julio/18 limpieza de acne con amp. desincrustante rosy entro 1:00 (mega)\r\n5/SEPT/18 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE OFELIA ENTRO 11:15 SE LE HIZO DOBLE EXTRACCIÓN\r\n20/SEP/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE OFELIA ENTRO 1:20\r\n17/OCT/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ANITA ENTRO 10:20\r\n4/DIC/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE REYNA\r\n24/ENERO/19 LIMPIEZA DE ACNE LUPITA ENTRO 9:30\r\n29/ENERO/19 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE LUPITA ENTRO 1:00\r\n14/MARZO/19 LIMPIEZA FACIAL MONICA ENTRO 9:10\r\n28/MARZO/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE MARY ENTRO 10:05\r\n17/JUNIO/19 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 11:35\r\n28/OCT/2020 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MONICA ENTRO 10:05\r\n12/02/2021 limpieza de acne con ampolleta desincrustante atendio rosi suc mega\r\n06/03/2021 limpieza de acne profunda con ampolleta desincrustante atendio arleth suc mega \r\n11/AGOSTO/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE ARLETH ENTRO 11:10 LLEVO JABON ACNIPOP\r\n23/OCT/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MONICA ENTRO 12:51 MEGA\r\n6/NOVIEMBRE/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JOHANY ENTRO 2:05\r\n20/NOVIEMBRE/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE LUCYE TNRO 2:00\r\n11/DICIEMBRE/2021 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE JOHANY ENTRO 2:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('933', 'C-100933', '', 'LESBIA VAZQUEZ SANCHEZ', '9931595031', '', '3/MAYO/18 PROM TRATAMIENTO ANTIEDAD LUPITA ENTRO 1:05 (MEGA)\r\n29/abril/19 full relax 2x600 rosy entro 5:10 mega\r\n9/NOVIEMBRE/19 LIMPIEZA FACIAL 2X600 MONI ENTRO 4:30 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('934', 'C-100934', '', 'JAQUELINE GARCIA LEON', '9933421221', '', '27/enero/17 limpieza facial 2x600 con amp. desincrustante susy entro 5:15 (mega)\r\n5/ABRIL/2021 PROM. TRATAMIENTO FACIAL VITAMINA C LUCY ENTRO 12:00\r\nLLEVO SERUM TIMEXPERT WHITE, LECHE CLARIFICANTE Y TONICO CLARIFICANTE', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('935', 'C-100935', '', 'BLANCA ESTELA PEREZ', '', '', '03/febrero/18 prom. del mes trat. multivitaminico susy entro 11:05 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('936', 'C-100936', '', 'ADRIANA DE LA CRUZ VAZQUEZ', '9931942783', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('937', 'C-100937', '', 'CLAUDIA CAROLINA SOLIS JIMENEZ', '9932753820', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('938', 'C-100938', '', 'KARLA PAULINA TOSCA BAEZ', '9932234159', '', 'INICIA TRATAMIENTO DE ACNÉ $395.00 CADA SESIÓN\r\nLLEVO JABON ACNIPOP, GEL BIOCONTROL, LIMPIADORA ÁCIDA, MASCARILLA PH5, ESPONJA LOCION BIOCONTROL\r\nSE LE RECETÓ MINOCIN 100 POR 30 DÍAS Y LENEDA AL 3%\r\n20/nov/15 tratamiento de acne lucy entro 4:20\r\n27/nov/15 tratamiento de acne lucy entro 8:20\r\n9/dic/15 tratamiento de acne lucy entro 4:10\r\n22/dic/15 tratamiento de acne lucy entro 5:10\r\n6/ene/16 tratamiento de acne lucy entro 4:25\r\n16/feb/16 tratamiento de acne lucy entro 4:20\r\n15/marzo/16 tratamiento de acne lucy entro 2.50\r\n16/mayo/16 tratameinto de acne lucy entro 4:00\r\n26/julio/16 limpieza de acne lucy entro 9:05\r\n24/nov/16 limpieza de acne con amp. desincrustante lucy entro 5:15\r\n6/abril/17 tiene pagada una limpieza facial\r\n10/abril/17 limpieza facial lucy entro 11:00 es la que tenia pagada\r\n30/DICIEMBRE/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE LUCY ENTRO 4:05\r\n29/DIC/2020 LIMPIEZA DE ACNE LUCY ENTRO 8:50\r\n30/DIC/2021 LIMPIEZA FACIAL LUCY ENTRO 4:10\r\n20/JUNIO/2022 LIMPIEZA FACIAL LUCY ENTRO 5:00\r\n19/OCTUBRE/2022 LIMPIEZA FACIAL BASICA LUCY ENTRO 9:00\r\n11/MAYO/2023 LIMPIEZA FACIAL LUCY ENTRO 8:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-04 18:40:49', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('939', 'C-100939', '', 'JOSE LUIS DE LA CRUZ CHABLE', '9931942783', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('940', 'C-100940', '', 'LEILA NIDIA GARCIA CLEMENTE', '', '', '14/05/04 limpieza facial hermi\r\n01/11/04 promocion hydratante con lifting yesy\r\n20/04/05 promocion botanico 4 f mary lazaro\r\n15/06/05 promocion catiodermia consuelo\r\n17/09/05 promocion colageno marcela\r\n29/dic/05 promocion vitamina c yesy\r\n17/feb/06 promocion vinoterapia marcela\r\n30/marzo/06 limipieza facial marcela\r\n11/mayo/06 promocion papaya y piña yesy\r\n14/julio/06 promocion oxigenoterapia yesy\r\n25/oct/06 promocion renove marcela entro 5:40\r\n15/dic/06 prom. navideña trat. nutritivo e hidratante bety entro 5:40\r\n10/julio/07 promocion colageno ligia entro 6:10\r\n19/sept/07 promocion colageno marcela entro 5:55\r\n06/dic/07 promocion vitamina c julia entro 6:05 llevo shampoo drops, masc. capilar,\r\n amp. mineralizzante.\r\n2/enero/08 limpieza facial odet entro 4:10\r\n13/marzo/08 limpieza facial con amp. desincrustante mary entro 6:25 \r\n12/mayo/08 limpieza facial con amp. desincrustante mary entro 5:55 \r\n7/oct/08 promocion colageno araceli entro 6:00\r\n25/marzo/11 limpieza facial con amp. desincrustante susy entro 5:55\r\n22/oct/2011 mdm 2x1 susy entro 6:40 (suc las flores)\r\n29/oct/11 limpieza facial 2x1 brenda entro 3:50 (suc las flores)\r\n22/noviembre/15 mdm full relax y limpieza facial 2x1 charito entro 12:05 (mega)\r\n30/12/17 PROMOCION TRATAMIENTO GOLD CHARITO ENTRO 2:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('941', 'C-100941', '', 'CRISTINA ALVARADO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('942', 'C-100942', '', 'ANA LAURA GARCIA LAGARDE', '9933937111', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('943', 'C-100943', '', 'GUADALUPE LOPEZ MADRIGAL', '9932837717', '', '17/ DICIEMBRE/2022 LIMPEZA FACIAL CON AMPOLLETA DESINCRUSTANTE MAS AMPOLLATE DE COLAGANO ROSY ENTRO 11.00 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-25 15:16:23', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('944', 'C-100944', '', 'JORGE CARDENAS VERA', '', 'JCADERNASV.TVP.@HOTMAIL.COM', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('945', 'C-100945', '', 'RAUL LANESTOSA HERNANDEZ', '993155129', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('946', 'C-100946', '', 'ALEJANDRA POZO PEREZ', '9931577858', 'aletabasco@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('947', 'C-100947', '', 'TERESA MAGDONEL GERONIMO', '9935939922', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('948', 'C-100948', '', 'JUANITA JERONIMO GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('949', 'C-100949', '', 'RUBEN MARTINEZ FUENTES', '9933183737', '', '1/feb/16 mdm full relax 2x600 carmen entro 6:00\r\n6/mayo/17 mdm full relax ofelia entro 11:45\r\n1/OCT/18 MDM MDM FULL RELAX 2 X 600 ANITA ENTRO 4:55\r\n2/ENERO/20 MASAJE FULL RELAX Y LIMPIEZA FACIAL 2 X 600 MARY LAZARO ENTRO 2:10\r\n9/ENERO/2023 DUO MASAJE FULL RELAX CRISTINA ENTRO 4:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-01-10 16:10:01', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('950', 'C-100950', '', 'MERCEDES ESPINOZA', '', '', '18-03-16 se realizo  l-f cristal martha 7pm\r\n', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('951', 'C-100951', '', 'AMELIA ZAPATA RAMIREZ', '9933475607', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('952', 'C-100952', '', 'ANA MARIA CERVANTE OROPEZA', '9931602399', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('953', 'C-100953', '', 'ATENEA ARRAZATE RODRIGUEZ', '9321208670', '', '17/05/11 masaje relajante 2x1 atendio dellanira entro 3:50 pm salio (suc)\r\n15/06/11 masaje relante atendio indira entro 12.10 pm salio 1.10 m (suc)\r\n01/08/11 masaje relajante atendio graciela entro 1.05 pm salio 2.30  (suc mega)\r\n19/08/11 masaje drenaje linfatico y lifting atendio jhoany entro 5:00 pm salio6.40 (mega)\r\n02/09/11 masaje drenaje linfatico atendio deyanira entro 3:10 salio 4.20  (suc mega)\r\n08/09/11 masaje drenaje linfatico atendio jhoany entro 12:10 salio 1:10 (suc mega\r\n02/12/11 masaje drenaje linfatico atendio jhoany entro 3:00 salio (mega)\r\n25/01/12 masaje drenaje linfatico atendio brenda entro 11.00 (mega)\r\n15/feb/12 mdm drenaje linfatico sara entro 2:05\r\n22/03/12 mdm atendio jhoany entro 2.29 (mega)\r\n29/03/12 mdm atendio brenda entro 3.00 (mega)\r\n11/04/12 mdm senso relax atendio brenda entro 12:50 (mega)\r\n27/09/12 mdm. drenaje linfatico atendio jenifer entro 1:35 mega\r\n09/octubre/15 mdm full relax susy entro 3:00 (mega)\r\n24/feb/16 mdm descontracturante maria entro 3:15\r\n22/junio/16 mdm drenaje linfatico carmen entro 4:20 (mega)\r\n11/octubre/16 mdm descontracturante carmen entro 5:00 (mega)\r\n13/marzo/17 mdm full relax rosy entro 3:05 (mega)\r\n12/junio/17 mdm descontracturante mariana entro 2:00\r\n5/NOVIEMBRE/19 MDM DESCONTRACTURANTE ALEGRIA ENTRO 3:00\r\n14/SEPTIEMBRE/2020 MASAJE DRENAJE LINFATICO OFELIA ENTRO 1:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('954', 'C-100954', '', 'NORIS SOMOSA DE LA PAZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('955', 'C-100955', '', 'ANA LILIA PONCE BRISEÑO', '9935904327', 'ana_lilia74@hotmail.com.mx', '20/11/03 prom. trat. hydratante con lifting de parpados lupita\r\n26/12/03 limpieza facial con amp. audaz lucy\r\n26/01/04 prom. trat. relajante e hidratante tete\r\n04/05/04 limpieza facial lupita\r\n10/07/04 promocion termico gladys\r\n28/08/04 limpieza facial mary lazaro\r\n08/10/04 limpieza de acne reyna\r\n20/10/04 limpieza facial gladys\r\n02/12/04 promocion vitamina c yesy\r\n20/01/05 limpieza facial mary\r\n23/03/05 limpieza facial mary\r\n07/05/05 promocion 3 geles mary\r\n22/06/05 limpieza de acne gladys\r\n29/07/05 limpieza de acne y limpieza de espalda gladys\r\n01/10/05 promocion modeladora rosy\r\n26/dic/05 limpieza de acne rosy\r\n05/agosto/06 promocion criogenico tana\r\n26/sept/06 limpieza de acne con amp. equilibrante mary\r\n8/dic/06 promocion nutiente e hidratante fanny entro 12:05\r\n09/abril/07 limpieza de acne ofelia entro 1:00 salio 2:00\r\n18/agosto/07 limpieza facial 2 x 1 bety entro 1:10\r\n13/marzo/08 limpieza de acne con amp. equilibrante mary\r\n17/mayo/08 limpieza de acne mary l se llevo 1 locion\r\nbiocontrol y un jabon sastid\r\n23/agosto/08 limpieza de acne sara entro 12:20 \r\n5/dic/08 limpieza de acne mary entro 4:50 \r\n9/ene/09 limpieza de acne mary entro 2:30 salio 4:30 \r\n23/ene/09 limpieza de acne con amp. desincrustante y amp. \r\nserum equilibrante mary entro 4:00 \r\n14/marzo/09 limpieza de acne con amp. balancing \r\nextract ofelia entro 9:40 salio 10:50 \r\n8/mayo/09 limpieza de acne lupita entro 5:25 \r\n12/junio/09 limpieza de acne con amp. desincrustante lupita entro 4:15 \r\n25/sept/09 limpieza facial de acne 2 x 1 con amp. desincrustante marina\r\n21/oct/09 limpieza de acne mary m entro 2:15 \r\n17/dic/09 limpieza facial de acne 2 x 1 mary entro 12:00 \r\n25/marzo/10 limpieza facial de acne 2 x 1 indira entro 12:10 \r\n22/mayo/10 promocion catiodermia marina entro 1:15 \r\n2/julio/10 promocion relajante e hidratante mariana entro 11:45 \r\n30/julio/10 limpieza de acne gladys entro 12:00\r\n26/agosto/10 limpieza de acne reyna entro 1:05\r\n22/oct/10 limpieza de acne marina entro 6:00\r\n26/nov/10 limpieza de acne karina \r\n28/ene/11 limpieza de acne gladys entro 1:45 \r\n20/11/03 depilacion de cejas lucy\r\n26/12/03 depilacion de bigote lucy\r\n28/08/04 depilacion de cejas mary lazaro\r\n20/10/04 depilacion de cejas gladys\r\n02/12/04 depilacion de cejas y bigote yesy\r\n20/01/05 depilacion de cejas y bigote mary\r\n23/03/05 depilacion de cejas mary\r\n05/08/06 depilacion de cejas reyna\r\n13/marzo/08 depilacion de cejas mary \r\n17/mayo/08 depilacion de cejas mary l\r\n5/dic/08 depilacion de cejas mary\r\n9/ene/09 depilacion de cejas y bigote mary \r\n23/ene/09 depilacion de cejas mary \r\n14/marzo/09 depilacion de cejas ofelia \r\n21/oct/09 depilacion de bigote mary\r\n17/dic/09 depilacion de cejas y bigote mary lazaro\r\n22/mayo/10 depilacion de cejas marina \r\n26/agosto/10 depilacion de cejas reyna\r\n26/nov/10 depilacion de cejas y bigote karina\r\n25/feb/11 limpieza de acne, depilacion de bigote y cejas mary lazaro entro 3:55 \r\ncarbo en abdomen, brazos, papada, cadera 500 c/3\r\n1.-23/marzo/11 carbo mary entro 5:03\r\n2.-26/marzo/11 carbo reyna entro 9:16\r\n3.-28/marzo/11 carbo reyna\r\n4.-30/marzo/11 carbo reyna \r\n5.-1/abril/11 carbo reyna\r\n6.-4/abril/11 carbo reyna\r\n7.-6/abril/11 carbo reyna\r\n8.-8/abril/11 carbo reyna\r\n9.-11/abril/11 carbo reyna\r\n\r\ntratamiento de celulitis $7000.00 abono $3500.00 resta $3500.00\r\n1.-cavitacion, masaje 25/marzo/11 reyna entro 5:02\r\n2.-dermosonic 28/marzo/11 reyna entro 4:56 \r\n3.-lumicell 29/marzo/11 reyna \r\n4.-radio 30/marzo/11 reyna \r\n5.-aspired, vf 1/abril/11 reyna\r\n6.-corpo 4/abril/11 reyna entro 5:10\r\n7.-dermosonic 5/abril/11 reyna entro 5:10\r\n8.-aspired, v f 6/abril/11 reyna\r\n9.-corpo 7/abril/11 araceli entro 6:01\r\n10.-lumicell 8/abril/11 reyna entro 5:05\r\n11.-dermosonic 11/abril/11 reyna entro 5:15\r\n12.-corpo 12/abril/11 reyna entro 6:00\r\n13.-aspired, drenaje 13/abril/11 reyna entro 5:00\r\n\r\n1/abril/11 limpieza de acne reyna entro 4:15 \r\n6/junio/11 se le tomo en cuenta un trat. de celulitis que se le debia para una limpieza de acne con\r\namp. piel grasa susy entro 3:40 **ya no se le debe nada**\r\n20/junio/11 limpieza de acne susy, depilacion de cejas entro 12:00\r\n9/agosto/11 limpieza de acne zara entro 4:35\r\n19/sep/11 limpieza de acne s le regalo el lifting reyna entro 4:05\r\n05/nov/11 limpieza de acne dep bigote, cejas sara entro 12:00\r\n6/dic/11 limpieza facial y masaje full relax 2 x 1 karina entro 1:00\r\n6/feb/12 limpieza de acne, depilacion de cejas reyna entro 10:15\r\n6/feb/12 masaje de espalda gladys entro 11:15\r\n17/feb/12 limpieza de acne aracely entro 3:10\r\n17/feb/12 delineado de cejas, se le dio $100.00 pesos a ofelia\r\n29/marzo/12 limpieza de acne, depilacion de cejas aracely\r\n18/mayo/12 limpieza de acne, depilacion de cejas lucy entro 4:20\r\n17 de julio 12 limpieza de acne atendio lucy entro a las 2 salio a las 3\r\n13/agosto/12 limpieza de acne sara entro 6:00\r\n3/dic/12 limpieza de acne con amp. desincrustante graciela entro 5:20\r\n7/ene/13 limpieza de acne reyna entro 12:10\r\n5/feb/13 limpieza de acne con amp. purificante, depilacion de cejas y bigote reyna entro 3:00\r\n14/oct/13 limpieza de acne graciela entro 1:05\r\n26/oct/13  limpieza de acne amp. desincrustante  yusiria entro 1.33\r\ntiene clinica cosmetologica\r\n3/marzo/14 limpieza de acne y dep. de cejas atendio reyna 1:25\r\n31/marzo/14 limpieza de acne yusiria entro 6:00\r\n19/mayo/14 limpieza de acne con amp. desincrustante yusiria entro 5:05\r\n8/julio/14 limpieza de acne mariana entro 1:25\r\n27/oct/14 limpieza de acne ana entro 12:00\r\n12/dic/14 limpieza de acne mariana entro 1:00\r\n5/oct/15 limpieza de acne andrea/reyna entro 3:45\r\n5/oct/15 dep de bigote y cejas \r\n11/nov/15 limpieza facial 2x600 graciela entro 11:55\r\n12/ene/ limpieza de acne y dep de cejas fernanda entro 10:25\r\n14/marzo/16 limpieza de acne  reyna entro 6:15\r\n7/oct/16 limpieza de acne reyna entro 11:50\r\n14/julio/17 limpieza de acne monica entr 2:55\r\n4/oct/17 limpieza de acne con amp. equilibrante lucy entro 4:00\r\n22/FEB/18 LIMPIEZA DE ACNE Y MSM CLIENTE FRECUENTE ANITA ENTRO 4:00\r\n8/JUNIO/18 LIMPIEZA FACIAL  MARY ENTRO 5:00\r\n15/OCT/18 MDM FULL RELAX Y LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 4:05\r\n14/MARZO/19 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE LUPITA ENTRO 3:55\r\n5/JULIO/19 PROMOCION COLAGENO HIDROLIZADO MARY LAZARO ENTRO 3:15\r\n28/NOV/19 PROMOCION TRAT DE PERLA REYNA ENTRO 11:00\r\n4/OCT/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA CON AMP. DE COLAGENO JHOANY ENTRO 11:15\r\n6/OCTUBRE/2022 MASAJE DRENAJE LINFATICO JHOANY ENTRO 11:00', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-06 08:48:45', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('956', 'C-100956', '', 'AMELIS SIERRA', '5560858247', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('957', 'C-100957', '', 'EUGENIA BILLEN ZANCHEZ', '9933043408', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('958', 'C-100958', '', 'VICTOR REYNA CUEVAS', '9932251047', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('959', 'C-100959', '', 'CONCEPCION MACIAS ESCORCIA', '9931327725', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('960', 'C-100960', '', 'MAGDALENA DEFAZ', '9933066628', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('961', 'C-100961', '', 'YADIRA ANEREY YERENA RAMOS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('962', 'C-100962', '', 'DANIELA MEDINA GONZALEZ', '9931909162', '', '22/diciembre/15 limpieza facial 2x1 eva entro 2:50 (mega)\r\n20/mayo/16 limpieza facial 2x600 andrea entro 5:00 (mega)\r\n23/diciembre/16 limpieza facial con amp. desincrustante maria entro 11:45 (mega)\r\n03/febrero/17 limpieza facial rosy entro 6:00 (mega)\r\n04/febrero/17 mdm full relax 2x600 lizbeth entro 7:10 (mega)\r\n19/marzo/17 limpieza facial 2x600 carmen entro 4:00 (mega)\r\n13/junio/17 limpieza facial 2x600 susy entro 4:00 (mega)\r\n23/sept/17 mdm combo carmen entro 10:10 (mega)\r\n21/noviembre/17 limpieza facial con amp. desincrustante rosy entro 11:50 (mega)\r\n23/dic/17 mdm full relax anita entro 12:15\r\n26/12/17 MASAJE DESCONTRACTURANTE CHARITO ENTRO 4:55\r\n28/12/17  LIMPIEZA FACIAL Y MDM FULL RELAX CHARITO ENTRO 4:00\r\n26/marzo/18 limpieza facial susy entro 3:50 (mega)\r\n10/ENE/19 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE REYNA ENTRO 5:05\r\n25/FEBRERO/19 LIMPIEZA FACIAL CARMEN ENTRO 5:00 MEGA\r\n10/MARZO/19 MDM GOETERMAL MONY ENTRO6:05 MEGA\r\n28/ABRIL/19 LIMPIEZA FACIAL MONY ENTRO 2:40 MEGA\r\n18/agosto/19 mdm full relax y limpieza facial 2x600 carmen entro 1:55 mega\r\n12/ENERO/2020 LIMPIEZA FACIAL PROFUNDA JANETH ENTRO 7:05 MEGA\r\n23/SEPTIEMBRE/2020 MASAJE DESCONTRACTURANTE OFELIA ENTRO 4:50\r\n20/DIC/2021 MASAJE FULL RELAX ROSI ENTRO 16:05 MEGA\r\n27/MARZO/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE ROSY ENTRO 2:50 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-27 15:37:02', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('963', 'C-100963', '', 'LOURDES COLLADO VELAZQUEZ', '9932024620', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('964', 'C-100964', '', 'CARLOS OLIVERAS LARA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('965', 'C-100965', '', 'LAURA ISABEL NORIEGA BOLA', '9933963397', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('966', 'C-100966', '', 'NELLY PRIEGO PEREZ', '', '', '11/feb/16 radio facial lucy entro 5:15\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('967', 'C-100967', '', 'PAOLA PEREZ CARRERA', '9931160362', '', '23/sept/17 mdm aromatico mariana entro 1:25\r\n13/MARZO/2021 DEPILACION DE CEJAS Y BIGOTE LUCY ENTRO  1:25\r\n8/JULIO/2021 FACIAL HYDRACURE, DEPILACION DE CEJAS Y BIGOTE MARIANA ENTRO 3:50\r\n29/SEPT/2022 DEPILACION DE CEJAS Y BIGOTE OFELIA ENTRO 12:30\r\n21/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN Y DEPILACION DE CEJAS Y DE BIGOTE CERA MARY LAZARO ENTRO 2:00\r\n9/MAYO/2023 DEPILACION CON CERA DE BIGOTE Y CEJAS CON PINZA OFELIA ENTRO 12:15', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-22 15:05:51', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('968', 'C-100968', '', 'GERARDO SOSA ALONSO', '9933963038', '', '26/nov/15 radio facial mariana entro 10:00\r\n17/nov/16 radio facial mariana entro 2:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('969', 'C-100969', '', 'CARLOS EDGAR LOPEZ MARTINEZ', '9931449063', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('970', 'C-100970', '', 'LETICIA HERNANDEZ', '9932421525', '', '16/ABRIL/19 LIMPIEZA DE ACNE CARMEN ENTRO 4:55 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('971', 'C-100971', '', 'MARIANA ESQUIBEL DIAZ', '9932203458', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('972', 'C-100972', '', 'MARTHA VICENTE SALAYA', '9932281337', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('973', 'C-100973', '', 'LILIANA SISNIEGA SANCHEZ', '9931603006', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('974', 'C-100974', '', 'MYRNA PATRICIA PADILLA GUEVARA', '9933618519', '', '29/sept/17 limpieza facial 2x600 andrea entro 7:05 (mega)\r\n20/octubre/17 prom. del mes trat. resveratrol andrea entro 3:40 (mega)\r\n26/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE LUCY ENTRO 2:15\r\n25/OCT/18 TXB 1/3 SUP BOTOX DR OSCAR\r\n24/SEP/19 YESO TERAPIA LUCY 1,000.00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('975', 'C-100975', '', 'ESTHER TORRES ZAPATA', '9931377875', '', 'dermazuleno- 15-06-98 pancha\r\nextraperformance-8-09-98 ofelia\r\ntonificante-   07-10-98   ofelia\r\ntonificante-        03-10-98     ofelia\r\nshock de colageno-      14-12-98   bego  \r\nginsneg-                          26-01-99          ofelia\r\nsequence-          15-03-99                  ofelia\r\nvino a comprar  el tonico whiten care, y\r\n la crema whiten care\r\njalea real-          21-04-99        ofelia\r\nbotanico              07-06-99       pancha\r\nmodeladora       09-07-99        mary \r\ncatiodermia-      03-07-99        ofelia\r\ntermico c/parafina           20-10-99                mayra\r\nschok intensivo idratacion, lifting,reafirmacion 17-11-99         lucy\r\nshock intensivo hidratacion, lifting y reafirmacion 14-12-99        carmita\r\n3 geles        07-01-2000              lucy\r\ncitoquinas-    14-03-00   hermo       \r\nhidroptima-       18-04-00        carmita\r\ncatiodermia            09-06-00        hermo\r\nhidraveil                  07-07-00        carmita\r\nhydramask              12-08-00         rosita                 \r\nshock de colageno-         05/12/00  carmita\r\nintensivo de schok\r\nlifting de colageno-\r\ntonificante-    30-10-00                 lucy\r\nwhiten care-                                    16/01/01    luc\r\nantiarrugas-                               20/02/01    hermo\r\nrevitalizante   22/03/01            bego\r\nparches frances               25/04/01 consuelo\r\nrevitalizante de phytomer     17/05/01   bego\r\ncatiodermia    20/06/01 consuelo\r\n3 geles   20/07/01 leny\r\nrevitalizante               10/12/01  bego\r\nhidrasoin                    18/03/02  carmita\r\ncompleto-\r\nmodeladora-\r\ntermico-\r\ninicia un new lift  13/04/02\r\n1.-.\r\n\r\n18/12/03 promocion vitamina c lucy\r\n17/01/04 prom. trat. relajante e hidratante consuelo\r\n23/02/04 promocion ginseng tete\r\n22/03/04 promocion anti-arrugas lupita\r\n21/04/04 promocion botanico 4 f lucy, \r\nse fue con 73 de hidratacion\r\n13/05/04 promocion 3 geles lupita contreras\r\n12/06/04 promocion catiodermia mary\r\n30/08/04 promocion regenerador antioxidante gladys\r\n27/09/04 promocion colageno ofelia\r\n30/10/04 promocion modeladora lupita\r\n25/11/04 prom. trat. hydratante con lifting gladys\r\n21/12/04 promocion vitamina c lupita\r\n17/01/05 promocion relajante e hidratante bego\r\n21/01/05   se  llevo   tonico excel therapy   y  \r\ncrema  revitase de ojos \r\n17/02/05 promocion ginseng reyna\r\n19/03/05 promocion antiarrugas marcela\r\n26/04/05 promocion botanico 4 f rosy\r\n13/05/05 promocion 3 geles yesy\r\n24/mayo/05  llevo tonico y leche desmaquillante\r\n de ginseng, crema de ojos revitase\r\n18/06/05 promocion catiodermia mary lazaro\r\n18/07/05 promocion termico mary\r\n20/08/05 llevo la emulsion facial y la crema facial nutrisense\r\n20/08/05 promocion regenerador antioxidante reyna\r\n23/09/05 promocion colageno lucy\r\n23/09/05 llevo leche desmaquillante jalea real\r\n14/nov/05 promocion hidratante con lifting gladys\r\n14/dic/05 promocion vitamina c rosy\r\n16/ene/06 promocion relajante e hidratante lucy\r\n25/ene/06 se llevo una emulsion,crema facial,y \r\ncrema de ojos de nutrisense, y una crema desmaquillante de jalea real.\r\n14/feb/06 llevo el tonico de jalea real\r\n27/feb/06 promocion vinoterapia reyna\r\n22/marzo/06 promocion chocoterapia reyna\r\n18/abril/06 dermorelax rosy\r\n\r\nse va a hacer el tratamiento de pidele al tiempo que vuelva\r\n1.-micro e hidratacion 25/abril/06 mary\r\n2.-micro y excel therapy 02/mayo/06 bego\r\n3.-micro y revitase 09/mayo/06 bego\r\n4.-micro y timexpert 16/mayo/06 bego\r\ntermino su tratamiento.\r\n llevo el gel desmaquillante y el tonico excel therapy.\r\n14/junio/06 promocion efecto botox mary\r\n25/julio/06 promocion oxigenoterapia consuelo\r\n25/agosto/06 promocion criogenico tana entro 4:45 salio 6:30\r\n25/agosto/06 llevo gel desmaquillante y tonico excel therapy\r\nla crema que lleva es la hydrasoin extra rich\r\n09/sept/06 llevo hidrasoin extra rich, renove. abono new lift $2500\r\n11/sept/06 limpieza facial lucy entro 7:40 salio 8:35\r\n11/oct/06 promocion renove carmen entro 4:40\r\n14/nov/06 promocion antiarrugas ofelia\r\n5/dic/06 promocion nutriente e hidratante bety entro 8:47 salio 10:25 \r\nse llevo 1 excel therapy renacer tonico facial, 1 leche de gingeng c-47, 1\r\n hydrasoin extra rich\r\n10/ene/07 promocion relajante e hidratante marcela entro 3:35\r\n08/feb/07 modeladora bety entro 10:40 \r\nllevo crema contorno de ojos infinitime\r\n16/feb/07 llevo crema facial infinitime \r\n16/marzo/07 promocion antiarrugas gladys entro 7:55 salio 9:30\r\n11/abril/07 promocion botanica carmen entro 8:10 salio 9:35\r\n18/abril/07  se llevo la crema contorno de ojos de nutrisence y \r\nel tonico facial de ginseng c-47\r\n08/mayo/07 promocion antiarrugas y reafirmante carmen entro 9:00 salio 10:30\r\n8/mayo/07 se llevo la crema de lendan hydroceramide marine \r\nskin cream liposome de 200 ml $850.00\r\n20/12/13 se hizo lapromocion del mes atendio graciela entro 12.50 suc las flores \r\n12/junio/07 promocion de cristal gladys entro 12:50\r\n17/julio/07 promocion colageno rosy entro 12:35. llevo tonico excel therapy\r\n20/agosto/07 promocion antioxidante y regenerante bety y \r\nse llevo la 1 renove de jabotiere trat contorno de\r\n ojos ojeras y bolsas.\r\n15/sept/07 promocion colageno lupita entro 10:25\r\n25/oct/07 trat. de caviar mary entro 12:30 llevo crema de renove\r\n14/nov/07 llevo tonico y leche desmaquillante de jalea real, crema de caviar. \r\n14/nov/07 se le dio de cortesia un mdm atendio gladys entro 9:50\r\n29/nov/07 seda y perla gladys entro 11:10\r\n5/ene/08 trat. botanico lucy entro 8:25 \r\n26/ene/08 llevo el pack de la crema de perla y el filtro solar.\r\n8/feb/08 promocion dermorelax mary lazaro entro 5:45 \r\nmesoterapia facial en cara $1000.00 c/s  pectoral cortesia\r\n1.-15/feb/08 mesoterapia facial bety.\r\n2.-22/feb/08 mesoterapia facial bety llevo tonico piel seca de lendan\r\n3.-29/feb/08 mesoterapia facial ofe entro 1:00\r\n4.-7/marzo/08 meso facial ofe\r\n5.-14/marzo/08 meso facial ofelia\r\ntermino tratamiento de meso. \r\n25/marzo/08 promocion criogenico bety entro 5:25 termino lucy\r\nllevo renove\r\n26/abril/08 promocion botanico sara entro 12:45 \r\n8/mayo/08 mesoterapia facial ofelia entro 1:30 salio 1:50\r\n03/junio/08 promocion catiodermia julia entro 12:45\r\n24/junio/08 llevo go-expressions, \r\ncrema contorno de ojos timexpert,\r\ncrema facial nacari. la que llevo anterior hidrasoin extra rich.\r\n8/julio/08 promocion termico sara entro 9:00 \r\n25/julio/08 se llevo una crema desmaquillante\r\n piel seca a normal de lendan y un tonico facial \r\npiel seca a normal de lendan\r\n2/agosto/08 promocion regenerador antioxidante sara entro 10:10\r\n llevo crema de manos infinitime. \r\n9/sept/08 promocion modeladora gladys entro 11:40 \r\n9/oct/08 promocion colageno con amp. serum  \r\nnutritivo regenerador ofelia entro 10:40 salio 12:10 \r\n6/nov/08 trat. hidro-.nutritivo con omega 3, 6 y 9 lucy entro 10:45 \r\n3/dic/08 micro lupita entro 12:45 \r\n3/dic/08 llevo pack timexpert de contorno de labios y \r\nojos, serum nutritivo de aceites incas y\r\n crema nutritiva con frutos incas.  \r\n17/dic/08 micro gladys entro 11:40\r\n20/ene/09 dejo pagado el tratamiento de excel therapy 02\r\n23/ene/09 se hizo el trat. excel therapy 02 \r\nque estaba pendiente atendio lupita entro 1:00 \r\n18/feb/09 promocion percollagen lucy entro 12:50 \r\n16/marzo/09 promocion spa therapy perla mary entro 11:20 \r\nllevo bbr, crema contorno de ojos perla, \r\nleche y tonico piel seca de lendan.\r\n18/abril/09 micro-modeladora ofelia entro 10:25 \r\n24/abril/09 micro-modeladora reyna entro 1:00 \r\n26/junio/09 promocion white line rosy entro 5:45 \r\n23/julio/09 promocion extraperformance araceli entro 11:30\r\n llevo crema nutritiva olio rituals y locion piel seca de lendan, \r\nel proximo trat. es el de splendid platinum\r\n19/agosto/09 promocion revitalizante mary entro 10:10 \r\n17/sept/09 tegor preventivo de manchas ofelia entro 1:00\r\n27/oct/09 promocion hidronutritivo ofe entro 9:40 salio 10:45  \r\nllevo pack emulsion nutrisense, leche y tonico piel seca de lendan.\r\n2/dic/09 trat. whitening de tegor marina \r\n27/ene/10 promocion vinoterapia lupita entro 10:50\r\n24/feb/10 promocion estimulante de endorfinas con amp. beaute i \r\nlupita entro 11:40\r\n17/marzo/10 promocion de cristal con amp. dermorelax gladys entro 12:45\r\n llevo pack crema facial, crema contorno de ojos \r\ny crema de cuello y escote timexpert lift, \r\nlocion facial excel therapy\r\ntratamiento de fotoelectroporacion $1250.00 c/s\r\n1.-rollon 17/abril/10 lupita \r\n2.-rollon 24/abril/10 ofe entro 9:50\r\n3.-rollon \r\n4.-rollon \r\n5.-mascarilla \r\n6.-mascarilla \r\n7.-mascarilla \r\n8.-mascarilla \r\n9/junio/10 promocion botanico 4 f marina entro 11:40\r\n16/julio/10 promocion relajante e hidratante mariana entro 11:50 \r\n7/agosto/10 promocion antiarrugas reyna entro 11:40\r\n llevo crema desmaquillante y crema de ojos timexpert lift \r\n4/sept/10 promocion termico araceli entro 8:35  \r\nllevo locion cutis seco de jabotiere, bbr, \r\ncrema reafirmante nutritiva jalea real. \r\n18/oct/10 promocion efecto botox mariana entro 11:00\r\n1/dic/10 promocion velos de colageno gladys entro 9:50 \r\n21/dic/10 llevo crema facial timexpert rides textura rica\r\n y tonico piel sensible de lendan\r\n27/ene/11 promocion porcelana con amp.\r\n beaute i karina entro 12:10 \r\n25/feb/11 promocion trat. de seda susy entro 5:20 \r\n30/marzo/11 promocion elastine gladys entro 11:08 \r\n7/mayo/11 tratamiento facial completo reyna entro 10:35 llevo concentrado instant lift reafirmante\r\ntimexpert lift, crema facial volumenes perfectos timexpert lift\r\n15/junio/11 promocion estimulante de endorfinas deyanira entro 11:30\r\nllevo crema de ojos dia/noche timexpert rides\r\n19/julio/11 promocion de amaranto susy entro 11:10 llevo tonico y gel desmaquillante excel therapy\r\n17/agosto/11 promocion piel de seda  susy entro 11:20\r\n17/agosto/11  se lleva crema de celulas madres de manzana  y el trat. de parches\r\n intensivos de un mes de lendan.\r\n06/oct/11 promocion relajante con amp.beuty 1 gladys entro 11:15\r\n09/nov/11 promocion germen de trigo mariana entro 11:00\r\n23/nov/2011 llevo emulsion cleanser  pieles secas a normales de lendan (suc las flores)\r\n6/dic/11 micro, promocion velo de colageno gladys entro 9:50 llevo go-expressions y renove\r\n14/ene/12 promocion revitalizante con amp. beuate i reyna entro 9:40 llevo crema excel t. 02\r\n15/feb/12 promocion 3 geles karina entro 10:50\r\n6/marzo/12 prp cce 03 8 ml 7 m dr. oscar\r\n20/marzo/12 micro aracely entro 5:00\r\n20/marzo/12 ipl manchas manos prog. i int. 3 lucy\r\n30/marzo/12 micro karina entro 8:40 llevo locion alta tolerancia y pantalla solar\r\n4/mayo/12 promocion velo de colageno sara entro 11:10 llevo crema infinitime piel mixta\r\n6/junio/12 promocion reafirmante  sara entro 13:10\r\n4/julio/12 promocion hidratante de arroz sara entro 11:50\r\n8/agosto/12 timerpert life yse llevo aqua rituals y una leche desmaquillante lendan reyna entro 11:3\r\n29/agosto/12 promocion del mes reafirmante hidratante reyna entro 5:55 (suc las flores)\r\n17/sept/12 desafio antiedad de natura bisse bego entro 4:45 llevo crema timexpert srns pack\r\n6/oct/12 vit c natura bisse bego entro 11:05\r\n24/oct/12 botox dr. oscar\r\n24/oct/12 llevo crema contorno de ojos nb ceutical\r\n23/nov/12 facial ceutical nb lucy entro 8:50\r\n12/dic/12 promocion de oro gladys entro 9:00\r\n15/enero/13 promocion con  amp. beutle lll contornos de ojos susy entro 5:00 (suc las flores)\r\n18/ene/13 delineado de parpado inferior, se le dio $100.00 pesos a ofelia\r\n29/enero/2013 llevo crema contornos de ojos renove (suc las flores)\r\n13/feb/13 promocion catiodermia con amp. dermorelax yusiria entro 10:45\r\n15/marzo/13 promocion royal jelly con gelula roja ana entro 11:30 llevo leche limpiadora y tonico\r\nalta tolerancia\r\n24/abril/2013 promocion porcelana atendio graciela entro 11:45 (suc las flores)\r\n26/abril/13 botox dr. oscar\r\n10/mayo/2013 llevo crema reafirmante nutriva jalea real (suc las flores)\r\n10/junio/2013 promocion de coco y mango atendio susy entro 12.40 (suc las flores)llevo pantalla sola\r\n21/junio/2013 llevo crema contornos de ojos renove 11.35 (suc las flores)\r\n10/julio/2013 promocion de colageno y elastine atendio mariana entro 11:00\r\n14/agosto/13 facial retinol mariana entro 11:55 llevo leche&locion royal jelly, heliocare crema, \r\npastillas y compacto\r\n05/09/13 promocion mes sept. lifting susy entro 11.00 ( suc las flores) llevo germaine capuccini\r\ncreema jalea real\r\n10/10/2013 promocion mes octubre the verde susy entro1.00 (suc las flores)\r\n22/oct/13  txb entre cejo p.g y nas 5.0  34.0\r\n9/nov/13 ptv retinol lucy entro 10:00 llevo crema limpiadora natura bisse\r\n14/ene/14 timexpert rides rosy entro 10:00\r\n17/feb/14 promocion eternamente joven susy entro 10:35\r\n25/03/14 serealizo la promocion del mes atendio graciela las flores  llevi pantalla solar \r\n15/mayo/14 prp $7000.00\r\n15/mayo/14 llevo tonico ceutical, crema reafirmante de vit c natura bisse\r\n7/06/2014 serealizo micro atendio mary las flores 5.30 \r\n24/06/14 sellevo el renove \r\n18/julio/14 promocion de colageno con gelula roja mirena entro 11:30\r\n10/agosto/14 promocion trat oxigenate sra bego (crista) \r\n11/oct/14 hydracure mirena entro 8:00\r\n29/oct/14 botox $5000.00 dr. oscar garcia\r\n30/oct/14 botox plastimo $5000.00 dr. oscar garcia\r\n22/nov/14 promocion antiedad humectante y nutritivo johany entro 8:00\r\n26/dic/14 micro con amp. beaute 1 carmen entro 11:00 llevó crema reafirmante contorno de ojos y labios de essential shock, heliocare compacto brown\r\n29/enero/15 promocion tart desintoxicante y oxigenante carmen entro 8:35\r\n11/feb/15 llevo pack timexpert srns\r\n12/marzo/15 promocion tratamiento anti-edad carmen entro 8:30\r\n23/abril/15 prp $7000.00 dr. oscar garcia\r\n27/mayo/15 micro ana entro 8:15\r\n27/mayo/15 llevo tonico ceutical de natura bisse y heliocare crema \r\n17/junio/15 llevo C+C vitamin cream natura bisse (crema reafirmante piel seca)\r\n17/junio/15 promocion antioxidante carmen entro 12:15\r\n11/agosto/15 promocion chocoterapia reyna entro 5:00\r\n5/sept/15 promocion equilibrante del ph graciela entro 12:00\r\n25/sept/15 promocion equilibrante del ph sra bego entro 5:05\r\n29/oct/15 botox sup $5000.00 dr. oscar garcia\r\n7/nov/15 promocion antiedad humectante y nutritivo graciela entro 8:15\r\n18/dic/15 promocion reafirmante modeladora candy entro 8:10\r\n19/ene/16 promocion desintoxicante carmen entro 10:30 llevo serum recuperador intensivo contorno de ojos de timexpert srns \r\n11/feb/16 promocion roll & lift lizvet entro 8:50 llevo crema correccion lineas/arrugas de timexpert rides textura rica.\r\n12/marzo/16 promocion hydrtante mary lazro entro 8:30\r\n2/abril/16 promocion luxury reyna entro 9:30 llevo leche desmaquillante esencial piel seca y delicada de germaine\r\n7/mayo/16 promocion de colageno lizvet entro 8:50\r\n1/junio/16 promocion de elastine maria entro 5:40\r\n5/julio/16 promocion de colágeno anita entro 8:10\r\n12/agosto/16 promoción de caviar mirena\r\n11/oct/16 promocion colageno maria entro 9:20\r\n26/oct/16 txb 1/3 sup y platisma $12000.00 dr. oscar garcia\r\n24/nov/16 promocion oxigenante mary lazaro entro 9:00\r\n25/nov/16 se le hizo de nuevo la promocion oxigenante ofelia entro 9:00 llevo crema royal jelly extreme\r\n7/dic/16 llevo crema contorno de ojos excel therapy \r\n29/dic/16 promocion trat multivitaminico mirena entro 9:\r\n25/ene/17 promocion desintoxicante andrea entro 9:10\r\n7/marzo/17 promocion estimulante de colageno con masc. led andrea entro 9:00\r\n7/marzo/17 llevo crema reafirmante de timexpert lift in\r\n29/abril/17 promocion termico andrea entro 9:10 llevo locion tonificante de germaine y crema contorno de ojos timexpert lift IN\r\n7/junio/17 promocion antioxidante monica entro 9:10 llevo crema hydracure piel seca\r\n19/julio/17 promoción trat relajante e hidratante lizvet entro 9:05\r\nLLEVO TONICO DE GERMAINE \r\nLLEVO HYDRACURE PIEL SECA Y LECHE DESMAQUILLANTE ESENTIAL PIEL SECA Y DELICADA  DE GERMAINE \r\n10/agosto/17 promocion desvanece las lenas del tiempo monica entro 9:10\r\n13/sept/17 promoción resveratrol ofe/lisbet entro 4:30 \r\nllevo filtro solar de diamond whitte\r\n9/oct/17 promocion reafirmante mary lazaro entro 11:40\r\n27/oct/17 botox cuello y rostro dr. oscar\r\n2/dic/17 llevo crema timexpert rides textura rica\r\n7/dic/17 promocion trat gold mariana entro 9:05\r\n30/01/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO MARY ENTRO 1:20\r\n02/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA MARIANA ENTRO 9:00\r\n3/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE ANITA ENTRO 9:10\r\n16/ABRIL/18   PRP CCE COSTO 7,000  DOCTOR OSCAR\r\n16/ABRIL/18 LLEVO CREMA X-CEL\r\n3/MAYO/18 MICRO ANITA ENTRO 10:15 LLEVO BRUMA SOLAR\r\n20/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE SUSY ENTRO 11:30\r\n24/JULIO/18 PROMOCION TRAT INTENSIVO DE RETINOL ANITA LLEVÓ HELIOCARE GEL\r\n21/AGOSTO/18  PROM TRATAMIENTO FACIAL HUMECTANTE OFELIA\r\n13/SEP/18  PROM TRATAMIENTO FACIAL REGENERANTE SRA BEGO\r\n13/SEP/18 LLEVO ROYAL JELLY CONFORT \r\n17/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE MARY ENTRO 11:15\r\n17/OCT/18 LLEVO LECHE DESMAQUILLANTE \r\n24/OCT/18 T X B 1/3 SUP Y PLATISMA DR OSCAR\r\n26/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN MONICA ENTRO 9:30\r\n18/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE KARLA ENTRO 10:05\r\n8/ENE/19 PROM TRATAMIENTO FACIAL REVITALIZANTE LUPITA\r\n8/ENE/19 LLEVO CREMA TEXT RICA\r\n4/MARZO/19 PROM TRATAMIENTO FACIAL DETOX  LUPITA ENTRO 4:50\r\n4/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE LUPITA ENTRO 2:10\r\nLLEVO OXYGEN MOUSSE ESPUMA LIMPIADORA\r\n11/ABRIL/19 PRP CCE 7,000 DR OSCAR\r\n16/MAYO/19 PROM TRATAMIENTO FACIAL EFECTO BOTOX ANITA ENTRO 4:55\r\n27/JUNIO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO ANTIEDAD SRA BEGO\r\n29/JULIO/19 PROMOCION COLAGENO HIDROLIZADO MARY CARMEN ENTRO 4:15\r\n21/AGOSTO/19 TRATAMIENTO FACIAL DE PORCELANA LUCY ENTRO 4:55\r\n30/AGOSTO/19 LLEVO CREMA HIDRATANTE PROTECTORA B-CALM DE GERMAINE\r\n1/OCTUBRE/19 TRATAMIENTO FACIAL  DOBLE ACCION LUPITA ENTRO 10:10\r\n20/NOVIEMBRE/19 TXB 1/3 SUP Y PLATISMA 12,000.00 DR OSCAR\r\n26/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS SRA BEGO\r\n18/DICIEMBRE/19 TRATAMIENTO FACIAL 24 K ANITA ENTRO 4:50\r\n21/ENERO/20 TRATAMIENTO FACIAL DESINTOXICANTE MARIANA ENTRO 4:45\r\n11/FEBRERO/20 TRATAMIENTO FACIAL 4F LUCY ENTRO 4:40\r\n24/JUNIO/2020 PROMOCION TRAT REPARADOR ANTIEDAD MARY LAZARO ENTRO 10:25\r\n10/AGOSTO/2020 PROMOCION TRAT OXIGENANTE LUCY ENTRO 4:15 LLEVO LOCION TONIFICANTE DE GERMAINE, CREMA X-CEL TIMEXPERT RIDES\r\n14/SEPTIEMBRE/2020 TRATAMIENTO FACIAL REVITALIZANTE LUCY ENTRO 4:25\r\n22/OCTUBRE/2020 TRATAMIENTO FACIAL  GOLD REGENERANTE LUCY ENTRO 4:55\r\n2/DICIEMBRE/2020 TRATAMIENTO FACIAL DE PORCELANA  YOANA ENTRO 4:50\r\nLLEVO LECHE DESMAQUILLANTE Y LOCION TONIFICANTE\r\n20/ENERO/2021 TRATAMIENTO FACIAL ANTIPOLUTION CON AMP BEAUTE I YOANA ENTRO 3:15\r\n24/FEB/2021 PROM. TRATAMIENTO PEEL OFF CON AMP DE ACIDO HIALURONICO ANITA ENTRO 4:30\r\n26/FEB/2021 LLEVO PACK LA CURA - RICH\r\n5/ABRIL/2021 PROM. TRATAMIENTO FACIAL VITAMINA C CON AMP BEAUTE I MONICA\r\n27/ABRIL/2021 PROM. TRATAMIENTO FACIAL VITAMINA C ANITA ENTRO 4:10\r\n14/MAYO/2021 PROMOCION DE CELULAS MADRE MONICA ENTRO 4:35 \r\n16/JUNIO/2021 PROM. TRATAMIENTO FACIAL RETINOL ANITA ENTRO 4:05\r\nLLEVO CRUB ESPUMA EXFOLIANTE DE EXCEL THERAPY Y LOCION TONIFICANTE', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('976', 'C-100976', '', 'CARLA ROMERO SEVILLA', '9931600011', '', '14/enero/18 limpieza facial 2x600 candy entro 12:05 (mega)\r\n21/abril/18 limpieza facial 2x600 rosy entro 2:00 (mega)\r\n15/junio/18 limpieza facial 2x600 candy entro 7:10 (mega)\r\n25/agosto/18 limpieza facial 2x600 susy entro 5:00 (mega)\r\n04/MAYO/19 LIMPIEZA FACIAL 2X600  ROSY ENTRO 3.05 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('977', 'C-100977', '', 'OSCAR MADERA PERES', '9931269633', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('978', 'C-100978', '', 'YADIRA ESTRADA FIGUEROA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('979', 'C-100979', '', 'MARIA GUADALUPE GARCIA PALMA', '9931655272', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('980', 'C-100980', '', 'GUSTAVO ALONSO RODRIGUEZ ULIN', '9931609979', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('981', 'C-100981', '', 'GLORIA LOPEZ SOTO', '9141009183', '', '30/01/18 INICIA TRATAMIENTO REDUCTIVO DE MASAJE Y CAVITACION PAGO 4,000 \r\nCON MEDIDAS DE CINTURA 113, CADERA BAJA 135 Y PESO 89KG\r\n1.- CAVITACION 60 MASAJE 45  30/01/18 REYNA ENTRO 4:00\r\n2.- MASAJE 45MN 31/ENERO/18 ANITA ENTRO 5:20\r\n3.- MASAJE 45MS  01/FEB/18 REYNA ENTRO 5:15\r\n4.- CAVITACION 60MN MASAJE   02/FEB/18 MARIANA ENTRÓ 5:15\r\n5.- CARB, MASAJE  05/FEB/18 REYNA ENTRO 4:25\r\n6.- CARBOX, MASAJE   06/FEB/18 REYNA ENTRO 5:20\r\n7.- CAVITACION 60MN MASAJE  07/FEB/18  REYNA ENTRO 5:05\r\n8.- CARB, MASAJE  08/FEB/18  MARIANA ENTRO 3:35\r\n9.- MASAJE  12/FEB/18 REYNA\r\n10.- CAVITACION 60MN MASAJE 13/FEB/18 LUCY\r\nTERMINO TRATAMIENTO CON MEDIDA CINTURA 103 CM, CADERA BAJA 126 CM\r\nPESO 85 1/2 KILOS', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('982', 'C-100982', '', 'YESENIA LOPEZ GARCIA', '9931934317', '', '2/OCTUBRE/2021 TRATAMIENTO DE MANCHAS DE AINHOA PIEL SENSIBLE JHOANY ENTRO 8:00\r\nLLEVO HELIOCARE 360ª Y EXCEL THERAPY SCRUB 365\r\n6/OCTUBRE/2021 LLEVO SO-DELICATE SOS. D -SENSITIZING SERUM FACIAL', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('983', 'C-100983', '', 'CAROLINA MENDOZA ALMEIDA', '9933420718', '', '2/MARZO/2023 CAVITACION 50 MIN Y DRENAJE 50 MIN LUCY ENTRO 5:15', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-02 19:06:36', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('984', 'C-100984', '', 'MARIA LUISA ZAMBRANO RECHY', '9935619842', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('985', 'C-100985', '', 'ALMA RUIZ GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('986', 'C-100986', '', 'REYNA BAUTISTA MORALES', '9932429846', '', '6/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE REYNA ENTRO 9:50', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('987', 'C-100987', '', 'ERIKA RODRIGUEZ GUZMAN', '9931637016/9331196667', 'erikarg@yahoo.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('988', 'C-100988', '', 'ROBERTO DE LA FUENTE HERNANDEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('989', 'C-100989', '', 'MARCELA ALFONSO TOSCA', '9932151714', '', '3/dic/10 trat de acne  mary lazaro\r\n6/dic/10 marina entro 6:15 \r\n9/dic/10 lucy entro 6:22\r\n28/ene/11 sara entro 5:13\r\n25/feb/11 trat. de acne karina entro 6:30\r\n24/marzo/11 trat. de acne mariana entro 6:04\r\n19/mayo/11 trat. de acne mariana \r\n3/junio/11 trat. de acne araceli entro 2:10\r\n22/junio/11 trat. de acne deyanira entro 3:10\r\n30/junio/11 trat. de acne sara entro 4:15\r\n11/julio/11 trat. de acne karina entro 5:10\r\n\r\n30/julio/11 trat. de acne mariana entro 10:40\r\n6/agosto/11 trat. de acne gladys entro 11:00\r\n13/agosto/11 trat de acne rosy 12:10\r\n20/agosto/11 trat. de acne sara 10:55\r\n27/agosto/11 trat. de acne brenda entro 11:10\r\n03/sept/11 trat de acne dulce entro 10:50\r\n01/sep/11 trat. de acne karina entro 10:20\r\n01/nov/11 trat. de acne brenda entro 3:00\r\n04/nov/11 trat. de acne mariana entro 10:40\r\n12/nov/11 trat. de acne dulce entro 10:50\r\n17/dic/11 trat. de acne karina entro 11:00\r\n30/dic/11 trat. de acne brenda entro 5:10\r\n25/feb/12 trat. de acne mariana entro 11:40\r\n17/marzo/12 trat. de acne aracely entro 10:50\r\n1/junio/12 trat acne lucy entro 4:55\r\n8/sept/12 trat de acne ofe entro 11:20\r\n15/sept/12 trat de acne sara entro 12:30\r\n12/ene/13 limpieza de acne con amp. desincrustante reyna entro 2:15\r\n26/ene/13 trat de acne con amp. desincrustante yusiria entro 12:30\r\n22/junio/13 limpieza de acne con amp. desincrustante rosy entro 11:40\r\n24/oct/13  trat. acne amp.desincrustante mariana entro 6:00\r\n23/nov/13 trat de acne con amp. desincrustante susy entro 1:00\r\n6/ene/14 trat de acne con amp. desincrustante yusiria entro 3:00\r\n10/julio/14 limpieza de acne lucero entro 4:30\r\n28/julio/14 trat de acne yusi entro 2:30\r\n23/agosto/14 limpieza de acne c/amp desincrustante nely entro 12.55 ( mega)\r\n06/sept/14 limpieza de acne c/ampp desincrustante lucero entro 5:35 (mega)\r\n26/nov/14 limpieza de acne c/amp desincrustante nelli entro 3:15 (mega)\r\n13/junio/15 trat. de acne con amp. desincrustante rosy entro 4:10 (mega)\r\n22/octubre/15 trat. de acne con amp. desincrustante susy entro 5:00 (mega)\r\n11/marzo/16 trat. acne con amp. desincrustante candy entro 7:10 (mega)\r\n03/abril/16 trat. acne con amp. desincrustante charito entro 7:20 (mega)\r\n06/abril/16 trat. acne con amp. desincrustante susy entro 1:00 (mega)\r\n23/abril/16 trat. acne con amp. desincrustante susy entro 7:00 (mega)\r\n12/JUNIO/19 LIMPIEZA DE ACNE CON AMPOLLETA  MONY ENTRO 6:00 MEGA\r\n24/junio/19 limpieza de acne  profunda 2x600 mony entro 4.00 mega\r\n15/OCT/2020 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE LUCY ENTRO 1:30\r\n20/ABRIL/2021 LIMPIEZA DE ACNE CON AMP DESINCRUSTANTE ROSY ENTRO 3:23 MEGA \r\n22/FEB/2022 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MONICA ENTRO 17:05 MEGA\r\n16/MAYO/2023 LIMPIEZA FACIAL CN AMPOLLETA DESINCRUSTANTE  SUSY ENTRO 5:10 (MEGA)\r\n07/JUNIO/2023 DUO LIMPIEZA FACIAL MONI ENTRO 4:00 MEGA ', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-07 13:16:15', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('990', 'C-100990', '', 'EVELYN MAURETH HIDALGO TOSCA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('991', 'C-100991', '', 'JULIA LETICIA TOSCA LOPEZ', '9932151714', '', '07/JUNIO/2023 DUO LIMPIEZA FACIAL ROSY ENTRO 4:00 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-07 13:16:28', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('992', 'C-100992', '', 'ROSARIO MOSCOSO GUTIERREZ', '9933997690 3572287', '', '28/JULIO/18 RADIOFRECUENCIA FRACCIONADA LUCY\r\n11/AGOSTO/18 RADIO FRACCIONADA LUCY ENTRO 8:05\r\n11/AGOSTO/18 CREMA SUPREMA DEFINICIÓN TIMEXPERT IN\r\n24/AGOSTO/18  RADIOFRECUENCIA  TRADICIONAL REYNA ENTRO 8:15\r\n8/SEPT/18 RADIOFRECUENCIA TRADICIONAL LUCY ENTRO 8:15\r\n15/SEP/18 RADIOFRECUENCIA TRADICIONAL LUCY ENTRO 8:10\r\n6/OCT/18 RADIO FRACCIONADA REYNA\r\n10/NOV/18 RADIOFRECUENCIA TRADICIONAL REYNA ENTRO 12:15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('993', 'C-100993', '', 'ANA DEL CARMEN RAMON RAMON', '9931279292', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('994', 'C-100994', '', 'GLORIA DIAZ CORTAZAR', '9931946299', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('995', 'C-100995', '', 'ROSALIA DE LEO MARTINEZ', '9931605258', '', '9/MARZO/20 LIMPIEZA FACIAL  2 X 600 LUCY ENTRO 6:00', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('996', 'C-100996', '', 'MONICA RUIZ CASTAÑEDA', '9931600496', '', '25/02/11 dep. cejas. atendio. jhoany. entro 1:30pm salio 2:00pm (suc)\r\n22/03/11 dep.cejas. atendio:rosita. entro: 12:00pm salio:12:35pm(suc)\r\n27/04/11 dep.cejas. atendio: lucy.entro:10:30.salio:11:15am (suc)\r\n30/05/11 limpieza facial mdm 2x1 y dep. de cejas atendio deyanira entro 1:20 pm salio 325 (suc)\r\n08/oct/11 promocion relajante dulce entro 11:45\r\n10/oct/11 delineado de cejas ofelia se le dio 100.00\r\n26/marzo/12 dep.cejas gladis entro 1:03\r\n9/marzo/12 botox 48 u 5 m dr. oscar\r\n2/octubre/2013 dep. cejas gladys entro 1:00\r\n25/oct/13 txb  44u  5.0  dr. oscar\r\n11/dic/13 depilacion de cejas yusiria \r\n16/dic/13 promocion de oro rosy entro 11:45\r\n23/dic/06 promocion navideña trat. nutritivo e hidratante bety entro 10:25\r\n01/feb/08 promocion dermorelax mary entro 10:10\r\n17/abril/08 promocion botanico marcela entro 2:15 \r\n29/sept/08 promocion modeladora araceli entro 12:00 \r\n24/ene/09 promocion jalea real reyna entro 12:20 \r\n21/abril/09 promocion spa therapy oro lucy \r\n13/julio/09 promocion extraperformance mary\r\n21/ene/10 limpieza facial con lifting rosy entro 12:40\r\n18/mayo/10 promocion catiodermia karina entro 5:50 \r\n21/oct/10 promocion efecto botox karina entro 1:10 \r\n7/feb/11 promocion trat. de seda, depilacion de cejas araceli entro 12:35 \r\n9/feb/11 masaje reductivo araceli entro 12:45 \r\n6/julio/11 depilacion de cejas ofe entro 11:00 salio 11:15\r\n6/julio/11 limpieza de acne con amp. finish sara entro 11:15\r\n19/nov/11 promocion germen de trigo y vitamina e sara entro 1:40\r\n19/dic/11 depilacion de cejas ofelia\r\n14/feb/12 depilacion de cejas ofelia \r\n27/feb/12 mdm completo $550.00 reyna entro 12:00\r\n10/marzo/12 mdm aracely entro 12:15\r\n8/mayo/12 promocion velo de colageno lucy entro 12:00\r\n24/mayo/12 depilacion de cejas ofelia entro 1:00\r\n25/mayo/12 mdm completo mariana entro 11:40\r\n10/julio/12 depilacion de cejas ofelia entro 1:00\r\n21/agosto/12 depilacion de cejas ofelia \r\n31/oct/12 depilacion de cejas araceli\r\n3/nov/12 promocion de colageno lucy entro 12:20\r\n19/dic/12 promocion de oro reyna 9:05\r\n22/marzo/13 depilacion de cejas ofelia\r\n26/abril/13 botox dr. oscar\r\n14/mayo/13 depilacion de cejas rosy\r\n16/mayo/13 promocion especial mdm full relax, facial hidratante mariana entro 5:15\r\n23/julio/13 mdm full relax ana entro 1:15\r\n23/julio/13 depilacion de cejas ofelia\r\n29/agosto/13 depilacion de cejas ofelia\r\n9/sept/13 depilacion de cejas ofelia entro 11:40\r\n9/sept/13 promocion lifting antiarrugas reyna entro 12:00\r\n10/ene/14 depilacion de cejas mariana entro 1:15\r\n7/mayo/14 depilacion de cejas mirena entro 11:00\r\n11/agosto/14 promocion trat oxigenante carmen y dep de cejas ofe  entro 11:15\r\n23/agosto/14 depilacion de cejas ofelia\r\n23/agosto/14 promocion oxigenante reyna entro 10:30\r\n8/octubre/14 depilacion de cejas atendio brenda entro 12:25\r\n30/oct/14 depilacion de cejas reyna\r\n30/oct/14 botox $5000.00 dr oscar garcia\r\n19/nov/14 depilacion de cejas jhoany entro 2:00\r\n24/abril/15 botox $5000.00 dr.oscar garcia\r\n11/junio/15 dep de cejas mariana entor 2:50\r\n4/julio/15 depilacion area rectal $350.00 y cejas ofelia entro 11:50 se le aplico amp. de colageno\r\n01/agosto/15 dep de cejas reyna entro 11.25\r\n21/agosto/15 dep de cejas y promocion chocoterapia lucy entro 10:35 llevo aceite rosa mosqueta de nb\r\n9/sept/15 dep de cejas mariana entro 11:30\r\n29/sept/15 dep de ceja lucy entor 12.15\r\n14/oct/15 dep de cejas mariana entro 2.30\r\n21/nov/15 depilacion de cejas reyna\r\n13/ene/16 limpieza facial y dep de cejas lucy entro 11:00\r\n21/marzo/16 delienado de cejas ofelia entro 9:15, se le dio $100.00  a ofelia\r\n4/abril/16 retoque de cejas ofelia, se le dio $100.00 a ofelia\r\n4/abril/16 promocion trat luxury mary lazaro entro 11:40\r\n22/abril/16 txb 1/3 sup $6000.00 dr. oscar garcia\r\n29/abril/16 mdm holistico reyna entro 12.20\r\n2/mayo/16 depilacion de cejas rosy\r\n2/maro/16 depilacion rectal cera (se le cobró $450.00) ofelia entro 12.15\r\n23/mayo/16 depilacion de cejas y promocion de colageno mariana entro 12:30\r\n15/junio/16 depilacion de ceja reyna entro 1:25 llevo crema  so-delicate \r\n19/julio/16 promocion y depilacion de ceja rosita entro 2:00\r\n19/agosto/16 depilacion de cejas mary lazaro entro 10:00\r\n5/oct/16 llevo crema so-delicate piel normal\r\n11/oct/16 depilacion de cejas ofelia\r\n26/oct/16 depilacion de cejas lucy \r\n26/oct/16 txb 1/3 sup $6000.00 dr. oscar garcia\r\n17/nov/16 promocion oxigenante y dep de cejas anita entro 12:15\r\n20/dic/16 depilacion de cejas mary lazaro entro 12:10\r\n21/dic/16 promocion trat multivitaminico lucy entro 11:15\r\n16/marzo/17 depilacion de cejas y dep de bikini $450.00 ofelia entro  10:30\r\n21/junio/17 LLEVO CREMA SO-DELICATE PIEL NORMAL DE GERMAINE\r\n8/agosto/17 depilacion de cejas lucy entro 11;35\r\n7/oct/17 promocion pidele al tiempo que vuelva (reafirmante) y dep de cejas mariana entro 11:30\r\n9/oct/17 mdm full relax lucy entro 12:00\r\n28/nov/17 depilacion de cejas ofelia\r\n28/nov/17 botox dr. oscar\r\n31/ENERO/18 DEPILACION DE CEJAS MARIANA LLECO CREMA SO-DELICATE PIEL SECA\r\n24/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO, DEP CEJAS Y DEP C/CERA SOLO RECTAL OFE\r\n22/MARZO/18 DEP DE CEJAS OFELIA\r\n14/ABRIL/18 DEP DE CEJAS LUCY ENTRO 11:25\r\n18/JUNIO/18 DEP DE CEJAS OFELIA\r\n19/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL Y DP DE CEJAS OFELIA\r\n4/SEPT/18 LLEVO CREMA SO-DELICATE PIEL NORMAL DE GERMAINE\r\n10/SEPT/18 DEPILACION ÁREA RECTAL, CEJAS, PROMOCION TRAT REGENERANTE Y ESTIMULANTE OFELIA ENTRO 2:15\r\n27/OCT/18 T X B 1/3 SUP BOTOX DR OCAR\r\n21/FEBRERO/19 DEPILACION DE CEJAS, BIKINI Y PROM TRATAMIENTO FACIAL REAFIRMANTE CON AMP BEAUTÉ I OFELIA ENTRO 2:30\r\n15/MARZO/19 PROM TRATAMIENTO FACIAL DETOX Y DEPILACION DE CEJAS LUPITA ENTRO 12:05\r\n15/MARZO/19 LLEVO SO-DELICATE PIELES CÁLIDAS Y SÉRUM RECONCILIADOR SO-DELICATE\r\n12/ABRIL/19 T X B 1/3 SUP 6,000 DR OSCAR\r\n5/JULIO/19 DEPILACION DE CEJAS Y AREA RECTAL OFELIA ENTRO 11:00\r\n5/SEPT/19 PROMOCION OXIGENANTE, DEPILACION DE CEJAS LUCY ENTRO 12:30\r\n15/OCTUBRE/19 DEPILACION DE CEJAS Y DEPILACION BIKINI 450.00 OFELIA ENTRO  2:15\r\n12/NOVIEMBRE/19 DELINEADO DE CEJAS OFELIA ENTRO 2:00\r\n22/NOVIEMBRE/19 TXB 1/3 SUP BOTOX 6,000.00 DR OSCAR\r\n27/FEBRERO/20 DEPILACION BRASILEÑA 450.00 Y DEPILACION DE CEJAS OFELIA ENTRO 1:40  LLEVO CREMA SO-DELICATE PIER NORMAL\r\n5/MARZO/20 TRATAMIENTO FACIAL RECUPERADOR OFELIA ENTRO 1:20\r\n1/JULIO/2020 PROMOCION TRAT DE ALGAS, DEPILACION DE CEJAS Y BIKINI OFELIA ENTRO 12:05 LLEVO CREMA SO-DELICATE PIEL NORMAL, UNA MASCARILLA LIFTING PARA CUELLO Y ESCOTE INHIBIT \r\n15/JULIO/2020 PROMOCION TRAT ANTIEDAD A BASE DE ALGAS OFELIA ENTRO 11:50\r\n14/AGOSTO/2020 PROMOCION TRAT OXIGENANTE, DEPILACION DE CEJAS OFELIA ENTRO 12:05\r\n20/OCT/2020 PROMOCION TRAT GOLD REGENERANTE, DEPILACION AREA RECTAL OFELIA ENTRO 1:00\r\n9/NOV/2020 PROMOCION TRAT BOTANICO LUCY ENTRO 12:10\r\n17/ABRIL/2021 DEPILACION DE CEJAS Y DEPILACION CON CERA DE BIKINI OFELIA ENTRO 2:00\r\n7/JULIO/2021 PROM. TRATAMIENTO FACIAL CAVIAR Y ORO Y DEPILACION DE CEJAS ANITA ENTRO  4:45\r\n13/DIC/2021 PROMOCION TRAT. FACE PURE, DEPILACION DE CEJAS, RECTO OFELIA ENTRO 9:15\r\n28/JULIO/2022 DEPILACION DE CEJAS LUCY ENTRO 1:20\r\n15/NOVIEMBRE/2022 PROMOCION TRAT. FACIAL REPARADOR FACIAL, DEPILACION DE CEJAS, DEPILACION AREA RECTAL OFELIA ENTRO 11:30\r\n30/ENERO/2023 PROMOCION TRAT. FACIAL PURIFICANTE, DEPILACION DE CEJAS LUCY ENTRO 12:30\r\n21/ABRIL/2023 PROMO TRATAMIENTO FACIAL PLASA MAMARINO, DEPILACION CON CERA DE BIKINI Y CEJAS OFELIA ENTRO 1:40\r\n2/MAYO/2023 DELINEADO DE CEJAS OFELIA ENTRO 12:00\r\n13/JUNIO/2023 MASAJE BONBON, DEPILACION DE CEJAS OFELIA ENTRO 12:30 LLEVO PARCHES TONICO HIDRATANTED E AINHOA\r\n((((((NO NECESITO RETOQUE DE CEJAS))))))', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-02 15:40:43', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('997', 'C-100997', '', 'MARITZA JIMENEZ GOMEZ', '9931299000', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('998', 'C-100998', '', 'REBECA ANTON ESPARZA', '9933115311', '', '15/dic/15 masaje full relax (vale regalo) candy entro 6:00\r\n11/mayo/17 promocion antiedad con lifting yennifer entro 5:15\r\n8/ABRIL/19 LIMPIEZA FACIAL 2 X 600 LUPITA ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('999', 'C-100999', '', 'NICOLINA INATTI', '9933939523', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1000', 'C-101000', '', 'KATI VARGAS', '9932075527', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1001', 'C-101001', '', 'MARTIN LAYNEZ CHANG', '9931485116', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1002', 'C-101002', '', 'GUILLERMO IRAZOKI SAINZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1003', 'C-101003', '', 'DIDIER BELTRAN PE', '9931752723', '', '31/MARZO/2021 LIMPIEZA FACIAL PROFUNDA MARY LAZARO ENTRO 4:05 \r\n5/FEB/2022 MASAJE DESCONTRACTURANTE JHOANY ENTRO 12:10\r\n5/MARZO/2022 MASAJE DESCONTRACTURANTE VALE DE REGALO LUCY ENTRO 2:05\r\n14/MARZO/2022 MASAJE DESCONTRACTURANTE MIRENA ENTRO 3:00\r\n7/JUNIO/2022 ************DATOS DE FACTURACION********************\r\nNOMBRE:    DIDIER BELTRAN PEÑALOZA\r\nRFC:    BEPD780822TV7\r\nDIRECC: PRIVADA TURIN NUM 5  FRACC. SOL CAMPESTRE\r\nCP: 86039    CORREO:   didierbp@gmail.com\r\n*************************************************************************', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1004', 'C-101004', '', 'AURORA MONTEJO BARRAGAN', '9931571239', '', '16/agosto/19 promocion tratamiento de porcelana susy entro 6.00 mega\r\n21/agosto/19 mdm drenaje linfatico mony entro 6:05 mega', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1005', 'C-101005', '', 'CITLALI JAZMIN MENDEZ LOPEZ', '9173280979', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1006', 'C-101006', '', 'SILVIA DE C.TRINIDAD LOPEZ', '', 'trinidadlopezc@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1007', 'C-101007', '', 'NALLELI FLORES MENDEZ', '9932025770', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1008', 'C-101008', '', 'SILVIA CASTILLO CONDE', '9931160037', 'gconde_30@yahoo.com', '03/11/03 depilacion ingle lupita\r\n29/11/03 depilacion de pantorrilla con amp. germipil rosy\r\n19/01/04 depilacion de ingle y pantorrilla con amp. germipil lupita c\r\n28/02/04 depilacion area de bikini lupita\r\n13/03/04 depilacion de pantorrilla con amp. germipil mary\r\n24/04/04 depilacion area de bikini consuelo\r\n05/06/04 depilacion de ingle y pantorrilla con amp. germipil lupita\r\n11/09/04 depilacion de pantorrillas e ingle con amp. germipil ofelia\r\n30/10/04 depilacion de pantorrillas e ingle rosy\r\n18/12/04 depilacion de pantorrilla, area de bikini mary lazaro\r\n12/02/05 depilacion de bikini, pantorrilla con amp. germipil mary\r\n18/03/05 depilacion de bikini, pantorrilla con amp. germipil mary lazaro\r\n05/05/05 depilacion de bikini, pantorrilla con amp. depifin marcela\r\n04/06/05 depilacion de pantorrilla e ingle con amp. depifin mary lazaro\r\n18/07/05 depilacion de pantorrilla e ingle con amp. depifin mary\r\n\r\n20/08/05 depilacion de pantorrilla e ingle con amp. depifin mary\r\n24/09/05 depilacion de pantorrilla e ingle con amp. depifin mary\r\n12/nov/05 depilacion de pantorrilla e ingle mary lazaro\r\n10/dic/05 depilacion de ingle y pantorrilla consuelo\r\n28/ene/06 depilacion de ingle y pantorrilla lucy\r\n04/marzo/06 depilacion de ingle y pantorrilla con amp. depifin marcela\r\n01/abril/06 depilacion de pantorillas lucy\r\n13/mayo/06 depilacion de ingle mary\r\n01/julio/06 depilacion pantorillas mary lazaro\r\n22/julio/06 depilacion de pantorillas y bikini yesy\r\n12/agosto/06 depilacion de bikini ofelia\r\n15/sept/06 depilacion de pantorilla e ingle mary lazaro entro 6:30\r\n14/oct/06 depilacion de pantorilla e ingle reyna entro 9:47\r\n20/nov/06 depilacion de pantorrilla lucy entro 11:10\r\n29/dic/06 depilacion de pantorrilla e ingle gladys entro 11:10\r\n17/feb/07 depilacion de pantorrila e ingle rosy entro 10:00\r\n17/marzo/07 depilacion de pantorrilla e ingle marcela entro 10:05 salio 11:00\r\n21/abril/07 depilacion de pantorrilla bety entro 9:15 salio 9:40\r\n02/junio/07 depilacion de pantorrilla e ingle con amp. depifin mary entro 10:10\r\n30/junio/07 depilacion de pantorilla e ingle marcela\r\n21/julio/07 depilacion de pantorrilla mary lazaro entro 8:25\r\n18/agosto/07 depilacion de pantorrilla y bikini mary entro 10:20\r\n15/sept/07 depilacion de pantorrilla e ingle mary entro 10:10\r\n06/oct/07 depilacion de pantorrilla mary lazaro entro 9:15\r\n14/dic/07 depilacion de pantorrilla y bikini bety entro 2:40\r\n7/ene/08 depilacion de ingle y pantorrilla lucy entro 9:20\r\n4/feb/08 depilacion de pantorrilla mary entro 10:10 \r\n23/feb/08 depilacion de pantorrilla y bikini odet entro 9:35 salio 10:30\r\n11/abril/08 depilacion de pantorrilla, bikini, axila gladys entro 10:35\r\n17/mayo/08 depilacion de pantorrilla y bikini reyna entro 10:30 \r\n14/junio/08 depilacion de pantorrilla ofelia entro 9:45 \r\n21/junio/08 depilacion de bikini mary entro 8:55 salio 9.30\r\n2/agosto/08 depilacion de bikini ofelia entro 10:00 \r\n23/agosto/08 depilacion de pantorrilla con amp. depifin marcela entro 1:00 \r\n20/sept/08 depilacion de pantorrilla y bikini con amp. depifin gladys entro 10:00\r\n18/oct/08 depilacion de pantorrilla y bikini con amp. depifin lucy entro 10:20 \r\n12/dic/08 depilacion de pantorrilla y bikini con amp. depifin mary lazaro entro 3:05\r\n3/feb/09 depilacion de biniki, axila y pantorrilla con amp. depifin mary entro 10:25\r\n2/marzo/09 depilacion de bikini y pantorrilla mary lazaro entro 2:00 salio 3:10\r\n8/abril/09 depilacion de pantorrilla, axila y bikini con amp. depifin mary entro 12:10\r\n22/mayo/09 depilacion de pantorrilla y bikini con amp. depifin mary lazaro entro 5:50\r\n20/junio/09 depilacion de pantorrilla y axila con amp. depifin mary entro 11:20\r\n25/julio/09 depilacion de pantorrilla lucy entro 10:50\r\n1/agosto/09 depilacion de bikini mary lazaro entro 11:00\r\n4/sept/09 depilacion de pantorrilla y bikini con amp. depifin mary lazaro entro 2:30\r\n9/sept/09 depilacion de axila gladys entro 11:05\r\n12/oct/09 depilacion de axila y pantorrillas lupita entro 11:30\r\n28/nov/09 depilacion de bikini y pantorrilla mary entro 11:10\r\n16/dic/09 depilacion de axila lucy entro 2:25 \r\n14/ene/10 depilacion de pantorrilla, axila, bikini mary lazaro entro 2:00 salio 3:00\r\n13/feb/10 depilacion de pantorrilla lucy entro 9:30 salio 10:20\r\n27/marzo/10 depilacion de pantorrilla y axila ofe entro 10:15\r\n10/abril/10 depilacion de bikini y axila lucy entro 8:30 salio 9:10 \r\n19/junio/10 depilacion bikini y pantorrilla con amp. depifin mary lazaro entro 9:10 \r\n3/julio/10 depilacion de axila sara entro 11:25\r\n17/julio/10 depilacion de pantorrillas gladys entro 12:55\r\n14/agosto/10 depilacion de pantorrillas y bikini con amp. depifin gladys entro 10:40\r\n28/agosto/10 depilacion de pantorrillas y axila con amp. depifin gladys entro 10:45\r\n02/oct/10 depilacion de pantorrilla gladys entro\r\n9/oct/10 depilacion de axila mary lazaro entro 11:10 \r\n15/nov/10 depilacion de axila y pantorrillas con amp. depifin araceli entro 12:45 \r\n30/dic/10 depilacion de axila, pantorrillas y bikini con amp. depifin gladys \r\n29/ene/11 depilacion de axila y pantorrillas mary lazaro entro 11:15 \r\n26/feb/11 depilacion de axila y pantorrillas con amp. depifin gladys entro 12:36\r\n26/marzo/11 depilacion de axila y pantorrillas con amp. depifin gladys \r\n25/abril/11 depilacion de axila,bikini y pantorrilla  con amp. depifin gladys entro 2:50\r\n18/junio/11 depilacion de axila, bikini y pantorrilla con amp. depifin gladys entro 12:30\r\n16/julio/11 depilacion de axila y pantorrilla con amp. depifin gladys entro 12:25\r\n03/sept/11 depilacion de axila y pantorrilla con ampolleta defipin gladys entro 11:10\r\n08/oct/11 depilacion pantorrilla axila gladys entro 10:05\r\n26/nov/11 depilacion de axila, bikini y pantorrilla con amp. depifin ofelia entro 11:00\r\n23/dic/11 depilacion de axila, pantorrilla con amp. depifin araceli entro 4:30\r\n21/ene/12 depilacion de axila, bikini, pantorrilla con amp. depifin gladys entro 11:30\r\n25/feb/12 depilacion de axila y pantorrilla gladys entro 11:05\r\n11/abril/12 depilacion de axila, pantorrilla, bikini con amp. depifin gladys entro 9:05\r\n12/mayo/12 depilacion de pantorrilla gladys entro 9:36\r\n11/junio/12 depilacion de axila y pantorrilla gladys entro 2:15 salio 3:10\r\n3/agosto/12 depilacion de axila y pantorrilla con amp. depifin gladys entro 1:40\r\n25/agosto/12 depilacion de axila y pantorrilla gladys entro 9:05\r\n29/sept/12 depilacion de axila y pantorrilla reyna entro 9:30\r\n10/nov/12 depilacion de axila y pantorrilla gladys entro 9:30\r\n8/dic/12 depilacion de axila y pantorrilla gladys entro 9:15\r\n12/ene/13 depilacion de axila y pantorrilla gladys entro 9:15\r\n9/feb/13 depilacion de axila, pantorrilla con amp. depifin gladys entro 11:15\r\n23/marzo/13 depilacion de axila y pantorrilla gladys entro 9:00\r\n27/abril/13 depilacion de axila y pantorrilla con amp. depifin gladys entro 9:00\r\n8/junio/13 depilacion de axila, pantorrilla gladys entro 11:40\r\n26/julio/13 depilacion de axila, pantorrilla gladys entro 2:10\r\n23/agosto/13 depilacion de axila, pantorrilla gladys entro 2:50\r\n18/oct/13 depilacion de axila y pantorrilla gladys entro 2:00\r\n16/nov/13 depilacion de axila y pantorrilla gladys entro 12:15\r\n27/dic/13 depilacion de pantorrilla gladys entro 2:30\r\n1/feb/14 depilacion de pantorrilla y axila yusiria entro 10:00 salio 10:40\r\n28/marzo/14 depilacion de pantorrillas y axila mirena entro 1:00\r\n30/abril/14 promocion trat de porcelana mariana entro 12:50\r\n7/junio/14 depilacion de axila, pantorrilla lucy entro 1:05\r\n18/julio/14 depilacion axila y pantorrilla yusi entro 2:20\r\n30/agosto/14 dep pantorrilla yusi entro 12:50\r\n4/oct/14 depilacion de axila, pantorrilla ana entro 1:30\r\n4/dic/14 depilacion de axila, pantorrilla brenda entro 1:15\r\n14/enero/15 depilacion de axila, pantorrilla johany entro 12:45\r\n18/MARZO/15 DEPILACION DE PANTORRILLA MARIANA ENTRO 3:00\r\n18/abril/15 depilacion de pantorrilla y axila mariana entro 8.50\r\n22/mayo/15 depilacion de pantorrilla carmen entro 1:30\r\n27/junio/15 depilacion de axila y pantorrillas ofelia entro 1:20\r\n08/agosto/15 dep pantorrilla y axila mariana entro 12.05\r\n30/sept/15 dep pantorrilla y axila candy entro 11.30\r\n30/sept/15 mdm full relax (cliente frecuente ) candy\r\n28/nov/15 depilacion de pantorrilla y axila mariana entro 12:15\r\n26/dic/15 depilacion de axila y pantorrilla ofelia entro 8:50\r\n30/ene/16 depilacion de axila y pantorrilla mariana entro 1:15\r\n4/abril/16 depilación de pantorrilla y axila mariana entro 1:30\r\n30/mayo/16 depilacion de pantorrilla y axila mariana entor 12.55\r\n26/julio/16 depilacion de axila y pantorrilla reyna entro 5:15\r\n26/julio/16 masaje fullr elax (cliente frecuente) reyna entro 5:40\r\n9/sept/16 depilacion de pantorrilla y axila mariana entro 4:00\r\n07/octubre/16 dep. de pantorrilla carmen entro 3:35 (mega)\r\n5/nov/16 depilacion de axila y pantorrilla mariana entro 2:30\r\n21/dic/16 depilacion de axila y pantorrilla mariana entro 4:\r\n11/feb/17 depilacion de pantorrilla y promocion trat de elastine mariana entro 12:00\r\n17/marzo/17 depilacion de axila y pantorrilla mariana entro 1:05\r\n29/abril/17 depilacion de axila, pantorrilla mariana entro 9:15\r\n27/junio/17 depilacion de axila y pantorrilla mariana entro 2:05\r\n29/junio/17 masaje full relax (cliente frecuente mariana entro 12.10\r\n1/sept/17 depilacion de pantorrilla y axila mariana entro 3:00\r\n29/sept/17 depilacion de axila y pantorrilla mariana entro 6:20\r\n3/nov/17 depilacion de axila y pantorrilla mariana entro 9:25\r\n21/12/17 DEPILACION PANTORRILLA Y AXILA  MARIAMA ENTRO 2:15\r\n22/12/17 PROMOCIÓN TRATAMIENTO GOLD  MARIANA ENTRO 5:10\r\n26/01/18 DEPILACION CON CERA DE PANTORRILLA  MARIANA ENTRO 1:00\r\n27/FEB/18 DEPILACION  CON CERA DE PANTORRILLA  Y AXILA MARIANA ENTRO 12:45\r\n18/ABRIL/18 AXILA, PANTORRILLA DEP CON CERA AXILA, PANTORRILLA MARIANA\r\n26/MAYO/18 DEP CON CERA DE PANTORRILLA Y AXILA MARY ENTRO 1:10\r\n2/JULIO/18 DEP CON CERA  AXILA Y PANTORRILLA MARY ENTRO 1:05\r\n16/AGOSTO/18 DEPILACION CON CERA DE PANTORRILLA MARY\r\n16/AGOSTO/18 MDM FULL RELAX DE CLIENTE FRECUENTE MONICA\r\n18/SEP/18 DEP CON CERA DE PANTORRILLA Y AXILA MARY\r\n20/NOV/18 DEPILACION CON CERA DE PANTORRILLA Y AXILA MARY ENTRO 3:10\r\n11/ENE/19 DEPILACION CON CERA DE PANTORRILLAS Y AXILA MARY\r\n29/JUNIO/19 DEPILACION CON CERA DE PANTORRILLA Y AXILA MARY ENTRO 1:10\r\n29/NOV/19 DEPILACION DE PANTORRILLA Y AXILA MARY LAZARO ENTRO 12:00\r\n14/MARZO/20 DEPILACION CON CERA DE AXILA Y PANTORRILLA MARY LAZARO ENTRO 1:20\r\n19/JUNIO/2020 DEPILACION DE AXILA Y PANTORRILLA MARY LAZARO ENTRO 12:10\r\n17/SEPT/2020 DEPILACION CON CERA DE PANTORRILLAS Y XILA MARY LAZARO ENTRO 1:30\r\n7/ENERO/2021 DEPILACION DE AXILA Y PANTORRILLAS MARY LAZARO ENTRO 10:10\r\n3/MAYO/2021 DEPILACION DE AXILA Y PANTORRILLA MARY LAZARO ENTRO 4:10\r\n7/AGOSTO/2021 DEPILACION PANTORRILLA MARY LAZARO ENTRO 1:10\r\n4/OCTUBRE/2021 DEPILACION CON CERA DE AXILA Y PANTORRILLAS MARY LAZARO ENTRO 12:55\r\n14/DIC/2021 DEPILACION CON CERA  DE AXILA, PANTORRILLA MARY LAZARO ENTRO 12:10\r\n14/FEBRERO/2022 DEPILACION C/CERA PAMTORRILLAS Y AXILA MARY LAZARO ENTRO 11:20 \r\n4/JUNIO/2022 DEPILACION DE PANTORRILLA Y AXILA MARY LAZARO ENTRO 2:15\r\n4/JUNIO/2022 DEPILACION CON CERA PANTORRILLAS Y AXILA MARY LAZARO ENTRO 2:10\r\n6/AGOSTO/2022 DEPILACION CON CERA DE PANTORRILAS MARIANA ENTRO 12:00\r\n30/SEPTIEMBRE/2022 DEPILACION CON CERA DE AXILA Y PANTORRILLAS MARY LAZARO ENTRO 3:20\r\n7/DICIEMBRE/2022 DEPILACION DE PANTORRILLAS CON CERA MARY LAZARO ENTRO 3:10\r\n17/FEBRERO/2023 DEPILACION CON CERA AXILA Y PANTORRILLA MARIANA ENTRO 4:00\r\n26/ABRIL/2023 DEPILACION CON CERA DE PANTORRILLAS JHOANY ENTRO 3:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-04-25 16:03:41', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('1009', 'C-101009', '', 'GABRIELA VAZQUEZ ROSAS', '9982050142', '', '23/mayo/07 lifting de parafina ofelia\r\n20/junio/07 lifting de colageno carmen entro 1:30 salio 2:05\r\n07/agosto/07 promocion regenerador antioxidante, lifting de colageno, \r\nplanchado de cejas reyna entro 2:20\r\n08/sept/07 promocion colageno marcela, planchado de cejas mary lazaro entro 11:35\r\n11/oct/07 lifting de parafina y planchado de cejas mary lazaro entro 3:30\r\ndepilacion de bigote $180.00 c/s retoques $60.00 c/s\r\n1ª sesion 23/mayo/07 bigote autom. 18 j ofelia\r\n2ª sesion 20/junio/07 bigote autom. 18 j rosy\r\n3ª sesion 07/agosto/07 bigote autom. 20 j lucy\r\n4ª sesion 08/sept/07 bigote autom. 22 j rosy\r\n5ª sesion 11/oct/07 bigote autom. 23 j lucy \r\n6a sesion 17/nov/07 bigote autom. 24 j lucy\r\n7a sesion 13/nov/07 bigote autom. 24 j rosy\r\n8a sesion 17/enero/08 bigote autom 24 j rosy\r\n31/ene/09 promocion jalea real julia entro 12:00 salio 1:15 \r\n29/ene/11 promocion porcelana, depilacion de cejas karina entro 11:55\r\n02/mayo/07 delineado de cejas y parpado inferior,\r\n se le dio $100.00 c/u a ofelia\r\n6/ene/09 delineado de labios, se le dio $100.00 pesos a ofelia \r\n24/ene/09 retoque de labios, se le dio $100.00 pesos a ofelia\r\n23/mayo/07 planchado de cejas ofelia\r\n17/nov/07 plachado de cejas reyna entro 1:00\r\n13/dic/07 planchado de cejas mary lazaro\r\n17/ene/08 planchado de cejas ofelia\r\n26/feb/11 promocion trat. de seda mary lazaro llevo pantalla solar, crema de ojos \r\ntimexpert lift, crema de hidratacion piel normal/seca de germaine se le receto \r\nseresis, omega 3,6 y 9.\r\nipl$1000.00 c/s\r\n1.-26/feb/11 prog. ii int. 3 mary lazaro \r\n2.-26/marzo/11 ipl prog. ii int. 5 lucy \r\n3.-7/mayo/11 prog. ii int. 5 lucy \r\n4.-11/junio/11 prog. i int. 5 rosy \r\n5.-22/julio/11 prog. i int. 5 lucy \r\n6.- 20/agosto/11 ipl int. 5\r\n7.- 23/sep/11 ipl int. 5 reyna \r\n\r\n\r\n26/marzo/11 promocion elastine araceli entro 12:29\r\n16/abril/11 promocion vinoterapia, planchado de cejas reyna entro 12:43\r\n7/mayo/11 promocion botanico sara entro 11:55\r\n11/junio/11 planchado de cejas araceli \r\n22/junio/11 promocion estimulante de endorfinas mariana\r\n9/julio/11 promocion de amaranto, planchado de cejas karina entro 10:25\r\n22/julio/11 llevo crema facial piel mixta infinitime \r\n\r\nllevo crema de noche y crema contorno de ojos de infinitime\r\n25/ene/12 promocion revitalizante, planchado de cejas reyna entro 1:05\r\n25/feb/12 promocion 3 geles sara entro 1:15\r\n24/marzo/12 planchado de cejas aracely entro 11:45\r\n30/marzo/12 promocion hidradermis deyanira entro 11:30\r\n5/mayo/12 promocion velo de colageno, planchado de cejas lucy entro 12:15\r\n27/julio/12 promocion hidratante de arroz y planchado de cejas araceli entro 2:40\r\n28/agosto/12 promocion hidratante y reafirmante, planchado de cejas araceli entro 2:05\r\n30/oct/12 promocion reafirmante de cuello, planchado de cejas araceli entro 12:10\r\n8/dic/12 promocion de oro, planchado de cejas gladys entro 1:00\r\n19/ene/13 promocion lifting de parpados, planchado de cejas reyna entro 12:20\r\n9/marzo/13 promocion royal jelly, depilacion y planchado de cejas gladys entro 12:35\r\n13/mayo/13 promocion relejante e hidratante, planchado de cejas reyna entro 11:00\r\n29/junio/13 promocion coco y mango, depilacion de cejas rosy entro 11:40\r\n24/agosto813 promocion oxigenante, planchado de cejas rosy entro 11:30\r\n30/mayo/14 promocion masaje holistico, facial hidratante, planchado de cejas nelli entro 3:15\r\n19/nov/14 promocion facial antiedad humectante y nutritivo, planchado de cejas brenda entro 12:50\r\n17/dic/14 promocion trat. global antiedad lucero entro 1:00 planchado de cejas lucy entro 2:00\r\ninicia radiofrecuencia facial $1500.00 cada sesion\r\n7/enero/15 radiofrecuencia facial reyna entro 4:00\r\n14/enero/15 radiofrecuencia facial johany entro 3:45\r\n18/febrero/15 radiofrecuencia facial reyna entro 3:40\r\n28/marzo/15 promocion tratamiento anti-edad lucy entro 11:00\r\n28/marzo/15 planchado de cejas sra. bego\r\n15/abril/15 promoción tratamiento de porcelana maribel entro 3:50\r\n13/mayo/15 promocion catiodermia y planchado de cejas ana entro 2:10\r\n10/julio/15 promocion trat de cuello y planchado de cejas candy entro 11:55\r\n07/agosto/15 promocion trat chocoterapia graciela entro 9:20\r\n24/agosto/15 promocion chocoterapia y planchado de cejas graciela entro 12:00\r\n17/sept/15 promocion equilibrante del ph reyna entro 3:10\r\n22/oct/15 promocion reafirmante, planchado de cejas reyna entro 2:55\r\n5/nov/15 promocion antiedad humectante y nutritivo y planchado de cejas maria entro 5:20\r\n28/dic/15 promocion reafirmante y planchado de cejas candy entro 10:55\r\n17/feb/16 promocion roll & lift y planchado de cejas charito entro 1:35\r\n4/mayo/16 promocion trat de colageno y planchado de cejas rosy entro 3:30\r\n9/junio/16 promocion de elastina y planchado de cejas maria entro 2:00\r\n9/julio/16 promocion de colageno y planchado de cejas reyna entro 11.10\r\n2/agosto/16 limpieza facial mirena entro 3:10\r\n2/agosto/16 promocion de caviar carmen entro 3:20\r\n30/sept/16 promocion de colageno y planchado de cejas mariana entro 3:05\r\n11/oct/16 promocion de colageno maria entro 3:00\r\n10/nov/16 delienado de cejas ofelia entro 2:30, se le dio $100..0 a ofelia\r\n11/nov/16 delineado de parpado infeior ofelia,  sel eido $100.00 a ofelia\r\n24/nov/16 retoque de cejas ofelia, se le dio $100.00 a ofelia\r\n25/nov/16 retoque de parpado inferior ofelia, se le dio $100.00 a ofelia\r\n10/marzo/17 promocion estimulante de colageno con masc. led y planchado de cejas susy entro 11:\r\n27/julio/17 masaje full relax (cleinte frecuente )monica entor 10.25\r\n27/julio/17 promocion trat relajante e hidratante  y planchado de cejas anita\r\n24/agosto/17 promocion desvanece las lineas del tiempo y planchado de cejas anita entro 11:00\r\n16/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL ANITA ENTRO 2:40\r\n22/DIC/18 LIMPIEZA FACIAL BELÉN ENTRO 12:00\r\n25/FEBRERO/19 MASAJE REDUCTIVO ROSY ENTRO 3:35 MEGA\r\n29/MARZO/19 PROM TRATAMIENTO FACIAL DETOX CON AMP BEAUTÉ IV Y PLANCHADO DE CEAS OFELIA ENTRO 11:15\r\n5/JUNIO/19 PROM TRATAMIENTO FACIAL REVOLUCIONARIO Y PLANCHADO DE CEJAS LUPITA ENTRO 11:30\r\n18/agosto/19 promocion del mes tratamiento de porcelana mony entro 12:10 mega\r\n12/OCT/19 PROMOCION DOBLE ACCION, PLANCHADO DE CEJAS MARY LAZARO ENTRO 11:20\r\n22/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS Y PLANCHADO DE CEJAS LUPITA ENTRO 2:15\r\n10/DIC/19 PROMOCION TRAT 24 K LUPITA ENTRO 12:05\r\n5/JULIO/2021 PROM. TRATAMIENTO FACIAL CAVIAR Y ORO OFELIA ENTRO 1:50\r\n8/JULIO/2022 PROMOCION TRAT ROLL & LIFT, PLANCHADO DE CEJAS JHOANY ENTRO 12:55\r\n22/NOVIEMBRE/2022 PROMOCION TRAT. FACIAL REPARADOR CELULAR, PLACHADO DE CEJAS MARIANA ENTRO 9:55\r\n2/MARZO/2023 PROMOCION TRAT. MICRODERMA ANTIEDAD CON AMP. ACIDO HIALURONICO DE CASMARA, PLANCHADO DE CEJAS OFELIA ENTRO 11:50\r\n14/JULIO/2023 PROMOCION TRAT. COOPING FACIAL, PLANCHADO DE CEJAS LUCY ENTRO 10:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-14 14:06:37', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('1010', 'C-101010', '', 'LOURDES LOZADA FERNANDEZ', '9932093004', '', '11/marzo/18 limpieza facial 2x600 susy entro 1:10 (mega)\r\n11/agosto/18 limpieza facial 2x600 lupita entro 2:15 (mega)\r\n25/agosto/18 mdm full relax 2x600 lupita entro 12:05 (mega)\r\n21/octubre/18 prom. del mes trat. reafirmante monica entro 4:10 (mega2\r\n27/abril/19 limpieza facial 2x600 con ampolleta beute 111 rosy entro 5:05 mega)\r\n15/FEBRERO/2020 FULL RELAX Y LIMPIEZA FACIAL 2X600 JANETH ENTRO 12:13 MEGA \r\n29/12/2020 limpieza facial 2x1 atendio arleyh suc mega \r\n31/JULIO/2021 LIMPIEZA FACIAL 2X600 *CON AMP. REAFIRMANTE* ROSI ENTRO 12:55 MEGA\r\n16/JULIO/2022 LIMPIEZA FACIAL 2X600  *CON AMPOLLETA DE COLAGENO BEAUTY II  Y DEPILACION DE CEJAS  MONICA ENTRO 1:00(MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-07-16 10:27:23', '1', '26', null, null);
INSERT INTO `clientes` VALUES ('1011', 'C-101011', '', 'ALEJANDRA PEREYRA', '9931600774', '', '14/mayo/17 mdm full relax y limpieza facial 2x600 lizbeth entro 1:05 (mega)\r\n24/febrero/18 limpieza de acne susy entro 7:15 (mega)\r\n11/marzo/18 limpieza de acne 2x600 monica entro 1:10 (mega)\r\n24/marzo/18 limpieza de acne monica entro 6:05 (mega)\r\n07/abril/18 limpieza de acne rosy entro 6:10 (mega)\r\n07/junio/18 limpieza de acne candy entro 12:00 (mega)\r\n11/agosto/18 limpieza de acne susy entro 2:10 (mega)\r\n25/agosto/18 mdm full relax 2x600 rosy entro 12:05 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1012', 'C-101012', '', 'MAYRA GARCIA VENEGAS', '9931679720', 'galatas80@hotmail.com', '/S1927/DIC/18 LIMPIEZA FACIAL Y MDM FULL RELAX 2 X 600 KARLA ENTRO 5:10\r\nEP/19 PROM. DEL MES TRATAMIENTO OXIGENANTE JANETH ENTRO 6:05 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1013', 'C-101013', '', 'LUIS ALBERTO NAJERA DIAZ', '9932221523', 'l_a_n_d_@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1014', 'C-101014', '', 'BENITA DE LOS SANTOS PATRICIO', '9932003047', 'beny-2025@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1015', 'C-101015', '', 'MARIA MAGDALENA GOMEZ PEREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1016', 'C-101016', '', 'IVON GOMEZ GOMEZ', '', 'blue_bombon@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1017', 'C-101017', '', 'VICENTE QUESADA PEREZ', '9331126027', '', '04/FEB/2022 MASAJE DESCONTRACTURANTE MONICA ENTRO 16:47 MEGA\r\n27/MAYO/2022 MASAJE DESCONTRACTURANTE MONICA ENTRO 16:00 MEGA\r\n26/AGOSTO/2022 MASAJE DESCONTRACTURANTE MONICA ENTRO 4:17 (MEGA)\r\n23/JUNIO/2023 MASAJE DESCONTRACTURANTE ROSY ENTRO 6:41 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-23 20:40:45', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('1018', 'C-101018', '', 'MARTHA PATRICIA GALMICHE LOPEZ', '19333330139', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1019', 'C-101019', '', 'ELIZABETH JIMENEZ MATEO', '9934462226', '', '27/julio/17 masaje drenaje linfatico susy entro 4.10\r\n11/OCTUBRE/19 LIMPIEZA FACIAL PROFUNDA (se le realizo extraccion suave y se le aplico mascarilla de azul heno porque padece de rosacea) ROSI ENTRO 5:00 MEGA\r\n17/NOV/2020 HYDRAFACIAL MARY LAZARO ENTRO 4:00\r\n19/DIC/2020 TRATAMIENTO FACIAL CON WELLBOX ($1,000.00) LUCY ENTRO 8:00\r\n31/MARZO/2021 HYDRAFACIAL ANITA ENTRO 9:50\r\n1/MAYO/2021 VITAMINA C DE NATURA BISSE OFELIA ENTRO 11:45 ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1020', 'C-101020', '', 'KATHIA ZOE CADENA CORTES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1021', 'C-101021', '', 'LLUVIA GALAN ALVARADO', '9931086924', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1022', 'C-101022', '', 'SILVIA VALENZUELA LOPEZ', '9931777548', '', '22/mayo/06 micro lucy\r\n20/mayo/06 llevo fluido reactivador secuencial y filtro solar bbr lait.\r\n19/agosto/10 skinlight punta de diamante lupita entro 8:40\r\n23/agosto/10 timexpert lift sara entro 8:30 \r\n7/nov/10 promocion modeladora graciela entro 2:35 (sucursal) \r\n14/nov/10 limpieza de acne con amp. desincrustante indira entro 3:20 (sucursal) \r\nllevo emulsion timexpert lift\r\nse le dio glycocell y crema contorno de ojos timexpert lift\r\nmicro con skinlight $650.00 c/s\r\n1.-\r\n2.-25/agosto/10 lupita \r\n3.-3/sept/10 gladys entro 8:35 llevo emulsion timpexpert lift\r\n4.-8/sept/10 gladys entro 8:40\r\n5.-13/sept/10 cristales gladys entro 9:10\r\n6.-20/sept/10 cristales gladys entro 8:45\r\n7.-25/sept/10 skinlight karina\r\n8.-02/oct/10    cristales    gladys    entro\r\n9.-7/oct/10 cristales mary entro 6:15\r\n10.-16/oct/10 cristales mary  entro 10:55 \r\n11.-24/oct/10 cristales indira entro 11:35 salio 1:00 (sucursal)\r\n12.-31/oct/10 cristales indira entro 4:15\r\n13.-4/nov/10 cristales indira (sucursal)\r\n14.-28/nov/10 cristales indira entro 1:30 (sucursal)\r\n15.-5/dic/10 cristales indira entro 2:00 salio 3:45 (sucursal) \r\n16.-12/dic/10 cristales indira entro 3:00 (sucursal) \r\n17.-9-ene-11 cristales indira entro 3:30 sucursal\r\n18.-16/ene/11 cristales indira entro 3:05 (sucursal)\r\n19.-13/feb/11 cristlaes indira entro 5:30 salio 6:35 (sucursal) \r\n13/03/11 micro-cristales. atendio: indira entro: 6:00pm salio: 7:05pm (suc)\r\n27/03/11 micro-cristales.atendio: indira entro: 2:20pm salio: 3:20pm (suc)\r\n03/04/11 micro-cristales atendio: indira. entro:5:00pm salio:6:00pm( suc)\r\n15/05/11 micro cristales atendio indira entro 4:10 pm salio 5:15 pm (suc)\r\n  \r\n16/05/11 inicio tratamiento reductivo( costo $ 3.000 pagado)  peso inicial 76.500 kg y\r\nsus medidas:\r\n\r\naddómen        83\r\nbusto               107\r\ncintura              85\r\ncadera alta      101\r\ncadera baja     109\r\nbrazo                  36\r\nmuslo                 57\r\n\r\n1.- 16/05/11 masaje reductivo atendio jhoany entro 7:20 pm salio 8:40 pm (suc)\r\n2.- 17/05/11 masaje reductivo atendio jhoany entro 7:15 pm salio 8:10 pm (suc)\r\n3.- 20/05/11 masaje reductivo atendio jhoany entro 7:05 pm salio 7:55  pm (suc)\r\n4.- 21/05/11 masaje reductivo atendio jhoany entro 10:20 am salio 11:15 am (suc)\r\n5.- 22/05/11 masaje reductivo atendio jhoany entro 10:05 am salio 11:00 am (suc)\r\n6.- 29/05/11 masaje reductivo atendio jhoany entro 10:20 am salio 11:25 am (suc)\r\n7.- 31/05/11 masaje reductivo atendio  jhoany entro 7:15  pm salio  pm 8:15 pm (suc)\r\n8.- 02/0611 masaje reductivo atendio jhoany entro 7:00 pm salio pm 8:00 pm (suc)\r\n9.- 03/06/11 masaje reductivo atendio jhoany entro 7:15 pm salio 8:05 pm (suc)\r\n10- 05/06/11 masaje reductivo atendio jhoany entro 11:10 am salio pm (suc) termino.\r\n\r\n\r\n21/05/11 micro cristales atendio indira entro 11:30 am salio 12:55 pm (suc) compro crema correctora\r\npearl sensation\r\n29/05/11 micro cristales atendio jhoany entro 11:36 am salio12.55 pm (suc)\r\n05/06/11 micro cristales atendio indiora entro 12:,10 pm salio 1:48 pm (suc)\r\n14/06/11 masaje reductivo atendio jhoana entro 7:00 pm salio pm (suc)\r\n19/06/11 masaje reductivo atendio jhoany entro 10.20 am salio 12:53 (suc)\r\n19/06/11 micro cristales atendio jhoany entro 12:36 pm salio1:50 pm (suc)\r\n26/06/11 micro cristales atendio jhoany entro 5:49 pm salio (suc mega\r\n26/06/11 masaje de espalda atendio jhoany \r\n03/07/11 micro ciritales atendio indira 3:46 am salio5:00  pm (suc mega)\r\n03/07/11 mdm de drenaje linfatico atendio jhoany 5:10 pm salio pm (suc mega)\r\n9/julio/11 delineado de parpado superior, se le dio $100.00 pesos a ofelia \r\n11/08/11 limpieza de acne entro indira 7:05 salio 8.20pm ( suc comer)\r\n14/08/11 tratamiento hidracuré atendio indira entro 3.00 pm salio5.00  (suc mega)\r\ncompro infinitime anti edad global\r\n21/08/11 micro cristales y dep de bigote atendio indira entro 5.44 salio\r\n01/09/11 depilacion de pierna completa entro indira 7:00 salio 7:40( suc comer)\r\n04/09/11 micro cristales atendio indira entro 6:30 pm salio (suc mega)\r\n11/09/11 compro cuello almohada herbal suc mega\r\n25/09/11 micro-cristales atendio:indira entro:2:30pm salio:3.45pm (suc mega)\r\n17/10/11 dep de bigote y piernas completa atendio deyanira sra bego entro 7.00 (mega)\r\n23/10/11 microcristales atendio indira entro 4.00 salio (mega)\r\n30/10/11 microcristales atendio indira entro 1:00 salio (mega) que hoy si le ardio la micro por \r\n\r\nprimera vez.\r\n25/11/11/ microcristales atendio jhoany entro 7:05 (mega)\r\n30/01/12 dep de piernas y bigote atendio jhoany entro 2.50 (mega)\r\n30/01/12 compro depifin masc infinetime, timexperlift concentrado  \r\n14/04/12 dep.piernas completas atendio deyanira 12:05 mega)\r\n2204/12 dep.. bigote deya entro 5:00 mega\r\n13/05/12 serealizo micro depilacion de piernas conpletas atendio jhoany entro 2:25(mega)\r\n1305/12 mdm  drenaje linfatico jhoany entro 4:00 mega\r\n26/05/12  serealizo limp de acne atendio yhoany entro 7:00(mega)\r\n27/05/12 serealizo microcristeles atendio yhoany entro 11:10 (mega9\r\n01/07/2012 lim. facial dep. de piernas completas atendio jhoany entro 3:54\r\n22/julio/12 depilacion de piernas jhoana entro 6:35 mega\r\n19/agosto/12 dep. pantorrillas atendio deya entro 7:15 mega\r\n15/09/12 trat. masajes reductivos atendio jhoany entro 6:05 mega\r\n16/09/12 trat. masajes reductivos atendio deya entro 5:00 mega\r\n17/09/12 masaje reductivo atendio jhoany entro 2:55 mega\r\n20/09/12 masaje reductivo atendio jhoany entro 7:20 mega\r\n21/09/12 masaje reductivo atendio jhoany entro 7:00 mega\r\n22/09/12 masaje reductivo atendio jhoany entro 1:15 mega\r\n23/09/12 masaje reductivo y carbox atendio jhoany entro 1:20 mega\r\n25/09/12 masaje reductivo atendio deya entro 7.30 mega\r\n26/09/12 masaje reductivo atendio brenda entro 7:15 mega\r\n30/09/12 masaje reductivo atendio brenda entro 5:35 mega\r\n\r\n01/10/12 inicio masaje/reductivo atendio deya entro 2:35 mega\r\n5/10/12 masaje rerductivo atendio jhoany entro 3:10 mega\r\n6/10/12 masaje reductivo atendio jhoany entro 2:05 mega\r\n7/10/12 masaje reductivo y depilacion de piernas atendio brenda entro 4:40 mega\r\n11/10/12 masaje reductivo atendio jhoany entro 2:00 mega\r\n14/10/12 masaje reductivo y lim. facial atendio jhoany entro 1:25 mega\r\n28/10/12 depilacion de media pierna atendiobrenda entro 5:20 mega\r\n9/12/12 depilacion de pierna completa atendio brenda entro 2:50 mega\r\n15/ene/13 dep. de media pierna atndio jhoany entro 3:00 mega\r\n10/03/13 dep. pierna completa atendio jhoany entro 12:20 mega \r\n05/05/13 lim. facial y dep de pierna completa atendo jhoany entro 6:10 mega \r\n06/06/13 dep. pantorrilla brenda mega entro 7-20\r\n23/06/13 dep pñantorrilla jhoany 7:20 mega\r\n21/07/13 dep. pierna completa brenda mega 7.00\r\n28/07/13 promocion de julio colageno y elastine jhoany mega 6.50\r\n08/09/13 dep. de pierna completa jhoany mega 1:30\r\n26/10/13 dep. pantorrilla mega jhoany 3:15\r\n08/12/13 dep de media pierna atendio jhoany mega entro 1:45\r\n02/02/14 promocion mes febrero y dep de piernas jhoany mega entro 5:00\r\n27/04/14 dep de piernas completas y lim facial graciela mega 1:55\r\n27/07/14 dep de piernas completas susi mega 4.00\r\n07/sept/14 dep piernas completas y limpieza facial nely entro 4:15(mega)\r\n18/ene/15 limpieza facial y dep. piernas completas candy entro 3:30 (mega)\r\n03/mayo/15 micro martha y masaje reductivo entro 2:20 (mega)\r\n02/junio/15 dep. piernas completas rosy entro 1:00 (mega)\r\n16/sept/15 promocion del mes rosy entro 6:35 (mega)\r\n27/sept/15 mdm drenaje linfatico maribel entro 4:25 (mega)\r\n11/octubre/15 mdm drenaje linfatico y prom. del mes trat. reafirmante susy entro 3:20 (mega)\r\n18/octubre/15 mdm drenaje linfatico y prom. del mes trat. reafirmante susy entro 3:25 (mega)\r\n25/octubre/15 mdm drenaje linfatico y prom. del mes trat. reafirmante susy entro 3:25 (mega)\r\n23/octubre/16 prom. del mes colageno lizbeth entro 12:45 (mega)\r\n02/abril/17 limpieza facial lizbeth entro 11:10 (mega)\r\n31/agosto/19 mdm full relax janeth entro 4:00 mega\r\n02/septiembre/19 INICIA TRATAMIENTO REDUCTIVO PAGO 3000 PESOS, INICIA CON PESO DE 74.5\r\nSUS MEDIDAS SON: ABDOMEN 90, BOSTO 108, CINTURA 89, CADERA ALTA 105, CADERA BAJA 111,BRAZO 32, MUSLO 67.\r\n1.- MSJ 45 MIN 03/sep/19 susy entro 12:00 mega\r\n2.- MSJ 45 MIN 04/sep/19 janeth entro 11:05 mega\r\n3.- MSJ 45 MIN 09/sep/19 mony entro 5:10 mega\r\n4.- MSJ 45 MIN 10/sep/19 janeth entro 5:05 mega\r\n5.-MSJ 45 MIN 12/sep/19 rosy entro 11:20 mega\r\n6.- MSJ 45 MIN 16/SEP/19 JANEHT ENTRO 5:00 MEGA\r\n7.-MSJ 45 MIN 17/SEP/19 MONY ENTRO 5:15 MEGA\r\n8.- MSJ 45 MIN 18/sep/19 janeth entro 5:10 mega\r\n9.- MSJ 45 MIN 24/sep/19 janeth entro 11:25 mega\r\n10.- MSJ 45 MIN\r\n4/sep/19 limpieza facial basica  janeth  entro 12:00 mega\r\n02/OCT/19 INICIA TRATAMIENTO CORPORAL PAGO 3000 PESOS.\r\n1.- MSJ 45 MIN 02/OCT/19 YANETH ENTRO 5:10 MEGA\r\n2.- MSJ 45 MIN 03/OCT/19 YANETH ENTRO 11.20 MEGA\r\n3.- MSJ 45 MIN 23/OCTUBRE/19 YANETH ENTRO 4:05 MEGA\r\n4.- MSJ 45 MIN 24/OCTUBRE/19 JANETH ENTRO 6:05 MEGA\r\n5.- MSJ 45 MIN 28/OCTUBRE/19 JANETH ENTRO 7:00 MEGA\r\n6.- MSJ 45 MIN 29/OCTUBRE/19 JANETH ENTRO 6:00 MEGA\r\n7.- MSJ 45 MIN 30/OCTUBRE/19 JANETH ENTRO 5:09 MEGA\r\n8.- MSJ 45 MIN 1/NOVIEMBRE/19 JANETH ENTRO 5:10 MEGA\r\n9.- MSJ 45 MIN 13/NOVIEMBRE/19 JANETH ENTRO 5:00 MEGA\r\n10.- MSJ 45 MIN\r\n24/OCTUBRE/19 LIMPIEZA FACIAL JANETH ENTRO 7:00 MEGA\r\n28/OCTUBRE/19 MICRODERMABRASION ROSI ENTRO 6:00 MEGA\r\n\r\n5/NOVIEMBRE/19 INICIO TRATAMIENTO DE MICRODERMABRASION PARA MARCAS DE ACNE (PAGO 3,200) SE LE ENTREGO PRODUCTO DE APOYO EN CASA:\r\n   *GEL DE ELASTINE\r\n   *GLICOCEL\r\n   *BRUMA SOLAR (PAGO DIFERENCIA DE 645, YA QUE EL FILTRO SOLAR HELIOCARE EN GEL LE RESECA LA PIEL TANTO LA MARCA COMO EL PRODUCTO)\r\n1.- 5/NOVIEMBRE/19 MICRO PARA MARCAS DE ACNE CON POLVO DE CRISTALES (intensidad 9) SUSI ENTRO 5:05 MEGA\r\n2.- 12/NOVIEMBRE/19 MICRO PARA MARCAS DE ACNE CON POLVO DE CRISTALES (intesidad 9) JANETH ENTRO 7:10 MEGA\r\n3.-21 /noviembre/19  MICRO DERMOBRASION  JANETH ENTRO 12.15 MEGA\r\n4.- 10/DICIEMBRE/19 MICRO DE PUNTA SUSI ENTRO 7:00 MEGA\r\n5.- 16/DICIEMBRE/19 MICRO DE PUNTA MONI ENTRO 6:10 MEGA\r\n6.-13/ENERO/2020 MICRO DEPUNTA ROSY ENTRO 6:12 MEGA\r\n7.- 16/MARZO/2020 MICRO CON POLVO MONI ENTRO 6:05 MEGA (PIDIO QUE SE LE TRABAJARA UNICAMENTE ROSTRO, AREA DE PECTORALES Y BIGOTE NO)\r\n8.-\r\n9.-\r\n10.-\r\n11.-\r\n12.-\r\n13.-\r\n14.-\r\n15.-\r\n\r\n14/NOVIEMBRE/19 DEPILACION CON CERA PIERNAS SUSI ENTRO 5:30 MEGA\r\n23/ENERO/2020 DEPILACION DE PIERNAS COMPLETAS SUSI ENTRO 11:19 MEGA\r\n13/FEBRERO/2020 DEPILACION DE PIERNAS COMPLETAS ROSI ENTRO 1:57 MEGA (PIDIO QUE SE LE BAJAR EL VOLUMEN A LA MUSICA Y QUE SE CAMBIARA DE CANCION)\r\n17/MARZO/2020 DEPILACION DE PIERNAS COMPLETAS ROSY ENTRO 2:13 MEGA (LA SEÑORITA POR SEGUNDA OCASION SE QUEJO DE LA MUSICA DICIENDO QUE TENIA EL VOLUMEN MUY ALTO, SE PROCEDIO A BAJAR EL VOLUMEN, PIDIO QUE SE LE CAMBIARA LA MUSICA, PIDIO TAMBIEN QUE SE LE APAGARA EL CLIMA Y AUN ASI NO QUEDO CONTENTA, LA MUSICA ESTABA CASI APAGADA, SUPERVISO DOÑA ROSY).\r\n ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1023', 'C-101023', '', 'MARCELA GONZALEZ', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1024', 'C-101024', '', 'BEATRIZ MENDEZ LOPEZ', '', 'betyfrias@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1025', 'C-101025', '', 'MARGARITA MENDEZ LOPEZ', '9231312632', '', '7/NOVIEMBRE/19 MDM FULL RELAX Y LIMPIEZA FACIAL 2X600 MONI ENTRO 2:05 MEGA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1026', 'C-101026', '', 'MARISOL ORTEGA SALAZAR', '', 'm-ortega.75@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1027', 'C-101027', '', 'JOEL SANTOS JOACHIN', '9931605468', 'jsantosj812@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1028', 'C-101028', '', 'CECILIA DE LOS ANGELES TORRES MORALES', '9932306094', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1029', 'C-101029', '', 'DAVID CORREA LEON', '', 'dacole1@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1030', 'C-101030', '', 'MARIA LUISA PEREZ MATRINEZ', '9931172075', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1031', 'C-101031', '', 'CARLOS ARRIOLA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1032', 'C-101032', '', 'IVONNE MEZA MORENO', '', 'ivonne2275@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1033', 'C-101033', '', 'LETICIA PALACIOS CORDOVA', '9933115946', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1034', 'C-101034', '', 'CELIA MORALES FERIA', '9932051258', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1035', 'C-101035', '', 'BRENDA DE LEON VIRRUETA', '993111446', '', 'dep. piernas completas $1500.00 c/s, axila $360.00c/s,\r\n dedos de pie $180.00 c/s brazos completos $1125.00 c/s\r\n\r\n1ª sesion 14/mayo/10 piernas com, axila y dedos, brazos completos aut 20 j mary l\r\n2ª sesion 15/junio/10 piernas completas, axila, dedos, brazos completos autom. 20 j mary l \r\n3ª sesion 19/agosto/10 piernas completas, axila, dedos, brazos autom. 22 j mary lazaro\r\n4ª sesion 7/oct/10 piernas completas,axila aut 23 j lucy\r\n\r\n\r\n\r\ndepilacion de bigote $180.00 c/s  bikini $450.00 c/s\r\n1ª sesion 15/junio/10 bigote, bikini 30 ms 18 j mary l\r\n2ª sesion 19/agosto/10 bigote, bikini 30 ms 18 j mary lazaro\r\n3ª  sesion 08/oct/10 brazos,bigote,bikini  lucy \r\n\r\n26/dic/11 5ta. sesion piernas completas 30 ms 36 j lucy\r\n26/dic/11 4ta sesion brazos, bigote 30 ms 36 j lucy \r\n22/feb/12 bikini 30 ms 26 j lucy\r\n30/marzo/12 piernas completas 30 ms 36 j, 1/2 brazo 30 ms 24 j, bikini, bigote 30 ms 26 j rosy \r\n25/julio/12 piernas completas, brazos completos, bikini, bigote autom. 60 j lucy \r\n30/oct/12 piernas completas, brazos completos, bigote autom. 60 j lucy\r\n28/nov/12 bikini autom. 60 j reyna\r\n15/mayo/13 1/2 brazo, bigote, bikini autom. 60 j rosy \r\n24/julio/13 1/2 brazo solo lado de arriba, bigote autom. 60 j rosy\r\n25/julio/13 piernas solo donde hay vello $750.00 autom. 60 j, bikini autom. 60 j lucy\r\n12/sept/13 rizado de pestañas reyna entro 12:15\r\n22/oct/13 1/2 brazo / bikini autom 60 lucy 1:25\r\n2/ene/14 rizado de pestañas mariana entro 2:00\r\n3/ene/14 1/2 brazo, bikini, bigote 30 ms 30 j rosy\r\n3/ene/14 limpieza facial $395.00 con amp. acido hialuronico $300 rosy entro 5:00\r\n30/mayo/14 1/2 brazo, bikini autom. 12 j, bigote autom. 10 j reyna\r\n28/agosto/14 bikini y medio brazo reyna entro 9:40\r\n01/nov/14  1/2 brzo aut-24, bikini aut-22, bigote au- 20 reyna la srta quizo ke se le pasara varias \r\n\r\n11/nov/15 medio brazo aut-26j mary lazaro\r\n22/julio/16 1/2 brazo aut-26j lucy\r\n\r\n20/dic/16 1/2 brazo aut-26j lucy\r\n24/mayo/17 retoque de medio brazo autom. 30 j lucy entro 6:25\r\n6/dic/17 retoque de medio brazo autom. 30 j mary lazaro\r\n13/AGOSTO/18 LASER DE CODOS  AUT 12 J COSTO 360.00\r\n11/ENE/19 LASER DOLO DE CODOS COSTO 360 SOLO CODOS \r\n9/SEP/19 LASER DE CODOS AUT 18J ( LA SRA LE MARCO CON EL PLUMON EL AREA 360.00 )   LUCY ENTRO 6:10\r\n29/ENERO/20 LASER DE CODOS AUT  18 J  LUCY ENTRO 3:00\r\n4/AGOSTO/2020  CODOS Y MEDIO BRAZO  AUT 20 J $750.00 Y BIKINI AUT 20 J $450.00 LUCY\r\n8/DIC/2020 RETOQUE DE CODOS (PARTE DE ARRIBA DEL ANTEBRAZO $360.00) LUCY\r\n13/JULIO/2021 RETOQUE DE CODOS  360.00 MARY LAZARO', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1036', 'C-101036', '', 'SHIRLEY ARZAT ALEJANDRO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1037', 'C-101037', '', 'ANA CONSUELO JIMENEZ LOPEZ', '9171010157', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1038', 'C-101038', '', 'IBRAHIM MORUA DELA ROSA', '9331240225', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1039', 'C-101039', '', 'MILITZA TRUJILLO HERNANDEZ', '9931896632', '', '9/enero/16 limpieza de acne con amp. desincrustante  candy entro 9:30\r\n18/marzo/16 limpieza de acne con amp. desincrustante candy entro 12:15 (mega)\r\n20-07-16 se realizo l-fa candy cristal 10-20\r\n21/agosto/17 limpieza de acne con amp. desincrustante lizvet entro 9:25\r\n19/oct/17 limpieza de acne con amp. desincrustante mary lazaro', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1040', 'C-101040', '', 'MARIA EUTIMIA DE LA CRUZ PEREZ', '9933912222', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1041', 'C-101041', '', 'BEATRIZ PULIDO CAMPOS', '9931964575', '', '17/feb/11 limpieza facial 2 x 1 susy entro 4:00 (sucursal) \r\n28/02/11 tratamiento piel de seda atendio:susi entro 11:30am-12:45pm. sucursal.\r\n26/05/11 trat,botanico 4f atendio:graciela entro:11:42am salio.1:10pm (suc)\r\n29/sep/11 promocion azteca karina entro 11:05\r\n15/dic/11 promocion velo de colageno sara entro 3:00\r\n26/ene/12 promocion revitalizante reyna entro 4:00\r\n30/marzo/12 depilacion bikini, axila, linea de abdomen lucy entro 6:15\r\n12/abril/12 promocion revitalizante aracely 11:55\r\n31/mayo/12 promocion velo de colageno aracely entro 5:30\r\n12/julio/12 promocion hidratante de arroz rosy entro 12:00\r\n13/sept/12 promocion de agave araceli entro 11:30\r\n11/oct/12 promocion reafirmante de cuello karina entro 5:00\r\n29/nov/12 promocion de colageno reyna entro 3:55\r\n31/ene/13 promocion lifting de parpados gladys entro 12:00\r\n21/marzo/13 promocion royal jelly mariana entro 3:00\r\n25/abril/13 promocion porcelana rosy entro 5:00\r\n20/junio/13 promocion coco y mango yusiria entro 5:55\r\n3/abril/14 promocion de porcelana nelli entro 11:30\r\n26/sept/13 promocion lifting anti arrugas yusiria entro 11:00\r\n31/oct/13 promocion the verde ana entro 3:05 llevo shampoo y masc. capilar hidronutritivo\r\n6/feb/14 promocion eternamente lucy entro 11:00\r\n17/julio/14 promocion trat de colageno yusi entro 4:45\r\n21/agosto/14 promocion oxigenante yusiria entro 4:00\r\n09/oct/14 promocion del mes trat. smoothie carmen entro 4:13 \r\n27/nov/14 promocion trat facial humectante y nutritivo ana entro 4:10\r\n26/febrero/15 promoción tratamiento reafirmante  johany entro 3:10\r\n30/marzo/15 criolipolisis reyna entro 3:00\r\n5/mayo/15 criolipolisis mirena entro 1:50\r\n14/mayo/15 promocion tratamiento de catiodermia reyna entro 4.00\r\n16/julio/15 promocion trat de cuello lucy entro 11:05 llevo diamond white oil-free\r\n27/agosto/15 promocion chocoterapia mary lazaro entro 11:00\r\n24/sept/15 promocion equilibrante del ph graciela entro 3.55\r\n12/nov/15 promocion antiedad fernanda entro 12:10\r\n25/feb/16 promocion roll & lift reyna entro 12.10\r\n2/junio/16 promocion de colageno anita entro 11:00\r\n14-07-16 se realizo prom del mes mariana 9-48\r\n25/agosto/16 promocidon de caviar maria entro 11:05\r\n22/sept/16 promoción de colageno maría entro 11:000\r\n27/oct/16 promocion de colageno carmen entro 10.55\r\n5/ene/17 promocion desintoxicante andrea entro 12:30\r\n23/feb/17 promocion trat de elastine anita entro 11:00\r\n30/marzo/17 promocion estimulante de colageno con luz leds carmen entro 11:00\r\n27/abril/17 promocion termico mary entro 3:50\r\n13/julio/17 promocion trata relajante hidratante  susy/anita entro 11.00\r\n31/agosto/17 promocion desvanece las lineas del tiempo susy entro 11:10\r\n30/nov/17 promocion termico humectante mary lazaro entro 12:00\r\n24/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD MARY ENTRO 2:05\r\n19/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL  ANITA\r\n20/OCTUBRE/2022 PROMOCION TRAT. FACIAL DE OBSIDIANA JHOANY ENTRO 10:05\r\n8/DICIEMBRE/2022 PROMOCION TRAT FACIAL GOLDEN CRISTINA ENTRO 12:15\r\n19/ENERO/2023 PROMOCION TRAT. PURIFICANTE CON AMP AGE COMPLEX \r\n JHOANY ENTRO 1:10\r\nLLEVO PROTECTOR SOLAR NATURA BISSE\r\n29/JUNIO/2023 PROMO TRATAMIENTO FACIAL ULTRASOUND KARLA ENTRO 11:10', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-01 12:56:45', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('1042', 'C-101042', '', 'LUISA FERNANDA GARCIA GUTIERREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1043', 'C-101043', '', 'ANA ISABEL VIDAL VIDAL', '9932123811', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1044', 'C-101044', '', 'YENI ZAPATA RAMIREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1045', 'C-101045', '', 'KARLA ORTIZ VIDAL', '7821452336', '', 'inicia depilacion laser de brasileño/total $650.00 cada sesion\r\n26/julio/16 1era. brasileño/tota aut-10j mary lazaro', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1046', 'C-101046', '', 'ANGELINA ARMENTA RODRIGEZ', '9931776636', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1047', 'C-101047', '', 'PERLA ALEJANDRA MORGAN DE LA CRUZ', '9331084088', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1048', 'C-101048', '', 'KATHUR PALOMERAS YABUR', '', 'makathur@hotmail.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1049', 'C-101049', '', 'LUISA KATHUR HENNE PALOMERAS', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1050', 'C-101050', '', 'CLAUDIA JEANETH HERNANDEZ BILBAO', '9932143365', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1051', 'C-101051', '', 'ISELA GERONIMO JIMENEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1052', 'C-101052', '', 'FLOR MARIA AZUETA CONTRERAS', '9932328206', 'rciller@prodigy.net.mx', '05/04/04 promocion botanico 4 f consuelo\r\n23/03/05 promocion antiarrugas marcela\r\n05/dic/05 limpieza facial marcela\r\n08/feb/06 promocion vinoterapia marcela\r\n31/mayo/06 promocion papaya y piña lucy\r\n06/nov/06 promocion antiarrugas marcela entro 4:10 salio 5:50\r\n22/nov/07 promocion hidratante con lifting marcela entro 4:50\r\n28/feb/11 promocion trat. de seda reyna entro 4:35 \r\n11/agosto/11 promocion piel de seda  karina entro  4:00\r\n04/nov/11 promocion germen de trigo karina entro 5:10\r\n27/junio/12 promocion reafirmante aracely entro 5:55\r\n3/sept/12 promocion de agave karina entro 5:10 llevo activador de celulas madres\r\n4/marzo/13 promocion royal jelly yusiria entro 4:40 llevo crema cuello y escote de timexpert lift\r\n13/junio/13 promocion coco y mango mariana entro 5:35\r\n28/abril/14 promocion trat de porcelana bego entro 4:40\r\n10/julio/14 mdm full relax lucero entro 1:15\r\n22/sept/14 promocion trat facial azteca carmen-bego entro 12:50\r\n24/febrero/15 promocion tratamiento reafirmante mirena entro 1:25\r\n7/mayo/15 masaje de espalda lucy entro 5:10\r\n7/mayo/15 promocion de catiodermia con amp, acido hyaluronico lucy entro 5:10\r\n24/agosto/15 promocion chocoterapia reyna entro 12:45\r\n19/ene/16 promocion desintoxicante y liftin ofelia entro 1:25 llevo ampolleta de germine y parches de ojos de pepino.\r\n6/junio/16 promocion de elastine mariana entro 12:25\r\n27/feb/17 promocion trat de elastine ofelia entro 12:45\r\n12/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO MARY ENTRO 12:30\r\nLLEVO CREMA JUVENTUD ESENCIAL EXCEL THERAPY\r\n26/FEB/19 LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 5:50\r\n19/DICIE,BRE/19 LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 6:00\r\n26/NOV/2020 LIMPIEZA FACIAL CON AMP. BEAUTE OFELIA ENTRO 6:00 LLEVO CREMA RECUPERADORA INTENSIVA TIMEXPERT SRNS\r\n21/JUNIO/2022 LIMPIEZA FACIAL 2X600 LUCY ENTRO 5:50\r\n27/OCTUBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CON AMP OXIGENANTE CRISTINA ENTRO 4:55\r\n14/JUNIO/2023 LIMPIEZA FACIAL KARLA ENTRO 1:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-14 13:51:36', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('1053', 'C-101053', '', 'ANA ZILLY RAMIREZ UCO', '9931928910', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1054', 'C-101054', '', 'ORLANDO MAUL LEON', '9331204701', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1055', 'C-101055', '', 'ARIANNA CRUZ CRUZ', '9933973124', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1056', 'C-101056', '', 'SHEILA TAJE SANCHEZ', '9932075039', '', '05/dicimbre/16 masaje full relaz 2x600 rosy entro 6.55 (mega)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1057', 'C-101057', '', 'HILDA PEREZ CALZADA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1058', 'C-101058', '', 'HUGO SANCHEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1059', 'C-101059', '', 'CAROLINA NUCAMENDI MALDONADO', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1060', 'C-101060', '', 'DARWIN JESUS CARRERA CRUZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1061', 'C-101061', '', 'PATRICIA FOJACO CORTES', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1062', 'C-101062', '', 'ASTRID MONSERRAT OVANDO RAMIREZ', '', '', '30/abril/16 limpieza de acne andrea entro 4:00 (mega)\r\n14/julio/16 limpieza de acne 2x600 charito entro 12:55 (mega)\r\n02/septiembre/16 limpieza de acne charito entro 7:25 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1063', 'C-101063', '', 'MONICA A. RAMIREZ GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1064', 'C-101064', '', 'RAUL ESTRADA HERNANDEZ', '9932632176', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1065', 'C-101065', '', 'KARLA PAOLA GONZALEZ GARCIA', '', '', '15/febrero/16 limpieza de acne entro 5:25 rosy (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1066', 'C-101066', '', 'MA. FERNANDA GONZALES GARCIA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1067', 'C-101067', '', 'GUADALUPE CARBALLO HIDALGO', '9931302410', 'lupitacarballo.25@hotmail.com', '28/ene/17 promocion desintoxicante y micro mariana entro 9:20\r\n29/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE MONICA ENTRO 2:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1068', 'C-101068', '', 'RAQUEL RAZQUIN RIVERO', '9932170948', '', '16/feb/11 limpieza de espalda indira entro 10:05 salio 11:10 (sucursal) \r\n14/05/11 limpieza facial 2x1 atendio susy entro 10:03 am salio 11:20 am (suc)\r\n09/10/11 limpieza facial 2x1 atendioindira entro 10.00 salio 11.10  (mega)\r\n22/10/11 masaje relajante 2x1 atendio graciela entro 7:00 salio 8.10 (mega)\r\n20/11/11 limpieza facial 2x1 atenedio:graciela entro:10:00am salio:11:15am (suc mega) compro\r\namp.hidracuré.\r\n10/12/11 limpieza facial 2x1 atendio jhoany enrtro 5.00 (mega)\r\n26/02/12 limp facial 2x1 atendio deyanira entro 10.00 (mega) con amp\r\nfinish y crema fluida regeneradora force vitamina c.\r\n21 04 2012 limpieza facial del 2x1 atendio brenda la comer entro a las 7 salio a las 8\r\n12/julio/12 depilacion de piernas completas jhoany entro 11:20 salio 12:05 (suc. la mega)\r\n30/09/12 depilacion de pierna completa atendio jhoany entro 10:00 mega\r\n29/09/12 lim. facial 2x1 atendio jenifer entro 7:10 mega\r\n8/11/12 depilacion de pierna completa atendio jhoany entro 10:05 mega\r\n8/12/12 promocion del atendio diana entro 11:05 mega\r\n14/01/13 dep. piernas completas c/ amp. depifin atendio jhoany entro 10:00 mega\r\n4/02/13 inicia reductivo/aparatologia atendio jhoany entro 10:05 mega\r\nabdomen 120\r\nbusto 121\r\ncintura 123\r\ncadera alta 134\r\ncadera baja 126\r\nbrazo 37\r\nmuslo 74\r\n5/02/|13 reductivo/aparatologia atendio jhoany entro 10:05 mega\r\n06/02/13 reductivo/aparatologia atendio jhoany entro 10:00 mega\r\n07/02/13 reductivo/aparatologia atendio brenda entro 10:05 mega\r\n8/02/13 reductivo/aparatologia atendio jeny entro 10:10 mega\r\n11/02/13 reductivo /aparatologia atenbdio jhoiany entro 10:00 mega\r\n12/02/13 reductivo/aparatologia atendio jhoany entro 10:10 mega\r\n13/02/13 reductivo/aparatologia atendio brenda entro 10:05 mega\r\n14/92/13 reductivo/aparatologia atendio jhoany entro 10:10 mega\r\n15/02/13 reductivo/aparatologia atendio jhoany entro 10:00 mega\r\n18/02713 carbox atendio jhoany entro 4:00 mega \r\n04/03/13 carbox atendio jhoany entro 3:50 mega\r\n12/03/13 inicia masaje reductivo con aparatologia  atendiobrenda entro: 10:05 mega \r\n13/03/13 corporal con aparatologia atendio brenda entro 10:00 mega \r\n14/03/13 corporal con aparatologia atendio brenda entro 9:55 mega \r\n15/03/13 corporal con aparatologia atendio brenda entro 1.0:00 mega \r\n16/03/13corporal con aparatologia atendio brenda entro 10:20 mega\r\n19/03/13 corporal con aparatologia atendio brenda entro 10:05 mega \r\n21/03./13 corporal con aparatologia atendio brenda entro 10:00 mega \r\n22/03/13 dep de pierna comp.leta atendio brenda entro 10:00 mega\r\n10/04/13 corporal con aparatologia atendio bety entro 9:55 mega \r\n11/04/13 corporal con aparatologia atendio jhoany entro 10:00 mega \r\n12/04/13 termino corporal con aparatologia atendio jhoany entro 10:05 mega \r\n13/04/13 lim. facial 2x1 atendio brenda entro 6:55 mega \r\n21/06/13 dep,pierna com, dep bikini y amp depifin jhoany\r\n05/10/13 se llevo vc. atache piel grasa a mixta\r\n16/11/13 limp. facial 2x1 jhoany mega 7:15\r\n07/12/13 lim facial atendio mirena mega entro 7:15\r\n11/12/13 dep de piernas completas atendio jhoany mega entro 10:00\r\n04/02/14 dep de piernas completas jhoany mega entro 10:10\r\n15/02/14 promocion mes febrero   anita mega 10:00\r\n04/04/14 promocion mes abril y dep de piernas completas c/amp depifin jhoany mega 4:00\r\n16/05/14 limpieza facial 2 x1 atendfio rosy entro 5.00 mega\r\n20/06/14 lim facial con amp beaute ii carmen mega y dep de piernas completas rosi mega entro 5:10\r\n     piel muy sencible al momento de depilar por la alergia que trae, quedo su piel irritada\r\n22/nov/14 limpieza facial 2x1 con amp. beaute ii candy entro 7:10 (mega)\r\n10/marzo/15 dep. piernas completas rosy entro 10:52 (mega)\r\n22/marzo/15 limpieza facial 2x1 con amp. beaute 2 maribel entro 10:03 (mega)\r\n19/junio/15 limpieza facial 2x1 con amp. acido hialuronico candy entro 5:00 (mega)\r\n25/junio/15 dep. piernas completas rosy entro 11:18 (mega)\r\n11/septiembre/15 dep. piernas completas y axila susy entro 11:05 (mega)\r\n17/octubre/15 limpieza facial 2x1 con amp. acido hialuronico y dep. piernas y axila rosy entro 12:05 (mega)\r\n29/noviembre/15 limpieza facial y lifting rosy entro 9:55 (mega)\r\n10/DICIEMBRE/2015 DEP. PIERNAS COMPLETAS AXILAS ROSY ENTRO 11:00 (MEGA)\r\n01/febrero/16 limpieza facial 2x1 con amp. beaute 2 candy entro 10:00 (mega)\r\n23/febrero/16 dep. piernas completas y axila  con amp. depifin rosy entro 10.55 (mega)\r\n13/marzo/16 limpieza facial 2x1 con amp. beaute II maria entro 5:05 (mega)\r\n15/mayo/16 limpieza facial 2x600 con lifting susy entro 6:15 (mega)\r\n12/junio/16 reflexologia podal charito entro 3:00 (mega)\r\n21/julio/16 dep. piernas completas y axila con amp. depifin lizbeth entro 2:55 (mega)\r\n04/agosto/16 prom. del mes caviar charito entro 10:00 (mega)\r\n28/09/2016 Depilacion AXILA PIERNAS COMPLE. con cera atendio lizbeth 11:00 (Mega)\r\n08/diciembre/16 limpieza facial 2x600 con amp. beaute II y dep. piernas completas susy entro 10:00 (mega)\r\n10/abril/17 limpieza facial 2x600 con amp. acido hialuronico y dep. piernas completas y axila candy entro 5:05 (mega)\r\n28/mayo/17 dep. piernas completas lizbeth entro 10:05 (mega)\r\n22/junio/18 dep. piernas completas y axila candy entro 11:05 (mega)\r\n13/marzo/19 dep. axila y piernas completas susy entro 10.55 (mega)\r\n24/junio/19 limpieza facial 2x600 mony entor 5:00 mega\r\nSE LE APLICO AMPOLLETA  BEAUTE 11\r\n26/agosto/19 dep. de piernas completas rosy entro 11:00 mega\r\n6/nov/19 depilacion de pierna completa susy entro 11:00 mega \r\n11/NOVIEMBRE/19 DRENAJE LINFATICO SUSY ENTRO 11:05 MEGA\r\n19/NOVIEMBRE/19 DRENAJE LINFATICO MONI ENTRO 11:00 MEGA\r\n25/NOVIEMBRE/19 DRENAJE LINFATICO MONI ENTRO 10:50 MEGA\r\n16/DIC/!9 MASAJE SENSORELAX  MONI ENTERO  12:00 MEGA \r\n5/MARZO/2020 DEP. DE PIERNAS COMPLETAS CON CERA SUSI ENTRO 2:00 MEGA\r\n16/12/2020 depilacion con cera de piernas y axila atendio rosi suc mega\r\n22/NOV/2021 DEPILACION CON CERA PIERNAS COMPLETAS ROSI  ENTRO 10:55 MEGA\r\n28/MARZO/2022 DEP. CON CERA DE PIERNAS COMPLETAS ROSI ENTRO 15:51 MEGA\r\n01/ DICIEMBRE/202 DEPILACION CON CERA DE PIERNAS COMPLETAS Y AXILAS SUSY ENTRO 4:00 (MEGA)\r\n30/MARZO/2023 DEPILACION CON CERA DE PIERNAS COMPLETAS MONICA ENTRO 5:00 (MEGA)\r\n24/ABRIL/2023 DEPILACION CON CERA DE AXILAS Y PIERNAS COMPLETAS MONICA ENTRO 10:00 (MEGA)\r\n08/MAYO/2023 DEPILACION CON CERA DE AXILAS Y PIERNAS COMPLETAS ROSY ENTRO 10:00 (MEGA)\r\n19/JUNIO/2023 DEPILACION AXILAS CON CERA Y DEPILACION DE PIERNAS COMPLETAS MONI ENTRO 10:52 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-17 21:23:20', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('1070', 'C-101070', '', 'SOFIA GUZMAN AGUIRRE', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1071', 'C-101071', '', 'VIRIDIANA YURIDIA RIOS HERNANDEZ', '9371050438', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1072', 'C-101072', '', 'GEORGINA FALCON VIDAL', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1073', 'C-101073', '', 'ALMA BERUMEN ALATORRE', '9931779363', '', '28/nov/15 promocion antiedad humectante y nutritivo y lifting candy entro 9:45\r\n28/marzo/16 mdm full relax 2x600 rosy entro 1:10\r\n17/sept/16 promocion de coalgeno y liftin#2 mirena entor 9:10\r\n3/dic/16 promocion trat multivitamínico lifting#2 rosy entro 10:25\r\n27/marzo/17 promocion estimulante de colageno con luz leds, lifting # 2 carmen entro 5:10\r\n29/sept/17 promocion resveratrol, lifting de colageno mariana entro 2:15\r\n18/nov/17 promocion termico humectante, lifting de colageno anita entro 9:00\r\n28/ABRIL/18 PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE, LIFTING DE COLÁGENO AITA ENTRO 1:00\r\n', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1074', 'C-101074', '', 'REBECA HERNANDEZ VAZQUEZ', '9932242881', '', '21/marzo/16 limpieza facial con amp. desincrustante mariana entro 11.25\r\n1/agosto/17 limpieza facial charito entro 10:15\r\n27/AGOSTO/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARY ENTRO 4:10\r\n13/ABRIL/19 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE LUPITA', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1075', 'C-101075', '', 'GLORIA CERVANTES JIMENEZ', '9931281543', 'glori_cervantes@hotmail.com', 'depilacion laser de axila $360.00 c/s\r\n1.-20/mayo/11 axila 30 ms 20 j lucy \r\n2.-22/junio/11 axila 30 ms 20 j rosy\r\n3.-22/julio/11 axila autom. 22 j ofe\r\n4.- 19/agosto/11 axila autom 24 j lucy\r\n5.-23/sep/11 axila aut.25j rosy\r\n6.- 11/nov/11 axila aut25j reyna entro 1:30\r\n7.-24/ene/12 axila 30 ms 18 j rosy\r\n8.-29/feb/12 axila 30 ms 18 j reyna\r\n\r\n\r\n13/oct/11 limp. facial 2x1 rosy entro 1:20 (suc. las flores)\r\n06/dic/2011 prom velo de colageno susy entro 1:15(suc las flores)\r\n29/feb/12 promocion 3 geles reyna entro 10:20\r\n11/agosto/12 promocion hidratante y reafirmante gladys\r\n27/abril/13 promocion de porcelana 100% hydratant graciela entro 4:10 (suc las flores)\r\n8/02/14  promocio atendio mary 5. suc las flores\r\n9/agosto/14 promocion oxigenante atendio ana entro 2:12\r\ndepilacion de piernas completas $1500.00 c/s\r\n13/agosto/14 1ra. piernas completas autom. 10 j reyna\r\n04/feb/15 prom. del mes trat. a base de elastine nelly entro 2:20 (mega)\r\n26/sept/15 prom. del mes rosy entro 4:15 (mega)\r\n10/marzo/16 depilación de piernas completas aut-18j reyna\r\n6/mayo/16 piernas completas aut-20j ofelia\r\n4/junio/16 piernas completas aut-20j lucy\r\n25/junio/16 promoción de elastine mariana entro 2:20\r\n3/sept/16 promoción de colágeno lucy entro 12:15\r\n3/sept/16 dep. piernas completas aut-20j lucy\r\n20/oct/16 8° piernas completas aut-21j , axila 30ms 20j lucy\r\n16/nov/16 piernas completas aut-22j lucy\r\n15/dic/6 promoción trat multivitamínico mirena entro 5:55\r\n06/enero/17 limpieza facial rosy entro 5:50 (mega)\r\n16/feb/17 piernas completas aut-22j, retoque de axila 30ms 20j lucy\r\n10/abril/17 11° piernas completas autom. 23 j lucy\r\n30/mayo/17 promoción anti edad con lifting carmen entro 4:40\r\n18/julio/17 promoción trat relajante e hidratante monica entro 5:00\r\n6/dic/17 promoción trat gold anita entro 4:35\r\n18/ENERO/18 PROM TRATAMIENTO OXIGENANTE C/ULTRASONIDO LUCY ENTRO 5:10\r\n20/JUNIO/18  PROM TRATAMIENTO FACIAL ANTIOXIDANTE OFELIA ENTRO 12:20\r\n23/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE REYNA ENTRO 6:00\r\n9/OCT/18 PROM TRATAMIENTO FACIAL REAFIRMANTE MARY ENTRO 5:25\r\n16/DIC/2020 PROMOCION TRAT PORCELANA ANITA ENTRO 3:15\r\n16/JULIO/2021 PROMOCION TRAT CAVIAR Y ORO MARY LAZARO ENTRO 10:00\r\n3/NOVIEMBRE/2021 FACIAL HYDRACURE LUCY ENTRO 4:55\r\n3/FEBRERO/2022 TRATAMIENTO FACIAL AGE TIMEXPERT RIDES LIFTING DE TIMEXPERT RIDES OFELIA  ENTRO 1:55\r\n5/AGOSTO/2022 TRATAMIENTO FACIAL VITAMINA C RADIANCE MARIANA ENTRO 11:10\r\n5/AGOSTO/2022 RETOQUE LASER DE AXILA  AUTOM. 18 J OFELIA\r\n27/FEBRERO/2023 TRATAMIENTO FACIAL VITAMINA C RADIANCE JHOANY ENTRO 11:00   LLEVO LIMPIADORA FACIAL\r\n21/MARZO/2023 RETOQUE DEPILACION LASER DE AXILAS AUTOM. 18 J, PIERNAS COMPLETAS AUTOM. 16 J OFELIA\r\nINICIA DEPILACION LASER DE BIKINI $550.00 C/S\r\n21/MARZO/2023 1RA. BIKINI AUTOM. 10 J OFELIA ENTRO 1:00\r\n9/MAYO/2023 TRATAMIENTO FACIAL VITAMINA C RADIANCE OFELIA ENTRO 4:00\r\n///////////////LLEVO PRODUCTOS///////////////////////\r\n** PACK EMULSION DE DIA VITAMINA C \r\n** PACK CREMA DE NOCHE VITAMINA C\r\n** FILTRO SOLAR DIAMOND NATURA BISSE\r\n** SPLASH LOCION CITRICA NATURA BISSE\r\n** DESMAQUILLANTE LIMPIADOR MICELLAR\r\n** VITAMINA C SESNSATIONS DECASMARA\r\n/////////////////////////////////////////////////////////////\r\n31/MAYO/2023 PROMO TRATAMIENTO FACIAL MAGIC FACE JHOANY ENTRO 4:05\r\n31/MAYO/2023 2DA  BIKINI TRADICIONAL AUT 10J JHOANY\r\n27/JUNIO/2023 3RA BIKINI 30MS 10J LUCY \r\n3/JULIO/2023 RADIOFRECUENCIA FACIAL SRA BEGO ENTRO 3:05', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-03 18:24:48', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('1076', 'C-101076', '', 'MECERDES JIMENEZ', '9932174698', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1077', 'C-101077', '', 'LAURA LUZ CABRERA HERNANDEZ', '', '', '19/diciembre/16 mdm full relax y limpieza de acne 2x600 maria entro 2:15 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1078', 'C-101078', '', 'ANNEKEN ROMERO PUIG', '', '', '21/agosto/10 depilacion de pantorrilla indira entro 11:20 \r\n2/feb/11 depilacion de piernas completas rosy entro 5:34\r\n1/marzo/11 depilacion de pantorrillas karina entro 5:02 \r\n19/julio/12 limpieza facial, depilacion de linea de abdomen gladys entro 12:20\r\n4/oct/12 limpieza facial karina entro 5:05\r\n29/oct/12 depilacion de muslo, linea de abdomen graciela entro 6:00\r\n19/dic/12 limpieza facial gladys entro 12:30\r\n2/feb/13 limpieza de acne gladys entro 11:00 llevo locion biocontrol, limpiadora facial acida.\r\n9/marzo/13 limpieza de acne gladys entro 11:15 llevo limpiadora facial acida\r\n20/abril/13 limpieza facial gladys entro 11:10\r\n24/junio/13 limpieza facial gladys entro 1:00\r\n22/julio/13 limpieza facial, depilacion de cejas y bigote gladys\r\n7/sept/13 limpieza facial gladys entro 12:05\r\n28/sept/13 limpieza facial gladys entro 12:30\r\n25/oct/13  limpieza facial amp. desincrustante  gladis entro 1:00\r\n7/dic/13 limpieza facial, depilacion de cejas gladys entro 10:00\r\n25/ene/14 limpieza facial rosy entro 1:30\r\n5/abril/14 limpieza facial rosy entro 10:00\r\n17/mayo/14 limpieza facial carmen entro 1:00\r\n25/junio/14 limpieza facial mariana 12:00\r\n11/julio/14 limpieza facial mariana entro 1:00\r\n07/agosto/14 dep cejas y bigote. limpieza de acne y mdm cliente frecuente mariana entro 10:35\r\n15/sept/14 limpieza facial, depilacion de cejas y bigote mariana entro 4:00\r\n8/octubre/14 limpieza facial y dep de cejas atendio mariana entro 4:15\r\n1/nov/14 limpieza facial mariana entro 12:30\r\n9/dic/14 limpieza facial mariana entro 10:25\r\n12/marzo/15 limpieza facial, dep. cejas y bigote mariana entro 6:00\r\n23/mayo/15 limpieza facial mariana entro 11:50\r\n29/junio/15 limpieza facial maribel entro 12:20\r\n6/oct/15 limpieza facial y dep de cejas y bigote mariana entro 12:45\r\n12/dic/15 limpieza facial y dep de bigote mariana entro 10:00\r\n8/abril/16 limpieza facial mariana entro 10:30\r\n8/junio/16 limpieza facial mariana entro 10:00\r\n30/junio/16 limpieza facial mariana entro 4:20\r\n17/sept/16 limpieza facial mariana entro 10:05\r\n8/dic/16 limpieza facial mariana entro 1:00\r\n10/ene/17 limpieza facial con amp. desicnrustante marian entro 11:00\r\n28/abril/17 limpieza facial mariana entro 1:00\r\n13/junio/17 limpieza facial mariana entro 4:10\r\n4/agosto/17 limpieza facial mariana entro 11:50\r\n2/dic/17 limpieza facial, depilacion de cejas y bigote mariana entro 10:00\r\n26/MARZO/18  LIMPIEZA FACIAL MARIANA ENTRO 1:20\r\n20/DIC/18 LIMPIEZA FACIAL OFELIA ENTRO 12:00\r\n28/DIC/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MONICA ENTRO 1:00\r\n17/ENERO/19 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 5:00\r\n23/MARZO/19 LIMPIEZA FACIAL OFELIA ENTRO 12:05', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1079', 'C-101079', '', 'MIRIAM JIMENEZ', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1080', 'C-101080', '', 'MARCIA ISABEL JIMENEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1081', 'C-101081', '', 'ALBA LAURA CASTILLO PEREZ', '9932154460', '', '26/dic/12 promocion de oro graciela entro 9:55\r\n29/ene/13 limpieza de acne mariana entro 11:00\r\n20/04/13 lim. facial con ampo serum equilibrium  atendio bety entro 12:15 mega \r\n27/mayo/13 limpieza de acne reyna entro 10:55\r\n09/julio/2013 limpieza de acne con amp. desincrustante reyna entro 5:20 \r\n17/agosto/13 limpieza de acne ana entro 10:15\r\n5/nov/13 limpieza de acne yusiria entro 11:00 llevo masc. ph5\r\n12/julio/14 promo. trat de colageno  reyna entro 10:55\r\n9/dic/14 limpieza de acne mirena entro 11:50\r\n25/agosto/15 limpieza facial con amp. desincrustante graciela entro 11:50\r\n24/nov/15 limpieza de acne acne con amp. desincrustante maria entro 9:30\r\n10/feb/16 limpieza facial con amp. desincrustante carmen entro 4:00\r\n30/mayo/16 masaje holistico y facial con lifting#2 mariana entro 9:50\r\n8/agosto/16 promoción de caviar carmen entro 5:00\r\n20/sept/16 promoción de colageno mariana entro 11:10\r\n9/nov/16 promocion oxigenante anita entro 11:00\r\n03/enero/17 limpieza de acne 2x600 susy entro 10:05 (mega)\r\n25/feb/17 limpieza de acne con amp. desincrustante susy entro 1:25\r\n10/marzo/17 micro candy entro 12:00 (mega)\r\n22/marzo/17 limpieza de acne con amp. desincrustante charito entro 10:05\r\n18/mayo/17 mdm full relax cliente frecuente, limpieza de acne con amp. desincrustante monica entro 10:00\r\n3/julio/17 limpieza de acne mariana entro 6:10\r\n7/agosto/17 promocion desvanece las lineas del tiempo lizvet entro 5:30\r\n22/sept/17 limpieza de acne con amp. desincrustante lucy entro 12:00\r\n01/noviembre/17 limpieza de acne candy entro 3:00 (mega)\r\n02/FEB/18 LIMPIEZA DE ACNE OFELIA ENTRO 12:00\r\n20/JUNIO/18 PROM TRATAMIENTO FACIAL ANTIOXIDANTE LUCY ENTRO 1:00\r\n30/OCT/18 LIMPIEZA FACIAL Y MDM FULL RELAX 2 X 600 ANITA ENTRO 4:00\r\n20/FEB/19 PROMOCION REAFIRMANTE REYNA ENTRO 9:00\r\n25/JUNIO/19 LIMPIEZA FACIAL MARY ENTRO 5:00\r\n5/JUNIO/2020 LIMPIEZA DE ACNE CON AMP. DESINCRUSTANTE MONICA ENTRO 9:00\r\n5/JUNIO/2020 RIZADO DE PESTAÑAS, PLANCHADO DE CEJAS LUCY ENTRO 10:00\r\n1/OCTUBRE/2021 LIMPIEZA FACIAL MARY LAZARO ENTRO 11:00\r\n16/NOV/2021 INICIA TRATAMIENTO REDUCTIVO (15 SESIONES B.FIN) SE LE ASIGNO DIETA DE LOS 13 DIAS. \r\n\r\nPESO: 78 kg \r\n                                                                         MEDIDAS\r\nABDOMEN: 88         \r\n BUSTO: 101       \r\nCINTURA: 93\r\nCADERA ALTA: 113\r\nCADERA BAJA: 114\r\nBRAZO: 35\r\nMUSLO: 71\r\n1. MASAJE 45 MIN 16/NOV/21 MONICA ENTRO 12:55 MEGA\r\n2. MASAJE 45 MIN 17/NOV/21 MONICA ENTRO 13:00 MEGA\r\n3. MASAJE 45 MIN 18/NOV/21 MONICA ENTRO 10:00 MEGA\r\n4.MASAJE 45 MIN  19/NOV/21 MONICA ENTRO 10:00 MEGA\r\n5.MASAJE 45 MIN  20/NOV/21 MONICA ENTRO 17:00 MEGA\r\n6.MASAJE 45 MIN  22/NOV/21 MONICA ENTRO 10:00 MEGA\r\n7.MASAJE 45 MIN  23/NOV/21 MONICA ENTRO 10:00 MEGA\r\n8.MASAJE 45 MIN  24/NOV/21 MONICA ENTRO 10:00 MEGA\r\n9.MASAJE 45 MIN  25/NOV/21 MONICA ENTRO 10:00 MEGA\r\n10.MASAJE 45 MIN 26/NOV/21 MONICA ENTRO 10:07 MEGA\r\n11.MASAJE 45 MIN 27/NOV/21 MONICA ENTRO 10:05 MEGA\r\n12.MASAJE 45 MIN 29/NOV/21 MONICA ENTRO 10:05 MEGA\r\n13.MASAJE 45 MIN \r\n14.MASAJE 45 MIN\r\n15.MASAJE 45 MIN\r\n07/ MARZO/2023 PROMOCION DEL MES TRATAMIENTO FACIAL MICRODERMA ANTIEDAD MONICA ENTRO 10:00 (MEGA)\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-07 09:47:15', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('1082', 'C-101082', '', 'JOSEFA DE LA CRUZ PEREZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1083', 'C-101083', '', 'ESTELA CORREA DE LA CRUZ', '9171011533', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1084', 'C-101084', '', 'LEIDY ARELY ZAMORA MORILLO', '9933605705', '', '1/AGOSTO/18 LIMPIEZA FACIAL 2 X 600 LUCY ENTRO 5:35', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1085', 'C-101085', '', 'ROCIO ARMIDA OLGUIN', '9931770975', '', '27/agosto/16 promoción de caviar andre entro 11.15', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1086', 'C-101086', '', 'BEATRIZ EDALIA ARIAS BOLON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1087', 'C-101087', '', 'MARINA LACRUZ CIFUENTES', '9932075537', 'lacruz_marina@yahoo.com', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1088', 'C-101088', '', 'FATIMA JESUS CRUZ TAMAYO', '9931169986', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1089', 'C-101089', '', 'JHOANA SANTANDREU RAMIREZ', '9932196530', '', '16/oct/13 mdm drenaje linfatico lucy entro 12:00\r\n30/oct/13 promocion the verde mirena entro 12:25\r\n05/11/13 masaje senso relax jhoany mega 6:00\r\n29/11/13 mdm 2x1 atendio martha mega entro 2.00\r\n13/12/13 mas drenaje linfatico atendio jhoany mega entro 4:40\r\n16/ene/14 mdm full relax mariana entro 10:00\r\n11/02/14 lim.facial 2x1 martha mega 4:15\r\n11/abril/14 mdm drenaje linfatico carmen entro 1:15\r\n18/08/14 mdm full relax candy mega 12.20\r\n11/sept/14 mdm full ralx (cliente frecuente)nely entro 11:40 (mega)\r\n24/09/14 limp facial 2x1 martha 12.10 mega\r\n13/dic/14 mdm full relax ana entro 9:30\r\n16/ene/15 mdm full relax nelly entro 1:00 (mega)\r\n18/ene/15 mdm full relax 2x1 candy entro 12:05 (mega)\r\n22-04-15 se realizo l-f entro 4 nely\r\n303/01/05 promocion relajante e hydratante reyna\r\n10/09/05 limpieza facial consuelo\r\n20/sept/06 limpieza facial mary entro 10:30\r\n02/mayo/07 promocion antiarrugas y reafirmante lucy entro 11:45\r\n07/julio/07 promocion colageno reyna entro 10:05\r\n06/oct/07 exf. cuerpo, masc. mdm geotermal, limpieza facial $1600.00 marcela entro 8:25\r\n5/ene/08 promocion relajante e hidratante mary lazaro entro 8:15\r\n16/feb/08 limpieza facial ofelia entro 10:00 \r\n26/abril/08 limpieza facial odet entro 9:30 \r\n31/ene/09 exfoliacion de cuerpo, promocion jalea real mary entro 8:05 salio 10:15 \r\n27/agosto/09 limpieza facial 2 x 1 ofelia entro 10:05 salio 11:15\r\n14/oct/09 limpieza facial 2x1 sara entro 10:40\r\n30/dic/09 limpieza facial 2x1 mary entro 9:00\r\n29/marzo/10 promocion del mes de cristal sara entro 12.15\r\n19/mayo/10 limpieza facial 2 x 1 indira entro 1:25\r\n21/junio/10 limpieza facial sara entro 1:00\r\n19/ene/11 promocion porcelana sara entro 9:05\r\n2/marzo/11 limpieza facial 2 x 1 lucy entro 12:00\r\n4/feb/12 mdm sensorelax, promocion 3 geles gladys entro 10:00\r\n13/05/12 trat velo de colageno atendio brenda entro 12:50 mega\r\n9/09/12 lim. facial atendio diana entro 10:55 mega\r\n9/09/12 se le aplico ampolleta desincrustante mega\r\n11/11/12 lim. facial y mdm 2x1 atendio jenifer entro 1:00 mega\r\n22/12/12 mdm 2x1 atendio diana entro 4:55 mega\r\n30/06/13 lim. facial jhoany mega 1:00\r\n31/agosto/2013 mdm full relax atendio graciela entro 8:00\r\n31/agosto/2013 promocion oxigenante atendio graciela \r\n29/abril/14 lim facial 2x1 mega atendio rosy entro 6:00\r\n16/ene/15 mdm full relax nelly entro 1:05 (mega)\r\n20/feb/15 limpieza facial nelly entro 1.50 mega\r\n14/01/16 MDM Y LIMP. FACIAL C/DESC. ENTRO 11.25 (CRISTAL)\r\n18/marzo/16 mdm full relax lucy entro 11.30\r\n12/dic/16 limpieza facial 2x500 charito entro 12.10\r\n4/feb/17 masaje full relax lucy entro 2:10\r\n5/SEPT/2020 MASAJE FULL RELAX, LIMPIEZA FACIAL 2 X 600 OFELIA ENTRO 9:15\r\n23/MARZO/2022 PROMOCION SHOCK DE COLAGENO CON AMP. ACIDO HIALURONICO LUCY ENTRO 9:30\r\n15/JUNIO/2022 MASAJE FULL RELAX CRISTINA ENTRO 9:10 ', 'no', 'inactivo', '2021-12-07 00:49:45', '2022-09-08 17:50:47', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('1090', 'C-101090', '', 'JOANA DE WIT QUINTERO', '9931176366', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1091', 'C-101091', '', 'MARIA TERESA GARCIA CRUZ', '9931360958', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1092', 'C-101092', '', 'IVON GABRIEL PAZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1093', 'C-101093', '', 'LOENA DE LA CRUZ LUNA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1094', 'C-101094', '', 'GUILLERMO TORRES LOPEZ', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1095', 'C-101095', '', 'GUILLERMO TORRES TEJEDA', '9932005080', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1096', 'C-101096', '', 'REBECA MARTINEZ OST', '9933477947', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1097', 'C-101097', '', 'JOVANI GUZMAN CORDOVA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1098', 'C-101098', '', 'SHEILA ROMERO CORNELIO', '9931609963', '', '20/diciembre/17 mdm full relax 2x600 candy entro 2:55 (mega)\r\n25/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD LUPITA ENTRO 11:25\r\n21/FEB/2022 MASAJE FULL RELAX MONICA ENTRO 12:50 MEGA\r\n08/OCTUBRE/2022 MASAJE DESCONTRACTURANTE SUSY ENTRO 10:00 (MEGA)', 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1099', 'C-101099', '', 'FABIOLA HERNANDEZ CANCINO', '9931082088', '', '18/abril/11 limpieza facial 2 x 1 sara entro 3:02\r\n28/julio/11 limpieza facial con amp. desincrustante rosy entro 12:00\r\n10/agosto/11 limpieza facial 2x1 aracely entro 2:00\r\n10/agosto/11 rizado de pestañas rosy entro 2:00\r\n31/oct/11 rizado y promocion mariana entro 11:20\r\n11/01/12 limp facial 2x1 atendio brenda (mega)\r\n12/ene/12 rizado de pestañas de regalo el tinte reyna entro 11:20\r\n3/agosto/12 limpieza facial 2 x 1 graciela\r\n3/agosto/12 rizado de pestañas sara entro 3:30\r\n19/06/13 lim facial atendio marta entro 6:00 mega\r\n7/enero/15 limpieza facial 2x1 mirena entro 5:00\r\n15/SEPTIEMBRE/15 LIMPIEZA FACIAL 2X1 MARIBEL ENTRO 2:00 (MEGA)\r\n05/noviembre/15 limpieza facial 2x1 rosy entro 6:50 (mega)\r\n17-11-15 se realizo masaje de cliente frecuente cristal martha 6pm\r\n14/diciembre/2015 limpieza facial charito 5:50 (mega)\r\n22/abril/19 mdm full relax y limpieza facial 2x600 csrmen entro 1:50 mega', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1100', 'C-101100', '', 'GUADALUPE CUSTODIO JIMENEZ', '', '', null, 'no', 'inactivo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1101', 'C-101101', '', 'GERARDO MONDRAGON PORRAS', '9933037078', '', '7/ABRIL/2021 LIMPIEZA FACIAL 2X600 JHOANY ENTRO 5:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1102', 'C-101102', '', 'SHIRLEY ANDRADE ZURITA', '9931993538', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1103', 'C-101103', '', 'HUGO HARDY ALVAREZ', '9931602297', '', '16/nov/15 limpieza facial mariana entor 2:20\r\n22/ene/16 limpieza facial con amp. desincrustante mariana entro 4:20\r\n2/abril/16 limpieza facial con amp. desincrustante mariana entro 9:15\r\n21/julio/16 limpieza facial con amp. desincrustante lucy entro 12:55\r\n7/nov/16 limpieza facial con amp. desicnrustante andrea entro 9:30\r\n26/ene/17 limpieza facial con amp. desincrustante mariana entro 1:40\r\n2/feb/17 masaje full relax (cleinte frecuente) andrea entro 4:00\r\n01/mayo/17 prom. del mes trat. atiedad rosy entro 1:50 (mega)\r\n19/junio/17 limpieza facial con amp. desincrustante andrea entro 2:00\r\n03/octubre/17 limpieza facial profunda andrea entro 04:00 (mega)\r\n19/FEB/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARIANA ENTRÓ 2:05\r\n27/JUNIO/18 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE  LUPITA ENTRO 12:30\r\n4/SEPT/18 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE LINDA ENTRO 4:40\r\n12/ABRIL/19 LIMPIEZA FACIAL DE ACNE  SUSY ENTRO 3:00 MEGA\r\n27/JULIO/19 LIMPIEZA FACIAL CN AMP DESINCRUSTANTE MARY ENTRO 9:15\r\n19/SEP/19 TRATAMIENTO FACIAL OXIGENANTE ALEGRIA  ENTRO 9:55\r\n26/OCT/19 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 1:20\r\n20/ENERO/20 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MARY LAZARO ENTRO 2:00\r\n01/MAYO/2021LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ALERT ENTRO 1:00\r\n13/JULIO/2021 LIMPIEZA FACIAL ARLETH Y MASAJE FULL RELAX MONICA ENTRO 15:02 MEGA.\r\n02/NOV/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ROSI ENTRO 11:00 MEGA\r\n9/SEPT/2022 LIMPIEZA FACIAL CONAMP. DESINCRUSTANTE OFELIA ENTRO 4:00\r\n4/NOVIEMBRE/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE OFELIA ENTRO 2:00\r\n16/FEBRERO/2023 PROMO TRATAMIENTO FACIAL ELIXIR DW JUVENTUD ARIANA ENTRO 2:50   VALE DE  REGALO\r\n15/JUNIO/2023 PROMOCION TRAT. FACIAL ULTRASOUND JHOANY ENTRO 3:30', 'no', 'activo', '2021-12-07 00:49:45', '2023-06-15 17:25:32', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('1104', 'C-101104', '', 'ESTHER MILING ANG VAZQUEZ', '9381091058', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1105', 'C-101105', '', 'HUMBERTO JIMENEZ AGUEDA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1106', 'C-101106', '', 'ADELINA HERRERA COBA', '9933591400', '', '6-09-15 SE REALIZO L-F 2X1 CRISTAL CANDY  5\r\n27/diciembre/15 limpieza facial 2x1 con amp. desincrustante charito entro 12:00 (mega)\r\n20/mayo/16 mdm holistico y facial con lifting#2 mariana entro 10.40\r\n26/ene/17 limpieza facial 2x600 susy entro 11.05\r\n29/junio/17 limpieza facial 2x600 rosy entro 6:00 (mega)', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1107', 'C-101107', '', 'NAYELI GONZALEZ DUE', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1108', 'C-101108', '', 'ROCIO DE LA FUENTE OTERO', '9931386533', '', '13/agosto/17 promocion del mes desvanece las lineas del tiempo charito entro 3:55 (mega)\r\n17/enero/18 limpieza facial 2x600 candy lifting (cortesía) candy entro 7:10 (mega)\r\n23/noviembre/18 prom. del mes trat. contra la polución de la luz azul rosy entro 1:00 (mega)\r\n21/DIC/18 PROM TRATAMIENTO FACIAL DIAMANTE KARLA ENTRO 9:00\r\n13/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE ANITA ENTRO 9:40\r\n2/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD MARY LAZARO ENTRO 4:10\r\n', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1109', 'C-101109', '', 'NINFA FALCON BAYONA', '9933112140', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1110', 'C-101110', '', 'SERGIO ZILLI FALCON', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1111', 'C-101111', '', 'MARIA VANESSA MORALES COBOS', '', '', '6/julio/16 limpieza facial 2z600 lizvet entor 1:20', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1112', 'C-101112', '', 'MARIA DE LA PAZ COBOS ROJAS', '9931562319', '', '6/julio/16 limpieza facial 2x600 anita entro 1:20\r\n29/nov/17 limpieza facial 2x600 anita entro 9:55\r\n17/FEB/18 TRATAMIENTO DE MICRO MARIANA ENTRO 12:00\r\n20/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL LUPITA\r\n19/FEB/19 PROMOCION REAFIRMANTE MARY LAZARO ENTRO 11:25\r\n19/JULIO/19 LIMPIEZA FACIAL ANITA ENTRO 12:00\r\n9/MARZO/2020 LIMPIEZA FACIAL 2 X 600 LUPITA ENTRO 12:05\r\n16/DICEMBRE/2021 LIMPIEZA FACIAL 2X600 MIRENA\r\n30/MARZO/2022 MICRO JHOANY ENTRO 10:00\r\n13/MARZO/2023 PROMOCION TRAT. FACIAL MICRODERMA ANTIEDAD OFELIA ENTRO 12:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-03-11 15:53:25', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('1113', 'C-101113', '', 'LILIANA ALVARADO AVENDA', '9931699948', '', '4/abril/16 mdm holistico 2x600 lizvet entro 6.00\r\n06/01/18 MDM LINFATICO Y PROM  TRAT OXIGENANTE CON ULTRASONIDO ANITA ENTRO 11:00\r\n7/JUNIO/2021 MASAJE FULL RELAX 2X600 MONICA ENTRO 4:55', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1114', 'C-101114', '', 'PATRICIA ROMERO DE LOS SANTOS', '9333272385/9333341746', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1115', 'C-101115', '', 'DEYANIRA OROPEZA OCA', '9931356505', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1116', 'C-101116', '', 'MAGALI MORENO CORTEZ', '9931356505', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1117', 'C-101117', '', 'MA. DE LOS ANGELES ARGUELLO CONDE', '9931294285', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1118', 'C-101118', '', 'MARCO ANTONIO LEYVA LEYVA', '9931558586', '', '03/02/04 limpieza facial alba\r\n06/04/04 limpieza facial lupita\r\n23/04/04 promocion botanico 4 f alba\r\n25/05/04 limpieza facial yesy\r\n19/07/04 promocion termico yesy\r\n13/04/05 promocion botanico rosy\r\n08/06/05 promocion catiodermia yesy\r\n29/06/05 limpieza facial mary\r\n02/08/05 limpieza facial gladys\r\n19/08/05 limpieza facial marcela\r\n12/oct/05 limpieza facial mary\r\n23/nov/05 limpieza facial yesy\r\n27/feb/06 limpieza facial mary\r\n05/abril/06 promocion coco y mango mary lazaro\r\n27/abril/06 limpieza facial yesy\r\n03/junio/06 limpieza facial yesy\r\n03/julio/06 limpieza facial yesy\r\n07/agosto/06 limpieza facial carmen\r\n12/sept/06 limpieza facial reyna entro 1:35 salio 2:50\r\n11/oct/06 limpieza facial rosy entro 5:05\r\n08/nov/06 limpieza facial carmen entro 1:40 salio 2:50\r\n6/dic/06 limpieza facial con ampolleta bety entro 10:20\r\n12/ene/07 limpieza facial con amp. hydratante lupita c entro 4:00\r\n08/oct/07 limpieza facial ligia entro 10:45\r\n10/dic/08 promocion vitamina c reyna entro 10:35 salio 11:50 \r\n18/junio/09 promocion white line araceli entro 10:40 \r\n31/marzo/10 promocion de cristal mariana entro 5:25 \r\n4/junio/10 promocion botanica mariana\r\n11/agosto/10 promocion antiarrugas ofe entro 12:00\r\n4/nov/10 promocion modeladora con amp. hidratante mariana\r\n23/nov/10 promocion modeladora mary lazaro entro 2:25 \r\n3/ene/11 promocion porcelana sara entro 2:00 \r\n2/marzo/11 limpieza facial mary lazaro entro 1:52\r\n31/marzo/11 promocion elastine con amp. desincrustante reyna entro 4:03 \r\n18/abril/11 limpieza facial mariana entro 2:10 salio 2:49 tenia prisa se le hizo en 35 minutos\r\n24/mayo/11 limpieza facial con amp. desincrustante y amp. beaute ii deyanira entro 1:05\r\n28/junio/11 limpieza facial con amp. desincrustante y amp. hidratante araceli entro 1:00\r\n21/oct/11 limpieza facial chely entro 3:05\r\n3/ene/12 limpieza facial con amp. desincrustnate y amp. acido hialuronico rosy entro 5:10\r\n25/ene/12 limpieza facial con amp. acido hialuronico karina entro 1:55\r\n22/feb/12 promocion 3 geles reyna entro 1:45\r\n17/abril/12 promocion revitalizante gladys entro 1:55\r\n15/mayo/12 promocion velo de colageno reyna entro 5:00\r\n11/junio/12 limpieza facial con amp. hydracure sara entro 1:05\r\n9/julio/12 limpieza facial con amp. de acido hialuronico karina entro 10:55\r\n6/sept/12 promocion de agave araceli entro 4:45\r\n3/oct/12 promocion de cuello sara entro 1:40\r\n16/nov/12 promocion de colageno sara entro 1:15\r\n13/dic/12 limpieza facial gladys entro 2:40\r\n7/ene/13 limpieza facial reyna entro 5:30\r\n19/feb/13 limpieza facial yusiria entro 1:40\r\n21/marzo/13 limpieza facial nelli entro 1:25\r\n20/mayo/13 limpieza facial reyna entro 9:55\r\n14/agosto/13 limpieza facial ana entro 3:15\r\n5/septiembre/13 limpieza facial ana entro 1:30\r\n17/oct/13 limpieza facial ana entro 5:15\r\n27/dic/13 limpieza facial susy entro 5:20\r\n12/feb/14 limpieza facial reyna entro 4:40\r\n15/feb/14 cavitacion en abdomen rosy entro 11:45\r\n28/marzo/14 limpieza facial yusiria entro 10:15\r\n01/julio/14 limpieza facial nelli entro 12:05\r\n29/junio/15 trat manchas lucy entro 3:15\r\n7/oct/15 limpieza facial lucy entro 11:35\r\n14/nov/15 limpieza facial charito entro 12.45\r\n26/dic/15 limpieza facial con amp. hidratante mary lazaro entro 9:10', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1119', 'C-101119', '', 'MONSERRAT HERNANDEZ ORTEGA', '9931524242', '', '27/feb/16 masaje combo (vale regalo) reyna entro 12.45\r\n22/JUNIO/20 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE Y MICRO PUNTA MARY LAZARO ENTRO 2:20', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1120', 'C-101120', '', 'CORA ROMERO ', '9933607180', 'albertopereyra86@gmail.com', '07/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO LUCY ENTRO 4:00 ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1121', 'C-101121', '', 'CRISTINA MEZA TATIS', '9931173286', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1122', 'C-101122', '', 'MIRIAM BAUTISTA MARTINEZ', '9331270030', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1123', 'C-101123', '', 'PAOLA ALEJANDRA CRUZ ARGUELLO', '9931294285', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1124', 'C-101124', '', 'SABRINA MENDEZ IRINEO', '9932598395', '', '19/MARZO/18 AXILA, BIGOTE 30MS, 10J REYNA ENTRO 5:15\r\n19/ABRIL/18  AXILA 30 MS 11J BIGOTE 30 MS 11 J REYNA\r\n18/MAYO/18 AXILA 30 MS 12 J, BIGOTE 30 MS 12 J MARY\r\n21/JUNIO/18 AXILA  Y BIGOTE 30 MS 13J MARY\r\nDEPILACION LASER DE AXILA $500.00 BIGOTE $250.00 PIERNAS COMPLETAS $1500.00 BIKINI $550.00\r\n22/DIC/2020 1RA. BIKINI, AXILA, PIERNAS COMPLETAS, BIKINI LUCY ', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1125', 'C-101125', '', 'EDUARDO BARREDO ALAMILLA', '9143361640', '', '', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1126', 'C-101126', '', 'PATRICIA ALAMILLA ', '9931255431', '', '14/AGOSTO/18 LIMPIEZA FACIAL 2 X 600 LUPITA ENTRO 5:00', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1127', 'C-101127', '', 'WALTER VENTURA LEYVA', '9931545371', '', '28/agosto/ promocion chocoterapia reyna entro 4:35\r\nllevo gel-crema hidro matificante , espuma purificante  de purexpert y 2 esponjas\r\n8/oct/15 promocion reafirmante reyna entro 4:18\r\n19/nov/15 promocion antiedad humectante y nutritivo reyna entro 4:30\r\n19/nov/15 llevo espuma purificante de purexpert\r\n17/dic/15 promocion reafirmante modeladora reyna entro 4:50\r\n13/feb/16 promocion roll & lift reyna entro 1:35\r\n21/abril/16 promocion trat luxury reyna entro 4:25\r\n21/abril/16 llevo crema hidratante no estrés de purexpert, contorno de ojos de excel therapy 02 y esponja\r\n9/junio/16 promocion de elastine reyna entro 4:50\r\n4/agosto/16 promocion de caviar reyna entro 4:15\r\n7/oct/16 promocion colageno reyna entro 4:15\r\n24/nov/16 promocion oxigenante reyna entro 4:25\r\n22/dic/16 promocion trat multivitaminico reyna entro 4:30\r\n6/abril/17 promocion termico anita entro 4:30\r\n15/junio/17 promocion antioxidante anita entro 4:30\r\n28/julio/17 promocion trat relajante e hidratante anita entor 4:30\r\n19/oct/17 promocion reafirmante anita entro 5:55\r\n24/nov/17 promocion termico humectante anita entro 4:30\r\n16/FEB/18 PROM TRATAMIENTO MULTIVITAMINICO REYNA ENTRO 4:25\r\n4/MAYO/18 PROM TRATAMIENTO ANTIEDAD REYNA ENTRO 10:50\r\n4/MAYO/18 LLEVO PRODUCTO JABON ACNIPOP, TIMEXPERT LIFT (IN). Y PUREXPERT CREMA HIDRATANTE\r\n13/JULIO/18 PROM TRATAMIENTO FACIAL DE RETINOL  REYNA ENTRO 5:00\r\n10/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE REYNA\r\n13/SEP/18 PROM TRATAMIENTO FACIAL REGENERANTE ANITA ENTRO 5:00\r\n5/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN REYNA ENTRO 4:40\r\n15/ENERO/19 PROMOCION REVITALIZANTE REYNA ENTRO 4:40\r\n27/FEB/19 PROM TRATAMIENTO FACIAL REAFIRMANTE REYNA ENTRO 4:45\r\n17/ABRIL/19 PROM TRATAMIENTO FACIAL HUMECTANTE REYNA ENTRO 4:20\r\n4/JULIO/19 ROM TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO ANITA ENTRO 5:00\r\n29/AGOSTO/19 TRATAMIENTO FACIAL HUMECTANTE REYNA ENTRO 4:20\r\n15/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION REYNA ENTRO 5:10\r\n22/NOVIEMBRE/19 TRATAMIENTO FACIAL DE PERLAS REYNA ENTRO 4:55\r\n20/DICIEMBRE/19 TRATAMIENTO FACIAL  24 K REYNA ENTRO 5:00\r\n13/MARZO/20 TRATAMIENTO FACIAL RECUPERADOR ANITA ENTRO 4:45\r\n19/JUNIO/2020 PROMOCION TRAT REPARADOR ANTIEDAD ANITA ENTRO 9:25\r\n24/AGOSTO/2020 PROMOCION TRAT OXIGENANTE ANITA ENTRO 9:00\r\n12/NOV/2020 PROMOCION TRAT. BOTANICO ANITA ENTRO 4:30\r\n29/ENERO/2021 PROMOCION TRAT ANTIPOLUCION ANITA ENTRO 3:15\r\n31/MARZO/2021 PROMOCION DE ACIDO HIALURONICO ANITA ENTRO 4:20 \r\n9/JUNIO/2021 PROM. TRATAMIENTO FACIAL CAVIAR Y ORO ANITA ENTRO 5:05\r\n20/AGOSTO/2021 PROMOCION TRATAMIENTO ORGNICO REVITALIZANTE MARIANA ENTRO 4:30 \r\n14/OCTUBRE/2021 PROM. TRATAMIENTO FACIAL ORGANICO CBD MARY LAZARO ENTRO 4:30\r\n29/OCTUBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ARLETH ENTRO 4:50\r\n26/ENERO/2022 PROM. TRATAMIENTO FACIAL DETOX MARY LAZARO ENTRO 4:40\r\n6/ABRIL/2022 PROM. TRATAMIENTO FACIAL CINETICO MARY LAZARO ENTRO 4:50\r\n10/JUNIO/2022 PROM. TRATAMIENTO YOGA FACIAL MARY LAZARO ENTRO 4:50\r\n1/SEPTIEMBRE/2022 PROM. TRATAMIENTO PREVENTIVO DE MANCHAS MARY LAZARO ENTRO 5:05\r\n7/OCTUBRE/2022 PROM. TRATAMIENTO FACIAL DE OBSIDIANA MARY LAZARO ENTRO ENTRO 4:00 \r\n24/NOVIEMBRE/2022 PROMOCION TRAT.  FACIAL REPARADOR CELULAR MARY LAZARO ENTRO 4:30\r\n21/DICIEMBRE/2022 PROMO TRATAMIENTO FACIAL GOLDEN MARY LAZARO ENTRO 4:45\r\n10/FEBRERO/2023 PROMO TRATAMIENTO FACIAL ELIXIR JUVENTUD LUCY ENTRO 4:40\r\n12/MAYO/2023 PROMOCION TRATAMIENTO FACIAL MAGIC FACE LUCY ENTRO 4:50', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-11 16:39:31', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('1128', 'C-101128', '', 'NINIVE DURAN CABRERA', '7471445816', '', '14/julio/16 delineado de cejas ofelia, s ele dio $100.00 a ofelia', 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1129', 'C-101129', '', 'MARIA ELENA ALVAREZ OCHOA', '9933997871', '', '6/ene/16 promocion desintoxicante reyna entro 12:45\r\n16/MAYO/2023 PROMOCION TRAT. FACIAL MAGIC FACE ALONDRA ENTRO 8:50 VALE DE REGALO', 'no', 'activo', '2021-12-07 00:49:45', '2023-05-15 19:08:23', '1', '37', null, null);
INSERT INTO `clientes` VALUES ('1130', 'C-101130', '', 'GABRIELA SALAZAR ALVAREZ', '9932091011', '', '11/nov/15 promocion antiedad humectante y nutritivo reyna entro 5:00\r\n30/ene/16 promoción desintoxicante charito entro 11.45\r\n13/dic/17 promocion trat gold mary lazaro entro 4:45\r\n27/enero/17 prom. del mes trat. oxigenante con amp. desincrustante entro 6:00 (mega)\r\n10/MAYO/18 PROM TRATAMIENTO FACIAL ANTIEDAD ANITA ENTRO 4:55\r\n9/FEB/19 PROMOCION REAFIRMANTE CON AMP. DESINCRUSTANTE LUPITA ENTRO 11:00\r\n27/JULIO/19 TRATAMIENTO FACIAL DE COLAGENO HIDROLIZADO ANITA ENTRO 1:45\r\n1/OCT/2021 PROMOCION LIMPIEZA FACIAL Y MASAJE FULL RELAX 2X600 ARLETH ENTRO 11:50\r\n29/NOVIEMBRE/2022 PROMO TRATAMIENTO FACIAL REPARACION CELULAR CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 5:00\r\nLLEVO SERUM HYDRACURE, GEL CREMA HIDRO-MATIFICANTE OIL FREE Y CONTORNO DE OJOS EXCEL THERAPY\r\n22/ABRIL/2023 PROMOCION TRAT. FACIAL PLASMA MARINO CON AMP. DESINCRUSTANTE KARLA ENTRO 2:00\r\nLLEVO MASCARILLA DE RETINOL Y MASCARA DE NOCHE RENOVADORA\r\n17/MAYO/2023 PROMO TRATAMIENTO FACIAL MAGIC FACE CON AMP. DESINCRUSTANTE ALONDRA ENTRO 5:00\r\nLLEVO TRATAMIENTO DE OJOS DIA Y NOCHE TIMEXPERT RIDES EYES', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-06 16:40:34', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('1131', 'C-101131', '', 'DORA ESTELA RAVERS DE GARZA', '', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1132', 'C-101132', '', 'YARA EVA SALGADO EVIA', '9373735332 9371256159', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1133', 'C-101133', '', 'OSVALDO DOMINGUEZ BAEZA', '9932106522', '', '1/DICIEMBRE/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE Y AMPOLLETA DE OXIGENO DE NATURA BISSE MARY LAZARO ENTRO 5:15\r\n12/DICIEMBRE/2020 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE MIRENA ENTRO 8:15\r\n5/ENERO/2021 MICRO CRISTALES MIRENA ENTRO 4:00 LLEVO GLYCOCELL\r\n14/ENERO/2021 MICRO CRISTALES MIRENA ENTRO 3:55\r\n4/FEB/2021 MICRO CRISTALES MARY LAZATO ENTRO 11:55\r\n8/MAYO/2021 LIMPIEZA FACIAL PROFUNDA CON AMPOLLETA DESINCRUSTANTE MARY LAZARO ENTRO 2:05 \r\n8/JUNIO/2021 LIMPIEZA FACIOAL CON AMP DESINCRUSTANTE MARY LAZARO ENTRO 5:45\r\n15/JULIO/2021 LIMPIEZA FACIAL CON AMP DESINCRUSTANTE ARLETH \r\n5/AGOSTO/2021 HYDRAFACIAL, LIMPIEZA DE ESPALDA MARY LAZARO ENTRO 3:50 LLEVO LOCION BIOCONTROL, 2 JABON ACNIPOP\r\n12/AGOSTO/2021 LIMPIEZA FACIAL Y LIMPIEZA DE ESPALDA JOHANY ENTRO 4:10\r\n4/SEPT/2021 LIMPIEZA FACIAL PROFUNDA CON AMPOLLETA OXIGENANTE DE NATURA BISSE  Y MICRODERMABRASION DE PUNTA OFELIA ENTRO 11:50 \r\n24/SEPT/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE  MARIANA \r\nLLEVO BOLSAS OJERAS FORMULA DETOX\r\n13/NOV/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE  JOANA ENTRO 2:10\r\n30/NOVIEMBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ARLETH ENTRO 1:20\r\nLLEVO LIMPIADORA FACIAL ACIDA Y JABON ACNIPOP\r\n7/DIC/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY ENTRO 12:05\r\n21/DICIEMBRE/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARY LAZARO ENTRO 1:50\r\n28/DIC/2021 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MIRENA ENTRO 11:05\r\n12/FEBRERO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA \r\n22/FEBRERO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MIRENA ENTRO 11:00\r\nLLEVO JABON ACNIPOP\r\n30/MARZO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 12:00\r\n16/JUNIO/2022 LIMPIEZA FACIAL PROFUNDA CON AMPOLLETA STABILIZING LUCY ENTRO 11:50 , LLEVO JABON ACNIPOP\r\n28/JUNIO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE JHOANY ENTRO 1:00\r\n28/JUNIO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE JOHANY\r\n5/JULIO/2022 LIMPIEZA FACIAL PROFUNDA LUCY ENTRO 5:00 \r\n13/JULIO/2022 MASAJE COMBO ARIANA ENTRO 1:00\r\n2/AGOSTO/2022 LIMPIEZA AFCIAL CON AMP. DESINCRUSTANTE ARIANA ENTRO 2:55\r\n25/AGOSTO/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE CRISTINA ENTRO 4:00\r\n5/SEPT/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 6:00\r\n13/SEPTIEMBRE/2022 LIMPIEZA FACIAL CON AMP.DESINCRUSTANTE ARIANA ENTRO 3:15\r\n23/SEPT/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE MARIANA ENTRO 4:05\r\n28/SEPT/2022 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE ARIANA ENTRO 6:00\r\n10/OCTUBRE/2022 MICRODERMABRASION MARIANA ENTRO 6:00 LLEVO JABON ACNIPOP, GLYCOCELL\r\n17/OCTUBRE/2022 MICRO MARCAS JHOANY ENTRO 5:55\r\n26/OCTUBRE/2022 MICRO MARY LAZARO ENTRO 5:50\r\n18/NOVIEMBRE/2022 MICRO MARY LAZARO ENTRO 5:00 LLEVO JABON ACNIPOP\r\n25/NOVIEMBRE/2022 MICRODERMOABRASION FACIAL MARIANA ENTRO 5:50 \r\n12/DICIEMBRE/2022 MICRODERMOABRASION FACIAL MARY LAZARO ENTRO 5:45 \r\n11/ENERO/2023 MICRODERMABRASION LUCY ENTRO 3:05\r\nLLEVO JABON ACNIPOP Y SERUM FACIAL  PEELING FACIAL CASMARA\r\n26/ENERO/2023 MICRODERMABRASION MARIANA ENTRO 3:00\r\n2/FEBRERO/2023 MICRODERMOABRASION ARIANA ENTRO 2:05\r\n17/MARZO/2023 LIMPIEZA FACIAL CON AMPOLLETA DESINCRUSTANTE SUSY ENTRO 6:00 \r\nLLEVO JABON ACNIPOP Y SERUM OJOS ROLL-ON FORMEN\r\n12/ABRIL/2023 LASER DE CARBONO OFELIA ENTRO 4:55\r\n26/ABRIL/2023 LIMPIEZA FACIAL KARLA ENTRO 6:00 LLEVO JABON ACNIPOP\r\n4/MAYO/2023 LIMPIEZA FACIAL CON AMP. DESINCRUSTANTE Y AMP DE CASMARA ANTIMANCHAS OFELIA ENTRO 3:05\r\n8/JUNIO/2023 LIMPIEZA FACIAL KARLA ENTRO 6:00\r\n20/JUNIO/2023 LIMPIEZA FACIAL CON AMP. PIEL SENSIBLE DE CASMARA ALONDRA ENTRO 6:00', 'no', 'activo', '2021-12-07 00:49:45', '2023-07-08 16:25:47', '1', '24', null, null);
INSERT INTO `clientes` VALUES ('1134', 'C-101134', '', 'ALEJANDRO DOMINGUEZ BAEZA', '9931043646', '', null, 'no', 'activo', '2021-12-07 00:49:45', '2021-12-07 01:01:43', '1', '1', null, null);
INSERT INTO `clientes` VALUES ('1135', 'C-101135', '', 'ALMA HERNANDEZ GUERRA', '9932123286', '', '26/marzo/10 desintoxicacion de pies con iones reyna entro 9:10\r\n26/marzo/10 promocion de cristal con amp. beaute ii karina \r\n29/abril/10 promocion 3 geles mary lazaro entro 6:20 \r\n1/junio/10 promocion botanico 4 f, desintoxicacion de pies con iones mary lazaro entro 2:45 \r\n1/julio/10 promocion relajante e hidratante, desintoxicacion de pies araceli entro 5:40 \r\n6/agosto/10 promocion antiarrugas karina entro 5:20\r\n11/sept/10 promocion termico ofe \r\n18/ene/11 promocion porcelana mary lazaro entro 5:20\r\n3/marzo/11 promocion elastine araceli entro 3:45 \r\n24/mayo/11 promocion botanico sara entro 5:45\r\n27/julio/11 mdm drenaje karina entro 1:30\r\n28/julio/11 promocion de amaranto reyna entro 4:15\r\n08/10/11 tatamiento relajante nutritivo atendio graciela entro 3.00 salio 4.00 (mega)\r\n1/dic/11 promocion velo de colageno, mdm rocio entro 2:30\r\n29/dic/11 promocion de colageno gladys\r\n15/02/12 trat de 3 geles atendio brenda entro 4.10\r\n01/04/12 trat revitalizante y regenerante atendio brenda entro2:00 (mega)\r\n10/abril/12 promocion revitalizante lucy entro 5:20\r\n18mayo12 promocion mes velo colageno(mega)brenda entro 615 salio 720\r\n07/07/2012 prom. del mes atendio yenifer (mega) entro 6:05\r\n23/julio/12 promocion hidratante de arroz gladys entro 11:30\r\n10/agosto/12 promocion del mes atendio diana entro 5:45 mega\r\n29/09/12 promocion del mes de agave atendio deya entro 7;10 mega\r\n28/dic/12 promocion de oro mariana entro 2:25\r\n28/dic/12 rizado de pestañas mariana\r\n27/marzo/13 promocion royal jelly, rizado de pestañas mariana entro 1:55\r\n1/abril/13 ya se le hizo el rizado de pestañas que estaba pendiente atendio mariana entro 2:05\r\n1/abril/13 planchado de cejas mariana \r\n17/junio/13 promocion coco y mango yusiria entro 2:00\r\n22/junio/13 rizado de pestañas y planchado de cejas rosy entro 1:10\r\n15/julio/13 promocion de colageno y elastine reyna entro 1:55 \r\n3/feb/14 promocion eternamente joven lucy entro 11:20\r\n8/feb/14 planchado de cejas, rizado de pestañas reyna entro 2:00\r\n29/marzo/14 promocion humectante nelli entro 2:45\r\n25/abril/14 promocion de porcelana yusi entro 3.00\r\n01/06/14 lim facial rosy mega 12:40 ojo: paciente llego sin cita y se le realizo limpieza sencilla y\r\n  rapida de 30 min, por misma peticion de ella, estando conciente del tiempo ella lo autorizo......\r\n05/07/14 promocion mes trat de colageno rosi mega 4:15\r\n10/agosto/14 promocion trat oxigenante graciela entro 12:10 (cristal)\r\n06/09/14 promocion del mes y planchado de ceja chela cristal entro 4.25\r\n23/oct/14 promocion trat smoothie mirena entro 3:00\r\n22/nov/14 promocion trat antiedad humectante y nutritivo yusira entro 2:00\r\n28/dic/14 limpieza facial nelly entro 12:42 (mega)\r\n9/ene/15 promocion desintoxicante y oxigenante, rizado de pestañas, planchado de cejas brenda \r\n20/junio/15 prom. del mes trat. antioxidante martha entro 4:55 (mega)\r\n27/sep/15 limpieza facial atendio eva entro 5:10 suc cristal\r\n28/noviembre/15 prom. del mes trat. antiedad rosy entro 3:25 (mega)\r\n30/diciembre/15 limpieza facial (la señora llego a las 4:20 y autorizo que se le hiciera el facial fue consciente) rosy entro 4:25 (mega)\r\n23-01-16 SE REALIZO PROMO DEL MES CRISTAL MARTHA 6PM\r\n07-05-16 se realizo promo del mes cristal candy 6-30\r\n30/julio/16 promocidon de colageno  mary lazaro entro 2:10\r\n27/agosto/16 promocion de caviar y planchado de cejas  reyna entro 3:30\r\n15/septiembre/16 prom. de mes charito entro 6:15 (mega)\r\n02/noviembre/16 prom. del mes oxigenante rosy entro 1:05 (mega)\r\n6/feb/17 promocion trat de elastine susy entro 2:15\r\n18/marzo/17 promocion estimulante de colageno con leeds rosy entro 1:20\r\n27/mayo/17 prom. del mes trat. antiedad candy entro 6:05 (mega)\r\n19/julio/17 limpieza facial 2x600 anita entor 4.55\r\n3/OCTUBRE/19 TRATAMIENTO FACIAL DOBLE ACCION ALEGRIA ENTRO 3:30\r\n18/OCTUBRE/2022 PROMOCION DEL MES TRATAMIENTO DE OBSIDIANA SUSY  ENTRO 1:55 (MEGA)', 'no', 'activo', '2021-12-07 00:49:45', '2022-10-18 13:24:22', '1', '23', null, null);
INSERT INTO `clientes` VALUES ('1136', 'C-101136', '', 'XOCHITL BOHORQUEZ JUAREZ', '9373226835 9371280713', '', '16/agosto/12 promocion hidratante y reafirmante reyna entro 4:10\r\n27/dic/12 promocion de oro gladys entro 9:10\r\n28/feb/13 promocion catiodermia gladys entro 9:25\r\n4/abril/13 promocion porcelana gladys entro 1:50\r\n25/junio/13 delineado de cejas, se le dio $100.00 pesos a ofelia\r\n09/julio/2013 retoque de cejas se le dio $100.00 pesos a ofelia\r\n09/julio/2013 promocion de elastina y colageno atendio ofelia \r\n5/septiembre/13 promocion de liftin antiarrugas atendio gladys entro 3:00\r\n04/12/13 promocion del mes diciembre atendio mirena mega entro 6:15\r\n27/feb/14 promocion eternamente joven nelli entro 1:25\r\n15/mayo/14 promocion facial hidratante carmen entro 12:45\r\n30/05/14 lim facial 2x1 anita mega 1:40 firmo autorización para realizar extraccion profunda\r\n26/junio/14 promocion de antioxidante mariana entro 4:35\r\n17/julio/14 promocion de colageno mirena entro 5:35\r\n8/agosto/14 limpieza de acne carmen entro 5:05\r\n11/sept/14 promocion trat. facial azteca brenda entro 9:10\r\n2/oct/14 promocion trat smoothie brenda entro 9:25\r\n23/oct/14 mdm cliente frecuente maribel entro 4:00\r\n28/nov/14 limpieza facial candy entro 2:39 (mega)\r\n9/ene/15 promocion desintoxicante y oxigenante mirena entro 9:25\r\n30/enero/15 promoción trat desintoxicante y oxigenante mirena entro 12.10\r\n19/marzo/15 mdm full relax (cliente frecuente) promocion tratamiento anti-edad lucero entro 12:50\r\n9/julio/15 promocion trat de cuello eva entro 10:30\r\n27/nov/15 promocion antiedad humectante y nutritivo graciela entro 12.50\r\n17/dic/15 promocion reafirmante modeladora mary lazaro entro 9:10\r\n11/feb/16 promocion roll & lift mary lazaro entro 11:00\r\n17/marzo/16 promocion hidrante  y dep de axila mary lazaro entro 11:05\r\n6/mayo/16 promocion trat de colageno ofelia entro 11.25\r\n27/mayo/16 mdm holístico y facial con lifting#2 lizvet entro 1:25\r\n7/julio/16 promocion de colageno mariaa entro 11:30\r\n19/julio/16 masaje full relax (cliente frecuente) mary lazaor entro 1:15\r\n18/agosto/16 promocion trat de caviar carmen entro 3:55\r\n9/dic/16 promocion trat multivitaminico andrea entro 10.30\r\n18/ene/17 promoción desintoxicante ofelia entro 9:05\r\n17/marzo/17 promocion estimulante de colageno por leeds carmen entro 11:05\r\n26/mayo/17 promocion antiedad con lifting carmen entro 5:40\r\n20/julio/17 promocion trat relajante e hidratante monica entro 2:30\r\n2/oct/17 promocion reafirmante mariana entro 10:50\r\n23/nov/17 promocion termico humectante mariana entro 10:30\r\n13/dic/17 promocion trat gold anita entro 9:40\r\n19/12/17 MDM CLIENTE FRECUENTE CHARITO ENTRO 2:30\r\n13/FEB/18 PROM TRATAMIENTO MULTIVITAMÍNICO MARIANA ENTRO 10:20\r\n22/MARZO/18 PROM TRATAMIENTO DE CATIODERMIA REYNA ENTRO 1:10\r\n23/ABRIL/18 INICIA TRATAMIENTO CORPORAL DE MASAJE Y CAVITACION COSTO 4,000 PAGADO CON MEDIDAS  CINTURA -OMBLIGO 93 PESO 79 1/2\r\n1.- CAVITACION 60, MASAJE 45  23/ABRIL/18 LUCY\r\n2.- CARBOX, MASAJE   24/ABRIL/18 LUPITA ENTRO 10:30\r\n25/ABRIL/18     PROM TRATAMIENTO HUMECTANTE Y REVITALIZANTE LUPITA  \r\n3.- MASAJE    25/ABRIL/18 LUPITA ENTRO  10:30\r\n4.- CAVITACION 60, MASAJE 45 26/ABRIL/18\r\n5.- MASAJE 45 28/ABRIL/18 LUPITA  ENTRO 8:55\r\n6.- MASAJE 45    29/ABRIL/18 LUPITA\r\n7.- CAVITACION 60, MASAJE 45 3/SEP/18  REYNA ENTRO 9:30\r\n8.- CARB, MASAJE 45 4/SEPT/18 LINDA ENTRO 11:30\r\n9.- MASAJE 5/SEPT/18 LINDA ENTRO 9:20\r\n10.- CAVT 60, MASAJE 45 6/SEPT/18 LINDA ENTRO 9:20\r\nTERMINO TRATAMIENTO\r\n30/AGOSTO/18 PROM TRATAMIENTO FACIAL HUMECTANTE MONICA ENTRO 9:15\r\n13/SEPT/18 MDM FULL RELAX CLIENTE FRECUENTE OFELIA ENTRO 9:15\r\n13/SEP/18 10 DISPAROS DE LIPOSONIX  OFELIA\r\n28/NOV/18 PROM TRATAMIENTO FACIAL DE POLUCIÓN MONICA-KARLA ENTRO 9:45 SALIO 11:00\r\n28/NOV/18 LLEVO HELIOCARE Y EXCEL THERAPY  POLLUTION DEFENSE O2\r\n28/ENERO/19 PROMOCION REVITALIZANTE LUCY ENTRO 12:10\r\n5/MARZO/19 PROM TRATAMIENTO FACIAL DETOX  LUPITA ENTRO 11:35\r\n16/ABRIL/19 PROM TRATAMIENTO FACIAL HUEMECTANTE  MARY\r\n16/ABRIL/19 DELINEADO DE CEJAS  OFELIA ENTRO 1:00\r\n7/MAYO/19 PROM TRATAMIENTO EFECTO BOTOX REYNA\r\n29/MAYO/19 RETOQUE DE CEJAS OFELIA\r\n12/JUNIO/19 PROMOCION REVOLUCIONARIO ANTIEDAD MARY CARMEN ENTRO 10:15\r\n4/SEP/19 PROMOCION OXIGENANTE MARY LAZARO ENTRO 11:20 LLEVO B-CALM CREMA HIDRATANTE FUNDAMENTAL LIGERA, CONTORNO DE OJOS EXCEL THERAPY POLLUTION DEFENSE\r\n31/OCT/19 PROMOCION DOBLE ACCION REYNA ENTRO 9:10 LLEVO FILTRO SOLAR NATURA BISSE\r\n4/DIC/19 PROMOCION TRAT 24 K REYNA ENTRO 9:30\r\n16/DICIEMBRE/19 MDM FULL RELAX DE CLIENTE FRECUENTE MILI ENTRO 5:05\r\n18/ENERO/20 TRATAMIENTO FACIAL DESINTOXICANTE MILI\r\n24/JULIO/2020 TRATAMIENTO FACIAL ANTIEDAD A BASE DE ALGAS Y DEPILACION DE CEJAS LUCY ENTRO 1:55 LLEVO ESSENTIAL SCHOK CONTORNO OJOS DE NATURA BISSE\r\n2/SEPT/2020 PROMOCION TRAT REVITALIZANTE, LIFTING DE COLAGENO OFELIA ENTRO 1:00 LLEVO SERUM INTENSIVO TIMEXPERT WHITE\r\n20/OCTUBRE/2020 TRATAMIENTO FACIAL GOLD REGENERANTE CON AMP ESTABALZING DE NATURA BISSE OFELIA ENTRO 5:30 LLEVO CREMA Y SERUM DE TIMEX