<?php
/**
 * Script de diagnóstico para verificar la conexión a la base de datos
 * Ejecutar con: docker-compose exec app php verificar_db.php
 */

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== DIAGNÓSTICO DE BASE DE DATOS ===\n\n";

// Información de conexión
$config = config('database.connections.mysql');
echo "📊 Configuración de Laravel:\n";
echo "   Host: " . $config['host'] . "\n";
echo "   Database: " . $config['database'] . "\n";
echo "   Username: " . $config['username'] . "\n";
echo "   Port: " . $config['port'] . "\n\n";

// Verificar conexión
try {
    $pdo = new PDO(
        "mysql:host={$config['host']};port={$config['port']};dbname={$config['database']}",
        $config['username'],
        $config['password']
    );
    echo "✅ Conexión exitosa a la base de datos\n\n";
} catch (PDOException $e) {
    echo "❌ Error de conexión: " . $e->getMessage() . "\n\n";
    exit(1);
}

// Verificar si la tabla productos existe
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'productos'");
    $tableExists = $stmt->rowCount() > 0;
    
    if ($tableExists) {
        echo "✅ La tabla 'productos' existe\n\n";
        
        // Verificar columnas
        echo "📋 Columnas de la tabla 'productos':\n";
        $stmt = $pdo->query("DESCRIBE productos");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $hasTipoProductoId = false;
        $hasTipoServicioId = false;
        
        foreach ($columns as $column) {
            echo "   - " . $column['Field'] . " (" . $column['Type'] . ")\n";
            if ($column['Field'] === 'tipo_producto_id') {
                $hasTipoProductoId = true;
            }
            if ($column['Field'] === 'tipo_servicio_id') {
                $hasTipoServicioId = true;
            }
        }
        
        echo "\n";
        
        if (!$hasTipoProductoId) {
            echo "❌ La columna 'tipo_producto_id' NO existe en la base de datos\n";
            echo "   Necesitas agregarla con:\n";
            echo "   ALTER TABLE productos ADD COLUMN tipo_producto_id INT(11) NULL AFTER estatus;\n\n";
        } else {
            echo "✅ La columna 'tipo_producto_id' existe\n\n";
        }
        
        if (!$hasTipoServicioId) {
            echo "⚠️  La columna 'tipo_servicio_id' NO existe en la base de datos\n";
        } else {
            echo "✅ La columna 'tipo_servicio_id' existe\n\n";
        }
        
    } else {
        echo "❌ La tabla 'productos' NO existe en la base de datos\n\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Error al verificar tabla: " . $e->getMessage() . "\n\n";
}

echo "\n=== FIN DEL DIAGNÓSTICO ===\n";

