<?php

use App\Http\Controllers\InventarioController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\CorteCajaController;
use App\Http\Controllers\DatoFiscalController;
use App\Http\Controllers\ExpedienteController;
use App\Http\Controllers\HorarioController;
use App\Http\Controllers\IngresoMercanciaController;
use App\Http\Controllers\ProductoBajaController;
use App\Http\Controllers\MarcaController;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SesionController;
use App\Http\Controllers\SucursalController;
use App\Http\Controllers\TiendaController;
use App\Http\Controllers\TipoBajaController;
use App\Http\Controllers\TipoPagoController;
use App\Http\Controllers\TipoProductoController;
use App\Http\Controllers\TipoServicioController;
use App\Http\Controllers\TipoTratamientoController;
use App\Http\Controllers\TokenController;
use App\Http\Controllers\TratamientoController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ValeController;
use App\Http\Controllers\VentaController;
use App\Models\TipoServicio;
use App\Http\Controllers\DireccionEntregaController;
use App\Http\Controllers\BancoController;
use App\Http\Controllers\OpcionPagoTransferenciaController;
use App\Http\Controllers\EnvioController;
use App\Http\Controllers\ConfigImpresionController;
use App\Http\Controllers\ConfigCorreoController;
use App\Http\Controllers\ImprimirTicketController;
use App\Http\Controllers\ImprimirValeController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::post('/registro', [UserController::class, 'registro']);
Route::get('/sesiones/monitor', [SesionController::class, 'monitor']);
Route::post('/productos/page', [ProductoController::class, 'paginacion']);
Route::post('/marcas/all', [MarcaController::class, 'index']);
Route::post('/tipos-servicios/all', [TipoServicioController::class, 'index']);
Route::post('/tipos-productos/all', [TipoProductoController::class, 'index']);

Route::get('/storage-link', function () {
    Artisan::call('storage:link');
    return response()->json([
        'success' => true,
        'message' => 'The links have been created.',
        'output' => trim(Artisan::output()),
    ]);
});

Route::get('/config-correos/enviar-prueba', [ConfigCorreoController::class, 'enviarPrueba']);
Route::post('/config-correos/enviar-ejemplo-template', [ConfigCorreoController::class, 'enviarEjemploTemplate']);
Route::get('/config-correos/logo-url', [ConfigCorreoController::class, 'getLogoUrl']);
Route::get('/printers', [ConfigCorreoController::class, 'obtenerImpresoras']);

Route::prefix('/tokens')->group(function (): void {
    Route::post('/create', [TokenController::class, 'createToken']);
    Route::post('/pw', [TokenController::class, 'createResetPW']);
    Route::post('/savepw', [TokenController::class, 'saveResetPW']);
    Route::post('/getpwuuid', [TokenController::class, 'getUserUuid']);
});

Route::middleware('auth:sanctum')->group(function () {

    Route::get('/prueba', [SesionController::class, 'prueba']);
    Route::prefix('/tokens')->group(function (): void {
        Route::delete('/{token}', [TokenController::class, 'expire']);
        Route::get('/permissions', function () {
            return auth()->check()?auth()->user()->jsPermissions():0;
        });
    });

    Route::prefix('/users')->group(function (): void {
        Route::get('/cliente/publico', fn () => \App\Models\User::clientePublico());
        Route::get('/', fn (Request $request) => $request->user()->load('roles','cliente',"tiendas",'cliente.direcciones','cliente.fiscales'));
        Route::get('/all', [UserController::class, 'getUsers']);
        Route::get('/{user}', [UserController::class, 'getUser']);
        Route::post('/create', [UserController::class, 'store']);
        Route::put('/{user}/edit', [UserController::class, 'update']);
        Route::put('/{user}/password', [UserController::class, 'updatePassword']);
        Route::get('/{user}/mediciones', [UserController::class, 'getMediciones']);
        Route::get('/{user}/sucursales', [UserController::class, 'getSucursales']);
        Route::put('/perfil', [UserController::class, 'updatePerfil']);
        Route::get('/config/setconfig', [UserController::class, 'setConfigSucursal']);
        Route::get('/config/sucursal', [UserController::class, 'getConfigSucursal']);
        Route::get('/get/terapista', [UserController::class, 'getTerapistas']);
        Route::get('/get/administrador', [UserController::class, 'getAdministradores']);
        Route::get('/get/revision', [UserController::class, 'getRevision']);
        Route::delete('/{user}', [UserController::class, 'destroy']);
    });

    Route::prefix('/clientes')->group(function (): void {
        Route::post('/all', [ClienteController::class, 'index']);
        Route::post('/create', [ClienteController::class, 'store']);
        Route::post('/search', [ClienteController::class, 'search']);
        Route::get('/{cliente}', [ClienteController::class, 'show']);
        Route::post('/{cliente}/expedientes', [ClienteController::class, 'getExpedientes']);
        Route::put('/{cliente}/edit', [ClienteController::class, 'update']);
        Route::delete('/{cliente}', [ClienteController::class, 'destroy']);
    });

    Route::prefix('/expedientes')->group(function (): void {
        Route::post('/create', [ExpedienteController::class, 'store']);
        Route::get('/{expediente}', [ExpedienteController::class, 'show']);
        Route::put('/{expediente}/edit', [ExpedienteController::class, 'update']);
        Route::delete('/{expediente}', [ExpedienteController::class, 'destroy']);
    });

    Route::prefix('/sucursales')->group(function (): void {
        Route::get('/all', [SucursalController::class, 'index']);
        Route::get('/index', [SucursalController::class, 'all']);
        Route::post('/create', [SucursalController::class, 'store']);
        Route::get('/{sucursal}', [SucursalController::class, 'show']);
        Route::put('/{sucursal}/edit', [SucursalController::class, 'update']);
        Route::delete('/{sucursal}', [SucursalController::class, 'destroy']);
    });

    Route::prefix('/horarios')->group(function (): void {
        Route::get('/all', [HorarioController::class, 'index']);
        Route::post('/create', [HorarioController::class, 'store']);
        Route::post('/disponibles', [HorarioController::class, 'getDisponible']);
        Route::get('/{horario}', [HorarioController::class, 'show']);
        Route::put('/{horario}/edit', [HorarioController::class, 'update']);
        Route::get('/{sucursal}/dias', [HorarioController::class, 'getLlenarDias']);
        Route::delete('/{horario}', [HorarioController::class, 'destroy']);
    });

    Route::prefix('/tratamientos')->group(function (): void {
        Route::post('/all', [TratamientoController::class, 'index']);
        Route::post('/create', [TratamientoController::class, 'store']);
        Route::get('/{tratamiento}', [TratamientoController::class, 'show']);
        Route::put('/{tratamiento}/edit', [TratamientoController::class, 'update']);
        Route::delete('/{tratamiento}', [TratamientoController::class, 'destroy']);
    });

    Route::prefix('/tipos-tratamientos')->group(function (): void {
        Route::post('/all', [TipoTratamientoController::class, 'index']);
        Route::post('/create', [TipoTratamientoController::class, 'store']);
        Route::get('/{tipoTratamiento}', [TipoTratamientoController::class, 'show']);
        Route::put('/{tipoTratamiento}/edit', [TipoTratamientoController::class, 'update']);
        Route::delete('/{tipoTratamiento}', [TipoTratamientoController::class, 'destroy']);
    });

    Route::prefix('/productos')->group(function (): void {
        Route::post('/all', [ProductoController::class, 'index']);
        Route::post('/create', [ProductoController::class, 'store']);
        Route::get('/{producto}', [ProductoController::class, 'show']);
        Route::post('/{producto}/edit', [ProductoController::class, 'update']);
        Route::delete('/{producto}', [ProductoController::class, 'destroy']);
        Route::post('/{producto}/imprimir-codigo-barras', [ProductoController::class, 'imprimirCodigoBarras']);
        Route::post('/generar-codigo-barras-ean13', [ProductoController::class, 'generarCodigoBarrasEAN13']);
        Route::post('/verificar-codigo-barras', [ProductoController::class, 'verificarCodigoBarras']);
    });

    Route::prefix('/marcas')->group(function (): void {
        Route::post('/create', [MarcaController::class, 'store']);
        Route::get('/{marca}', [MarcaController::class, 'show']);
        Route::put('/{marca}/edit', [MarcaController::class, 'update']);
        Route::delete('/{marca}', [MarcaController::class, 'destroy']);
    });

    Route::prefix('/tipos-servicios')->group(function (): void {
        Route::post('/create', [TipoServicioController::class, 'store']);
        Route::get('/{tipoServicio}', [TipoServicioController::class, 'show']);
        Route::put('/{tipoServicio}/edit', [TipoServicioController::class, 'update']);
        Route::delete('/{tipoServicio}', [TipoServicioController::class, 'destroy']);
    });

    Route::prefix('/tipos-productos')->group(function (): void {
        Route::post('/create', [TipoProductoController::class, 'store']);
        Route::get('/{tipoProducto}', [TipoProductoController::class, 'show']);
        Route::put('/{tipoProducto}/edit', [TipoProductoController::class, 'update']);
        Route::delete('/{tipoProducto}', [TipoProductoController::class, 'destroy']);
    });

    Route::prefix('/sesiones')->group(function (): void {
        Route::post('/all', [SesionController::class, 'index']);
        Route::post('/fecha', [SesionController::class, 'fecha']);
        Route::post('/revision', [SesionController::class, 'getRevision']);
        Route::post('/search', [SesionController::class, 'search']);
        Route::post('/create', [SesionController::class, 'store']);
        Route::get('/{sesion}', [SesionController::class, 'show']);
        Route::post('/resumen/fecha', [SesionController::class, 'resumenFecha']);
        Route::post('/vale/token', [SesionController::class, 'verificarVales']);
        Route::put('/{sesion}/edit', [SesionController::class, 'update']);
        Route::delete('/{sesion}', [SesionController::class, 'destroy']);
    });

    Route::prefix('/roles')->group(function (): void {
        Route::get('/all', [RoleController::class, 'getRoles']);
    });

    Route::prefix('/tiendas')->group(function (): void {
        Route::get('/count', [TiendaController::class, 'count']);
        Route::get('/all', [TiendaController::class, 'index']);
        Route::get('/delete-by-user', [TiendaController::class, 'destroyByUser']);
        Route::post('/create', [TiendaController::class, 'store']);
        Route::post('/pagar', [TiendaController::class, 'pagar']);
        Route::post('/{venta}/comprobante', [TiendaController::class, 'updateComprobante']);
        Route::get('/{tienda}', [TiendaController::class, 'show']);
        Route::put('/{tienda}/edit', [TiendaController::class, 'update']);
        Route::delete('/{tienda}', [TiendaController::class, 'destroy']);
    });

    Route::prefix('/inventarios')->group(function (): void {
        Route::get('/all', [InventarioController::class, 'index']);
        Route::post('/page', [InventarioController::class, 'paginacion']);
        Route::post('/create', [InventarioController::class, 'store']);
        Route::get('/{inventario}', [InventarioController::class, 'show']);
        Route::put('/{inventario}/edit', [InventarioController::class, 'update']);
        Route::delete('/{inventario}', [InventarioController::class, 'destroy']);
    });

    Route::prefix('/ingresos-mercancias')->group(function (): void {
        Route::get('/all', [IngresoMercanciaController::class, 'index']);
        Route::post('/page', [IngresoMercanciaController::class, 'paginacion']);
        Route::post('/create', [IngresoMercanciaController::class, 'store']);
        Route::get('/{ingreso}', [IngresoMercanciaController::class, 'show']);
        Route::put('/{ingreso}/edit', [IngresoMercanciaController::class, 'update']);
        Route::delete('/{ingreso}', [IngresoMercanciaController::class, 'destroy']);
    });

    Route::prefix('/productos-bajas')->group(function (): void {
        Route::get('/all', [ProductoBajaController::class, 'index']);
        Route::post('/page', [ProductoBajaController::class, 'paginacion']);
        Route::post('/create', [ProductoBajaController::class, 'store']);
        Route::get('/{salida}', [ProductoBajaController::class, 'show']);
        Route::put('/{salida}/edit', [ProductoBajaController::class, 'update']);
        Route::delete('/{salida}', [ProductoBajaController::class, 'destroy']);
    });

    Route::prefix('/tipos-bajas')->group(function (): void {
        Route::get('/all', [TipoBajaController::class, 'index']);
    });

    Route::prefix('/tipos-pagos')->group(function (): void {
        Route::get('/all', [TipoPagoController::class, 'index']);
    });

    Route::prefix('/ventas')->group(function (): void {
        Route::get('/all', [VentaController::class, 'index']);
        Route::post('/mis-compras', [VentaController::class, 'misVentas']);
        Route::post('/page', [VentaController::class, 'paginacion']);
        Route::post('/create', [VentaController::class, 'store']);
        Route::get('/{venta}', [VentaController::class, 'show']);
        Route::put('/{venta}/canledado', [VentaController::class, 'canledado']);
        Route::post('/seed-ticket/{venta}', [VentaController::class, 'seedTicket']);
        Route::delete('/{venta}', [VentaController::class, 'destroy']);
        Route::post('/tienda/verificar', [VentaController::class, 'paginacionTiendaVerificar']);
        Route::put('/{venta}/autorizar', [VentaController::class, 'autorizar']);
    });

    Route::prefix('/cortes-cajas')->group(function (): void {
        Route::post('/page', [CorteCajaController::class, 'paginacion']);
        Route::post('/create', [CorteCajaController::class, 'store']);
        Route::post('/calcular-corte', [CorteCajaController::class, 'calculoCorte']);
        Route::get('/{corte}', [CorteCajaController::class, 'show']);
    });

    Route::prefix('/vales')->group(function (): void {
        Route::post('/page', [ValeController::class, 'paginacion']);
        Route::get('/{vale}', [ValeController::class, 'show']);
    });

    Route::prefix('/direcciones-entrega')->group(function (): void {
        Route::get('/all/{cliente}', [DireccionEntregaController::class, 'index']);
        Route::get('/for-select/{cliente}', [DireccionEntregaController::class, 'getForSelect']);
        Route::post('/create', [DireccionEntregaController::class, 'store']);
        Route::get('/{direccionEntrega}', [DireccionEntregaController::class, 'show']);
        Route::put('/{direccionEntrega}/edit', [DireccionEntregaController::class, 'update']);
        Route::delete('/{direccionEntrega}', [DireccionEntregaController::class, 'destroy']);
    });

    Route::prefix('/datos-fiscales')->group(function (): void {
        Route::get('/all/{cliente}', [DatoFiscalController::class, 'index']);
        Route::get('/for-select/{cliente}', [DatoFiscalController::class, 'getForSelect']);
        Route::post('/create', [DatoFiscalController::class, 'store']);
        Route::get('/{datoFiscal}', [DatoFiscalController::class, 'show']);
        Route::post('/{datoFiscal}/edit', [DatoFiscalController::class, 'update']);
        Route::delete('/{datoFiscal}', [DatoFiscalController::class, 'destroy']);
    });

    Route::prefix('/bancos')->group(function (): void {
        Route::get('/all', [BancoController::class, 'index']);
        Route::get('/for-select', [BancoController::class, 'getForSelect']);
        Route::post('/create', [BancoController::class, 'store']);
        Route::get('/{banco}', [BancoController::class, 'show']);
        Route::put('/{banco}/edit', [BancoController::class, 'update']);
        Route::delete('/{banco}', [BancoController::class, 'destroy']);
    });

    Route::prefix('/opciones-pago-transferencia')->group(function (): void {
        Route::get('/all', [OpcionPagoTransferenciaController::class, 'index']);
        Route::get('/for-select', [OpcionPagoTransferenciaController::class, 'getForSelect']);
        Route::get('/principal', [OpcionPagoTransferenciaController::class, 'principal']);
        Route::post('/create', [OpcionPagoTransferenciaController::class, 'store']);
        Route::get('/{opcion}', [OpcionPagoTransferenciaController::class, 'show']);
        Route::put('/{opcion}/edit', [OpcionPagoTransferenciaController::class, 'update']);
        Route::delete('/{opcion}', [OpcionPagoTransferenciaController::class, 'destroy']);
    });

    Route::prefix('/envios')->group(function (): void {
        Route::get('/all', [EnvioController::class, 'index']);
        Route::post('/create', [EnvioController::class, 'store']);
        Route::get('/{envio}', [EnvioController::class, 'show']);
        Route::put('/{envio}/edit', [EnvioController::class, 'update']);
        Route::delete('/{envio}', [EnvioController::class, 'destroy']);
        Route::get('/venta/{ventaId}', [EnvioController::class, 'getByVenta']);
    });

    Route::prefix('/config-impresiones')->group(function (): void {
        Route::get('/all', [ConfigImpresionController::class, 'index']);
        Route::get('/activa', [ConfigImpresionController::class, 'getActiva']);
        Route::get('/estilos/{id}', [ConfigImpresionController::class, 'getEstilos']);
        Route::get('/config-imprimir-directa', [ConfigImpresionController::class, 'getConfigImpresionDirecta']);
        Route::post('/create', [ConfigImpresionController::class, 'store']);
        Route::get('/{id}', [ConfigImpresionController::class, 'show']);
        Route::put('/{id}/edit', [ConfigImpresionController::class, 'update']);
        Route::delete('/{id}', [ConfigImpresionController::class, 'destroy']);
        Route::put('/{id}/activar', [ConfigImpresionController::class, 'activar']);
        Route::put('/{id}/predeterminada', [ConfigImpresionController::class, 'establecerPredeterminada']);
        Route::post('/{id}/duplicar', [ConfigImpresionController::class, 'duplicar']);
        Route::post('/{id}/enviar-prueba', [ConfigImpresionController::class, 'enviarPrueba']);
        Route::post('/{id}/enviar-prueba-vale', [ConfigImpresionController::class, 'enviarPruebaVale']);
        Route::post('/{id}/enviar-prueba-etiquetas', [ConfigImpresionController::class, 'enviarPruebaEtiquetas']);
        Route::post('/imprimir-ticket/{ventaId}', [ConfigImpresionController::class, 'imprimirTicket']);
        Route::post('/imprimir-vale/{valeId}', [ConfigImpresionController::class, 'imprimirVale']);
    });

    Route::prefix('/config-correos')->group(function (): void {
        Route::get('/all', [ConfigCorreoController::class, 'index']);
        Route::get('/activa', [ConfigCorreoController::class, 'getActiva']);
        Route::get('/modo-prueba', [ConfigCorreoController::class, 'getModoPrueba']);
        Route::post('/create', [ConfigCorreoController::class, 'store']);
        Route::get('/{id}', [ConfigCorreoController::class, 'show']);
        Route::put('/{id}/edit', [ConfigCorreoController::class, 'update']);
        Route::delete('/{id}', [ConfigCorreoController::class, 'destroy']);
        Route::put('/{id}/activar', [ConfigCorreoController::class, 'activar']);
        Route::put('/{id}/toggle-modo-prueba', [ConfigCorreoController::class, 'toggleModoPrueba']);
    });

    Route::prefix('/imprimir')->group(function (): void {
        Route::post('/ticket/{venta}', [ImprimirTicketController::class, 'imprimir']);
        Route::post('/vale/{vale}', [ImprimirValeController::class, 'imprimir']);
    });
});
