@extends('mails.layout')

@section('content')
    <h2>Nueva Solicitud de Cita</h2>
    <p>Se ha recibido una nueva solicitud de cita del cliente <strong>{{ $sesion->cliente->razonSocial }}</strong>.</p>
    
    <table class="data-table">
        <tr>
            <td>Folio:</td>
            <td><strong>#{{ $sesion->id }}</strong></td>
        </tr>
        <tr>
            <td>Cliente:</td>
            <td><strong>{{ $sesion->cliente->razonSocial }}</strong></td>
        </tr>
        <tr>
            <td>Correo electrónico:</td>
            <td>{{ $sesion->cliente->user->email }}</td>
        </tr>
        <tr>
            <td>Teléfono:</td>
            <td>{{ $sesion->cliente->celular }}</td>
        </tr>
        <tr>
            <td>Sucursal:</td>
            <td><strong>{{ $sesion->sucursal->nombre }}</strong></td>
        </tr>
        <tr>
            <td>Fecha y hora:</td>
            <td><strong>{{ \Carbon\Carbon::parse($sesion->fecha_asignada)->format('d/m/Y H:i') }}</strong></td>
        </tr>
    </table>

    <div class="info-box">
        <p><strong>📅 Acción Requerida</strong></p>
        <p>Por favor, revise la solicitud de cita en el sistema y proceda con la autorización correspondiente.</p>
    </div>

    <p>Por favor, acceda al sistema para revisar los detalles completos de la cita y proceder con la autorización.</p>
@endsection

@php
    $title = 'Nueva Solicitud de Cita - Notificación Administrativa';
    $headerTitle = 'Nueva Solicitud de Cita';
@endphp