@extends('mails.layout')

@section('content')
    <h2>Restablecimiento de Contraseña</h2>
    <p>Hola, <strong>{{ $user->name }}</strong>,</p>
    <p>Hemos recibido una solicitud para restablecer la contraseña de su cuenta el <strong>{{ \Carbon\Carbon::parse($user->updated_at)->format('d/m/Y H:i') }}</strong>.</p>
    
    <p>Para crear una nueva contraseña, haga clic en el botón a continuación:</p>
    
    <div style="text-align: center;">
        <a href="{{ env('MIX_URL') }}/auth/changepw/{{ $user->uuid }}" class="button">
            Restablecer Contraseña
        </a>
    </div>

    <div class="info-box">
        <p><strong>🔒 Importante:</strong></p>
        <ul>
            <li>Este enlace es válido por tiempo limitado.</li>
            <li>Si no solicitó este cambio, ignore este correo y su contraseña permanecerá sin cambios.</li>
            <li>Si recibió múltiples correos, utilice el enlace del último correo recibido.</li>
            <li>Por seguridad, no comparta este enlace con nadie.</li>
        </ul>
    </div>

    <p>Si tiene problemas para acceder al enlace, puede copiar y pegar la siguiente URL en su navegador:</p>
    <p style="word-break: break-all; color: #e8c39e font-size: 12px;">{{ env('MIX_URL') }}/auth/changepw/{{ $user->uuid }}</p>
    
    <p>Si no solicitó este cambio, puede ignorar este correo de forma segura.</p>
@endsection

@php
    $title = 'Restablecimiento de Contraseña - EGURROLA';
    $headerTitle = 'Restablecer Contraseña';
@endphp