# Documentación de Templates de Correo - EGURROLA

Este documento describe todos los templates de correo disponibles en el sistema y dónde se utilizan.

## 📧 Templates Disponibles

### 1. **aviso_nuevo_venta_confirmacion_cliente.blade.php**
**Descripción:** Notificación al cliente cuando su venta ha sido confirmada.

**Uso:**
- **Controlador:** `app/Http/Controllers/VentaController.php`
- **Método:** `autorizar()` (línea ~502)
- **Clase Mail:** `App\Mail\AvisoNuevoVentaConfirmacionCliente`
- **Cuándo se envía:** Cuando un administrador autoriza/confirma una venta

**Datos disponibles:**
- `$venta` - Objeto Venta con relaciones (cliente, etc.)

---

### 2. **aviso_nuevo_venta_cliente.blade.php**
**Descripción:** Notificación al cliente cuando se registra una nueva venta (pendiente de validación).

**Uso:**
- **Controlador:** `app/Http/Controllers/TiendaController.php`
- **Métodos:** `pagar()` (línea ~254) y método para actualizar comprobante (línea ~281)
- **Clase Mail:** `App\Mail\AvisoNuevoVentaCliente`
- **Cuándo se envía:** Cuando un cliente realiza una compra y se registra la venta

**Datos disponibles:**
- `$venta` - Objeto Venta con relaciones (cliente, etc.)

---

### 3. **aviso_nuevo_venta_admin.blade.php**
**Descripción:** Notificación al administrador cuando se registra una nueva venta.

**Uso:**
- **Controlador:** `app/Http/Controllers/TiendaController.php`
- **Métodos:** `pagar()` (línea ~253) y método para actualizar comprobante (línea ~280)
- **Clase Mail:** `App\Mail\AvisoNuevoVentaAdmin`
- **Cuándo se envía:** Cuando un cliente realiza una compra y se registra la venta

**Datos disponibles:**
- `$venta` - Objeto Venta con relaciones (cliente, etc.)

---

### 4. **aviso_nuevo_cliente.blade.php**
**Descripción:** Notificación al administrador cuando se registra un nuevo cliente.

**Uso:**
- **Controlador:** `app/Http/Controllers/UserController.php`
- **Método:** `registro()` (línea ~110)
- **Clase Mail:** `App\Mail\AvisoNuevoCliente`
- **Cuándo se envía:** Cuando un nuevo usuario se registra en el sistema

**Datos disponibles:**
- `$user` - Objeto User con datos del nuevo cliente

---

### 5. **aviso_nueva_cita.blade.php**
**Descripción:** Notificación al administrador cuando se solicita una nueva cita.

**Uso:**
- **Controlador:** `app/Http/Controllers/SesionController.php`
- **Método:** `store()` (línea ~338)
- **Clase Mail:** `App\Mail\AvisoNuevaCita`
- **Cuándo se envía:** Cuando un cliente crea una solicitud de cita

**Datos disponibles:**
- `$sesion` - Objeto Sesion con relaciones (cliente, sucursal, etc.)

---

### 6. **aviso_cambio_pw.blade.php**
**Descripción:** Correo para restablecer la contraseña del usuario.

**Uso:**
- **Controlador:** `app/Http/Controllers/TokenController.php`
- **Método:** `createResetPW()` (línea ~59)
- **Clase Mail:** `App\Mail\AvisoCambioPw`
- **Cuándo se envía:** Cuando un usuario solicita restablecer su contraseña

**Datos disponibles:**
- `$user` - Objeto User con UUID para el enlace de restablecimiento

**Nota:** Incluye un enlace para restablecer la contraseña usando `$user->uuid`

---

### 7. **aviso_activacion_cliente.blade.php**
**Descripción:** Notificación al cliente cuando su cuenta ha sido activada.

**Uso:**
- **Controlador:** `app/Http/Controllers/UserController.php`
- **Método:** `update()` (línea ~189)
- **Clase Mail:** `App\Mail\AvisoActivacionCliente`
- **Cuándo se envía:** Cuando un administrador activa la cuenta de un cliente

**Datos disponibles:**
- `$user` - Objeto User con datos del cliente activado

---

### 8. **aviso_activacion_cita.blade.php**
**Descripción:** Notificación al cliente cuando su cita ha sido autorizada.

**Uso:**
- **Controlador:** `app/Http/Controllers/SesionController.php`
- **Método:** `update()` (línea ~449)
- **Clase Mail:** `App\Mail\AvisoActivacionCita`
- **Cuándo se envía:** Cuando un administrador autoriza una cita solicitada

**Datos disponibles:**
- `$sesion` - Objeto Sesion con relaciones (cliente, sucursal, terapista, etc.)

---

### 9. **auto_aviso_nuevo_cliente.blade.php**
**Descripción:** Notificación automática al cliente cuando completa su registro (cuenta pendiente de activación).

**Uso:**
- **Controlador:** `app/Http/Controllers/UserController.php`
- **Método:** `registro()` (línea ~105-109)
- **Clase Mail:** `App\Mail\AutoAvisoNuevoCliente`
- **Cuándo se envía:** Automáticamente cuando un cliente completa su registro y su cuenta NO está activa

**Datos disponibles:**
- `$user` - Objeto User con datos del nuevo cliente

**Nota:** Se usa cuando `$user->tipo_cliente != 'cliente_linea'`

---

### 10. **auto_aviso_nuevo_cliente_local.blade.php**
**Descripción:** Notificación automática al cliente cuando completa su registro (cuenta activa inmediatamente).

**Uso:**
- **Controlador:** `app/Http/Controllers/UserController.php`
- **Método:** `registro()` (línea ~107)
- **Clase Mail:** `App\Mail\AutoAvisoNuevoClienteLocal`
- **Cuándo se envía:** Automáticamente cuando un cliente de tipo 'cliente_linea' completa su registro

**Datos disponibles:**
- `$user` - Objeto User con datos del nuevo cliente

**Nota:** Se usa cuando `$user->tipo_cliente == 'cliente_linea'`

---

### 11. **prueba_correo.blade.php**
**Descripción:** Template de correo de prueba para verificar la configuración de correo.

**Uso:**
- **Controlador:** `app/Http/Controllers/ConfigCorreoController.php`
- **Método:** `enviarPrueba()` (línea ~279)
- **Endpoint:** `POST /api/config-correos/enviar-prueba`
- **Cuándo se envía:** Cuando se solicita enviar un correo de prueba desde el sistema de configuración

**Datos disponibles:**
- `$configuracion` - Objeto ConfigCorreo con la configuración activa

---

## 🎨 Layout Base

Todos los templates de correo utilizan el layout base `mails.layout.blade.php` que proporciona:
- Diseño profesional y responsive
- Estilos consistentes
- Header con gradiente
- Footer con información de la empresa
- Estilos para tablas, botones e información destacada

## 📝 Notas Importantes

1. **Configuración de Correo:** Todos los correos utilizan el sistema de configuración de `ConfigCorreo` que permite:
   - Modo prueba: redirige todos los correos a un correo de prueba
   - Configuración activa: permite cambiar la configuración de correo en tiempo real

2. **Helper de Correo:** Se utiliza `App\Helpers\CorreoHelper` para obtener el correo de destino según la configuración activa.

3. **Formato de Fechas:** Se utiliza `Carbon` para formatear las fechas en formato español (d/m/Y H:i).

4. **Variables de Entorno:**
   - `MIX_URL`: URL del frontend para enlaces
   - `MIX_API_URL`: URL del API/backend
   - `MAIL_FROM_ADDRESS`: Correo del remitente por defecto

## 🔧 Endpoint de Prueba

**Endpoint:** `POST /api/config-correos/enviar-prueba`

**Autenticación:** Requerida (auth:sanctum)

**Respuesta exitosa:**
```json
{
    "success": true,
    "message": "Correo de prueba enviado exitosamente",
    "data": {
        "correo_destino": "correo@ejemplo.com",
        "configuracion": "Nombre de la configuración",
        "modo_prueba": true
    }
}
```

**Respuesta de error:**
```json
{
    "success": false,
    "message": "Error al enviar el correo de prueba",
    "error": "Mensaje de error detallado"
}
```

