import axios from "axios";
import router from "@/router";
const API_BASE_URI = process.env.MIX_API_URL;
const instance = axios.create({
  baseURL: API_BASE_URI,
});
instance.defaults.headers.post["Content-Type"] = "application/json";
instance.interceptors.request.use(
  (config) => {
    const token = window.localStorage.getItem("token");
    // if (!token) {
      // router.replace({ name: "login-route" });
    // }

    if (config.headers) config.headers["Authorization"] = `Bearer ${token}`;
    return config;
  },
  (error) => Promise.reject(error)
);
export default instance;
