import ApiService from "@/services/ApiService";

const baseUrl = "tipos-servicios";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const createServicio = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getServicioId = async (servicio_id) => {
  const response = await ApiService.get(`${baseUrl}/${servicio_id}`);
  return response.data;
};

export const updateServicio = async (params, servicio_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${servicio_id}/edit`,
    params
  );
  return response.data;
};

export const deleteServicio = async (servicio_id) => {
  const response = await ApiService.delete(`${baseUrl}/${servicio_id}`);
  return response.data;
};

