import ApiService from "@/services/ApiService";

const baseUrl = "tipos-productos";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const createProducto = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getProductoId = async (producto_id) => {
  const response = await ApiService.get(`${baseUrl}/${producto_id}`);
  return response.data;
};

export const updateProducto = async (params, producto_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${producto_id}/edit`,
    params
  );
  return response.data;
};

export const deleteProducto = async (producto_id) => {
  const response = await ApiService.delete(`${baseUrl}/${producto_id}`);
  return response.data;
};

