import ApiService from "@/services/ApiService";
import ApiServiceFile from "@/services/ApiServiceFile";

const baseUrl = "tiendas";

export const getAll = async ($params) => {
  const response = await ApiService.get(`${baseUrl}/all`,$params);
  return response.data;
};

export const getCount = async ($params) => {
  const response = await ApiService.get(`${baseUrl}/count`,$params);
  return response.data;
};

export const createTienda = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getTiendaId = async (tienda_id) => {
  const response = await ApiService.get(`${baseUrl}/${tienda_id}`);
  return response.data;
};

export const updateTienda = async (params, tienda_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${tienda_id}/edit`,
    params
  );
  return response.data;
};

export const deleteTienda = async (tienda_id) => {
  const response = await ApiService.delete(`${baseUrl}/${tienda_id}`);
  return response.data;
};

export const deleteByUserTienda = async () => {
  const response = await ApiService.get(`${baseUrl}/delete-by-user`);
  return response.data;
};

export const pagar = async (params) => {
  const response = await ApiServiceFile.post(`${baseUrl}/pagar`, params);
  return response.data;
};

export const updateComprobante = async (params, id) => {
  const response = await ApiServiceFile.post(`${baseUrl}/${id}/comprobante`, params);
  return response.data;
};

