import ApiService from "@/services/ApiService";

const baseUrl = "sesiones";

export const getAll = async (params) => {
  const response = await ApiService.post(`${baseUrl}/all`,params);
  return response.data;
};

export const createSesion = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getSesionId = async (sesion_id) => {
  const response = await ApiService.get(`${baseUrl}/${sesion_id}`);
  return response.data;
};

export const updateSesion = async (params, sesion_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${sesion_id}/edit`,
    params
  );
  return response.data;
};

export const deleteSesion = async (sesion_id) => {
  const response = await ApiService.delete(`${baseUrl}/${sesion_id}`);
  return response.data;
};

export const getSesionFecha = async (fecha,params) => {
  const response = await ApiService.post(`${baseUrl}/fecha?fecha=${fecha}`,params);
  return response.data;
};

export const getResumenFecha = async (fecha,params) => {
  const response = await ApiService.post(`${baseUrl}/resumen/fecha?fecha=${fecha}`,params);
  return response.data;
};

export const getMonitor = async (sucursal_id,fecha) => {
  const response = await ApiService.get(`${baseUrl}/monitor?sucursal_id=${sucursal_id}&fecha=${fecha}`);
  return response.data;
};

export const getRevision = async (params) => {
  const response = await ApiService.post(`${baseUrl}/revision`,params);
  return response.data;
};

export const getAllSearch = async (params) => {
  const response = await ApiService.post(`${baseUrl}/search`,params);
  return response.data;
};

export const getVerificarVale = async (params) => {
  const response = await ApiService.post(`${baseUrl}/vale/token`,params);
  return response.data;
};
