import ApiService from "@/services/ApiService";
import ApiServiceFile from "@/services/ApiServiceFile";

const baseUrl = "productos";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const getPage = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/page?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createProducto = async (params) => {
  const response = await ApiServiceFile.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getProductoId = async (producto_id) => {
  const response = await ApiService.get(`${baseUrl}/${producto_id}`);
  return response.data;
};

export const updateProducto = async (params, producto_id) => {
  const response = await ApiServiceFile.post(
    `${baseUrl}/${producto_id}/edit`,
    params
  );
  return response.data;
};

export const deleteProducto = async (producto_id) => {
  const response = await ApiService.delete(`${baseUrl}/${producto_id}`);
  return response.data;
};

export const imprimirCodigoBarras = async (producto_id, codigo_barras) => {
  const response = await ApiService.post(`${baseUrl}/${producto_id}/imprimir-codigo-barras`, {
    codigo_barras: codigo_barras
  });
  return response.data;
};

export const generarCodigoBarrasEAN13 = async () => {
  const response = await ApiService.post(`${baseUrl}/generar-codigo-barras-ean13`);
  return response.data;
};

export const verificarCodigoBarras = async (codigo_barras) => {
  const response = await ApiService.post(`${baseUrl}/verificar-codigo-barras`, {
    codigo_barras: codigo_barras
  });
  return response.data;
};
