import ApiService from "@/services/ApiService";

const baseUrl = "productos-bajas";

export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const getPage = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/page?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createProductoBaja = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getProductoBajaId = async (salida_id) => {
  const response = await ApiService.get(`${baseUrl}/${salida_id}`);
  return response.data;
};

export const updateProductoBaja = async (params, salida_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${salida_id}/edit`,
    params
  );
  return response.data;
};

export const deleteProductoBaja = async (salida_id) => {
  const response = await ApiService.delete(`${baseUrl}/${salida_id}`);
  return response.data;
};

