import ApiService from "@/services/ApiService";

const baseUrl = "expedientes";

export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const createExpediente = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getExpedienteId = async (expediente_id) => {
  const response = await ApiService.get(`${baseUrl}/${expediente_id}`);
  return response.data;
};

export const updateExpediente = async (params, expediente_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${expediente_id}/edit`,
    params
  );
  return response.data;
};

export const deleteExpediente = async (expediente_id) => {
  const response = await ApiService.delete(`${baseUrl}/${expediente_id}`);
  return response.data;
};
