import ApiService from "@/services/ApiService";
import ApiServiceFile from "@/services/ApiServiceFile";

const baseUrl = "datos-fiscales";

export const getPage = async (clienteId) => {
  const response = await ApiService.get(`${baseUrl}/all/${clienteId}`);
  return response.data;
};

export const createDatoFiscal = async (params) => {
  const response = await ApiServiceFile.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getDatoFiscalId = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const updateDatoFiscal = async (params, id) => {
  const response = await ApiServiceFile.post(`${baseUrl}/${id}/edit`, params);
  return response.data;
};

export const deleteDatoFiscal = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

export const getDatoFiscalForSelect = async (clienteId) => {
  const response = await ApiService.get(`${baseUrl}/for-select/${clienteId}`);
  return response.data;
};
