import ApiService from "@/services/ApiService";

const baseUrl = "cortes-cajas";

export const getPage = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/page?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createCorteCaja = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const calcularCorteCaja = async (params) => {
  const response = await ApiService.post(`${baseUrl}/calcular-corte`, params);
  return response.data;
};

export const getCorteCajaId = async (ingreso_id) => {
  const response = await ApiService.get(`${baseUrl}/${ingreso_id}`);
  return response.data;
};

