import ApiService from "@/services/ApiService";

const baseUrl = "config-correos";

/**
 * Obtener todas las configuraciones de correo
 */
export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

/**
 * Obtener la configuración activa
 */
export const getActiva = async () => {
  const response = await ApiService.get(`${baseUrl}/activa`);
  return response.data;
};

/**
 * Obtener el estado del modo prueba
 */
export const getModoPrueba = async () => {
  const response = await ApiService.get(`${baseUrl}/modo-prueba`);
  return response.data;
};

/**
 * Crear una nueva configuración
 */
export const create = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

/**
 * Obtener una configuración por ID
 */
export const getById = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

/**
 * Actualizar una configuración
 */
export const update = async (params, id) => {
  const response = await ApiService.put(`${baseUrl}/${id}/edit`, params);
  return response.data;
};

/**
 * Eliminar una configuración
 */
export const deleteConfig = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

/**
 * Activar una configuración
 */
export const activar = async (id) => {
  const response = await ApiService.put(`${baseUrl}/${id}/activar`);
  return response.data;
};

/**
 * Activar/Desactivar modo prueba
 */
export const toggleModoPrueba = async (id) => {
  const response = await ApiService.put(`${baseUrl}/${id}/toggle-modo-prueba`);
  return response.data;
};

/**
 * Enviar ejemplo de template de correo
 */
export const enviarEjemploTemplate = async (template) => {
  const response = await ApiService.post(`${baseUrl}/enviar-ejemplo-template`, {
    template: template
  });
  return response.data;
};

/**
 * Configuración por defecto en caso de error
 */
export const getConfiguracionPorDefecto = () => {
  return {
    id: 0,
    nombre: 'Configuración por Defecto',
    correo_prueba: 'deyvijesusgomezmoha@gmail.com',
    modo_prueba: true,
    es_activa: true
  };
};
