import ApiService from "@/services/ApiService";

const baseUrl = "clientes";

export const getAll = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/all?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createCliente = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getClienteId = async (cliente_id) => {
  const response = await ApiService.get(`${baseUrl}/${cliente_id}`);
  return response.data;
};

export const updateCliente = async (params, cliente_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${cliente_id}/edit`,
    params
  );
  return response.data;
};

export const deleteCliente = async (cliente_id) => {
  const response = await ApiService.delete(`${baseUrl}/${cliente_id}`);
  return response.data;
};

export const getExpedientes = async (cliente_id,params) => {
  const response = await ApiService.post(`${baseUrl}/${cliente_id}/expedientes`, params);
  return response.data;
};

export const getAllSearch = async (params) => {
  const response = await ApiService.post(`${baseUrl}/search`,params);
  return response.data;
};