import ApiService from "@/services/ApiService";

const baseUrl = "bancos";

export const getPage = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const createBanco = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getBancoId = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const updateBanco = async (params, id) => {
  const response = await ApiService.post(`${baseUrl}/${id}/edit`, params);
  return response.data;
};

export const deleteBanco = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

export const getBancoForSelect = async () => {
  const response = await ApiService.get(`${baseUrl}/for-select`);
  return response.data;
};
