import { createApp } from 'vue';
import { createPinia } from 'pinia';
import App from './App.vue';
import router from './router';
import store from './store';
import axios from "axios";
const app = createApp(App);

//pinia
const pinia = createPinia();

// bootstrap
import * as bootstrap from 'bootstrap';
window.bootstrap = bootstrap;

// modals
import '@/assets/sass/components/custom-modal.scss';

// perfect scrollbar
import PerfectScrollbar from 'vue3-perfect-scrollbar';
import 'vue3-perfect-scrollbar/dist/vue3-perfect-scrollbar.css';

//vue-meta
import { createHead } from '@vueuse/head';
const head = createHead();

//Sweetalert
import Swal from 'sweetalert2';
window.Swal = Swal;

// nouislider - later remove and add to page due to not working in page
import VueNouislider from 'vue3-nouislider';
import 'vue3-nouislider/dist/vue3-nouislider.css';

// vue input mask
import Maska from 'maska';

// smooth scroll
import { registerScrollSpy } from 'vue3-scroll-spy/dist/index';
registerScrollSpy(app, { offset: 118 });

//vue-i18n
import i18n from './i18n';

// datatables
import { ClientTable } from 'v-tables-3';

// json to excel
import vue3JsonExcel from 'vue3-json-excel';

//vue-wizard
import VueFormWizard from 'vue3-form-wizard';
import 'vue3-form-wizard/dist/style.css';
import * as AuthRepository from "@/repositories/AuthRepository";

const permisos = await AuthRepository.permissions();
window.Laravel.jsPermissions = permisos;
import LaravelPermissionToVueJS from 'laravel-permission-to-vuejs';

app.provide('$can', (value)=>{
    return window.Laravel.jsPermissions.permissions.includes(value);
});
app.provide('$is', (value)=>{
    return window.Laravel.jsPermissions.roles.includes(value);
});

app.provide('$isUserType', (value) => {
    return window.Laravel.jsPermissions.tipo_cliente === value;
});

// set default settings
import appSetting from './app-setting';
window.$appSetting = appSetting;
window.$appSetting.init();

app.use(pinia).use(store).use(router).use(i18n).use(PerfectScrollbar).use(VueNouislider).use(Maska).use(ClientTable).use(vue3JsonExcel).use(VueFormWizard).use(LaravelPermissionToVueJS).use(head).mount('#app');
