#!/bin/bash

# Script de configuración inicial del proyecto Docker

echo "🚀 Configurando proyecto Egurrola con Docker..."

# Levantar contenedores
echo "📦 Levantando contenedores..."
docker-compose up -d

# Esperar a que MySQL esté listo
echo "⏳ Esperando a que MySQL esté listo..."
sleep 10

# Instalar dependencias de Composer
echo "📥 Instalando dependencias de PHP (Composer)..."
docker-compose exec -T app composer install

# Instalar dependencias de NPM
echo "📥 Instalando dependencias de Node (NPM)..."
docker-compose exec -T node npm install

# Verificar si existe .env
if [ ! -f .env ]; then
    echo "📝 Creando archivo .env..."
    if [ -f .env.example ]; then
        docker-compose exec -T app cp .env.example .env
    else
        echo "⚠️  No se encontró .env.example, creando .env básico..."
        cat > .env << EOF
APP_NAME=Egurrola
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost:8000

DB_CONNECTION=mysql
DB_HOST=mysql
DB_PORT=3306
DB_DATABASE=egurrola
DB_USERNAME=egurrola_user
DB_PASSWORD=egurrola_password

CACHE_DRIVER=file
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120
EOF
    fi
fi

# Generar clave de aplicación
echo "🔑 Generando clave de aplicación..."
docker-compose exec -T app php artisan key:generate

# Configurar permisos
echo "🔐 Configurando permisos..."
docker-compose exec -T app chmod -R 775 storage bootstrap/cache
docker-compose exec -T app chown -R www-data:www-data storage bootstrap/cache

# Compilar assets
echo "🎨 Compilando assets..."
docker-compose exec -T node npm run dev

echo "✅ ¡Configuración completada!"
echo ""
echo "🌐 Accesos:"
echo "   - Aplicación: http://localhost:8080"
echo "   - phpMyAdmin: http://localhost:8081"
echo ""
echo "📝 Próximos pasos:"
echo "   1. Ejecuta las migraciones: docker-compose exec app php artisan migrate"
echo "   2. Si necesitas seeders: docker-compose exec app php artisan db:seed"


