@echo off
REM Script de configuración inicial del proyecto Docker (Windows)

echo 🚀 Configurando proyecto Egurrola con Docker...

REM Levantar contenedores
echo 📦 Levantando contenedores...
docker-compose up -d

REM Esperar a que MySQL esté listo
echo ⏳ Esperando a que MySQL esté listo...
timeout /t 10 /nobreak >nul

REM Instalar dependencias de Composer
echo 📥 Instalando dependencias de PHP (Composer)...
docker-compose exec -T app composer install

REM Instalar dependencias de NPM
echo 📥 Instalando dependencias de Node (NPM)...
docker-compose exec -T node npm install

REM Verificar si existe .env
if not exist .env (
    echo 📝 Creando archivo .env...
    if exist .env.example (
        docker-compose exec -T app cp .env.example .env
    ) else (
        echo ⚠️  No se encontró .env.example, creando .env básico...
        (
            echo APP_NAME=Egurrola
            echo APP_ENV=local
            echo APP_KEY=
            echo APP_DEBUG=true
            echo APP_URL=http://localhost:8080
            echo.
            echo DB_CONNECTION=mysql
            echo DB_HOST=mysql
            echo DB_PORT=3306
            echo DB_DATABASE=egurrola
            echo DB_USERNAME=egurrola_user
            echo DB_PASSWORD=egurrola_password
            echo.
            echo CACHE_DRIVER=file
            echo QUEUE_CONNECTION=sync
            echo SESSION_DRIVER=file
            echo SESSION_LIFETIME=120
        ) > .env
    )
)

REM Generar clave de aplicación
echo 🔑 Generando clave de aplicación...
docker-compose exec -T app php artisan key:generate

REM Configurar permisos
echo 🔐 Configurando permisos...
docker-compose exec -T app chmod -R 775 storage bootstrap/cache
docker-compose exec -T app chown -R www-data:www-data storage bootstrap/cache

REM Compilar assets
echo 🎨 Compilando assets...
docker-compose exec -T node npm run dev

echo.
echo ✅ ¡Configuración completada!
echo.
echo 🌐 Accesos:
echo    - Aplicación: http://localhost:8080
echo    - phpMyAdmin: http://localhost:8081
echo.
echo 📝 Próximos pasos:
echo    1. Ejecuta las migraciones: docker-compose exec app php artisan migrate
echo    2. Si necesitas seeders: docker-compose exec app php artisan db:seed
echo.
pause


