# Docker Setup - Proyecto Egurrola

Esta carpeta contiene toda la configuración de Docker para el proyecto Laravel/Vue.

## 🐳 Servicios Incluidos

- **PHP 8.1** con Composer y extensiones necesarias para Laravel
- **Node.js 18.17.1** para compilar assets de Vue
- **MySQL 8.0** compatible con PHP 8.1
- **Nginx** como servidor web
- **phpMyAdmin** para gestión de base de datos

## 📋 Requisitos Previos

- Docker instalado y funcionando
- Docker Compose instalado

## 🚀 Inicio Rápido

### 1. Levantar los contenedores

```bash
docker-compose up -d
```

Este comando creará y levantará todos los servicios en segundo plano.

### 2. Instalar dependencias de PHP

```bash
docker-compose exec app composer install
```

### 3. Instalar dependencias de Node

```bash
docker-compose exec node npm install
```

### 4. Configurar archivo .env

Si no tienes un archivo `.env`, copia el ejemplo:

```bash
docker-compose exec app cp .env.example .env
```

Luego edita el archivo `.env` con las siguientes credenciales de base de datos:

```env
DB_CONNECTION=mysql
DB_HOST=mysql
DB_PORT=3306
DB_DATABASE=egurrola
DB_USERNAME=egurrola_user
DB_PASSWORD=egurrola_password
```

### 5. Generar clave de aplicación

```bash
docker-compose exec app php artisan key:generate
```

### 6. Ejecutar migraciones

```bash
docker-compose exec app php artisan migrate
```

### 7. Compilar assets

Para desarrollo:
```bash
docker-compose exec node npm run dev
```

Para producción:
```bash
docker-compose exec node npm run production
```

Para watch (desarrollo con recarga automática):
```bash
docker-compose exec node npm run watch
```

## 🌐 Accesos

Una vez levantados los servicios, puedes acceder a:

- **Aplicación Laravel**: http://localhost:8080
- **phpMyAdmin**: http://localhost:8081
- **MySQL**: localhost:3307

### Credenciales de phpMyAdmin

- **Usuario**: root
- **Contraseña**: root_password

O puedes usar:

- **Usuario**: egurrola_user
- **Contraseña**: egurrola_password

## 📝 Comandos Útiles

### Ver logs de los servicios

```bash
# Todos los servicios
docker-compose logs -f

# Servicio específico
docker-compose logs -f app
docker-compose logs -f nginx
docker-compose logs -f mysql
docker-compose logs -f node
```

### Detener los contenedores

```bash
docker-compose stop
```

### Detener y eliminar contenedores

```bash
docker-compose down
```

### Detener y eliminar contenedores + volúmenes (⚠️ elimina la base de datos)

```bash
docker-compose down -v
```

### Reiniciar un servicio específico

```bash
docker-compose restart app
```

### Ejecutar comandos Artisan

```bash
docker-compose exec app php artisan [comando]
```

Ejemplos:
```bash
docker-compose exec app php artisan migrate
docker-compose exec app php artisan db:seed
docker-compose exec app php artisan cache:clear
docker-compose exec app php artisan config:clear
```

### Ejecutar comandos Composer

```bash
docker-compose exec app composer [comando]
```

Ejemplos:
```bash
docker-compose exec app composer install
docker-compose exec app composer update
docker-compose exec app composer require paquete/nombre
```

### Ejecutar comandos NPM

```bash
docker-compose exec node npm [comando]
```

Ejemplos:
```bash
docker-compose exec node npm install
docker-compose exec node npm run dev
docker-compose exec node npm run production
```

### Acceder al shell del contenedor PHP

```bash
docker-compose exec app bash
```

### Acceder al shell del contenedor Node

```bash
docker-compose exec node bash
```

### Acceder a MySQL desde línea de comandos

```bash
docker-compose exec mysql mysql -u egurrola_user -pegurrola_password egurrola
```

## 🔧 Configuración

### Cambiar puertos

Si necesitas cambiar los puertos, edita el archivo `docker-compose.yml` en la raíz del proyecto:

```yaml
nginx:
  ports:
    - "8080:80"  # Cambia 8080 por el puerto que desees

mysql:
  ports:
    - "3307:3306"  # Cambia 3307 por el puerto que desees

phpmyadmin:
  ports:
    - "8081:80"  # Cambia 8081 por el puerto que desees
```

### Cambiar credenciales de MySQL

Edita el archivo `docker-compose.yml` y modifica las variables de entorno del servicio `mysql`:

```yaml
mysql:
  environment:
    MYSQL_DATABASE: tu_base_de_datos
    MYSQL_USER: tu_usuario
    MYSQL_PASSWORD: tu_contraseña
    MYSQL_ROOT_PASSWORD: tu_root_password
```

**Importante**: También actualiza el archivo `.env` de Laravel con las mismas credenciales.

### Configuración de PHP

Puedes modificar `docker/php/php.ini` para ajustar la configuración de PHP según tus necesidades.

### Configuración de Nginx

Puedes modificar `docker/nginx/nginx.conf` para ajustar la configuración del servidor web.

## 🗂️ Estructura de Archivos

```
docker/
├── README.md           # Esta documentación
├── php/
│   ├── Dockerfile      # Imagen PHP 8.1 con Composer
│   └── php.ini         # Configuración de PHP
├── node/
│   └── Dockerfile      # Imagen Node 18.17.1
├── nginx/
│   └── nginx.conf      # Configuración de Nginx
└── mysql/
    └── my.cnf          # Configuración de MySQL
```

## 🐛 Solución de Problemas

### Error: "Port already in use"

Si algún puerto está en uso, cambia el puerto en `docker-compose.yml` o detén el servicio que lo está usando.

### Error: "Permission denied" en storage o bootstrap/cache

Ejecuta:

```bash
docker-compose exec app chmod -R 775 storage bootstrap/cache
docker-compose exec app chown -R www-data:www-data storage bootstrap/cache
```

### La aplicación no carga

1. Verifica que todos los contenedores estén corriendo: `docker-compose ps`
2. Revisa los logs: `docker-compose logs`
3. Verifica que el archivo `.env` esté configurado correctamente
4. Asegúrate de que los assets estén compilados: `docker-compose exec node npm run dev`

### Problemas con la base de datos

1. Verifica que el contenedor MySQL esté corriendo: `docker-compose ps mysql`
2. Revisa los logs: `docker-compose logs mysql`
3. Verifica las credenciales en `.env` coincidan con `docker-compose.yml`

### Limpiar todo y empezar de nuevo

```bash
# Detener y eliminar contenedores, redes y volúmenes
docker-compose down -v

# Eliminar imágenes (opcional)
docker-compose down --rmi all

# Volver a levantar
docker-compose up -d --build
```

## 📚 Recursos Adicionales

- [Documentación de Docker](https://docs.docker.com/)
- [Documentación de Docker Compose](https://docs.docker.com/compose/)
- [Documentación de Laravel](https://laravel.com/docs)
- [Documentación de Vue.js](https://vuejs.org/)

## 💡 Tips

- Usa `docker-compose exec` para ejecutar comandos dentro de los contenedores
- Los volúmenes persisten los datos incluso si detienes los contenedores
- Para desarrollo, usa `npm run watch` para compilación automática
- Revisa los logs regularmente para detectar problemas temprano


