# 🔌 Configuración de Conexión Navicat

## ⚠️ Importante: Puerto Correcto

El puerto de MySQL está mapeado a **3307** en tu máquina local, NO 3306.

## 📋 Configuración en Navicat

### Datos de Conexión:

- **Connection Name**: Egurrola (o el nombre que prefieras)
- **Host**: `localhost` o `127.0.0.1`
- **Port**: `3307` ⚠️ **IMPORTANTE: Usa el puerto 3307, no 3306**
- **User Name**: `root`
- **Password**: `root_password`

### O usando el usuario de la aplicación:

- **Host**: `localhost` o `127.0.0.1`
- **Port**: `3307`
- **User Name**: `egurrola_user`
- **Password**: `egurrola_password`
- **Database**: `egurrola`

## 🔧 Si no puedes conectarte

### 1. Verifica que el contenedor esté corriendo

```bash
docker-compose ps mysql
```

Deberías ver algo como:
```
egurrola_mysql   Up   0.0.0.0:3307->3306/tcp
```

### 2. Reinicia el contenedor MySQL

Si ya tenías el contenedor corriendo antes de estos cambios:

```bash
docker-compose restart mysql
```

O si necesitas recrearlo completamente (⚠️ esto eliminará los datos si no están en un volumen):

```bash
docker-compose down
docker-compose up -d mysql
```

### 3. Verifica los logs de MySQL

```bash
docker-compose logs mysql
```

### 4. Si el contenedor ya existía antes

Si el contenedor MySQL ya existía antes de agregar la configuración de `bind-address`, necesitas:

1. **Opción A: Recrear el contenedor** (si no tienes datos importantes):
   ```bash
   docker-compose down -v
   docker-compose up -d
   ```

2. **Opción B: Configurar manualmente** (si tienes datos importantes):
   ```bash
   # Conectarse al contenedor MySQL
   docker-compose exec mysql mysql -u root -proot_password
   
   # Dentro de MySQL, ejecutar:
   CREATE USER IF NOT EXISTS 'root'@'%' IDENTIFIED BY 'root_password';
   GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' WITH GRANT OPTION;
   FLUSH PRIVILEGES;
   ```

### 5. Verifica el firewall

Si estás en Windows, verifica que el puerto 3307 no esté bloqueado por el firewall.

### 6. Prueba la conexión desde la terminal

```bash
# Desde tu máquina (no dentro del contenedor)
mysql -h 127.0.0.1 -P 3307 -u root -proot_password
```

O usando Docker:

```bash
docker-compose exec mysql mysql -u root -proot_password -e "SELECT 1;"
```

## 🔍 Troubleshooting Avanzado

### Verificar que MySQL está escuchando en todas las interfaces

```bash
docker-compose exec mysql netstat -tlnp | grep 3306
```

Deberías ver algo como:
```
tcp        0      0 0.0.0.0:3306            0.0.0.0:*               LISTEN
```

### Verificar usuarios y permisos

```bash
docker-compose exec mysql mysql -u root -proot_password -e "SELECT user, host FROM mysql.user;"
```

Deberías ver usuarios con `%` (cualquier host) además de `localhost`.

## 📝 Notas

- El puerto **3307** es el puerto en tu máquina local
- El puerto **3306** es el puerto dentro del contenedor Docker
- Si cambias el puerto en `docker-compose.yml`, actualiza también Navicat
- La contraseña por defecto de root es `root_password` (cámbiala en producción)

