<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VentaDetalle extends Model
{
    use HasFactory;

    protected $table = 'ventas_detalles';

    protected $fillable = [
        'descripcion',
        'venta_id',
        'producto_id',
        'tratamiento_id',
        'vale_id',
        'total',
        'subtotal',
        'precio_unitario',
        'cantidad',
        'iva',
        'ieps',
        'estatus',
        'cancelado',
        'fecha_registro',
    ];

    public function producto(): BelongsTo
    {
        return $this->belongsTo(Producto::class, 'producto_id');
    }

    public function tratamiento(): BelongsTo
    {
        return $this->belongsTo(Tratamiento::class,'tratamiento_id');
    }

    public function vale(): BelongsTo
    {
        return $this->belongsTo(Vale::class,'vale_id');
    }

    public function venta(): BelongsTo
    {
        return $this->belongsTo(Venta::class,'venta_id');
    }
}
