<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VentaCorte extends Model
{
    use HasFactory;

    protected $table = 'ventas_cortes';

    protected $fillable = [
        'venta_id',
        'corte_caja_id',
    ];

    public function corteCaja(): BelongsTo
    {
        return $this->belongsTo(CorteCaja::class,'corte_caja_id');
    }

    public function venta(): BelongsTo
    {
        // ayudame agregar esto
        // ->selectRaw("
        //     date_format(ventas.fecha_registro,'%d-%m-%Y %l %p') fecha_asignada_custom
        // ")
        return $this->belongsTo(Venta::class,'venta_id')->selectRaw("
            ventas.*,
            date_format(ventas.fecha_registro,'%d-%m-%Y %l %p') fecha_asignada_custom
        ");
    }
}
