<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserSucursal extends Model
{
    use HasFactory;

    protected $table = 'users_sucursales';

    protected $fillable = [
        'user_id',
        'surcursal_id'
    ];

    public function sucursal(): BelongsTo
    {
        return $this->belongsTo(Sucursal::class,'sucursal_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class,'user_id');
    }
}
