<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Tratamiento extends Model
{
    use HasFactory;

    protected $table = 'tratamientos';

    protected $fillable = [
        'tratamiento',
        'precio',
        'tiene_iva',
        'iva',
        'tiene_ieps',
        'ieps',
        'desc_tratamiento',
        'estatus',
        'duracion',
        'tipo_tratamiento_id',
    ];

    public function sesionTratamiento(): HasMany
    {
        return $this->hasMany(SesionTratamiento::class, 'tratamiento_id');
    }

    public function tipoTratamiento(): BelongsTo
    {
        return $this->belongsTo(TipoTratamiento::class,'tipo_tratamiento_id');
    }

    public function ventasDetalles(): HasMany
    {
        return $this->hasMany(VentaDetalle::class, 'producto_id');
    }
}
