<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TipoTratamiento extends Model
{
    use HasFactory;

    protected $table = 'tipos_tratamientos';

    protected $fillable = [
        'desc_tipo_tratamiento',
        'estatus',
    ];

    public function tratamiento(): HasMany
    {
        return $this->hasMany(tratamiento::class, 'tipo_tratamiento_id');
    }
}
