<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TipoPago extends Model
{
    use HasFactory;

    protected $table = 'tipos_pagos';

    protected $fillable = [
        'descripcion',
    ];

    public function pagos(): HasMany
    {
        return $this->hasMany(Venta::class, 'tipo_pago_id');
    }
}
