<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Sucursal extends Model
{
    use HasFactory;

    protected $table = 'sucursales';

    protected $fillable = [
        'nombre',
        'correo',
        'direccion',
        'telefono',
        'estatus'
    ];

    public function expedientes(): HasMany
    {
        return $this->hasMany(Expediente::class, 'sucursal_id');
    }
    
    public function sesiones(): HasMany
    {
        return $this->hasMany(Sesion::class, 'sucursal_id');
    }

    public function horarios(): HasMany
    {
        return $this->hasMany(Horario::class, 'sucursal_id');
    }

    public function usersSucursales(): HasMany
    {
        return $this->hasMany(UserSucursal::class, 'sucursal_id');
    }

    public function inventarios(): HasMany
    {
        return $this->hasMany(Inventario::class, 'sucursal_id');
    }

    public function ingresosMercancias(): HasMany
    {
        return $this->hasMany(IngresoMercancia::class, 'sucursal_id');
    }

    public function productosBajas(): HasMany
    {
        return $this->hasMany(ProductoBaja::class, 'sucursal_id');
    }

    public function ventas(): HasMany
    {
        return $this->hasMany(Venta::class, 'sucursal_id');
    }

    public function cortesCajas(): HasMany
    {
        return $this->hasMany(CorteCaja::class, 'sucursal_id');
    }
}
