<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Sesion extends Model
{
    use HasFactory;

    protected $table = 'sesiones';

    protected $fillable = [
        'sucursal_id',
        'cliente_id',
        'terapista_id',
        'duracion',
        'fecha_asignada',
        'observaciones',
        'observacion_cliente',
        'asistencia',
        'preferencia_terepista',
        'vale',
        'asistencia_cumplida',
        'usa_expediente',
        'aprobado',
        'vale_id',
    ];

    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class);
    }

    public function terapista(): BelongsTo
    {
        return $this->belongsTo(User::class, 'terapista_id');
    }

    public function sucursal(): BelongsTo
    {
        return $this->belongsTo(Sucursal::class, 'sucursal_id');
    }

    public function sesionTratamiento(): HasMany
    {
        return $this->hasMany(SesionTratamiento::class, 'sesion_id')
        ->leftjoin('tratamientos', 'sesiones_tratamientos.tratamiento_id', '=', 'tratamientos.id')
        ->selectRaw('
            tratamientos.id,
            tratamientos.tratamiento,
            tratamientos.duracion
        ');
    }

    public function sesionTratamientoPrecio(): HasMany
    {
        return $this->hasMany(SesionTratamiento::class, 'sesion_id')
        ->leftjoin('tratamientos', 'sesiones_tratamientos.tratamiento_id', '=', 'tratamientos.id')
        ->selectRaw('
            sesiones_tratamientos.*,
            tratamientos.tratamiento,
            tratamientos.precio,
            (tratamientos.iva/100) iva_def,
            (tratamientos.ieps/100) ieps_def,
            (tratamientos.precio*(tratamientos.iva/100)) iva,
            (tratamientos.precio + (tratamientos.precio*(tratamientos.iva/100))) total
        ')
        ->where(['estatus'=>'activo']);
    }

    public function sesionTratamientoPuro(): HasMany
    {
        return $this->hasMany(SesionTratamiento::class, 'sesion_id');
    }

    public function valesSesiones(): HasMany
    {
        return $this->hasMany(ValeSesion::class, 'sesion_id');
    }

    public function ventasSesiones(): HasMany
    {
        return $this->hasMany(VentaSesion::class, 'sesion_id');
    }
}
