<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Producto extends Model
{
    use HasFactory;

    protected $table = 'productos';

    protected $fillable = [
        'marca_id',
        'codigo_barras',
        'nombre',
        'nombre_corto',
        'descripcion',
        'precio',
        'tiene_iva',
        'iva',
        'tiene_ieps',
        'ieps',
        'estatus',
        'tipo_servicio_id',
        'tipo_producto_id',
        'path',
    ];

    public function marca(): BelongsTo
    {
        return $this->belongsTo(Marca::class,'marca_id');
    }

    public function tipoServicio(): BelongsTo
    {
        return $this->belongsTo(TipoServicio::class,'tipo_servicio_id');
    }

    public function tipoProducto(): BelongsTo
    {
        return $this->belongsTo(TipoProducto::class,'tipo_producto_id');
    }

    public function tiendas(): HasMany
    {
        return $this->hasMany(Tienda::class, 'producto_id');
    }

    public function inventarios(): HasMany
    {
        return $this->hasMany(Inventario::class, 'producto_id');
    }

    public function ingresosMercancias(): HasMany
    {
        return $this->hasMany(IngresoMercancia::class, 'producto_id');
    }

    public function productosBajas(): HasMany
    {
        return $this->hasMany(ProductoBaja::class, 'producto_id');
    }

    public function ventasDetalles(): HasMany
    {
        return $this->hasMany(VentaDetalle::class, 'producto_id');
    }
}
