<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Pago extends Model
{
    use HasFactory;

    protected $table = 'pagos';

    protected $fillable = [
        'venta_id',
        'tipo_pago_id',
        'banco',
        'folio_pago',
        'cambio',
        'pago',
        'total'
    ];

    public function venta(): HasMany
    {
        return $this->hasMany(Venta::class, 'venta_id');
    }

    public function tipoPago(): BelongsTo
    {
        return $this->belongsTo(TipoPago::class,'tipo_pago_id');
    }
}
