<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Envio extends Model
{
    use HasFactory;

    protected $table = 'envios';

    public $timestamps = false;

    protected $fillable = [
        'venta_id',
        'paqueteria',
        'numero_guia',
        'fecha_envio',
        'fecha_entrega_estimada',
        'estatus',
    ];

    public function venta(): BelongsTo
    {
        return $this->belongsTo(Venta::class, 'venta_id', 'id');
    }
}
