<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class DatoFiscal extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'datos_fiscales';

    protected $fillable = [
        'cliente_id',
        'rfc',
        'razon_social',
        'correo',
        'uso_cfdi',
        'regimen_fiscal',
        'metodo_pago',
        'calle',
        'numero_exterior',
        'numero_interior',
        'colonia',
        'codigo_postal',
        'ciudad',
        'estado',
        'pais',
        'documento_fiscal', // Para almacenar la ruta del documento
        'es_principal',
        'estatus'
    ];

    protected $appends = ['documento_fiscal_path'];

    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function getDocumentoFiscalPathAttribute()
    {
        return asset(str_replace("public", "storage", $this->documento_fiscal));
    }
}
