<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConfigCorreo extends Model
{
    use HasFactory;

    protected $table = 'config_correos';

    protected $fillable = [
        'nombre',
        'correo_prueba',
        'modo_prueba',
        'es_activa'
    ];

    protected $casts = [
        'modo_prueba' => 'boolean',
        'es_activa' => 'boolean',
    ];

    /**
     * Obtener la configuración activa de correo
     */
    public static function getConfigActiva()
    {
        return self::where('es_activa', true)->first();
    }

    /**
     * Obtener la configuración predeterminada de correo
     */
    public static function getConfigPredeterminada()
    {
        return self::where('es_predeterminada', true)->first();
    }

    /**
     * Activar esta configuración y desactivar las demás
     */
    public function activar()
    {
        // Desactivar todas las demás configuraciones
        self::where('id', '!=', $this->id)->update(['es_activa' => false]);
        
        // Activar esta configuración
        $this->update(['es_activa' => true]);
    }


    /**
     * Verificar si el modo prueba está activo
     */
    public static function modoPruebaActivo()
    {
        $config = self::getConfigActiva() ?? self::getConfigPredeterminada();
        return $config && $config->modo_prueba;
    }

    /**
     * Obtener el correo de prueba actual
     */
    public static function getCorreoPrueba()
    {
        $config = self::getConfigActiva() ?? self::getConfigPredeterminada();
        return $config ? $config->correo_prueba : null;
    }

    /**
     * Obtener configuración completa activa
     */
    public static function getConfiguracionActiva()
    {
        return self::getConfigActiva() ?? self::getConfigPredeterminada();
    }
}
