<?php

namespace App\Http\Controllers;

use App\Models\TipoTratamiento;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class TipoTratamientoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request): JsonResponse
    {
        $tipoTratamiento=TipoTratamiento::where(['estatus'=>'activo'])->get();
        return response()->json([
            'data' =>$tipoTratamiento
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'desc_tipo_tratamiento' => ['required', 'string'],
            'estatus' => ['required', 'string','max:10']
        ]);

        $tipoTratamiento = TipoTratamiento::create($request->only([
            'desc_tipo_tratamiento',
            'estatus',
        ]));

        return response()->json([
            'data' => $tipoTratamiento,
        ], JsonResponse::HTTP_OK);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(TipoTratamiento $tipoTratamiento): JsonResponse
    {
        return response()->json([
            'data' => $tipoTratamiento,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TipoTratamiento $tipoTratamiento): JsonResponse
    {
        $request->validate([
            'desc_tipo_tratamiento' => ['required', 'string'],
            'estatus' => ['required', 'string','max:10']
        ]);

        $tipoTratamiento->update($request->only([
            'desc_tipo_tratamiento',
            'estatus',
        ]));

        return response()->json([
            'data' => $tipoTratamiento,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(TipoTratamiento $tipoTratamiento): JsonResponse
    {
        if (\count($tipoTratamiento->tratamiento) > 0) {
            $tipoTratamiento->update([
                'estatus' => 'inactivo',
            ]);
        } else {
            $tipoTratamiento->delete();
        }

        return response()->json(null, JsonResponse::HTTP_NO_CONTENT);
    }
}
