import ApiService from "@/services/ApiService";

const baseUrl = "lavanderia/ordenes";

export const getAll = async (params = {}) => {
  const response = await ApiService.get(`${baseUrl}`, { params });
  return response.data;
};

export const createOrden = async (payload) => {
  const response = await ApiService.post(`${baseUrl}`, payload);
  return response.data;
};

export const avanzarOrden = async (id) => {
  const response = await ApiService.post(`${baseUrl}/${id}/avanzar`);
  return response.data;
};

export const marcarEntregada = async (id) => {
  const response = await ApiService.post(`${baseUrl}/${id}/entregar`);
  return response.data;
};

export const getById = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const getDashboardResumen = async () => {
  const response = await ApiService.get(`${baseUrl}/dashboard/resumen`);
  return response.data;
};

export const escanearQR = async (codigoQr) => {
  const response = await ApiService.post(`${baseUrl}/escanear-qr`, {
    codigo_qr: codigoQr,
  });
  return response.data;
};

export const escanearFolio = async (folioUnico) => {
  const response = await ApiService.post(`${baseUrl}/escanear-qr`, {
    folio_unico: folioUnico,
  });
  return response.data;
};
