<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     * 
     * Sistema de Control de Lavado - Tabla de órdenes de lavandería
     * Almacena toda la información de las órdenes: recepción, proceso y entrega
     */
    public function up(): void
    {
        Schema::create('ordenes_lavanderia', function (Blueprint $table): void {
            $table->id();
            $table->string('folio_unico', 100)->unique();
            $table->text('codigo_qr');

            $table->string('cliente_nombre', 255);
            $table->string('cliente_email', 255)->nullable();

            $table->string('tipo_servicio', 150);
            $table->text('detalles_ropa');
            $table->text('instrucciones')->nullable();

            $table->decimal('total', 10, 2)->default(0);

            $table->boolean('is_priority')->default(false);

            $table->enum('current_step', [
                'recepcion',
                'lavado',
                'secado',
                'planchado',
                'terminado',
                'entregado',
            ])->default('recepcion');

            $table->timestamp('current_step_started_at')->nullable();
            $table->timestamp('lavado_started_at')->nullable();
            $table->timestamp('secado_started_at')->nullable();
            $table->timestamp('planchado_started_at')->nullable();
            $table->timestamp('terminado_at')->nullable();
            $table->timestamp('entregado_at')->nullable();

            $table->enum('estatus', [
                'pendiente',
                'en_proceso',
                'terminado',
                'entregado',
                'cancelado',
            ])->default('pendiente');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ordenes_lavanderia');
    }
};

