<?php

namespace App\Repositories\Contracts;

use App\Models\OrdenLavanderia;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;

interface OrdenLavanderiaRepositoryInterface
{
    public function create(array $data): OrdenLavanderia;

    public function findById(int $id): ?OrdenLavanderia;

    public function findByFolio(string $folioUnico): ?OrdenLavanderia;

    public function update(OrdenLavanderia $orden, array $data): OrdenLavanderia;

    public function getPendientesEnProceso(): Collection;

    public function paginate(array $filters = [], int $perPage = 20): LengthAwarePaginator;
}

