<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenLavanderia extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'ordenes_lavanderia';

    protected $fillable = [
        'folio_unico',
        'codigo_qr',
        'cliente_nombre',
        'cliente_email',
        'tipo_servicio',
        'detalles_ropa',
        'instrucciones',
        'total',
        'is_priority',
        'current_step',
        'current_step_started_at',
        'lavado_started_at',
        'secado_started_at',
        'planchado_started_at',
        'terminado_at',
        'entregado_at',
        'estatus',
    ];

    protected $casts = [
        'is_priority' => 'boolean',
        'current_step_started_at' => 'datetime',
        'lavado_started_at' => 'datetime',
        'secado_started_at' => 'datetime',
        'planchado_started_at' => 'datetime',
        'terminado_at' => 'datetime',
        'entregado_at' => 'datetime',
    ];

    public const STEP_RECEPCION = 'recepcion';
    public const STEP_LAVADO = 'lavado';
    public const STEP_SECADO = 'secado';
    public const STEP_PLANCHADO = 'planchado';
    public const STEP_TERMINADO = 'terminado';
    public const STEP_ENTREGADO = 'entregado';

    public const ESTATUS_PENDIENTE = 'pendiente';
    public const ESTATUS_EN_PROCESO = 'en_proceso';
    public const ESTATUS_TERMINADO = 'terminado';
    public const ESTATUS_ENTREGADO = 'entregado';
    public const ESTATUS_CANCELADO = 'cancelado';
}

