<?php

namespace App\Mail;

use App\Models\OrdenLavanderia;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrdenLavanderiaListaCliente extends Mailable
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public readonly OrdenLavanderia $orden
    ) {
    }

    public function build(): self
    {
        return $this->subject('Tu ropa está lista - Orden #'.$this->orden->folio_unico)
            ->view('emails.ordenes.lista_cliente', [
                'orden' => $this->orden,
            ]);
    }
}

