<?php

namespace App\Mail;

use App\Models\OrdenLavanderia;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrdenLavanderiaCreadaAdmin extends Mailable
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public readonly OrdenLavanderia $orden
    ) {
    }

    public function build(): self
    {
        return $this->subject('Nueva orden de lavandería #'.$this->orden->folio_unico)
            ->view('emails.ordenes.creada_admin', [
                'orden' => $this->orden,
            ]);
    }
}

