<?php

namespace App\Listeners;

use App\Events\OrdenLavanderiaTerminada;
use App\Mail\OrdenLavanderiaListaCliente;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Mail;

class EnviarCorreoOrdenLavanderiaListaCliente implements ShouldQueue
{
    public function handle(OrdenLavanderiaTerminada $event): void
    {
        $email = $event->orden->cliente_email;

        if (!$email) {
            return;
        }

        Mail::to($email)->send(new OrdenLavanderiaListaCliente($event->orden));
    }
}

