<?php

namespace App\Listeners;

use App\Events\OrdenLavanderiaCreada;
use App\Mail\OrdenLavanderiaCreadaAdmin;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Mail;

class EnviarCorreoOrdenLavanderiaCreada implements ShouldQueue
{
    public function handle(OrdenLavanderiaCreada $event): void
    {
        $adminEmail = config('mail.from.address');

        if (!$adminEmail) {
            return;
        }

        Mail::to($adminEmail)->send(new OrdenLavanderiaCreadaAdmin($event->orden));
    }
}

